/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import java.util.Map;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project.LoadPlanable;
import net.sourceforge.plantuml.project.draw.TimeHeader;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.DayOfWeek;
import net.sourceforge.plantuml.project.time.MonthYear;
import net.sourceforge.plantuml.project.timescale.TimeScaleDaily;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class TimeHeaderDaily
extends TimeHeader {
    private final LoadPlanable defaultPlan;
    private final Map<Day, HColor> colorDays;
    private final Map<DayOfWeek, HColor> colorDaysOfWeek;
    private final Map<Day, String> nameDays;

    @Override
    protected double getTimeHeaderHeight() {
        return this.Y_POS_ROW28() + 13.0;
    }

    @Override
    public double getTimeFooterHeight() {
        return 38.0;
    }

    public TimeHeaderDaily(Day calendar, Day min, Day max, LoadPlanable defaultPlan, Map<Day, HColor> colorDays, Map<DayOfWeek, HColor> colorDaysOfWeek, Map<Day, String> nameDays, Day printStart, Day printEnd) {
        super(min, max, new TimeScaleDaily(calendar, printStart));
        this.defaultPlan = defaultPlan;
        this.colorDays = colorDays;
        this.colorDaysOfWeek = colorDaysOfWeek;
        this.nameDays = nameDays;
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawTextsBackground(ug, totalHeightWithoutFooter);
        this.drawTextsDayOfWeek(ug.apply(UTranslate.dy(this.Y_POS_ROW16())));
        this.drawTextDayOfMonth(ug.apply(UTranslate.dy(this.Y_POS_ROW28())));
        this.drawMonths(ug);
        this.drawVBars(ug, totalHeightWithoutFooter);
        this.drawVbar(ug, this.getTimeScale().getStartingPosition(this.max.increment()), 0.0, totalHeightWithoutFooter + this.getTimeFooterHeight());
        this.printNamedDays(ug);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, this.getFullHeaderHeight());
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        this.drawTextDayOfMonth(ug.apply(UTranslate.dy(12.0)));
        this.drawTextsDayOfWeek(ug);
        this.drawMonths(ug.apply(UTranslate.dy(24.0)));
        this.drawHline(ug, 0.0);
        this.drawHline(ug, this.getTimeFooterHeight());
    }

    private void drawTextsBackground(UGraphic ug, double totalHeightWithoutFooter) {
        double height = totalHeightWithoutFooter - this.getFullHeaderHeight();
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            double x2 = this.getTimeScale().getEndingPosition(wink);
            HColor back = this.colorDays.get(wink);
            HColor backDoW = this.colorDaysOfWeek.get((Object)wink.getDayOfWeek());
            if (backDoW != null) {
                back = backDoW;
            }
            if (back == null && this.defaultPlan.getLoadAt(wink) == 0) {
                back = this.veryLightGray;
            }
            if (back != null) {
                this.drawRectangle(ug.apply(back.bg()), height, x1 + 1.0, x2);
            }
            wink = wink.increment();
        }
    }

    private void drawTextsDayOfWeek(UGraphic ug) {
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            double x2 = this.getTimeScale().getEndingPosition(wink);
            HColor textColor = this.getTextBackColor(wink);
            this.printCentered(ug, this.getTextBlock(wink.getDayOfWeek().shortName(), 10, false, textColor), x1, x2);
            wink = wink.increment();
        }
    }

    private void drawTextDayOfMonth(UGraphic ug) {
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            double x2 = this.getTimeScale().getEndingPosition(wink);
            HColor textColor = this.getTextBackColor(wink);
            this.printCentered(ug, this.getTextBlock("" + wink.getDayOfMonth(), 10, false, textColor), x1, x2);
            wink = wink.increment();
        }
    }

    private HColor getTextBackColor(Day wink) {
        if (this.defaultPlan.getLoadAt(wink) <= 0) {
            return this.lightGray;
        }
        return HColorUtils.BLACK;
    }

    private void drawMonths(UGraphic ug) {
        MonthYear last = null;
        double lastChangeMonth = -1.0;
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            if (!wink.monthYear().equals(last)) {
                if (last != null) {
                    this.printMonth(ug, last, lastChangeMonth, x1);
                }
                lastChangeMonth = x1;
                last = wink.monthYear();
            }
            wink = wink.increment();
        }
        double x1 = this.getTimeScale().getStartingPosition(this.max.increment());
        if (x1 > lastChangeMonth) {
            this.printMonth(ug, last, lastChangeMonth, x1);
        }
    }

    private void drawVBars(UGraphic ug, double totalHeightWithoutFooter) {
        MonthYear last = null;
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            double startingY = this.getFullHeaderHeight();
            double len = totalHeightWithoutFooter;
            if (!wink.monthYear().equals(last)) {
                startingY = 0.0;
                last = wink.monthYear();
                len += 37.0;
            }
            this.drawVbar(ug, this.getTimeScale().getStartingPosition(wink), startingY, len);
            wink = wink.increment();
        }
    }

    private void printMonth(UGraphic ug, MonthYear monthYear, double start, double end) {
        TextBlock tiny = this.getTextBlock(monthYear.shortName(), 12, true, HColorUtils.BLACK);
        TextBlock small = this.getTextBlock(monthYear.longName(), 12, true, HColorUtils.BLACK);
        TextBlock big = this.getTextBlock(monthYear.longNameYYYY(), 12, true, HColorUtils.BLACK);
        this.printCentered(ug, start, end, tiny, small, big);
    }

    private void drawVbar(UGraphic ug, double x, double y1, double y2) {
        ULine vbar = ULine.vline(y2 - y1);
        ug.apply(HColorUtils.LIGHT_GRAY).apply(new UTranslate(x, y1)).draw(vbar);
    }

    private void printNamedDays(UGraphic ug) {
        if (this.nameDays.size() > 0) {
            String last = null;
            Day wink = this.min;
            while (wink.compareTo(this.max.increment()) <= 0) {
                String name = this.nameDays.get(wink);
                if (name != null && !name.equals(last)) {
                    double x1 = this.getTimeScale().getStartingPosition(wink);
                    double x2 = this.getTimeScale().getEndingPosition(wink);
                    TextBlock label = this.getTextBlock(name, 12, false, HColorUtils.BLACK);
                    double h = label.calculateDimension(ug.getStringBounder()).getHeight();
                    double y1 = this.getTimeHeaderHeight();
                    double y2 = this.getFullHeaderHeight();
                    label.drawU(ug.apply(new UTranslate(x1, this.Y_POS_ROW28() + 11.0)));
                }
                last = name;
                wink = wink.increment();
            }
        }
    }

    @Override
    public double getFullHeaderHeight() {
        return this.getTimeHeaderHeight() + this.getHeaderNameDayHeight();
    }

    private double getHeaderNameDayHeight() {
        if (this.nameDays.size() > 0) {
            return 16.0;
        }
        return 0.0;
    }
}

