/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.yaml;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.json.JsonArray;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.json.JsonValue;

public class SimpleYamlParser {
    private static final String KEY = "([_0-9\\w][- _0-9\\w]*)";
    private JsonObject result;
    private final List<Integer> pendingIndents = new ArrayList<Integer>();

    public JsonObject parse(List<String> lines) {
        List<String> tmp = new ArrayList<String>();
        for (String s : lines) {
            if (s.trim().length() == 0 || s.trim().startsWith("#")) continue;
            tmp.add(s);
        }
        tmp = this.mergeMultiline(tmp);
        this.result = new JsonObject();
        this.pendingIndents.clear();
        this.pendingIndents.add(0);
        for (String s : tmp) {
            this.parseSingleLine(s);
        }
        return this.result;
    }

    private List<String> mergeMultiline(List<String> tmp) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < tmp.size(); ++i) {
            if (this.nameOnly(tmp.get(i)) != null && this.textOnly(tmp.get(i + 1))) {
                StringBuilder sb = new StringBuilder(tmp.get(i));
                while (this.textOnly(tmp.get(i + 1))) {
                    sb.append(" " + tmp.get(i + 1).trim());
                    ++i;
                }
                result.add(sb.toString());
                continue;
            }
            result.add(tmp.get(i));
        }
        return result;
    }

    private String[] dashNameAndValue(String s) {
        Pattern p1 = Pattern.compile("^\\s*[-]\\s*([_0-9\\w][- _0-9\\w]*)\\s*:\\s*(\\S.*)$");
        Matcher m1 = p1.matcher(s);
        if (m1.matches()) {
            String name = m1.group(1);
            String data = m1.group(2).trim();
            return new String[]{name, data};
        }
        return null;
    }

    private String[] nameAndValue(String s) {
        Pattern p1 = Pattern.compile("^\\s*([_0-9\\w][- _0-9\\w]*)\\s*:\\s*(\\S.*)$");
        Matcher m1 = p1.matcher(s);
        if (m1.matches()) {
            String name = m1.group(1);
            String data = m1.group(2).trim();
            return new String[]{name, data};
        }
        return null;
    }

    private String nameOnly(String s) {
        Pattern p1 = Pattern.compile("^\\s*([_0-9\\w][- _0-9\\w]*)\\s*:\\s*\\|?\\s*$");
        Matcher m1 = p1.matcher(s);
        if (m1.matches()) {
            String name = m1.group(1);
            return name;
        }
        return null;
    }

    private String listedValue(String s) {
        Pattern p1 = Pattern.compile("^\\s*[-]\\s*(\\S.*)$");
        Matcher m1 = p1.matcher(s);
        if (m1.matches()) {
            String name = m1.group(1).trim();
            return name;
        }
        return null;
    }

    private boolean textOnly(String s) {
        if (this.isList(s)) {
            return false;
        }
        return s.indexOf(58) == -1;
    }

    private void parseSingleLine(String s) {
        int indent = this.getIndent(s);
        if (this.isListStrict(s)) {
            this.muteToArray(indent);
            return;
        }
        String[] dashNameAndValue = this.dashNameAndValue(s);
        if (dashNameAndValue != null) {
            this.muteToArray(indent);
            this.parseSingleLine(s.replaceFirst("[-]", " "));
            return;
        }
        String listedValue = this.listedValue(s);
        if (listedValue != null) {
            JsonArray array = this.getForceArray(indent);
            array.add(listedValue);
            return;
        }
        JsonObject working = this.getWorking(indent);
        if (working == null) {
            System.err.println("ERROR: ignoring " + s);
            return;
        }
        String[] nameAndValue = this.nameAndValue(s);
        if (nameAndValue != null) {
            String name = nameAndValue[0];
            String data = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(nameAndValue[1], "\"");
            working.add(name, data);
            return;
        }
        String nameOnly = this.nameOnly(s);
        if (nameOnly != null) {
            working.add(nameOnly, new JsonObject());
            return;
        }
        throw new UnsupportedOperationException(s);
    }

    private JsonArray getForceArray(int indent) {
        String field;
        while (this.getLastIndent() > indent - 1) {
            this.pendingIndents.remove(this.pendingIndents.size() - 1);
        }
        JsonObject last = SimpleYamlParser.search(this.result, this.pendingIndents.size());
        if (!(last.get(field = last.names().get(last.size() - 1)) instanceof JsonArray)) {
            last.set(field, new JsonArray());
        }
        return (JsonArray)last.get(field);
    }

    private void muteToArray(int indent) {
        String field;
        while (this.getLastIndent() > indent) {
            this.pendingIndents.remove(this.pendingIndents.size() - 1);
        }
        JsonObject last = SimpleYamlParser.search(this.result, this.pendingIndents.size());
        if (!(last.get(field = last.names().get(last.size() - 1)) instanceof JsonArray)) {
            last.set(field, new JsonArray());
        } else {
            ((JsonArray)last.get(field)).add(new JsonObject());
        }
    }

    private boolean isList(String s) {
        return s.trim().startsWith("-");
    }

    private boolean isListStrict(String s) {
        return s.trim().equals("-");
    }

    private int getLastIndent() {
        return this.pendingIndents.get(this.pendingIndents.size() - 1);
    }

    private JsonObject getWorking(int indent) {
        if (indent > this.getLastIndent()) {
            this.pendingIndents.add(indent);
            return SimpleYamlParser.search(this.result, this.pendingIndents.size());
        }
        if (indent == this.getLastIndent()) {
            return SimpleYamlParser.search(this.result, this.pendingIndents.size());
        }
        int idx = this.pendingIndents.indexOf(indent);
        if (idx == -1) {
            return null;
        }
        while (this.pendingIndents.size() > idx + 1) {
            this.pendingIndents.remove(this.pendingIndents.size() - 1);
        }
        return SimpleYamlParser.search(this.result, this.pendingIndents.size());
    }

    private static JsonObject search(JsonObject current, int size) {
        if (size <= 1) {
            return current;
        }
        String last = current.names().get(current.size() - 1);
        JsonValue tmp = current.get(last);
        if (tmp instanceof JsonArray) {
            JsonArray array = (JsonArray)tmp;
            if (array.size() == 0) {
                tmp = new JsonObject();
                array.add(tmp);
            } else {
                tmp = array.get(array.size() - 1);
            }
        }
        return SimpleYamlParser.search((JsonObject)tmp, size - 1);
    }

    private int getIndent(String s) {
        int indent = 0;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == ' ' || ch == '\t') {
                ++indent;
                continue;
            }
            return indent;
        }
        return 0;
    }
}

