/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.menus;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.ExtensionPopupMenu;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.AutoDetectSyntaxHttpPanelTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;

public class SyntaxMenu
extends ExtensionPopupMenu {
    private static final long serialVersionUID = 8472491919281117716L;
    private static final String MENU_LABEL = Constant.messages.getString("http.panel.view.syntaxtext.popup.syntax.label");
    private static final String AUTO_DETECT_SYNTAX_OPTION = Constant.messages.getString("http.panel.view.syntaxtext.popup.syntax.autoDetect");
    private JCheckBoxMenuItem autoDetectSyntax;
    private JPopupMenu.Separator autoDetectSyntaxSeparator;
    private ButtonGroup syntaxStylesButtonGroup = new ButtonGroup();
    private Map<String, JRadioButtonMenuItem> syntaxOptions = new HashMap<String, JRadioButtonMenuItem>();
    private JPopupMenu.Separator plainSyntaxSeparator;

    public SyntaxMenu() {
        super(MENU_LABEL);
        this.autoDetectSyntax = new JCheckBoxMenuItem(new ChangeAutoDetectSyntaxAction(AUTO_DETECT_SYNTAX_OPTION));
        this.add(this.autoDetectSyntax);
        this.autoDetectSyntaxSeparator = new JPopupMenu.Separator();
        this.add(this.autoDetectSyntaxSeparator);
        this.addSyntaxOption(HttpPanelSyntaxHighlightTextArea.PLAIN_SYNTAX_LABEL, "text/plain");
        this.syntaxOptions.get("text/plain").setSelected(true);
        this.plainSyntaxSeparator = new JPopupMenu.Separator();
        this.add(this.plainSyntaxSeparator);
    }

    @Override
    public boolean isEnableForComponent(Component invoker) {
        if (invoker instanceof HttpPanelSyntaxHighlightTextArea) {
            HttpPanelSyntaxHighlightTextArea httpPanelTextArea = (HttpPanelSyntaxHighlightTextArea)((Object)invoker);
            this.updateState(httpPanelTextArea);
            return true;
        }
        return false;
    }

    @Override
    public boolean precedeWithSeparator() {
        return true;
    }

    public void updateState(HttpPanelSyntaxHighlightTextArea httpPanelTextArea) {
        String style;
        JRadioButtonMenuItem radioButton;
        if (httpPanelTextArea instanceof AutoDetectSyntaxHttpPanelTextArea) {
            AutoDetectSyntaxHttpPanelTextArea textArea = (AutoDetectSyntaxHttpPanelTextArea)httpPanelTextArea;
            this.autoDetectSyntax.setSelected(textArea.isAutoDetectSyntax());
            this.autoDetectSyntax.setVisible(true);
            this.autoDetectSyntaxSeparator.setVisible(true);
        } else {
            this.autoDetectSyntax.setVisible(false);
            this.autoDetectSyntaxSeparator.setVisible(false);
        }
        Vector<HttpPanelSyntaxHighlightTextArea.SyntaxStyle> styles = httpPanelTextArea.getSyntaxStyles();
        boolean hasMultipleStyles = true;
        if (hasMultipleStyles && styles.size() == 1) {
            hasMultipleStyles = false;
        }
        this.plainSyntaxSeparator.setVisible(hasMultipleStyles);
        Iterator<JRadioButtonMenuItem> itSyntaxOptions = this.syntaxOptions.values().iterator();
        while (itSyntaxOptions.hasNext()) {
            itSyntaxOptions.next().setVisible(false);
        }
        this.syntaxOptions.get("text/plain").setVisible(true);
        if (hasMultipleStyles) {
            for (HttpPanelSyntaxHighlightTextArea.SyntaxStyle syntaxStyle : styles) {
                String styleKey = syntaxStyle.getStyleKey();
                radioButton = this.syntaxOptions.get(styleKey);
                if (radioButton != null) {
                    radioButton.setVisible(true);
                    continue;
                }
                this.addSyntaxOption(syntaxStyle.getLabel(), styleKey);
                this.syntaxOptions.get(styleKey).setVisible(true);
            }
        }
        if ((radioButton = this.syntaxOptions.get(style = httpPanelTextArea.getSyntaxEditingStyle())) != null) {
            radioButton.setSelected(true);
        } else if ("text/plain".equals(style)) {
            this.syntaxOptions.get("text/plain").setSelected(true);
        }
    }

    private void addSyntaxOption(String text, String styleKey) {
        JRadioButtonMenuItem syntaxOption = new JRadioButtonMenuItem(new ChangeSyntaxAction(text, styleKey));
        this.syntaxStylesButtonGroup.add(syntaxOption);
        this.add(syntaxOption);
        this.syntaxOptions.put(styleKey, syntaxOption);
    }

    private static class ChangeAutoDetectSyntaxAction
    extends TextAction {
        private static final long serialVersionUID = -6045054098695629693L;

        public ChangeAutoDetectSyntaxAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textComponent = this.getTextComponent(e);
            if (textComponent instanceof AutoDetectSyntaxHttpPanelTextArea) {
                AutoDetectSyntaxHttpPanelTextArea textArea;
                textArea.setAutoDetectSyntax(!(textArea = (AutoDetectSyntaxHttpPanelTextArea)((Object)textComponent)).isAutoDetectSyntax());
            }
        }
    }

    private static class ChangeSyntaxAction
    extends TextAction {
        private static final long serialVersionUID = 5136037355346821365L;
        private final String styleKey;

        public ChangeSyntaxAction(String text, String styleKey) {
            super(text);
            this.styleKey = styleKey;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textComponent = this.getTextComponent(e);
            if (textComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelTextArea = (HttpPanelSyntaxHighlightTextArea)((Object)textComponent);
                httpPanelTextArea.setSyntaxEditingStyle(this.styleKey);
            }
        }
    }
}

