/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.httputils;

import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.network.HttpMessage;

public class HtmlContext {
    public static final int IGNORE_PARENT = 1;
    public static final int IGNORE_TAG = 2;
    public static final int IGNORE_QUOTES = 4;
    public static final int IGNORE_IN_SCRIPT = 8;
    public static final int IGNORE_IN_URL = 16;
    public static final int IGNORE_WITH_SRC = 32;
    public static final int IGNORE_HTML_COMMENT = 64;
    private HttpMessage msg;
    private String target;
    private int start = 0;
    private int end = 0;
    private List<String> parentTags = new ArrayList<String>();
    private String tagAttribute = null;
    private boolean inScriptAttribute = false;
    private boolean inUrlAttribute = false;
    private boolean inTagWithSrc = false;
    private String surroundingQuote = "";
    private boolean htmlComment = false;

    public HtmlContext(HttpMessage msg, String target, int start, int end) {
        this.msg = msg;
        this.target = target;
        this.start = start;
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public HttpMessage getMsg() {
        return this.msg;
    }

    public String getTarget() {
        return this.target;
    }

    public List<String> getParentTags() {
        return this.parentTags;
    }

    public void setParentTags(List<String> surroundingTags) {
        this.parentTags = surroundingTags;
    }

    public String getSurroundingQuote() {
        return this.surroundingQuote;
    }

    public void setSurroundingQuote(String surroundingQuote) {
        this.surroundingQuote = surroundingQuote;
    }

    public String getTagAttribute() {
        return this.tagAttribute;
    }

    public void setTagAttribute(String tagAttribute) {
        this.tagAttribute = tagAttribute;
    }

    public void addParentTag(String name) {
        this.parentTags.add(0, name);
    }

    public String getParentTag() {
        if (this.parentTags.size() > 0) {
            return this.parentTags.get(this.parentTags.size() - 1);
        }
        return null;
    }

    public boolean isInScriptAttribute() {
        return this.inScriptAttribute;
    }

    public void setInScriptAttribute(boolean inScriptAttribute) {
        this.inScriptAttribute = inScriptAttribute;
    }

    public boolean isHtmlComment() {
        return this.htmlComment;
    }

    public void setHtmlComment(boolean htmlComment) {
        this.htmlComment = htmlComment;
    }

    public boolean isInUrlAttribute() {
        return this.inUrlAttribute;
    }

    public void setInUrlAttribute(boolean inUrlAttribute) {
        this.inUrlAttribute = inUrlAttribute;
    }

    public boolean isInTagWithSrc() {
        return this.inTagWithSrc;
    }

    public void setInTagWithSrc(boolean inTagWithSrc) {
        this.inTagWithSrc = inTagWithSrc;
    }

    public boolean matches(HtmlContext context, int ignoreFlags) {
        if (context == null) {
            return false;
        }
        if ((ignoreFlags ^ 2) > 0 && (this.tagAttribute != null ? !this.tagAttribute.equals(context.getTagAttribute()) : context.getTagAttribute() != null)) {
            return false;
        }
        if ((ignoreFlags ^ 4) > 0 && (this.surroundingQuote != null ? !this.surroundingQuote.equals(context.getSurroundingQuote()) : context.getSurroundingQuote() != null)) {
            return false;
        }
        if ((ignoreFlags ^ 1) > 0 && (this.getParentTag() != null ? !this.getParentTag().equals(context.getParentTag()) : context.getParentTag() != null)) {
            return false;
        }
        if ((ignoreFlags ^ 8) > 0 && this.inScriptAttribute != context.isInScriptAttribute()) {
            return false;
        }
        if ((ignoreFlags ^ 0x20) > 0 && this.inTagWithSrc != context.isInTagWithSrc()) {
            return false;
        }
        if ((ignoreFlags ^ 0x10) > 0 && this.inUrlAttribute != context.isInUrlAttribute()) {
            return false;
        }
        return (ignoreFlags ^ 0x40) <= 0 || this.htmlComment == context.isHtmlComment();
    }
}

