/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import net.htmlparser.jericho.Source;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpStatusCode;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderRedirectParser
extends SpiderParser {
    @Override
    public boolean parseResource(HttpMessage message, Source source, int depth) {
        this.getLogger().debug("Parsing an HTTP redirection resource...");
        String location = message.getResponseHeader().getHeader("Location");
        if (location != null && !location.isEmpty()) {
            String baseURL = message.getRequestHeader().getURI().toString();
            this.processURL(message, depth, location, baseURL);
        }
        return true;
    }

    @Override
    public boolean canParseResource(HttpMessage message, String path, boolean wasAlreadyParsed) {
        return HttpStatusCode.isRedirection(message.getResponseHeader().getStatusCode());
    }
}

