/*
 * Decompiled with CFR 0.152.
 */
package com.lizardworks.tiff;

import com.lizardworks.tiff.T4Code;
import com.lizardworks.util.Converter;

class T4Node {
    public static final int NOMASK = 65535;
    int mask = 65535;
    T4Node zero = null;
    T4Node one = null;
    T4Code code = null;

    public String toString() {
        StringBuffer sz = new StringBuffer();
        String szMask = Converter.intToBinaryString(this.mask, 16);
        int i = this.mask != 65535 ? szMask.indexOf("1") : this.code.bitLength;
        sz.append("\n");
        while (i > 0) {
            sz.append(" ");
            --i;
        }
        sz.append("{");
        sz.append(szMask);
        sz.append(",");
        sz.append(this.zero);
        sz.append(",");
        sz.append(this.one);
        sz.append(",");
        sz.append(this.code);
        sz.append("}");
        return sz.toString();
    }

    public void Add(int d, T4Code c) {
        if (d == c.bitLength) {
            this.code = c;
        } else {
            int bits;
            ++d;
            if (this.mask == 65535) {
                this.mask = 1 << 16 - d;
            }
            if (((bits = c.codeWord << 16 - c.bitLength) & this.mask) == 0) {
                if (this.zero == null) {
                    this.zero = new T4Node();
                }
                this.zero.Add(d, c);
            } else {
                if (this.one == null) {
                    this.one = new T4Node();
                }
                this.one.Add(d, c);
            }
        }
    }

    public void ReversedAdd(int d, T4Code c) {
        if (d == c.bitLength) {
            this.code = c;
        } else {
            if (this.mask == 65535) {
                this.mask = 1 << d;
            }
            ++d;
            int bits = c.codeWord;
            if ((bits & this.mask) == 0) {
                if (this.zero == null) {
                    this.zero = new T4Node();
                }
                this.zero.ReversedAdd(d, c);
            } else {
                if (this.one == null) {
                    this.one = new T4Node();
                }
                this.one.ReversedAdd(d, c);
            }
        }
    }

    public T4Node Find(int i) {
        if (this.code != null) {
            return this;
        }
        if (this.mask != 65535) {
            if ((this.mask & i) == 0) {
                return this.zero != null ? this.zero.Find(i) : null;
            }
            return this.one != null ? this.one.Find(i) : null;
        }
        return null;
    }
}

