/*
 *
 * LiveWallpaper
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (C) 2012-2016 Maximilian Schnarr <Maximilian.Schnarr@googlemail.com>
 *
 */

#ifndef _LW_CORE_H_
#define _LW_CORE_H_

#include <stdlib.h>

#include <glib-object.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include <GL/glew.h>

#include <livewallpaper/util.h>
#include <livewallpaper/error.h>
#include <livewallpaper/random.h>
#include <livewallpaper/range.h>
#include <livewallpaper/noise.h>
#include <livewallpaper/color.h>
#include <livewallpaper/output.h>
#include <livewallpaper/texture.h>
#include <livewallpaper/cairo-texture.h>
#include <livewallpaper/shader.h>
#include <livewallpaper/math.h>
#include <livewallpaper/matrix.h>
#include <livewallpaper/buffer.h>
#include <livewallpaper/program.h>
#include <livewallpaper/background.h>
#include <livewallpaper/wallpaper.h>

#endif /* _LW_CORE_H_ */

