/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.board;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AnnotatedWorker;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.board.Activity;
import net.sourceforge.plantuml.board.PostIt;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.ImageParameter;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class BoardDiagram
extends UmlDiagram {
    private final List<Activity> activities = new ArrayList<Activity>();

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("Board");
    }

    public BoardDiagram() {
        super(UmlDiagramType.BOARD);
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        Scale scale = this.getScale();
        double dpiFactor = scale == null ? this.getScaleCoef(fileFormatOption) : scale.getScale(100.0, 100.0);
        ISkinParam skinParam = this.getSkinParam();
        int margin1 = SkinParam.zeroMargin(10);
        int margin2 = SkinParam.zeroMargin(10);
        Style style = StyleSignature.of(SName.root, SName.document, SName.mindmapDiagram).getMergedStyle(skinParam.getCurrentStyleBuilder());
        HColor backgroundColor = style.value(PName.BackGroundColor).asColor(skinParam.getIHtmlColorSet());
        if (backgroundColor == null) {
            backgroundColor = HColorUtils.transparent();
        }
        ClockwiseTopRightBottomLeft margins = ClockwiseTopRightBottomLeft.margin1margin2(margin1, margin2);
        String metadata = fileFormatOption.isWithMetadata() ? this.getMetadata() : null;
        ImageParameter imageParameter = new ImageParameter(skinParam.getColorMapper(), skinParam.handwritten(), null, dpiFactor, metadata, "", margins, backgroundColor);
        ImageBuilder imageBuilder = ImageBuilder.build(imageParameter);
        TextBlockBackcolored result = this.getTextBlock();
        result = new AnnotatedWorker(this, skinParam, fileFormatOption.getDefaultStringBounder(this.getSkinParam())).addAdd(result);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, this.seed(), os);
    }

    private TextBlockBackcolored getTextBlock() {
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                BoardDiagram.this.drawMe(ug);
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                double width = 200.0;
                double height = 200.0;
                return new Dimension2DDouble(200.0, 200.0);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HColor getBackcolor() {
                return null;
            }
        };
    }

    private void drawMe(UGraphic ug) {
        UGraphic mug = ug;
        for (Activity activity : this.activities) {
            activity.drawMe(mug);
            mug = mug.apply(UTranslate.dx(activity.getFullWidth()));
        }
        ULine line = ULine.hline(this.getFullWidth());
        for (int i = 0; i < this.getMaxStage(); ++i) {
            double dy = (double)(i + 1) * PostIt.getHeight() - 10.0;
            ug.apply(HColorUtils.BLACK).apply(new UStroke(5.0, 5.0, 0.5)).apply(UTranslate.dy(dy)).draw(line);
        }
    }

    private double getFullWidth() {
        double width = 0.0;
        for (Activity activity : this.activities) {
            width += activity.getFullWidth();
        }
        return width;
    }

    private int getMaxStage() {
        int max = 0;
        for (Activity activity : this.activities) {
            max = Math.max(max, activity.getMaxStage());
        }
        return max;
    }

    private Activity getLastActivity() {
        return this.activities.get(this.activities.size() - 1);
    }

    public CommandExecutionResult addLine(String plus, String label) {
        if (plus.length() == 0) {
            Activity activity = new Activity(this, label, this.getSkinParam());
            this.activities.add(activity);
            return CommandExecutionResult.ok();
        }
        this.getLastActivity().addRelease(plus.length(), label);
        return CommandExecutionResult.ok();
    }
}

