/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class Election {
    private final Map<String, CharSequence> all = new HashMap<String, CharSequence>();

    Election() {
    }

    public void addCandidate(String display, CharSequence candidate) {
        this.all.put(display, candidate);
    }

    private CharSequence getCandidate(String shortName) {
        List<CharSequence> list = this.getAllCandidateContains(shortName);
        if (list.size() == 1) {
            return list.get(0);
        }
        list = this.getAllCandidateContainsStrict(shortName);
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    private List<CharSequence> getAllCandidateContains(String shortName) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        for (Map.Entry<String, CharSequence> ent : this.all.entrySet()) {
            if (!ent.getKey().contains(shortName)) continue;
            result.add(ent.getValue());
        }
        return result;
    }

    private List<CharSequence> getAllCandidateContainsStrict(String shortName) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        for (Map.Entry<String, CharSequence> ent : this.all.entrySet()) {
            String key = ent.getKey();
            if (!key.matches(".*\\b" + shortName + "\\b.*")) continue;
            result.add(ent.getValue());
        }
        return result;
    }

    public Map<CharSequence, String> getAllElected(Collection<String> shortNames) {
        HashMap<CharSequence, String> memberWithPort = new HashMap<CharSequence, String>();
        for (String shortName : new HashSet<String>(shortNames)) {
            CharSequence m = this.getCandidate(shortName);
            if (m == null) continue;
            memberWithPort.put(m, shortName);
            shortNames.remove(shortName);
        }
        return Collections.unmodifiableMap(memberWithPort);
    }
}

