#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt5 import QtGui, QtCore, QtWidgets
from rotarybase import *


# Linear control, v0...v1 in ns steps.
#
class Rlinctl (RotaryBase):

    def __init__(self, parent, style, v0, v1, ns, dk):
        self.v0 = v0
        self.dv = v1 - v0
        self.ns = ns
        self.dk = dk
        super (Rlinctl, self).__init__(parent, style)
        
    def handle_wheel (self, dw):
        sh = self.modifiers == QtCore.Qt.ShiftModifier 
        if sh: dk = 1
        else:  dk = self.dk
        if dw < 0: dk = -dk
        self.k = max (0, min (self.ns, self.k + dk))
        
    def handle_move (self, dk):
        if self.mousebutt == 1:
            self.k = max (0, min (self.ns, self.kref + dk // 2))
        
    def k2a (self, k):
        return 225 - 270 * k / self.ns

    def k2v (self, k):
        return self.v0 + self.dv * k / self.ns
        
    def v2k (self, v):
        r = (v - self.v0) / self.dv
        return max (0, min (self.ns, int (self.ns * r)))


# Audio gain control
#
class Rgainctl (RotaryBase):

    def __init__(self, parent, style):
        super (Rgainctl, self).__init__(parent, style)
        
    def handle_wheel (self, dw):
        sh = self.modifiers == QtCore.Qt.ShiftModifier 
        if sh: dk = 1   # 0.5 dB
        else:  dk = 4   # 2.0 dB
        if dw < 0: dk = -dk
        self.k = max (0, min (120, self.k + dk))
        
    def handle_move (self, dk):
        if self.mousebutt == 1:
            self.k = max (0, min (120, self.kref + dk // 2))
        
    def k2a (self, k):
        return 225 - 270 * k / 120

    def k2v (self, k):
        if k > 0: return k / 2 - 50.0
        else:     return -200.0
        
    def v2k (self, v):
        return max (0, min (160, int (2 * v + 100.5)))

