﻿
# game/tutorial_atl.rpy:208
translate piglatin tutorial_positions_a09a3fd1:

    # e "In this tutorial, I'll teach you how Ren'Py positions things on the screen. But before that, let's learn a little bit about how Python handles numbers."
    e "Niay histay utorialtay, Iay'llay eachtay ouyay owhay Enray'Ypay ositionspay hingstay onay hetay creensay. Utbay eforebay hattay, etlay'say earnlay aay ittlelay itbay aboutay owhay Ythonpay andleshay umbersnay."

# game/tutorial_atl.rpy:210
translate piglatin tutorial_positions_ba39aabc:

    # e "There are two main kinds of numbers in Python: integers and floating point numbers. An integer consists entirely of digits, while a floating point number has a decimal point."
    e "Heretay areay wotay ainmay indskay ofay umbersnay inay Ythonpay: integersay anday oatingflay ointpay umbersnay. Naay integeray onsistscay entirelyay ofay igitsday, hileway aay oatingflay ointpay umbernay ashay aay ecimalday ointpay."

# game/tutorial_atl.rpy:212
translate piglatin tutorial_positions_a60b775d:

    # e "For example, 100 is an integer, while 0.5 is a floating point number, or float for short. In this system, there are two zeros: 0 is an integer, and 0.0 is a float."
    e "Orfay exampleay, 001ay isay anay integeray, hileway 0ay.5ay isay aay oatingflay ointpay umbernay, oray oatflay orfay ortshay. Niay histay ystemsay, heretay areay wotay eroszay: 0ay isay anay integeray, anday 0ay.0ay isay aay oatflay."

# game/tutorial_atl.rpy:214
translate piglatin tutorial_positions_7f1a560c:

    # e "Ren'Py uses integers to represent absolute coordinates, and floats to represent fractions of an area with known size."
    e "Enray'Ypay usesay integersay otay epresentray absoluteay oordinatescay, anday oatsflay otay epresentray actionsfray ofay anay areaay ithway nownkay izesay."

# game/tutorial_atl.rpy:216
translate piglatin tutorial_positions_8e7d3e52:

    # e "When we're positioning something, the area is usually the entire screen."
    e "Henway eway'eray ositioningpay omethingsay, hetay areaay isay usuallyay hetay entireay creensay."

# game/tutorial_atl.rpy:218
translate piglatin tutorial_positions_fdcf9d8b:

    # e "Let me get out of the way, and I'll show you where some positions are."
    e "Etlay emay etgay outay ofay hetay ayway, anday Iay'llay owshay ouyay hereway omesay ositionspay areay."

# game/tutorial_atl.rpy:232
translate piglatin tutorial_positions_76d7a5bf:

    # e "The origin is the upper-left corner of the screen. That's where the x position (xpos) and the y position (ypos) are both zero."
    e "Hetay originay isay hetay upperay-eftlay ornercay ofay hetay creensay. Hattay'say hereway hetay xay ositionpay (posxay) anday hetay yay ositionpay (posyay) areay othbay erozay."

# game/tutorial_atl.rpy:238
translate piglatin tutorial_positions_be14c7c3:

    # e "When we increase xpos, we move to the right. So here's an xpos of .5, meaning half the width across the screen."
    e "Henway eway increaseay posxay, eway ovemay otay hetay ightray. Osay erehay'say anay posxay ofay .5ay, eaningmay alfhay hetay idthway acrossay hetay creensay."

# game/tutorial_atl.rpy:243
translate piglatin tutorial_positions_9b91be6c:

    # e "Increasing xpos to 1.0 moves us to the right-hand border of the screen."
    e "Ncreasingiay posxay otay 1ay.0ay ovesmay usay otay hetay ightray-andhay orderbay ofay hetay creensay."

# game/tutorial_atl.rpy:249
translate piglatin tutorial_positions_2b293304:

    # e "We can also use an absolute xpos, which is given in an absolute number of pixels from the left side of the screen. For example, since this window is 1280 pixels across, using an xpos of 640 will return the target to the center of the top row."
    e "Eway ancay alsoay useay anay absoluteay posxay, hichway isay ivengay inay anay absoluteay umbernay ofay ixelspay omfray hetay eftlay idesay ofay hetay creensay. Orfay exampleay, incesay histay indowway isay 2801ay ixelspay acrossay, usingay anay posxay ofay 406ay illway eturnray hetay argettay otay hetay entercay ofay hetay optay owray."

# game/tutorial_atl.rpy:251
translate piglatin tutorial_positions_c4d18c0a:

    # e "The y-axis position, or ypos works the same way. Right now, we have a ypos of 0.0."
    e "Hetay yay-axisay ositionpay, oray posyay orksway hetay amesay ayway. Ightray ownay, eway avehay aay posyay ofay 0ay.0ay."

# game/tutorial_atl.rpy:257
translate piglatin tutorial_positions_16933a61:

    # e "Here's a ypos of 0.5."
    e "Erehay'say aay posyay ofay 0ay.5ay."

# game/tutorial_atl.rpy:262
translate piglatin tutorial_positions_6eb36777:

    # e "A ypos of 1.0 specifies a position at the bottom of the screen. If you look carefully, you can see the position indicator spinning below the text window."
    e "Aay posyay ofay 1ay.0ay pecifiessay aay ositionpay atay hetay ottombay ofay hetay creensay. Fiay ouyay ooklay arefullycay, ouyay ancay eesay hetay ositionpay indicatoray pinningsay elowbay hetay exttay indowway."

# game/tutorial_atl.rpy:264
translate piglatin tutorial_positions_a423050f:

    # e "Like xpos, ypos can also be an integer. In this case, ypos would give the total number of pixels from the top of the screen."
    e "Ikelay posxay, posyay ancay alsoay ebay anay integeray. Niay histay asecay, posyay ouldway ivegay hetay otaltay umbernay ofay ixelspay omfray hetay optay ofay hetay creensay."

# game/tutorial_atl.rpy:270
translate piglatin tutorial_positions_bc7a809a:

    # e "Can you guess where this position is, relative to the screen?" nointeract
    e "Ancay ouyay uessgay hereway histay ositionpay isay, elativeray otay hetay creensay?" nointeract

# game/tutorial_atl.rpy:276
translate piglatin tutorial_positions_6f926e18:

    # e "Sorry, that's wrong. The xpos is .75, and the ypos is .25."
    e "Orrysay, hattay'say rongway. Hetay posxay isay .57ay, anday hetay posyay isay .52ay."

# game/tutorial_atl.rpy:278
translate piglatin tutorial_positions_5d5feb98:

    # e "In other words, it's 75%% of the way from the left side, and 25%% of the way from the top."
    e "Niay otheray ordsway, itay'say 57ay%% ofay hetay ayway omfray hetay eftlay idesay, anday 52ay%% ofay hetay ayway omfray hetay optay."

# game/tutorial_atl.rpy:282
translate piglatin tutorial_positions_77b45218:

    # e "Good job! You got that position right."
    e "Oodgay objay! Ouyay otgay hattay ositionpay ightray."

# game/tutorial_atl.rpy:286
translate piglatin tutorial_positions_6f926e18_1:

    # e "Sorry, that's wrong. The xpos is .75, and the ypos is .25."
    e "Orrysay, hattay'say rongway. Hetay posxay isay .57ay, anday hetay posyay isay .52ay."

# game/tutorial_atl.rpy:288
translate piglatin tutorial_positions_5d5feb98_1:

    # e "In other words, it's 75%% of the way from the left side, and 25%% of the way from the top."
    e "Niay otheray ordsway, itay'say 57ay%% ofay hetay ayway omfray hetay eftlay idesay, anday 52ay%% ofay hetay ayway omfray hetay optay."

# game/tutorial_atl.rpy:302
translate piglatin tutorial_positions_e4380a83:

    # e "The second position we care about is the anchor. The anchor is a spot on the thing being positioned."
    e "Hetay econdsay ositionpay eway arecay aboutay isay hetay anchoray. Hetay anchoray isay aay potsay onay hetay hingtay eingbay ositionedpay."

# game/tutorial_atl.rpy:304
translate piglatin tutorial_positions_d1db1246:

    # e "For example, here we have an xanchor of 0.0 and a yanchor of 0.0. It's in the upper-left corner of the logo image."
    e "Orfay exampleay, erehay eway avehay anay anchorxay ofay 0ay.0ay anday aay anchoryay ofay 0ay.0ay. Tiay'say inay hetay upperay-eftlay ornercay ofay hetay ogolay imageay."

# game/tutorial_atl.rpy:309
translate piglatin tutorial_positions_6056873f:

    # e "When we increase the xanchor to 1.0, the anchor moves to the right corner of the image."
    e "Henway eway increaseay hetay anchorxay otay 1ay.0ay, hetay anchoray ovesmay otay hetay ightray ornercay ofay hetay imageay."

# game/tutorial_atl.rpy:314
translate piglatin tutorial_positions_7cdb8dcc:

    # e "Similarly, when both xanchor and yanchor are 1.0, the anchor is the bottom-right corner."
    e "Imilarlysay, henway othbay anchorxay anday anchoryay areay 1ay.0ay, hetay anchoray isay hetay ottombay-ightray ornercay."

# game/tutorial_atl.rpy:321
translate piglatin tutorial_positions_03a07da8:

    # e "To place an image on the screen, we need both the position and the anchor."
    e "Otay aceplay anay imageay onay hetay creensay, eway eednay othbay hetay ositionpay anday hetay anchoray."

# game/tutorial_atl.rpy:329
translate piglatin tutorial_positions_8945054f:

    # e "We then line them up, so that both the position and anchor are at the same point on the screen."
    e "Eway hentay inelay hemtay upay, osay hattay othbay hetay ositionpay anday anchoray areay atay hetay amesay ointpay onay hetay creensay."

# game/tutorial_atl.rpy:339
translate piglatin tutorial_positions_2b184a93:

    # e "When we place both in the upper-left corner, the image moves to the upper-left corner of the screen."
    e "Henway eway aceplay othbay inay hetay upperay-eftlay ornercay, hetay imageay ovesmay otay hetay upperay-eftlay ornercay ofay hetay creensay."

# game/tutorial_atl.rpy:348
translate piglatin tutorial_positions_5aac4f3f:

    # e "With the right combination of position and anchor, any place on the screen can be specified, without even knowing the size of the image."
    e "Ithway hetay ightray ombinationcay ofay ositionpay anday anchoray, anyay aceplay onay hetay creensay ancay ebay pecifiedsay, ithoutway evenay nowingkay hetay izesay ofay hetay imageay."

# game/tutorial_atl.rpy:360
translate piglatin tutorial_positions_3b59b797:

    # e "It's often useful to set xpos and xanchor to the same value. We call that xalign, and it gives a fractional position on the screen."
    e "Tiay'say oftenay usefulay otay etsay posxay anday anchorxay otay hetay amesay aluevay. Eway allcay hattay alignxay, anday itay ivesgay aay actionalfray ositionpay onay hetay creensay."

# game/tutorial_atl.rpy:365
translate piglatin tutorial_positions_b8ebf9fe:

    # e "For example, when we set xalign to 0.0, things are aligned to the left side of the screen."
    e "Orfay exampleay, henway eway etsay alignxay otay 0ay.0ay, hingstay areay aligneday otay hetay eftlay idesay ofay hetay creensay."

# game/tutorial_atl.rpy:370
translate piglatin tutorial_positions_8ce35d52:

    # e "When we set it to 1.0, then we're aligned to the right side of the screen."
    e "Henway eway etsay itay otay 1ay.0ay, hentay eway'eray aligneday otay hetay ightray idesay ofay hetay creensay."

# game/tutorial_atl.rpy:375
translate piglatin tutorial_positions_6745825f:

    # e "And when we set it to 0.5, we're back to the center of the screen."
    e "Ndaay henway eway etsay itay otay 0ay.5ay, eway'eray ackbay otay hetay entercay ofay hetay creensay."

# game/tutorial_atl.rpy:377
translate piglatin tutorial_positions_64428a07:

    # e "Setting yalign is similar, except along the y-axis."
    e "Ettingsay alignyay isay imilarsay, exceptay alongay hetay yay-axisay."

# game/tutorial_atl.rpy:379
translate piglatin tutorial_positions_cfb77d42:

    # e "Remember that xalign is just setting xpos and xanchor to the same value, and yalign is just setting ypos and yanchor to the same value."
    e "Ememberray hattay alignxay isay ustjay ettingsay posxay anday anchorxay otay hetay amesay aluevay, anday alignyay isay ustjay ettingsay posyay anday anchoryay otay hetay amesay aluevay."

# game/tutorial_atl.rpy:384
translate piglatin tutorial_positions_cfc1723e:

    # e "The xcenter and ycenter properties position the center of the image. Here, with xcenter set to .75, the center of the image is three-quarters of the way to the right side of the screen."
    e "Hetay centerxay anday centeryay ropertiespay ositionpay hetay entercay ofay hetay imageay. Erehay, ithway centerxay etsay otay .57ay, hetay entercay ofay hetay imageay isay hreetay-uartersqay ofay hetay ayway otay hetay ightray idesay ofay hetay creensay."

# game/tutorial_atl.rpy:389
translate piglatin tutorial_positions_7728dbf9:

    # e "The difference between xalign and xcenter is more obvious when xcenter is 1.0, and the image is halfway off the right side of the screen."
    e "Hetay ifferenceday etweenbay alignxay anday centerxay isay oremay obviousay henway centerxay isay 1ay.0ay, anday hetay imageay isay alfwayhay offay hetay ightray idesay ofay hetay creensay."

# game/tutorial_atl.rpy:397
translate piglatin tutorial_positions_1b1cedc6:

    # e "There are the xoffset and yoffset properties, which are applied after everything else, and offset things to the right or bottom, respectively."
    e "Heretay areay hetay offsetxay anday offsetyay ropertiespay, hichway areay applieday afteray everythingay elseay, anday offsetay hingstay otay hetay ightray oray ottombay, espectivelyray."

# game/tutorial_atl.rpy:402
translate piglatin tutorial_positions_e6da2798:

    # e "Of course, you can use negative numbers to offset things to the left and top."
    e "Foay oursecay, ouyay ancay useay egativenay umbersnay otay offsetay hingstay otay hetay eftlay anday optay."

# game/tutorial_atl.rpy:407
translate piglatin tutorial_positions_e0fe2d81:

    # e "Lastly, I'll mention that there are combined properties like align, pos, anchor, and center. Align takes a pair of numbers, and sets xalign to the first and yalign to the second. The others are similar."
    e "Astlylay, Iay'llay entionmay hattay heretay areay ombinedcay ropertiespay ikelay alignay, ospay, anchoray, anday entercay. Lignaay akestay aay airpay ofay umbersnay, anday etssay alignxay otay hetay irstfay anday alignyay otay hetay econdsay. Hetay othersay areay imilarsay."

# game/tutorial_atl.rpy:414
translate piglatin tutorial_positions_0f4ca2b6:

    # e "Once you understand positions, you can use transformations to move things around the Ren'Py screen."
    e "Nceoay ouyay understanday ositionspay, ouyay ancay useay ansformationstray otay ovemay hingstay arounday hetay Enray'Ypay creensay."

# game/tutorial_atl.rpy:421
translate piglatin tutorial_atl_d5d6b62a:

    # e "Ren'Py uses transforms to animate, manipulate, and place images. We've already seen the very simplest of transforms in use:"
    e "Enray'Ypay usesay ansformstray otay animateay, anipulatemay, anday aceplay imagesay. Eway'evay alreadyay eensay hetay eryvay implestsay ofay ansformstray inay useay:"

# game/tutorial_atl.rpy:428
translate piglatin tutorial_atl_7e853c9d:

    # e "Transforms can be very simple affairs that place the image somewhere on the screen, like the right transform."
    e "Ransformstay ancay ebay eryvay implesay affairsay hattay aceplay hetay imageay omewheresay onay hetay creensay, ikelay hetay ightray ansformtray."

# game/tutorial_atl.rpy:432
translate piglatin tutorial_atl_87a6ecbd:

    # e "But transforms can also be far more complicated affairs, that introduce animation and effects into the mix. To demonstrate, let's have a Gratuitous Rock Concert!"
    e "Utbay ansformstray ancay alsoay ebay arfay oremay omplicatedcay affairsay, hattay introduceay animationay anday effectsay intoay hetay ixmay. Otay emonstrateday, etlay'say avehay aay Ratuitousgay Ockray Oncertcay!"

# game/tutorial_atl.rpy:440
translate piglatin tutorial_atl_65badef3:

    # e "But first, let's have... a Gratuitous Rock Concert!"
    e "Utbay irstfay, etlay'say avehay... aay Ratuitousgay Ockray Oncertcay!"

# game/tutorial_atl.rpy:448
translate piglatin tutorial_atl_e0d3c5ec:

    # e "That was a lot of work, but it was built out of small parts."
    e "Hattay asway aay otlay ofay orkway, utbay itay asway uiltbay outay ofay mallsay artspay."

# game/tutorial_atl.rpy:450
translate piglatin tutorial_atl_f2407514:

    # e "Most transforms in Ren'Py are built using the Animation and Transform Language, or ATL for short."
    e "Ostmay ansformstray inay Enray'Ypay areay uiltbay usingay hetay Nimationaay anday Ransformtay Anguagelay, oray Tlaay orfay ortshay."

# game/tutorial_atl.rpy:452
translate piglatin tutorial_atl_1f22f875:

    # e "There are currently three places where ATL can be used in Ren'Py."
    e "Heretay areay urrentlycay hreetay acesplay hereway Tlaay ancay ebay useday inay Enray'Ypay."

# game/tutorial_atl.rpy:457
translate piglatin tutorial_atl_fd036bdf:

    # e "The first place ATL can be used is as part of an image statement. Instead of a displayable, an image may be defined as a block of ATL code."
    e "Hetay irstfay aceplay Tlaay ancay ebay useday isay asay artpay ofay anay imageay atementstay. Nsteadiay ofay aay isplayableday, anay imageay aymay ebay efinedday asay aay ockblay ofay Tlaay odecay."

# game/tutorial_atl.rpy:459
translate piglatin tutorial_atl_7cad2ab9:

    # e "When used in this way, we have to be sure that ATL includes one or more displayables to actually show."
    e "Henway useday inay histay ayway, eway avehay otay ebay uresay hattay Tlaay includesay oneay oray oremay isplayablesday otay actuallyay owshay."

# game/tutorial_atl.rpy:464
translate piglatin tutorial_atl_c78b2a1e:

    # e "The second way is through the use of the transform statement. This assigns the ATL block to a python variable, allowing it to be used in at clauses and inside other transforms."
    e "Hetay econdsay ayway isay hroughtay hetay useay ofay hetay ansformtray atementstay. Histay assignsay hetay Tlaay ockblay otay aay ythonpay ariablevay, allowingay itay otay ebay useday inay atay ausesclay anday insideay otheray ansformstray."

# game/tutorial_atl.rpy:476
translate piglatin tutorial_atl_da7a7759:

    # e "Finally, an ATL block can be used as part of a show statement, instead of the at clause."
    e "Inallyfay, anay Tlaay ockblay ancay ebay useday asay artpay ofay aay owshay atementstay, insteaday ofay hetay atay auseclay."

# game/tutorial_atl.rpy:483
translate piglatin tutorial_atl_1dd345c6:

    # e "When ATL is used as part of a show statement, values of properties exist even when the transform is changed. So even though a click your click stopped the motion, the image remains in the same place."
    e "Henway Tlaay isay useday asay artpay ofay aay owshay atementstay, aluesvay ofay ropertiespay existay evenay henway hetay ansformtray isay angedchay. Osay evenay houghtay aay ickclay ouryay ickclay oppedstay hetay otionmay, hetay imageay emainsray inay hetay amesay aceplay."

# game/tutorial_atl.rpy:491
translate piglatin tutorial_atl_98047789:

    # e "The key to ATL is what we call composability. ATL is made up of relatively simple commands, which can be combined together to create complicated transforms."
    e "Hetay eykay otay Tlaay isay hatway eway allcay omposabilitycay. Tlaay isay ademay upay ofay elativelyray implesay ommandscay, hichway ancay ebay ombinedcay ogethertay otay reatecay omplicatedcay ansformstray."

# game/tutorial_atl.rpy:493
translate piglatin tutorial_atl_ed82983f:

    # e "Before I explain how ATL works, let me explain what animation and transformation are."
    e "Eforebay Iay explainay owhay Tlaay orksway, etlay emay explainay hatway animationay anday ansformationtray areay."

# game/tutorial_atl.rpy:498
translate piglatin tutorial_atl_2807adff:

    # e "Animation is when the displayable being shown changes. For example, right now I am changing my expression."
    e "Nimationaay isay henway hetay isplayableday eingbay ownshay angeschay. Orfay exampleay, ightray ownay Iay amay angingchay ymay expressionay."

# game/tutorial_atl.rpy:525
translate piglatin tutorial_atl_3eec202b:

    # e "Transformation involves moving or distorting an image. This includes placing it on the screen, zooming it in and out, rotating it, and changing its opacity."
    e "Ransformationtay involvesay ovingmay oray istortingday anay imageay. Histay includesay acingplay itay onay hetay creensay, oomingzay itay inay anday outay, otatingray itay, anday angingchay itsay opacityay."

# game/tutorial_atl.rpy:533
translate piglatin tutorial_atl_fbc9bf83:

    # e "To introduce ATL, let's start by looking at at a simple animation. Here's one that consists of five lines of ATL code, contained within an image statement."
    e "Otay introduceay Tlaay, etlay'say artstay ybay ookinglay atay atay aay implesay animationay. Erehay'say oneay hattay onsistscay ofay ivefay ineslay ofay Tlaay odecay, ontainedcay ithinway anay imageay atementstay."

# game/tutorial_atl.rpy:535
translate piglatin tutorial_atl_bf92d973:

    # e "To change a displayable, simply mention it on a line of ATL. Here, we're switching back and forth between two images."
    e "Otay angechay aay isplayableday, implysay entionmay itay onay aay inelay ofay Tlaay. Erehay, eway'eray witchingsay ackbay anday orthfay etweenbay wotay imagesay."

# game/tutorial_atl.rpy:537
translate piglatin tutorial_atl_51a41db4:

    # e "Since we're defining an image, the first line of ATL must give a displayable. Otherwise, there would be nothing to show."
    e "Incesay eway'eray efiningday anay imageay, hetay irstfay inelay ofay Tlaay ustmay ivegay aay isplayableday. Therwiseoay, heretay ouldway ebay othingnay otay owshay."

# game/tutorial_atl.rpy:539
translate piglatin tutorial_atl_3d065074:

    # e "The second and fourth lines are pause statements, which cause ATL to wait half a second each before continuing. That's how we give the delay between images."
    e "Hetay econdsay anday ourthfay ineslay areay ausepay atementsstay, hichway ausecay Tlaay otay aitway alfhay aay econdsay eachay eforebay ontinuingcay. Hattay'say owhay eway ivegay hetay elayday etweenbay imagesay."

# game/tutorial_atl.rpy:541
translate piglatin tutorial_atl_60f2a5e8:

    # e "The final line is a repeat statement. This causes the current block of ATL to be restarted. You can only have one repeat statement per block."
    e "Hetay inalfay inelay isay aay epeatray atementstay. Histay ausescay hetay urrentcay ockblay ofay Tlaay otay ebay estartedray. Ouyay ancay onlyay avehay oneay epeatray atementstay erpay ockblay."

# game/tutorial_atl.rpy:546
translate piglatin tutorial_atl_146cf4c4:

    # e "If we were to write repeat 2 instead, the animation would loop twice, then stop."
    e "Fiay eway ereway otay riteway epeatray 2ay insteaday, hetay animationay ouldway ooplay wicetay, hentay opstay."

# game/tutorial_atl.rpy:551
translate piglatin tutorial_atl_d90b1838:

    # e "Omitting the repeat statement means that the animation stops once we reach the end of the block of ATL code."
    e "Mittingoay hetay epeatray atementstay eansmay hattay hetay animationay opsstay onceay eway eachray hetay enday ofay hetay ockblay ofay Tlaay odecay."

# game/tutorial_atl.rpy:557
translate piglatin tutorial_atl_e5872360:

    # e "By default, displayables are replaced instantaneously. We can also use a with clause to give a transition between displayables."
    e "Ybay efaultday, isplayablesday areay eplacedray instantaneouslyay. Eway ancay alsoay useay aay ithway auseclay otay ivegay aay ansitiontray etweenbay isplayablesday."

# game/tutorial_atl.rpy:564
translate piglatin tutorial_atl_2e9d63ea:

    # e "With animation done, we'll see how we can use ATL to transform images, starting with positioning an image on the screen."
    e "Ithway animationay oneday, eway'llay eesay owhay eway ancay useay Tlaay otay ansformtray imagesay, artingstay ithway ositioningpay anay imageay onay hetay creensay."

# game/tutorial_atl.rpy:573
translate piglatin tutorial_atl_ddc55039:

    # e "The simplest thing we can to is to statically position an image. This is done by giving the names of the position properties, followed by the property values."
    e "Hetay implestsay hingtay eway ancay otay isay otay aticallystay ositionpay anay imageay. Histay isay oneday ybay ivinggay hetay amesnay ofay hetay ositionpay ropertiespay, ollowedfay ybay hetay ropertypay aluesvay."

# game/tutorial_atl.rpy:578
translate piglatin tutorial_atl_43516492:

    # e "With a few more statements, we can move things around on the screen."
    e "Ithway aay ewfay oremay atementsstay, eway ancay ovemay hingstay arounday onay hetay creensay."

# game/tutorial_atl.rpy:580
translate piglatin tutorial_atl_fb979287:

    # e "This example starts the image off at the top-right of the screen, and waits a second. It then moves it to the left side, waits another second, and repeats."
    e "Histay exampleay artsstay hetay imageay offay atay hetay optay-ightray ofay hetay creensay, anday aitsway aay econdsay. Tiay hentay ovesmay itay otay hetay eftlay idesay, aitsway anotheray econdsay, anday epeatsray."

# game/tutorial_atl.rpy:582
translate piglatin tutorial_atl_7650ec09:

    # e "The pause and repeat statements are the same statements we used in our animations. They work throughout ATL code."
    e "Hetay ausepay anday epeatray atementsstay areay hetay amesay atementsstay eway useday inay ouray animationsay. Heytay orkway hroughouttay Tlaay odecay."

# game/tutorial_atl.rpy:587
translate piglatin tutorial_atl_d3416d4f:

    # e "Having the image jump around on the screen isn't all that useful. That's why ATL has the interpolation statement."
    e "Avinghay hetay imageay umpjay arounday onay hetay creensay isnay'tay allay hattay usefulay. Hattay'say hyway Tlaay ashay hetay interpolationay atementstay."

# game/tutorial_atl.rpy:589
translate piglatin tutorial_atl_4e7512ec:

    # e "The interpolation statement allows you to smoothly vary the value of a transform property, from an old to a new value."
    e "Hetay interpolationay atementstay allowsay ouyay otay moothlysay aryvay hetay aluevay ofay aay ansformtray ropertypay, omfray anay olday otay aay ewnay aluevay."

# game/tutorial_atl.rpy:591
translate piglatin tutorial_atl_685eeeaa:

    # e "Here, we have an interpolation statement on the second ATL line. It starts off with the name of a time function, in this case linear."
    e "Erehay, eway avehay anay interpolationay atementstay onay hetay econdsay Tlaay inelay. Tiay artsstay offay ithway hetay amenay ofay aay imetay unctionfay, inay histay asecay inearlay."

# game/tutorial_atl.rpy:593
translate piglatin tutorial_atl_c5cb49de:

    # e "That's followed by an amount of time, in this case three seconds. It ends with a list of properties, each followed by its new value."
    e "Hattay'say ollowedfay ybay anay amountay ofay imetay, inay histay asecay hreetay econdssay. Tiay endsay ithway aay istlay ofay ropertiespay, eachay ollowedfay ybay itsay ewnay aluevay."

# game/tutorial_atl.rpy:595
translate piglatin tutorial_atl_04b8bc1d:

    # e "The value of each property is interpolated from its value when the statement starts to the value at the end of the statement. This is done once per frame, allowing smooth animation."
    e "Hetay aluevay ofay eachay ropertypay isay interpolateday omfray itsay aluevay henway hetay atementstay artsstay otay hetay aluevay atay hetay enday ofay hetay atementstay. Histay isay oneday onceay erpay amefray, allowingay moothsay animationay."

# game/tutorial_atl.rpy:606
translate piglatin tutorial_atl_2958f397:

    # e "ATL supports more complicated move types, like circle and spline motion. But I won't be showing those here."
    e "Tlaay upportssay oremay omplicatedcay ovemay ypestay, ikelay irclecay anday plinesay otionmay. Utbay Iay onway'tay ebay owingshay hosetay erehay."

# game/tutorial_atl.rpy:610
translate piglatin tutorial_atl_d08fe8d9:

    # e "Apart from displayables, pause, interpolation, and repeat, there are a few other statements we can use as part of ATL."
    e "Partaay omfray isplayablesday, ausepay, interpolationay, anday epeatray, heretay areay aay ewfay otheray atementsstay eway ancay useay asay artpay ofay Tlaay."

# game/tutorial_atl.rpy:622
translate piglatin tutorial_atl_84b22ac0:

    # e "ATL transforms created using the statement become ATL statements themselves. Since the default positions are also transforms, this means that we can use left, right, and center inside of an ATL block."
    e "Tlaay ansformstray reatedcay usingay hetay atementstay ecomebay Tlaay atementsstay hemselvestay. Incesay hetay efaultday ositionspay areay alsoay ansformstray, histay eansmay hattay eway ancay useay eftlay, ightray, anday entercay insideay ofay anay Tlaay ockblay."

# game/tutorial_atl.rpy:638
translate piglatin tutorial_atl_331126c1:

    # e "Here, we have two new statements. The block statement allows you to include a block of ATL code. Since the repeat statement applies to blocks, this lets you repeat only part of an ATL transform."
    e "Erehay, eway avehay wotay ewnay atementsstay. Hetay ockblay atementstay allowsay ouyay otay includeay aay ockblay ofay Tlaay odecay. Incesay hetay epeatray atementstay appliesay otay ocksblay, histay etslay ouyay epeatray onlyay artpay ofay anay Tlaay ansformtray."

# game/tutorial_atl.rpy:640
translate piglatin tutorial_atl_24f67b67:

    # e "We also have the time statement, which runs after the given number of seconds have elapsed from the start of the block. It will run even if another statement is running, stopping the other statement."
    e "Eway alsoay avehay hetay imetay atementstay, hichway unsray afteray hetay ivengay umbernay ofay econdssay avehay elapseday omfray hetay artstay ofay hetay ockblay. Tiay illway unray evenay ifay anotheray atementstay isay unningray, oppingstay hetay otheray atementstay."

# game/tutorial_atl.rpy:642
translate piglatin tutorial_atl_b7709507:

    # e "So this example bounces the image back and forth for eleven and a half seconds, and then moves it to the right side of the screen."
    e "Osay histay exampleay ouncesbay hetay imageay ackbay anday orthfay orfay elevenay anday aay alfhay econdssay, anday hentay ovesmay itay otay hetay ightray idesay ofay hetay creensay."

# game/tutorial_atl.rpy:656
translate piglatin tutorial_atl_f903bc3b:

    # e "The parallel statement lets us run two blocks of ATL code at the same time."
    e "Hetay arallelpay atementstay etslay usay unray wotay ocksblay ofay Tlaay odecay atay hetay amesay imetay."

# game/tutorial_atl.rpy:658
translate piglatin tutorial_atl_5d0f8f9d:

    # e "Here, the top block move the image in the horizontal direction, and the bottom block moves it in the vertical direction. Since they're moving at different speeds, it looks like the image is bouncing on the screen."
    e "Erehay, hetay optay ockblay ovemay hetay imageay inay hetay orizontalhay irectionday, anday hetay ottombay ockblay ovesmay itay inay hetay erticalvay irectionday. Incesay heytay'eray ovingmay atay ifferentday peedssay, itay ookslay ikelay hetay imageay isay ouncingbay onay hetay creensay."

# game/tutorial_atl.rpy:672
translate piglatin tutorial_atl_28a7d27e:

    # e "Finally, the choice statement makes Ren'Py randomly pick a block of ATL code. This allows you to add some variation as to what Ren'Py shows."
    e "Inallyfay, hetay oicechay atementstay akesmay Enray'Ypay andomlyray ickpay aay ockblay ofay Tlaay odecay. Histay allowsay ouyay otay adday omesay ariationvay asay otay hatway Enray'Ypay owsshay."

# game/tutorial_atl.rpy:678
translate piglatin tutorial_atl_2265254b:

    # e "This tutorial game has only scratched the surface of what you can do with ATL. For example, we haven't even covered the on and event statements. For more information, you might want to check out {a=https://renpy.org/doc/html/atl.html}the ATL chapter in the reference manual{/a}."
    e "Histay utorialtay amegay ashay onlyay cratchedsay hetay urfacesay ofay hatway ouyay ancay oday ithway Tlaay. Orfay exampleay, eway avenhay'tay evenay overedcay hetay onay anday eventay atementsstay. Orfay oremay informationay, ouyay ightmay antway otay eckchay outay {a=https://renpy.org/doc/html/atl.html}hetay Tlaay apterchay inay hetay eferenceray anualmay{/a}."

# game/tutorial_atl.rpy:687
translate piglatin transform_properties_391169cf:

    # e "Ren'Py has quite a few transform properties that can be used with ATL, the Transform displayable, and the add Screen Language statement."
    e "Enray'Ypay ashay uiteqay aay ewfay ansformtray ropertiespay hattay ancay ebay useday ithway Tlaay, hetay Ransformtay isplayableday, anday hetay adday Creensay Anguagelay atementstay."

# game/tutorial_atl.rpy:688
translate piglatin transform_properties_fc895a1f:

    # e "Here, we'll show them off so you can see them in action and get used to what each does."
    e "Erehay, eway'llay owshay hemtay offay osay ouyay ancay eesay hemtay inay actionay anday etgay useday otay hatway eachay oesday."

# game/tutorial_atl.rpy:704
translate piglatin transform_properties_88daf990:

    # e "First off, all of the position properties are also transform properties. These include the pos, anchor, align, center, and offset properties."
    e "Irstfay offay, allay ofay hetay ositionpay ropertiespay areay alsoay ansformtray ropertiespay. Hesetay includeay hetay ospay, anchoray, alignay, entercay, anday offsetay ropertiespay."

# game/tutorial_atl.rpy:722
translate piglatin transform_properties_d7a487f1:

    # e "The position properties can also be used to pan over a displayable larger than the screen, by giving xpos and ypos negative values."
    e "Hetay ositionpay ropertiespay ancay alsoay ebay useday otay anpay overay aay isplayableday argerlay hantay hetay creensay, ybay ivinggay posxay anday posyay egativenay aluesvay."

# game/tutorial_atl.rpy:732
translate piglatin transform_properties_89e0d7c2:

    # "The subpixel property controls how things are lined up with the screen. When False, images can be pixel-perfect, but there can be pixel jumping."
    "Hetay ubpixelsay ropertypay ontrolscay owhay hingstay areay inedlay upay ithway hetay creensay. Henway Alsefay, imagesay ancay ebay ixelpay-erfectpay, utbay heretay ancay ebay ixelpay umpingjay."

# game/tutorial_atl.rpy:739
translate piglatin transform_properties_4194527e:

    # "When it's set to True, movement is smoother at the cost of blurring images a little."
    "Henway itay'say etsay otay Ruetay, ovementmay isay moothersay atay hetay ostcay ofay urringblay imagesay aay ittlelay."

# game/tutorial_atl.rpy:758
translate piglatin transform_properties_35934e77:

    # e "Transforms also support polar coordinates. The around property sets the center of the coordinate system to coordinates given in pixels."
    e "Ransformstay alsoay upportsay olarpay oordinatescay. Hetay arounday ropertypay etssay hetay entercay ofay hetay oordinatecay ystemsay otay oordinatescay ivengay inay ixelspay."

# game/tutorial_atl.rpy:766
translate piglatin transform_properties_605ebd0c:

    # e "The angle property gives the angle in degrees. Angles run clockwise, with the zero angle at the top of the screen."
    e "Hetay angleay ropertypay ivesgay hetay angleay inay egreesday. Nglesaay unray ockwiseclay, ithway hetay erozay angleay atay hetay optay ofay hetay creensay."

# game/tutorial_atl.rpy:775
translate piglatin transform_properties_6d4555ed:

    # e "The radius property gives the distance in pixels from the anchor of the displayable to the center of the coordinate system."
    e "Hetay adiusray ropertypay ivesgay hetay istanceday inay ixelspay omfray hetay anchoray ofay hetay isplayableday otay hetay entercay ofay hetay oordinatecay ystemsay."

# game/tutorial_atl.rpy:789
translate piglatin transform_properties_7af037a5:

    # e "There are several ways to resize a displayable. The zoom property lets us scale a displayable by a factor, making it bigger and smaller."
    e "Heretay areay everalsay aysway otay esizeray aay isplayableday. Hetay oomzay ropertypay etslay usay calesay aay isplayableday ybay aay actorfay, akingmay itay iggerbay anday mallersay."

# game/tutorial_atl.rpy:802
translate piglatin transform_properties_b6527546:

    # e "The xzoom and yzoom properties allow the displayable to be scaled in the X and Y directions independently."
    e "Hetay zoomxay anday zoomyay ropertiespay alloway hetay isplayableday otay ebay caledsay inay hetay Xay anday Yay irectionsday independentlyay."

# game/tutorial_atl.rpy:812
translate piglatin transform_properties_b98b780b:

    # e "By making xzoom or yzoom a negative number, we can flip the image horizontally or vertically."
    e "Ybay akingmay zoomxay oray zoomyay aay egativenay umbernay, eway ancay ipflay hetay imageay orizontallyhay oray erticallyvay."

# game/tutorial_atl.rpy:822
translate piglatin transform_properties_74d542ff:

    # e "Instead of zooming by a scale factor, the size transform property can be used to scale a displayable to a size in pixels."
    e "Nsteadiay ofay oomingzay ybay aay calesay actorfay, hetay izesay ansformtray ropertypay ancay ebay useday otay calesay aay isplayableday otay aay izesay inay ixelspay."

# game/tutorial_atl.rpy:837
translate piglatin transform_properties_438ed776:

    # e "The alpha property is used to change the opacity of a displayable. This can make it appear and disappear."
    e "Hetay alphaay ropertypay isay useday otay angechay hetay opacityay ofay aay isplayableday. Histay ancay akemay itay appearay anday isappearday."

# game/tutorial_atl.rpy:850
translate piglatin transform_properties_aee19f86:

    # e "The rotate property rotates a displayable."
    e "Hetay otateray ropertypay otatesray aay isplayableday."

# game/tutorial_atl.rpy:861
translate piglatin transform_properties_57b3235a:

    # e "By default, when a displayable is rotated, Ren'Py will include extra space on all four sides, so the size doesn't change as it rotates. Here, you can see the extra space on the left and top, and it's also there on the right and bottom."
    e "Ybay efaultday, henway aay isplayableday isay otatedray, Enray'Ypay illway includeay extraay pacesay onay allay ourfay idessay, osay hetay izesay oesnday'tay angechay asay itay otatesray. Erehay, ouyay ancay eesay hetay extraay pacesay onay hetay eftlay anday optay, anday itay'say alsoay heretay onay hetay ightray anday ottombay."

# game/tutorial_atl.rpy:873
translate piglatin transform_properties_66d29ee8:

    # e "By setting rotate_pad to False, we can get rid of the space, at the cost of the size of the displayable changing as it rotates."
    e "Ybay ettingsay otate_padray otay Alsefay, eway ancay etgay idray ofay hetay pacesay, atay hetay ostcay ofay hetay izesay ofay hetay isplayableday angingchay asay itay otatesray."

# game/tutorial_atl.rpy:884
translate piglatin transform_properties_7f32e8ad:

    # e "The tile transform properties, xtile and ytile, repeat the displayable multiple times."
    e "Hetay iletay ansformtray ropertiespay, tilexay anday tileyay, epeatray hetay isplayableday ultiplemay imestay."

# game/tutorial_atl.rpy:894
translate piglatin transform_properties_207b7fc8:

    # e "The crop property crops a rectangle out of a displayable, showing only part of it."
    e "Hetay ropcay ropertypay ropscay aay ectangleray outay ofay aay isplayableday, owingshay onlyay artpay ofay itay."

# game/tutorial_atl.rpy:908
translate piglatin transform_properties_e7e22d28:

    # e "When used together, crop and size can be used to focus in on specific parts of an image."
    e "Henway useday ogethertay, ropcay anday izesay ancay ebay useday otay ocusfay inay onay pecificsay artspay ofay anay imageay."

# game/tutorial_atl.rpy:920
translate piglatin transform_properties_f34abd82:

    # e "The xpan and ypan properties can be used to pan over a displayable, given an angle in degrees, with 0 being the center."
    e "Hetay panxay anday panyay ropertiespay ancay ebay useday otay anpay overay aay isplayableday, ivengay anay angleay inay egreesday, ithway 0ay eingbay hetay entercay."

# game/tutorial_atl.rpy:927
translate piglatin transform_properties_bfa3b139:

    # e "Those are all the transform properties we have to work with. By putting them together in the right order, you can create complex things."
    e "Hosetay areay allay hetay ansformtray ropertiespay eway avehay otay orkway ithway. Ybay uttingpay hemtay ogethertay inay hetay ightray orderay, ouyay ancay reatecay omplexcay hingstay."

translate piglatin strings:

    # game/tutorial_atl.rpy:270
    old "xpos 1.0 ypos .5"
    new "posxay 1ay.0ay posyay .5ay"

    # game/tutorial_atl.rpy:270
    old "xpos .75 ypos .25"
    new "posxay .57ay posyay .52ay"

    # game/tutorial_atl.rpy:270
    old "xpos .25 ypos .33"
    new "posxay .52ay posyay .33ay"

