/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.types.TimeMap;
import org.gephi.graph.impl.FormattingAndParsingUtils;
import org.joda.time.DateTimeZone;

public abstract class TimestampMap<T>
implements TimeMap<Double, T> {
    protected double[] array;
    protected int size = 0;

    public TimestampMap() {
        this.array = new double[0];
    }

    public TimestampMap(int capacity) {
        this.array = new double[capacity];
        Arrays.fill(this.array, Double.MAX_VALUE);
    }

    protected TimestampMap(double[] keys) {
        this.array = new double[keys.length];
        System.arraycopy(keys, 0, this.array, 0, keys.length);
        this.size = keys.length;
    }

    @Override
    public boolean put(Double timestamp, T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Object values = this.getValuesArray();
        int valuesLength = Array.getLength(values);
        int index = this.putInner(timestamp);
        if (index < 0) {
            int insertIndex = -index - 1;
            if (this.size - 1 < valuesLength) {
                if (insertIndex < this.size - 1) {
                    System.arraycopy(values, insertIndex, values, insertIndex + 1, this.size - insertIndex - 1);
                }
                Array.set(values, insertIndex, value);
            } else {
                Object newArray = Array.newInstance(values.getClass().getComponentType(), valuesLength + 1);
                System.arraycopy(values, 0, newArray, 0, insertIndex);
                System.arraycopy(values, insertIndex, newArray, insertIndex + 1, valuesLength - insertIndex);
                Array.set(newArray, insertIndex, value);
                this.setValuesArray(newArray);
            }
            return true;
        }
        Array.set(values, index, value);
        return false;
    }

    @Override
    public boolean remove(Double timestamp) {
        Object values = this.getValuesArray();
        int removeIndex = this.removeInner(timestamp);
        if (removeIndex >= 0) {
            if (removeIndex != this.size) {
                System.arraycopy(values, removeIndex + 1, values, removeIndex, this.size - removeIndex);
            }
            return true;
        }
        return false;
    }

    @Override
    public T get(Double timestamp, T defaultValue) {
        int index = this.getIndex(timestamp);
        if (index >= 0) {
            return this.getValue(index);
        }
        return defaultValue;
    }

    @Override
    public Object get(Interval interval, Estimator estimator) {
        if (!this.isSupported(estimator)) {
            throw new UnsupportedOperationException("Not supported estimator.");
        }
        switch (estimator) {
            case AVERAGE: {
                return this.getAverage(interval);
            }
            case MIN: {
                return this.getMin(interval);
            }
            case MAX: {
                return this.getMax(interval);
            }
            case FIRST: {
                return this.getFirst(interval);
            }
            case LAST: {
                return this.getLast(interval);
            }
        }
        throw new UnsupportedOperationException("Not supported estimator.");
    }

    @Override
    public T[] toValuesArray() {
        Object values = this.getValuesArray();
        int length = Array.getLength(values);
        if (values.getClass().getComponentType().isPrimitive() || this.size < length) {
            Object[] res = (Object[])Array.newInstance(this.getTypeClass(), this.size);
            for (int i = 0; i < this.size; ++i) {
                res[i] = Array.get(values, i);
            }
            return res;
        }
        return (Object[])values;
    }

    protected Object toPrimitiveArray() {
        Object values = this.getValuesArray();
        int length = Array.getLength(values);
        if (this.size < length - 1) {
            Object res = Array.newInstance(values.getClass().getComponentType(), this.size);
            System.arraycopy(values, 0, res, 0, this.size);
            return res;
        }
        return values;
    }

    @Override
    public abstract Class<T> getTypeClass();

    @Override
    public abstract boolean isSupported(Estimator var1);

    protected abstract T getValue(int var1);

    protected abstract Object getValuesArray();

    protected abstract void setValuesArray(Object var1);

    protected int putInner(double timestamp) {
        int index = Arrays.binarySearch(this.array, 0, this.size, timestamp);
        if (index < 0) {
            int insertIndex = -index - 1;
            if (this.size < this.array.length) {
                if (insertIndex < this.size) {
                    System.arraycopy(this.array, insertIndex, this.array, insertIndex + 1, this.size - insertIndex);
                }
                this.array[insertIndex] = timestamp;
            } else {
                double[] newArray = new double[this.array.length + 1];
                System.arraycopy(this.array, 0, newArray, 0, insertIndex);
                System.arraycopy(this.array, insertIndex, newArray, insertIndex + 1, this.array.length - insertIndex);
                newArray[insertIndex] = timestamp;
                this.array = newArray;
            }
            ++this.size;
        }
        return index;
    }

    protected int removeInner(double timestamp) {
        int index = Arrays.binarySearch(this.array, 0, this.size, timestamp);
        if (index >= 0) {
            int removeIndex = index;
            if (removeIndex == this.size - 1) {
                --this.size;
            } else {
                System.arraycopy(this.array, removeIndex + 1, this.array, removeIndex, this.size - removeIndex - 1);
                --this.size;
            }
            return removeIndex;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    protected int getIndex(double timestamp) {
        return Arrays.binarySearch(this.array, 0, this.size, timestamp);
    }

    protected int[] getOverlappingTimestamps(double intervalStart, double intervalEnd) {
        int index = Arrays.binarySearch(this.array, 0, this.size, intervalStart);
        int n = index = index >= 0 ? index : -index - 1;
        if (index < this.size) {
            int[] res = new int[this.size - index];
            int i = 0;
            while (index < this.size && this.array[index] <= intervalEnd) {
                res[i++] = index++;
            }
            if (res.length != i) {
                return Arrays.copyOf(res, i);
            }
            return res;
        }
        return new int[0];
    }

    @Override
    public boolean contains(Double timestamp) {
        return this.getIndex(timestamp) >= 0;
    }

    public double[] getTimestamps() {
        if (this.size < this.array.length) {
            double[] res = new double[this.size];
            System.arraycopy(this.array, 0, res, 0, this.size);
            return res;
        }
        return this.array;
    }

    public Double[] toKeysArray() {
        Double[] res = new Double[this.size];
        for (int i = 0; i < this.size; ++i) {
            res[i] = this.array[i];
        }
        return res;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.array = new double[0];
        this.setValuesArray(Array.newInstance(this.getValuesArray().getClass().getComponentType(), 0));
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.size;
        for (int i = 0; i < this.size; ++i) {
            double t = this.array[i];
            hash = 29 * hash + (int)(Double.doubleToLongBits(t) ^ Double.doubleToLongBits(t) >>> 32);
            T obj = this.getValue(i);
            hash = 29 * hash + obj.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimestampMap other = (TimestampMap)obj;
        if (this.size != other.size) {
            return false;
        }
        for (int i = 0; i < this.array.length && i < other.array.length; ++i) {
            double i1 = this.array[i];
            double i2 = other.array[i];
            if (i1 != i2) {
                return false;
            }
            T o1 = this.getValue(i);
            T o2 = other.getValue(i);
            if (!(o1 == null && o2 != null || o1 != null && o2 == null) && (o1 == null || o2 == null || o1.equals(o2))) continue;
            return false;
        }
        return true;
    }

    protected Object getFirst(Interval interval) {
        if (this.size == 0) {
            return null;
        }
        int[] timestamps = this.getOverlappingTimestamps(interval.getLow(), interval.getHigh());
        if (timestamps.length == 0) {
            return null;
        }
        return this.getValue(timestamps[0]);
    }

    protected Object getLast(Interval interval) {
        if (this.size == 0) {
            return null;
        }
        int[] timestamps = this.getOverlappingTimestamps(interval.getLow(), interval.getHigh());
        if (timestamps.length == 0) {
            return null;
        }
        return this.getValue(timestamps[timestamps.length - 1]);
    }

    protected Object getMin(Interval interval) {
        Double min = this.getMinDouble(interval);
        return min != null ? Double.valueOf(min) : null;
    }

    protected Double getMinDouble(Interval interval) {
        if (this.size == 0) {
            return null;
        }
        int[] timestamps = this.getOverlappingTimestamps(interval.getLow(), interval.getHigh());
        if (timestamps.length == 0) {
            return null;
        }
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < timestamps.length; ++i) {
            double val = ((Number)this.getValue(timestamps[i])).doubleValue();
            min = Math.min(val, min);
        }
        return min;
    }

    protected Object getMax(Interval interval) {
        Double max = this.getMaxDouble(interval);
        return max != null ? Double.valueOf(max) : null;
    }

    protected Double getMaxDouble(Interval interval) {
        if (this.size == 0) {
            return null;
        }
        int[] timestamps = this.getOverlappingTimestamps(interval.getLow(), interval.getHigh());
        if (timestamps.length == 0) {
            return null;
        }
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < timestamps.length; ++i) {
            double val = ((Number)this.getValue(timestamps[i])).doubleValue();
            max = Math.max(val, max);
        }
        return max;
    }

    protected Object getAverage(Interval interval) {
        BigDecimal average = this.getAverageBigDecimal(interval);
        return average != null ? Double.valueOf(average.doubleValue()) : null;
    }

    protected BigDecimal getAverageBigDecimal(Interval interval) {
        if (this.size == 0) {
            return null;
        }
        int[] timestamps = this.getOverlappingTimestamps(interval.getLow(), interval.getHigh());
        if (timestamps.length == 0) {
            return null;
        }
        if (timestamps.length == 1) {
            return new BigDecimal(((Number)this.getValue(timestamps[0])).doubleValue());
        }
        BigDecimal result = new BigDecimal(0.0);
        BigDecimal period = new BigDecimal(0.0);
        BigDecimal two = new BigDecimal(2.0);
        for (int i = 1; i < timestamps.length; ++i) {
            BigDecimal p = new BigDecimal(this.array[timestamps[i]] - this.array[timestamps[i - 1]]);
            period = period.add(p);
            BigDecimal lowVal = new BigDecimal(((Number)this.getValue(timestamps[i - 1])).doubleValue());
            BigDecimal highVal = new BigDecimal(((Number)this.getValue(timestamps[i])).doubleValue());
            result = result.add(lowVal.add(highVal).divide(two).multiply(p));
        }
        return result.divide(period, 10, RoundingMode.HALF_EVEN);
    }

    protected Double getAverageDouble(Interval interval) {
        if (this.size == 0) {
            return null;
        }
        int[] timestamps = this.getOverlappingTimestamps(interval.getLow(), interval.getHigh());
        if (timestamps.length == 0) {
            return null;
        }
        if (timestamps.length == 1) {
            return ((Number)this.getValue(timestamps[0])).doubleValue();
        }
        double result = 0.0;
        double period = 0.0;
        for (int i = 1; i < timestamps.length; ++i) {
            double p = this.array[timestamps[i]] - this.array[timestamps[i - 1]];
            period += p;
            double lowVal = ((Number)this.getValue(timestamps[i - 1])).doubleValue();
            double highVal = ((Number)this.getValue(timestamps[i])).doubleValue();
            result += p * (lowVal + highVal) / 2.0;
        }
        return result / period;
    }

    @Override
    public String toString(TimeFormat timeFormat, DateTimeZone timeZone) {
        if (this.size == 0) {
            return "<empty>";
        }
        T[] values = this.toValuesArray();
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        for (int i = 0; i < this.size; ++i) {
            sb.append('[');
            sb.append(AttributeUtils.printTimestampInFormat(this.array[i], timeFormat, timeZone));
            sb.append(", ");
            String stringValue = values[i].toString();
            if (FormattingAndParsingUtils.containsDynamicSpecialCharacters(stringValue) || stringValue.trim().isEmpty()) {
                sb.append('\"');
                sb.append(stringValue.replace("\\", "\\\\").replace("\"", "\\\""));
                sb.append('\"');
            } else {
                sb.append(stringValue);
            }
            sb.append(']');
            if (i >= this.size - 1) continue;
            sb.append("; ");
        }
        sb.append('>');
        return sb.toString();
    }

    @Override
    public String toString(TimeFormat timeFormat) {
        return this.toString(timeFormat, null);
    }

    public String toString() {
        return this.toString(TimeFormat.DOUBLE, null);
    }
}

