/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVFunctionSys;
import mediathek.tool.javafx.FXErrorDialog;
import okio.BufferedSink;
import okio.Okio;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lmediathek/gui/actions/SetAppMemoryAction;", "Ljavax/swing/AbstractAction;", "()V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "Companion", "MediathekView"})
public final class SetAppMemoryAction
extends AbstractAction {
    private static final String WIN_VMOPTIONS_FILE = "MediathekView.vmoptions";
    private static final String MAC_VMOPTIONS_FILE;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(@NotNull ActionEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        String fileName = null;
        Path optionsPath = null;
        if (SystemUtils.IS_OS_MAC_OSX) {
            fileName = MAC_VMOPTIONS_FILE;
            Path path = Paths.get(fileName, new String[0]);
            Intrinsics.checkNotNullExpressionValue(path, "Paths.get(fileName)");
            optionsPath = path;
            if (Files.notExists(optionsPath, new LinkOption[0])) {
                try {
                    Closeable closeable = Okio.buffer(Okio.sink(optionsPath, new OpenOption[0]));
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        BufferedSink sink2 = (BufferedSink)closeable;
                        boolean bl3 = false;
                        sink2.writeUtf8("### SEIEN SIE VORSICHTIG! FEHLERHAFTE EINTR\u00c4GE VERHINDERN DEN START DER ANWENDUNG!\n");
                        BufferedSink bufferedSink = sink2.writeUtf8("-Xmx2G");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                }
                catch (IOException ex) {
                    logger.error(ex);
                    FXErrorDialog.showErrorDialogWithoutParent("MediathekView", "Schreibvorgang fehlgeschlagen", StringsKt.trimIndent("\n                                Die Datei '" + optionsPath.normalize().toAbsolutePath() + "' konnte nicht geschrieben werden.\n                                Bitte wenden Sie sich bei Fragen an das Forum!\n                                "), ex);
                }
            }
        } else {
            fileName = WIN_VMOPTIONS_FILE;
            Path path = Paths.get(MVFunctionSys.getPathToApplicationJar(), fileName);
            Intrinsics.checkNotNullExpressionValue(path, "Paths.get(MVFunctionSys.\u2026plicationJar(), fileName)");
            optionsPath = path;
        }
        String fileStr = ((Object)optionsPath.normalize().toAbsolutePath()).toString();
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(optionsPath.normalize().toAbsolutePath().toFile());
            }
            catch (Exception ex) {
                logger.error("Failed to open vm options file", (Throwable)ex);
                FXErrorDialog.showErrorDialogWithoutParent("MediathekView", "Datei konnte nicht ge\u00f6ffnet werden", "Es trat ein Fehler beim \u00d6ffnen der Datei auf.\nDiese Funktion wird nur durch die offiziellen MediathekView-Apps unterst\u00fctzt.\nBitte wenden Sie sich mit dem unten sichtbaren Fehler an das Forum.", ex);
            }
        } else {
            logger.error("Desktop is not supported");
            JOptionPane.showMessageDialog(MediathekGui.ui(), "<html>Datei konnte nicht ge\u00f6ffnet werden, da Java auf Ihrem System das \u00d6ffnen nicht unterst\u00fctzt.<br>Bitte bearbeiten Sie manuell die Datei '" + fileStr + "'</html>");
        }
    }

    public SetAppMemoryAction() {
        this.putValue("Name", "Speicherzuweisung \u00e4ndern...");
    }

    static {
        Companion = new Companion(null);
        MAC_VMOPTIONS_FILE = GuiFunktionen.getHomePath() + File.separator + ".mediathek3" + File.separator + "MediathekView_vmoptions.txt";
        logger = LogManager.getLogger();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lmediathek/gui/actions/SetAppMemoryAction$Companion;", "", "()V", "MAC_VMOPTIONS_FILE", "", "WIN_VMOPTIONS_FILE", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

