/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages;

import cc.arduino.contributions.DownloadableContribution;
import cc.arduino.contributions.packages.ContributedBoard;
import cc.arduino.contributions.packages.ContributedHelp;
import cc.arduino.contributions.packages.ContributedPackage;
import cc.arduino.contributions.packages.ContributedTool;
import cc.arduino.contributions.packages.ContributedToolReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ContributedPlatform
extends DownloadableContribution {
    private String url;
    private String version;
    private long size;
    private String archiveFileName;
    private String name;
    private String category;
    private String architecture;
    private String checksum;
    private ArrayList<ContributedToolReference> toolsDependencies = new ArrayList();
    private ArrayList<ContributedBoard> boards = new ArrayList();
    private ContributedHelp help;
    private boolean installed;
    private File installedFolder;
    private boolean builtIn;
    private Map<ContributedToolReference, ContributedTool> resolvedToolReferences;
    private ContributedPackage parentPackage;
    public static final Comparator<ContributedPlatform> BUILTIN_AS_LAST = (x, y) -> {
        int px = x.isBuiltIn() ? 1 : -1;
        int py = y.isBuiltIn() ? 1 : -1;
        return px - py;
    };

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getArchiveFileName() {
        return this.archiveFileName;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    @Override
    public String getChecksum() {
        return this.checksum;
    }

    public List<ContributedToolReference> getToolsDependencies() {
        return this.toolsDependencies;
    }

    public List<ContributedBoard> getBoards() {
        return this.boards;
    }

    public ContributedHelp getHelp() {
        return this.help;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public File getInstalledFolder() {
        return this.installedFolder;
    }

    public void setInstalledFolder(File installedFolder) {
        this.installedFolder = installedFolder;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public void setBuiltIn(boolean builtIn) {
        this.builtIn = builtIn;
    }

    public List<ContributedTool> getResolvedTools() {
        return new LinkedList<ContributedTool>(this.resolvedToolReferences.values());
    }

    @JsonIgnore
    public Map<ContributedToolReference, ContributedTool> getResolvedToolReferences() {
        return this.resolvedToolReferences;
    }

    public void resolveToolsDependencies(Collection<ContributedPackage> packages) {
        this.resolvedToolReferences = new HashMap<ContributedToolReference, ContributedTool>();
        if (this.getToolsDependencies() == null) {
            return;
        }
        for (ContributedToolReference dep : this.getToolsDependencies()) {
            ContributedTool tool = dep.resolve(packages);
            if (tool == null) {
                System.err.println("Index error: could not find referenced tool " + dep);
                continue;
            }
            this.resolvedToolReferences.put(dep, tool);
        }
    }

    public ContributedPackage getParentPackage() {
        return this.parentPackage;
    }

    public void setParentPackage(ContributedPackage parentPackage) {
        this.parentPackage = parentPackage;
    }

    public String toString() {
        return this.getParsedVersion();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContributedPlatform)) {
            return false;
        }
        ContributedPlatform obj1 = (ContributedPlatform)obj;
        ContributedPackage parent = this.getParentPackage();
        ContributedPackage parent1 = obj1.getParentPackage();
        if (parent == null) {
            if (parent1 != null) {
                return false;
            }
        } else {
            if (parent1 == null) {
                return false;
            }
            if (!parent.getName().equals(parent1.getName())) {
                return false;
            }
        }
        if (!this.getArchitecture().equals(obj1.getArchitecture())) {
            return false;
        }
        if (!this.getVersion().equals(obj1.getVersion())) {
            return false;
        }
        return this.getName().equals(obj1.getName());
    }
}

