/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

public final class CheckTypeImportCodeReferences
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    public static final DiagnosticType TYPE_IMPORT_CODE_REFERENCE = DiagnosticType.error("JSC_TYPE_IMPORT_CODE_REFERENCE", "Cannot reference goog.requireType()''d name {0} outside of a type annotation.");
    private static final Node GOOG_REQUIRE_TYPE = IR.getprop(IR.name("goog"), IR.string("requireType"));
    private final AbstractCompiler compiler;

    public CheckTypeImportCodeReferences(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        Node decl;
        if (!n.isName()) {
            return;
        }
        Var var = (Var)t.getScope().getVar(n.getString());
        if (var == null) {
            return;
        }
        Node declNameNode = var.getNameNode();
        if (declNameNode == null || declNameNode == n || !NodeUtil.isDeclarationLValue(declNameNode)) {
            return;
        }
        Node node = decl = declNameNode.getParent().isStringKey() ? declNameNode.getGrandparent().getGrandparent() : declNameNode.getParent();
        if (!(NodeUtil.isNameDeclaration(decl) && decl.hasOneChild() && decl.getFirstChild().hasChildren() && decl.getFirstChild().getLastChild().isCall())) {
            return;
        }
        Node callNode = decl.getFirstChild().getLastChild();
        if (!callNode.getFirstChild().matchesQualifiedName(GOOG_REQUIRE_TYPE)) {
            return;
        }
        t.report(n, TYPE_IMPORT_CODE_REFERENCE, n.getString());
    }
}

