/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolymerBehaviorExtractor;
import com.google.javascript.jscomp.PolymerPass;
import com.google.javascript.jscomp.PolymerPassErrors;
import com.google.javascript.jscomp.PolymerPassStaticUtils;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class PolymerClassDefinition {
    final DefinitionType defType;
    final Node definition;
    final Node target;
    final boolean hasGeneratedLhs;
    final Node descriptor;
    final PolymerPass.MemberDefinition constructor;
    @Nullable
    final String nativeBaseElement;
    final List<PolymerPass.MemberDefinition> props;
    final Map<PolymerPass.MemberDefinition, PolymerBehaviorExtractor.BehaviorDefinition> behaviorProps;
    @Nullable
    final List<PolymerPass.MemberDefinition> methods;
    @Nullable
    final ImmutableList<PolymerBehaviorExtractor.BehaviorDefinition> behaviors;
    @Nullable
    final FeatureSet features;
    private String interfaceName = null;

    PolymerClassDefinition(DefinitionType defType, Node definition, Node target, boolean hasGeneratedLhs, Node descriptor, JSDocInfo classInfo, PolymerPass.MemberDefinition constructor, String nativeBaseElement, List<PolymerPass.MemberDefinition> props, Map<PolymerPass.MemberDefinition, PolymerBehaviorExtractor.BehaviorDefinition> behaviorProps, List<PolymerPass.MemberDefinition> methods, ImmutableList<PolymerBehaviorExtractor.BehaviorDefinition> behaviors, FeatureSet features) {
        this.defType = defType;
        this.definition = definition;
        this.target = target;
        this.hasGeneratedLhs = hasGeneratedLhs;
        Preconditions.checkState(descriptor == null || descriptor.isObjectLit());
        this.descriptor = descriptor;
        this.constructor = constructor;
        this.nativeBaseElement = nativeBaseElement;
        this.props = props;
        this.behaviorProps = behaviorProps;
        this.methods = methods;
        this.behaviors = behaviors;
        this.features = features;
    }

    @Nullable
    static PolymerClassDefinition extractFromCallNode(Node callNode, AbstractCompiler compiler, ModuleMetadataMap.ModuleMetadata moduleMetadata, PolymerBehaviorExtractor behaviorExtractor) {
        Node target;
        Node descriptor = NodeUtil.getArgumentForCallOrNew(callNode, 0);
        if (descriptor == null || !descriptor.isObjectLit()) {
            compiler.report(JSError.make(callNode, PolymerPassErrors.POLYMER_DESCRIPTOR_NOT_VALID, new String[0]));
            return null;
        }
        int paramCount = callNode.getChildCount() - 1;
        if (paramCount != 1) {
            compiler.report(JSError.make(callNode, PolymerPassErrors.POLYMER_UNEXPECTED_PARAMS, new String[0]));
            return null;
        }
        Node elName = NodeUtil.getFirstPropMatchingKey(descriptor, "is");
        if (elName == null) {
            compiler.report(JSError.make(callNode, PolymerPassErrors.POLYMER_MISSING_IS, new String[0]));
            return null;
        }
        boolean hasGeneratedLhs = false;
        if (NodeUtil.isNameDeclaration(callNode.getGrandparent())) {
            target = IR.name(callNode.getParent().getString());
        } else if (callNode.getParent().isAssign()) {
            target = PolymerClassDefinition.isGoogModuleExports(callNode.getParent()) ? PolymerClassDefinition.createDummyGoogModuleExportsTarget(compiler, callNode) : callNode.getParent().getFirstChild().cloneTree();
        } else {
            String elNameStringBase = elName.isQualifiedName() ? elName.getQualifiedName().replace('.', '$') : elName.getString();
            String elNameString = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, elNameStringBase);
            elNameString = elNameString + "Element";
            target = IR.name(elNameString);
            hasGeneratedLhs = true;
        }
        JSDocInfo classInfo = NodeUtil.getBestJSDocInfo(target);
        JSDocInfo ctorInfo = null;
        Node constructor = NodeUtil.getFirstPropMatchingKey(descriptor, "factoryImpl");
        if (constructor == null) {
            constructor = NodeUtil.emptyFunction();
            compiler.reportChangeToChangeScope(constructor);
            constructor.useSourceInfoFromForTree(callNode);
        } else {
            ctorInfo = NodeUtil.getBestJSDocInfo(constructor);
        }
        Node baseClass = NodeUtil.getFirstPropMatchingKey(descriptor, "extends");
        String nativeBaseElement = baseClass == null ? null : baseClass.getString();
        Node behaviorArray = NodeUtil.getFirstPropMatchingKey(descriptor, "behaviors");
        ImmutableList<PolymerBehaviorExtractor.BehaviorDefinition> behaviors = behaviorExtractor.extractBehaviors(behaviorArray, moduleMetadata);
        ArrayList<PolymerPass.MemberDefinition> properties = new ArrayList<PolymerPass.MemberDefinition>();
        LinkedHashMap<PolymerPass.MemberDefinition, PolymerBehaviorExtractor.BehaviorDefinition> behaviorProps = new LinkedHashMap<PolymerPass.MemberDefinition, PolymerBehaviorExtractor.BehaviorDefinition>();
        for (PolymerBehaviorExtractor.BehaviorDefinition behavior : behaviors) {
            for (PolymerPass.MemberDefinition prop : behavior.props) {
                behaviorProps.put(prop, behavior);
            }
        }
        PolymerClassDefinition.overwriteMembersIfPresent(properties, PolymerPassStaticUtils.extractProperties(descriptor, DefinitionType.ObjectLiteral, compiler, null));
        PolymerClassDefinition.removeDuplicateBehaviorProps(behaviorProps);
        PolymerClassDefinition.removeBehaviorPropsOverlappingWithElementProps(behaviorProps, properties);
        FeatureSet newFeatures = null;
        if (!behaviors.isEmpty()) {
            newFeatures = ((PolymerBehaviorExtractor.BehaviorDefinition)behaviors.get((int)0)).features;
            for (int i = 1; i < behaviors.size(); ++i) {
                newFeatures = newFeatures.union(((PolymerBehaviorExtractor.BehaviorDefinition)behaviors.get((int)i)).features);
            }
        }
        ArrayList<PolymerPass.MemberDefinition> methods = new ArrayList<PolymerPass.MemberDefinition>();
        for (Node keyNode : descriptor.children()) {
            boolean isFunctionDefinition = keyNode.isMemberFunctionDef() || keyNode.isStringKey() && keyNode.getFirstChild().isFunction();
            if (!isFunctionDefinition) continue;
            methods.add(new PolymerPass.MemberDefinition(NodeUtil.getBestJSDocInfo(keyNode), keyNode, keyNode.getFirstChild()));
        }
        return new PolymerClassDefinition(DefinitionType.ObjectLiteral, callNode, target, hasGeneratedLhs, descriptor, classInfo, new PolymerPass.MemberDefinition(ctorInfo, null, constructor), nativeBaseElement, properties, behaviorProps, methods, behaviors, newFeatures);
    }

    private static boolean isGoogModuleExports(Node assign) {
        if (!assign.getParent().isExprResult() || !assign.getFirstChild().matchesName("exports")) {
            return false;
        }
        Node containingBlock = assign.getGrandparent();
        return containingBlock.isModuleBody() && containingBlock.getParent().getBooleanProp(Node.GOOG_MODULE) || NodeUtil.isBundledGoogModuleScopeRoot(containingBlock);
    }

    private static Node createDummyGoogModuleExportsTarget(AbstractCompiler compiler, Node callNode) {
        String madeUpName = "exportsForPolymer$jscomp" + compiler.getUniqueNameIdSupplier().get();
        Node assignExpr = callNode.getGrandparent();
        Node moduleBody = assignExpr.getParent();
        Node exportName = callNode.getParent().getFirstChild();
        Node target = IR.name(madeUpName).clonePropsFrom(exportName).srcref(exportName);
        callNode.replaceWith(target);
        Node newDecl = IR.var(target.cloneNode(), callNode).srcref(assignExpr);
        moduleBody.addChildBefore(newDecl, assignExpr);
        newDecl.setJSDocInfo(assignExpr.getJSDocInfo());
        assignExpr.setJSDocInfo(null);
        return target;
    }

    @Nullable
    static PolymerClassDefinition extractFromClassNode(Node classNode, AbstractCompiler compiler, GlobalNamespace globalNames) {
        Node target;
        Preconditions.checkState(classNode != null && classNode.isClass());
        Node propertiesDescriptor = null;
        Node propertiesGetter = NodeUtil.getFirstGetterMatchingKey(NodeUtil.getClassMembers(classNode), "properties");
        if (propertiesGetter != null) {
            if (!propertiesGetter.isStaticMember()) {
                compiler.report(JSError.make(classNode, PolymerPassErrors.POLYMER_CLASS_PROPERTIES_NOT_STATIC, new String[0]));
            } else {
                for (Node child : NodeUtil.getFunctionBody(propertiesGetter.getFirstChild()).children()) {
                    if (!child.isReturn()) continue;
                    if (child.hasChildren() && child.getFirstChild().isObjectLit()) {
                        propertiesDescriptor = child.getFirstChild();
                        break;
                    }
                    compiler.report(JSError.make(propertiesGetter, PolymerPassErrors.POLYMER_CLASS_PROPERTIES_INVALID, new String[0]));
                }
            }
        }
        if (NodeUtil.isNameDeclaration(classNode.getGrandparent())) {
            target = IR.name(classNode.getParent().getString());
        } else if (classNode.getParent().isAssign() && classNode.getParent().getFirstChild().isQualifiedName()) {
            target = classNode.getParent().getFirstChild();
        } else if (!classNode.getFirstChild().isEmpty()) {
            target = classNode.getFirstChild();
        } else {
            compiler.report(JSError.make(classNode, PolymerPassErrors.POLYMER_CLASS_UNNAMED, new String[0]));
            return null;
        }
        JSDocInfo classInfo = NodeUtil.getBestJSDocInfo(classNode);
        JSDocInfo ctorInfo = null;
        Node constructor = NodeUtil.getEs6ClassConstructorMemberFunctionDef(classNode);
        if (constructor != null) {
            ctorInfo = NodeUtil.getBestJSDocInfo(constructor);
        }
        ImmutableList<PolymerPass.MemberDefinition> properties = PolymerPassStaticUtils.extractProperties(propertiesDescriptor, DefinitionType.ES6Class, compiler, constructor);
        ArrayList<PolymerPass.MemberDefinition> methods = new ArrayList<PolymerPass.MemberDefinition>();
        for (Node keyNode : NodeUtil.getClassMembers(classNode).children()) {
            if (!keyNode.isMemberFunctionDef()) continue;
            methods.add(new PolymerPass.MemberDefinition(NodeUtil.getBestJSDocInfo(keyNode), keyNode, keyNode.getFirstChild()));
        }
        return new PolymerClassDefinition(DefinitionType.ES6Class, classNode, target, false, propertiesDescriptor, classInfo, new PolymerPass.MemberDefinition(ctorInfo, null, constructor), null, properties, null, methods, null, null);
    }

    private static void overwriteMembersIfPresent(List<PolymerPass.MemberDefinition> list, List<PolymerPass.MemberDefinition> newMembers) {
        for (PolymerPass.MemberDefinition newMember : newMembers) {
            for (PolymerPass.MemberDefinition member : list) {
                if (!member.name.getString().equals(newMember.name.getString())) continue;
                list.remove(member);
                break;
            }
            list.add(newMember);
        }
    }

    private static void removeDuplicateBehaviorProps(Map<PolymerPass.MemberDefinition, PolymerBehaviorExtractor.BehaviorDefinition> behaviorProps) {
        if (behaviorProps == null) {
            return;
        }
        Iterator<Map.Entry<PolymerPass.MemberDefinition, PolymerBehaviorExtractor.BehaviorDefinition>> behaviorsItr = behaviorProps.entrySet().iterator();
        HashSet<String> seen = new HashSet<String>();
        while (behaviorsItr.hasNext()) {
            PolymerPass.MemberDefinition memberDefinition = behaviorsItr.next().getKey();
            String propertyName = memberDefinition.name.getString();
            if (seen.add(propertyName)) continue;
            behaviorsItr.remove();
        }
    }

    private static void removeBehaviorPropsOverlappingWithElementProps(Map<PolymerPass.MemberDefinition, PolymerBehaviorExtractor.BehaviorDefinition> behaviorProps, List<PolymerPass.MemberDefinition> polymerElementProps) {
        if (behaviorProps == null) {
            return;
        }
        Set elementPropNames = polymerElementProps.stream().map(x -> x.name.getString()).collect(Collectors.toSet());
        Iterator<Map.Entry<PolymerPass.MemberDefinition, PolymerBehaviorExtractor.BehaviorDefinition>> behaviorsItr = behaviorProps.entrySet().iterator();
        while (behaviorsItr.hasNext()) {
            PolymerPass.MemberDefinition memberDefinition = behaviorsItr.next().getKey();
            if (!elementPropNames.contains(memberDefinition.name.getString())) continue;
            behaviorsItr.remove();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("defType", (Object)this.defType).add("definition", this.definition).add("target", this.target).add("nativeBaseElement", this.nativeBaseElement).omitNullValues().toString();
    }

    String getInterfaceName(Supplier<String> uniqueIdSupplier) {
        if (this.interfaceName == null) {
            this.interfaceName = "Polymer" + this.target.getQualifiedName().replace('.', '_') + "Interface" + uniqueIdSupplier.get();
        }
        return this.interfaceName;
    }

    static enum DefinitionType {
        ObjectLiteral,
        ES6Class;

    }
}

