/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.Altitude;
import tim.prune.data.AltitudeRange;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Timestamp;
import tim.prune.data.Track;
import tim.prune.data.UnitSetLibrary;

public class RangeStats {
    private int _numPoints = 0;
    private int _numSegments = 0;
    private boolean _foundTrackPoint = false;
    protected AltitudeRange _totalAltitudeRange = new AltitudeRange();
    protected AltitudeRange _movingAltitudeRange = new AltitudeRange();
    private Timestamp _earliestTimestamp = null;
    private Timestamp _latestTimestamp = null;
    private long _movingMilliseconds = 0L;
    private boolean _timesIncomplete = false;
    private boolean _timesOutOfSequence = false;
    protected double _totalDistanceRads = 0.0;
    protected double _movingDistanceRads = 0.0;
    protected DataPoint _prevPoint = null;

    public RangeStats() {
    }

    public RangeStats(Track track, int n, int n2) {
        this.populateFromTrack(track, n, n2);
    }

    protected void populateFromTrack(Track track, int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            this.addPoint(track.getPoint(n3));
            ++n3;
        }
    }

    public void addPoint(DataPoint dataPoint) {
        if (dataPoint == null) {
            return;
        }
        ++this._numPoints;
        if (dataPoint.isWaypoint()) {
            return;
        }
        if (dataPoint.getSegmentStart() || !this._foundTrackPoint) {
            ++this._numSegments;
        }
        this._foundTrackPoint = true;
        if (this._prevPoint != null) {
            double d = DataPoint.calculateRadiansBetween(this._prevPoint, dataPoint);
            this._totalDistanceRads += d;
            if (!dataPoint.getSegmentStart()) {
                this._movingDistanceRads += d;
            }
        }
        if (dataPoint.hasTimestamp()) {
            Timestamp timestamp = dataPoint.getTimestamp();
            if (this._earliestTimestamp == null || timestamp.isBefore(this._earliestTimestamp)) {
                this._earliestTimestamp = timestamp;
            }
            if (this._latestTimestamp == null || timestamp.isAfter(this._latestTimestamp)) {
                this._latestTimestamp = timestamp;
            }
            if (!dataPoint.getSegmentStart() && this._prevPoint != null && this._prevPoint.hasTimestamp()) {
                long l = timestamp.getMillisecondsSince(this._prevPoint.getTimestamp());
                if (l < 0L) {
                    this._timesOutOfSequence = true;
                } else {
                    this._movingMilliseconds += l;
                }
            }
        } else {
            this._timesIncomplete = true;
        }
        if (dataPoint.hasAltitude()) {
            Altitude altitude = dataPoint.getAltitude();
            this._totalAltitudeRange.addValue(altitude);
            if (dataPoint.getSegmentStart()) {
                this._movingAltitudeRange.ignoreValue(altitude);
            } else {
                this._movingAltitudeRange.addValue(altitude);
            }
        }
        this.doFurtherCalculations(dataPoint);
        this._prevPoint = dataPoint;
    }

    protected void doFurtherCalculations(DataPoint dataPoint) {
    }

    public int getNumPoints() {
        return this._numPoints;
    }

    public int getNumSegments() {
        return this._numSegments;
    }

    public AltitudeRange getTotalAltitudeRange() {
        return this._totalAltitudeRange;
    }

    public AltitudeRange getMovingAltitudeRange() {
        return this._movingAltitudeRange;
    }

    public Timestamp getEarliestTimestamp() {
        return this._earliestTimestamp;
    }

    public Timestamp getLatestTimestamp() {
        return this._latestTimestamp;
    }

    public long getTotalDurationInSeconds() {
        if (this._earliestTimestamp != null && this._latestTimestamp != null) {
            return this._latestTimestamp.getSecondsSince(this._earliestTimestamp);
        }
        return 0L;
    }

    public long getMovingDurationInSeconds() {
        return this._movingMilliseconds / 1000L;
    }

    public boolean getTimestampsIncomplete() {
        return this._timesIncomplete;
    }

    public boolean getTimestampsOutOfSequence() {
        return this._timesOutOfSequence;
    }

    public double getTotalDistance() {
        return Distance.convertRadiansToDistance(this._totalDistanceRads);
    }

    public double getMovingDistance() {
        return Distance.convertRadiansToDistance(this._movingDistanceRads);
    }

    public double getMovingDistanceKilometres() {
        return Distance.convertRadiansToDistance(this._movingDistanceRads, UnitSetLibrary.UNITS_KILOMETRES);
    }

    public double getTotalVerticalSpeed() {
        long l = this.getTotalDurationInSeconds();
        if (l > 0L && this._totalAltitudeRange.hasRange()) {
            return this._totalAltitudeRange.getMetricHeightDiff() / (double)l;
        }
        return 0.0;
    }

    public double getMovingVerticalSpeed() {
        long l = this.getMovingDurationInSeconds();
        if (l > 0L && this._movingAltitudeRange.hasRange()) {
            return this._movingAltitudeRange.getMetricHeightDiff() / (double)l;
        }
        return 0.0;
    }
}

