/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Area;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.ChangePropertyKeyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagCheckerAsserts;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleIndex;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.MapCSSParser;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.ParseException;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.TokenMgrError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.FileWatcher;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Stopwatch;
import org.openstreetmap.josm.tools.Utils;

public class MapCSSTagChecker
extends Test.TagTest {
    private MapCSSStyleIndex indexData;
    private final Map<MapCSSRule, MapCSSTagCheckerAndRule> ruleToCheckMap = new HashMap<MapCSSRule, MapCSSTagCheckerAndRule>();
    private static final Map<IPrimitive, Area> mpAreaCache = new HashMap<IPrimitive, Area>();
    static final boolean ALL_TESTS = true;
    static final boolean ONLY_SELECTED_TESTS = false;
    public static final String ENTRIES_PREF_KEY = "validator." + MapCSSTagChecker.class.getName() + ".entries";
    final MultiMap<String, TagCheck> checks = new MultiMap();
    private final Map<String, String> urlTitles = new HashMap<String, String>();

    public MapCSSTagChecker() {
        super(I18n.tr("Tag checker (MapCSS based)", new Object[0]), I18n.tr("This test checks for errors in tag keys and values.", new Object[0]));
    }

    static MapCSSStyleIndex createMapCSSTagCheckerIndex(MultiMap<String, TagCheck> checks, boolean includeOtherSeverity, boolean allTests) {
        MapCSSStyleIndex index = new MapCSSStyleIndex();
        Stream<MapCSSRule> ruleStream = checks.values().stream().flatMap(Collection::stream).filter(c -> includeOtherSeverity || Severity.OTHER != c.getSeverity() || !c.setClassExpressions.isEmpty()).filter(c -> {
            if (allTests) return true;
            if (!c.rule.selectors.stream().anyMatch(Selector.ChildOrParentSelector.class::isInstance)) return false;
            return true;
        }).map(c -> c.rule);
        index.buildIndex(ruleStream);
        return index;
    }

    public synchronized Collection<TestError> getErrorsForPrimitive(OsmPrimitive p, boolean includeOtherSeverity) {
        ArrayList<TestError> res = new ArrayList<TestError>();
        if (this.indexData == null) {
            this.indexData = MapCSSTagChecker.createMapCSSTagCheckerIndex(this.checks, includeOtherSeverity, true);
        }
        Environment env = new Environment(p, new MultiCascade(), "default", null);
        env.mpAreaCache = mpAreaCache;
        Iterator<MapCSSRule> candidates = this.indexData.getRuleCandidates(p);
        while (candidates.hasNext()) {
            MapCSSRule r = candidates.next();
            for (Selector selector : r.selectors) {
                MapCSSTagCheckerAndRule test;
                TagCheck check;
                env.clearSelectorMatchingInformation();
                if (!selector.matches(env) || (check = (test = this.ruleToCheckMap.computeIfAbsent(r, rule -> this.checks.entrySet().stream().map(e -> ((Set)e.getValue()).stream().filter(c -> c.rule.declaration == rule.declaration).findFirst().map(c -> new MapCSSTagCheckerAndRule((TagCheck)c, this.getTitle((String)e.getKey()))).orElse(null)).filter(Objects::nonNull).findFirst().orElse(null))) == null ? null : test.tagCheck) == null) continue;
                r.declaration.execute(env);
                if (check.errors.isEmpty()) continue;
                for (TestError e : check.getErrorsForPrimitive(p, selector, env, test)) {
                    MapCSSTagChecker.addIfNotSimilar(e, res);
                }
            }
        }
        return res;
    }

    private String getTitle(String url) {
        return this.urlTitles.getOrDefault(url, I18n.tr("unknown", new Object[0]));
    }

    private static void addIfNotSimilar(TestError toAdd, List<TestError> errors) {
        boolean isDup;
        boolean bl = isDup = toAdd.getPrimitives().size() >= 2 && errors.stream().anyMatch(e -> e.getCode() == toAdd.getCode() && e.getMessage().equals(toAdd.getMessage()) && e.getPrimitives().size() == toAdd.getPrimitives().size() && e.getPrimitives().containsAll(toAdd.getPrimitives()) && MapCSSTagChecker.highlightedIsEqual(e.getHighlighted(), toAdd.getHighlighted()));
        if (!isDup) {
            errors.add(toAdd);
        }
    }

    private static boolean highlightedIsEqual(Collection<?> highlighted, Collection<?> highlighted2) {
        if (highlighted.size() == highlighted2.size()) {
            if (!highlighted.isEmpty()) {
                Object h1 = highlighted.iterator().next();
                Object h2 = highlighted2.iterator().next();
                if (h1 instanceof Area && h2 instanceof Area) {
                    return ((Area)h1).equals((Area)h2);
                }
                return highlighted.containsAll(highlighted2);
            }
            return true;
        }
        return false;
    }

    static Collection<TestError> getErrorsForPrimitive(OsmPrimitive p, boolean includeOtherSeverity, Collection<Set<TagCheck>> checksCol) {
        ArrayList<TestError> r = new ArrayList<TestError>();
        Environment env = new Environment(p, new MultiCascade(), "default", null);
        env.mpAreaCache = mpAreaCache;
        for (Set<TagCheck> schecks : checksCol) {
            for (TagCheck check : schecks) {
                Selector selector;
                boolean ignoreError;
                boolean bl = ignoreError = Severity.OTHER == check.getSeverity() && !includeOtherSeverity;
                if (ignoreError && check.setClassExpressions.isEmpty() || (selector = check.whichSelectorMatchesEnvironment(env)) == null) continue;
                check.rule.declaration.execute(env);
                if (ignoreError || check.errors.isEmpty()) continue;
                r.addAll(check.getErrorsForPrimitive(p, selector, env, new MapCSSTagCheckerAndRule(check.rule)));
            }
        }
        return r;
    }

    @Override
    public void check(OsmPrimitive p) {
        for (TestError e : this.getErrorsForPrimitive(p, ValidatorPrefHelper.PREF_OTHER.get())) {
            MapCSSTagChecker.addIfNotSimilar(e, this.errors);
        }
    }

    public synchronized ParseResult addMapCSS(String url) throws ParseException, IOException {
        boolean checkAssertions = Config.getPref().getBoolean("validator.check_assert_local_rules", false) && Utils.isLocalUrl(url);
        return this.addMapCSS(url, checkAssertions ? Logging::warn : null);
    }

    synchronized ParseResult addMapCSS(String url, AssertionConsumer assertionConsumer) throws ParseException, IOException {
        ParseResult result;
        CheckParameterUtil.ensureParameterNotNull(url, "url");
        try (CachedFile cache = new CachedFile(url);
             InputStream zip = cache.findZipEntryInputStream("validator.mapcss", "");
             InputStream s = zip != null ? zip : cache.getInputStream();
             BufferedReader reader = new BufferedReader(UTFInputStreamReader.create(s));){
            if (zip != null) {
                I18n.addTexts(cache.getFile());
            }
            result = TagCheck.readMapCSS(reader, assertionConsumer);
            this.checks.remove(url);
            this.checks.putAll(url, result.parseChecks);
            this.urlTitles.put(url, MapCSSTagChecker.findURLTitle(url));
            this.indexData = null;
        }
        return result;
    }

    private static String findURLTitle(String url) {
        for (SourceEntry source : new ValidatorPrefHelper().get()) {
            if (!url.equals(source.url) || source.title == null || source.title.isEmpty()) continue;
            return source.title;
        }
        if (url.endsWith(".mapcss")) {
            url = new File(url).getName();
        }
        if (url.length() > 33) {
            url = "..." + url.substring(url.length() - 30);
        }
        return url;
    }

    @Override
    public synchronized void initialize() throws Exception {
        this.checks.clear();
        this.urlTitles.clear();
        this.indexData = null;
        for (SourceEntry source : new ValidatorPrefHelper().get()) {
            if (!source.active) continue;
            String i = source.url;
            try {
                if (!i.startsWith("resource:")) {
                    Logging.info(I18n.tr("Adding {0} to tag checker", i));
                } else if (Logging.isDebugEnabled()) {
                    Logging.debug(I18n.tr("Adding {0} to tag checker", i));
                }
                this.addMapCSS(i);
                if (!Config.getPref().getBoolean("validator.auto_reload_local_rules", true) || !source.isLocal()) continue;
                FileWatcher.getDefaultInstance().registerSource(source);
            }
            catch (IOException | IllegalArgumentException | IllegalStateException ex) {
                Logging.warn(I18n.tr("Failed to add {0} to tag checker", i));
                Logging.log(Logging.LEVEL_WARN, ex);
            }
            catch (ParseException | TokenMgrError ex) {
                Logging.warn(I18n.tr("Failed to add {0} to tag checker", i));
                Logging.warn(ex);
            }
        }
        MapCSSTagCheckerAsserts.clear();
    }

    public static void reloadRule(SourceEntry rule) {
        MapCSSTagChecker tagChecker = OsmValidator.getTest(MapCSSTagChecker.class);
        if (tagChecker != null) {
            try {
                tagChecker.addMapCSS(rule.url);
            }
            catch (IOException | ParseException | TokenMgrError e) {
                Logging.warn(e);
            }
        }
    }

    @Override
    public synchronized void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        super.setShowElements(true);
    }

    @Override
    public synchronized void endTest() {
        this.indexData = null;
        mpAreaCache.clear();
        this.ruleToCheckMap.clear();
        super.endTest();
    }

    @Override
    public void visit(Collection<OsmPrimitive> selection) {
        if (this.progressMonitor != null) {
            this.progressMonitor.setTicksCount(selection.size() * this.checks.size());
        }
        mpAreaCache.clear();
        HashSet<OsmPrimitive> surrounding = new HashSet<OsmPrimitive>();
        for (Map.Entry<String, Set<TagCheck>> entry : this.checks.entrySet()) {
            if (this.isCanceled()) break;
            this.visit(entry.getKey(), entry.getValue(), selection, surrounding);
        }
    }

    private void visit(String url, Set<TagCheck> checksForUrl, Collection<OsmPrimitive> selection, Set<OsmPrimitive> surrounding) {
        MultiMap<String, TagCheck> currentCheck = new MultiMap<String, TagCheck>();
        currentCheck.putAll(url, checksForUrl);
        this.indexData = MapCSSTagChecker.createMapCSSTagCheckerIndex(currentCheck, this.includeOtherSeverityChecks(), true);
        HashSet<OsmPrimitive> tested = new HashSet<OsmPrimitive>();
        String title = this.getTitle(url);
        if (this.progressMonitor != null) {
            this.progressMonitor.setExtraText(I18n.tr(" {0}", title));
        }
        long cnt = 0L;
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (OsmPrimitive p : selection) {
            if (this.isCanceled()) break;
            if (this.isPrimitiveUsable(p)) {
                this.check(p);
                if (this.partialSelection) {
                    tested.add(p);
                }
            }
            if (this.progressMonitor == null) continue;
            this.progressMonitor.worked(1);
            if (++cnt % 10000L != 0L || stopwatch.elapsed() < 500L) continue;
            this.progressMonitor.setExtraText(I18n.tr(" {0}: {1} of {2} elements done", title, cnt, selection.size()));
        }
        if (this.partialSelection && !tested.isEmpty()) {
            this.testPartial(currentCheck, tested, surrounding);
        }
    }

    private void testPartial(MultiMap<String, TagCheck> currentCheck, Set<OsmPrimitive> tested, Set<OsmPrimitive> surrounding) {
        boolean includeOtherSeverity = this.includeOtherSeverityChecks();
        this.indexData = MapCSSTagChecker.createMapCSSTagCheckerIndex(currentCheck, includeOtherSeverity, false);
        if (this.indexData.isEmpty()) {
            return;
        }
        if (surrounding.isEmpty()) {
            for (OsmPrimitive p : tested) {
                if (p.getDataSet() == null) continue;
                surrounding.addAll(p.getDataSet().searchWays(p.getBBox()));
                surrounding.addAll(p.getDataSet().searchRelations(p.getBBox()));
            }
        }
        for (OsmPrimitive p : surrounding) {
            if (tested.contains(p)) continue;
            Collection<TestError> additionalErrors = this.getErrorsForPrimitive(p, includeOtherSeverity);
            for (TestError e : additionalErrors) {
                if (!e.getPrimitives().stream().anyMatch(tested::contains)) continue;
                MapCSSTagChecker.addIfNotSimilar(e, this.errors);
            }
        }
    }

    public void runOnly(String ruleFile, Collection<OsmPrimitive> selection) {
        mpAreaCache.clear();
        HashSet<OsmPrimitive> surrounding = new HashSet<OsmPrimitive>();
        for (Map.Entry<String, Set<TagCheck>> entry : this.checks.entrySet()) {
            if (this.isCanceled()) break;
            if (!entry.getKey().endsWith(ruleFile)) continue;
            this.visit(entry.getKey(), entry.getValue(), selection, surrounding);
        }
    }

    @FunctionalInterface
    static interface AssertionConsumer
    extends Consumer<String> {
    }

    static class MapCSSTagCheckerAndRule
    extends MapCSSTagChecker {
        public final MapCSSRule rule;
        private final TagCheck tagCheck;
        private final String source;

        MapCSSTagCheckerAndRule(MapCSSRule rule) {
            this.rule = rule;
            this.tagCheck = null;
            this.source = "";
        }

        MapCSSTagCheckerAndRule(TagCheck tagCheck, String source) {
            this.rule = tagCheck.rule;
            this.tagCheck = tagCheck;
            this.source = source;
        }

        public String toString() {
            return "MapCSSTagCheckerAndRule [rule=" + this.rule + ']';
        }

        @Override
        public String getSource() {
            return this.source;
        }
    }

    public static class TagCheck
    implements Predicate<OsmPrimitive> {
        protected final MapCSSRule rule;
        protected final List<FixCommand> fixCommands;
        protected final List<String> alternatives;
        protected final Map<Instruction.AssignmentInstruction, Severity> errors;
        protected final Collection<String> setClassExpressions;
        protected boolean deletion;
        protected String group;
        private static final String POSSIBLE_THROWS = "throwError/throwWarning/throwOther";

        TagCheck(MapCSSRule rule) {
            this.rule = rule;
            this.fixCommands = new ArrayList<FixCommand>();
            this.alternatives = new ArrayList<String>();
            this.errors = new HashMap<Instruction.AssignmentInstruction, Severity>();
            this.setClassExpressions = new HashSet<String>();
        }

        TagCheck(TagCheck check) {
            this.rule = check.rule;
            this.fixCommands = Utils.toUnmodifiableList(check.fixCommands);
            this.alternatives = Utils.toUnmodifiableList(check.alternatives);
            this.errors = Utils.toUnmodifiableMap(check.errors);
            this.setClassExpressions = Utils.toUnmodifiableList(check.setClassExpressions);
            this.deletion = check.deletion;
            this.group = check.group;
        }

        TagCheck toImmutable() {
            return new TagCheck(this);
        }

        static TagCheck ofMapCSSRule(MapCSSRule rule, AssertionConsumer assertionConsumer) throws IllegalDataException {
            TagCheck check = new TagCheck(rule);
            HashMap<String, Boolean> assertions = new HashMap<String, Boolean>();
            for (Instruction i : rule.declaration.instructions) {
                if (!(i instanceof Instruction.AssignmentInstruction)) continue;
                Instruction.AssignmentInstruction ai = (Instruction.AssignmentInstruction)i;
                if (ai.isSetInstruction) {
                    check.setClassExpressions.add(ai.key);
                    continue;
                }
                try {
                    String val;
                    String string = ai.val instanceof Expression ? (String)Optional.ofNullable(((Expression)ai.val).evaluate(new Environment())).map(Object::toString).map(String::intern).orElse(null) : (ai.val instanceof String ? (String)ai.val : (val = ai.val instanceof Keyword ? ((Keyword)ai.val).val : null));
                    if ("throwError".equals(ai.key)) {
                        check.errors.put(ai, Severity.ERROR);
                        continue;
                    }
                    if ("throwWarning".equals(ai.key)) {
                        check.errors.put(ai, Severity.WARNING);
                        continue;
                    }
                    if ("throwOther".equals(ai.key)) {
                        check.errors.put(ai, Severity.OTHER);
                        continue;
                    }
                    if (ai.key.startsWith("throw")) {
                        Logging.log(Logging.LEVEL_WARN, "Unsupported " + ai.key + " instruction. Allowed instructions are " + POSSIBLE_THROWS + '.', null);
                        continue;
                    }
                    if ("fixAdd".equals(ai.key)) {
                        check.fixCommands.add(FixCommand.fixAdd(ai.val));
                        continue;
                    }
                    if ("fixRemove".equals(ai.key)) {
                        CheckParameterUtil.ensureThat(!(ai.val instanceof String) || val == null || !val.contains("="), "Unexpected '='. Please only specify the key to remove in: " + ai);
                        check.fixCommands.add(FixCommand.fixRemove(ai.val));
                        continue;
                    }
                    if (val != null && "fixChangeKey".equals(ai.key)) {
                        CheckParameterUtil.ensureThat(val.contains("=>"), "Separate old from new key by '=>'!");
                        String[] x = val.split("=>", 2);
                        check.fixCommands.add(FixCommand.fixChangeKey(Utils.removeWhiteSpaces(x[0]), Utils.removeWhiteSpaces(x[1])));
                        continue;
                    }
                    if (val != null && "fixDeleteObject".equals(ai.key)) {
                        CheckParameterUtil.ensureThat("this".equals(val), "fixDeleteObject must be followed by 'this'");
                        check.deletion = true;
                        continue;
                    }
                    if (val != null && "suggestAlternative".equals(ai.key)) {
                        check.alternatives.add(val);
                        continue;
                    }
                    if (val != null && "assertMatch".equals(ai.key)) {
                        assertions.put(val, Boolean.TRUE);
                        continue;
                    }
                    if (val != null && "assertNoMatch".equals(ai.key)) {
                        assertions.put(val, Boolean.FALSE);
                        continue;
                    }
                    if (val != null && "group".equals(ai.key)) {
                        check.group = val;
                        continue;
                    }
                    if (ai.key.startsWith("-")) {
                        Logging.debug("Ignoring extension instruction: " + ai.key + ": " + ai.val);
                        continue;
                    }
                    throw new IllegalDataException("Cannot add instruction " + ai.key + ": " + ai.val + '!');
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalDataException(e);
                }
            }
            if (check.errors.isEmpty() && check.setClassExpressions.isEmpty()) {
                throw new IllegalDataException("No throwError/throwWarning/throwOther given! You should specify a validation error message for " + rule.selectors);
            }
            if (check.errors.size() > 1) {
                throw new IllegalDataException("More than one throwError/throwWarning/throwOther given! You should specify a single validation error message for " + rule.selectors);
            }
            if (assertionConsumer != null) {
                MapCSSTagCheckerAsserts.checkAsserts(check, assertions, assertionConsumer);
            }
            return check.toImmutable();
        }

        static ParseResult readMapCSS(Reader css) throws ParseException {
            return TagCheck.readMapCSS(css, null);
        }

        static ParseResult readMapCSS(Reader css, AssertionConsumer assertionConsumer) throws ParseException {
            CheckParameterUtil.ensureParameterNotNull(css, "css");
            MapCSSStyleSource source = new MapCSSStyleSource("");
            MapCSSParser preprocessor = new MapCSSParser(css, MapCSSParser.LexicalState.PREPROCESSOR);
            StringReader mapcss = new StringReader(preprocessor.pp_root(source));
            Object object = null;
            try {
                new MapCSSParser(mapcss, MapCSSParser.LexicalState.DEFAULT).sheet(source);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    try {
                        mapcss.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    mapcss.close();
                }
            }
            source.removeMetaRules();
            ArrayList<TagCheck> parseChecks = new ArrayList<TagCheck>();
            for (MapCSSRule rule : source.rules) {
                try {
                    parseChecks.add(TagCheck.ofMapCSSRule(rule, assertionConsumer));
                }
                catch (IllegalDataException e) {
                    Logging.error("Cannot add MapCSS rule: " + e.getMessage());
                    source.logError(e);
                }
            }
            return new ParseResult(parseChecks, source.getErrors());
        }

        @Override
        public boolean test(OsmPrimitive primitive) {
            return this.whichSelectorMatchesPrimitive(primitive) != null;
        }

        Selector whichSelectorMatchesPrimitive(OsmPrimitive primitive) {
            return this.whichSelectorMatchesEnvironment(new Environment(primitive));
        }

        Selector whichSelectorMatchesEnvironment(Environment env) {
            return this.rule.selectors.stream().filter(i -> i.matches(env.clearSelectorMatchingInformation())).findFirst().orElse(null);
        }

        static String determineArgument(Selector.GeneralSelector matchingSelector, int index, String type, OsmPrimitive p) {
            try {
                Tag tag;
                Condition c = matchingSelector.getConditions().get(index);
                Tag tag2 = tag = c instanceof Condition.ToTagConvertable ? ((Condition.ToTagConvertable)((Object)c)).asTag(p) : null;
                if (tag == null) {
                    return null;
                }
                if ("key".equals(type)) {
                    return tag.getKey();
                }
                if ("value".equals(type)) {
                    return tag.getValue();
                }
                if ("tag".equals(type)) {
                    return tag.toString();
                }
            }
            catch (IndexOutOfBoundsException ignore) {
                Logging.debug(ignore);
            }
            return null;
        }

        static String insertArguments(Selector matchingSelector, String s, OsmPrimitive p) {
            if (s != null && matchingSelector instanceof Selector.ChildOrParentSelector) {
                return TagCheck.insertArguments(((Selector.ChildOrParentSelector)matchingSelector).right, s, p);
            }
            if (s == null || !(matchingSelector instanceof Selector.GeneralSelector)) {
                return s;
            }
            Matcher m = Pattern.compile("\\{(\\d+)\\.(key|value|tag)\\}").matcher(s);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String argument = TagCheck.determineArgument((Selector.GeneralSelector)matchingSelector, Integer.parseInt(m.group(1)), m.group(2), p);
                try {
                    m.appendReplacement(sb, String.valueOf(argument).replace("^(", "").replace(")$", ""));
                }
                catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                    Logging.log(Logging.LEVEL_ERROR, I18n.tr("Unable to replace argument {0} in {1}: {2}", argument, sb, e.getMessage()), e);
                }
            }
            m.appendTail(sb);
            return sb.toString();
        }

        Command fixPrimitive(OsmPrimitive p) {
            if (p.getDataSet() == null || this.fixCommands.isEmpty() && !this.deletion) {
                return null;
            }
            try {
                Selector matchingSelector = this.whichSelectorMatchesPrimitive(p);
                Collection cmds = this.fixCommands.stream().map(fixCommand -> fixCommand.createCommand(p, matchingSelector)).collect(Collectors.toList());
                if (this.deletion && !p.isDeleted()) {
                    cmds.add(new DeleteCommand(p));
                }
                return new SequenceCommand(I18n.tr("Fix of {0}", this.getDescriptionForMatchingSelector(p, matchingSelector)), cmds);
            }
            catch (IllegalArgumentException e) {
                Logging.error(e);
                return null;
            }
        }

        String getMessage(OsmPrimitive p) {
            if (this.errors.isEmpty()) {
                return this.rule.declaration.toString();
            }
            Object val = this.errors.keySet().iterator().next().val;
            return String.valueOf(val instanceof Expression ? ((Expression)val).evaluate(new Environment(p)) : val);
        }

        String getDescription(OsmPrimitive p) {
            if (this.alternatives.isEmpty()) {
                return this.getMessage(p);
            }
            return I18n.tr("{0}, use {1} instead", this.getMessage(p), String.join((CharSequence)I18n.tr(" or ", new Object[0]), this.alternatives));
        }

        String getDescriptionForMatchingSelector(OsmPrimitive p, Selector matchingSelector) {
            return TagCheck.insertArguments(matchingSelector, this.getDescription(p), p);
        }

        Severity getSeverity() {
            return this.errors.isEmpty() ? null : this.errors.values().iterator().next();
        }

        public String toString() {
            return this.getDescription(null);
        }

        protected List<TestError> getErrorsForPrimitive(OsmPrimitive p, Selector matchingSelector, Environment env, Test tester) {
            ArrayList<TestError> res = new ArrayList<TestError>();
            if (matchingSelector != null && !this.errors.isEmpty()) {
                Command fix = this.fixPrimitive(p);
                String description = this.getDescriptionForMatchingSelector(p, matchingSelector);
                String description1 = this.group == null ? description : this.group;
                String description2 = this.group == null ? null : description;
                String selector = matchingSelector.toString();
                TestError.Builder errorBuilder = TestError.builder(tester, this.getSeverity(), 3000).messageWithManuallyTranslatedDescription(description1, description2, selector);
                if (fix != null) {
                    errorBuilder.fix(() -> fix);
                }
                if (env.child instanceof OsmPrimitive) {
                    res.add(errorBuilder.primitives(p, (OsmPrimitive)env.child).build());
                } else if (env.children != null) {
                    for (IPrimitive c : env.children) {
                        Object is;
                        if (!(c instanceof OsmPrimitive)) continue;
                        errorBuilder = TestError.builder(tester, this.getSeverity(), 3000).messageWithManuallyTranslatedDescription(description1, description2, selector);
                        if (fix != null) {
                            errorBuilder.fix(() -> fix);
                        }
                        boolean hiliteFound = false;
                        if (env.intersections != null && (is = env.intersections.get(c)) != null) {
                            errorBuilder.highlight((Area)is);
                            hiliteFound = true;
                        }
                        if (env.crossingWaysMap != null && !hiliteFound && (is = env.crossingWaysMap.get(c)) != null) {
                            HashSet<WaySegment> toHilite = new HashSet<WaySegment>();
                            for (List wsList : is.values()) {
                                toHilite.addAll(wsList);
                            }
                            errorBuilder.highlightWaySegments(toHilite);
                        }
                        res.add(errorBuilder.primitives(p, (OsmPrimitive)c).build());
                    }
                } else {
                    res.add(errorBuilder.primitives(p).build());
                }
            }
            return res;
        }
    }

    public static class ParseResult {
        public final List<TagCheck> parseChecks;
        public final Collection<Throwable> parseErrors;

        public ParseResult(List<TagCheck> parseChecks, Collection<Throwable> parseErrors) {
            this.parseChecks = parseChecks;
            this.parseErrors = parseErrors;
        }
    }

    @FunctionalInterface
    static interface FixCommand {
        public Command createCommand(OsmPrimitive var1, Selector var2);

        public static void checkObject(Object obj) {
            CheckParameterUtil.ensureThat(obj instanceof Expression || obj instanceof String, () -> "instance of Exception or String expected, but got " + obj);
        }

        public static String evaluateObject(Object obj, OsmPrimitive p, Selector matchingSelector) {
            String s;
            if (obj instanceof Expression) {
                s = (String)((Expression)obj).evaluate(new Environment(p));
            } else if (obj instanceof String) {
                s = (String)obj;
            } else {
                return null;
            }
            return TagCheck.insertArguments(matchingSelector, s, p);
        }

        public static FixCommand fixAdd(final Object obj) {
            FixCommand.checkObject(obj);
            return new FixCommand(){

                @Override
                public Command createCommand(OsmPrimitive p, Selector matchingSelector) {
                    Tag tag = Tag.ofString(FixCommand.evaluateObject(obj, p, matchingSelector));
                    return new ChangePropertyCommand(p, tag.getKey(), tag.getValue());
                }

                public String toString() {
                    return "fixAdd: " + obj;
                }
            };
        }

        public static FixCommand fixRemove(final Object obj) {
            FixCommand.checkObject(obj);
            return new FixCommand(){

                @Override
                public Command createCommand(OsmPrimitive p, Selector matchingSelector) {
                    String key = FixCommand.evaluateObject(obj, p, matchingSelector);
                    return new ChangePropertyCommand(p, key, "");
                }

                public String toString() {
                    return "fixRemove: " + obj;
                }
            };
        }

        public static FixCommand fixChangeKey(final String oldKey, final String newKey) {
            return new FixCommand(){

                @Override
                public Command createCommand(OsmPrimitive p, Selector matchingSelector) {
                    return new ChangePropertyKeyCommand(p, TagCheck.insertArguments(matchingSelector, oldKey, p), TagCheck.insertArguments(matchingSelector, newKey, p));
                }

                public String toString() {
                    return "fixChangeKey: " + oldKey + " => " + newKey;
                }
            };
        }
    }
}

