/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetReader;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.gui.widgets.QuadStateCheckBox;
import org.openstreetmap.josm.tools.GBC;

public class Check
extends KeyedItem {
    public String value_on = "yes";
    public String value_off = "no";
    public boolean disable_off;
    public String default_;
    public String icon;
    public short icon_size = (short)16;
    private QuadStateCheckBox check;
    private QuadStateCheckBox.State initialState;
    private Boolean def;

    @Override
    public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel, boolean presetInitiallyMatches) {
        String oneValue;
        KeyedItem.Usage usage = Check.determineBooleanUsage(sel, this.key);
        String string = oneValue = usage.values.isEmpty() ? null : usage.values.last();
        this.def = "on".equals(this.default_) ? Boolean.TRUE : ("off".equals(this.default_) ? Boolean.FALSE : null);
        this.initializeLocaleText(null);
        if (usage.values.size() < 2 && (oneValue == null || this.value_on.equals(oneValue) || this.value_off.equals(oneValue))) {
            if (this.def != null && !PROP_FILL_DEFAULT.get().booleanValue()) {
                for (OsmPrimitive s : sel) {
                    if (!s.hasKeys()) continue;
                    this.def = null;
                }
            }
            this.initialState = this.value_on.equals(oneValue) || Boolean.TRUE.equals(this.def) ? QuadStateCheckBox.State.SELECTED : (this.value_off.equals(oneValue) || Boolean.FALSE.equals(this.def) ? QuadStateCheckBox.State.NOT_SELECTED : QuadStateCheckBox.State.UNSET);
        } else {
            this.def = null;
            this.initialState = QuadStateCheckBox.State.PARTIAL;
        }
        ArrayList<QuadStateCheckBox.State> allowedStates = new ArrayList<QuadStateCheckBox.State>(4);
        if (QuadStateCheckBox.State.PARTIAL == this.initialState) {
            allowedStates.add(QuadStateCheckBox.State.PARTIAL);
        }
        allowedStates.add(QuadStateCheckBox.State.SELECTED);
        if (!this.disable_off || this.value_off.equals(oneValue)) {
            allowedStates.add(QuadStateCheckBox.State.NOT_SELECTED);
        }
        allowedStates.add(QuadStateCheckBox.State.UNSET);
        this.check = new QuadStateCheckBox(this.icon == null ? this.locale_text : null, this.initialState, allowedStates.toArray(new QuadStateCheckBox.State[0]));
        this.check.setPropertyText(this.key);
        this.check.setState(this.check.getState());
        this.check.setComponentPopupMenu(this.getPopupMenu());
        if (this.icon != null) {
            JPanel checkPanel = new JPanel(new GridBagLayout());
            checkPanel.add((Component)this.check, GBC.std());
            JLabel label = new JLabel(this.locale_text, this.getIcon(), 2);
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Check.this.check.getMouseAdapter().mousePressed(e);
                }
            });
            checkPanel.add(label);
            checkPanel.add((Component)new JLabel(), GBC.eol().fill());
            p.add((Component)checkPanel, GBC.eol());
        } else {
            p.add((Component)this.check, GBC.eol());
        }
        return true;
    }

    @Override
    public void addCommands(List<Tag> changedTags) {
        if (this.def == null && this.check.getState() == this.initialState) {
            return;
        }
        changedTags.add(new Tag(this.key, this.check.getState() == QuadStateCheckBox.State.SELECTED ? this.value_on : (this.check.getState() == QuadStateCheckBox.State.NOT_SELECTED ? this.value_off : null)));
    }

    @Override
    public KeyedItem.MatchType getDefaultMatch() {
        return KeyedItem.MatchType.NONE;
    }

    public ImageIcon getIcon() {
        return this.icon == null ? null : Check.loadImageIcon(this.icon, TaggingPresetReader.getZipIcons(), Integer.valueOf(this.icon_size));
    }

    @Override
    public Collection<String> getValues() {
        return this.disable_off ? Arrays.asList(this.value_on) : Arrays.asList(this.value_on, this.value_off);
    }

    @Override
    public String toString() {
        return "Check [key=" + this.key + ", text=" + this.text + ", " + (this.locale_text != null ? "locale_text=" + this.locale_text + ", " : "") + (this.value_on != null ? "value_on=" + this.value_on + ", " : "") + (this.value_off != null ? "value_off=" + this.value_off + ", " : "") + "default_=" + this.default_ + ", " + (this.check != null ? "check=" + this.check + ", " : "") + (this.initialState != null ? "initialState=" + (Object)((Object)this.initialState) + ", " : "") + "def=" + this.def + ']';
    }
}

