/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.Rainbow;

public class LinkRendering {
    private final Rainbow rainbow;
    private final Display display;

    public LinkRendering(Rainbow rainbow) {
        this(rainbow, Display.NULL);
    }

    private LinkRendering(Rainbow rainbow, Display display) {
        if (rainbow == null) {
            throw new IllegalArgumentException();
        }
        this.rainbow = rainbow;
        this.display = display;
    }

    public static LinkRendering none() {
        return new LinkRendering(Rainbow.none());
    }

    public LinkRendering withRainbow(Rainbow rainbow) {
        return new LinkRendering(rainbow, this.display);
    }

    public LinkRendering withDisplay(Display display) {
        return new LinkRendering(this.rainbow, display);
    }

    public Display getDisplay() {
        return this.display;
    }

    public Rainbow getRainbow() {
        return this.rainbow;
    }

    public Rainbow getRainbow(Rainbow defaultColor) {
        if (this.rainbow.size() == 0) {
            return defaultColor;
        }
        return this.rainbow;
    }

    public boolean isNone() {
        return Display.isNull(this.display) && this.rainbow.size() == 0;
    }

    public String toString() {
        return super.toString() + " " + this.display + " " + this.rainbow;
    }
}

