/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.TreeSet;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project.GanttConstraint;
import net.sourceforge.plantuml.project.ToTaskDraw;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskImpl;
import net.sourceforge.plantuml.project.draw.AbstractTaskDraw;
import net.sourceforge.plantuml.project.draw.FingerPrint;
import net.sourceforge.plantuml.project.draw.PathUtils;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class TaskDrawRegular
extends AbstractTaskDraw {
    private final Day end;
    private final boolean oddStart;
    private final boolean oddEnd;
    private final Collection<Day> paused;
    private final Collection<GanttConstraint> constraints;
    private final double margin = 2.0;

    public TaskDrawRegular(TimeScale timeScale, double y, String prettyDisplay, Day start, Day end, boolean oddStart, boolean oddEnd, ISkinParam skinParam, Task task, ToTaskDraw toTaskDraw, Collection<GanttConstraint> constraints) {
        super(timeScale, y, prettyDisplay, start, skinParam, task, toTaskDraw);
        this.constraints = constraints;
        this.end = end;
        this.oddStart = oddStart;
        this.oddEnd = oddEnd;
        this.paused = new TreeSet<Day>(((TaskImpl)task).getAllPaused());
        Day tmp = start;
        while (tmp.compareTo(end) <= 0) {
            int load = toTaskDraw.getDefaultPlan().getLoadAt(tmp);
            if (load == 0) {
                this.paused.add(tmp);
            }
            tmp = tmp.increment();
        }
    }

    @Override
    public void drawTitle(UGraphic ug) {
        TextBlock title = Display.getWithNewlines(this.prettyDisplay).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        Dimension2D dim = title.calculateDimension(ug.getStringBounder());
        double h = (2.0 + this.getShapeHeight() - dim.getHeight()) / 2.0;
        double pos1 = this.timeScale.getStartingPosition(this.start) + 6.0;
        double pos2 = this.timeScale.getEndingPosition(this.end) - 6.0;
        double pos = pos2 - pos1 > dim.getWidth() ? pos1 : this.getOutPosition(pos2);
        title.drawU(ug.apply(new UTranslate(pos, h)));
    }

    private double getOutPosition(double pos2) {
        if (this.isThereRightArrow()) {
            return pos2 + 18.0;
        }
        return pos2 + 8.0;
    }

    private boolean isThereRightArrow() {
        for (GanttConstraint constraint : this.constraints) {
            if (!constraint.isThereRightArrow(this.getTask())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Style getStyle() {
        Style style = StyleSignature.of(SName.root, SName.element, SName.ganttDiagram, SName.task).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        return style;
    }

    @Override
    public void drawU(UGraphic ug) {
        double startPos = this.timeScale.getStartingPosition(this.start);
        this.drawNote(ug.apply(new UTranslate(startPos + 2.0, this.getYNotePosition())));
        ug = this.applyColors(ug).apply(new UTranslate(2.0, 2.0));
        this.drawShape(ug);
    }

    private double getYNotePosition() {
        return this.getShapeHeight() + 6.0;
    }

    private void drawNote(UGraphic ug) {
        if (this.note == null) {
            return;
        }
        this.getOpaleNote().drawU(ug);
    }

    @Override
    public double getHeightMax(StringBounder stringBounder) {
        if (this.note == null) {
            return this.getHeightTask();
        }
        return this.getYNotePosition() + this.getOpaleNote().calculateDimension(stringBounder).getHeight();
    }

    private Opale getOpaleNote() {
        Style style = StyleSignature.of(SName.root, SName.element, SName.ganttDiagram, SName.note).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        FontConfiguration fc = new FontConfiguration(this.skinParam, style);
        Sheet sheet = Parser.build(fc, this.skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), this.skinParam, CreoleMode.FULL).createSheet(this.note);
        SheetBlock1 sheet1 = new SheetBlock1(sheet, LineBreakStrategy.NONE, this.skinParam.getPadding());
        HColor noteBackgroundColor = style.value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
        HColor borderColor = style.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        double shadowing = style.value(PName.Shadowing).asDouble();
        Opale opale = new Opale(shadowing, borderColor, noteBackgroundColor, sheet1, false);
        return opale;
    }

    @Override
    public FingerPrint getFingerPrint() {
        double h = this.getHeightTask();
        double startPos = this.timeScale.getStartingPosition(this.start);
        double endPos = this.timeScale.getEndingPosition(this.end);
        return new FingerPrint(startPos, this.getY(), endPos - startPos, h);
    }

    @Override
    public FingerPrint getFingerPrintNote(StringBounder stringBounder) {
        if (this.note == null) {
            return null;
        }
        Dimension2D dim = this.getOpaleNote().calculateDimension(stringBounder);
        double startPos = this.timeScale.getStartingPosition(this.start);
        return new FingerPrint(startPos, this.getY() + this.getYNotePosition(), dim.getWidth(), dim.getHeight());
    }

    private UGraphic applyColors(UGraphic ug) {
        if (this.colors != null && this.colors.isOk()) {
            return this.colors.apply(ug);
        }
        return ug.apply(this.getLineColor()).apply(this.getBackgroundColor().bg());
    }

    private void drawShape(UGraphic ug) {
        double startPos = this.timeScale.getStartingPosition(this.start);
        double endPos = this.timeScale.getEndingPosition(this.end);
        double fullLength = endPos - startPos - 4.0;
        if (fullLength < 3.0) {
            fullLength = 3.0;
        }
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        if (this.oddStart && !this.oddEnd) {
            ug.apply(UTranslate.dx(startPos)).draw(PathUtils.UtoRight(fullLength, this.getShapeHeight()));
        } else if (!this.oddStart && this.oddEnd) {
            ug.apply(UTranslate.dx(startPos)).draw(PathUtils.UtoLeft(fullLength, this.getShapeHeight()));
        } else {
            URectangle full = new URectangle(fullLength, this.getShapeHeight()).rounded(8.0);
            if (this.completion == 100) {
                ug.apply(UTranslate.dx(startPos)).draw(full);
            } else {
                double partialLength = fullLength * (double)this.completion / 100.0;
                ug.apply(UTranslate.dx(startPos)).apply(HColorUtils.WHITE).apply(HColorUtils.WHITE.bg()).draw(full);
                if (partialLength > 2.0) {
                    URectangle partial = new URectangle(partialLength, this.getShapeHeight()).rounded(8.0);
                    ug.apply(UTranslate.dx(startPos)).apply(new HColorNone()).draw(partial);
                }
                if (partialLength > 10.0 && partialLength < fullLength - 10.0) {
                    URectangle patch = new URectangle(8.0, this.getShapeHeight());
                    ug.apply(UTranslate.dx(startPos)).apply(new HColorNone()).apply(UTranslate.dx(partialLength - 8.0)).draw(patch);
                }
                ug.apply(UTranslate.dx(startPos)).apply(new HColorNone().bg()).draw(full);
            }
        }
        if (this.url != null) {
            ug.closeUrl();
        }
        Day begin = null;
        for (Day pause : this.paused) {
            if (this.paused.contains(pause.increment())) {
                if (begin != null) continue;
                begin = pause;
                continue;
            }
            if (begin == null) {
                this.drawPause(ug, pause, pause);
            } else {
                this.drawPause(ug, begin, pause);
            }
            begin = null;
        }
    }

    private void drawPause(UGraphic ug, Day start1, Day end) {
        double x1 = this.timeScale.getStartingPosition(start1);
        double x2 = this.timeScale.getEndingPosition(end);
        URectangle small = new URectangle(x2 - x1 - 1.0, this.getShapeHeight() + 1.0);
        ULine line = ULine.hline(x2 - x1 - 1.0);
        ug = ug.apply(UTranslate.dx(x1 - 1.0));
        ug.apply(HColorUtils.WHITE).apply(HColorUtils.WHITE.bg()).draw(small);
        UGraphic ugLine = ug.apply(new UStroke(2.0, 3.0, 1.0));
        ugLine.draw(line);
        ugLine.apply(UTranslate.dy(this.getShapeHeight())).draw(line);
    }
}

