/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;

public class EntityImageCircleStart
extends AbstractEntityImage {
    private static final int SIZE = 20;
    private final ColorParam colorParam;

    public StyleSignature getDefaultStyleDefinitionCircle() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.circle);
    }

    public EntityImageCircleStart(ILeaf entity, ISkinParam skinParam, ColorParam colorParam) {
        super(entity, skinParam);
        this.colorParam = colorParam;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(20.0, 20.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        UEllipse circle = new UEllipse(20.0, 20.0);
        double shadowing = 0.0;
        if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
            shadowing = 3.0;
        }
        HColor color = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), this.colorParam);
        if (UseStyle.useBetaStyle()) {
            Style style = this.getDefaultStyleDefinitionCircle().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
            color = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
            shadowing = style.value(PName.Shadowing).asDouble();
        }
        circle.setDeltaShadow(shadowing);
        ug.apply(color.bg()).apply(new HColorNone()).draw(circle);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }
}

