// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from STM32F7x8.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/STMicro

// +build stm32,stm32f7x8

// STM32F7x8
//

package stm32

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "STM32F7x8"
)

// Interrupt numbers.
const (
	IRQ_WWDG               = 0   // Window watchdog
	IRQ_PVD                = 1   // External interrupt/event controller
	IRQ_TAMP_STAMP         = 2   // External interrupt/event controller
	IRQ_RTC_WKUP           = 3   // Real-time clock
	IRQ_FLASH              = 4   // FLASH
	IRQ_RCC                = 5   // Reset and clock control
	IRQ_EXTI0              = 6   // External interrupt/event controller
	IRQ_EXTI1              = 7   // External interrupt/event controller
	IRQ_EXTI2              = 8   // External interrupt/event controller
	IRQ_EXTI3              = 9   // External interrupt/event controller
	IRQ_EXTI4              = 10  // External interrupt/event controller
	IRQ_DMA1_Stream0       = 11  //
	IRQ_DMA1_Stream1       = 12  //
	IRQ_DMA1_Stream2       = 13  //
	IRQ_DMA1_Stream3       = 14  //
	IRQ_DMA1_Stream4       = 15  //
	IRQ_DMA1_Stream5       = 16  //
	IRQ_DMA1_Stream6       = 17  //
	IRQ_ADC                = 18  // Analog-to-digital converter
	IRQ_CAN1_TX            = 19  // Controller area network
	IRQ_CAN1_RX0           = 20  // Controller area network
	IRQ_CAN1_RX1           = 21  // Controller area network
	IRQ_CAN1_SCE           = 22  // Controller area network
	IRQ_EXTI9_5            = 23  // External interrupt/event controller
	IRQ_TIM1_BRK_TIM9      = 24  // Advanced-timers
	IRQ_TIM1_UP_TIM10      = 25  // Advanced-timers
	IRQ_TIM1_TRG_COM_TIM11 = 26  // Advanced-timers
	IRQ_TIM1_CC            = 27  // Advanced-timers
	IRQ_TIM2               = 28  // General purpose timers
	IRQ_TIM3               = 29  // General purpose timers
	IRQ_TIM4               = 30  // General purpose timers
	IRQ_I2C1_EV            = 31  // Inter-integrated circuit
	IRQ_I2C1_ER            = 32  // Inter-integrated circuit
	IRQ_I2C2_EV            = 33  //
	IRQ_I2C2_ER            = 34  //
	IRQ_SPI1               = 35  // Serial peripheral interface
	IRQ_SPI2               = 36  //
	IRQ_USART1             = 37  //
	IRQ_USART2             = 38  //
	IRQ_USART3             = 39  //
	IRQ_EXTI15_10          = 40  // External interrupt/event controller
	IRQ_RTC_ALARM          = 41  // External interrupt/event controller
	IRQ_OTG_FS_WKUP        = 42  // External interrupt/event controller
	IRQ_TIM8_BRK_TIM12     = 43  //
	IRQ_TIM8_UP_TIM13      = 44  //
	IRQ_TIM8_TRG_COM_TIM14 = 45  //
	IRQ_TIM8_CC            = 46  //
	IRQ_DMA1_Stream7       = 47  //
	IRQ_FMC                = 48  // Flexible memory controller
	IRQ_SDMMC1             = 49  // Secure digital input/output interface
	IRQ_TIM5               = 50  // General-purpose-timers
	IRQ_SPI3               = 51  //
	IRQ_UART4              = 52  //
	IRQ_UART5              = 53  //
	IRQ_TIM6_DAC           = 54  // Basic timers
	IRQ_TIM7               = 55  //
	IRQ_DMA2_Stream0       = 56  // DMA controller
	IRQ_DMA2_Stream1       = 57  // DMA controller
	IRQ_DMA2_Stream2       = 58  // DMA controller
	IRQ_DMA2_Stream3       = 59  // DMA controller
	IRQ_DMA2_Stream4       = 60  // DMA controller
	IRQ_ETH                = 61  // Ethernet: media access control (MAC)
	IRQ_ETH_WKUP           = 62  // Ethernet: media access control (MAC)
	IRQ_CAN2_TX            = 63  //
	IRQ_CAN2_RX0           = 64  //
	IRQ_CAN2_RX1           = 65  //
	IRQ_CAN2_SCE           = 66  //
	IRQ_OTG_FS             = 67  // USB on the go full speed
	IRQ_DMA2_Stream5       = 68  // DMA controller
	IRQ_DMA2_Stream6       = 69  // DMA controller
	IRQ_DMA2_Stream7       = 70  // DMA controller
	IRQ_USART6             = 71  // Universal synchronous asynchronous receiver transmitter
	IRQ_I2C3_EV            = 72  //
	IRQ_I2C3_ER            = 73  //
	IRQ_OTG_HS_EP1_OUT     = 74  // USB on the go high speed
	IRQ_OTG_HS_EP1_IN      = 75  // USB on the go high speed
	IRQ_OTG_HS_WKUP        = 76  // USB on the go high speed
	IRQ_OTG_HS             = 77  // USB on the go high speed
	IRQ_DCMI               = 78  // Digital camera interface
	IRQ_CRYP               = 79  // Cryptographic processor
	IRQ_HASH_RNG           = 80  // Random number generator
	IRQ_FPU                = 81  // Floting point unit
	IRQ_UART7              = 82  //
	IRQ_UART8              = 83  //
	IRQ_SPI4               = 84  //
	IRQ_SPI5               = 85  //
	IRQ_SPI6               = 86  //
	IRQ_SAI1               = 87  // Serial audio interface
	IRQ_LCD_TFT            = 88  // LCD-TFT Controller
	IRQ_DMA2D              = 90  // DMA2D controller
	IRQ_SAI2               = 91  //
	IRQ_QuadSPI            = 92  // QuadSPI interface
	IRQ_LP_Timer1          = 93  // Low power timer
	IRQ_I2C4_EV            = 95  //
	IRQ_I2C4_ER            = 96  //
	IRQ_SPDIFRX            = 97  // Receiver Interface
	IRQ_DSIHOST            = 98  // DSI Host
	IRQ_DFSDM1_FLT0        = 99  // Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT1        = 100 // Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT2        = 101 // Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT3        = 102 // Digital filter for sigma delta modulators
	IRQ_SDMMC2             = 103 //
	IRQ_CAN3_TX            = 104 //
	IRQ_CAN3_RX0           = 105 //
	IRQ_CAN3_RX1           = 106 //
	IRQ_CAN3_SCE           = 107 //
	IRQ_JPEG               = 108 // JPEG codec
	IRQ_MDIOS              = 109 // Management data input/output slave
	IRQ_max                = 109 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_WWDG, "WWDG_IRQHandler")
	_ = interrupt.Register(IRQ_PVD, "PVD_IRQHandler")
	_ = interrupt.Register(IRQ_TAMP_STAMP, "TAMP_STAMP_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_WKUP, "RTC_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_FLASH, "FLASH_IRQHandler")
	_ = interrupt.Register(IRQ_RCC, "RCC_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI0, "EXTI0_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI1, "EXTI1_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI2, "EXTI2_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI3, "EXTI3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI4, "EXTI4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream0, "DMA1_Stream0_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream1, "DMA1_Stream1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream2, "DMA1_Stream2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream3, "DMA1_Stream3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream4, "DMA1_Stream4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream5, "DMA1_Stream5_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream6, "DMA1_Stream6_IRQHandler")
	_ = interrupt.Register(IRQ_ADC, "ADC_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_TX, "CAN1_TX_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_RX0, "CAN1_RX0_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_RX1, "CAN1_RX1_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_SCE, "CAN1_SCE_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI9_5, "EXTI9_5_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_BRK_TIM9, "TIM1_BRK_TIM9_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_UP_TIM10, "TIM1_UP_TIM10_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_TRG_COM_TIM11, "TIM1_TRG_COM_TIM11_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_CC, "TIM1_CC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM2, "TIM2_IRQHandler")
	_ = interrupt.Register(IRQ_TIM3, "TIM3_IRQHandler")
	_ = interrupt.Register(IRQ_TIM4, "TIM4_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_EV, "I2C1_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_ER, "I2C1_ER_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_EV, "I2C2_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_ER, "I2C2_ER_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_SPI2, "SPI2_IRQHandler")
	_ = interrupt.Register(IRQ_USART1, "USART1_IRQHandler")
	_ = interrupt.Register(IRQ_USART2, "USART2_IRQHandler")
	_ = interrupt.Register(IRQ_USART3, "USART3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI15_10, "EXTI15_10_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_ALARM, "RTC_ALARM_IRQHandler")
	_ = interrupt.Register(IRQ_OTG_FS_WKUP, "OTG_FS_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_BRK_TIM12, "TIM8_BRK_TIM12_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_UP_TIM13, "TIM8_UP_TIM13_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_TRG_COM_TIM14, "TIM8_TRG_COM_TIM14_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_CC, "TIM8_CC_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream7, "DMA1_Stream7_IRQHandler")
	_ = interrupt.Register(IRQ_FMC, "FMC_IRQHandler")
	_ = interrupt.Register(IRQ_SDMMC1, "SDMMC1_IRQHandler")
	_ = interrupt.Register(IRQ_TIM5, "TIM5_IRQHandler")
	_ = interrupt.Register(IRQ_SPI3, "SPI3_IRQHandler")
	_ = interrupt.Register(IRQ_UART4, "UART4_IRQHandler")
	_ = interrupt.Register(IRQ_UART5, "UART5_IRQHandler")
	_ = interrupt.Register(IRQ_TIM6_DAC, "TIM6_DAC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM7, "TIM7_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream0, "DMA2_Stream0_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream1, "DMA2_Stream1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream2, "DMA2_Stream2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream3, "DMA2_Stream3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream4, "DMA2_Stream4_IRQHandler")
	_ = interrupt.Register(IRQ_ETH, "ETH_IRQHandler")
	_ = interrupt.Register(IRQ_ETH_WKUP, "ETH_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_CAN2_TX, "CAN2_TX_IRQHandler")
	_ = interrupt.Register(IRQ_CAN2_RX0, "CAN2_RX0_IRQHandler")
	_ = interrupt.Register(IRQ_CAN2_RX1, "CAN2_RX1_IRQHandler")
	_ = interrupt.Register(IRQ_CAN2_SCE, "CAN2_SCE_IRQHandler")
	_ = interrupt.Register(IRQ_OTG_FS, "OTG_FS_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream5, "DMA2_Stream5_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream6, "DMA2_Stream6_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream7, "DMA2_Stream7_IRQHandler")
	_ = interrupt.Register(IRQ_USART6, "USART6_IRQHandler")
	_ = interrupt.Register(IRQ_I2C3_EV, "I2C3_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C3_ER, "I2C3_ER_IRQHandler")
	_ = interrupt.Register(IRQ_OTG_HS_EP1_OUT, "OTG_HS_EP1_OUT_IRQHandler")
	_ = interrupt.Register(IRQ_OTG_HS_EP1_IN, "OTG_HS_EP1_IN_IRQHandler")
	_ = interrupt.Register(IRQ_OTG_HS_WKUP, "OTG_HS_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_OTG_HS, "OTG_HS_IRQHandler")
	_ = interrupt.Register(IRQ_DCMI, "DCMI_IRQHandler")
	_ = interrupt.Register(IRQ_CRYP, "CRYP_IRQHandler")
	_ = interrupt.Register(IRQ_HASH_RNG, "HASH_RNG_IRQHandler")
	_ = interrupt.Register(IRQ_FPU, "FPU_IRQHandler")
	_ = interrupt.Register(IRQ_UART7, "UART7_IRQHandler")
	_ = interrupt.Register(IRQ_UART8, "UART8_IRQHandler")
	_ = interrupt.Register(IRQ_SPI4, "SPI4_IRQHandler")
	_ = interrupt.Register(IRQ_SPI5, "SPI5_IRQHandler")
	_ = interrupt.Register(IRQ_SPI6, "SPI6_IRQHandler")
	_ = interrupt.Register(IRQ_SAI1, "SAI1_IRQHandler")
	_ = interrupt.Register(IRQ_LCD_TFT, "LCD_TFT_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2D, "DMA2D_IRQHandler")
	_ = interrupt.Register(IRQ_SAI2, "SAI2_IRQHandler")
	_ = interrupt.Register(IRQ_QuadSPI, "QuadSPI_IRQHandler")
	_ = interrupt.Register(IRQ_LP_Timer1, "LP_Timer1_IRQHandler")
	_ = interrupt.Register(IRQ_I2C4_EV, "I2C4_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C4_ER, "I2C4_ER_IRQHandler")
	_ = interrupt.Register(IRQ_SPDIFRX, "SPDIFRX_IRQHandler")
	_ = interrupt.Register(IRQ_DSIHOST, "DSIHOST_IRQHandler")
	_ = interrupt.Register(IRQ_DFSDM1_FLT0, "DFSDM1_FLT0_IRQHandler")
	_ = interrupt.Register(IRQ_DFSDM1_FLT1, "DFSDM1_FLT1_IRQHandler")
	_ = interrupt.Register(IRQ_DFSDM1_FLT2, "DFSDM1_FLT2_IRQHandler")
	_ = interrupt.Register(IRQ_DFSDM1_FLT3, "DFSDM1_FLT3_IRQHandler")
	_ = interrupt.Register(IRQ_SDMMC2, "SDMMC2_IRQHandler")
	_ = interrupt.Register(IRQ_CAN3_TX, "CAN3_TX_IRQHandler")
	_ = interrupt.Register(IRQ_CAN3_RX0, "CAN3_RX0_IRQHandler")
	_ = interrupt.Register(IRQ_CAN3_RX1, "CAN3_RX1_IRQHandler")
	_ = interrupt.Register(IRQ_CAN3_SCE, "CAN3_SCE_IRQHandler")
	_ = interrupt.Register(IRQ_JPEG, "JPEG_IRQHandler")
	_ = interrupt.Register(IRQ_MDIOS, "MDIOS_IRQHandler")
)

// Peripherals.
var (
	RNG           = (*RNG_Type)(unsafe.Pointer(uintptr(0x50060800)))        // Random number generator
	HASH          = (*HASH_Type)(unsafe.Pointer(uintptr(0x50060400)))       // Hash processor
	CRYP          = (*CRYP_Type)(unsafe.Pointer(uintptr(0x50060000)))       // Cryptographic processor
	DCMI          = (*DCMI_Type)(unsafe.Pointer(uintptr(0x50050000)))       // Digital camera interface
	FMC           = (*FSMC_Type)(unsafe.Pointer(uintptr(0xa0000000)))       // Flexible memory controller
	DMA2          = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026400)))        // DMA controller
	RCC           = (*RCC_Type)(unsafe.Pointer(uintptr(0x40023800)))        // Reset and clock control
	GPIOD         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020c00)))       // General-purpose I/Os
	GPIOB         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020400)))       // General-purpose I/Os
	GPIOA         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020000)))       // General-purpose I/Os
	SYSCFG        = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40013800)))     // System configuration controller
	SPI1          = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))        // Serial peripheral interface
	ADC1          = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012000)))        // Analog-to-digital converter
	DAC           = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))        // Digital-to-analog converter
	PWR           = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))        // Power control
	IWDG          = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))       // Independent watchdog
	WWDG          = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))       // Window watchdog
	TIM1          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010000)))        // Advanced-timers
	TIM2          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))        // General purpose timers
	TIM3          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))        // General purpose timers
	TIM4          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))        // General purpose timers
	TIM9          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))        // General purpose timers
	TIM10         = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))        // General-purpose-timers
	TIM6          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))        // Basic timers
	Ethernet_MAC  = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40028000)))   // Ethernet: media access control (MAC)
	CRC           = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))        // Cryptographic processor
	CAN1          = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006400)))        // Controller area network
	Flash         = (*FLASH_Type)(unsafe.Pointer(uintptr(0x40023c00)))      // FLASH
	EXTI          = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40013c00)))       // External interrupt/event controller
	LTCD          = (*LTDC_Type)(unsafe.Pointer(uintptr(0x40016800)))       // LCD-TFT Controller
	SAI1          = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015800)))        // Serial audio interface
	DMA2D         = (*DMA2D_Type)(unsafe.Pointer(uintptr(0x4002b000)))      // DMA2D controller
	QUADSPI       = (*QUADSPI_Type)(unsafe.Pointer(uintptr(0xa0001000)))    // QuadSPI interface
	CEC           = (*CEC_Type)(unsafe.Pointer(uintptr(0x40006c00)))        // HDMI-CEC controller
	SPDIFRX       = (*SPDIF_RX_Type)(unsafe.Pointer(uintptr(0x40004000)))   // Receiver Interface
	SDMMC1        = (*SDMMC_Type)(unsafe.Pointer(uintptr(0x40012c00)))      // Secure digital input/output interface
	LPTIM1        = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40002400)))      // Low power timer
	I2C1          = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))        // Inter-integrated circuit
	RTC           = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))        // Real-time clock
	USART6        = (*USART_Type)(unsafe.Pointer(uintptr(0x40011400)))      // Universal synchronous asynchronous receiver transmitter
	OTG_FS_GLOBAL = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000000))) // USB on the go full speed
	OTG_HS_GLOBAL = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040000))) // USB on the go high speed
	MDIOS         = (*MDIOS_Type)(unsafe.Pointer(uintptr(0x40017800)))      // Management data input/output slave
	DFSDM         = (*DFSDM_Type)(unsafe.Pointer(uintptr(0x40017400)))      // Digital filter for sigma delta modulators
	JPEG          = (*JPEG_Type)(unsafe.Pointer(uintptr(0x50051000)))       // JPEG codec
	Ethernet_MMC  = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40028100)))   // Ethernet: MAC management counters
	Ethernet_PTP  = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40028700)))   // Ethernet: Precision time protocol
	Ethernet_DMA  = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40029000)))   // Ethernet: DMA controller operation
	OTG_FS_HOST   = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000400))) // USB on the go full speed
	OTG_FS_DEVICE = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000800))) // USB on the go full speed
	OTG_FS_PWRCLK = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000e00))) // USB on the go full speed
	OTG_HS_HOST   = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040400))) // USB on the go high speed
	OTG_HS_DEVICE = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040800))) // USB on the go high speed
	OTG_HS_PWRCLK = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040e00))) // USB on the go high speed
	DSI           = (*DSI_Type)(unsafe.Pointer(uintptr(0x40016c00)))        // DSI Host
	NVIC          = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))       // Nested Vectored Interrupt Controller
	MPU           = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))        // Memory protection unit
	STK           = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))        // SysTick timer
	NVIC_STIR     = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))       // Nested vectored interrupt controller
	FPU_CPACR     = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))        // Floating point unit CPACR
	SCB_ACTRL     = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))        // System control block ACTLR
	FPU           = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))        // Floting point unit
	SCB           = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))        // System control block
	PF            = (*PF_Type)(unsafe.Pointer(uintptr(0xe000ed78)))         // Processor features
	AC            = (*AC_Type)(unsafe.Pointer(uintptr(0xe000ef90)))         // Access control
	DMA1          = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026000)))        // DMA controller
	GPIOC         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020800)))       // General-purpose I/Os
	GPIOK         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40022800)))       // General-purpose I/Os
	GPIOJ         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40022400)))       // General-purpose I/Os
	GPIOI         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40022000)))       // General-purpose I/Os
	GPIOH         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021c00)))       // General-purpose I/Os
	GPIOG         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021800)))       // General-purpose I/Os
	GPIOF         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021400)))       // General-purpose I/Os
	GPIOE         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021000)))       // General-purpose I/Os
	SPI2          = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))        // Serial peripheral interface
	SPI4          = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013400)))        // Serial peripheral interface
	SPI5          = (*SPI_Type)(unsafe.Pointer(uintptr(0x40015000)))        // Serial peripheral interface
	SPI3          = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))        // Serial peripheral interface
	SPI6          = (*SPI_Type)(unsafe.Pointer(uintptr(0x40015400)))        // Serial peripheral interface
	ADC2          = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012100)))        // Analog-to-digital converter
	ADC3          = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012200)))        // Analog-to-digital converter
	TIM8          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010400)))        // Advanced-timers
	TIM5          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))        // General purpose timers
	TIM12         = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001800)))        // General purpose timers
	TIM11         = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))        // General-purpose-timers
	TIM13         = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001c00)))        // General-purpose-timers
	TIM14         = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002000)))        // General-purpose-timers
	TIM7          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))        // Basic timers
	CAN2          = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006800)))        // Controller area network
	CAN3          = (*CAN_Type)(unsafe.Pointer(uintptr(0x40003400)))        // Controller area network
	SAI2          = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015c00)))        // Serial audio interface
	SDMMC2        = (*SDMMC_Type)(unsafe.Pointer(uintptr(0x40011c00)))      // Secure digital input/output interface
	I2C2          = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))        // Inter-integrated circuit
	I2C3          = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))        // Inter-integrated circuit
	I2C4          = (*I2C_Type)(unsafe.Pointer(uintptr(0x40006000)))        // Inter-integrated circuit
	USART1        = (*USART_Type)(unsafe.Pointer(uintptr(0x40011000)))      // Universal synchronous asynchronous receiver transmitter
	USART3        = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))      // Universal synchronous asynchronous receiver transmitter
	USART2        = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))      // Universal synchronous asynchronous receiver transmitter
	UART5         = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))      // Universal synchronous asynchronous receiver transmitter
	UART4         = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))      // Universal synchronous asynchronous receiver transmitter
	UART8         = (*USART_Type)(unsafe.Pointer(uintptr(0x40007c00)))      // Universal synchronous asynchronous receiver transmitter
	UART7         = (*USART_Type)(unsafe.Pointer(uintptr(0x40007800)))      // Universal synchronous asynchronous receiver transmitter
)

// Random number generator
type RNG_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	DR volatile.Register32 // 0x8
}

// Hash processor
type HASH_Type struct {
	CR       volatile.Register32 // 0x0
	DIN      volatile.Register32 // 0x4
	STR      volatile.Register32 // 0x8
	HR0      volatile.Register32 // 0xC
	HR1      volatile.Register32 // 0x10
	HR2      volatile.Register32 // 0x14
	HR3      volatile.Register32 // 0x18
	HR4      volatile.Register32 // 0x1C
	IMR      volatile.Register32 // 0x20
	SR       volatile.Register32 // 0x24
	_        [208]byte
	CSR0     volatile.Register32 // 0xF8
	CSR1     volatile.Register32 // 0xFC
	CSR2     volatile.Register32 // 0x100
	CSR3     volatile.Register32 // 0x104
	CSR4     volatile.Register32 // 0x108
	CSR5     volatile.Register32 // 0x10C
	CSR6     volatile.Register32 // 0x110
	CSR7     volatile.Register32 // 0x114
	CSR8     volatile.Register32 // 0x118
	CSR9     volatile.Register32 // 0x11C
	CSR10    volatile.Register32 // 0x120
	CSR11    volatile.Register32 // 0x124
	CSR12    volatile.Register32 // 0x128
	CSR13    volatile.Register32 // 0x12C
	CSR14    volatile.Register32 // 0x130
	CSR15    volatile.Register32 // 0x134
	CSR16    volatile.Register32 // 0x138
	CSR17    volatile.Register32 // 0x13C
	CSR18    volatile.Register32 // 0x140
	CSR19    volatile.Register32 // 0x144
	CSR20    volatile.Register32 // 0x148
	CSR21    volatile.Register32 // 0x14C
	CSR22    volatile.Register32 // 0x150
	CSR23    volatile.Register32 // 0x154
	CSR24    volatile.Register32 // 0x158
	CSR25    volatile.Register32 // 0x15C
	CSR26    volatile.Register32 // 0x160
	CSR27    volatile.Register32 // 0x164
	CSR28    volatile.Register32 // 0x168
	CSR29    volatile.Register32 // 0x16C
	CSR30    volatile.Register32 // 0x170
	CSR31    volatile.Register32 // 0x174
	CSR32    volatile.Register32 // 0x178
	CSR33    volatile.Register32 // 0x17C
	CSR34    volatile.Register32 // 0x180
	CSR35    volatile.Register32 // 0x184
	CSR36    volatile.Register32 // 0x188
	CSR37    volatile.Register32 // 0x18C
	CSR38    volatile.Register32 // 0x190
	CSR39    volatile.Register32 // 0x194
	CSR40    volatile.Register32 // 0x198
	CSR41    volatile.Register32 // 0x19C
	CSR42    volatile.Register32 // 0x1A0
	CSR43    volatile.Register32 // 0x1A4
	CSR44    volatile.Register32 // 0x1A8
	CSR45    volatile.Register32 // 0x1AC
	CSR46    volatile.Register32 // 0x1B0
	CSR47    volatile.Register32 // 0x1B4
	CSR48    volatile.Register32 // 0x1B8
	CSR49    volatile.Register32 // 0x1BC
	CSR50    volatile.Register32 // 0x1C0
	CSR51    volatile.Register32 // 0x1C4
	CSR52    volatile.Register32 // 0x1C8
	CSR53    volatile.Register32 // 0x1CC
	_        [320]byte
	HASH_HR0 volatile.Register32 // 0x310
	HASH_HR1 volatile.Register32 // 0x314
	HASH_HR2 volatile.Register32 // 0x318
	HASH_HR3 volatile.Register32 // 0x31C
	HASH_HR4 volatile.Register32 // 0x320
	HASH_HR5 volatile.Register32 // 0x324
	HASH_HR6 volatile.Register32 // 0x328
	HASH_HR7 volatile.Register32 // 0x32C
}

// Cryptographic processor
type CRYP_Type struct {
	CR         volatile.Register32 // 0x0
	SR         volatile.Register32 // 0x4
	DIN        volatile.Register32 // 0x8
	DOUT       volatile.Register32 // 0xC
	DMACR      volatile.Register32 // 0x10
	IMSCR      volatile.Register32 // 0x14
	RISR       volatile.Register32 // 0x18
	MISR       volatile.Register32 // 0x1C
	K0LR       volatile.Register32 // 0x20
	K0RR       volatile.Register32 // 0x24
	K1LR       volatile.Register32 // 0x28
	K1RR       volatile.Register32 // 0x2C
	K2LR       volatile.Register32 // 0x30
	K2RR       volatile.Register32 // 0x34
	K3LR       volatile.Register32 // 0x38
	K3RR       volatile.Register32 // 0x3C
	IV0LR      volatile.Register32 // 0x40
	IV0RR      volatile.Register32 // 0x44
	IV1LR      volatile.Register32 // 0x48
	IV1RR      volatile.Register32 // 0x4C
	CSGCMCCM0R volatile.Register32 // 0x50
	CSGCMCCM1R volatile.Register32 // 0x54
	CSGCMCCM2R volatile.Register32 // 0x58
	CSGCMCCM3R volatile.Register32 // 0x5C
	CSGCMCCM4R volatile.Register32 // 0x60
	CSGCMCCM5R volatile.Register32 // 0x64
	CSGCMCCM6R volatile.Register32 // 0x68
	CSGCMCCM7R volatile.Register32 // 0x6C
	CSGCM0R    volatile.Register32 // 0x70
	CSGCM1R    volatile.Register32 // 0x74
	CSGCM2R    volatile.Register32 // 0x78
	CSGCM3R    volatile.Register32 // 0x7C
	CSGCM4R    volatile.Register32 // 0x80
	CSGCM5R    volatile.Register32 // 0x84
	CSGCM6R    volatile.Register32 // 0x88
	CSGCM7R    volatile.Register32 // 0x8C
}

// Digital camera interface
type DCMI_Type struct {
	CR     volatile.Register32 // 0x0
	SR     volatile.Register32 // 0x4
	RIS    volatile.Register32 // 0x8
	IER    volatile.Register32 // 0xC
	MIS    volatile.Register32 // 0x10
	ICR    volatile.Register32 // 0x14
	ESCR   volatile.Register32 // 0x18
	ESUR   volatile.Register32 // 0x1C
	CWSTRT volatile.Register32 // 0x20
	CWSIZE volatile.Register32 // 0x24
	DR     volatile.Register32 // 0x28
}

// Flexible memory controller
type FSMC_Type struct {
	BCR1  volatile.Register32 // 0x0
	BTR1  volatile.Register32 // 0x4
	BCR2  volatile.Register32 // 0x8
	BTR2  volatile.Register32 // 0xC
	BCR3  volatile.Register32 // 0x10
	BTR3  volatile.Register32 // 0x14
	BCR4  volatile.Register32 // 0x18
	BTR4  volatile.Register32 // 0x1C
	_     [96]byte
	PCR   volatile.Register32 // 0x80
	SR    volatile.Register32 // 0x84
	PMEM  volatile.Register32 // 0x88
	PATT  volatile.Register32 // 0x8C
	_     [4]byte
	ECCR  volatile.Register32 // 0x94
	_     [108]byte
	BWTR1 volatile.Register32 // 0x104
	_     [4]byte
	BWTR2 volatile.Register32 // 0x10C
	_     [4]byte
	BWTR3 volatile.Register32 // 0x114
	_     [4]byte
	BWTR4 volatile.Register32 // 0x11C
	_     [32]byte
	SDCR1 volatile.Register32 // 0x140
	SDCR2 volatile.Register32 // 0x144
	SDTR1 volatile.Register32 // 0x148
	SDTR2 volatile.Register32 // 0x14C
	SDCMR volatile.Register32 // 0x150
	SDRTR volatile.Register32 // 0x154
	SDSR  volatile.Register32 // 0x158
}

// DMA controller
type DMA_Type struct {
	LISR   volatile.Register32 // 0x0
	HISR   volatile.Register32 // 0x4
	LIFCR  volatile.Register32 // 0x8
	HIFCR  volatile.Register32 // 0xC
	S0CR   volatile.Register32 // 0x10
	S0NDTR volatile.Register32 // 0x14
	S0PAR  volatile.Register32 // 0x18
	S0M0AR volatile.Register32 // 0x1C
	S0M1AR volatile.Register32 // 0x20
	S0FCR  volatile.Register32 // 0x24
	S1CR   volatile.Register32 // 0x28
	S1NDTR volatile.Register32 // 0x2C
	S1PAR  volatile.Register32 // 0x30
	S1M0AR volatile.Register32 // 0x34
	S1M1AR volatile.Register32 // 0x38
	S1FCR  volatile.Register32 // 0x3C
	S2CR   volatile.Register32 // 0x40
	S2NDTR volatile.Register32 // 0x44
	S2PAR  volatile.Register32 // 0x48
	S2M0AR volatile.Register32 // 0x4C
	S2M1AR volatile.Register32 // 0x50
	S2FCR  volatile.Register32 // 0x54
	S3CR   volatile.Register32 // 0x58
	S3NDTR volatile.Register32 // 0x5C
	S3PAR  volatile.Register32 // 0x60
	S3M0AR volatile.Register32 // 0x64
	S3M1AR volatile.Register32 // 0x68
	S3FCR  volatile.Register32 // 0x6C
	S4CR   volatile.Register32 // 0x70
	S4NDTR volatile.Register32 // 0x74
	S4PAR  volatile.Register32 // 0x78
	S4M0AR volatile.Register32 // 0x7C
	S4M1AR volatile.Register32 // 0x80
	S4FCR  volatile.Register32 // 0x84
	S5CR   volatile.Register32 // 0x88
	S5NDTR volatile.Register32 // 0x8C
	S5PAR  volatile.Register32 // 0x90
	S5M0AR volatile.Register32 // 0x94
	S5M1AR volatile.Register32 // 0x98
	S5FCR  volatile.Register32 // 0x9C
	S6CR   volatile.Register32 // 0xA0
	S6NDTR volatile.Register32 // 0xA4
	S6PAR  volatile.Register32 // 0xA8
	S6M0AR volatile.Register32 // 0xAC
	S6M1AR volatile.Register32 // 0xB0
	S6FCR  volatile.Register32 // 0xB4
	S7CR   volatile.Register32 // 0xB8
	S7NDTR volatile.Register32 // 0xBC
	S7PAR  volatile.Register32 // 0xC0
	S7M0AR volatile.Register32 // 0xC4
	S7M1AR volatile.Register32 // 0xC8
	S7FCR  volatile.Register32 // 0xCC
}

// Reset and clock control
type RCC_Type struct {
	CR         volatile.Register32 // 0x0
	PLLCFGR    volatile.Register32 // 0x4
	CFGR       volatile.Register32 // 0x8
	CIR        volatile.Register32 // 0xC
	AHB1RSTR   volatile.Register32 // 0x10
	AHB2RSTR   volatile.Register32 // 0x14
	AHB3RSTR   volatile.Register32 // 0x18
	_          [4]byte
	APB1RSTR   volatile.Register32 // 0x20
	APB2RSTR   volatile.Register32 // 0x24
	_          [8]byte
	AHB1ENR    volatile.Register32 // 0x30
	AHB2ENR    volatile.Register32 // 0x34
	AHB3ENR    volatile.Register32 // 0x38
	_          [4]byte
	APB1ENR    volatile.Register32 // 0x40
	APB2ENR    volatile.Register32 // 0x44
	_          [8]byte
	AHB1LPENR  volatile.Register32 // 0x50
	AHB2LPENR  volatile.Register32 // 0x54
	AHB3LPENR  volatile.Register32 // 0x58
	_          [4]byte
	APB1LPENR  volatile.Register32 // 0x60
	APB2LPENR  volatile.Register32 // 0x64
	_          [8]byte
	BDCR       volatile.Register32 // 0x70
	CSR        volatile.Register32 // 0x74
	_          [8]byte
	SSCGR      volatile.Register32 // 0x80
	PLLI2SCFGR volatile.Register32 // 0x84
	PLLSAICFGR volatile.Register32 // 0x88
	DKCFGR1    volatile.Register32 // 0x8C
	DKCFGR2    volatile.Register32 // 0x90
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER         volatile.Register32 // 0x0
	OTYPER        volatile.Register32 // 0x4
	GPIOB_OSPEEDR volatile.Register32 // 0x8
	PUPDR         volatile.Register32 // 0xC
	IDR           volatile.Register32 // 0x10
	ODR           volatile.Register32 // 0x14
	BSRR          volatile.Register32 // 0x18
	LCKR          volatile.Register32 // 0x1C
	AFRL          volatile.Register32 // 0x20
	AFRH          volatile.Register32 // 0x24
	BRR           volatile.Register32 // 0x28
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRM   volatile.Register32 // 0x0
	PMC     volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	_       [8]byte
	CMPCR   volatile.Register32 // 0x20
}

// Serial peripheral interface
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// Analog-to-digital converter
type ADC_Type struct {
	SR    volatile.Register32 // 0x0
	CR1   volatile.Register32 // 0x4
	CR2   volatile.Register32 // 0x8
	SMPR1 volatile.Register32 // 0xC
	SMPR2 volatile.Register32 // 0x10
	JOFR1 volatile.Register32 // 0x14
	JOFR2 volatile.Register32 // 0x18
	JOFR3 volatile.Register32 // 0x1C
	JOFR4 volatile.Register32 // 0x20
	HTR   volatile.Register32 // 0x24
	LTR   volatile.Register32 // 0x28
	SQR1  volatile.Register32 // 0x2C
	SQR2  volatile.Register32 // 0x30
	SQR3  volatile.Register32 // 0x34
	JSQR  volatile.Register32 // 0x38
	JDR1  volatile.Register32 // 0x3C
	JDR2  volatile.Register32 // 0x40
	JDR3  volatile.Register32 // 0x44
	JDR4  volatile.Register32 // 0x48
	DR    volatile.Register32 // 0x4C
}

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
}

// Power control
type PWR_Type struct {
	CR1  volatile.Register32 // 0x0
	CSR1 volatile.Register32 // 0x4
	CR2  volatile.Register32 // 0x8
	CSR2 volatile.Register32 // 0xC
}

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// Window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// Advanced-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	BDTR         volatile.Register32 // 0x44
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
	_            [4]byte
	CCMR3_Output volatile.Register32 // 0x54
	CCR5         volatile.Register32 // 0x58
	CRR6         volatile.Register32 // 0x5C
	AF1          volatile.Register32 // 0x60
	AF2          volatile.Register32 // 0x64
}

// Ethernet: media access control (MAC)
type Ethernet_Type struct {
	MACCR      volatile.Register32 // 0x0
	MACFFR     volatile.Register32 // 0x4
	MACHTHR    volatile.Register32 // 0x8
	MACHTLR    volatile.Register32 // 0xC
	MACMIIAR   volatile.Register32 // 0x10
	MACMIIDR   volatile.Register32 // 0x14
	MACFCR     volatile.Register32 // 0x18
	MACVLANTR  volatile.Register32 // 0x1C
	_          [12]byte
	MACPMTCSR  volatile.Register32 // 0x2C
	_          [4]byte
	MACDBGR    volatile.Register32 // 0x34
	MACSR      volatile.Register32 // 0x38
	MACIMR     volatile.Register32 // 0x3C
	MACA0HR    volatile.Register32 // 0x40
	MACA0LR    volatile.Register32 // 0x44
	MACA1HR    volatile.Register32 // 0x48
	MACA1LR    volatile.Register32 // 0x4C
	MACA2HR    volatile.Register32 // 0x50
	MACA2LR    volatile.Register32 // 0x54
	MACA3HR    volatile.Register32 // 0x58
	MACA3LR    volatile.Register32 // 0x5C
	MACRWUFFER volatile.Register32 // 0x60
}

// Cryptographic processor
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	INIT volatile.Register32 // 0xC
	POL  volatile.Register32 // 0x10
}

// Controller area network
type CAN_Type struct {
	MCR   volatile.Register32 // 0x0
	MSR   volatile.Register32 // 0x4
	TSR   volatile.Register32 // 0x8
	RF0R  volatile.Register32 // 0xC
	RF1R  volatile.Register32 // 0x10
	IER   volatile.Register32 // 0x14
	ESR   volatile.Register32 // 0x18
	BTR   volatile.Register32 // 0x1C
	_     [352]byte
	TI0R  volatile.Register32 // 0x180
	TDT0R volatile.Register32 // 0x184
	TDL0R volatile.Register32 // 0x188
	TDH0R volatile.Register32 // 0x18C
	TI1R  volatile.Register32 // 0x190
	TDT1R volatile.Register32 // 0x194
	TDL1R volatile.Register32 // 0x198
	TDH1R volatile.Register32 // 0x19C
	TI2R  volatile.Register32 // 0x1A0
	TDT2R volatile.Register32 // 0x1A4
	TDL2R volatile.Register32 // 0x1A8
	TDH2R volatile.Register32 // 0x1AC
	RI0R  volatile.Register32 // 0x1B0
	RDT0R volatile.Register32 // 0x1B4
	RDL0R volatile.Register32 // 0x1B8
	RDH0R volatile.Register32 // 0x1BC
	RI1R  volatile.Register32 // 0x1C0
	RDT1R volatile.Register32 // 0x1C4
	RDL1R volatile.Register32 // 0x1C8
	RDH1R volatile.Register32 // 0x1CC
	_     [48]byte
	FMR   volatile.Register32 // 0x200
	FM1R  volatile.Register32 // 0x204
	_     [4]byte
	FS1R  volatile.Register32 // 0x20C
	_     [4]byte
	FFA1R volatile.Register32 // 0x214
	_     [4]byte
	FA1R  volatile.Register32 // 0x21C
	_     [32]byte
	F0R1  volatile.Register32 // 0x240
	F0R2  volatile.Register32 // 0x244
	F1R1  volatile.Register32 // 0x248
	F1R2  volatile.Register32 // 0x24C
	F2R1  volatile.Register32 // 0x250
	F2R2  volatile.Register32 // 0x254
	F3R1  volatile.Register32 // 0x258
	F3R2  volatile.Register32 // 0x25C
	F4R1  volatile.Register32 // 0x260
	F4R2  volatile.Register32 // 0x264
	F5R1  volatile.Register32 // 0x268
	F5R2  volatile.Register32 // 0x26C
	F6R1  volatile.Register32 // 0x270
	F6R2  volatile.Register32 // 0x274
	F7R1  volatile.Register32 // 0x278
	F7R2  volatile.Register32 // 0x27C
	F8R1  volatile.Register32 // 0x280
	F8R2  volatile.Register32 // 0x284
	F9R1  volatile.Register32 // 0x288
	F9R2  volatile.Register32 // 0x28C
	F10R1 volatile.Register32 // 0x290
	F10R2 volatile.Register32 // 0x294
	F11R1 volatile.Register32 // 0x298
	F11R2 volatile.Register32 // 0x29C
	F12R1 volatile.Register32 // 0x2A0
	F12R2 volatile.Register32 // 0x2A4
	F13R1 volatile.Register32 // 0x2A8
	F13R2 volatile.Register32 // 0x2AC
	F14R1 volatile.Register32 // 0x2B0
	F14R2 volatile.Register32 // 0x2B4
	F15R1 volatile.Register32 // 0x2B8
	F15R2 volatile.Register32 // 0x2BC
	F16R1 volatile.Register32 // 0x2C0
	F16R2 volatile.Register32 // 0x2C4
	F17R1 volatile.Register32 // 0x2C8
	F17R2 volatile.Register32 // 0x2CC
	F18R1 volatile.Register32 // 0x2D0
	F18R2 volatile.Register32 // 0x2D4
	F19R1 volatile.Register32 // 0x2D8
	F19R2 volatile.Register32 // 0x2DC
	F20R1 volatile.Register32 // 0x2E0
	F20R2 volatile.Register32 // 0x2E4
	F21R1 volatile.Register32 // 0x2E8
	F21R2 volatile.Register32 // 0x2EC
	F22R1 volatile.Register32 // 0x2F0
	F22R2 volatile.Register32 // 0x2F4
	F23R1 volatile.Register32 // 0x2F8
	F23R2 volatile.Register32 // 0x2FC
	F24R1 volatile.Register32 // 0x300
	F24R2 volatile.Register32 // 0x304
	F25R1 volatile.Register32 // 0x308
	F25R2 volatile.Register32 // 0x30C
	F26R1 volatile.Register32 // 0x310
	F26R2 volatile.Register32 // 0x314
	F27R1 volatile.Register32 // 0x318
	F27R2 volatile.Register32 // 0x31C
}

// FLASH
type FLASH_Type struct {
	ACR     volatile.Register32 // 0x0
	KEYR    volatile.Register32 // 0x4
	OPTKEYR volatile.Register32 // 0x8
	SR      volatile.Register32 // 0xC
	CR      volatile.Register32 // 0x10
	OPTCR   volatile.Register32 // 0x14
	OPTCR1  volatile.Register32 // 0x18
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR   volatile.Register32 // 0x0
	EMR   volatile.Register32 // 0x4
	RTSR  volatile.Register32 // 0x8
	FTSR  volatile.Register32 // 0xC
	SWIER volatile.Register32 // 0x10
	PR    volatile.Register32 // 0x14
}

// LCD-TFT Controller
type LTDC_Type struct {
	_        [8]byte
	SSCR     volatile.Register32 // 0x8
	BPCR     volatile.Register32 // 0xC
	AWCR     volatile.Register32 // 0x10
	TWCR     volatile.Register32 // 0x14
	GCR      volatile.Register32 // 0x18
	_        [8]byte
	SRCR     volatile.Register32 // 0x24
	_        [4]byte
	BCCR     volatile.Register32 // 0x2C
	_        [4]byte
	IER      volatile.Register32 // 0x34
	ISR      volatile.Register32 // 0x38
	ICR      volatile.Register32 // 0x3C
	LIPCR    volatile.Register32 // 0x40
	CPSR     volatile.Register32 // 0x44
	CDSR     volatile.Register32 // 0x48
	_        [56]byte
	L1CR     volatile.Register32 // 0x84
	L1WHPCR  volatile.Register32 // 0x88
	L1WVPCR  volatile.Register32 // 0x8C
	L1CKCR   volatile.Register32 // 0x90
	L1PFCR   volatile.Register32 // 0x94
	L1CACR   volatile.Register32 // 0x98
	L1DCCR   volatile.Register32 // 0x9C
	L1BFCR   volatile.Register32 // 0xA0
	_        [8]byte
	L1CFBAR  volatile.Register32 // 0xAC
	L1CFBLR  volatile.Register32 // 0xB0
	L1CFBLNR volatile.Register32 // 0xB4
	_        [12]byte
	L1CLUTWR volatile.Register32 // 0xC4
	_        [60]byte
	L2CR     volatile.Register32 // 0x104
	L2WHPCR  volatile.Register32 // 0x108
	L2WVPCR  volatile.Register32 // 0x10C
	L2CKCR   volatile.Register32 // 0x110
	L2PFCR   volatile.Register32 // 0x114
	L2CACR   volatile.Register32 // 0x118
	L2DCCR   volatile.Register32 // 0x11C
	L2BFCR   volatile.Register32 // 0x120
	_        [8]byte
	L2CFBAR  volatile.Register32 // 0x12C
	L2CFBLR  volatile.Register32 // 0x130
	L2CFBLNR volatile.Register32 // 0x134
	_        [12]byte
	L2CLUTWR volatile.Register32 // 0x144
}

// Serial audio interface
type SAI_Type struct {
	GCR    volatile.Register32 // 0x0
	ACR1   volatile.Register32 // 0x4
	ACR2   volatile.Register32 // 0x8
	AFRCR  volatile.Register32 // 0xC
	ASLOTR volatile.Register32 // 0x10
	AIM    volatile.Register32 // 0x14
	ASR    volatile.Register32 // 0x18
	ACLRFR volatile.Register32 // 0x1C
	ADR    volatile.Register32 // 0x20
	BCR1   volatile.Register32 // 0x24
	BCR2   volatile.Register32 // 0x28
	BFRCR  volatile.Register32 // 0x2C
	BSLOTR volatile.Register32 // 0x30
	BIM    volatile.Register32 // 0x34
	BSR    volatile.Register32 // 0x38
	BCLRFR volatile.Register32 // 0x3C
	BDR    volatile.Register32 // 0x40
}

// DMA2D controller
type DMA2D_Type struct {
	CR      volatile.Register32 // 0x0
	ISR     volatile.Register32 // 0x4
	IFCR    volatile.Register32 // 0x8
	FGMAR   volatile.Register32 // 0xC
	FGOR    volatile.Register32 // 0x10
	BGMAR   volatile.Register32 // 0x14
	BGOR    volatile.Register32 // 0x18
	FGPFCCR volatile.Register32 // 0x1C
	FGCOLR  volatile.Register32 // 0x20
	BGPFCCR volatile.Register32 // 0x24
	BGCOLR  volatile.Register32 // 0x28
	FGCMAR  volatile.Register32 // 0x2C
	BGCMAR  volatile.Register32 // 0x30
	OPFCCR  volatile.Register32 // 0x34
	OCOLR   volatile.Register32 // 0x38
	OMAR    volatile.Register32 // 0x3C
	OOR     volatile.Register32 // 0x40
	NLR     volatile.Register32 // 0x44
	LWR     volatile.Register32 // 0x48
	AMTCR   volatile.Register32 // 0x4C
	_       [944]byte
	FGCLUT  volatile.Register32 // 0x400
	_       [1020]byte
	BGCLUT  volatile.Register32 // 0x800
}

// QuadSPI interface
type QUADSPI_Type struct {
	CR    volatile.Register32 // 0x0
	DCR   volatile.Register32 // 0x4
	SR    volatile.Register32 // 0x8
	FCR   volatile.Register32 // 0xC
	DLR   volatile.Register32 // 0x10
	CCR   volatile.Register32 // 0x14
	AR    volatile.Register32 // 0x18
	ABR   volatile.Register32 // 0x1C
	DR    volatile.Register32 // 0x20
	PSMKR volatile.Register32 // 0x24
	PSMAR volatile.Register32 // 0x28
	PIR   volatile.Register32 // 0x2C
	LPTR  volatile.Register32 // 0x30
}

// HDMI-CEC controller
type CEC_Type struct {
	CR   volatile.Register32 // 0x0
	CFGR volatile.Register32 // 0x4
	TXDR volatile.Register32 // 0x8
	RXDR volatile.Register32 // 0xC
	ISR  volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
}

// Receiver Interface
type SPDIF_RX_Type struct {
	CR   volatile.Register32 // 0x0
	IMR  volatile.Register32 // 0x4
	SR   volatile.Register32 // 0x8
	IFCR volatile.Register32 // 0xC
	DR   volatile.Register32 // 0x10
	CSR  volatile.Register32 // 0x14
	DIR  volatile.Register32 // 0x18
}

// Secure digital input/output interface
type SDMMC_Type struct {
	POWER   volatile.Register32 // 0x0
	CLKCR   volatile.Register32 // 0x4
	ARG     volatile.Register32 // 0x8
	CMD     volatile.Register32 // 0xC
	RESPCMD volatile.Register32 // 0x10
	RESP1   volatile.Register32 // 0x14
	RESP2   volatile.Register32 // 0x18
	RESP3   volatile.Register32 // 0x1C
	RESP4   volatile.Register32 // 0x20
	DTIMER  volatile.Register32 // 0x24
	DLEN    volatile.Register32 // 0x28
	DCTRL   volatile.Register32 // 0x2C
	DCOUNT  volatile.Register32 // 0x30
	STA     volatile.Register32 // 0x34
	ICR     volatile.Register32 // 0x38
	MASK    volatile.Register32 // 0x3C
	_       [8]byte
	FIFOCNT volatile.Register32 // 0x48
	_       [52]byte
	FIFO    volatile.Register32 // 0x80
}

// Low power timer
type LPTIM_Type struct {
	ISR  volatile.Register32 // 0x0
	ICR  volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	CFGR volatile.Register32 // 0xC
	CR   volatile.Register32 // 0x10
	CMP  volatile.Register32 // 0x14
	ARR  volatile.Register32 // 0x18
	CNT  volatile.Register32 // 0x1C
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAMPCR   volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	OR       volatile.Register32 // 0x4C
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
	BKP20R   volatile.Register32 // 0xA0
	BKP21R   volatile.Register32 // 0xA4
	BKP22R   volatile.Register32 // 0xA8
	BKP23R   volatile.Register32 // 0xAC
	BKP24R   volatile.Register32 // 0xB0
	BKP25R   volatile.Register32 // 0xB4
	BKP26R   volatile.Register32 // 0xB8
	BKP27R   volatile.Register32 // 0xBC
	BKP28R   volatile.Register32 // 0xC0
	BKP29R   volatile.Register32 // 0xC4
	BKP30R   volatile.Register32 // 0xC8
	BKP31R   volatile.Register32 // 0xCC
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1  volatile.Register32 // 0x0
	CR2  volatile.Register32 // 0x4
	CR3  volatile.Register32 // 0x8
	BRR  volatile.Register32 // 0xC
	GTPR volatile.Register32 // 0x10
	RTOR volatile.Register32 // 0x14
	RQR  volatile.Register32 // 0x18
	ISR  volatile.Register32 // 0x1C
	ICR  volatile.Register32 // 0x20
	RDR  volatile.Register32 // 0x24
	TDR  volatile.Register32 // 0x28
}

// USB on the go full speed
type USB_OTG_FS_Type struct {
	OTG_FS_GOTGCTL         volatile.Register32 // 0x0
	OTG_FS_GOTGINT         volatile.Register32 // 0x4
	OTG_FS_GAHBCFG         volatile.Register32 // 0x8
	OTG_FS_GUSBCFG         volatile.Register32 // 0xC
	OTG_FS_GRSTCTL         volatile.Register32 // 0x10
	OTG_FS_GINTSTS         volatile.Register32 // 0x14
	OTG_FS_GINTMSK         volatile.Register32 // 0x18
	OTG_FS_GRXSTSR_Device  volatile.Register32 // 0x1C
	OTG_FS_GRXSTSP_Device  volatile.Register32 // 0x20
	OTG_FS_GRXFSIZ         volatile.Register32 // 0x24
	OTG_FS_DIEPTXF0_Device volatile.Register32 // 0x28
	OTG_FS_HNPTXSTS        volatile.Register32 // 0x2C
	OTG_FS_GI2CCTL         volatile.Register32 // 0x30
	_                      [4]byte
	OTG_FS_GCCFG           volatile.Register32 // 0x38
	OTG_FS_CID             volatile.Register32 // 0x3C
	_                      [20]byte
	OTG_FS_GLPMCFG         volatile.Register32 // 0x54
	OTG_FS_GPWRDN          volatile.Register32 // 0x58
	_                      [4]byte
	OTG_FS_GADPCTL         volatile.Register32 // 0x60
	_                      [156]byte
	OTG_FS_HPTXFSIZ        volatile.Register32 // 0x100
	OTG_FS_DIEPTXF1        volatile.Register32 // 0x104
	OTG_FS_DIEPTXF2        volatile.Register32 // 0x108
	OTG_FS_DIEPTXF3        volatile.Register32 // 0x10C
	OTG_FS_DIEPTXF4        volatile.Register32 // 0x110
	OTG_FS_DIEPTXF5        volatile.Register32 // 0x114
}

// USB on the go high speed
type USB_OTG_HS_Type struct {
	OTG_HS_GOTGCTL        volatile.Register32 // 0x0
	OTG_HS_GOTGINT        volatile.Register32 // 0x4
	OTG_HS_GAHBCFG        volatile.Register32 // 0x8
	OTG_HS_GUSBCFG        volatile.Register32 // 0xC
	OTG_HS_GRSTCTL        volatile.Register32 // 0x10
	OTG_HS_GINTSTS        volatile.Register32 // 0x14
	OTG_HS_GINTMSK        volatile.Register32 // 0x18
	OTG_HS_GRXSTSR_Host   volatile.Register32 // 0x1C
	OTG_HS_GRXSTSP_Host   volatile.Register32 // 0x20
	OTG_HS_GRXFSIZ        volatile.Register32 // 0x24
	OTG_HS_HNPTXFSIZ_Host volatile.Register32 // 0x28
	OTG_HS_GNPTXSTS       volatile.Register32 // 0x2C
	_                     [8]byte
	OTG_HS_GCCFG          volatile.Register32 // 0x38
	OTG_HS_CID            volatile.Register32 // 0x3C
	_                     [20]byte
	OTG_HS_GLPMCFG        volatile.Register32 // 0x54
	_                     [168]byte
	OTG_HS_HPTXFSIZ       volatile.Register32 // 0x100
	OTG_HS_DIEPTXF1       volatile.Register32 // 0x104
	OTG_HS_DIEPTXF2       volatile.Register32 // 0x108
	_                     [16]byte
	OTG_HS_DIEPTXF3       volatile.Register32 // 0x11C
	OTG_HS_DIEPTXF4       volatile.Register32 // 0x120
	OTG_HS_DIEPTXF5       volatile.Register32 // 0x124
	OTG_HS_DIEPTXF6       volatile.Register32 // 0x128
	OTG_HS_DIEPTXF7       volatile.Register32 // 0x12C
}

// Management data input/output slave
type MDIOS_Type struct {
	MDIOS_CR      volatile.Register32 // 0x0
	MDIOS_WRFR    volatile.Register32 // 0x4
	MDIOS_CWRFR   volatile.Register32 // 0x8
	MDIOS_RDFR    volatile.Register32 // 0xC
	MDIOS_CRDFR   volatile.Register32 // 0x10
	MDIOS_SR      volatile.Register32 // 0x14
	MDIOS_CLRFR   volatile.Register32 // 0x18
	MDIOS_DINR0   volatile.Register32 // 0x1C
	MDIOS_DINR1   volatile.Register32 // 0x20
	MDIOS_DINR2   volatile.Register32 // 0x24
	MDIOS_DINR3   volatile.Register32 // 0x28
	MDIOS_DINR4   volatile.Register32 // 0x2C
	MDIOS_DINR5   volatile.Register32 // 0x30
	MDIOS_DINR6   volatile.Register32 // 0x34
	MDIOS_DINR7   volatile.Register32 // 0x38
	MDIOS_DINR8   volatile.Register32 // 0x3C
	MDIOS_DINR9   volatile.Register32 // 0x40
	MDIOS_DINR10  volatile.Register32 // 0x44
	MDIOS_DINR11  volatile.Register32 // 0x48
	MDIOS_DINR12  volatile.Register32 // 0x4C
	MDIOS_DINR13  volatile.Register32 // 0x50
	MDIOS_DINR14  volatile.Register32 // 0x54
	MDIOS_DINR15  volatile.Register32 // 0x58
	MDIOS_DINR16  volatile.Register32 // 0x5C
	MDIOS_DINR17  volatile.Register32 // 0x60
	MDIOS_DINR18  volatile.Register32 // 0x64
	MDIOS_DINR19  volatile.Register32 // 0x68
	MDIOS_DINR20  volatile.Register32 // 0x6C
	MDIOS_DINR21  volatile.Register32 // 0x70
	MDIOS_DINR22  volatile.Register32 // 0x74
	MDIOS_DINR23  volatile.Register32 // 0x78
	MDIOS_DINR24  volatile.Register32 // 0x7C
	MDIOS_DINR25  volatile.Register32 // 0x80
	MDIOS_DINR26  volatile.Register32 // 0x84
	MDIOS_DINR27  volatile.Register32 // 0x88
	MDIOS_DINR28  volatile.Register32 // 0x8C
	MDIOS_DINR29  volatile.Register32 // 0x90
	MDIOS_DINR30  volatile.Register32 // 0x94
	MDIOS_DINR31  volatile.Register32 // 0x98
	MDIOS_DOUTR0  volatile.Register32 // 0x9C
	MDIOS_DOUTR1  volatile.Register32 // 0xA0
	MDIOS_DOUTR2  volatile.Register32 // 0xA4
	MDIOS_DOUTR3  volatile.Register32 // 0xA8
	MDIOS_DOUTR4  volatile.Register32 // 0xAC
	MDIOS_DOUTR5  volatile.Register32 // 0xB0
	MDIOS_DOUTR6  volatile.Register32 // 0xB4
	MDIOS_DOUTR7  volatile.Register32 // 0xB8
	MDIOS_DOUTR8  volatile.Register32 // 0xBC
	MDIOS_DOUTR9  volatile.Register32 // 0xC0
	MDIOS_DOUTR10 volatile.Register32 // 0xC4
	MDIOS_DOUTR11 volatile.Register32 // 0xC8
	MDIOS_DOUTR12 volatile.Register32 // 0xCC
	MDIOS_DOUTR13 volatile.Register32 // 0xD0
	MDIOS_DOUTR14 volatile.Register32 // 0xD4
	MDIOS_DOUTR15 volatile.Register32 // 0xD8
	MDIOS_DOUTR16 volatile.Register32 // 0xDC
	MDIOS_DOUTR17 volatile.Register32 // 0xE0
	MDIOS_DOUTR18 volatile.Register32 // 0xE4
	MDIOS_DOUTR19 volatile.Register32 // 0xE8
	MDIOS_DOUTR20 volatile.Register32 // 0xEC
	MDIOS_DOUTR21 volatile.Register32 // 0xF0
	MDIOS_DOUTR22 volatile.Register32 // 0xF4
	MDIOS_DOUTR23 volatile.Register32 // 0xF8
	MDIOS_DOUTR24 volatile.Register32 // 0xFC
	MDIOS_DOUTR25 volatile.Register32 // 0x100
	MDIOS_DOUTR26 volatile.Register32 // 0x104
	MDIOS_DOUTR27 volatile.Register32 // 0x108
	MDIOS_DOUTR28 volatile.Register32 // 0x10C
	MDIOS_DOUTR29 volatile.Register32 // 0x110
	MDIOS_DOUTR30 volatile.Register32 // 0x114
	MDIOS_DOUTR31 volatile.Register32 // 0x118
}

// Digital filter for sigma delta modulators
type DFSDM_Type struct {
	DFSDM_CHCFG0R1  volatile.Register32 // 0x0
	DFSDM_CHCFG0R2  volatile.Register32 // 0x4
	DFSDM_AWSCD0R   volatile.Register32 // 0x8
	DFSDM_CHWDAT0R  volatile.Register32 // 0xC
	DFSDM_CHDATIN0R volatile.Register32 // 0x10
	_               [12]byte
	DFSDM_CHCFG1R1  volatile.Register32 // 0x20
	DFSDM_CHCFG1R2  volatile.Register32 // 0x24
	DFSDM_AWSCD1R   volatile.Register32 // 0x28
	DFSDM_CHWDAT1R  volatile.Register32 // 0x2C
	DFSDM_CHDATIN1R volatile.Register32 // 0x30
	_               [12]byte
	DFSDM_CHCFG2R1  volatile.Register32 // 0x40
	DFSDM_CHCFG2R2  volatile.Register32 // 0x44
	DFSDM_AWSCD2R   volatile.Register32 // 0x48
	DFSDM_CHWDAT2R  volatile.Register32 // 0x4C
	DFSDM_CHDATIN2R volatile.Register32 // 0x50
	_               [12]byte
	DFSDM_CHCFG3R1  volatile.Register32 // 0x60
	DFSDM_CHCFG3R2  volatile.Register32 // 0x64
	DFSDM_AWSCD3R   volatile.Register32 // 0x68
	DFSDM_CHWDAT3R  volatile.Register32 // 0x6C
	DFSDM_CHDATIN3R volatile.Register32 // 0x70
	_               [12]byte
	DFSDM_CHCFG4R1  volatile.Register32 // 0x80
	DFSDM_CHCFG4R2  volatile.Register32 // 0x84
	DFSDM_AWSCD4R   volatile.Register32 // 0x88
	DFSDM_CHWDAT4R  volatile.Register32 // 0x8C
	DFSDM_CHDATIN4R volatile.Register32 // 0x90
	_               [12]byte
	DFSDM_CHCFG5R1  volatile.Register32 // 0xA0
	DFSDM_CHCFG5R2  volatile.Register32 // 0xA4
	DFSDM_AWSCD5R   volatile.Register32 // 0xA8
	DFSDM_CHWDAT5R  volatile.Register32 // 0xAC
	DFSDM_CHDATIN5R volatile.Register32 // 0xB0
	_               [12]byte
	DFSDM_CHCFG6R1  volatile.Register32 // 0xC0
	DFSDM_CHCFG6R2  volatile.Register32 // 0xC4
	DFSDM_AWSCD6R   volatile.Register32 // 0xC8
	DFSDM_CHWDAT6R  volatile.Register32 // 0xCC
	DFSDM_CHDATIN6R volatile.Register32 // 0xD0
	_               [12]byte
	DFSDM_CHCFG7R1  volatile.Register32 // 0xE0
	DFSDM_CHCFG7R2  volatile.Register32 // 0xE4
	DFSDM_AWSCD7R   volatile.Register32 // 0xE8
	DFSDM_CHWDAT7R  volatile.Register32 // 0xEC
	DFSDM_CHDATIN7R volatile.Register32 // 0xF0
	_               [12]byte
	DFSDM0_CR1      volatile.Register32 // 0x100
	DFSDM0_CR2      volatile.Register32 // 0x104
	DFSDM0_ISR      volatile.Register32 // 0x108
	DFSDM0_ICR      volatile.Register32 // 0x10C
	DFSDM0_JCHGR    volatile.Register32 // 0x110
	DFSDM0_FCR      volatile.Register32 // 0x114
	DFSDM0_JDATAR   volatile.Register32 // 0x118
	DFSDM0_RDATAR   volatile.Register32 // 0x11C
	DFSDM0_AWHTR    volatile.Register32 // 0x120
	DFSDM0_AWLTR    volatile.Register32 // 0x124
	DFSDM0_AWSR     volatile.Register32 // 0x128
	DFSDM0_AWCFR    volatile.Register32 // 0x12C
	DFSDM0_EXMAX    volatile.Register32 // 0x130
	DFSDM0_EXMIN    volatile.Register32 // 0x134
	DFSDM0_CNVTIMR  volatile.Register32 // 0x138
	_               [68]byte
	DFSDM1_CR1      volatile.Register32 // 0x180
	DFSDM1_CR2      volatile.Register32 // 0x184
	DFSDM1_ISR      volatile.Register32 // 0x188
	DFSDM1_ICR      volatile.Register32 // 0x18C
	DFSDM1_JCHGR    volatile.Register32 // 0x190
	DFSDM1_FCR      volatile.Register32 // 0x194
	DFSDM1_JDATAR   volatile.Register32 // 0x198
	_               [4]byte
	DFSDM1_AWHTR    volatile.Register32 // 0x1A0
	DFSDM1_AWLTR    volatile.Register32 // 0x1A4
	DFSDM1_AWSR     volatile.Register32 // 0x1A8
	DFSDM1_AWCFR    volatile.Register32 // 0x1AC
	DFSDM1_EXMAX    volatile.Register32 // 0x1B0
	DFSDM1_EXMIN    volatile.Register32 // 0x1B4
	DFSDM1_CNVTIMR  volatile.Register32 // 0x1B8
	_               [68]byte
	DFSDM2_CR1      volatile.Register32 // 0x200
	DFSDM2_CR2      volatile.Register32 // 0x204
	DFSDM2_ISR      volatile.Register32 // 0x208
	DFSDM2_ICR      volatile.Register32 // 0x20C
	DFSDM2_JCHGR    volatile.Register32 // 0x210
	DFSDM2_FCR      volatile.Register32 // 0x214
	DFSDM2_JDATAR   volatile.Register32 // 0x218
	_               [4]byte
	DFSDM2_AWHTR    volatile.Register32 // 0x220
	DFSDM2_AWLTR    volatile.Register32 // 0x224
	DFSDM2_AWSR     volatile.Register32 // 0x228
	DFSDM2_AWCFR    volatile.Register32 // 0x22C
	DFSDM2_EXMAX    volatile.Register32 // 0x230
	DFSDM2_EXMIN    volatile.Register32 // 0x234
	DFSDM2_CNVTIMR  volatile.Register32 // 0x238
	_               [100]byte
	DFSDM3_AWHTR    volatile.Register32 // 0x2A0
	DFSDM3_AWLTR    volatile.Register32 // 0x2A4
	DFSDM3_AWSR     volatile.Register32 // 0x2A8
	DFSDM3_AWCFR    volatile.Register32 // 0x2AC
	DFSDM3_EXMAX    volatile.Register32 // 0x2B0
	DFSDM3_EXMIN    volatile.Register32 // 0x2B4
	DFSDM3_CNVTIMR  volatile.Register32 // 0x2B8
	_               [84]byte
	DFSDM3_JCHGR    volatile.Register32 // 0x310
	DFSDM3_FCR      volatile.Register32 // 0x314
	DFSDM3_JDATAR   volatile.Register32 // 0x318
	_               [100]byte
	DFSDM3_CR1      volatile.Register32 // 0x380
	DFSDM3_CR2      volatile.Register32 // 0x384
	DFSDM3_ISR      volatile.Register32 // 0x388
	DFSDM3_ICR      volatile.Register32 // 0x38C
}

// JPEG codec
type JPEG_Type struct {
	JPEG_CONFR0    volatile.Register32 // 0x0
	JPEG_CONFR1    volatile.Register32 // 0x4
	JPEG_CONFR2    volatile.Register32 // 0x8
	JPEG_CONFR3    volatile.Register32 // 0xC
	JPEG_CONFR4    volatile.Register32 // 0x10
	JPEG_CONFR5    volatile.Register32 // 0x14
	JPEG_CONFR6    volatile.Register32 // 0x18
	JPEG_CONFR7    volatile.Register32 // 0x1C
	_              [16]byte
	JPEG_CR        volatile.Register32 // 0x30
	JPEG_SR        volatile.Register32 // 0x34
	JPEG_CFR       volatile.Register32 // 0x38
	_              [4]byte
	JPEG_DIR       volatile.Register32 // 0x40
	JPEG_DOR       volatile.Register32 // 0x44
	_              [8]byte
	QMEM0_0        volatile.Register32 // 0x50
	QMEM0_1        volatile.Register32 // 0x54
	QMEM0_2        volatile.Register32 // 0x58
	QMEM0_3        volatile.Register32 // 0x5C
	QMEM0_4        volatile.Register32 // 0x60
	QMEM0_5        volatile.Register32 // 0x64
	QMEM0_6        volatile.Register32 // 0x68
	QMEM0_7        volatile.Register32 // 0x6C
	QMEM0_8        volatile.Register32 // 0x70
	QMEM0_9        volatile.Register32 // 0x74
	QMEM0_10       volatile.Register32 // 0x78
	QMEM0_11       volatile.Register32 // 0x7C
	QMEM0_12       volatile.Register32 // 0x80
	QMEM0_13       volatile.Register32 // 0x84
	QMEM0_14       volatile.Register32 // 0x88
	QMEM0_15       volatile.Register32 // 0x8C
	QMEM1_0        volatile.Register32 // 0x90
	QMEM1_1        volatile.Register32 // 0x94
	QMEM1_2        volatile.Register32 // 0x98
	QMEM1_3        volatile.Register32 // 0x9C
	QMEM1_4        volatile.Register32 // 0xA0
	QMEM1_5        volatile.Register32 // 0xA4
	QMEM1_6        volatile.Register32 // 0xA8
	QMEM1_7        volatile.Register32 // 0xAC
	QMEM1_8        volatile.Register32 // 0xB0
	QMEM1_9        volatile.Register32 // 0xB4
	QMEM1_10       volatile.Register32 // 0xB8
	QMEM1_11       volatile.Register32 // 0xBC
	QMEM1_12       volatile.Register32 // 0xC0
	QMEM1_13       volatile.Register32 // 0xC4
	QMEM1_14       volatile.Register32 // 0xC8
	QMEM1_15       volatile.Register32 // 0xCC
	QMEM2_0        volatile.Register32 // 0xD0
	QMEM2_1        volatile.Register32 // 0xD4
	QMEM2_2        volatile.Register32 // 0xD8
	QMEM2_3        volatile.Register32 // 0xDC
	QMEM2_4        volatile.Register32 // 0xE0
	QMEM2_5        volatile.Register32 // 0xE4
	QMEM2_6        volatile.Register32 // 0xE8
	QMEM2_7        volatile.Register32 // 0xEC
	QMEM2_8        volatile.Register32 // 0xF0
	QMEM2_9        volatile.Register32 // 0xF4
	QMEM2_10       volatile.Register32 // 0xF8
	QMEM2_11       volatile.Register32 // 0xFC
	QMEM2_12       volatile.Register32 // 0x100
	QMEM2_13       volatile.Register32 // 0x104
	QMEM2_14       volatile.Register32 // 0x108
	QMEM2_15       volatile.Register32 // 0x10C
	QMEM3_0        volatile.Register32 // 0x110
	QMEM3_1        volatile.Register32 // 0x114
	QMEM3_2        volatile.Register32 // 0x118
	QMEM3_3        volatile.Register32 // 0x11C
	QMEM3_4        volatile.Register32 // 0x120
	QMEM3_5        volatile.Register32 // 0x124
	QMEM3_6        volatile.Register32 // 0x128
	QMEM3_7        volatile.Register32 // 0x12C
	QMEM3_8        volatile.Register32 // 0x130
	QMEM3_9        volatile.Register32 // 0x134
	QMEM3_10       volatile.Register32 // 0x138
	QMEM3_11       volatile.Register32 // 0x13C
	QMEM3_12       volatile.Register32 // 0x140
	QMEM3_13       volatile.Register32 // 0x144
	QMEM3_14       volatile.Register32 // 0x148
	QMEM3_15       volatile.Register32 // 0x14C
	HUFFMIN_0      volatile.Register32 // 0x150
	HUFFMIN_1      volatile.Register32 // 0x154
	HUFFMIN_2      volatile.Register32 // 0x158
	HUFFMIN_3      volatile.Register32 // 0x15C
	HUFFMIN_4      volatile.Register32 // 0x160
	HUFFMIN_5      volatile.Register32 // 0x164
	HUFFMIN_6      volatile.Register32 // 0x168
	HUFFMIN_7      volatile.Register32 // 0x16C
	HUFFMIN_8      volatile.Register32 // 0x170
	HUFFMIN_9      volatile.Register32 // 0x174
	HUFFMIN_10     volatile.Register32 // 0x178
	HUFFMIN_11     volatile.Register32 // 0x17C
	HUFFMIN_12     volatile.Register32 // 0x180
	HUFFMIN_13     volatile.Register32 // 0x184
	HUFFMIN_14     volatile.Register32 // 0x188
	HUFFMIN_15     volatile.Register32 // 0x18C
	HUFFBASE0      volatile.Register32 // 0x190
	HUFFBASE1      volatile.Register32 // 0x194
	HUFFBASE2      volatile.Register32 // 0x198
	HUFFBASE3      volatile.Register32 // 0x19C
	HUFFBASE4      volatile.Register32 // 0x1A0
	HUFFBASE5      volatile.Register32 // 0x1A4
	HUFFBASE6      volatile.Register32 // 0x1A8
	HUFFBASE7      volatile.Register32 // 0x1AC
	HUFFBASE8      volatile.Register32 // 0x1B0
	HUFFBASE9      volatile.Register32 // 0x1B4
	HUFFBASE10     volatile.Register32 // 0x1B8
	HUFFBASE11     volatile.Register32 // 0x1BC
	HUFFBASE12     volatile.Register32 // 0x1C0
	HUFFBASE13     volatile.Register32 // 0x1C4
	HUFFBASE14     volatile.Register32 // 0x1C8
	HUFFBASE15     volatile.Register32 // 0x1CC
	HUFFBASE16     volatile.Register32 // 0x1D0
	HUFFBASE17     volatile.Register32 // 0x1D4
	HUFFBASE18     volatile.Register32 // 0x1D8
	HUFFBASE19     volatile.Register32 // 0x1DC
	HUFFBASE20     volatile.Register32 // 0x1E0
	HUFFBASE21     volatile.Register32 // 0x1E4
	HUFFBASE22     volatile.Register32 // 0x1E8
	HUFFBASE23     volatile.Register32 // 0x1EC
	HUFFBASE24     volatile.Register32 // 0x1F0
	HUFFBASE25     volatile.Register32 // 0x1F4
	HUFFBASE26     volatile.Register32 // 0x1F8
	HUFFBASE27     volatile.Register32 // 0x1FC
	HUFFBASE28     volatile.Register32 // 0x200
	HUFFBASE29     volatile.Register32 // 0x204
	HUFFBASE30     volatile.Register32 // 0x208
	HUFFBASE31     volatile.Register32 // 0x20C
	HUFFSYMB0      volatile.Register32 // 0x210
	HUFFSYMB1      volatile.Register32 // 0x214
	HUFFSYMB2      volatile.Register32 // 0x218
	HUFFSYMB3      volatile.Register32 // 0x21C
	HUFFSYMB4      volatile.Register32 // 0x220
	HUFFSYMB5      volatile.Register32 // 0x224
	HUFFSYMB6      volatile.Register32 // 0x228
	HUFFSYMB7      volatile.Register32 // 0x22C
	HUFFSYMB8      volatile.Register32 // 0x230
	HUFFSYMB9      volatile.Register32 // 0x234
	HUFFSYMB10     volatile.Register32 // 0x238
	HUFFSYMB11     volatile.Register32 // 0x23C
	HUFFSYMB12     volatile.Register32 // 0x240
	HUFFSYMB13     volatile.Register32 // 0x244
	HUFFSYMB14     volatile.Register32 // 0x248
	HUFFSYMB15     volatile.Register32 // 0x24C
	HUFFSYMB16     volatile.Register32 // 0x250
	HUFFSYMB17     volatile.Register32 // 0x254
	HUFFSYMB18     volatile.Register32 // 0x258
	HUFFSYMB19     volatile.Register32 // 0x25C
	HUFFSYMB20     volatile.Register32 // 0x260
	HUFFSYMB21     volatile.Register32 // 0x264
	HUFFSYMB22     volatile.Register32 // 0x268
	HUFFSYMB23     volatile.Register32 // 0x26C
	HUFFSYMB24     volatile.Register32 // 0x270
	HUFFSYMB25     volatile.Register32 // 0x274
	HUFFSYMB26     volatile.Register32 // 0x278
	HUFFSYMB27     volatile.Register32 // 0x27C
	HUFFSYMB28     volatile.Register32 // 0x280
	HUFFSYMB29     volatile.Register32 // 0x284
	HUFFSYMB30     volatile.Register32 // 0x288
	HUFFSYMB31     volatile.Register32 // 0x28C
	HUFFSYMB32     volatile.Register32 // 0x290
	HUFFSYMB33     volatile.Register32 // 0x294
	HUFFSYMB34     volatile.Register32 // 0x298
	HUFFSYMB35     volatile.Register32 // 0x29C
	HUFFSYMB36     volatile.Register32 // 0x2A0
	HUFFSYMB37     volatile.Register32 // 0x2A4
	HUFFSYMB38     volatile.Register32 // 0x2A8
	HUFFSYMB39     volatile.Register32 // 0x2AC
	HUFFSYMB40     volatile.Register32 // 0x2B0
	HUFFSYMB41     volatile.Register32 // 0x2B4
	HUFFSYMB42     volatile.Register32 // 0x2B8
	HUFFSYMB43     volatile.Register32 // 0x2BC
	HUFFSYMB44     volatile.Register32 // 0x2C0
	HUFFSYMB45     volatile.Register32 // 0x2C4
	HUFFSYMB46     volatile.Register32 // 0x2C8
	HUFFSYMB47     volatile.Register32 // 0x2CC
	HUFFSYMB48     volatile.Register32 // 0x2D0
	HUFFSYMB49     volatile.Register32 // 0x2D4
	HUFFSYMB50     volatile.Register32 // 0x2D8
	HUFFSYMB51     volatile.Register32 // 0x2DC
	HUFFSYMB52     volatile.Register32 // 0x2E0
	HUFFSYMB53     volatile.Register32 // 0x2E4
	HUFFSYMB54     volatile.Register32 // 0x2E8
	HUFFSYMB55     volatile.Register32 // 0x2EC
	HUFFSYMB56     volatile.Register32 // 0x2F0
	HUFFSYMB57     volatile.Register32 // 0x2F4
	HUFFSYMB58     volatile.Register32 // 0x2F8
	HUFFSYMB59     volatile.Register32 // 0x2FC
	HUFFSYMB60     volatile.Register32 // 0x300
	HUFFSYMB61     volatile.Register32 // 0x304
	HUFFSYMB62     volatile.Register32 // 0x308
	HUFFSYMB63     volatile.Register32 // 0x30C
	HUFFSYMB64     volatile.Register32 // 0x310
	HUFFSYMB65     volatile.Register32 // 0x314
	HUFFSYMB66     volatile.Register32 // 0x318
	HUFFSYMB67     volatile.Register32 // 0x31C
	HUFFSYMB68     volatile.Register32 // 0x320
	HUFFSYMB69     volatile.Register32 // 0x324
	HUFFSYMB70     volatile.Register32 // 0x328
	HUFFSYMB71     volatile.Register32 // 0x32C
	HUFFSYMB72     volatile.Register32 // 0x330
	HUFFSYMB73     volatile.Register32 // 0x334
	HUFFSYMB74     volatile.Register32 // 0x338
	HUFFSYMB75     volatile.Register32 // 0x33C
	HUFFSYMB76     volatile.Register32 // 0x340
	HUFFSYMB77     volatile.Register32 // 0x344
	HUFFSYMB78     volatile.Register32 // 0x348
	HUFFSYMB79     volatile.Register32 // 0x34C
	HUFFSYMB80     volatile.Register32 // 0x350
	HUFFSYMB81     volatile.Register32 // 0x354
	HUFFSYMB82     volatile.Register32 // 0x358
	HUFFSYMB83     volatile.Register32 // 0x35C
	DHTMEM0        volatile.Register32 // 0x360
	DHTMEM2        volatile.Register32 // 0x364
	DHTMEM3        volatile.Register32 // 0x368
	DHTMEM4        volatile.Register32 // 0x36C
	DHTMEM5        volatile.Register32 // 0x370
	DHTMEM6        volatile.Register32 // 0x374
	DHTMEM7        volatile.Register32 // 0x378
	DHTMEM8        volatile.Register32 // 0x37C
	DHTMEM9        volatile.Register32 // 0x380
	DHTMEM10       volatile.Register32 // 0x384
	DHTMEM11       volatile.Register32 // 0x388
	DHTMEM12       volatile.Register32 // 0x38C
	DHTMEM13       volatile.Register32 // 0x390
	DHTMEM14       volatile.Register32 // 0x394
	DHTMEM15       volatile.Register32 // 0x398
	DHTMEM16       volatile.Register32 // 0x39C
	DHTMEM17       volatile.Register32 // 0x3A0
	DHTMEM18       volatile.Register32 // 0x3A4
	DHTMEM19       volatile.Register32 // 0x3A8
	DHTMEM20       volatile.Register32 // 0x3AC
	DHTMEM21       volatile.Register32 // 0x3B0
	DHTMEM22       volatile.Register32 // 0x3B4
	DHTMEM23       volatile.Register32 // 0x3B8
	DHTMEM24       volatile.Register32 // 0x3BC
	DHTMEM25       volatile.Register32 // 0x3C0
	DHTMEM26       volatile.Register32 // 0x3C4
	DHTMEM27       volatile.Register32 // 0x3C8
	DHTMEM28       volatile.Register32 // 0x3CC
	DHTMEM29       volatile.Register32 // 0x3D0
	DHTMEM30       volatile.Register32 // 0x3D4
	DHTMEM31       volatile.Register32 // 0x3D8
	DHTMEM32       volatile.Register32 // 0x3DC
	DHTMEM33       volatile.Register32 // 0x3E0
	DHTMEM34       volatile.Register32 // 0x3E4
	DHTMEM35       volatile.Register32 // 0x3E8
	DHTMEM36       volatile.Register32 // 0x3EC
	DHTMEM37       volatile.Register32 // 0x3F0
	DHTMEM38       volatile.Register32 // 0x3F4
	DHTMEM39       volatile.Register32 // 0x3F8
	DHTMEM40       volatile.Register32 // 0x3FC
	DHTMEM41       volatile.Register32 // 0x400
	DHTMEM42       volatile.Register32 // 0x404
	DHTMEM43       volatile.Register32 // 0x408
	DHTMEM44       volatile.Register32 // 0x40C
	DHTMEM45       volatile.Register32 // 0x410
	DHTMEM46       volatile.Register32 // 0x414
	DHTMEM47       volatile.Register32 // 0x418
	DHTMEM48       volatile.Register32 // 0x41C
	DHTMEM49       volatile.Register32 // 0x420
	DHTMEM50       volatile.Register32 // 0x424
	DHTMEM51       volatile.Register32 // 0x428
	DHTMEM52       volatile.Register32 // 0x42C
	DHTMEM53       volatile.Register32 // 0x430
	DHTMEM54       volatile.Register32 // 0x434
	DHTMEM55       volatile.Register32 // 0x438
	DHTMEM56       volatile.Register32 // 0x43C
	DHTMEM57       volatile.Register32 // 0x440
	DHTMEM58       volatile.Register32 // 0x444
	DHTMEM59       volatile.Register32 // 0x448
	DHTMEM60       volatile.Register32 // 0x44C
	DHTMEM61       volatile.Register32 // 0x450
	DHTMEM62       volatile.Register32 // 0x454
	DHTMEM63       volatile.Register32 // 0x458
	DHTMEM64       volatile.Register32 // 0x45C
	DHTMEM65       volatile.Register32 // 0x460
	DHTMEM66       volatile.Register32 // 0x464
	DHTMEM67       volatile.Register32 // 0x468
	DHTMEM68       volatile.Register32 // 0x46C
	DHTMEM69       volatile.Register32 // 0x470
	DHTMEM70       volatile.Register32 // 0x474
	DHTMEM71       volatile.Register32 // 0x478
	DHTMEM72       volatile.Register32 // 0x47C
	DHTMEM73       volatile.Register32 // 0x480
	DHTMEM74       volatile.Register32 // 0x484
	DHTMEM75       volatile.Register32 // 0x488
	DHTMEM76       volatile.Register32 // 0x48C
	DHTMEM77       volatile.Register32 // 0x490
	DHTMEM78       volatile.Register32 // 0x494
	DHTMEM79       volatile.Register32 // 0x498
	DHTMEM80       volatile.Register32 // 0x49C
	DHTMEM81       volatile.Register32 // 0x4A0
	DHTMEM82       volatile.Register32 // 0x4A4
	DHTMEM83       volatile.Register32 // 0x4A8
	DHTMEM84       volatile.Register32 // 0x4AC
	DHTMEM85       volatile.Register32 // 0x4B0
	DHTMEM86       volatile.Register32 // 0x4B4
	DHTMEM87       volatile.Register32 // 0x4B8
	DHTMEM88       volatile.Register32 // 0x4BC
	DHTMEM89       volatile.Register32 // 0x4C0
	DHTMEM90       volatile.Register32 // 0x4C4
	DHTMEM91       volatile.Register32 // 0x4C8
	DHTMEM92       volatile.Register32 // 0x4CC
	DHTMEM93       volatile.Register32 // 0x4D0
	DHTMEM94       volatile.Register32 // 0x4D4
	DHTMEM95       volatile.Register32 // 0x4D8
	DHTMEM96       volatile.Register32 // 0x4DC
	DHTMEM97       volatile.Register32 // 0x4E0
	DHTMEM98       volatile.Register32 // 0x4E4
	DHTMEM99       volatile.Register32 // 0x4E8
	DHTMEM100      volatile.Register32 // 0x4EC
	DHTMEM101      volatile.Register32 // 0x4F0
	DHTMEM102      volatile.Register32 // 0x4F4
	DHTMEM103      volatile.Register32 // 0x4F8
	_              [4]byte
	HUFFENC_AC0_0  volatile.Register32 // 0x500
	HUFFENC_AC0_1  volatile.Register32 // 0x504
	HUFFENC_AC0_2  volatile.Register32 // 0x508
	HUFFENC_AC0_3  volatile.Register32 // 0x50C
	HUFFENC_AC0_4  volatile.Register32 // 0x510
	HUFFENC_AC0_5  volatile.Register32 // 0x514
	HUFFENC_AC0_6  volatile.Register32 // 0x518
	HUFFENC_AC0_7  volatile.Register32 // 0x51C
	HUFFENC_AC0_8  volatile.Register32 // 0x520
	HUFFENC_AC0_9  volatile.Register32 // 0x524
	HUFFENC_AC0_10 volatile.Register32 // 0x528
	HUFFENC_AC0_11 volatile.Register32 // 0x52C
	HUFFENC_AC0_12 volatile.Register32 // 0x530
	HUFFENC_AC0_13 volatile.Register32 // 0x534
	HUFFENC_AC0_14 volatile.Register32 // 0x538
	HUFFENC_AC0_15 volatile.Register32 // 0x53C
	HUFFENC_AC0_16 volatile.Register32 // 0x540
	HUFFENC_AC0_17 volatile.Register32 // 0x544
	HUFFENC_AC0_18 volatile.Register32 // 0x548
	HUFFENC_AC0_19 volatile.Register32 // 0x54C
	HUFFENC_AC0_20 volatile.Register32 // 0x550
	HUFFENC_AC0_21 volatile.Register32 // 0x554
	HUFFENC_AC0_22 volatile.Register32 // 0x558
	HUFFENC_AC0_23 volatile.Register32 // 0x55C
	HUFFENC_AC0_24 volatile.Register32 // 0x560
	HUFFENC_AC0_25 volatile.Register32 // 0x564
	HUFFENC_AC0_26 volatile.Register32 // 0x568
	HUFFENC_AC0_27 volatile.Register32 // 0x56C
	HUFFENC_AC0_28 volatile.Register32 // 0x570
	HUFFENC_AC0_29 volatile.Register32 // 0x574
	HUFFENC_AC0_30 volatile.Register32 // 0x578
	HUFFENC_AC0_31 volatile.Register32 // 0x57C
	HUFFENC_AC0_32 volatile.Register32 // 0x580
	HUFFENC_AC0_33 volatile.Register32 // 0x584
	HUFFENC_AC0_34 volatile.Register32 // 0x588
	HUFFENC_AC0_35 volatile.Register32 // 0x58C
	HUFFENC_AC0_36 volatile.Register32 // 0x590
	HUFFENC_AC0_37 volatile.Register32 // 0x594
	HUFFENC_AC0_38 volatile.Register32 // 0x598
	HUFFENC_AC0_39 volatile.Register32 // 0x59C
	HUFFENC_AC0_40 volatile.Register32 // 0x5A0
	HUFFENC_AC0_41 volatile.Register32 // 0x5A4
	HUFFENC_AC0_42 volatile.Register32 // 0x5A8
	HUFFENC_AC0_43 volatile.Register32 // 0x5AC
	HUFFENC_AC0_44 volatile.Register32 // 0x5B0
	HUFFENC_AC0_45 volatile.Register32 // 0x5B4
	HUFFENC_AC0_46 volatile.Register32 // 0x5B8
	HUFFENC_AC0_47 volatile.Register32 // 0x5BC
	HUFFENC_AC0_48 volatile.Register32 // 0x5C0
	HUFFENC_AC0_49 volatile.Register32 // 0x5C4
	HUFFENC_AC0_50 volatile.Register32 // 0x5C8
	HUFFENC_AC0_51 volatile.Register32 // 0x5CC
	HUFFENC_AC0_52 volatile.Register32 // 0x5D0
	HUFFENC_AC0_53 volatile.Register32 // 0x5D4
	HUFFENC_AC0_54 volatile.Register32 // 0x5D8
	HUFFENC_AC0_55 volatile.Register32 // 0x5DC
	HUFFENC_AC0_56 volatile.Register32 // 0x5E0
	HUFFENC_AC0_57 volatile.Register32 // 0x5E4
	HUFFENC_AC0_58 volatile.Register32 // 0x5E8
	HUFFENC_AC0_59 volatile.Register32 // 0x5EC
	HUFFENC_AC0_60 volatile.Register32 // 0x5F0
	HUFFENC_AC0_61 volatile.Register32 // 0x5F4
	HUFFENC_AC0_62 volatile.Register32 // 0x5F8
	HUFFENC_AC0_63 volatile.Register32 // 0x5FC
	HUFFENC_AC0_64 volatile.Register32 // 0x600
	HUFFENC_AC0_65 volatile.Register32 // 0x604
	HUFFENC_AC0_66 volatile.Register32 // 0x608
	HUFFENC_AC0_67 volatile.Register32 // 0x60C
	HUFFENC_AC0_68 volatile.Register32 // 0x610
	HUFFENC_AC0_69 volatile.Register32 // 0x614
	HUFFENC_AC0_70 volatile.Register32 // 0x618
	HUFFENC_AC0_71 volatile.Register32 // 0x61C
	HUFFENC_AC0_72 volatile.Register32 // 0x620
	HUFFENC_AC0_73 volatile.Register32 // 0x624
	HUFFENC_AC0_74 volatile.Register32 // 0x628
	HUFFENC_AC0_75 volatile.Register32 // 0x62C
	HUFFENC_AC0_76 volatile.Register32 // 0x630
	HUFFENC_AC0_77 volatile.Register32 // 0x634
	HUFFENC_AC0_78 volatile.Register32 // 0x638
	HUFFENC_AC0_79 volatile.Register32 // 0x63C
	HUFFENC_AC0_80 volatile.Register32 // 0x640
	HUFFENC_AC0_81 volatile.Register32 // 0x644
	HUFFENC_AC0_82 volatile.Register32 // 0x648
	HUFFENC_AC0_83 volatile.Register32 // 0x64C
	HUFFENC_AC0_84 volatile.Register32 // 0x650
	HUFFENC_AC0_85 volatile.Register32 // 0x654
	HUFFENC_AC0_86 volatile.Register32 // 0x658
	HUFFENC_AC0_87 volatile.Register32 // 0x65C
	HUFFENC_AC1_0  volatile.Register32 // 0x660
	HUFFENC_AC1_1  volatile.Register32 // 0x664
	HUFFENC_AC1_2  volatile.Register32 // 0x668
	HUFFENC_AC1_3  volatile.Register32 // 0x66C
	HUFFENC_AC1_4  volatile.Register32 // 0x670
	HUFFENC_AC1_5  volatile.Register32 // 0x674
	HUFFENC_AC1_6  volatile.Register32 // 0x678
	HUFFENC_AC1_7  volatile.Register32 // 0x67C
	HUFFENC_AC1_8  volatile.Register32 // 0x680
	HUFFENC_AC1_9  volatile.Register32 // 0x684
	HUFFENC_AC1_10 volatile.Register32 // 0x688
	HUFFENC_AC1_11 volatile.Register32 // 0x68C
	HUFFENC_AC1_12 volatile.Register32 // 0x690
	HUFFENC_AC1_13 volatile.Register32 // 0x694
	HUFFENC_AC1_14 volatile.Register32 // 0x698
	HUFFENC_AC1_15 volatile.Register32 // 0x69C
	HUFFENC_AC1_16 volatile.Register32 // 0x6A0
	HUFFENC_AC1_17 volatile.Register32 // 0x6A4
	HUFFENC_AC1_18 volatile.Register32 // 0x6A8
	HUFFENC_AC1_19 volatile.Register32 // 0x6AC
	HUFFENC_AC1_20 volatile.Register32 // 0x6B0
	HUFFENC_AC1_21 volatile.Register32 // 0x6B4
	HUFFENC_AC1_22 volatile.Register32 // 0x6B8
	HUFFENC_AC1_23 volatile.Register32 // 0x6BC
	HUFFENC_AC1_24 volatile.Register32 // 0x6C0
	HUFFENC_AC1_25 volatile.Register32 // 0x6C4
	HUFFENC_AC1_26 volatile.Register32 // 0x6C8
	HUFFENC_AC1_27 volatile.Register32 // 0x6CC
	HUFFENC_AC1_28 volatile.Register32 // 0x6D0
	HUFFENC_AC1_29 volatile.Register32 // 0x6D4
	HUFFENC_AC1_30 volatile.Register32 // 0x6D8
	HUFFENC_AC1_31 volatile.Register32 // 0x6DC
	HUFFENC_AC1_32 volatile.Register32 // 0x6E0
	HUFFENC_AC1_33 volatile.Register32 // 0x6E4
	HUFFENC_AC1_34 volatile.Register32 // 0x6E8
	HUFFENC_AC1_35 volatile.Register32 // 0x6EC
	HUFFENC_AC1_36 volatile.Register32 // 0x6F0
	HUFFENC_AC1_37 volatile.Register32 // 0x6F4
	HUFFENC_AC1_38 volatile.Register32 // 0x6F8
	HUFFENC_AC1_39 volatile.Register32 // 0x6FC
	HUFFENC_AC1_40 volatile.Register32 // 0x700
	HUFFENC_AC1_41 volatile.Register32 // 0x704
	HUFFENC_AC1_42 volatile.Register32 // 0x708
	HUFFENC_AC1_43 volatile.Register32 // 0x70C
	HUFFENC_AC1_44 volatile.Register32 // 0x710
	HUFFENC_AC1_45 volatile.Register32 // 0x714
	HUFFENC_AC1_46 volatile.Register32 // 0x718
	HUFFENC_AC1_47 volatile.Register32 // 0x71C
	HUFFENC_AC1_48 volatile.Register32 // 0x720
	HUFFENC_AC1_49 volatile.Register32 // 0x724
	HUFFENC_AC1_50 volatile.Register32 // 0x728
	HUFFENC_AC1_51 volatile.Register32 // 0x72C
	HUFFENC_AC1_52 volatile.Register32 // 0x730
	HUFFENC_AC1_53 volatile.Register32 // 0x734
	HUFFENC_AC1_54 volatile.Register32 // 0x738
	HUFFENC_AC1_55 volatile.Register32 // 0x73C
	HUFFENC_AC1_56 volatile.Register32 // 0x740
	HUFFENC_AC1_57 volatile.Register32 // 0x744
	HUFFENC_AC1_58 volatile.Register32 // 0x748
	HUFFENC_AC1_59 volatile.Register32 // 0x74C
	HUFFENC_AC1_60 volatile.Register32 // 0x750
	HUFFENC_AC1_61 volatile.Register32 // 0x754
	HUFFENC_AC1_62 volatile.Register32 // 0x758
	HUFFENC_AC1_63 volatile.Register32 // 0x75C
	HUFFENC_AC1_64 volatile.Register32 // 0x760
	HUFFENC_AC1_65 volatile.Register32 // 0x764
	HUFFENC_AC1_66 volatile.Register32 // 0x768
	HUFFENC_AC1_67 volatile.Register32 // 0x76C
	HUFFENC_AC1_68 volatile.Register32 // 0x770
	HUFFENC_AC1_69 volatile.Register32 // 0x774
	HUFFENC_AC1_70 volatile.Register32 // 0x778
	HUFFENC_AC1_71 volatile.Register32 // 0x77C
	HUFFENC_AC1_72 volatile.Register32 // 0x780
	HUFFENC_AC1_73 volatile.Register32 // 0x784
	HUFFENC_AC1_74 volatile.Register32 // 0x788
	HUFFENC_AC1_75 volatile.Register32 // 0x78C
	HUFFENC_AC1_76 volatile.Register32 // 0x790
	HUFFENC_AC1_77 volatile.Register32 // 0x794
	HUFFENC_AC1_78 volatile.Register32 // 0x798
	HUFFENC_AC1_79 volatile.Register32 // 0x79C
	HUFFENC_AC1_80 volatile.Register32 // 0x7A0
	HUFFENC_AC1_81 volatile.Register32 // 0x7A4
	HUFFENC_AC1_82 volatile.Register32 // 0x7A8
	HUFFENC_AC1_83 volatile.Register32 // 0x7AC
	HUFFENC_AC1_84 volatile.Register32 // 0x7B0
	HUFFENC_AC1_85 volatile.Register32 // 0x7B4
	HUFFENC_AC1_86 volatile.Register32 // 0x7B8
	HUFFENC_AC1_87 volatile.Register32 // 0x7BC
	HUFFENC_DC0_0  volatile.Register32 // 0x7C0
	HUFFENC_DC0_1  volatile.Register32 // 0x7C4
	HUFFENC_DC0_2  volatile.Register32 // 0x7C8
	HUFFENC_DC0_3  volatile.Register32 // 0x7CC
	HUFFENC_DC0_4  volatile.Register32 // 0x7D0
	HUFFENC_DC0_5  volatile.Register32 // 0x7D4
	HUFFENC_DC0_6  volatile.Register32 // 0x7D8
	HUFFENC_DC0_7  volatile.Register32 // 0x7DC
	HUFFENC_DC1_0  volatile.Register32 // 0x7E0
	HUFFENC_DC1_1  volatile.Register32 // 0x7E4
	HUFFENC_DC1_2  volatile.Register32 // 0x7E8
	HUFFENC_DC1_3  volatile.Register32 // 0x7EC
	HUFFENC_DC1_4  volatile.Register32 // 0x7F0
	HUFFENC_DC1_5  volatile.Register32 // 0x7F4
	HUFFENC_DC1_6  volatile.Register32 // 0x7F8
	HUFFENC_DC1_7  volatile.Register32 // 0x7FC
}

// DSI Host
type DSI_Type struct {
	DSI_VR      volatile.Register32 // 0x0
	DSI_CR      volatile.Register32 // 0x4
	DSI_CCR     volatile.Register32 // 0x8
	DSI_LVCIDR  volatile.Register32 // 0xC
	DSI_LCOLCR  volatile.Register32 // 0x10
	DSI_LPCR    volatile.Register32 // 0x14
	DSI_LPMCR   volatile.Register32 // 0x18
	_           [16]byte
	DSI_PCR     volatile.Register32 // 0x2C
	DSI_GVCIDR  volatile.Register32 // 0x30
	DSI_MCR     volatile.Register32 // 0x34
	DSI_VMCR    volatile.Register32 // 0x38
	DSI_VPCR    volatile.Register32 // 0x3C
	DSI_VCCR    volatile.Register32 // 0x40
	DSI_VNPCR   volatile.Register32 // 0x44
	DSI_VHSACR  volatile.Register32 // 0x48
	DSI_VHBPCR  volatile.Register32 // 0x4C
	DSI_VLCR    volatile.Register32 // 0x50
	DSI_VVSACR  volatile.Register32 // 0x54
	DSI_VVBPCR  volatile.Register32 // 0x58
	DSI_VVFPCR  volatile.Register32 // 0x5C
	DSI_VVACR   volatile.Register32 // 0x60
	DSI_LCCR    volatile.Register32 // 0x64
	DSI_CMCR    volatile.Register32 // 0x68
	DSI_GHCR    volatile.Register32 // 0x6C
	DSI_GPDR    volatile.Register32 // 0x70
	DSI_GPSR    volatile.Register32 // 0x74
	DSI_TCCR0   volatile.Register32 // 0x78
	DSI_TCCR1   volatile.Register32 // 0x7C
	DSI_TCCR2   volatile.Register32 // 0x80
	DSI_TCCR3   volatile.Register32 // 0x84
	DSI_TCCR4   volatile.Register32 // 0x88
	DSI_TCCR5   volatile.Register32 // 0x8C
	_           [4]byte
	DSI_CLCR    volatile.Register32 // 0x94
	DSI_CLTCR   volatile.Register32 // 0x98
	DSI_DLTCR   volatile.Register32 // 0x9C
	DSI_PCTLR   volatile.Register32 // 0xA0
	DSI_PCONFR  volatile.Register32 // 0xA4
	DSI_PUCR    volatile.Register32 // 0xA8
	DSI_PTTCR   volatile.Register32 // 0xAC
	DSI_PSR     volatile.Register32 // 0xB0
	_           [8]byte
	DSI_ISR0    volatile.Register32 // 0xBC
	DSI_ISR1    volatile.Register32 // 0xC0
	DSI_IER0    volatile.Register32 // 0xC4
	DSI_IER1    volatile.Register32 // 0xC8
	_           [12]byte
	DSI_FIR0    volatile.Register32 // 0xD8
	DSI_FIR1    volatile.Register32 // 0xDC
	_           [32]byte
	DSI_VSCR    volatile.Register32 // 0x100
	_           [8]byte
	DSI_LCVCIDR volatile.Register32 // 0x10C
	DSI_LCCCR   volatile.Register32 // 0x110
	_           [4]byte
	DSI_LPMCCR  volatile.Register32 // 0x118
	_           [28]byte
	DSI_VMCCR   volatile.Register32 // 0x138
	DSI_VPCCR   volatile.Register32 // 0x13C
	DSI_VCCCR   volatile.Register32 // 0x140
	DSI_VNPCCR  volatile.Register32 // 0x144
	DSI_VHSACCR volatile.Register32 // 0x148
	DSI_VHBPCCR volatile.Register32 // 0x14C
	DSI_VLCCR   volatile.Register32 // 0x150
	DSI_VVSACCR volatile.Register32 // 0x154
	DSI_VVBPCCR volatile.Register32 // 0x158
	DSI_VVFPCCR volatile.Register32 // 0x15C
	DSI_VVACCR  volatile.Register32 // 0x160
	_           [668]byte
	DSI_WCFGR   volatile.Register32 // 0x400
	DSI_WCR     volatile.Register32 // 0x404
	DSI_WIER    volatile.Register32 // 0x408
	DSI_WISR    volatile.Register32 // 0x40C
	DSI_WIFCR   volatile.Register32 // 0x410
	_           [4]byte
	DSI_WPCR1   volatile.Register32 // 0x418
	DSI_WPCR2   volatile.Register32 // 0x41C
	DSI_WPCR3   volatile.Register32 // 0x420
	DSI_WPCR4   volatile.Register32 // 0x424
	DSI_WPCR5   volatile.Register32 // 0x428
	_           [4]byte
	DSI_WRPCR   volatile.Register32 // 0x430
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	ISER2 volatile.Register32 // 0x8
	_     [116]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	ICER2 volatile.Register32 // 0x88
	_     [116]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	ISPR2 volatile.Register32 // 0x108
	_     [116]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	ICPR2 volatile.Register32 // 0x188
	_     [116]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	IABR2 volatile.Register32 // 0x208
	_     [244]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
	IPR18 volatile.Register32 // 0x348
	IPR19 volatile.Register32 // 0x34C
	IPR20 volatile.Register32 // 0x350
	IPR21 volatile.Register32 // 0x354
	IPR22 volatile.Register32 // 0x358
	IPR23 volatile.Register32 // 0x35C
	IPR24 volatile.Register32 // 0x360
	IPR25 volatile.Register32 // 0x364
	IPR26 volatile.Register32 // 0x368
	IPR27 volatile.Register32 // 0x36C
	IPR28 volatile.Register32 // 0x370
}

// Memory protection unit
type MPU_Type struct {
	MPU_TYPER volatile.Register32 // 0x0
	MPU_CTRL  volatile.Register32 // 0x4
	MPU_RNR   volatile.Register32 // 0x8
	MPU_RBAR  volatile.Register32 // 0xC
	MPU_RASR  volatile.Register32 // 0x10
}

// SysTick timer
type STK_Type struct {
	CSR   volatile.Register32 // 0x0
	RVR   volatile.Register32 // 0x4
	CVR   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// Floating point unit CPACR
type FPU_Type struct {
	CPACR volatile.Register32 // 0x0
}

// System control block ACTLR
type SCB_Type struct {
	ACTRL volatile.Register32 // 0x0
}

// Processor features
type PF_Type struct {
	CLIDR  volatile.Register32 // 0x0
	CTR    volatile.Register32 // 0x4
	CCSIDR volatile.Register32 // 0x8
}

// Access control
type AC_Type struct {
	ITCMCR volatile.Register32 // 0x0
	DTCMCR volatile.Register32 // 0x4
	AHBPCR volatile.Register32 // 0x8
	CACR   volatile.Register32 // 0xC
	AHBSCR volatile.Register32 // 0x10
	_      [4]byte
	ABFSR  volatile.Register32 // 0x18
}

// Bitfields for RNG: Random number generator
const (
	// CR: control register
	RNG_CR_IE_Pos    = 0x3 // Position of IE field.
	RNG_CR_IE_Msk    = 0x8 // Bit mask of IE field.
	RNG_CR_IE        = 0x8 // Bit IE.
	RNG_CR_RNGEN_Pos = 0x2 // Position of RNGEN field.
	RNG_CR_RNGEN_Msk = 0x4 // Bit mask of RNGEN field.
	RNG_CR_RNGEN     = 0x4 // Bit RNGEN.

	// SR: status register
	RNG_SR_SEIS_Pos = 0x6  // Position of SEIS field.
	RNG_SR_SEIS_Msk = 0x40 // Bit mask of SEIS field.
	RNG_SR_SEIS     = 0x40 // Bit SEIS.
	RNG_SR_CEIS_Pos = 0x5  // Position of CEIS field.
	RNG_SR_CEIS_Msk = 0x20 // Bit mask of CEIS field.
	RNG_SR_CEIS     = 0x20 // Bit CEIS.
	RNG_SR_SECS_Pos = 0x2  // Position of SECS field.
	RNG_SR_SECS_Msk = 0x4  // Bit mask of SECS field.
	RNG_SR_SECS     = 0x4  // Bit SECS.
	RNG_SR_CECS_Pos = 0x1  // Position of CECS field.
	RNG_SR_CECS_Msk = 0x2  // Bit mask of CECS field.
	RNG_SR_CECS     = 0x2  // Bit CECS.
	RNG_SR_DRDY_Pos = 0x0  // Position of DRDY field.
	RNG_SR_DRDY_Msk = 0x1  // Bit mask of DRDY field.
	RNG_SR_DRDY     = 0x1  // Bit DRDY.

	// DR: data register
	RNG_DR_RNDATA_Pos = 0x0        // Position of RNDATA field.
	RNG_DR_RNDATA_Msk = 0xffffffff // Bit mask of RNDATA field.
)

// Bitfields for HASH: Hash processor
const (
	// CR: control register
	HASH_CR_INIT_Pos     = 0x2     // Position of INIT field.
	HASH_CR_INIT_Msk     = 0x4     // Bit mask of INIT field.
	HASH_CR_INIT         = 0x4     // Bit INIT.
	HASH_CR_DMAE_Pos     = 0x3     // Position of DMAE field.
	HASH_CR_DMAE_Msk     = 0x8     // Bit mask of DMAE field.
	HASH_CR_DMAE         = 0x8     // Bit DMAE.
	HASH_CR_DATATYPE_Pos = 0x4     // Position of DATATYPE field.
	HASH_CR_DATATYPE_Msk = 0x30    // Bit mask of DATATYPE field.
	HASH_CR_MODE_Pos     = 0x6     // Position of MODE field.
	HASH_CR_MODE_Msk     = 0x40    // Bit mask of MODE field.
	HASH_CR_MODE         = 0x40    // Bit MODE.
	HASH_CR_ALGO0_Pos    = 0x7     // Position of ALGO0 field.
	HASH_CR_ALGO0_Msk    = 0x80    // Bit mask of ALGO0 field.
	HASH_CR_ALGO0        = 0x80    // Bit ALGO0.
	HASH_CR_NBW_Pos      = 0x8     // Position of NBW field.
	HASH_CR_NBW_Msk      = 0xf00   // Bit mask of NBW field.
	HASH_CR_DINNE_Pos    = 0xc     // Position of DINNE field.
	HASH_CR_DINNE_Msk    = 0x1000  // Bit mask of DINNE field.
	HASH_CR_DINNE        = 0x1000  // Bit DINNE.
	HASH_CR_MDMAT_Pos    = 0xd     // Position of MDMAT field.
	HASH_CR_MDMAT_Msk    = 0x2000  // Bit mask of MDMAT field.
	HASH_CR_MDMAT        = 0x2000  // Bit MDMAT.
	HASH_CR_LKEY_Pos     = 0x10    // Position of LKEY field.
	HASH_CR_LKEY_Msk     = 0x10000 // Bit mask of LKEY field.
	HASH_CR_LKEY         = 0x10000 // Bit LKEY.
	HASH_CR_ALGO1_Pos    = 0x12    // Position of ALGO1 field.
	HASH_CR_ALGO1_Msk    = 0x40000 // Bit mask of ALGO1 field.
	HASH_CR_ALGO1        = 0x40000 // Bit ALGO1.

	// DIN: data input register
	HASH_DIN_DATAIN_Pos = 0x0        // Position of DATAIN field.
	HASH_DIN_DATAIN_Msk = 0xffffffff // Bit mask of DATAIN field.

	// STR: start register
	HASH_STR_DCAL_Pos = 0x8   // Position of DCAL field.
	HASH_STR_DCAL_Msk = 0x100 // Bit mask of DCAL field.
	HASH_STR_DCAL     = 0x100 // Bit DCAL.
	HASH_STR_NBLW_Pos = 0x0   // Position of NBLW field.
	HASH_STR_NBLW_Msk = 0x1f  // Bit mask of NBLW field.

	// HR0: digest registers
	HASH_HR0_H0_Pos = 0x0        // Position of H0 field.
	HASH_HR0_H0_Msk = 0xffffffff // Bit mask of H0 field.

	// HR1: digest registers
	HASH_HR1_H1_Pos = 0x0        // Position of H1 field.
	HASH_HR1_H1_Msk = 0xffffffff // Bit mask of H1 field.

	// HR2: digest registers
	HASH_HR2_H2_Pos = 0x0        // Position of H2 field.
	HASH_HR2_H2_Msk = 0xffffffff // Bit mask of H2 field.

	// HR3: digest registers
	HASH_HR3_H3_Pos = 0x0        // Position of H3 field.
	HASH_HR3_H3_Msk = 0xffffffff // Bit mask of H3 field.

	// HR4: digest registers
	HASH_HR4_H4_Pos = 0x0        // Position of H4 field.
	HASH_HR4_H4_Msk = 0xffffffff // Bit mask of H4 field.

	// IMR: interrupt enable register
	HASH_IMR_DCIE_Pos  = 0x1 // Position of DCIE field.
	HASH_IMR_DCIE_Msk  = 0x2 // Bit mask of DCIE field.
	HASH_IMR_DCIE      = 0x2 // Bit DCIE.
	HASH_IMR_DINIE_Pos = 0x0 // Position of DINIE field.
	HASH_IMR_DINIE_Msk = 0x1 // Bit mask of DINIE field.
	HASH_IMR_DINIE     = 0x1 // Bit DINIE.

	// SR: status register
	HASH_SR_BUSY_Pos  = 0x3 // Position of BUSY field.
	HASH_SR_BUSY_Msk  = 0x8 // Bit mask of BUSY field.
	HASH_SR_BUSY      = 0x8 // Bit BUSY.
	HASH_SR_DMAS_Pos  = 0x2 // Position of DMAS field.
	HASH_SR_DMAS_Msk  = 0x4 // Bit mask of DMAS field.
	HASH_SR_DMAS      = 0x4 // Bit DMAS.
	HASH_SR_DCIS_Pos  = 0x1 // Position of DCIS field.
	HASH_SR_DCIS_Msk  = 0x2 // Bit mask of DCIS field.
	HASH_SR_DCIS      = 0x2 // Bit DCIS.
	HASH_SR_DINIS_Pos = 0x0 // Position of DINIS field.
	HASH_SR_DINIS_Msk = 0x1 // Bit mask of DINIS field.
	HASH_SR_DINIS     = 0x1 // Bit DINIS.

	// CSR0: context swap registers
	HASH_CSR0_CSR0_Pos = 0x0        // Position of CSR0 field.
	HASH_CSR0_CSR0_Msk = 0xffffffff // Bit mask of CSR0 field.

	// CSR1: context swap registers
	HASH_CSR1_CSR1_Pos = 0x0        // Position of CSR1 field.
	HASH_CSR1_CSR1_Msk = 0xffffffff // Bit mask of CSR1 field.

	// CSR2: context swap registers
	HASH_CSR2_CSR2_Pos = 0x0        // Position of CSR2 field.
	HASH_CSR2_CSR2_Msk = 0xffffffff // Bit mask of CSR2 field.

	// CSR3: context swap registers
	HASH_CSR3_CSR3_Pos = 0x0        // Position of CSR3 field.
	HASH_CSR3_CSR3_Msk = 0xffffffff // Bit mask of CSR3 field.

	// CSR4: context swap registers
	HASH_CSR4_CSR4_Pos = 0x0        // Position of CSR4 field.
	HASH_CSR4_CSR4_Msk = 0xffffffff // Bit mask of CSR4 field.

	// CSR5: context swap registers
	HASH_CSR5_CSR5_Pos = 0x0        // Position of CSR5 field.
	HASH_CSR5_CSR5_Msk = 0xffffffff // Bit mask of CSR5 field.

	// CSR6: context swap registers
	HASH_CSR6_CSR6_Pos = 0x0        // Position of CSR6 field.
	HASH_CSR6_CSR6_Msk = 0xffffffff // Bit mask of CSR6 field.

	// CSR7: context swap registers
	HASH_CSR7_CSR7_Pos = 0x0        // Position of CSR7 field.
	HASH_CSR7_CSR7_Msk = 0xffffffff // Bit mask of CSR7 field.

	// CSR8: context swap registers
	HASH_CSR8_CSR8_Pos = 0x0        // Position of CSR8 field.
	HASH_CSR8_CSR8_Msk = 0xffffffff // Bit mask of CSR8 field.

	// CSR9: context swap registers
	HASH_CSR9_CSR9_Pos = 0x0        // Position of CSR9 field.
	HASH_CSR9_CSR9_Msk = 0xffffffff // Bit mask of CSR9 field.

	// CSR10: context swap registers
	HASH_CSR10_CSR10_Pos = 0x0        // Position of CSR10 field.
	HASH_CSR10_CSR10_Msk = 0xffffffff // Bit mask of CSR10 field.

	// CSR11: context swap registers
	HASH_CSR11_CSR11_Pos = 0x0        // Position of CSR11 field.
	HASH_CSR11_CSR11_Msk = 0xffffffff // Bit mask of CSR11 field.

	// CSR12: context swap registers
	HASH_CSR12_CSR12_Pos = 0x0        // Position of CSR12 field.
	HASH_CSR12_CSR12_Msk = 0xffffffff // Bit mask of CSR12 field.

	// CSR13: context swap registers
	HASH_CSR13_CSR13_Pos = 0x0        // Position of CSR13 field.
	HASH_CSR13_CSR13_Msk = 0xffffffff // Bit mask of CSR13 field.

	// CSR14: context swap registers
	HASH_CSR14_CSR14_Pos = 0x0        // Position of CSR14 field.
	HASH_CSR14_CSR14_Msk = 0xffffffff // Bit mask of CSR14 field.

	// CSR15: context swap registers
	HASH_CSR15_CSR15_Pos = 0x0        // Position of CSR15 field.
	HASH_CSR15_CSR15_Msk = 0xffffffff // Bit mask of CSR15 field.

	// CSR16: context swap registers
	HASH_CSR16_CSR16_Pos = 0x0        // Position of CSR16 field.
	HASH_CSR16_CSR16_Msk = 0xffffffff // Bit mask of CSR16 field.

	// CSR17: context swap registers
	HASH_CSR17_CSR17_Pos = 0x0        // Position of CSR17 field.
	HASH_CSR17_CSR17_Msk = 0xffffffff // Bit mask of CSR17 field.

	// CSR18: context swap registers
	HASH_CSR18_CSR18_Pos = 0x0        // Position of CSR18 field.
	HASH_CSR18_CSR18_Msk = 0xffffffff // Bit mask of CSR18 field.

	// CSR19: context swap registers
	HASH_CSR19_CSR19_Pos = 0x0        // Position of CSR19 field.
	HASH_CSR19_CSR19_Msk = 0xffffffff // Bit mask of CSR19 field.

	// CSR20: context swap registers
	HASH_CSR20_CSR20_Pos = 0x0        // Position of CSR20 field.
	HASH_CSR20_CSR20_Msk = 0xffffffff // Bit mask of CSR20 field.

	// CSR21: context swap registers
	HASH_CSR21_CSR21_Pos = 0x0        // Position of CSR21 field.
	HASH_CSR21_CSR21_Msk = 0xffffffff // Bit mask of CSR21 field.

	// CSR22: context swap registers
	HASH_CSR22_CSR22_Pos = 0x0        // Position of CSR22 field.
	HASH_CSR22_CSR22_Msk = 0xffffffff // Bit mask of CSR22 field.

	// CSR23: context swap registers
	HASH_CSR23_CSR23_Pos = 0x0        // Position of CSR23 field.
	HASH_CSR23_CSR23_Msk = 0xffffffff // Bit mask of CSR23 field.

	// CSR24: context swap registers
	HASH_CSR24_CSR24_Pos = 0x0        // Position of CSR24 field.
	HASH_CSR24_CSR24_Msk = 0xffffffff // Bit mask of CSR24 field.

	// CSR25: context swap registers
	HASH_CSR25_CSR25_Pos = 0x0        // Position of CSR25 field.
	HASH_CSR25_CSR25_Msk = 0xffffffff // Bit mask of CSR25 field.

	// CSR26: context swap registers
	HASH_CSR26_CSR26_Pos = 0x0        // Position of CSR26 field.
	HASH_CSR26_CSR26_Msk = 0xffffffff // Bit mask of CSR26 field.

	// CSR27: context swap registers
	HASH_CSR27_CSR27_Pos = 0x0        // Position of CSR27 field.
	HASH_CSR27_CSR27_Msk = 0xffffffff // Bit mask of CSR27 field.

	// CSR28: context swap registers
	HASH_CSR28_CSR28_Pos = 0x0        // Position of CSR28 field.
	HASH_CSR28_CSR28_Msk = 0xffffffff // Bit mask of CSR28 field.

	// CSR29: context swap registers
	HASH_CSR29_CSR29_Pos = 0x0        // Position of CSR29 field.
	HASH_CSR29_CSR29_Msk = 0xffffffff // Bit mask of CSR29 field.

	// CSR30: context swap registers
	HASH_CSR30_CSR30_Pos = 0x0        // Position of CSR30 field.
	HASH_CSR30_CSR30_Msk = 0xffffffff // Bit mask of CSR30 field.

	// CSR31: context swap registers
	HASH_CSR31_CSR31_Pos = 0x0        // Position of CSR31 field.
	HASH_CSR31_CSR31_Msk = 0xffffffff // Bit mask of CSR31 field.

	// CSR32: context swap registers
	HASH_CSR32_CSR32_Pos = 0x0        // Position of CSR32 field.
	HASH_CSR32_CSR32_Msk = 0xffffffff // Bit mask of CSR32 field.

	// CSR33: context swap registers
	HASH_CSR33_CSR33_Pos = 0x0        // Position of CSR33 field.
	HASH_CSR33_CSR33_Msk = 0xffffffff // Bit mask of CSR33 field.

	// CSR34: context swap registers
	HASH_CSR34_CSR34_Pos = 0x0        // Position of CSR34 field.
	HASH_CSR34_CSR34_Msk = 0xffffffff // Bit mask of CSR34 field.

	// CSR35: context swap registers
	HASH_CSR35_CSR35_Pos = 0x0        // Position of CSR35 field.
	HASH_CSR35_CSR35_Msk = 0xffffffff // Bit mask of CSR35 field.

	// CSR36: context swap registers
	HASH_CSR36_CSR36_Pos = 0x0        // Position of CSR36 field.
	HASH_CSR36_CSR36_Msk = 0xffffffff // Bit mask of CSR36 field.

	// CSR37: context swap registers
	HASH_CSR37_CSR37_Pos = 0x0        // Position of CSR37 field.
	HASH_CSR37_CSR37_Msk = 0xffffffff // Bit mask of CSR37 field.

	// CSR38: context swap registers
	HASH_CSR38_CSR38_Pos = 0x0        // Position of CSR38 field.
	HASH_CSR38_CSR38_Msk = 0xffffffff // Bit mask of CSR38 field.

	// CSR39: context swap registers
	HASH_CSR39_CSR39_Pos = 0x0        // Position of CSR39 field.
	HASH_CSR39_CSR39_Msk = 0xffffffff // Bit mask of CSR39 field.

	// CSR40: context swap registers
	HASH_CSR40_CSR40_Pos = 0x0        // Position of CSR40 field.
	HASH_CSR40_CSR40_Msk = 0xffffffff // Bit mask of CSR40 field.

	// CSR41: context swap registers
	HASH_CSR41_CSR41_Pos = 0x0        // Position of CSR41 field.
	HASH_CSR41_CSR41_Msk = 0xffffffff // Bit mask of CSR41 field.

	// CSR42: context swap registers
	HASH_CSR42_CSR42_Pos = 0x0        // Position of CSR42 field.
	HASH_CSR42_CSR42_Msk = 0xffffffff // Bit mask of CSR42 field.

	// CSR43: context swap registers
	HASH_CSR43_CSR43_Pos = 0x0        // Position of CSR43 field.
	HASH_CSR43_CSR43_Msk = 0xffffffff // Bit mask of CSR43 field.

	// CSR44: context swap registers
	HASH_CSR44_CSR44_Pos = 0x0        // Position of CSR44 field.
	HASH_CSR44_CSR44_Msk = 0xffffffff // Bit mask of CSR44 field.

	// CSR45: context swap registers
	HASH_CSR45_CSR45_Pos = 0x0        // Position of CSR45 field.
	HASH_CSR45_CSR45_Msk = 0xffffffff // Bit mask of CSR45 field.

	// CSR46: context swap registers
	HASH_CSR46_CSR46_Pos = 0x0        // Position of CSR46 field.
	HASH_CSR46_CSR46_Msk = 0xffffffff // Bit mask of CSR46 field.

	// CSR47: context swap registers
	HASH_CSR47_CSR47_Pos = 0x0        // Position of CSR47 field.
	HASH_CSR47_CSR47_Msk = 0xffffffff // Bit mask of CSR47 field.

	// CSR48: context swap registers
	HASH_CSR48_CSR48_Pos = 0x0        // Position of CSR48 field.
	HASH_CSR48_CSR48_Msk = 0xffffffff // Bit mask of CSR48 field.

	// CSR49: context swap registers
	HASH_CSR49_CSR49_Pos = 0x0        // Position of CSR49 field.
	HASH_CSR49_CSR49_Msk = 0xffffffff // Bit mask of CSR49 field.

	// CSR50: context swap registers
	HASH_CSR50_CSR50_Pos = 0x0        // Position of CSR50 field.
	HASH_CSR50_CSR50_Msk = 0xffffffff // Bit mask of CSR50 field.

	// CSR51: context swap registers
	HASH_CSR51_CSR51_Pos = 0x0        // Position of CSR51 field.
	HASH_CSR51_CSR51_Msk = 0xffffffff // Bit mask of CSR51 field.

	// CSR52: context swap registers
	HASH_CSR52_CSR52_Pos = 0x0        // Position of CSR52 field.
	HASH_CSR52_CSR52_Msk = 0xffffffff // Bit mask of CSR52 field.

	// CSR53: context swap registers
	HASH_CSR53_CSR53_Pos = 0x0        // Position of CSR53 field.
	HASH_CSR53_CSR53_Msk = 0xffffffff // Bit mask of CSR53 field.

	// HASH_HR0: HASH digest register
	HASH_HASH_HR0_H0_Pos = 0x0        // Position of H0 field.
	HASH_HASH_HR0_H0_Msk = 0xffffffff // Bit mask of H0 field.

	// HASH_HR1: read-only
	HASH_HASH_HR1_H1_Pos = 0x0        // Position of H1 field.
	HASH_HASH_HR1_H1_Msk = 0xffffffff // Bit mask of H1 field.

	// HASH_HR2: read-only
	HASH_HASH_HR2_H2_Pos = 0x0        // Position of H2 field.
	HASH_HASH_HR2_H2_Msk = 0xffffffff // Bit mask of H2 field.

	// HASH_HR3: read-only
	HASH_HASH_HR3_H3_Pos = 0x0        // Position of H3 field.
	HASH_HASH_HR3_H3_Msk = 0xffffffff // Bit mask of H3 field.

	// HASH_HR4: read-only
	HASH_HASH_HR4_H4_Pos = 0x0        // Position of H4 field.
	HASH_HASH_HR4_H4_Msk = 0xffffffff // Bit mask of H4 field.

	// HASH_HR5: read-only
	HASH_HASH_HR5_H5_Pos = 0x0        // Position of H5 field.
	HASH_HASH_HR5_H5_Msk = 0xffffffff // Bit mask of H5 field.

	// HASH_HR6: read-only
	HASH_HASH_HR6_H6_Pos = 0x0        // Position of H6 field.
	HASH_HASH_HR6_H6_Msk = 0xffffffff // Bit mask of H6 field.

	// HASH_HR7: read-only
	HASH_HASH_HR7_H7_Pos = 0x0        // Position of H7 field.
	HASH_HASH_HR7_H7_Msk = 0xffffffff // Bit mask of H7 field.
)

// Bitfields for CRYP: Cryptographic processor
const (
	// CR: control register
	CRYP_CR_ALGODIR_Pos   = 0x2     // Position of ALGODIR field.
	CRYP_CR_ALGODIR_Msk   = 0x4     // Bit mask of ALGODIR field.
	CRYP_CR_ALGODIR       = 0x4     // Bit ALGODIR.
	CRYP_CR_ALGOMODE0_Pos = 0x3     // Position of ALGOMODE0 field.
	CRYP_CR_ALGOMODE0_Msk = 0x38    // Bit mask of ALGOMODE0 field.
	CRYP_CR_DATATYPE_Pos  = 0x6     // Position of DATATYPE field.
	CRYP_CR_DATATYPE_Msk  = 0xc0    // Bit mask of DATATYPE field.
	CRYP_CR_KEYSIZE_Pos   = 0x8     // Position of KEYSIZE field.
	CRYP_CR_KEYSIZE_Msk   = 0x300   // Bit mask of KEYSIZE field.
	CRYP_CR_FFLUSH_Pos    = 0xe     // Position of FFLUSH field.
	CRYP_CR_FFLUSH_Msk    = 0x4000  // Bit mask of FFLUSH field.
	CRYP_CR_FFLUSH        = 0x4000  // Bit FFLUSH.
	CRYP_CR_CRYPEN_Pos    = 0xf     // Position of CRYPEN field.
	CRYP_CR_CRYPEN_Msk    = 0x8000  // Bit mask of CRYPEN field.
	CRYP_CR_CRYPEN        = 0x8000  // Bit CRYPEN.
	CRYP_CR_GCM_CCMPH_Pos = 0x10    // Position of GCM_CCMPH field.
	CRYP_CR_GCM_CCMPH_Msk = 0x30000 // Bit mask of GCM_CCMPH field.
	CRYP_CR_ALGOMODE3_Pos = 0x13    // Position of ALGOMODE3 field.
	CRYP_CR_ALGOMODE3_Msk = 0x80000 // Bit mask of ALGOMODE3 field.
	CRYP_CR_ALGOMODE3     = 0x80000 // Bit ALGOMODE3.

	// SR: status register
	CRYP_SR_BUSY_Pos = 0x4  // Position of BUSY field.
	CRYP_SR_BUSY_Msk = 0x10 // Bit mask of BUSY field.
	CRYP_SR_BUSY     = 0x10 // Bit BUSY.
	CRYP_SR_OFFU_Pos = 0x3  // Position of OFFU field.
	CRYP_SR_OFFU_Msk = 0x8  // Bit mask of OFFU field.
	CRYP_SR_OFFU     = 0x8  // Bit OFFU.
	CRYP_SR_OFNE_Pos = 0x2  // Position of OFNE field.
	CRYP_SR_OFNE_Msk = 0x4  // Bit mask of OFNE field.
	CRYP_SR_OFNE     = 0x4  // Bit OFNE.
	CRYP_SR_IFNF_Pos = 0x1  // Position of IFNF field.
	CRYP_SR_IFNF_Msk = 0x2  // Bit mask of IFNF field.
	CRYP_SR_IFNF     = 0x2  // Bit IFNF.
	CRYP_SR_IFEM_Pos = 0x0  // Position of IFEM field.
	CRYP_SR_IFEM_Msk = 0x1  // Bit mask of IFEM field.
	CRYP_SR_IFEM     = 0x1  // Bit IFEM.

	// DIN: data input register
	CRYP_DIN_DATAIN_Pos = 0x0        // Position of DATAIN field.
	CRYP_DIN_DATAIN_Msk = 0xffffffff // Bit mask of DATAIN field.

	// DOUT: data output register
	CRYP_DOUT_DATAOUT_Pos = 0x0        // Position of DATAOUT field.
	CRYP_DOUT_DATAOUT_Msk = 0xffffffff // Bit mask of DATAOUT field.

	// DMACR: DMA control register
	CRYP_DMACR_DOEN_Pos = 0x1 // Position of DOEN field.
	CRYP_DMACR_DOEN_Msk = 0x2 // Bit mask of DOEN field.
	CRYP_DMACR_DOEN     = 0x2 // Bit DOEN.
	CRYP_DMACR_DIEN_Pos = 0x0 // Position of DIEN field.
	CRYP_DMACR_DIEN_Msk = 0x1 // Bit mask of DIEN field.
	CRYP_DMACR_DIEN     = 0x1 // Bit DIEN.

	// IMSCR: interrupt mask set/clear           register
	CRYP_IMSCR_OUTIM_Pos = 0x1 // Position of OUTIM field.
	CRYP_IMSCR_OUTIM_Msk = 0x2 // Bit mask of OUTIM field.
	CRYP_IMSCR_OUTIM     = 0x2 // Bit OUTIM.
	CRYP_IMSCR_INIM_Pos  = 0x0 // Position of INIM field.
	CRYP_IMSCR_INIM_Msk  = 0x1 // Bit mask of INIM field.
	CRYP_IMSCR_INIM      = 0x1 // Bit INIM.

	// RISR: raw interrupt status register
	CRYP_RISR_OUTRIS_Pos = 0x1 // Position of OUTRIS field.
	CRYP_RISR_OUTRIS_Msk = 0x2 // Bit mask of OUTRIS field.
	CRYP_RISR_OUTRIS     = 0x2 // Bit OUTRIS.
	CRYP_RISR_INRIS_Pos  = 0x0 // Position of INRIS field.
	CRYP_RISR_INRIS_Msk  = 0x1 // Bit mask of INRIS field.
	CRYP_RISR_INRIS      = 0x1 // Bit INRIS.

	// MISR: masked interrupt status           register
	CRYP_MISR_OUTMIS_Pos = 0x1 // Position of OUTMIS field.
	CRYP_MISR_OUTMIS_Msk = 0x2 // Bit mask of OUTMIS field.
	CRYP_MISR_OUTMIS     = 0x2 // Bit OUTMIS.
	CRYP_MISR_INMIS_Pos  = 0x0 // Position of INMIS field.
	CRYP_MISR_INMIS_Msk  = 0x1 // Bit mask of INMIS field.
	CRYP_MISR_INMIS      = 0x1 // Bit INMIS.

	// K0LR: key registers
	CRYP_K0LR_B224_Pos = 0x0        // Position of B224 field.
	CRYP_K0LR_B224_Msk = 0x1        // Bit mask of B224 field.
	CRYP_K0LR_B224     = 0x1        // Bit B224.
	CRYP_K0LR_B225_Pos = 0x1        // Position of B225 field.
	CRYP_K0LR_B225_Msk = 0x2        // Bit mask of B225 field.
	CRYP_K0LR_B225     = 0x2        // Bit B225.
	CRYP_K0LR_B226_Pos = 0x2        // Position of B226 field.
	CRYP_K0LR_B226_Msk = 0x4        // Bit mask of B226 field.
	CRYP_K0LR_B226     = 0x4        // Bit B226.
	CRYP_K0LR_B227_Pos = 0x3        // Position of B227 field.
	CRYP_K0LR_B227_Msk = 0x8        // Bit mask of B227 field.
	CRYP_K0LR_B227     = 0x8        // Bit B227.
	CRYP_K0LR_B228_Pos = 0x4        // Position of B228 field.
	CRYP_K0LR_B228_Msk = 0x10       // Bit mask of B228 field.
	CRYP_K0LR_B228     = 0x10       // Bit B228.
	CRYP_K0LR_B229_Pos = 0x5        // Position of B229 field.
	CRYP_K0LR_B229_Msk = 0x20       // Bit mask of B229 field.
	CRYP_K0LR_B229     = 0x20       // Bit B229.
	CRYP_K0LR_B230_Pos = 0x6        // Position of B230 field.
	CRYP_K0LR_B230_Msk = 0x40       // Bit mask of B230 field.
	CRYP_K0LR_B230     = 0x40       // Bit B230.
	CRYP_K0LR_B231_Pos = 0x7        // Position of B231 field.
	CRYP_K0LR_B231_Msk = 0x80       // Bit mask of B231 field.
	CRYP_K0LR_B231     = 0x80       // Bit B231.
	CRYP_K0LR_B232_Pos = 0x8        // Position of B232 field.
	CRYP_K0LR_B232_Msk = 0x100      // Bit mask of B232 field.
	CRYP_K0LR_B232     = 0x100      // Bit B232.
	CRYP_K0LR_B233_Pos = 0x9        // Position of B233 field.
	CRYP_K0LR_B233_Msk = 0x200      // Bit mask of B233 field.
	CRYP_K0LR_B233     = 0x200      // Bit B233.
	CRYP_K0LR_B234_Pos = 0xa        // Position of B234 field.
	CRYP_K0LR_B234_Msk = 0x400      // Bit mask of B234 field.
	CRYP_K0LR_B234     = 0x400      // Bit B234.
	CRYP_K0LR_B235_Pos = 0xb        // Position of B235 field.
	CRYP_K0LR_B235_Msk = 0x800      // Bit mask of B235 field.
	CRYP_K0LR_B235     = 0x800      // Bit B235.
	CRYP_K0LR_B236_Pos = 0xc        // Position of B236 field.
	CRYP_K0LR_B236_Msk = 0x1000     // Bit mask of B236 field.
	CRYP_K0LR_B236     = 0x1000     // Bit B236.
	CRYP_K0LR_B237_Pos = 0xd        // Position of B237 field.
	CRYP_K0LR_B237_Msk = 0x2000     // Bit mask of B237 field.
	CRYP_K0LR_B237     = 0x2000     // Bit B237.
	CRYP_K0LR_B238_Pos = 0xe        // Position of B238 field.
	CRYP_K0LR_B238_Msk = 0x4000     // Bit mask of B238 field.
	CRYP_K0LR_B238     = 0x4000     // Bit B238.
	CRYP_K0LR_B239_Pos = 0xf        // Position of B239 field.
	CRYP_K0LR_B239_Msk = 0x8000     // Bit mask of B239 field.
	CRYP_K0LR_B239     = 0x8000     // Bit B239.
	CRYP_K0LR_B240_Pos = 0x10       // Position of B240 field.
	CRYP_K0LR_B240_Msk = 0x10000    // Bit mask of B240 field.
	CRYP_K0LR_B240     = 0x10000    // Bit B240.
	CRYP_K0LR_B241_Pos = 0x11       // Position of B241 field.
	CRYP_K0LR_B241_Msk = 0x20000    // Bit mask of B241 field.
	CRYP_K0LR_B241     = 0x20000    // Bit B241.
	CRYP_K0LR_B242_Pos = 0x12       // Position of B242 field.
	CRYP_K0LR_B242_Msk = 0x40000    // Bit mask of B242 field.
	CRYP_K0LR_B242     = 0x40000    // Bit B242.
	CRYP_K0LR_B243_Pos = 0x13       // Position of B243 field.
	CRYP_K0LR_B243_Msk = 0x80000    // Bit mask of B243 field.
	CRYP_K0LR_B243     = 0x80000    // Bit B243.
	CRYP_K0LR_B244_Pos = 0x14       // Position of B244 field.
	CRYP_K0LR_B244_Msk = 0x100000   // Bit mask of B244 field.
	CRYP_K0LR_B244     = 0x100000   // Bit B244.
	CRYP_K0LR_B245_Pos = 0x15       // Position of B245 field.
	CRYP_K0LR_B245_Msk = 0x200000   // Bit mask of B245 field.
	CRYP_K0LR_B245     = 0x200000   // Bit B245.
	CRYP_K0LR_B246_Pos = 0x16       // Position of B246 field.
	CRYP_K0LR_B246_Msk = 0x400000   // Bit mask of B246 field.
	CRYP_K0LR_B246     = 0x400000   // Bit B246.
	CRYP_K0LR_B247_Pos = 0x17       // Position of B247 field.
	CRYP_K0LR_B247_Msk = 0x800000   // Bit mask of B247 field.
	CRYP_K0LR_B247     = 0x800000   // Bit B247.
	CRYP_K0LR_B248_Pos = 0x18       // Position of B248 field.
	CRYP_K0LR_B248_Msk = 0x1000000  // Bit mask of B248 field.
	CRYP_K0LR_B248     = 0x1000000  // Bit B248.
	CRYP_K0LR_B249_Pos = 0x19       // Position of B249 field.
	CRYP_K0LR_B249_Msk = 0x2000000  // Bit mask of B249 field.
	CRYP_K0LR_B249     = 0x2000000  // Bit B249.
	CRYP_K0LR_B250_Pos = 0x1a       // Position of B250 field.
	CRYP_K0LR_B250_Msk = 0x4000000  // Bit mask of B250 field.
	CRYP_K0LR_B250     = 0x4000000  // Bit B250.
	CRYP_K0LR_B251_Pos = 0x1b       // Position of B251 field.
	CRYP_K0LR_B251_Msk = 0x8000000  // Bit mask of B251 field.
	CRYP_K0LR_B251     = 0x8000000  // Bit B251.
	CRYP_K0LR_B252_Pos = 0x1c       // Position of B252 field.
	CRYP_K0LR_B252_Msk = 0x10000000 // Bit mask of B252 field.
	CRYP_K0LR_B252     = 0x10000000 // Bit B252.
	CRYP_K0LR_B253_Pos = 0x1d       // Position of B253 field.
	CRYP_K0LR_B253_Msk = 0x20000000 // Bit mask of B253 field.
	CRYP_K0LR_B253     = 0x20000000 // Bit B253.
	CRYP_K0LR_B254_Pos = 0x1e       // Position of B254 field.
	CRYP_K0LR_B254_Msk = 0x40000000 // Bit mask of B254 field.
	CRYP_K0LR_B254     = 0x40000000 // Bit B254.
	CRYP_K0LR_B255_Pos = 0x1f       // Position of B255 field.
	CRYP_K0LR_B255_Msk = 0x80000000 // Bit mask of B255 field.
	CRYP_K0LR_B255     = 0x80000000 // Bit B255.

	// K0RR: key registers
	CRYP_K0RR_B192_Pos = 0x0        // Position of B192 field.
	CRYP_K0RR_B192_Msk = 0x1        // Bit mask of B192 field.
	CRYP_K0RR_B192     = 0x1        // Bit B192.
	CRYP_K0RR_B193_Pos = 0x1        // Position of B193 field.
	CRYP_K0RR_B193_Msk = 0x2        // Bit mask of B193 field.
	CRYP_K0RR_B193     = 0x2        // Bit B193.
	CRYP_K0RR_B194_Pos = 0x2        // Position of B194 field.
	CRYP_K0RR_B194_Msk = 0x4        // Bit mask of B194 field.
	CRYP_K0RR_B194     = 0x4        // Bit B194.
	CRYP_K0RR_B195_Pos = 0x3        // Position of B195 field.
	CRYP_K0RR_B195_Msk = 0x8        // Bit mask of B195 field.
	CRYP_K0RR_B195     = 0x8        // Bit B195.
	CRYP_K0RR_B196_Pos = 0x4        // Position of B196 field.
	CRYP_K0RR_B196_Msk = 0x10       // Bit mask of B196 field.
	CRYP_K0RR_B196     = 0x10       // Bit B196.
	CRYP_K0RR_B197_Pos = 0x5        // Position of B197 field.
	CRYP_K0RR_B197_Msk = 0x20       // Bit mask of B197 field.
	CRYP_K0RR_B197     = 0x20       // Bit B197.
	CRYP_K0RR_B198_Pos = 0x6        // Position of B198 field.
	CRYP_K0RR_B198_Msk = 0x40       // Bit mask of B198 field.
	CRYP_K0RR_B198     = 0x40       // Bit B198.
	CRYP_K0RR_B199_Pos = 0x7        // Position of B199 field.
	CRYP_K0RR_B199_Msk = 0x80       // Bit mask of B199 field.
	CRYP_K0RR_B199     = 0x80       // Bit B199.
	CRYP_K0RR_B200_Pos = 0x8        // Position of B200 field.
	CRYP_K0RR_B200_Msk = 0x100      // Bit mask of B200 field.
	CRYP_K0RR_B200     = 0x100      // Bit B200.
	CRYP_K0RR_B201_Pos = 0x9        // Position of B201 field.
	CRYP_K0RR_B201_Msk = 0x200      // Bit mask of B201 field.
	CRYP_K0RR_B201     = 0x200      // Bit B201.
	CRYP_K0RR_B202_Pos = 0xa        // Position of B202 field.
	CRYP_K0RR_B202_Msk = 0x400      // Bit mask of B202 field.
	CRYP_K0RR_B202     = 0x400      // Bit B202.
	CRYP_K0RR_B203_Pos = 0xb        // Position of B203 field.
	CRYP_K0RR_B203_Msk = 0x800      // Bit mask of B203 field.
	CRYP_K0RR_B203     = 0x800      // Bit B203.
	CRYP_K0RR_B204_Pos = 0xc        // Position of B204 field.
	CRYP_K0RR_B204_Msk = 0x1000     // Bit mask of B204 field.
	CRYP_K0RR_B204     = 0x1000     // Bit B204.
	CRYP_K0RR_B205_Pos = 0xd        // Position of B205 field.
	CRYP_K0RR_B205_Msk = 0x2000     // Bit mask of B205 field.
	CRYP_K0RR_B205     = 0x2000     // Bit B205.
	CRYP_K0RR_B206_Pos = 0xe        // Position of B206 field.
	CRYP_K0RR_B206_Msk = 0x4000     // Bit mask of B206 field.
	CRYP_K0RR_B206     = 0x4000     // Bit B206.
	CRYP_K0RR_B207_Pos = 0xf        // Position of B207 field.
	CRYP_K0RR_B207_Msk = 0x8000     // Bit mask of B207 field.
	CRYP_K0RR_B207     = 0x8000     // Bit B207.
	CRYP_K0RR_B208_Pos = 0x10       // Position of B208 field.
	CRYP_K0RR_B208_Msk = 0x10000    // Bit mask of B208 field.
	CRYP_K0RR_B208     = 0x10000    // Bit B208.
	CRYP_K0RR_B209_Pos = 0x11       // Position of B209 field.
	CRYP_K0RR_B209_Msk = 0x20000    // Bit mask of B209 field.
	CRYP_K0RR_B209     = 0x20000    // Bit B209.
	CRYP_K0RR_B210_Pos = 0x12       // Position of B210 field.
	CRYP_K0RR_B210_Msk = 0x40000    // Bit mask of B210 field.
	CRYP_K0RR_B210     = 0x40000    // Bit B210.
	CRYP_K0RR_B211_Pos = 0x13       // Position of B211 field.
	CRYP_K0RR_B211_Msk = 0x80000    // Bit mask of B211 field.
	CRYP_K0RR_B211     = 0x80000    // Bit B211.
	CRYP_K0RR_B212_Pos = 0x14       // Position of B212 field.
	CRYP_K0RR_B212_Msk = 0x100000   // Bit mask of B212 field.
	CRYP_K0RR_B212     = 0x100000   // Bit B212.
	CRYP_K0RR_B213_Pos = 0x15       // Position of B213 field.
	CRYP_K0RR_B213_Msk = 0x200000   // Bit mask of B213 field.
	CRYP_K0RR_B213     = 0x200000   // Bit B213.
	CRYP_K0RR_B214_Pos = 0x16       // Position of B214 field.
	CRYP_K0RR_B214_Msk = 0x400000   // Bit mask of B214 field.
	CRYP_K0RR_B214     = 0x400000   // Bit B214.
	CRYP_K0RR_B215_Pos = 0x17       // Position of B215 field.
	CRYP_K0RR_B215_Msk = 0x800000   // Bit mask of B215 field.
	CRYP_K0RR_B215     = 0x800000   // Bit B215.
	CRYP_K0RR_B216_Pos = 0x18       // Position of B216 field.
	CRYP_K0RR_B216_Msk = 0x1000000  // Bit mask of B216 field.
	CRYP_K0RR_B216     = 0x1000000  // Bit B216.
	CRYP_K0RR_B217_Pos = 0x19       // Position of B217 field.
	CRYP_K0RR_B217_Msk = 0x2000000  // Bit mask of B217 field.
	CRYP_K0RR_B217     = 0x2000000  // Bit B217.
	CRYP_K0RR_B218_Pos = 0x1a       // Position of B218 field.
	CRYP_K0RR_B218_Msk = 0x4000000  // Bit mask of B218 field.
	CRYP_K0RR_B218     = 0x4000000  // Bit B218.
	CRYP_K0RR_B219_Pos = 0x1b       // Position of B219 field.
	CRYP_K0RR_B219_Msk = 0x8000000  // Bit mask of B219 field.
	CRYP_K0RR_B219     = 0x8000000  // Bit B219.
	CRYP_K0RR_B220_Pos = 0x1c       // Position of B220 field.
	CRYP_K0RR_B220_Msk = 0x10000000 // Bit mask of B220 field.
	CRYP_K0RR_B220     = 0x10000000 // Bit B220.
	CRYP_K0RR_B221_Pos = 0x1d       // Position of B221 field.
	CRYP_K0RR_B221_Msk = 0x20000000 // Bit mask of B221 field.
	CRYP_K0RR_B221     = 0x20000000 // Bit B221.
	CRYP_K0RR_B222_Pos = 0x1e       // Position of B222 field.
	CRYP_K0RR_B222_Msk = 0x40000000 // Bit mask of B222 field.
	CRYP_K0RR_B222     = 0x40000000 // Bit B222.
	CRYP_K0RR_B223_Pos = 0x1f       // Position of B223 field.
	CRYP_K0RR_B223_Msk = 0x80000000 // Bit mask of B223 field.
	CRYP_K0RR_B223     = 0x80000000 // Bit B223.

	// K1LR: key registers
	CRYP_K1LR_B160_Pos = 0x0        // Position of B160 field.
	CRYP_K1LR_B160_Msk = 0x1        // Bit mask of B160 field.
	CRYP_K1LR_B160     = 0x1        // Bit B160.
	CRYP_K1LR_B161_Pos = 0x1        // Position of B161 field.
	CRYP_K1LR_B161_Msk = 0x2        // Bit mask of B161 field.
	CRYP_K1LR_B161     = 0x2        // Bit B161.
	CRYP_K1LR_B162_Pos = 0x2        // Position of B162 field.
	CRYP_K1LR_B162_Msk = 0x4        // Bit mask of B162 field.
	CRYP_K1LR_B162     = 0x4        // Bit B162.
	CRYP_K1LR_B163_Pos = 0x3        // Position of B163 field.
	CRYP_K1LR_B163_Msk = 0x8        // Bit mask of B163 field.
	CRYP_K1LR_B163     = 0x8        // Bit B163.
	CRYP_K1LR_B164_Pos = 0x4        // Position of B164 field.
	CRYP_K1LR_B164_Msk = 0x10       // Bit mask of B164 field.
	CRYP_K1LR_B164     = 0x10       // Bit B164.
	CRYP_K1LR_B165_Pos = 0x5        // Position of B165 field.
	CRYP_K1LR_B165_Msk = 0x20       // Bit mask of B165 field.
	CRYP_K1LR_B165     = 0x20       // Bit B165.
	CRYP_K1LR_B166_Pos = 0x6        // Position of B166 field.
	CRYP_K1LR_B166_Msk = 0x40       // Bit mask of B166 field.
	CRYP_K1LR_B166     = 0x40       // Bit B166.
	CRYP_K1LR_B167_Pos = 0x7        // Position of B167 field.
	CRYP_K1LR_B167_Msk = 0x80       // Bit mask of B167 field.
	CRYP_K1LR_B167     = 0x80       // Bit B167.
	CRYP_K1LR_B168_Pos = 0x8        // Position of B168 field.
	CRYP_K1LR_B168_Msk = 0x100      // Bit mask of B168 field.
	CRYP_K1LR_B168     = 0x100      // Bit B168.
	CRYP_K1LR_B169_Pos = 0x9        // Position of B169 field.
	CRYP_K1LR_B169_Msk = 0x200      // Bit mask of B169 field.
	CRYP_K1LR_B169     = 0x200      // Bit B169.
	CRYP_K1LR_B170_Pos = 0xa        // Position of B170 field.
	CRYP_K1LR_B170_Msk = 0x400      // Bit mask of B170 field.
	CRYP_K1LR_B170     = 0x400      // Bit B170.
	CRYP_K1LR_B171_Pos = 0xb        // Position of B171 field.
	CRYP_K1LR_B171_Msk = 0x800      // Bit mask of B171 field.
	CRYP_K1LR_B171     = 0x800      // Bit B171.
	CRYP_K1LR_B172_Pos = 0xc        // Position of B172 field.
	CRYP_K1LR_B172_Msk = 0x1000     // Bit mask of B172 field.
	CRYP_K1LR_B172     = 0x1000     // Bit B172.
	CRYP_K1LR_B173_Pos = 0xd        // Position of B173 field.
	CRYP_K1LR_B173_Msk = 0x2000     // Bit mask of B173 field.
	CRYP_K1LR_B173     = 0x2000     // Bit B173.
	CRYP_K1LR_B174_Pos = 0xe        // Position of B174 field.
	CRYP_K1LR_B174_Msk = 0x4000     // Bit mask of B174 field.
	CRYP_K1LR_B174     = 0x4000     // Bit B174.
	CRYP_K1LR_B175_Pos = 0xf        // Position of B175 field.
	CRYP_K1LR_B175_Msk = 0x8000     // Bit mask of B175 field.
	CRYP_K1LR_B175     = 0x8000     // Bit B175.
	CRYP_K1LR_B176_Pos = 0x10       // Position of B176 field.
	CRYP_K1LR_B176_Msk = 0x10000    // Bit mask of B176 field.
	CRYP_K1LR_B176     = 0x10000    // Bit B176.
	CRYP_K1LR_B177_Pos = 0x11       // Position of B177 field.
	CRYP_K1LR_B177_Msk = 0x20000    // Bit mask of B177 field.
	CRYP_K1LR_B177     = 0x20000    // Bit B177.
	CRYP_K1LR_B178_Pos = 0x12       // Position of B178 field.
	CRYP_K1LR_B178_Msk = 0x40000    // Bit mask of B178 field.
	CRYP_K1LR_B178     = 0x40000    // Bit B178.
	CRYP_K1LR_B179_Pos = 0x13       // Position of B179 field.
	CRYP_K1LR_B179_Msk = 0x80000    // Bit mask of B179 field.
	CRYP_K1LR_B179     = 0x80000    // Bit B179.
	CRYP_K1LR_B180_Pos = 0x14       // Position of B180 field.
	CRYP_K1LR_B180_Msk = 0x100000   // Bit mask of B180 field.
	CRYP_K1LR_B180     = 0x100000   // Bit B180.
	CRYP_K1LR_B181_Pos = 0x15       // Position of B181 field.
	CRYP_K1LR_B181_Msk = 0x200000   // Bit mask of B181 field.
	CRYP_K1LR_B181     = 0x200000   // Bit B181.
	CRYP_K1LR_B182_Pos = 0x16       // Position of B182 field.
	CRYP_K1LR_B182_Msk = 0x400000   // Bit mask of B182 field.
	CRYP_K1LR_B182     = 0x400000   // Bit B182.
	CRYP_K1LR_B183_Pos = 0x17       // Position of B183 field.
	CRYP_K1LR_B183_Msk = 0x800000   // Bit mask of B183 field.
	CRYP_K1LR_B183     = 0x800000   // Bit B183.
	CRYP_K1LR_B184_Pos = 0x18       // Position of B184 field.
	CRYP_K1LR_B184_Msk = 0x1000000  // Bit mask of B184 field.
	CRYP_K1LR_B184     = 0x1000000  // Bit B184.
	CRYP_K1LR_B185_Pos = 0x19       // Position of B185 field.
	CRYP_K1LR_B185_Msk = 0x2000000  // Bit mask of B185 field.
	CRYP_K1LR_B185     = 0x2000000  // Bit B185.
	CRYP_K1LR_B186_Pos = 0x1a       // Position of B186 field.
	CRYP_K1LR_B186_Msk = 0x4000000  // Bit mask of B186 field.
	CRYP_K1LR_B186     = 0x4000000  // Bit B186.
	CRYP_K1LR_B187_Pos = 0x1b       // Position of B187 field.
	CRYP_K1LR_B187_Msk = 0x8000000  // Bit mask of B187 field.
	CRYP_K1LR_B187     = 0x8000000  // Bit B187.
	CRYP_K1LR_B188_Pos = 0x1c       // Position of B188 field.
	CRYP_K1LR_B188_Msk = 0x10000000 // Bit mask of B188 field.
	CRYP_K1LR_B188     = 0x10000000 // Bit B188.
	CRYP_K1LR_B189_Pos = 0x1d       // Position of B189 field.
	CRYP_K1LR_B189_Msk = 0x20000000 // Bit mask of B189 field.
	CRYP_K1LR_B189     = 0x20000000 // Bit B189.
	CRYP_K1LR_B190_Pos = 0x1e       // Position of B190 field.
	CRYP_K1LR_B190_Msk = 0x40000000 // Bit mask of B190 field.
	CRYP_K1LR_B190     = 0x40000000 // Bit B190.
	CRYP_K1LR_B191_Pos = 0x1f       // Position of B191 field.
	CRYP_K1LR_B191_Msk = 0x80000000 // Bit mask of B191 field.
	CRYP_K1LR_B191     = 0x80000000 // Bit B191.

	// K1RR: key registers
	CRYP_K1RR_B128_Pos = 0x0        // Position of B128 field.
	CRYP_K1RR_B128_Msk = 0x1        // Bit mask of B128 field.
	CRYP_K1RR_B128     = 0x1        // Bit B128.
	CRYP_K1RR_B129_Pos = 0x1        // Position of B129 field.
	CRYP_K1RR_B129_Msk = 0x2        // Bit mask of B129 field.
	CRYP_K1RR_B129     = 0x2        // Bit B129.
	CRYP_K1RR_B130_Pos = 0x2        // Position of B130 field.
	CRYP_K1RR_B130_Msk = 0x4        // Bit mask of B130 field.
	CRYP_K1RR_B130     = 0x4        // Bit B130.
	CRYP_K1RR_B131_Pos = 0x3        // Position of B131 field.
	CRYP_K1RR_B131_Msk = 0x8        // Bit mask of B131 field.
	CRYP_K1RR_B131     = 0x8        // Bit B131.
	CRYP_K1RR_B132_Pos = 0x4        // Position of B132 field.
	CRYP_K1RR_B132_Msk = 0x10       // Bit mask of B132 field.
	CRYP_K1RR_B132     = 0x10       // Bit B132.
	CRYP_K1RR_B133_Pos = 0x5        // Position of B133 field.
	CRYP_K1RR_B133_Msk = 0x20       // Bit mask of B133 field.
	CRYP_K1RR_B133     = 0x20       // Bit B133.
	CRYP_K1RR_B134_Pos = 0x6        // Position of B134 field.
	CRYP_K1RR_B134_Msk = 0x40       // Bit mask of B134 field.
	CRYP_K1RR_B134     = 0x40       // Bit B134.
	CRYP_K1RR_B135_Pos = 0x7        // Position of B135 field.
	CRYP_K1RR_B135_Msk = 0x80       // Bit mask of B135 field.
	CRYP_K1RR_B135     = 0x80       // Bit B135.
	CRYP_K1RR_B136_Pos = 0x8        // Position of B136 field.
	CRYP_K1RR_B136_Msk = 0x100      // Bit mask of B136 field.
	CRYP_K1RR_B136     = 0x100      // Bit B136.
	CRYP_K1RR_B137_Pos = 0x9        // Position of B137 field.
	CRYP_K1RR_B137_Msk = 0x200      // Bit mask of B137 field.
	CRYP_K1RR_B137     = 0x200      // Bit B137.
	CRYP_K1RR_B138_Pos = 0xa        // Position of B138 field.
	CRYP_K1RR_B138_Msk = 0x400      // Bit mask of B138 field.
	CRYP_K1RR_B138     = 0x400      // Bit B138.
	CRYP_K1RR_B139_Pos = 0xb        // Position of B139 field.
	CRYP_K1RR_B139_Msk = 0x800      // Bit mask of B139 field.
	CRYP_K1RR_B139     = 0x800      // Bit B139.
	CRYP_K1RR_B140_Pos = 0xc        // Position of B140 field.
	CRYP_K1RR_B140_Msk = 0x1000     // Bit mask of B140 field.
	CRYP_K1RR_B140     = 0x1000     // Bit B140.
	CRYP_K1RR_B141_Pos = 0xd        // Position of B141 field.
	CRYP_K1RR_B141_Msk = 0x2000     // Bit mask of B141 field.
	CRYP_K1RR_B141     = 0x2000     // Bit B141.
	CRYP_K1RR_B142_Pos = 0xe        // Position of B142 field.
	CRYP_K1RR_B142_Msk = 0x4000     // Bit mask of B142 field.
	CRYP_K1RR_B142     = 0x4000     // Bit B142.
	CRYP_K1RR_B143_Pos = 0xf        // Position of B143 field.
	CRYP_K1RR_B143_Msk = 0x8000     // Bit mask of B143 field.
	CRYP_K1RR_B143     = 0x8000     // Bit B143.
	CRYP_K1RR_B144_Pos = 0x10       // Position of B144 field.
	CRYP_K1RR_B144_Msk = 0x10000    // Bit mask of B144 field.
	CRYP_K1RR_B144     = 0x10000    // Bit B144.
	CRYP_K1RR_B145_Pos = 0x11       // Position of B145 field.
	CRYP_K1RR_B145_Msk = 0x20000    // Bit mask of B145 field.
	CRYP_K1RR_B145     = 0x20000    // Bit B145.
	CRYP_K1RR_B146_Pos = 0x12       // Position of B146 field.
	CRYP_K1RR_B146_Msk = 0x40000    // Bit mask of B146 field.
	CRYP_K1RR_B146     = 0x40000    // Bit B146.
	CRYP_K1RR_B147_Pos = 0x13       // Position of B147 field.
	CRYP_K1RR_B147_Msk = 0x80000    // Bit mask of B147 field.
	CRYP_K1RR_B147     = 0x80000    // Bit B147.
	CRYP_K1RR_B148_Pos = 0x14       // Position of B148 field.
	CRYP_K1RR_B148_Msk = 0x100000   // Bit mask of B148 field.
	CRYP_K1RR_B148     = 0x100000   // Bit B148.
	CRYP_K1RR_B149_Pos = 0x15       // Position of B149 field.
	CRYP_K1RR_B149_Msk = 0x200000   // Bit mask of B149 field.
	CRYP_K1RR_B149     = 0x200000   // Bit B149.
	CRYP_K1RR_B150_Pos = 0x16       // Position of B150 field.
	CRYP_K1RR_B150_Msk = 0x400000   // Bit mask of B150 field.
	CRYP_K1RR_B150     = 0x400000   // Bit B150.
	CRYP_K1RR_B151_Pos = 0x17       // Position of B151 field.
	CRYP_K1RR_B151_Msk = 0x800000   // Bit mask of B151 field.
	CRYP_K1RR_B151     = 0x800000   // Bit B151.
	CRYP_K1RR_B152_Pos = 0x18       // Position of B152 field.
	CRYP_K1RR_B152_Msk = 0x1000000  // Bit mask of B152 field.
	CRYP_K1RR_B152     = 0x1000000  // Bit B152.
	CRYP_K1RR_B153_Pos = 0x19       // Position of B153 field.
	CRYP_K1RR_B153_Msk = 0x2000000  // Bit mask of B153 field.
	CRYP_K1RR_B153     = 0x2000000  // Bit B153.
	CRYP_K1RR_B154_Pos = 0x1a       // Position of B154 field.
	CRYP_K1RR_B154_Msk = 0x4000000  // Bit mask of B154 field.
	CRYP_K1RR_B154     = 0x4000000  // Bit B154.
	CRYP_K1RR_B155_Pos = 0x1b       // Position of B155 field.
	CRYP_K1RR_B155_Msk = 0x8000000  // Bit mask of B155 field.
	CRYP_K1RR_B155     = 0x8000000  // Bit B155.
	CRYP_K1RR_B156_Pos = 0x1c       // Position of B156 field.
	CRYP_K1RR_B156_Msk = 0x10000000 // Bit mask of B156 field.
	CRYP_K1RR_B156     = 0x10000000 // Bit B156.
	CRYP_K1RR_B157_Pos = 0x1d       // Position of B157 field.
	CRYP_K1RR_B157_Msk = 0x20000000 // Bit mask of B157 field.
	CRYP_K1RR_B157     = 0x20000000 // Bit B157.
	CRYP_K1RR_B158_Pos = 0x1e       // Position of B158 field.
	CRYP_K1RR_B158_Msk = 0x40000000 // Bit mask of B158 field.
	CRYP_K1RR_B158     = 0x40000000 // Bit B158.
	CRYP_K1RR_B159_Pos = 0x1f       // Position of B159 field.
	CRYP_K1RR_B159_Msk = 0x80000000 // Bit mask of B159 field.
	CRYP_K1RR_B159     = 0x80000000 // Bit B159.

	// K2LR: key registers
	CRYP_K2LR_B96_Pos  = 0x0        // Position of B96 field.
	CRYP_K2LR_B96_Msk  = 0x1        // Bit mask of B96 field.
	CRYP_K2LR_B96      = 0x1        // Bit B96.
	CRYP_K2LR_B97_Pos  = 0x1        // Position of B97 field.
	CRYP_K2LR_B97_Msk  = 0x2        // Bit mask of B97 field.
	CRYP_K2LR_B97      = 0x2        // Bit B97.
	CRYP_K2LR_B98_Pos  = 0x2        // Position of B98 field.
	CRYP_K2LR_B98_Msk  = 0x4        // Bit mask of B98 field.
	CRYP_K2LR_B98      = 0x4        // Bit B98.
	CRYP_K2LR_B99_Pos  = 0x3        // Position of B99 field.
	CRYP_K2LR_B99_Msk  = 0x8        // Bit mask of B99 field.
	CRYP_K2LR_B99      = 0x8        // Bit B99.
	CRYP_K2LR_B100_Pos = 0x4        // Position of B100 field.
	CRYP_K2LR_B100_Msk = 0x10       // Bit mask of B100 field.
	CRYP_K2LR_B100     = 0x10       // Bit B100.
	CRYP_K2LR_B101_Pos = 0x5        // Position of B101 field.
	CRYP_K2LR_B101_Msk = 0x20       // Bit mask of B101 field.
	CRYP_K2LR_B101     = 0x20       // Bit B101.
	CRYP_K2LR_B102_Pos = 0x6        // Position of B102 field.
	CRYP_K2LR_B102_Msk = 0x40       // Bit mask of B102 field.
	CRYP_K2LR_B102     = 0x40       // Bit B102.
	CRYP_K2LR_B103_Pos = 0x7        // Position of B103 field.
	CRYP_K2LR_B103_Msk = 0x80       // Bit mask of B103 field.
	CRYP_K2LR_B103     = 0x80       // Bit B103.
	CRYP_K2LR_B104_Pos = 0x8        // Position of B104 field.
	CRYP_K2LR_B104_Msk = 0x100      // Bit mask of B104 field.
	CRYP_K2LR_B104     = 0x100      // Bit B104.
	CRYP_K2LR_B105_Pos = 0x9        // Position of B105 field.
	CRYP_K2LR_B105_Msk = 0x200      // Bit mask of B105 field.
	CRYP_K2LR_B105     = 0x200      // Bit B105.
	CRYP_K2LR_B106_Pos = 0xa        // Position of B106 field.
	CRYP_K2LR_B106_Msk = 0x400      // Bit mask of B106 field.
	CRYP_K2LR_B106     = 0x400      // Bit B106.
	CRYP_K2LR_B107_Pos = 0xb        // Position of B107 field.
	CRYP_K2LR_B107_Msk = 0x800      // Bit mask of B107 field.
	CRYP_K2LR_B107     = 0x800      // Bit B107.
	CRYP_K2LR_B108_Pos = 0xc        // Position of B108 field.
	CRYP_K2LR_B108_Msk = 0x1000     // Bit mask of B108 field.
	CRYP_K2LR_B108     = 0x1000     // Bit B108.
	CRYP_K2LR_B109_Pos = 0xd        // Position of B109 field.
	CRYP_K2LR_B109_Msk = 0x2000     // Bit mask of B109 field.
	CRYP_K2LR_B109     = 0x2000     // Bit B109.
	CRYP_K2LR_B110_Pos = 0xe        // Position of B110 field.
	CRYP_K2LR_B110_Msk = 0x4000     // Bit mask of B110 field.
	CRYP_K2LR_B110     = 0x4000     // Bit B110.
	CRYP_K2LR_B111_Pos = 0xf        // Position of B111 field.
	CRYP_K2LR_B111_Msk = 0x8000     // Bit mask of B111 field.
	CRYP_K2LR_B111     = 0x8000     // Bit B111.
	CRYP_K2LR_B112_Pos = 0x10       // Position of B112 field.
	CRYP_K2LR_B112_Msk = 0x10000    // Bit mask of B112 field.
	CRYP_K2LR_B112     = 0x10000    // Bit B112.
	CRYP_K2LR_B113_Pos = 0x11       // Position of B113 field.
	CRYP_K2LR_B113_Msk = 0x20000    // Bit mask of B113 field.
	CRYP_K2LR_B113     = 0x20000    // Bit B113.
	CRYP_K2LR_B114_Pos = 0x12       // Position of B114 field.
	CRYP_K2LR_B114_Msk = 0x40000    // Bit mask of B114 field.
	CRYP_K2LR_B114     = 0x40000    // Bit B114.
	CRYP_K2LR_B115_Pos = 0x13       // Position of B115 field.
	CRYP_K2LR_B115_Msk = 0x80000    // Bit mask of B115 field.
	CRYP_K2LR_B115     = 0x80000    // Bit B115.
	CRYP_K2LR_B116_Pos = 0x14       // Position of B116 field.
	CRYP_K2LR_B116_Msk = 0x100000   // Bit mask of B116 field.
	CRYP_K2LR_B116     = 0x100000   // Bit B116.
	CRYP_K2LR_B117_Pos = 0x15       // Position of B117 field.
	CRYP_K2LR_B117_Msk = 0x200000   // Bit mask of B117 field.
	CRYP_K2LR_B117     = 0x200000   // Bit B117.
	CRYP_K2LR_B118_Pos = 0x16       // Position of B118 field.
	CRYP_K2LR_B118_Msk = 0x400000   // Bit mask of B118 field.
	CRYP_K2LR_B118     = 0x400000   // Bit B118.
	CRYP_K2LR_B119_Pos = 0x17       // Position of B119 field.
	CRYP_K2LR_B119_Msk = 0x800000   // Bit mask of B119 field.
	CRYP_K2LR_B119     = 0x800000   // Bit B119.
	CRYP_K2LR_B120_Pos = 0x18       // Position of B120 field.
	CRYP_K2LR_B120_Msk = 0x1000000  // Bit mask of B120 field.
	CRYP_K2LR_B120     = 0x1000000  // Bit B120.
	CRYP_K2LR_B121_Pos = 0x19       // Position of B121 field.
	CRYP_K2LR_B121_Msk = 0x2000000  // Bit mask of B121 field.
	CRYP_K2LR_B121     = 0x2000000  // Bit B121.
	CRYP_K2LR_B122_Pos = 0x1a       // Position of B122 field.
	CRYP_K2LR_B122_Msk = 0x4000000  // Bit mask of B122 field.
	CRYP_K2LR_B122     = 0x4000000  // Bit B122.
	CRYP_K2LR_B123_Pos = 0x1b       // Position of B123 field.
	CRYP_K2LR_B123_Msk = 0x8000000  // Bit mask of B123 field.
	CRYP_K2LR_B123     = 0x8000000  // Bit B123.
	CRYP_K2LR_B124_Pos = 0x1c       // Position of B124 field.
	CRYP_K2LR_B124_Msk = 0x10000000 // Bit mask of B124 field.
	CRYP_K2LR_B124     = 0x10000000 // Bit B124.
	CRYP_K2LR_B125_Pos = 0x1d       // Position of B125 field.
	CRYP_K2LR_B125_Msk = 0x20000000 // Bit mask of B125 field.
	CRYP_K2LR_B125     = 0x20000000 // Bit B125.
	CRYP_K2LR_B126_Pos = 0x1e       // Position of B126 field.
	CRYP_K2LR_B126_Msk = 0x40000000 // Bit mask of B126 field.
	CRYP_K2LR_B126     = 0x40000000 // Bit B126.
	CRYP_K2LR_B127_Pos = 0x1f       // Position of B127 field.
	CRYP_K2LR_B127_Msk = 0x80000000 // Bit mask of B127 field.
	CRYP_K2LR_B127     = 0x80000000 // Bit B127.

	// K2RR: key registers
	CRYP_K2RR_B64_Pos = 0x0        // Position of B64 field.
	CRYP_K2RR_B64_Msk = 0x1        // Bit mask of B64 field.
	CRYP_K2RR_B64     = 0x1        // Bit B64.
	CRYP_K2RR_B65_Pos = 0x1        // Position of B65 field.
	CRYP_K2RR_B65_Msk = 0x2        // Bit mask of B65 field.
	CRYP_K2RR_B65     = 0x2        // Bit B65.
	CRYP_K2RR_B66_Pos = 0x2        // Position of B66 field.
	CRYP_K2RR_B66_Msk = 0x4        // Bit mask of B66 field.
	CRYP_K2RR_B66     = 0x4        // Bit B66.
	CRYP_K2RR_B67_Pos = 0x3        // Position of B67 field.
	CRYP_K2RR_B67_Msk = 0x8        // Bit mask of B67 field.
	CRYP_K2RR_B67     = 0x8        // Bit B67.
	CRYP_K2RR_B68_Pos = 0x4        // Position of B68 field.
	CRYP_K2RR_B68_Msk = 0x10       // Bit mask of B68 field.
	CRYP_K2RR_B68     = 0x10       // Bit B68.
	CRYP_K2RR_B69_Pos = 0x5        // Position of B69 field.
	CRYP_K2RR_B69_Msk = 0x20       // Bit mask of B69 field.
	CRYP_K2RR_B69     = 0x20       // Bit B69.
	CRYP_K2RR_B70_Pos = 0x6        // Position of B70 field.
	CRYP_K2RR_B70_Msk = 0x40       // Bit mask of B70 field.
	CRYP_K2RR_B70     = 0x40       // Bit B70.
	CRYP_K2RR_B71_Pos = 0x7        // Position of B71 field.
	CRYP_K2RR_B71_Msk = 0x80       // Bit mask of B71 field.
	CRYP_K2RR_B71     = 0x80       // Bit B71.
	CRYP_K2RR_B72_Pos = 0x8        // Position of B72 field.
	CRYP_K2RR_B72_Msk = 0x100      // Bit mask of B72 field.
	CRYP_K2RR_B72     = 0x100      // Bit B72.
	CRYP_K2RR_B73_Pos = 0x9        // Position of B73 field.
	CRYP_K2RR_B73_Msk = 0x200      // Bit mask of B73 field.
	CRYP_K2RR_B73     = 0x200      // Bit B73.
	CRYP_K2RR_B74_Pos = 0xa        // Position of B74 field.
	CRYP_K2RR_B74_Msk = 0x400      // Bit mask of B74 field.
	CRYP_K2RR_B74     = 0x400      // Bit B74.
	CRYP_K2RR_B75_Pos = 0xb        // Position of B75 field.
	CRYP_K2RR_B75_Msk = 0x800      // Bit mask of B75 field.
	CRYP_K2RR_B75     = 0x800      // Bit B75.
	CRYP_K2RR_B76_Pos = 0xc        // Position of B76 field.
	CRYP_K2RR_B76_Msk = 0x1000     // Bit mask of B76 field.
	CRYP_K2RR_B76     = 0x1000     // Bit B76.
	CRYP_K2RR_B77_Pos = 0xd        // Position of B77 field.
	CRYP_K2RR_B77_Msk = 0x2000     // Bit mask of B77 field.
	CRYP_K2RR_B77     = 0x2000     // Bit B77.
	CRYP_K2RR_B78_Pos = 0xe        // Position of B78 field.
	CRYP_K2RR_B78_Msk = 0x4000     // Bit mask of B78 field.
	CRYP_K2RR_B78     = 0x4000     // Bit B78.
	CRYP_K2RR_B79_Pos = 0xf        // Position of B79 field.
	CRYP_K2RR_B79_Msk = 0x8000     // Bit mask of B79 field.
	CRYP_K2RR_B79     = 0x8000     // Bit B79.
	CRYP_K2RR_B80_Pos = 0x10       // Position of B80 field.
	CRYP_K2RR_B80_Msk = 0x10000    // Bit mask of B80 field.
	CRYP_K2RR_B80     = 0x10000    // Bit B80.
	CRYP_K2RR_B81_Pos = 0x11       // Position of B81 field.
	CRYP_K2RR_B81_Msk = 0x20000    // Bit mask of B81 field.
	CRYP_K2RR_B81     = 0x20000    // Bit B81.
	CRYP_K2RR_B82_Pos = 0x12       // Position of B82 field.
	CRYP_K2RR_B82_Msk = 0x40000    // Bit mask of B82 field.
	CRYP_K2RR_B82     = 0x40000    // Bit B82.
	CRYP_K2RR_B83_Pos = 0x13       // Position of B83 field.
	CRYP_K2RR_B83_Msk = 0x80000    // Bit mask of B83 field.
	CRYP_K2RR_B83     = 0x80000    // Bit B83.
	CRYP_K2RR_B84_Pos = 0x14       // Position of B84 field.
	CRYP_K2RR_B84_Msk = 0x100000   // Bit mask of B84 field.
	CRYP_K2RR_B84     = 0x100000   // Bit B84.
	CRYP_K2RR_B85_Pos = 0x15       // Position of B85 field.
	CRYP_K2RR_B85_Msk = 0x200000   // Bit mask of B85 field.
	CRYP_K2RR_B85     = 0x200000   // Bit B85.
	CRYP_K2RR_B86_Pos = 0x16       // Position of B86 field.
	CRYP_K2RR_B86_Msk = 0x400000   // Bit mask of B86 field.
	CRYP_K2RR_B86     = 0x400000   // Bit B86.
	CRYP_K2RR_B87_Pos = 0x17       // Position of B87 field.
	CRYP_K2RR_B87_Msk = 0x800000   // Bit mask of B87 field.
	CRYP_K2RR_B87     = 0x800000   // Bit B87.
	CRYP_K2RR_B88_Pos = 0x18       // Position of B88 field.
	CRYP_K2RR_B88_Msk = 0x1000000  // Bit mask of B88 field.
	CRYP_K2RR_B88     = 0x1000000  // Bit B88.
	CRYP_K2RR_B89_Pos = 0x19       // Position of B89 field.
	CRYP_K2RR_B89_Msk = 0x2000000  // Bit mask of B89 field.
	CRYP_K2RR_B89     = 0x2000000  // Bit B89.
	CRYP_K2RR_B90_Pos = 0x1a       // Position of B90 field.
	CRYP_K2RR_B90_Msk = 0x4000000  // Bit mask of B90 field.
	CRYP_K2RR_B90     = 0x4000000  // Bit B90.
	CRYP_K2RR_B91_Pos = 0x1b       // Position of B91 field.
	CRYP_K2RR_B91_Msk = 0x8000000  // Bit mask of B91 field.
	CRYP_K2RR_B91     = 0x8000000  // Bit B91.
	CRYP_K2RR_B92_Pos = 0x1c       // Position of B92 field.
	CRYP_K2RR_B92_Msk = 0x10000000 // Bit mask of B92 field.
	CRYP_K2RR_B92     = 0x10000000 // Bit B92.
	CRYP_K2RR_B93_Pos = 0x1d       // Position of B93 field.
	CRYP_K2RR_B93_Msk = 0x20000000 // Bit mask of B93 field.
	CRYP_K2RR_B93     = 0x20000000 // Bit B93.
	CRYP_K2RR_B94_Pos = 0x1e       // Position of B94 field.
	CRYP_K2RR_B94_Msk = 0x40000000 // Bit mask of B94 field.
	CRYP_K2RR_B94     = 0x40000000 // Bit B94.
	CRYP_K2RR_B95_Pos = 0x1f       // Position of B95 field.
	CRYP_K2RR_B95_Msk = 0x80000000 // Bit mask of B95 field.
	CRYP_K2RR_B95     = 0x80000000 // Bit B95.

	// K3LR: key registers
	CRYP_K3LR_B32_Pos = 0x0        // Position of B32 field.
	CRYP_K3LR_B32_Msk = 0x1        // Bit mask of B32 field.
	CRYP_K3LR_B32     = 0x1        // Bit B32.
	CRYP_K3LR_B33_Pos = 0x1        // Position of B33 field.
	CRYP_K3LR_B33_Msk = 0x2        // Bit mask of B33 field.
	CRYP_K3LR_B33     = 0x2        // Bit B33.
	CRYP_K3LR_B34_Pos = 0x2        // Position of B34 field.
	CRYP_K3LR_B34_Msk = 0x4        // Bit mask of B34 field.
	CRYP_K3LR_B34     = 0x4        // Bit B34.
	CRYP_K3LR_B35_Pos = 0x3        // Position of B35 field.
	CRYP_K3LR_B35_Msk = 0x8        // Bit mask of B35 field.
	CRYP_K3LR_B35     = 0x8        // Bit B35.
	CRYP_K3LR_B36_Pos = 0x4        // Position of B36 field.
	CRYP_K3LR_B36_Msk = 0x10       // Bit mask of B36 field.
	CRYP_K3LR_B36     = 0x10       // Bit B36.
	CRYP_K3LR_B37_Pos = 0x5        // Position of B37 field.
	CRYP_K3LR_B37_Msk = 0x20       // Bit mask of B37 field.
	CRYP_K3LR_B37     = 0x20       // Bit B37.
	CRYP_K3LR_B38_Pos = 0x6        // Position of B38 field.
	CRYP_K3LR_B38_Msk = 0x40       // Bit mask of B38 field.
	CRYP_K3LR_B38     = 0x40       // Bit B38.
	CRYP_K3LR_B39_Pos = 0x7        // Position of B39 field.
	CRYP_K3LR_B39_Msk = 0x80       // Bit mask of B39 field.
	CRYP_K3LR_B39     = 0x80       // Bit B39.
	CRYP_K3LR_B40_Pos = 0x8        // Position of B40 field.
	CRYP_K3LR_B40_Msk = 0x100      // Bit mask of B40 field.
	CRYP_K3LR_B40     = 0x100      // Bit B40.
	CRYP_K3LR_B41_Pos = 0x9        // Position of B41 field.
	CRYP_K3LR_B41_Msk = 0x200      // Bit mask of B41 field.
	CRYP_K3LR_B41     = 0x200      // Bit B41.
	CRYP_K3LR_B42_Pos = 0xa        // Position of B42 field.
	CRYP_K3LR_B42_Msk = 0x400      // Bit mask of B42 field.
	CRYP_K3LR_B42     = 0x400      // Bit B42.
	CRYP_K3LR_B43_Pos = 0xb        // Position of B43 field.
	CRYP_K3LR_B43_Msk = 0x800      // Bit mask of B43 field.
	CRYP_K3LR_B43     = 0x800      // Bit B43.
	CRYP_K3LR_B44_Pos = 0xc        // Position of B44 field.
	CRYP_K3LR_B44_Msk = 0x1000     // Bit mask of B44 field.
	CRYP_K3LR_B44     = 0x1000     // Bit B44.
	CRYP_K3LR_B45_Pos = 0xd        // Position of B45 field.
	CRYP_K3LR_B45_Msk = 0x2000     // Bit mask of B45 field.
	CRYP_K3LR_B45     = 0x2000     // Bit B45.
	CRYP_K3LR_B46_Pos = 0xe        // Position of B46 field.
	CRYP_K3LR_B46_Msk = 0x4000     // Bit mask of B46 field.
	CRYP_K3LR_B46     = 0x4000     // Bit B46.
	CRYP_K3LR_B47_Pos = 0xf        // Position of B47 field.
	CRYP_K3LR_B47_Msk = 0x8000     // Bit mask of B47 field.
	CRYP_K3LR_B47     = 0x8000     // Bit B47.
	CRYP_K3LR_B48_Pos = 0x10       // Position of B48 field.
	CRYP_K3LR_B48_Msk = 0x10000    // Bit mask of B48 field.
	CRYP_K3LR_B48     = 0x10000    // Bit B48.
	CRYP_K3LR_B49_Pos = 0x11       // Position of B49 field.
	CRYP_K3LR_B49_Msk = 0x20000    // Bit mask of B49 field.
	CRYP_K3LR_B49     = 0x20000    // Bit B49.
	CRYP_K3LR_B50_Pos = 0x12       // Position of B50 field.
	CRYP_K3LR_B50_Msk = 0x40000    // Bit mask of B50 field.
	CRYP_K3LR_B50     = 0x40000    // Bit B50.
	CRYP_K3LR_B51_Pos = 0x13       // Position of B51 field.
	CRYP_K3LR_B51_Msk = 0x80000    // Bit mask of B51 field.
	CRYP_K3LR_B51     = 0x80000    // Bit B51.
	CRYP_K3LR_B52_Pos = 0x14       // Position of B52 field.
	CRYP_K3LR_B52_Msk = 0x100000   // Bit mask of B52 field.
	CRYP_K3LR_B52     = 0x100000   // Bit B52.
	CRYP_K3LR_B53_Pos = 0x15       // Position of B53 field.
	CRYP_K3LR_B53_Msk = 0x200000   // Bit mask of B53 field.
	CRYP_K3LR_B53     = 0x200000   // Bit B53.
	CRYP_K3LR_B54_Pos = 0x16       // Position of B54 field.
	CRYP_K3LR_B54_Msk = 0x400000   // Bit mask of B54 field.
	CRYP_K3LR_B54     = 0x400000   // Bit B54.
	CRYP_K3LR_B55_Pos = 0x17       // Position of B55 field.
	CRYP_K3LR_B55_Msk = 0x800000   // Bit mask of B55 field.
	CRYP_K3LR_B55     = 0x800000   // Bit B55.
	CRYP_K3LR_B56_Pos = 0x18       // Position of B56 field.
	CRYP_K3LR_B56_Msk = 0x1000000  // Bit mask of B56 field.
	CRYP_K3LR_B56     = 0x1000000  // Bit B56.
	CRYP_K3LR_B57_Pos = 0x19       // Position of B57 field.
	CRYP_K3LR_B57_Msk = 0x2000000  // Bit mask of B57 field.
	CRYP_K3LR_B57     = 0x2000000  // Bit B57.
	CRYP_K3LR_B58_Pos = 0x1a       // Position of B58 field.
	CRYP_K3LR_B58_Msk = 0x4000000  // Bit mask of B58 field.
	CRYP_K3LR_B58     = 0x4000000  // Bit B58.
	CRYP_K3LR_B59_Pos = 0x1b       // Position of B59 field.
	CRYP_K3LR_B59_Msk = 0x8000000  // Bit mask of B59 field.
	CRYP_K3LR_B59     = 0x8000000  // Bit B59.
	CRYP_K3LR_B60_Pos = 0x1c       // Position of B60 field.
	CRYP_K3LR_B60_Msk = 0x10000000 // Bit mask of B60 field.
	CRYP_K3LR_B60     = 0x10000000 // Bit B60.
	CRYP_K3LR_B61_Pos = 0x1d       // Position of B61 field.
	CRYP_K3LR_B61_Msk = 0x20000000 // Bit mask of B61 field.
	CRYP_K3LR_B61     = 0x20000000 // Bit B61.
	CRYP_K3LR_B62_Pos = 0x1e       // Position of B62 field.
	CRYP_K3LR_B62_Msk = 0x40000000 // Bit mask of B62 field.
	CRYP_K3LR_B62     = 0x40000000 // Bit B62.
	CRYP_K3LR_B63_Pos = 0x1f       // Position of B63 field.
	CRYP_K3LR_B63_Msk = 0x80000000 // Bit mask of B63 field.
	CRYP_K3LR_B63     = 0x80000000 // Bit B63.

	// K3RR: key registers
	CRYP_K3RR_B0_Pos  = 0x0        // Position of B0 field.
	CRYP_K3RR_B0_Msk  = 0x1        // Bit mask of B0 field.
	CRYP_K3RR_B0      = 0x1        // Bit B0.
	CRYP_K3RR_B1_Pos  = 0x1        // Position of B1 field.
	CRYP_K3RR_B1_Msk  = 0x2        // Bit mask of B1 field.
	CRYP_K3RR_B1      = 0x2        // Bit B1.
	CRYP_K3RR_B2_Pos  = 0x2        // Position of B2 field.
	CRYP_K3RR_B2_Msk  = 0x4        // Bit mask of B2 field.
	CRYP_K3RR_B2      = 0x4        // Bit B2.
	CRYP_K3RR_B3_Pos  = 0x3        // Position of B3 field.
	CRYP_K3RR_B3_Msk  = 0x8        // Bit mask of B3 field.
	CRYP_K3RR_B3      = 0x8        // Bit B3.
	CRYP_K3RR_B4_Pos  = 0x4        // Position of B4 field.
	CRYP_K3RR_B4_Msk  = 0x10       // Bit mask of B4 field.
	CRYP_K3RR_B4      = 0x10       // Bit B4.
	CRYP_K3RR_B5_Pos  = 0x5        // Position of B5 field.
	CRYP_K3RR_B5_Msk  = 0x20       // Bit mask of B5 field.
	CRYP_K3RR_B5      = 0x20       // Bit B5.
	CRYP_K3RR_B6_Pos  = 0x6        // Position of B6 field.
	CRYP_K3RR_B6_Msk  = 0x40       // Bit mask of B6 field.
	CRYP_K3RR_B6      = 0x40       // Bit B6.
	CRYP_K3RR_B7_Pos  = 0x7        // Position of B7 field.
	CRYP_K3RR_B7_Msk  = 0x80       // Bit mask of B7 field.
	CRYP_K3RR_B7      = 0x80       // Bit B7.
	CRYP_K3RR_B8_Pos  = 0x8        // Position of B8 field.
	CRYP_K3RR_B8_Msk  = 0x100      // Bit mask of B8 field.
	CRYP_K3RR_B8      = 0x100      // Bit B8.
	CRYP_K3RR_B9_Pos  = 0x9        // Position of B9 field.
	CRYP_K3RR_B9_Msk  = 0x200      // Bit mask of B9 field.
	CRYP_K3RR_B9      = 0x200      // Bit B9.
	CRYP_K3RR_B10_Pos = 0xa        // Position of B10 field.
	CRYP_K3RR_B10_Msk = 0x400      // Bit mask of B10 field.
	CRYP_K3RR_B10     = 0x400      // Bit B10.
	CRYP_K3RR_B11_Pos = 0xb        // Position of B11 field.
	CRYP_K3RR_B11_Msk = 0x800      // Bit mask of B11 field.
	CRYP_K3RR_B11     = 0x800      // Bit B11.
	CRYP_K3RR_B12_Pos = 0xc        // Position of B12 field.
	CRYP_K3RR_B12_Msk = 0x1000     // Bit mask of B12 field.
	CRYP_K3RR_B12     = 0x1000     // Bit B12.
	CRYP_K3RR_B13_Pos = 0xd        // Position of B13 field.
	CRYP_K3RR_B13_Msk = 0x2000     // Bit mask of B13 field.
	CRYP_K3RR_B13     = 0x2000     // Bit B13.
	CRYP_K3RR_B14_Pos = 0xe        // Position of B14 field.
	CRYP_K3RR_B14_Msk = 0x4000     // Bit mask of B14 field.
	CRYP_K3RR_B14     = 0x4000     // Bit B14.
	CRYP_K3RR_B15_Pos = 0xf        // Position of B15 field.
	CRYP_K3RR_B15_Msk = 0x8000     // Bit mask of B15 field.
	CRYP_K3RR_B15     = 0x8000     // Bit B15.
	CRYP_K3RR_B16_Pos = 0x10       // Position of B16 field.
	CRYP_K3RR_B16_Msk = 0x10000    // Bit mask of B16 field.
	CRYP_K3RR_B16     = 0x10000    // Bit B16.
	CRYP_K3RR_B17_Pos = 0x11       // Position of B17 field.
	CRYP_K3RR_B17_Msk = 0x20000    // Bit mask of B17 field.
	CRYP_K3RR_B17     = 0x20000    // Bit B17.
	CRYP_K3RR_B18_Pos = 0x12       // Position of B18 field.
	CRYP_K3RR_B18_Msk = 0x40000    // Bit mask of B18 field.
	CRYP_K3RR_B18     = 0x40000    // Bit B18.
	CRYP_K3RR_B19_Pos = 0x13       // Position of B19 field.
	CRYP_K3RR_B19_Msk = 0x80000    // Bit mask of B19 field.
	CRYP_K3RR_B19     = 0x80000    // Bit B19.
	CRYP_K3RR_B20_Pos = 0x14       // Position of B20 field.
	CRYP_K3RR_B20_Msk = 0x100000   // Bit mask of B20 field.
	CRYP_K3RR_B20     = 0x100000   // Bit B20.
	CRYP_K3RR_B21_Pos = 0x15       // Position of B21 field.
	CRYP_K3RR_B21_Msk = 0x200000   // Bit mask of B21 field.
	CRYP_K3RR_B21     = 0x200000   // Bit B21.
	CRYP_K3RR_B22_Pos = 0x16       // Position of B22 field.
	CRYP_K3RR_B22_Msk = 0x400000   // Bit mask of B22 field.
	CRYP_K3RR_B22     = 0x400000   // Bit B22.
	CRYP_K3RR_B23_Pos = 0x17       // Position of B23 field.
	CRYP_K3RR_B23_Msk = 0x800000   // Bit mask of B23 field.
	CRYP_K3RR_B23     = 0x800000   // Bit B23.
	CRYP_K3RR_B24_Pos = 0x18       // Position of B24 field.
	CRYP_K3RR_B24_Msk = 0x1000000  // Bit mask of B24 field.
	CRYP_K3RR_B24     = 0x1000000  // Bit B24.
	CRYP_K3RR_B25_Pos = 0x19       // Position of B25 field.
	CRYP_K3RR_B25_Msk = 0x2000000  // Bit mask of B25 field.
	CRYP_K3RR_B25     = 0x2000000  // Bit B25.
	CRYP_K3RR_B26_Pos = 0x1a       // Position of B26 field.
	CRYP_K3RR_B26_Msk = 0x4000000  // Bit mask of B26 field.
	CRYP_K3RR_B26     = 0x4000000  // Bit B26.
	CRYP_K3RR_B27_Pos = 0x1b       // Position of B27 field.
	CRYP_K3RR_B27_Msk = 0x8000000  // Bit mask of B27 field.
	CRYP_K3RR_B27     = 0x8000000  // Bit B27.
	CRYP_K3RR_B28_Pos = 0x1c       // Position of B28 field.
	CRYP_K3RR_B28_Msk = 0x10000000 // Bit mask of B28 field.
	CRYP_K3RR_B28     = 0x10000000 // Bit B28.
	CRYP_K3RR_B29_Pos = 0x1d       // Position of B29 field.
	CRYP_K3RR_B29_Msk = 0x20000000 // Bit mask of B29 field.
	CRYP_K3RR_B29     = 0x20000000 // Bit B29.
	CRYP_K3RR_B30_Pos = 0x1e       // Position of B30 field.
	CRYP_K3RR_B30_Msk = 0x40000000 // Bit mask of B30 field.
	CRYP_K3RR_B30     = 0x40000000 // Bit B30.
	CRYP_K3RR_B31_Pos = 0x1f       // Position of B31 field.
	CRYP_K3RR_B31_Msk = 0x80000000 // Bit mask of B31 field.
	CRYP_K3RR_B31     = 0x80000000 // Bit B31.

	// IV0LR: initialization vector           registers
	CRYP_IV0LR_IV31_Pos = 0x0        // Position of IV31 field.
	CRYP_IV0LR_IV31_Msk = 0x1        // Bit mask of IV31 field.
	CRYP_IV0LR_IV31     = 0x1        // Bit IV31.
	CRYP_IV0LR_IV30_Pos = 0x1        // Position of IV30 field.
	CRYP_IV0LR_IV30_Msk = 0x2        // Bit mask of IV30 field.
	CRYP_IV0LR_IV30     = 0x2        // Bit IV30.
	CRYP_IV0LR_IV29_Pos = 0x2        // Position of IV29 field.
	CRYP_IV0LR_IV29_Msk = 0x4        // Bit mask of IV29 field.
	CRYP_IV0LR_IV29     = 0x4        // Bit IV29.
	CRYP_IV0LR_IV28_Pos = 0x3        // Position of IV28 field.
	CRYP_IV0LR_IV28_Msk = 0x8        // Bit mask of IV28 field.
	CRYP_IV0LR_IV28     = 0x8        // Bit IV28.
	CRYP_IV0LR_IV27_Pos = 0x4        // Position of IV27 field.
	CRYP_IV0LR_IV27_Msk = 0x10       // Bit mask of IV27 field.
	CRYP_IV0LR_IV27     = 0x10       // Bit IV27.
	CRYP_IV0LR_IV26_Pos = 0x5        // Position of IV26 field.
	CRYP_IV0LR_IV26_Msk = 0x20       // Bit mask of IV26 field.
	CRYP_IV0LR_IV26     = 0x20       // Bit IV26.
	CRYP_IV0LR_IV25_Pos = 0x6        // Position of IV25 field.
	CRYP_IV0LR_IV25_Msk = 0x40       // Bit mask of IV25 field.
	CRYP_IV0LR_IV25     = 0x40       // Bit IV25.
	CRYP_IV0LR_IV24_Pos = 0x7        // Position of IV24 field.
	CRYP_IV0LR_IV24_Msk = 0x80       // Bit mask of IV24 field.
	CRYP_IV0LR_IV24     = 0x80       // Bit IV24.
	CRYP_IV0LR_IV23_Pos = 0x8        // Position of IV23 field.
	CRYP_IV0LR_IV23_Msk = 0x100      // Bit mask of IV23 field.
	CRYP_IV0LR_IV23     = 0x100      // Bit IV23.
	CRYP_IV0LR_IV22_Pos = 0x9        // Position of IV22 field.
	CRYP_IV0LR_IV22_Msk = 0x200      // Bit mask of IV22 field.
	CRYP_IV0LR_IV22     = 0x200      // Bit IV22.
	CRYP_IV0LR_IV21_Pos = 0xa        // Position of IV21 field.
	CRYP_IV0LR_IV21_Msk = 0x400      // Bit mask of IV21 field.
	CRYP_IV0LR_IV21     = 0x400      // Bit IV21.
	CRYP_IV0LR_IV20_Pos = 0xb        // Position of IV20 field.
	CRYP_IV0LR_IV20_Msk = 0x800      // Bit mask of IV20 field.
	CRYP_IV0LR_IV20     = 0x800      // Bit IV20.
	CRYP_IV0LR_IV19_Pos = 0xc        // Position of IV19 field.
	CRYP_IV0LR_IV19_Msk = 0x1000     // Bit mask of IV19 field.
	CRYP_IV0LR_IV19     = 0x1000     // Bit IV19.
	CRYP_IV0LR_IV18_Pos = 0xd        // Position of IV18 field.
	CRYP_IV0LR_IV18_Msk = 0x2000     // Bit mask of IV18 field.
	CRYP_IV0LR_IV18     = 0x2000     // Bit IV18.
	CRYP_IV0LR_IV17_Pos = 0xe        // Position of IV17 field.
	CRYP_IV0LR_IV17_Msk = 0x4000     // Bit mask of IV17 field.
	CRYP_IV0LR_IV17     = 0x4000     // Bit IV17.
	CRYP_IV0LR_IV16_Pos = 0xf        // Position of IV16 field.
	CRYP_IV0LR_IV16_Msk = 0x8000     // Bit mask of IV16 field.
	CRYP_IV0LR_IV16     = 0x8000     // Bit IV16.
	CRYP_IV0LR_IV15_Pos = 0x10       // Position of IV15 field.
	CRYP_IV0LR_IV15_Msk = 0x10000    // Bit mask of IV15 field.
	CRYP_IV0LR_IV15     = 0x10000    // Bit IV15.
	CRYP_IV0LR_IV14_Pos = 0x11       // Position of IV14 field.
	CRYP_IV0LR_IV14_Msk = 0x20000    // Bit mask of IV14 field.
	CRYP_IV0LR_IV14     = 0x20000    // Bit IV14.
	CRYP_IV0LR_IV13_Pos = 0x12       // Position of IV13 field.
	CRYP_IV0LR_IV13_Msk = 0x40000    // Bit mask of IV13 field.
	CRYP_IV0LR_IV13     = 0x40000    // Bit IV13.
	CRYP_IV0LR_IV12_Pos = 0x13       // Position of IV12 field.
	CRYP_IV0LR_IV12_Msk = 0x80000    // Bit mask of IV12 field.
	CRYP_IV0LR_IV12     = 0x80000    // Bit IV12.
	CRYP_IV0LR_IV11_Pos = 0x14       // Position of IV11 field.
	CRYP_IV0LR_IV11_Msk = 0x100000   // Bit mask of IV11 field.
	CRYP_IV0LR_IV11     = 0x100000   // Bit IV11.
	CRYP_IV0LR_IV10_Pos = 0x15       // Position of IV10 field.
	CRYP_IV0LR_IV10_Msk = 0x200000   // Bit mask of IV10 field.
	CRYP_IV0LR_IV10     = 0x200000   // Bit IV10.
	CRYP_IV0LR_IV9_Pos  = 0x16       // Position of IV9 field.
	CRYP_IV0LR_IV9_Msk  = 0x400000   // Bit mask of IV9 field.
	CRYP_IV0LR_IV9      = 0x400000   // Bit IV9.
	CRYP_IV0LR_IV8_Pos  = 0x17       // Position of IV8 field.
	CRYP_IV0LR_IV8_Msk  = 0x800000   // Bit mask of IV8 field.
	CRYP_IV0LR_IV8      = 0x800000   // Bit IV8.
	CRYP_IV0LR_IV7_Pos  = 0x18       // Position of IV7 field.
	CRYP_IV0LR_IV7_Msk  = 0x1000000  // Bit mask of IV7 field.
	CRYP_IV0LR_IV7      = 0x1000000  // Bit IV7.
	CRYP_IV0LR_IV6_Pos  = 0x19       // Position of IV6 field.
	CRYP_IV0LR_IV6_Msk  = 0x2000000  // Bit mask of IV6 field.
	CRYP_IV0LR_IV6      = 0x2000000  // Bit IV6.
	CRYP_IV0LR_IV5_Pos  = 0x1a       // Position of IV5 field.
	CRYP_IV0LR_IV5_Msk  = 0x4000000  // Bit mask of IV5 field.
	CRYP_IV0LR_IV5      = 0x4000000  // Bit IV5.
	CRYP_IV0LR_IV4_Pos  = 0x1b       // Position of IV4 field.
	CRYP_IV0LR_IV4_Msk  = 0x8000000  // Bit mask of IV4 field.
	CRYP_IV0LR_IV4      = 0x8000000  // Bit IV4.
	CRYP_IV0LR_IV3_Pos  = 0x1c       // Position of IV3 field.
	CRYP_IV0LR_IV3_Msk  = 0x10000000 // Bit mask of IV3 field.
	CRYP_IV0LR_IV3      = 0x10000000 // Bit IV3.
	CRYP_IV0LR_IV2_Pos  = 0x1d       // Position of IV2 field.
	CRYP_IV0LR_IV2_Msk  = 0x20000000 // Bit mask of IV2 field.
	CRYP_IV0LR_IV2      = 0x20000000 // Bit IV2.
	CRYP_IV0LR_IV1_Pos  = 0x1e       // Position of IV1 field.
	CRYP_IV0LR_IV1_Msk  = 0x40000000 // Bit mask of IV1 field.
	CRYP_IV0LR_IV1      = 0x40000000 // Bit IV1.
	CRYP_IV0LR_IV0_Pos  = 0x1f       // Position of IV0 field.
	CRYP_IV0LR_IV0_Msk  = 0x80000000 // Bit mask of IV0 field.
	CRYP_IV0LR_IV0      = 0x80000000 // Bit IV0.

	// IV0RR: initialization vector           registers
	CRYP_IV0RR_IV63_Pos = 0x0        // Position of IV63 field.
	CRYP_IV0RR_IV63_Msk = 0x1        // Bit mask of IV63 field.
	CRYP_IV0RR_IV63     = 0x1        // Bit IV63.
	CRYP_IV0RR_IV62_Pos = 0x1        // Position of IV62 field.
	CRYP_IV0RR_IV62_Msk = 0x2        // Bit mask of IV62 field.
	CRYP_IV0RR_IV62     = 0x2        // Bit IV62.
	CRYP_IV0RR_IV61_Pos = 0x2        // Position of IV61 field.
	CRYP_IV0RR_IV61_Msk = 0x4        // Bit mask of IV61 field.
	CRYP_IV0RR_IV61     = 0x4        // Bit IV61.
	CRYP_IV0RR_IV60_Pos = 0x3        // Position of IV60 field.
	CRYP_IV0RR_IV60_Msk = 0x8        // Bit mask of IV60 field.
	CRYP_IV0RR_IV60     = 0x8        // Bit IV60.
	CRYP_IV0RR_IV59_Pos = 0x4        // Position of IV59 field.
	CRYP_IV0RR_IV59_Msk = 0x10       // Bit mask of IV59 field.
	CRYP_IV0RR_IV59     = 0x10       // Bit IV59.
	CRYP_IV0RR_IV58_Pos = 0x5        // Position of IV58 field.
	CRYP_IV0RR_IV58_Msk = 0x20       // Bit mask of IV58 field.
	CRYP_IV0RR_IV58     = 0x20       // Bit IV58.
	CRYP_IV0RR_IV57_Pos = 0x6        // Position of IV57 field.
	CRYP_IV0RR_IV57_Msk = 0x40       // Bit mask of IV57 field.
	CRYP_IV0RR_IV57     = 0x40       // Bit IV57.
	CRYP_IV0RR_IV56_Pos = 0x7        // Position of IV56 field.
	CRYP_IV0RR_IV56_Msk = 0x80       // Bit mask of IV56 field.
	CRYP_IV0RR_IV56     = 0x80       // Bit IV56.
	CRYP_IV0RR_IV55_Pos = 0x8        // Position of IV55 field.
	CRYP_IV0RR_IV55_Msk = 0x100      // Bit mask of IV55 field.
	CRYP_IV0RR_IV55     = 0x100      // Bit IV55.
	CRYP_IV0RR_IV54_Pos = 0x9        // Position of IV54 field.
	CRYP_IV0RR_IV54_Msk = 0x200      // Bit mask of IV54 field.
	CRYP_IV0RR_IV54     = 0x200      // Bit IV54.
	CRYP_IV0RR_IV53_Pos = 0xa        // Position of IV53 field.
	CRYP_IV0RR_IV53_Msk = 0x400      // Bit mask of IV53 field.
	CRYP_IV0RR_IV53     = 0x400      // Bit IV53.
	CRYP_IV0RR_IV52_Pos = 0xb        // Position of IV52 field.
	CRYP_IV0RR_IV52_Msk = 0x800      // Bit mask of IV52 field.
	CRYP_IV0RR_IV52     = 0x800      // Bit IV52.
	CRYP_IV0RR_IV51_Pos = 0xc        // Position of IV51 field.
	CRYP_IV0RR_IV51_Msk = 0x1000     // Bit mask of IV51 field.
	CRYP_IV0RR_IV51     = 0x1000     // Bit IV51.
	CRYP_IV0RR_IV50_Pos = 0xd        // Position of IV50 field.
	CRYP_IV0RR_IV50_Msk = 0x2000     // Bit mask of IV50 field.
	CRYP_IV0RR_IV50     = 0x2000     // Bit IV50.
	CRYP_IV0RR_IV49_Pos = 0xe        // Position of IV49 field.
	CRYP_IV0RR_IV49_Msk = 0x4000     // Bit mask of IV49 field.
	CRYP_IV0RR_IV49     = 0x4000     // Bit IV49.
	CRYP_IV0RR_IV48_Pos = 0xf        // Position of IV48 field.
	CRYP_IV0RR_IV48_Msk = 0x8000     // Bit mask of IV48 field.
	CRYP_IV0RR_IV48     = 0x8000     // Bit IV48.
	CRYP_IV0RR_IV47_Pos = 0x10       // Position of IV47 field.
	CRYP_IV0RR_IV47_Msk = 0x10000    // Bit mask of IV47 field.
	CRYP_IV0RR_IV47     = 0x10000    // Bit IV47.
	CRYP_IV0RR_IV46_Pos = 0x11       // Position of IV46 field.
	CRYP_IV0RR_IV46_Msk = 0x20000    // Bit mask of IV46 field.
	CRYP_IV0RR_IV46     = 0x20000    // Bit IV46.
	CRYP_IV0RR_IV45_Pos = 0x12       // Position of IV45 field.
	CRYP_IV0RR_IV45_Msk = 0x40000    // Bit mask of IV45 field.
	CRYP_IV0RR_IV45     = 0x40000    // Bit IV45.
	CRYP_IV0RR_IV44_Pos = 0x13       // Position of IV44 field.
	CRYP_IV0RR_IV44_Msk = 0x80000    // Bit mask of IV44 field.
	CRYP_IV0RR_IV44     = 0x80000    // Bit IV44.
	CRYP_IV0RR_IV43_Pos = 0x14       // Position of IV43 field.
	CRYP_IV0RR_IV43_Msk = 0x100000   // Bit mask of IV43 field.
	CRYP_IV0RR_IV43     = 0x100000   // Bit IV43.
	CRYP_IV0RR_IV42_Pos = 0x15       // Position of IV42 field.
	CRYP_IV0RR_IV42_Msk = 0x200000   // Bit mask of IV42 field.
	CRYP_IV0RR_IV42     = 0x200000   // Bit IV42.
	CRYP_IV0RR_IV41_Pos = 0x16       // Position of IV41 field.
	CRYP_IV0RR_IV41_Msk = 0x400000   // Bit mask of IV41 field.
	CRYP_IV0RR_IV41     = 0x400000   // Bit IV41.
	CRYP_IV0RR_IV40_Pos = 0x17       // Position of IV40 field.
	CRYP_IV0RR_IV40_Msk = 0x800000   // Bit mask of IV40 field.
	CRYP_IV0RR_IV40     = 0x800000   // Bit IV40.
	CRYP_IV0RR_IV39_Pos = 0x18       // Position of IV39 field.
	CRYP_IV0RR_IV39_Msk = 0x1000000  // Bit mask of IV39 field.
	CRYP_IV0RR_IV39     = 0x1000000  // Bit IV39.
	CRYP_IV0RR_IV38_Pos = 0x19       // Position of IV38 field.
	CRYP_IV0RR_IV38_Msk = 0x2000000  // Bit mask of IV38 field.
	CRYP_IV0RR_IV38     = 0x2000000  // Bit IV38.
	CRYP_IV0RR_IV37_Pos = 0x1a       // Position of IV37 field.
	CRYP_IV0RR_IV37_Msk = 0x4000000  // Bit mask of IV37 field.
	CRYP_IV0RR_IV37     = 0x4000000  // Bit IV37.
	CRYP_IV0RR_IV36_Pos = 0x1b       // Position of IV36 field.
	CRYP_IV0RR_IV36_Msk = 0x8000000  // Bit mask of IV36 field.
	CRYP_IV0RR_IV36     = 0x8000000  // Bit IV36.
	CRYP_IV0RR_IV35_Pos = 0x1c       // Position of IV35 field.
	CRYP_IV0RR_IV35_Msk = 0x10000000 // Bit mask of IV35 field.
	CRYP_IV0RR_IV35     = 0x10000000 // Bit IV35.
	CRYP_IV0RR_IV34_Pos = 0x1d       // Position of IV34 field.
	CRYP_IV0RR_IV34_Msk = 0x20000000 // Bit mask of IV34 field.
	CRYP_IV0RR_IV34     = 0x20000000 // Bit IV34.
	CRYP_IV0RR_IV33_Pos = 0x1e       // Position of IV33 field.
	CRYP_IV0RR_IV33_Msk = 0x40000000 // Bit mask of IV33 field.
	CRYP_IV0RR_IV33     = 0x40000000 // Bit IV33.
	CRYP_IV0RR_IV32_Pos = 0x1f       // Position of IV32 field.
	CRYP_IV0RR_IV32_Msk = 0x80000000 // Bit mask of IV32 field.
	CRYP_IV0RR_IV32     = 0x80000000 // Bit IV32.

	// IV1LR: initialization vector           registers
	CRYP_IV1LR_IV95_Pos = 0x0        // Position of IV95 field.
	CRYP_IV1LR_IV95_Msk = 0x1        // Bit mask of IV95 field.
	CRYP_IV1LR_IV95     = 0x1        // Bit IV95.
	CRYP_IV1LR_IV94_Pos = 0x1        // Position of IV94 field.
	CRYP_IV1LR_IV94_Msk = 0x2        // Bit mask of IV94 field.
	CRYP_IV1LR_IV94     = 0x2        // Bit IV94.
	CRYP_IV1LR_IV93_Pos = 0x2        // Position of IV93 field.
	CRYP_IV1LR_IV93_Msk = 0x4        // Bit mask of IV93 field.
	CRYP_IV1LR_IV93     = 0x4        // Bit IV93.
	CRYP_IV1LR_IV92_Pos = 0x3        // Position of IV92 field.
	CRYP_IV1LR_IV92_Msk = 0x8        // Bit mask of IV92 field.
	CRYP_IV1LR_IV92     = 0x8        // Bit IV92.
	CRYP_IV1LR_IV91_Pos = 0x4        // Position of IV91 field.
	CRYP_IV1LR_IV91_Msk = 0x10       // Bit mask of IV91 field.
	CRYP_IV1LR_IV91     = 0x10       // Bit IV91.
	CRYP_IV1LR_IV90_Pos = 0x5        // Position of IV90 field.
	CRYP_IV1LR_IV90_Msk = 0x20       // Bit mask of IV90 field.
	CRYP_IV1LR_IV90     = 0x20       // Bit IV90.
	CRYP_IV1LR_IV89_Pos = 0x6        // Position of IV89 field.
	CRYP_IV1LR_IV89_Msk = 0x40       // Bit mask of IV89 field.
	CRYP_IV1LR_IV89     = 0x40       // Bit IV89.
	CRYP_IV1LR_IV88_Pos = 0x7        // Position of IV88 field.
	CRYP_IV1LR_IV88_Msk = 0x80       // Bit mask of IV88 field.
	CRYP_IV1LR_IV88     = 0x80       // Bit IV88.
	CRYP_IV1LR_IV87_Pos = 0x8        // Position of IV87 field.
	CRYP_IV1LR_IV87_Msk = 0x100      // Bit mask of IV87 field.
	CRYP_IV1LR_IV87     = 0x100      // Bit IV87.
	CRYP_IV1LR_IV86_Pos = 0x9        // Position of IV86 field.
	CRYP_IV1LR_IV86_Msk = 0x200      // Bit mask of IV86 field.
	CRYP_IV1LR_IV86     = 0x200      // Bit IV86.
	CRYP_IV1LR_IV85_Pos = 0xa        // Position of IV85 field.
	CRYP_IV1LR_IV85_Msk = 0x400      // Bit mask of IV85 field.
	CRYP_IV1LR_IV85     = 0x400      // Bit IV85.
	CRYP_IV1LR_IV84_Pos = 0xb        // Position of IV84 field.
	CRYP_IV1LR_IV84_Msk = 0x800      // Bit mask of IV84 field.
	CRYP_IV1LR_IV84     = 0x800      // Bit IV84.
	CRYP_IV1LR_IV83_Pos = 0xc        // Position of IV83 field.
	CRYP_IV1LR_IV83_Msk = 0x1000     // Bit mask of IV83 field.
	CRYP_IV1LR_IV83     = 0x1000     // Bit IV83.
	CRYP_IV1LR_IV82_Pos = 0xd        // Position of IV82 field.
	CRYP_IV1LR_IV82_Msk = 0x2000     // Bit mask of IV82 field.
	CRYP_IV1LR_IV82     = 0x2000     // Bit IV82.
	CRYP_IV1LR_IV81_Pos = 0xe        // Position of IV81 field.
	CRYP_IV1LR_IV81_Msk = 0x4000     // Bit mask of IV81 field.
	CRYP_IV1LR_IV81     = 0x4000     // Bit IV81.
	CRYP_IV1LR_IV80_Pos = 0xf        // Position of IV80 field.
	CRYP_IV1LR_IV80_Msk = 0x8000     // Bit mask of IV80 field.
	CRYP_IV1LR_IV80     = 0x8000     // Bit IV80.
	CRYP_IV1LR_IV79_Pos = 0x10       // Position of IV79 field.
	CRYP_IV1LR_IV79_Msk = 0x10000    // Bit mask of IV79 field.
	CRYP_IV1LR_IV79     = 0x10000    // Bit IV79.
	CRYP_IV1LR_IV78_Pos = 0x11       // Position of IV78 field.
	CRYP_IV1LR_IV78_Msk = 0x20000    // Bit mask of IV78 field.
	CRYP_IV1LR_IV78     = 0x20000    // Bit IV78.
	CRYP_IV1LR_IV77_Pos = 0x12       // Position of IV77 field.
	CRYP_IV1LR_IV77_Msk = 0x40000    // Bit mask of IV77 field.
	CRYP_IV1LR_IV77     = 0x40000    // Bit IV77.
	CRYP_IV1LR_IV76_Pos = 0x13       // Position of IV76 field.
	CRYP_IV1LR_IV76_Msk = 0x80000    // Bit mask of IV76 field.
	CRYP_IV1LR_IV76     = 0x80000    // Bit IV76.
	CRYP_IV1LR_IV75_Pos = 0x14       // Position of IV75 field.
	CRYP_IV1LR_IV75_Msk = 0x100000   // Bit mask of IV75 field.
	CRYP_IV1LR_IV75     = 0x100000   // Bit IV75.
	CRYP_IV1LR_IV74_Pos = 0x15       // Position of IV74 field.
	CRYP_IV1LR_IV74_Msk = 0x200000   // Bit mask of IV74 field.
	CRYP_IV1LR_IV74     = 0x200000   // Bit IV74.
	CRYP_IV1LR_IV73_Pos = 0x16       // Position of IV73 field.
	CRYP_IV1LR_IV73_Msk = 0x400000   // Bit mask of IV73 field.
	CRYP_IV1LR_IV73     = 0x400000   // Bit IV73.
	CRYP_IV1LR_IV72_Pos = 0x17       // Position of IV72 field.
	CRYP_IV1LR_IV72_Msk = 0x800000   // Bit mask of IV72 field.
	CRYP_IV1LR_IV72     = 0x800000   // Bit IV72.
	CRYP_IV1LR_IV71_Pos = 0x18       // Position of IV71 field.
	CRYP_IV1LR_IV71_Msk = 0x1000000  // Bit mask of IV71 field.
	CRYP_IV1LR_IV71     = 0x1000000  // Bit IV71.
	CRYP_IV1LR_IV70_Pos = 0x19       // Position of IV70 field.
	CRYP_IV1LR_IV70_Msk = 0x2000000  // Bit mask of IV70 field.
	CRYP_IV1LR_IV70     = 0x2000000  // Bit IV70.
	CRYP_IV1LR_IV69_Pos = 0x1a       // Position of IV69 field.
	CRYP_IV1LR_IV69_Msk = 0x4000000  // Bit mask of IV69 field.
	CRYP_IV1LR_IV69     = 0x4000000  // Bit IV69.
	CRYP_IV1LR_IV68_Pos = 0x1b       // Position of IV68 field.
	CRYP_IV1LR_IV68_Msk = 0x8000000  // Bit mask of IV68 field.
	CRYP_IV1LR_IV68     = 0x8000000  // Bit IV68.
	CRYP_IV1LR_IV67_Pos = 0x1c       // Position of IV67 field.
	CRYP_IV1LR_IV67_Msk = 0x10000000 // Bit mask of IV67 field.
	CRYP_IV1LR_IV67     = 0x10000000 // Bit IV67.
	CRYP_IV1LR_IV66_Pos = 0x1d       // Position of IV66 field.
	CRYP_IV1LR_IV66_Msk = 0x20000000 // Bit mask of IV66 field.
	CRYP_IV1LR_IV66     = 0x20000000 // Bit IV66.
	CRYP_IV1LR_IV65_Pos = 0x1e       // Position of IV65 field.
	CRYP_IV1LR_IV65_Msk = 0x40000000 // Bit mask of IV65 field.
	CRYP_IV1LR_IV65     = 0x40000000 // Bit IV65.
	CRYP_IV1LR_IV64_Pos = 0x1f       // Position of IV64 field.
	CRYP_IV1LR_IV64_Msk = 0x80000000 // Bit mask of IV64 field.
	CRYP_IV1LR_IV64     = 0x80000000 // Bit IV64.

	// IV1RR: initialization vector           registers
	CRYP_IV1RR_IV127_Pos = 0x0        // Position of IV127 field.
	CRYP_IV1RR_IV127_Msk = 0x1        // Bit mask of IV127 field.
	CRYP_IV1RR_IV127     = 0x1        // Bit IV127.
	CRYP_IV1RR_IV126_Pos = 0x1        // Position of IV126 field.
	CRYP_IV1RR_IV126_Msk = 0x2        // Bit mask of IV126 field.
	CRYP_IV1RR_IV126     = 0x2        // Bit IV126.
	CRYP_IV1RR_IV125_Pos = 0x2        // Position of IV125 field.
	CRYP_IV1RR_IV125_Msk = 0x4        // Bit mask of IV125 field.
	CRYP_IV1RR_IV125     = 0x4        // Bit IV125.
	CRYP_IV1RR_IV124_Pos = 0x3        // Position of IV124 field.
	CRYP_IV1RR_IV124_Msk = 0x8        // Bit mask of IV124 field.
	CRYP_IV1RR_IV124     = 0x8        // Bit IV124.
	CRYP_IV1RR_IV123_Pos = 0x4        // Position of IV123 field.
	CRYP_IV1RR_IV123_Msk = 0x10       // Bit mask of IV123 field.
	CRYP_IV1RR_IV123     = 0x10       // Bit IV123.
	CRYP_IV1RR_IV122_Pos = 0x5        // Position of IV122 field.
	CRYP_IV1RR_IV122_Msk = 0x20       // Bit mask of IV122 field.
	CRYP_IV1RR_IV122     = 0x20       // Bit IV122.
	CRYP_IV1RR_IV121_Pos = 0x6        // Position of IV121 field.
	CRYP_IV1RR_IV121_Msk = 0x40       // Bit mask of IV121 field.
	CRYP_IV1RR_IV121     = 0x40       // Bit IV121.
	CRYP_IV1RR_IV120_Pos = 0x7        // Position of IV120 field.
	CRYP_IV1RR_IV120_Msk = 0x80       // Bit mask of IV120 field.
	CRYP_IV1RR_IV120     = 0x80       // Bit IV120.
	CRYP_IV1RR_IV119_Pos = 0x8        // Position of IV119 field.
	CRYP_IV1RR_IV119_Msk = 0x100      // Bit mask of IV119 field.
	CRYP_IV1RR_IV119     = 0x100      // Bit IV119.
	CRYP_IV1RR_IV118_Pos = 0x9        // Position of IV118 field.
	CRYP_IV1RR_IV118_Msk = 0x200      // Bit mask of IV118 field.
	CRYP_IV1RR_IV118     = 0x200      // Bit IV118.
	CRYP_IV1RR_IV117_Pos = 0xa        // Position of IV117 field.
	CRYP_IV1RR_IV117_Msk = 0x400      // Bit mask of IV117 field.
	CRYP_IV1RR_IV117     = 0x400      // Bit IV117.
	CRYP_IV1RR_IV116_Pos = 0xb        // Position of IV116 field.
	CRYP_IV1RR_IV116_Msk = 0x800      // Bit mask of IV116 field.
	CRYP_IV1RR_IV116     = 0x800      // Bit IV116.
	CRYP_IV1RR_IV115_Pos = 0xc        // Position of IV115 field.
	CRYP_IV1RR_IV115_Msk = 0x1000     // Bit mask of IV115 field.
	CRYP_IV1RR_IV115     = 0x1000     // Bit IV115.
	CRYP_IV1RR_IV114_Pos = 0xd        // Position of IV114 field.
	CRYP_IV1RR_IV114_Msk = 0x2000     // Bit mask of IV114 field.
	CRYP_IV1RR_IV114     = 0x2000     // Bit IV114.
	CRYP_IV1RR_IV113_Pos = 0xe        // Position of IV113 field.
	CRYP_IV1RR_IV113_Msk = 0x4000     // Bit mask of IV113 field.
	CRYP_IV1RR_IV113     = 0x4000     // Bit IV113.
	CRYP_IV1RR_IV112_Pos = 0xf        // Position of IV112 field.
	CRYP_IV1RR_IV112_Msk = 0x8000     // Bit mask of IV112 field.
	CRYP_IV1RR_IV112     = 0x8000     // Bit IV112.
	CRYP_IV1RR_IV111_Pos = 0x10       // Position of IV111 field.
	CRYP_IV1RR_IV111_Msk = 0x10000    // Bit mask of IV111 field.
	CRYP_IV1RR_IV111     = 0x10000    // Bit IV111.
	CRYP_IV1RR_IV110_Pos = 0x11       // Position of IV110 field.
	CRYP_IV1RR_IV110_Msk = 0x20000    // Bit mask of IV110 field.
	CRYP_IV1RR_IV110     = 0x20000    // Bit IV110.
	CRYP_IV1RR_IV109_Pos = 0x12       // Position of IV109 field.
	CRYP_IV1RR_IV109_Msk = 0x40000    // Bit mask of IV109 field.
	CRYP_IV1RR_IV109     = 0x40000    // Bit IV109.
	CRYP_IV1RR_IV108_Pos = 0x13       // Position of IV108 field.
	CRYP_IV1RR_IV108_Msk = 0x80000    // Bit mask of IV108 field.
	CRYP_IV1RR_IV108     = 0x80000    // Bit IV108.
	CRYP_IV1RR_IV107_Pos = 0x14       // Position of IV107 field.
	CRYP_IV1RR_IV107_Msk = 0x100000   // Bit mask of IV107 field.
	CRYP_IV1RR_IV107     = 0x100000   // Bit IV107.
	CRYP_IV1RR_IV106_Pos = 0x15       // Position of IV106 field.
	CRYP_IV1RR_IV106_Msk = 0x200000   // Bit mask of IV106 field.
	CRYP_IV1RR_IV106     = 0x200000   // Bit IV106.
	CRYP_IV1RR_IV105_Pos = 0x16       // Position of IV105 field.
	CRYP_IV1RR_IV105_Msk = 0x400000   // Bit mask of IV105 field.
	CRYP_IV1RR_IV105     = 0x400000   // Bit IV105.
	CRYP_IV1RR_IV104_Pos = 0x17       // Position of IV104 field.
	CRYP_IV1RR_IV104_Msk = 0x800000   // Bit mask of IV104 field.
	CRYP_IV1RR_IV104     = 0x800000   // Bit IV104.
	CRYP_IV1RR_IV103_Pos = 0x18       // Position of IV103 field.
	CRYP_IV1RR_IV103_Msk = 0x1000000  // Bit mask of IV103 field.
	CRYP_IV1RR_IV103     = 0x1000000  // Bit IV103.
	CRYP_IV1RR_IV102_Pos = 0x19       // Position of IV102 field.
	CRYP_IV1RR_IV102_Msk = 0x2000000  // Bit mask of IV102 field.
	CRYP_IV1RR_IV102     = 0x2000000  // Bit IV102.
	CRYP_IV1RR_IV101_Pos = 0x1a       // Position of IV101 field.
	CRYP_IV1RR_IV101_Msk = 0x4000000  // Bit mask of IV101 field.
	CRYP_IV1RR_IV101     = 0x4000000  // Bit IV101.
	CRYP_IV1RR_IV100_Pos = 0x1b       // Position of IV100 field.
	CRYP_IV1RR_IV100_Msk = 0x8000000  // Bit mask of IV100 field.
	CRYP_IV1RR_IV100     = 0x8000000  // Bit IV100.
	CRYP_IV1RR_IV99_Pos  = 0x1c       // Position of IV99 field.
	CRYP_IV1RR_IV99_Msk  = 0x10000000 // Bit mask of IV99 field.
	CRYP_IV1RR_IV99      = 0x10000000 // Bit IV99.
	CRYP_IV1RR_IV98_Pos  = 0x1d       // Position of IV98 field.
	CRYP_IV1RR_IV98_Msk  = 0x20000000 // Bit mask of IV98 field.
	CRYP_IV1RR_IV98      = 0x20000000 // Bit IV98.
	CRYP_IV1RR_IV97_Pos  = 0x1e       // Position of IV97 field.
	CRYP_IV1RR_IV97_Msk  = 0x40000000 // Bit mask of IV97 field.
	CRYP_IV1RR_IV97      = 0x40000000 // Bit IV97.
	CRYP_IV1RR_IV96_Pos  = 0x1f       // Position of IV96 field.
	CRYP_IV1RR_IV96_Msk  = 0x80000000 // Bit mask of IV96 field.
	CRYP_IV1RR_IV96      = 0x80000000 // Bit IV96.

	// CSGCMCCM0R: context swap register
	CRYP_CSGCMCCM0R_CSGCMCCM0R_Pos = 0x0        // Position of CSGCMCCM0R field.
	CRYP_CSGCMCCM0R_CSGCMCCM0R_Msk = 0xffffffff // Bit mask of CSGCMCCM0R field.

	// CSGCMCCM1R: context swap register
	CRYP_CSGCMCCM1R_CSGCMCCM1R_Pos = 0x0        // Position of CSGCMCCM1R field.
	CRYP_CSGCMCCM1R_CSGCMCCM1R_Msk = 0xffffffff // Bit mask of CSGCMCCM1R field.

	// CSGCMCCM2R: context swap register
	CRYP_CSGCMCCM2R_CSGCMCCM2R_Pos = 0x0        // Position of CSGCMCCM2R field.
	CRYP_CSGCMCCM2R_CSGCMCCM2R_Msk = 0xffffffff // Bit mask of CSGCMCCM2R field.

	// CSGCMCCM3R: context swap register
	CRYP_CSGCMCCM3R_CSGCMCCM3R_Pos = 0x0        // Position of CSGCMCCM3R field.
	CRYP_CSGCMCCM3R_CSGCMCCM3R_Msk = 0xffffffff // Bit mask of CSGCMCCM3R field.

	// CSGCMCCM4R: context swap register
	CRYP_CSGCMCCM4R_CSGCMCCM4R_Pos = 0x0        // Position of CSGCMCCM4R field.
	CRYP_CSGCMCCM4R_CSGCMCCM4R_Msk = 0xffffffff // Bit mask of CSGCMCCM4R field.

	// CSGCMCCM5R: context swap register
	CRYP_CSGCMCCM5R_CSGCMCCM5R_Pos = 0x0        // Position of CSGCMCCM5R field.
	CRYP_CSGCMCCM5R_CSGCMCCM5R_Msk = 0xffffffff // Bit mask of CSGCMCCM5R field.

	// CSGCMCCM6R: context swap register
	CRYP_CSGCMCCM6R_CSGCMCCM6R_Pos = 0x0        // Position of CSGCMCCM6R field.
	CRYP_CSGCMCCM6R_CSGCMCCM6R_Msk = 0xffffffff // Bit mask of CSGCMCCM6R field.

	// CSGCMCCM7R: context swap register
	CRYP_CSGCMCCM7R_CSGCMCCM7R_Pos = 0x0        // Position of CSGCMCCM7R field.
	CRYP_CSGCMCCM7R_CSGCMCCM7R_Msk = 0xffffffff // Bit mask of CSGCMCCM7R field.

	// CSGCM0R: context swap register
	CRYP_CSGCM0R_CSGCM0R_Pos = 0x0        // Position of CSGCM0R field.
	CRYP_CSGCM0R_CSGCM0R_Msk = 0xffffffff // Bit mask of CSGCM0R field.

	// CSGCM1R: context swap register
	CRYP_CSGCM1R_CSGCM1R_Pos = 0x0        // Position of CSGCM1R field.
	CRYP_CSGCM1R_CSGCM1R_Msk = 0xffffffff // Bit mask of CSGCM1R field.

	// CSGCM2R: context swap register
	CRYP_CSGCM2R_CSGCM2R_Pos = 0x0        // Position of CSGCM2R field.
	CRYP_CSGCM2R_CSGCM2R_Msk = 0xffffffff // Bit mask of CSGCM2R field.

	// CSGCM3R: context swap register
	CRYP_CSGCM3R_CSGCM3R_Pos = 0x0        // Position of CSGCM3R field.
	CRYP_CSGCM3R_CSGCM3R_Msk = 0xffffffff // Bit mask of CSGCM3R field.

	// CSGCM4R: context swap register
	CRYP_CSGCM4R_CSGCM4R_Pos = 0x0        // Position of CSGCM4R field.
	CRYP_CSGCM4R_CSGCM4R_Msk = 0xffffffff // Bit mask of CSGCM4R field.

	// CSGCM5R: context swap register
	CRYP_CSGCM5R_CSGCM5R_Pos = 0x0        // Position of CSGCM5R field.
	CRYP_CSGCM5R_CSGCM5R_Msk = 0xffffffff // Bit mask of CSGCM5R field.

	// CSGCM6R: context swap register
	CRYP_CSGCM6R_CSGCM6R_Pos = 0x0        // Position of CSGCM6R field.
	CRYP_CSGCM6R_CSGCM6R_Msk = 0xffffffff // Bit mask of CSGCM6R field.

	// CSGCM7R: context swap register
	CRYP_CSGCM7R_CSGCM7R_Pos = 0x0        // Position of CSGCM7R field.
	CRYP_CSGCM7R_CSGCM7R_Msk = 0xffffffff // Bit mask of CSGCM7R field.
)

// Bitfields for DCMI: Digital camera interface
const (
	// CR: control register 1
	DCMI_CR_ENABLE_Pos  = 0xe    // Position of ENABLE field.
	DCMI_CR_ENABLE_Msk  = 0x4000 // Bit mask of ENABLE field.
	DCMI_CR_ENABLE      = 0x4000 // Bit ENABLE.
	DCMI_CR_EDM_Pos     = 0xa    // Position of EDM field.
	DCMI_CR_EDM_Msk     = 0xc00  // Bit mask of EDM field.
	DCMI_CR_FCRC_Pos    = 0x8    // Position of FCRC field.
	DCMI_CR_FCRC_Msk    = 0x300  // Bit mask of FCRC field.
	DCMI_CR_VSPOL_Pos   = 0x7    // Position of VSPOL field.
	DCMI_CR_VSPOL_Msk   = 0x80   // Bit mask of VSPOL field.
	DCMI_CR_VSPOL       = 0x80   // Bit VSPOL.
	DCMI_CR_HSPOL_Pos   = 0x6    // Position of HSPOL field.
	DCMI_CR_HSPOL_Msk   = 0x40   // Bit mask of HSPOL field.
	DCMI_CR_HSPOL       = 0x40   // Bit HSPOL.
	DCMI_CR_PCKPOL_Pos  = 0x5    // Position of PCKPOL field.
	DCMI_CR_PCKPOL_Msk  = 0x20   // Bit mask of PCKPOL field.
	DCMI_CR_PCKPOL      = 0x20   // Bit PCKPOL.
	DCMI_CR_ESS_Pos     = 0x4    // Position of ESS field.
	DCMI_CR_ESS_Msk     = 0x10   // Bit mask of ESS field.
	DCMI_CR_ESS         = 0x10   // Bit ESS.
	DCMI_CR_JPEG_Pos    = 0x3    // Position of JPEG field.
	DCMI_CR_JPEG_Msk    = 0x8    // Bit mask of JPEG field.
	DCMI_CR_JPEG        = 0x8    // Bit JPEG.
	DCMI_CR_CROP_Pos    = 0x2    // Position of CROP field.
	DCMI_CR_CROP_Msk    = 0x4    // Bit mask of CROP field.
	DCMI_CR_CROP        = 0x4    // Bit CROP.
	DCMI_CR_CM_Pos      = 0x1    // Position of CM field.
	DCMI_CR_CM_Msk      = 0x2    // Bit mask of CM field.
	DCMI_CR_CM          = 0x2    // Bit CM.
	DCMI_CR_CAPTURE_Pos = 0x0    // Position of CAPTURE field.
	DCMI_CR_CAPTURE_Msk = 0x1    // Bit mask of CAPTURE field.
	DCMI_CR_CAPTURE     = 0x1    // Bit CAPTURE.

	// SR: status register
	DCMI_SR_FNE_Pos   = 0x2 // Position of FNE field.
	DCMI_SR_FNE_Msk   = 0x4 // Bit mask of FNE field.
	DCMI_SR_FNE       = 0x4 // Bit FNE.
	DCMI_SR_VSYNC_Pos = 0x1 // Position of VSYNC field.
	DCMI_SR_VSYNC_Msk = 0x2 // Bit mask of VSYNC field.
	DCMI_SR_VSYNC     = 0x2 // Bit VSYNC.
	DCMI_SR_HSYNC_Pos = 0x0 // Position of HSYNC field.
	DCMI_SR_HSYNC_Msk = 0x1 // Bit mask of HSYNC field.
	DCMI_SR_HSYNC     = 0x1 // Bit HSYNC.

	// RIS: raw interrupt status register
	DCMI_RIS_LINE_RIS_Pos  = 0x4  // Position of LINE_RIS field.
	DCMI_RIS_LINE_RIS_Msk  = 0x10 // Bit mask of LINE_RIS field.
	DCMI_RIS_LINE_RIS      = 0x10 // Bit LINE_RIS.
	DCMI_RIS_VSYNC_RIS_Pos = 0x3  // Position of VSYNC_RIS field.
	DCMI_RIS_VSYNC_RIS_Msk = 0x8  // Bit mask of VSYNC_RIS field.
	DCMI_RIS_VSYNC_RIS     = 0x8  // Bit VSYNC_RIS.
	DCMI_RIS_ERR_RIS_Pos   = 0x2  // Position of ERR_RIS field.
	DCMI_RIS_ERR_RIS_Msk   = 0x4  // Bit mask of ERR_RIS field.
	DCMI_RIS_ERR_RIS       = 0x4  // Bit ERR_RIS.
	DCMI_RIS_OVR_RIS_Pos   = 0x1  // Position of OVR_RIS field.
	DCMI_RIS_OVR_RIS_Msk   = 0x2  // Bit mask of OVR_RIS field.
	DCMI_RIS_OVR_RIS       = 0x2  // Bit OVR_RIS.
	DCMI_RIS_FRAME_RIS_Pos = 0x0  // Position of FRAME_RIS field.
	DCMI_RIS_FRAME_RIS_Msk = 0x1  // Bit mask of FRAME_RIS field.
	DCMI_RIS_FRAME_RIS     = 0x1  // Bit FRAME_RIS.

	// IER: interrupt enable register
	DCMI_IER_LINE_IE_Pos  = 0x4  // Position of LINE_IE field.
	DCMI_IER_LINE_IE_Msk  = 0x10 // Bit mask of LINE_IE field.
	DCMI_IER_LINE_IE      = 0x10 // Bit LINE_IE.
	DCMI_IER_VSYNC_IE_Pos = 0x3  // Position of VSYNC_IE field.
	DCMI_IER_VSYNC_IE_Msk = 0x8  // Bit mask of VSYNC_IE field.
	DCMI_IER_VSYNC_IE     = 0x8  // Bit VSYNC_IE.
	DCMI_IER_ERR_IE_Pos   = 0x2  // Position of ERR_IE field.
	DCMI_IER_ERR_IE_Msk   = 0x4  // Bit mask of ERR_IE field.
	DCMI_IER_ERR_IE       = 0x4  // Bit ERR_IE.
	DCMI_IER_OVR_IE_Pos   = 0x1  // Position of OVR_IE field.
	DCMI_IER_OVR_IE_Msk   = 0x2  // Bit mask of OVR_IE field.
	DCMI_IER_OVR_IE       = 0x2  // Bit OVR_IE.
	DCMI_IER_FRAME_IE_Pos = 0x0  // Position of FRAME_IE field.
	DCMI_IER_FRAME_IE_Msk = 0x1  // Bit mask of FRAME_IE field.
	DCMI_IER_FRAME_IE     = 0x1  // Bit FRAME_IE.

	// MIS: masked interrupt status           register
	DCMI_MIS_LINE_MIS_Pos  = 0x4  // Position of LINE_MIS field.
	DCMI_MIS_LINE_MIS_Msk  = 0x10 // Bit mask of LINE_MIS field.
	DCMI_MIS_LINE_MIS      = 0x10 // Bit LINE_MIS.
	DCMI_MIS_VSYNC_MIS_Pos = 0x3  // Position of VSYNC_MIS field.
	DCMI_MIS_VSYNC_MIS_Msk = 0x8  // Bit mask of VSYNC_MIS field.
	DCMI_MIS_VSYNC_MIS     = 0x8  // Bit VSYNC_MIS.
	DCMI_MIS_ERR_MIS_Pos   = 0x2  // Position of ERR_MIS field.
	DCMI_MIS_ERR_MIS_Msk   = 0x4  // Bit mask of ERR_MIS field.
	DCMI_MIS_ERR_MIS       = 0x4  // Bit ERR_MIS.
	DCMI_MIS_OVR_MIS_Pos   = 0x1  // Position of OVR_MIS field.
	DCMI_MIS_OVR_MIS_Msk   = 0x2  // Bit mask of OVR_MIS field.
	DCMI_MIS_OVR_MIS       = 0x2  // Bit OVR_MIS.
	DCMI_MIS_FRAME_MIS_Pos = 0x0  // Position of FRAME_MIS field.
	DCMI_MIS_FRAME_MIS_Msk = 0x1  // Bit mask of FRAME_MIS field.
	DCMI_MIS_FRAME_MIS     = 0x1  // Bit FRAME_MIS.

	// ICR: interrupt clear register
	DCMI_ICR_LINE_ISC_Pos  = 0x4  // Position of LINE_ISC field.
	DCMI_ICR_LINE_ISC_Msk  = 0x10 // Bit mask of LINE_ISC field.
	DCMI_ICR_LINE_ISC      = 0x10 // Bit LINE_ISC.
	DCMI_ICR_VSYNC_ISC_Pos = 0x3  // Position of VSYNC_ISC field.
	DCMI_ICR_VSYNC_ISC_Msk = 0x8  // Bit mask of VSYNC_ISC field.
	DCMI_ICR_VSYNC_ISC     = 0x8  // Bit VSYNC_ISC.
	DCMI_ICR_ERR_ISC_Pos   = 0x2  // Position of ERR_ISC field.
	DCMI_ICR_ERR_ISC_Msk   = 0x4  // Bit mask of ERR_ISC field.
	DCMI_ICR_ERR_ISC       = 0x4  // Bit ERR_ISC.
	DCMI_ICR_OVR_ISC_Pos   = 0x1  // Position of OVR_ISC field.
	DCMI_ICR_OVR_ISC_Msk   = 0x2  // Bit mask of OVR_ISC field.
	DCMI_ICR_OVR_ISC       = 0x2  // Bit OVR_ISC.
	DCMI_ICR_FRAME_ISC_Pos = 0x0  // Position of FRAME_ISC field.
	DCMI_ICR_FRAME_ISC_Msk = 0x1  // Bit mask of FRAME_ISC field.
	DCMI_ICR_FRAME_ISC     = 0x1  // Bit FRAME_ISC.

	// ESCR: embedded synchronization code           register
	DCMI_ESCR_FEC_Pos = 0x18       // Position of FEC field.
	DCMI_ESCR_FEC_Msk = 0xff000000 // Bit mask of FEC field.
	DCMI_ESCR_LEC_Pos = 0x10       // Position of LEC field.
	DCMI_ESCR_LEC_Msk = 0xff0000   // Bit mask of LEC field.
	DCMI_ESCR_LSC_Pos = 0x8        // Position of LSC field.
	DCMI_ESCR_LSC_Msk = 0xff00     // Bit mask of LSC field.
	DCMI_ESCR_FSC_Pos = 0x0        // Position of FSC field.
	DCMI_ESCR_FSC_Msk = 0xff       // Bit mask of FSC field.

	// ESUR: embedded synchronization unmask           register
	DCMI_ESUR_FEU_Pos = 0x18       // Position of FEU field.
	DCMI_ESUR_FEU_Msk = 0xff000000 // Bit mask of FEU field.
	DCMI_ESUR_LEU_Pos = 0x10       // Position of LEU field.
	DCMI_ESUR_LEU_Msk = 0xff0000   // Bit mask of LEU field.
	DCMI_ESUR_LSU_Pos = 0x8        // Position of LSU field.
	DCMI_ESUR_LSU_Msk = 0xff00     // Bit mask of LSU field.
	DCMI_ESUR_FSU_Pos = 0x0        // Position of FSU field.
	DCMI_ESUR_FSU_Msk = 0xff       // Bit mask of FSU field.

	// CWSTRT: crop window start
	DCMI_CWSTRT_VST_Pos     = 0x10       // Position of VST field.
	DCMI_CWSTRT_VST_Msk     = 0x1fff0000 // Bit mask of VST field.
	DCMI_CWSTRT_HOFFCNT_Pos = 0x0        // Position of HOFFCNT field.
	DCMI_CWSTRT_HOFFCNT_Msk = 0x3fff     // Bit mask of HOFFCNT field.

	// CWSIZE: crop window size
	DCMI_CWSIZE_VLINE_Pos  = 0x10       // Position of VLINE field.
	DCMI_CWSIZE_VLINE_Msk  = 0x3fff0000 // Bit mask of VLINE field.
	DCMI_CWSIZE_CAPCNT_Pos = 0x0        // Position of CAPCNT field.
	DCMI_CWSIZE_CAPCNT_Msk = 0x3fff     // Bit mask of CAPCNT field.

	// DR: data register
	DCMI_DR_Byte3_Pos = 0x18       // Position of Byte3 field.
	DCMI_DR_Byte3_Msk = 0xff000000 // Bit mask of Byte3 field.
	DCMI_DR_Byte2_Pos = 0x10       // Position of Byte2 field.
	DCMI_DR_Byte2_Msk = 0xff0000   // Bit mask of Byte2 field.
	DCMI_DR_Byte1_Pos = 0x8        // Position of Byte1 field.
	DCMI_DR_Byte1_Msk = 0xff00     // Bit mask of Byte1 field.
	DCMI_DR_Byte0_Pos = 0x0        // Position of Byte0 field.
	DCMI_DR_Byte0_Msk = 0xff       // Bit mask of Byte0 field.
)

// Bitfields for FMC: Flexible memory controller
const (
	// BCR1: SRAM/NOR-Flash chip-select control register           1
	FSMC_BCR1_CCLKEN_Pos    = 0x14     // Position of CCLKEN field.
	FSMC_BCR1_CCLKEN_Msk    = 0x100000 // Bit mask of CCLKEN field.
	FSMC_BCR1_CCLKEN        = 0x100000 // Bit CCLKEN.
	FSMC_BCR1_CBURSTRW_Pos  = 0x13     // Position of CBURSTRW field.
	FSMC_BCR1_CBURSTRW_Msk  = 0x80000  // Bit mask of CBURSTRW field.
	FSMC_BCR1_CBURSTRW      = 0x80000  // Bit CBURSTRW.
	FSMC_BCR1_ASYNCWAIT_Pos = 0xf      // Position of ASYNCWAIT field.
	FSMC_BCR1_ASYNCWAIT_Msk = 0x8000   // Bit mask of ASYNCWAIT field.
	FSMC_BCR1_ASYNCWAIT     = 0x8000   // Bit ASYNCWAIT.
	FSMC_BCR1_EXTMOD_Pos    = 0xe      // Position of EXTMOD field.
	FSMC_BCR1_EXTMOD_Msk    = 0x4000   // Bit mask of EXTMOD field.
	FSMC_BCR1_EXTMOD        = 0x4000   // Bit EXTMOD.
	FSMC_BCR1_WAITEN_Pos    = 0xd      // Position of WAITEN field.
	FSMC_BCR1_WAITEN_Msk    = 0x2000   // Bit mask of WAITEN field.
	FSMC_BCR1_WAITEN        = 0x2000   // Bit WAITEN.
	FSMC_BCR1_WREN_Pos      = 0xc      // Position of WREN field.
	FSMC_BCR1_WREN_Msk      = 0x1000   // Bit mask of WREN field.
	FSMC_BCR1_WREN          = 0x1000   // Bit WREN.
	FSMC_BCR1_WAITCFG_Pos   = 0xb      // Position of WAITCFG field.
	FSMC_BCR1_WAITCFG_Msk   = 0x800    // Bit mask of WAITCFG field.
	FSMC_BCR1_WAITCFG       = 0x800    // Bit WAITCFG.
	FSMC_BCR1_WAITPOL_Pos   = 0x9      // Position of WAITPOL field.
	FSMC_BCR1_WAITPOL_Msk   = 0x200    // Bit mask of WAITPOL field.
	FSMC_BCR1_WAITPOL       = 0x200    // Bit WAITPOL.
	FSMC_BCR1_BURSTEN_Pos   = 0x8      // Position of BURSTEN field.
	FSMC_BCR1_BURSTEN_Msk   = 0x100    // Bit mask of BURSTEN field.
	FSMC_BCR1_BURSTEN       = 0x100    // Bit BURSTEN.
	FSMC_BCR1_FACCEN_Pos    = 0x6      // Position of FACCEN field.
	FSMC_BCR1_FACCEN_Msk    = 0x40     // Bit mask of FACCEN field.
	FSMC_BCR1_FACCEN        = 0x40     // Bit FACCEN.
	FSMC_BCR1_MWID_Pos      = 0x4      // Position of MWID field.
	FSMC_BCR1_MWID_Msk      = 0x30     // Bit mask of MWID field.
	FSMC_BCR1_MTYP_Pos      = 0x2      // Position of MTYP field.
	FSMC_BCR1_MTYP_Msk      = 0xc      // Bit mask of MTYP field.
	FSMC_BCR1_MUXEN_Pos     = 0x1      // Position of MUXEN field.
	FSMC_BCR1_MUXEN_Msk     = 0x2      // Bit mask of MUXEN field.
	FSMC_BCR1_MUXEN         = 0x2      // Bit MUXEN.
	FSMC_BCR1_MBKEN_Pos     = 0x0      // Position of MBKEN field.
	FSMC_BCR1_MBKEN_Msk     = 0x1      // Bit mask of MBKEN field.
	FSMC_BCR1_MBKEN         = 0x1      // Bit MBKEN.

	// BTR1: SRAM/NOR-Flash chip-select timing register           1
	FSMC_BTR1_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FSMC_BTR1_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BTR1_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FSMC_BTR1_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BTR1_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FSMC_BTR1_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BTR1_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FSMC_BTR1_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FSMC_BTR1_DATAST_Pos  = 0x8        // Position of DATAST field.
	FSMC_BTR1_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FSMC_BTR1_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FSMC_BTR1_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BTR1_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FSMC_BTR1_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.

	// BCR2: SRAM/NOR-Flash chip-select control register           2
	FSMC_BCR2_CBURSTRW_Pos  = 0x13    // Position of CBURSTRW field.
	FSMC_BCR2_CBURSTRW_Msk  = 0x80000 // Bit mask of CBURSTRW field.
	FSMC_BCR2_CBURSTRW      = 0x80000 // Bit CBURSTRW.
	FSMC_BCR2_ASYNCWAIT_Pos = 0xf     // Position of ASYNCWAIT field.
	FSMC_BCR2_ASYNCWAIT_Msk = 0x8000  // Bit mask of ASYNCWAIT field.
	FSMC_BCR2_ASYNCWAIT     = 0x8000  // Bit ASYNCWAIT.
	FSMC_BCR2_EXTMOD_Pos    = 0xe     // Position of EXTMOD field.
	FSMC_BCR2_EXTMOD_Msk    = 0x4000  // Bit mask of EXTMOD field.
	FSMC_BCR2_EXTMOD        = 0x4000  // Bit EXTMOD.
	FSMC_BCR2_WAITEN_Pos    = 0xd     // Position of WAITEN field.
	FSMC_BCR2_WAITEN_Msk    = 0x2000  // Bit mask of WAITEN field.
	FSMC_BCR2_WAITEN        = 0x2000  // Bit WAITEN.
	FSMC_BCR2_WREN_Pos      = 0xc     // Position of WREN field.
	FSMC_BCR2_WREN_Msk      = 0x1000  // Bit mask of WREN field.
	FSMC_BCR2_WREN          = 0x1000  // Bit WREN.
	FSMC_BCR2_WAITCFG_Pos   = 0xb     // Position of WAITCFG field.
	FSMC_BCR2_WAITCFG_Msk   = 0x800   // Bit mask of WAITCFG field.
	FSMC_BCR2_WAITCFG       = 0x800   // Bit WAITCFG.
	FSMC_BCR2_WRAPMOD_Pos   = 0xa     // Position of WRAPMOD field.
	FSMC_BCR2_WRAPMOD_Msk   = 0x400   // Bit mask of WRAPMOD field.
	FSMC_BCR2_WRAPMOD       = 0x400   // Bit WRAPMOD.
	FSMC_BCR2_WAITPOL_Pos   = 0x9     // Position of WAITPOL field.
	FSMC_BCR2_WAITPOL_Msk   = 0x200   // Bit mask of WAITPOL field.
	FSMC_BCR2_WAITPOL       = 0x200   // Bit WAITPOL.
	FSMC_BCR2_BURSTEN_Pos   = 0x8     // Position of BURSTEN field.
	FSMC_BCR2_BURSTEN_Msk   = 0x100   // Bit mask of BURSTEN field.
	FSMC_BCR2_BURSTEN       = 0x100   // Bit BURSTEN.
	FSMC_BCR2_FACCEN_Pos    = 0x6     // Position of FACCEN field.
	FSMC_BCR2_FACCEN_Msk    = 0x40    // Bit mask of FACCEN field.
	FSMC_BCR2_FACCEN        = 0x40    // Bit FACCEN.
	FSMC_BCR2_MWID_Pos      = 0x4     // Position of MWID field.
	FSMC_BCR2_MWID_Msk      = 0x30    // Bit mask of MWID field.
	FSMC_BCR2_MTYP_Pos      = 0x2     // Position of MTYP field.
	FSMC_BCR2_MTYP_Msk      = 0xc     // Bit mask of MTYP field.
	FSMC_BCR2_MUXEN_Pos     = 0x1     // Position of MUXEN field.
	FSMC_BCR2_MUXEN_Msk     = 0x2     // Bit mask of MUXEN field.
	FSMC_BCR2_MUXEN         = 0x2     // Bit MUXEN.
	FSMC_BCR2_MBKEN_Pos     = 0x0     // Position of MBKEN field.
	FSMC_BCR2_MBKEN_Msk     = 0x1     // Bit mask of MBKEN field.
	FSMC_BCR2_MBKEN         = 0x1     // Bit MBKEN.

	// BTR2: SRAM/NOR-Flash chip-select timing register           2
	FSMC_BTR2_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FSMC_BTR2_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BTR2_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FSMC_BTR2_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BTR2_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FSMC_BTR2_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BTR2_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FSMC_BTR2_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FSMC_BTR2_DATAST_Pos  = 0x8        // Position of DATAST field.
	FSMC_BTR2_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FSMC_BTR2_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FSMC_BTR2_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BTR2_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FSMC_BTR2_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.

	// BCR3: SRAM/NOR-Flash chip-select control register           3
	FSMC_BCR3_CBURSTRW_Pos  = 0x13    // Position of CBURSTRW field.
	FSMC_BCR3_CBURSTRW_Msk  = 0x80000 // Bit mask of CBURSTRW field.
	FSMC_BCR3_CBURSTRW      = 0x80000 // Bit CBURSTRW.
	FSMC_BCR3_ASYNCWAIT_Pos = 0xf     // Position of ASYNCWAIT field.
	FSMC_BCR3_ASYNCWAIT_Msk = 0x8000  // Bit mask of ASYNCWAIT field.
	FSMC_BCR3_ASYNCWAIT     = 0x8000  // Bit ASYNCWAIT.
	FSMC_BCR3_EXTMOD_Pos    = 0xe     // Position of EXTMOD field.
	FSMC_BCR3_EXTMOD_Msk    = 0x4000  // Bit mask of EXTMOD field.
	FSMC_BCR3_EXTMOD        = 0x4000  // Bit EXTMOD.
	FSMC_BCR3_WAITEN_Pos    = 0xd     // Position of WAITEN field.
	FSMC_BCR3_WAITEN_Msk    = 0x2000  // Bit mask of WAITEN field.
	FSMC_BCR3_WAITEN        = 0x2000  // Bit WAITEN.
	FSMC_BCR3_WREN_Pos      = 0xc     // Position of WREN field.
	FSMC_BCR3_WREN_Msk      = 0x1000  // Bit mask of WREN field.
	FSMC_BCR3_WREN          = 0x1000  // Bit WREN.
	FSMC_BCR3_WAITCFG_Pos   = 0xb     // Position of WAITCFG field.
	FSMC_BCR3_WAITCFG_Msk   = 0x800   // Bit mask of WAITCFG field.
	FSMC_BCR3_WAITCFG       = 0x800   // Bit WAITCFG.
	FSMC_BCR3_WRAPMOD_Pos   = 0xa     // Position of WRAPMOD field.
	FSMC_BCR3_WRAPMOD_Msk   = 0x400   // Bit mask of WRAPMOD field.
	FSMC_BCR3_WRAPMOD       = 0x400   // Bit WRAPMOD.
	FSMC_BCR3_WAITPOL_Pos   = 0x9     // Position of WAITPOL field.
	FSMC_BCR3_WAITPOL_Msk   = 0x200   // Bit mask of WAITPOL field.
	FSMC_BCR3_WAITPOL       = 0x200   // Bit WAITPOL.
	FSMC_BCR3_BURSTEN_Pos   = 0x8     // Position of BURSTEN field.
	FSMC_BCR3_BURSTEN_Msk   = 0x100   // Bit mask of BURSTEN field.
	FSMC_BCR3_BURSTEN       = 0x100   // Bit BURSTEN.
	FSMC_BCR3_FACCEN_Pos    = 0x6     // Position of FACCEN field.
	FSMC_BCR3_FACCEN_Msk    = 0x40    // Bit mask of FACCEN field.
	FSMC_BCR3_FACCEN        = 0x40    // Bit FACCEN.
	FSMC_BCR3_MWID_Pos      = 0x4     // Position of MWID field.
	FSMC_BCR3_MWID_Msk      = 0x30    // Bit mask of MWID field.
	FSMC_BCR3_MTYP_Pos      = 0x2     // Position of MTYP field.
	FSMC_BCR3_MTYP_Msk      = 0xc     // Bit mask of MTYP field.
	FSMC_BCR3_MUXEN_Pos     = 0x1     // Position of MUXEN field.
	FSMC_BCR3_MUXEN_Msk     = 0x2     // Bit mask of MUXEN field.
	FSMC_BCR3_MUXEN         = 0x2     // Bit MUXEN.
	FSMC_BCR3_MBKEN_Pos     = 0x0     // Position of MBKEN field.
	FSMC_BCR3_MBKEN_Msk     = 0x1     // Bit mask of MBKEN field.
	FSMC_BCR3_MBKEN         = 0x1     // Bit MBKEN.

	// BTR3: SRAM/NOR-Flash chip-select timing register           3
	FSMC_BTR3_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FSMC_BTR3_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BTR3_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FSMC_BTR3_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BTR3_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FSMC_BTR3_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BTR3_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FSMC_BTR3_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FSMC_BTR3_DATAST_Pos  = 0x8        // Position of DATAST field.
	FSMC_BTR3_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FSMC_BTR3_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FSMC_BTR3_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BTR3_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FSMC_BTR3_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.

	// BCR4: SRAM/NOR-Flash chip-select control register           4
	FSMC_BCR4_CBURSTRW_Pos  = 0x13    // Position of CBURSTRW field.
	FSMC_BCR4_CBURSTRW_Msk  = 0x80000 // Bit mask of CBURSTRW field.
	FSMC_BCR4_CBURSTRW      = 0x80000 // Bit CBURSTRW.
	FSMC_BCR4_ASYNCWAIT_Pos = 0xf     // Position of ASYNCWAIT field.
	FSMC_BCR4_ASYNCWAIT_Msk = 0x8000  // Bit mask of ASYNCWAIT field.
	FSMC_BCR4_ASYNCWAIT     = 0x8000  // Bit ASYNCWAIT.
	FSMC_BCR4_EXTMOD_Pos    = 0xe     // Position of EXTMOD field.
	FSMC_BCR4_EXTMOD_Msk    = 0x4000  // Bit mask of EXTMOD field.
	FSMC_BCR4_EXTMOD        = 0x4000  // Bit EXTMOD.
	FSMC_BCR4_WAITEN_Pos    = 0xd     // Position of WAITEN field.
	FSMC_BCR4_WAITEN_Msk    = 0x2000  // Bit mask of WAITEN field.
	FSMC_BCR4_WAITEN        = 0x2000  // Bit WAITEN.
	FSMC_BCR4_WREN_Pos      = 0xc     // Position of WREN field.
	FSMC_BCR4_WREN_Msk      = 0x1000  // Bit mask of WREN field.
	FSMC_BCR4_WREN          = 0x1000  // Bit WREN.
	FSMC_BCR4_WAITCFG_Pos   = 0xb     // Position of WAITCFG field.
	FSMC_BCR4_WAITCFG_Msk   = 0x800   // Bit mask of WAITCFG field.
	FSMC_BCR4_WAITCFG       = 0x800   // Bit WAITCFG.
	FSMC_BCR4_WRAPMOD_Pos   = 0xa     // Position of WRAPMOD field.
	FSMC_BCR4_WRAPMOD_Msk   = 0x400   // Bit mask of WRAPMOD field.
	FSMC_BCR4_WRAPMOD       = 0x400   // Bit WRAPMOD.
	FSMC_BCR4_WAITPOL_Pos   = 0x9     // Position of WAITPOL field.
	FSMC_BCR4_WAITPOL_Msk   = 0x200   // Bit mask of WAITPOL field.
	FSMC_BCR4_WAITPOL       = 0x200   // Bit WAITPOL.
	FSMC_BCR4_BURSTEN_Pos   = 0x8     // Position of BURSTEN field.
	FSMC_BCR4_BURSTEN_Msk   = 0x100   // Bit mask of BURSTEN field.
	FSMC_BCR4_BURSTEN       = 0x100   // Bit BURSTEN.
	FSMC_BCR4_FACCEN_Pos    = 0x6     // Position of FACCEN field.
	FSMC_BCR4_FACCEN_Msk    = 0x40    // Bit mask of FACCEN field.
	FSMC_BCR4_FACCEN        = 0x40    // Bit FACCEN.
	FSMC_BCR4_MWID_Pos      = 0x4     // Position of MWID field.
	FSMC_BCR4_MWID_Msk      = 0x30    // Bit mask of MWID field.
	FSMC_BCR4_MTYP_Pos      = 0x2     // Position of MTYP field.
	FSMC_BCR4_MTYP_Msk      = 0xc     // Bit mask of MTYP field.
	FSMC_BCR4_MUXEN_Pos     = 0x1     // Position of MUXEN field.
	FSMC_BCR4_MUXEN_Msk     = 0x2     // Bit mask of MUXEN field.
	FSMC_BCR4_MUXEN         = 0x2     // Bit MUXEN.
	FSMC_BCR4_MBKEN_Pos     = 0x0     // Position of MBKEN field.
	FSMC_BCR4_MBKEN_Msk     = 0x1     // Bit mask of MBKEN field.
	FSMC_BCR4_MBKEN         = 0x1     // Bit MBKEN.

	// BTR4: SRAM/NOR-Flash chip-select timing register           4
	FSMC_BTR4_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FSMC_BTR4_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BTR4_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FSMC_BTR4_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BTR4_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FSMC_BTR4_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BTR4_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FSMC_BTR4_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FSMC_BTR4_DATAST_Pos  = 0x8        // Position of DATAST field.
	FSMC_BTR4_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FSMC_BTR4_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FSMC_BTR4_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BTR4_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FSMC_BTR4_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.

	// PCR: PC Card/NAND Flash control           register
	FSMC_PCR_ECCPS_Pos   = 0x11    // Position of ECCPS field.
	FSMC_PCR_ECCPS_Msk   = 0xe0000 // Bit mask of ECCPS field.
	FSMC_PCR_TAR_Pos     = 0xd     // Position of TAR field.
	FSMC_PCR_TAR_Msk     = 0x1e000 // Bit mask of TAR field.
	FSMC_PCR_TCLR_Pos    = 0x9     // Position of TCLR field.
	FSMC_PCR_TCLR_Msk    = 0x1e00  // Bit mask of TCLR field.
	FSMC_PCR_ECCEN_Pos   = 0x6     // Position of ECCEN field.
	FSMC_PCR_ECCEN_Msk   = 0x40    // Bit mask of ECCEN field.
	FSMC_PCR_ECCEN       = 0x40    // Bit ECCEN.
	FSMC_PCR_PWID_Pos    = 0x4     // Position of PWID field.
	FSMC_PCR_PWID_Msk    = 0x30    // Bit mask of PWID field.
	FSMC_PCR_PTYP_Pos    = 0x3     // Position of PTYP field.
	FSMC_PCR_PTYP_Msk    = 0x8     // Bit mask of PTYP field.
	FSMC_PCR_PTYP        = 0x8     // Bit PTYP.
	FSMC_PCR_PBKEN_Pos   = 0x2     // Position of PBKEN field.
	FSMC_PCR_PBKEN_Msk   = 0x4     // Bit mask of PBKEN field.
	FSMC_PCR_PBKEN       = 0x4     // Bit PBKEN.
	FSMC_PCR_PWAITEN_Pos = 0x1     // Position of PWAITEN field.
	FSMC_PCR_PWAITEN_Msk = 0x2     // Bit mask of PWAITEN field.
	FSMC_PCR_PWAITEN     = 0x2     // Bit PWAITEN.

	// SR: FIFO status and interrupt           register
	FSMC_SR_FEMPT_Pos = 0x6  // Position of FEMPT field.
	FSMC_SR_FEMPT_Msk = 0x40 // Bit mask of FEMPT field.
	FSMC_SR_FEMPT     = 0x40 // Bit FEMPT.
	FSMC_SR_IFEN_Pos  = 0x5  // Position of IFEN field.
	FSMC_SR_IFEN_Msk  = 0x20 // Bit mask of IFEN field.
	FSMC_SR_IFEN      = 0x20 // Bit IFEN.
	FSMC_SR_ILEN_Pos  = 0x4  // Position of ILEN field.
	FSMC_SR_ILEN_Msk  = 0x10 // Bit mask of ILEN field.
	FSMC_SR_ILEN      = 0x10 // Bit ILEN.
	FSMC_SR_IREN_Pos  = 0x3  // Position of IREN field.
	FSMC_SR_IREN_Msk  = 0x8  // Bit mask of IREN field.
	FSMC_SR_IREN      = 0x8  // Bit IREN.
	FSMC_SR_IFS_Pos   = 0x2  // Position of IFS field.
	FSMC_SR_IFS_Msk   = 0x4  // Bit mask of IFS field.
	FSMC_SR_IFS       = 0x4  // Bit IFS.
	FSMC_SR_ILS_Pos   = 0x1  // Position of ILS field.
	FSMC_SR_ILS_Msk   = 0x2  // Bit mask of ILS field.
	FSMC_SR_ILS       = 0x2  // Bit ILS.
	FSMC_SR_IRS_Pos   = 0x0  // Position of IRS field.
	FSMC_SR_IRS_Msk   = 0x1  // Bit mask of IRS field.
	FSMC_SR_IRS       = 0x1  // Bit IRS.

	// PMEM: Common memory space timing           register
	FSMC_PMEM_MEMHIZx_Pos  = 0x18       // Position of MEMHIZx field.
	FSMC_PMEM_MEMHIZx_Msk  = 0xff000000 // Bit mask of MEMHIZx field.
	FSMC_PMEM_MEMHOLDx_Pos = 0x10       // Position of MEMHOLDx field.
	FSMC_PMEM_MEMHOLDx_Msk = 0xff0000   // Bit mask of MEMHOLDx field.
	FSMC_PMEM_MEMWAITx_Pos = 0x8        // Position of MEMWAITx field.
	FSMC_PMEM_MEMWAITx_Msk = 0xff00     // Bit mask of MEMWAITx field.
	FSMC_PMEM_MEMSETx_Pos  = 0x0        // Position of MEMSETx field.
	FSMC_PMEM_MEMSETx_Msk  = 0xff       // Bit mask of MEMSETx field.

	// PATT: Attribute memory space timing           register
	FSMC_PATT_ATTHIZx_Pos  = 0x18       // Position of ATTHIZx field.
	FSMC_PATT_ATTHIZx_Msk  = 0xff000000 // Bit mask of ATTHIZx field.
	FSMC_PATT_ATTHOLDx_Pos = 0x10       // Position of ATTHOLDx field.
	FSMC_PATT_ATTHOLDx_Msk = 0xff0000   // Bit mask of ATTHOLDx field.
	FSMC_PATT_ATTWAITx_Pos = 0x8        // Position of ATTWAITx field.
	FSMC_PATT_ATTWAITx_Msk = 0xff00     // Bit mask of ATTWAITx field.
	FSMC_PATT_ATTSETx_Pos  = 0x0        // Position of ATTSETx field.
	FSMC_PATT_ATTSETx_Msk  = 0xff       // Bit mask of ATTSETx field.

	// ECCR: ECC result register
	FSMC_ECCR_ECCx_Pos = 0x0        // Position of ECCx field.
	FSMC_ECCR_ECCx_Msk = 0xffffffff // Bit mask of ECCx field.

	// BWTR1: SRAM/NOR-Flash write timing registers           1
	FSMC_BWTR1_ACCMOD_Pos = 0x1c       // Position of ACCMOD field.
	FSMC_BWTR1_ACCMOD_Msk = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BWTR1_DATLAT_Pos = 0x18       // Position of DATLAT field.
	FSMC_BWTR1_DATLAT_Msk = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BWTR1_CLKDIV_Pos = 0x14       // Position of CLKDIV field.
	FSMC_BWTR1_CLKDIV_Msk = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BWTR1_DATAST_Pos = 0x8        // Position of DATAST field.
	FSMC_BWTR1_DATAST_Msk = 0xff00     // Bit mask of DATAST field.
	FSMC_BWTR1_ADDHLD_Pos = 0x4        // Position of ADDHLD field.
	FSMC_BWTR1_ADDHLD_Msk = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BWTR1_ADDSET_Pos = 0x0        // Position of ADDSET field.
	FSMC_BWTR1_ADDSET_Msk = 0xf        // Bit mask of ADDSET field.

	// BWTR2: SRAM/NOR-Flash write timing registers           2
	FSMC_BWTR2_ACCMOD_Pos = 0x1c       // Position of ACCMOD field.
	FSMC_BWTR2_ACCMOD_Msk = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BWTR2_DATLAT_Pos = 0x18       // Position of DATLAT field.
	FSMC_BWTR2_DATLAT_Msk = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BWTR2_CLKDIV_Pos = 0x14       // Position of CLKDIV field.
	FSMC_BWTR2_CLKDIV_Msk = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BWTR2_DATAST_Pos = 0x8        // Position of DATAST field.
	FSMC_BWTR2_DATAST_Msk = 0xff00     // Bit mask of DATAST field.
	FSMC_BWTR2_ADDHLD_Pos = 0x4        // Position of ADDHLD field.
	FSMC_BWTR2_ADDHLD_Msk = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BWTR2_ADDSET_Pos = 0x0        // Position of ADDSET field.
	FSMC_BWTR2_ADDSET_Msk = 0xf        // Bit mask of ADDSET field.

	// BWTR3: SRAM/NOR-Flash write timing registers           3
	FSMC_BWTR3_ACCMOD_Pos = 0x1c       // Position of ACCMOD field.
	FSMC_BWTR3_ACCMOD_Msk = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BWTR3_DATLAT_Pos = 0x18       // Position of DATLAT field.
	FSMC_BWTR3_DATLAT_Msk = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BWTR3_CLKDIV_Pos = 0x14       // Position of CLKDIV field.
	FSMC_BWTR3_CLKDIV_Msk = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BWTR3_DATAST_Pos = 0x8        // Position of DATAST field.
	FSMC_BWTR3_DATAST_Msk = 0xff00     // Bit mask of DATAST field.
	FSMC_BWTR3_ADDHLD_Pos = 0x4        // Position of ADDHLD field.
	FSMC_BWTR3_ADDHLD_Msk = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BWTR3_ADDSET_Pos = 0x0        // Position of ADDSET field.
	FSMC_BWTR3_ADDSET_Msk = 0xf        // Bit mask of ADDSET field.

	// BWTR4: SRAM/NOR-Flash write timing registers           4
	FSMC_BWTR4_ACCMOD_Pos = 0x1c       // Position of ACCMOD field.
	FSMC_BWTR4_ACCMOD_Msk = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BWTR4_DATLAT_Pos = 0x18       // Position of DATLAT field.
	FSMC_BWTR4_DATLAT_Msk = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BWTR4_CLKDIV_Pos = 0x14       // Position of CLKDIV field.
	FSMC_BWTR4_CLKDIV_Msk = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BWTR4_DATAST_Pos = 0x8        // Position of DATAST field.
	FSMC_BWTR4_DATAST_Msk = 0xff00     // Bit mask of DATAST field.
	FSMC_BWTR4_ADDHLD_Pos = 0x4        // Position of ADDHLD field.
	FSMC_BWTR4_ADDHLD_Msk = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BWTR4_ADDSET_Pos = 0x0        // Position of ADDSET field.
	FSMC_BWTR4_ADDSET_Msk = 0xf        // Bit mask of ADDSET field.

	// SDCR1: SDRAM Control Register 1
	FSMC_SDCR1_NC_Pos     = 0x0    // Position of NC field.
	FSMC_SDCR1_NC_Msk     = 0x3    // Bit mask of NC field.
	FSMC_SDCR1_NR_Pos     = 0x2    // Position of NR field.
	FSMC_SDCR1_NR_Msk     = 0xc    // Bit mask of NR field.
	FSMC_SDCR1_MWID_Pos   = 0x4    // Position of MWID field.
	FSMC_SDCR1_MWID_Msk   = 0x30   // Bit mask of MWID field.
	FSMC_SDCR1_NB_Pos     = 0x6    // Position of NB field.
	FSMC_SDCR1_NB_Msk     = 0x40   // Bit mask of NB field.
	FSMC_SDCR1_NB         = 0x40   // Bit NB.
	FSMC_SDCR1_CAS_Pos    = 0x7    // Position of CAS field.
	FSMC_SDCR1_CAS_Msk    = 0x180  // Bit mask of CAS field.
	FSMC_SDCR1_WP_Pos     = 0x9    // Position of WP field.
	FSMC_SDCR1_WP_Msk     = 0x200  // Bit mask of WP field.
	FSMC_SDCR1_WP         = 0x200  // Bit WP.
	FSMC_SDCR1_SDCLK_Pos  = 0xa    // Position of SDCLK field.
	FSMC_SDCR1_SDCLK_Msk  = 0xc00  // Bit mask of SDCLK field.
	FSMC_SDCR1_RBURST_Pos = 0xc    // Position of RBURST field.
	FSMC_SDCR1_RBURST_Msk = 0x1000 // Bit mask of RBURST field.
	FSMC_SDCR1_RBURST     = 0x1000 // Bit RBURST.
	FSMC_SDCR1_RPIPE_Pos  = 0xd    // Position of RPIPE field.
	FSMC_SDCR1_RPIPE_Msk  = 0x6000 // Bit mask of RPIPE field.

	// SDCR2: SDRAM Control Register 2
	FSMC_SDCR2_NC_Pos     = 0x0    // Position of NC field.
	FSMC_SDCR2_NC_Msk     = 0x3    // Bit mask of NC field.
	FSMC_SDCR2_NR_Pos     = 0x2    // Position of NR field.
	FSMC_SDCR2_NR_Msk     = 0xc    // Bit mask of NR field.
	FSMC_SDCR2_MWID_Pos   = 0x4    // Position of MWID field.
	FSMC_SDCR2_MWID_Msk   = 0x30   // Bit mask of MWID field.
	FSMC_SDCR2_NB_Pos     = 0x6    // Position of NB field.
	FSMC_SDCR2_NB_Msk     = 0x40   // Bit mask of NB field.
	FSMC_SDCR2_NB         = 0x40   // Bit NB.
	FSMC_SDCR2_CAS_Pos    = 0x7    // Position of CAS field.
	FSMC_SDCR2_CAS_Msk    = 0x180  // Bit mask of CAS field.
	FSMC_SDCR2_WP_Pos     = 0x9    // Position of WP field.
	FSMC_SDCR2_WP_Msk     = 0x200  // Bit mask of WP field.
	FSMC_SDCR2_WP         = 0x200  // Bit WP.
	FSMC_SDCR2_SDCLK_Pos  = 0xa    // Position of SDCLK field.
	FSMC_SDCR2_SDCLK_Msk  = 0xc00  // Bit mask of SDCLK field.
	FSMC_SDCR2_RBURST_Pos = 0xc    // Position of RBURST field.
	FSMC_SDCR2_RBURST_Msk = 0x1000 // Bit mask of RBURST field.
	FSMC_SDCR2_RBURST     = 0x1000 // Bit RBURST.
	FSMC_SDCR2_RPIPE_Pos  = 0xd    // Position of RPIPE field.
	FSMC_SDCR2_RPIPE_Msk  = 0x6000 // Bit mask of RPIPE field.

	// SDTR1: SDRAM Timing register 1
	FSMC_SDTR1_TMRD_Pos = 0x0       // Position of TMRD field.
	FSMC_SDTR1_TMRD_Msk = 0xf       // Bit mask of TMRD field.
	FSMC_SDTR1_TXSR_Pos = 0x4       // Position of TXSR field.
	FSMC_SDTR1_TXSR_Msk = 0xf0      // Bit mask of TXSR field.
	FSMC_SDTR1_TRAS_Pos = 0x8       // Position of TRAS field.
	FSMC_SDTR1_TRAS_Msk = 0xf00     // Bit mask of TRAS field.
	FSMC_SDTR1_TRC_Pos  = 0xc       // Position of TRC field.
	FSMC_SDTR1_TRC_Msk  = 0xf000    // Bit mask of TRC field.
	FSMC_SDTR1_TWR_Pos  = 0x10      // Position of TWR field.
	FSMC_SDTR1_TWR_Msk  = 0xf0000   // Bit mask of TWR field.
	FSMC_SDTR1_TRP_Pos  = 0x14      // Position of TRP field.
	FSMC_SDTR1_TRP_Msk  = 0xf00000  // Bit mask of TRP field.
	FSMC_SDTR1_TRCD_Pos = 0x18      // Position of TRCD field.
	FSMC_SDTR1_TRCD_Msk = 0xf000000 // Bit mask of TRCD field.

	// SDTR2: SDRAM Timing register 2
	FSMC_SDTR2_TMRD_Pos = 0x0       // Position of TMRD field.
	FSMC_SDTR2_TMRD_Msk = 0xf       // Bit mask of TMRD field.
	FSMC_SDTR2_TXSR_Pos = 0x4       // Position of TXSR field.
	FSMC_SDTR2_TXSR_Msk = 0xf0      // Bit mask of TXSR field.
	FSMC_SDTR2_TRAS_Pos = 0x8       // Position of TRAS field.
	FSMC_SDTR2_TRAS_Msk = 0xf00     // Bit mask of TRAS field.
	FSMC_SDTR2_TRC_Pos  = 0xc       // Position of TRC field.
	FSMC_SDTR2_TRC_Msk  = 0xf000    // Bit mask of TRC field.
	FSMC_SDTR2_TWR_Pos  = 0x10      // Position of TWR field.
	FSMC_SDTR2_TWR_Msk  = 0xf0000   // Bit mask of TWR field.
	FSMC_SDTR2_TRP_Pos  = 0x14      // Position of TRP field.
	FSMC_SDTR2_TRP_Msk  = 0xf00000  // Bit mask of TRP field.
	FSMC_SDTR2_TRCD_Pos = 0x18      // Position of TRCD field.
	FSMC_SDTR2_TRCD_Msk = 0xf000000 // Bit mask of TRCD field.

	// SDCMR: SDRAM Command Mode register
	FSMC_SDCMR_MODE_Pos = 0x0      // Position of MODE field.
	FSMC_SDCMR_MODE_Msk = 0x7      // Bit mask of MODE field.
	FSMC_SDCMR_CTB2_Pos = 0x3      // Position of CTB2 field.
	FSMC_SDCMR_CTB2_Msk = 0x8      // Bit mask of CTB2 field.
	FSMC_SDCMR_CTB2     = 0x8      // Bit CTB2.
	FSMC_SDCMR_CTB1_Pos = 0x4      // Position of CTB1 field.
	FSMC_SDCMR_CTB1_Msk = 0x10     // Bit mask of CTB1 field.
	FSMC_SDCMR_CTB1     = 0x10     // Bit CTB1.
	FSMC_SDCMR_NRFS_Pos = 0x5      // Position of NRFS field.
	FSMC_SDCMR_NRFS_Msk = 0x1e0    // Bit mask of NRFS field.
	FSMC_SDCMR_MRD_Pos  = 0x9      // Position of MRD field.
	FSMC_SDCMR_MRD_Msk  = 0x3ffe00 // Bit mask of MRD field.

	// SDRTR: SDRAM Refresh Timer register
	FSMC_SDRTR_CRE_Pos   = 0x0    // Position of CRE field.
	FSMC_SDRTR_CRE_Msk   = 0x1    // Bit mask of CRE field.
	FSMC_SDRTR_CRE       = 0x1    // Bit CRE.
	FSMC_SDRTR_COUNT_Pos = 0x1    // Position of COUNT field.
	FSMC_SDRTR_COUNT_Msk = 0x3ffe // Bit mask of COUNT field.
	FSMC_SDRTR_REIE_Pos  = 0xe    // Position of REIE field.
	FSMC_SDRTR_REIE_Msk  = 0x4000 // Bit mask of REIE field.
	FSMC_SDRTR_REIE      = 0x4000 // Bit REIE.

	// SDSR: SDRAM Status register
	FSMC_SDSR_RE_Pos     = 0x0  // Position of RE field.
	FSMC_SDSR_RE_Msk     = 0x1  // Bit mask of RE field.
	FSMC_SDSR_RE         = 0x1  // Bit RE.
	FSMC_SDSR_MODES1_Pos = 0x1  // Position of MODES1 field.
	FSMC_SDSR_MODES1_Msk = 0x6  // Bit mask of MODES1 field.
	FSMC_SDSR_MODES2_Pos = 0x3  // Position of MODES2 field.
	FSMC_SDSR_MODES2_Msk = 0x18 // Bit mask of MODES2 field.
	FSMC_SDSR_BUSY_Pos   = 0x5  // Position of BUSY field.
	FSMC_SDSR_BUSY_Msk   = 0x20 // Bit mask of BUSY field.
	FSMC_SDSR_BUSY       = 0x20 // Bit BUSY.
)

// Bitfields for DMA2: DMA controller
const (
	// LISR: low interrupt status register
	DMA_LISR_TCIF3_Pos  = 0x1b      // Position of TCIF3 field.
	DMA_LISR_TCIF3_Msk  = 0x8000000 // Bit mask of TCIF3 field.
	DMA_LISR_TCIF3      = 0x8000000 // Bit TCIF3.
	DMA_LISR_HTIF3_Pos  = 0x1a      // Position of HTIF3 field.
	DMA_LISR_HTIF3_Msk  = 0x4000000 // Bit mask of HTIF3 field.
	DMA_LISR_HTIF3      = 0x4000000 // Bit HTIF3.
	DMA_LISR_TEIF3_Pos  = 0x19      // Position of TEIF3 field.
	DMA_LISR_TEIF3_Msk  = 0x2000000 // Bit mask of TEIF3 field.
	DMA_LISR_TEIF3      = 0x2000000 // Bit TEIF3.
	DMA_LISR_DMEIF3_Pos = 0x18      // Position of DMEIF3 field.
	DMA_LISR_DMEIF3_Msk = 0x1000000 // Bit mask of DMEIF3 field.
	DMA_LISR_DMEIF3     = 0x1000000 // Bit DMEIF3.
	DMA_LISR_FEIF3_Pos  = 0x16      // Position of FEIF3 field.
	DMA_LISR_FEIF3_Msk  = 0x400000  // Bit mask of FEIF3 field.
	DMA_LISR_FEIF3      = 0x400000  // Bit FEIF3.
	DMA_LISR_TCIF2_Pos  = 0x15      // Position of TCIF2 field.
	DMA_LISR_TCIF2_Msk  = 0x200000  // Bit mask of TCIF2 field.
	DMA_LISR_TCIF2      = 0x200000  // Bit TCIF2.
	DMA_LISR_HTIF2_Pos  = 0x14      // Position of HTIF2 field.
	DMA_LISR_HTIF2_Msk  = 0x100000  // Bit mask of HTIF2 field.
	DMA_LISR_HTIF2      = 0x100000  // Bit HTIF2.
	DMA_LISR_TEIF2_Pos  = 0x13      // Position of TEIF2 field.
	DMA_LISR_TEIF2_Msk  = 0x80000   // Bit mask of TEIF2 field.
	DMA_LISR_TEIF2      = 0x80000   // Bit TEIF2.
	DMA_LISR_DMEIF2_Pos = 0x12      // Position of DMEIF2 field.
	DMA_LISR_DMEIF2_Msk = 0x40000   // Bit mask of DMEIF2 field.
	DMA_LISR_DMEIF2     = 0x40000   // Bit DMEIF2.
	DMA_LISR_FEIF2_Pos  = 0x10      // Position of FEIF2 field.
	DMA_LISR_FEIF2_Msk  = 0x10000   // Bit mask of FEIF2 field.
	DMA_LISR_FEIF2      = 0x10000   // Bit FEIF2.
	DMA_LISR_TCIF1_Pos  = 0xb       // Position of TCIF1 field.
	DMA_LISR_TCIF1_Msk  = 0x800     // Bit mask of TCIF1 field.
	DMA_LISR_TCIF1      = 0x800     // Bit TCIF1.
	DMA_LISR_HTIF1_Pos  = 0xa       // Position of HTIF1 field.
	DMA_LISR_HTIF1_Msk  = 0x400     // Bit mask of HTIF1 field.
	DMA_LISR_HTIF1      = 0x400     // Bit HTIF1.
	DMA_LISR_TEIF1_Pos  = 0x9       // Position of TEIF1 field.
	DMA_LISR_TEIF1_Msk  = 0x200     // Bit mask of TEIF1 field.
	DMA_LISR_TEIF1      = 0x200     // Bit TEIF1.
	DMA_LISR_DMEIF1_Pos = 0x8       // Position of DMEIF1 field.
	DMA_LISR_DMEIF1_Msk = 0x100     // Bit mask of DMEIF1 field.
	DMA_LISR_DMEIF1     = 0x100     // Bit DMEIF1.
	DMA_LISR_FEIF1_Pos  = 0x6       // Position of FEIF1 field.
	DMA_LISR_FEIF1_Msk  = 0x40      // Bit mask of FEIF1 field.
	DMA_LISR_FEIF1      = 0x40      // Bit FEIF1.
	DMA_LISR_TCIF0_Pos  = 0x5       // Position of TCIF0 field.
	DMA_LISR_TCIF0_Msk  = 0x20      // Bit mask of TCIF0 field.
	DMA_LISR_TCIF0      = 0x20      // Bit TCIF0.
	DMA_LISR_HTIF0_Pos  = 0x4       // Position of HTIF0 field.
	DMA_LISR_HTIF0_Msk  = 0x10      // Bit mask of HTIF0 field.
	DMA_LISR_HTIF0      = 0x10      // Bit HTIF0.
	DMA_LISR_TEIF0_Pos  = 0x3       // Position of TEIF0 field.
	DMA_LISR_TEIF0_Msk  = 0x8       // Bit mask of TEIF0 field.
	DMA_LISR_TEIF0      = 0x8       // Bit TEIF0.
	DMA_LISR_DMEIF0_Pos = 0x2       // Position of DMEIF0 field.
	DMA_LISR_DMEIF0_Msk = 0x4       // Bit mask of DMEIF0 field.
	DMA_LISR_DMEIF0     = 0x4       // Bit DMEIF0.
	DMA_LISR_FEIF0_Pos  = 0x0       // Position of FEIF0 field.
	DMA_LISR_FEIF0_Msk  = 0x1       // Bit mask of FEIF0 field.
	DMA_LISR_FEIF0      = 0x1       // Bit FEIF0.

	// HISR: high interrupt status register
	DMA_HISR_TCIF7_Pos  = 0x1b      // Position of TCIF7 field.
	DMA_HISR_TCIF7_Msk  = 0x8000000 // Bit mask of TCIF7 field.
	DMA_HISR_TCIF7      = 0x8000000 // Bit TCIF7.
	DMA_HISR_HTIF7_Pos  = 0x1a      // Position of HTIF7 field.
	DMA_HISR_HTIF7_Msk  = 0x4000000 // Bit mask of HTIF7 field.
	DMA_HISR_HTIF7      = 0x4000000 // Bit HTIF7.
	DMA_HISR_TEIF7_Pos  = 0x19      // Position of TEIF7 field.
	DMA_HISR_TEIF7_Msk  = 0x2000000 // Bit mask of TEIF7 field.
	DMA_HISR_TEIF7      = 0x2000000 // Bit TEIF7.
	DMA_HISR_DMEIF7_Pos = 0x18      // Position of DMEIF7 field.
	DMA_HISR_DMEIF7_Msk = 0x1000000 // Bit mask of DMEIF7 field.
	DMA_HISR_DMEIF7     = 0x1000000 // Bit DMEIF7.
	DMA_HISR_FEIF7_Pos  = 0x16      // Position of FEIF7 field.
	DMA_HISR_FEIF7_Msk  = 0x400000  // Bit mask of FEIF7 field.
	DMA_HISR_FEIF7      = 0x400000  // Bit FEIF7.
	DMA_HISR_TCIF6_Pos  = 0x15      // Position of TCIF6 field.
	DMA_HISR_TCIF6_Msk  = 0x200000  // Bit mask of TCIF6 field.
	DMA_HISR_TCIF6      = 0x200000  // Bit TCIF6.
	DMA_HISR_HTIF6_Pos  = 0x14      // Position of HTIF6 field.
	DMA_HISR_HTIF6_Msk  = 0x100000  // Bit mask of HTIF6 field.
	DMA_HISR_HTIF6      = 0x100000  // Bit HTIF6.
	DMA_HISR_TEIF6_Pos  = 0x13      // Position of TEIF6 field.
	DMA_HISR_TEIF6_Msk  = 0x80000   // Bit mask of TEIF6 field.
	DMA_HISR_TEIF6      = 0x80000   // Bit TEIF6.
	DMA_HISR_DMEIF6_Pos = 0x12      // Position of DMEIF6 field.
	DMA_HISR_DMEIF6_Msk = 0x40000   // Bit mask of DMEIF6 field.
	DMA_HISR_DMEIF6     = 0x40000   // Bit DMEIF6.
	DMA_HISR_FEIF6_Pos  = 0x10      // Position of FEIF6 field.
	DMA_HISR_FEIF6_Msk  = 0x10000   // Bit mask of FEIF6 field.
	DMA_HISR_FEIF6      = 0x10000   // Bit FEIF6.
	DMA_HISR_TCIF5_Pos  = 0xb       // Position of TCIF5 field.
	DMA_HISR_TCIF5_Msk  = 0x800     // Bit mask of TCIF5 field.
	DMA_HISR_TCIF5      = 0x800     // Bit TCIF5.
	DMA_HISR_HTIF5_Pos  = 0xa       // Position of HTIF5 field.
	DMA_HISR_HTIF5_Msk  = 0x400     // Bit mask of HTIF5 field.
	DMA_HISR_HTIF5      = 0x400     // Bit HTIF5.
	DMA_HISR_TEIF5_Pos  = 0x9       // Position of TEIF5 field.
	DMA_HISR_TEIF5_Msk  = 0x200     // Bit mask of TEIF5 field.
	DMA_HISR_TEIF5      = 0x200     // Bit TEIF5.
	DMA_HISR_DMEIF5_Pos = 0x8       // Position of DMEIF5 field.
	DMA_HISR_DMEIF5_Msk = 0x100     // Bit mask of DMEIF5 field.
	DMA_HISR_DMEIF5     = 0x100     // Bit DMEIF5.
	DMA_HISR_FEIF5_Pos  = 0x6       // Position of FEIF5 field.
	DMA_HISR_FEIF5_Msk  = 0x40      // Bit mask of FEIF5 field.
	DMA_HISR_FEIF5      = 0x40      // Bit FEIF5.
	DMA_HISR_TCIF4_Pos  = 0x5       // Position of TCIF4 field.
	DMA_HISR_TCIF4_Msk  = 0x20      // Bit mask of TCIF4 field.
	DMA_HISR_TCIF4      = 0x20      // Bit TCIF4.
	DMA_HISR_HTIF4_Pos  = 0x4       // Position of HTIF4 field.
	DMA_HISR_HTIF4_Msk  = 0x10      // Bit mask of HTIF4 field.
	DMA_HISR_HTIF4      = 0x10      // Bit HTIF4.
	DMA_HISR_TEIF4_Pos  = 0x3       // Position of TEIF4 field.
	DMA_HISR_TEIF4_Msk  = 0x8       // Bit mask of TEIF4 field.
	DMA_HISR_TEIF4      = 0x8       // Bit TEIF4.
	DMA_HISR_DMEIF4_Pos = 0x2       // Position of DMEIF4 field.
	DMA_HISR_DMEIF4_Msk = 0x4       // Bit mask of DMEIF4 field.
	DMA_HISR_DMEIF4     = 0x4       // Bit DMEIF4.
	DMA_HISR_FEIF4_Pos  = 0x0       // Position of FEIF4 field.
	DMA_HISR_FEIF4_Msk  = 0x1       // Bit mask of FEIF4 field.
	DMA_HISR_FEIF4      = 0x1       // Bit FEIF4.

	// LIFCR: low interrupt flag clear           register
	DMA_LIFCR_CTCIF3_Pos  = 0x1b      // Position of CTCIF3 field.
	DMA_LIFCR_CTCIF3_Msk  = 0x8000000 // Bit mask of CTCIF3 field.
	DMA_LIFCR_CTCIF3      = 0x8000000 // Bit CTCIF3.
	DMA_LIFCR_CHTIF3_Pos  = 0x1a      // Position of CHTIF3 field.
	DMA_LIFCR_CHTIF3_Msk  = 0x4000000 // Bit mask of CHTIF3 field.
	DMA_LIFCR_CHTIF3      = 0x4000000 // Bit CHTIF3.
	DMA_LIFCR_CTEIF3_Pos  = 0x19      // Position of CTEIF3 field.
	DMA_LIFCR_CTEIF3_Msk  = 0x2000000 // Bit mask of CTEIF3 field.
	DMA_LIFCR_CTEIF3      = 0x2000000 // Bit CTEIF3.
	DMA_LIFCR_CDMEIF3_Pos = 0x18      // Position of CDMEIF3 field.
	DMA_LIFCR_CDMEIF3_Msk = 0x1000000 // Bit mask of CDMEIF3 field.
	DMA_LIFCR_CDMEIF3     = 0x1000000 // Bit CDMEIF3.
	DMA_LIFCR_CFEIF3_Pos  = 0x16      // Position of CFEIF3 field.
	DMA_LIFCR_CFEIF3_Msk  = 0x400000  // Bit mask of CFEIF3 field.
	DMA_LIFCR_CFEIF3      = 0x400000  // Bit CFEIF3.
	DMA_LIFCR_CTCIF2_Pos  = 0x15      // Position of CTCIF2 field.
	DMA_LIFCR_CTCIF2_Msk  = 0x200000  // Bit mask of CTCIF2 field.
	DMA_LIFCR_CTCIF2      = 0x200000  // Bit CTCIF2.
	DMA_LIFCR_CHTIF2_Pos  = 0x14      // Position of CHTIF2 field.
	DMA_LIFCR_CHTIF2_Msk  = 0x100000  // Bit mask of CHTIF2 field.
	DMA_LIFCR_CHTIF2      = 0x100000  // Bit CHTIF2.
	DMA_LIFCR_CTEIF2_Pos  = 0x13      // Position of CTEIF2 field.
	DMA_LIFCR_CTEIF2_Msk  = 0x80000   // Bit mask of CTEIF2 field.
	DMA_LIFCR_CTEIF2      = 0x80000   // Bit CTEIF2.
	DMA_LIFCR_CDMEIF2_Pos = 0x12      // Position of CDMEIF2 field.
	DMA_LIFCR_CDMEIF2_Msk = 0x40000   // Bit mask of CDMEIF2 field.
	DMA_LIFCR_CDMEIF2     = 0x40000   // Bit CDMEIF2.
	DMA_LIFCR_CFEIF2_Pos  = 0x10      // Position of CFEIF2 field.
	DMA_LIFCR_CFEIF2_Msk  = 0x10000   // Bit mask of CFEIF2 field.
	DMA_LIFCR_CFEIF2      = 0x10000   // Bit CFEIF2.
	DMA_LIFCR_CTCIF1_Pos  = 0xb       // Position of CTCIF1 field.
	DMA_LIFCR_CTCIF1_Msk  = 0x800     // Bit mask of CTCIF1 field.
	DMA_LIFCR_CTCIF1      = 0x800     // Bit CTCIF1.
	DMA_LIFCR_CHTIF1_Pos  = 0xa       // Position of CHTIF1 field.
	DMA_LIFCR_CHTIF1_Msk  = 0x400     // Bit mask of CHTIF1 field.
	DMA_LIFCR_CHTIF1      = 0x400     // Bit CHTIF1.
	DMA_LIFCR_CTEIF1_Pos  = 0x9       // Position of CTEIF1 field.
	DMA_LIFCR_CTEIF1_Msk  = 0x200     // Bit mask of CTEIF1 field.
	DMA_LIFCR_CTEIF1      = 0x200     // Bit CTEIF1.
	DMA_LIFCR_CDMEIF1_Pos = 0x8       // Position of CDMEIF1 field.
	DMA_LIFCR_CDMEIF1_Msk = 0x100     // Bit mask of CDMEIF1 field.
	DMA_LIFCR_CDMEIF1     = 0x100     // Bit CDMEIF1.
	DMA_LIFCR_CFEIF1_Pos  = 0x6       // Position of CFEIF1 field.
	DMA_LIFCR_CFEIF1_Msk  = 0x40      // Bit mask of CFEIF1 field.
	DMA_LIFCR_CFEIF1      = 0x40      // Bit CFEIF1.
	DMA_LIFCR_CTCIF0_Pos  = 0x5       // Position of CTCIF0 field.
	DMA_LIFCR_CTCIF0_Msk  = 0x20      // Bit mask of CTCIF0 field.
	DMA_LIFCR_CTCIF0      = 0x20      // Bit CTCIF0.
	DMA_LIFCR_CHTIF0_Pos  = 0x4       // Position of CHTIF0 field.
	DMA_LIFCR_CHTIF0_Msk  = 0x10      // Bit mask of CHTIF0 field.
	DMA_LIFCR_CHTIF0      = 0x10      // Bit CHTIF0.
	DMA_LIFCR_CTEIF0_Pos  = 0x3       // Position of CTEIF0 field.
	DMA_LIFCR_CTEIF0_Msk  = 0x8       // Bit mask of CTEIF0 field.
	DMA_LIFCR_CTEIF0      = 0x8       // Bit CTEIF0.
	DMA_LIFCR_CDMEIF0_Pos = 0x2       // Position of CDMEIF0 field.
	DMA_LIFCR_CDMEIF0_Msk = 0x4       // Bit mask of CDMEIF0 field.
	DMA_LIFCR_CDMEIF0     = 0x4       // Bit CDMEIF0.
	DMA_LIFCR_CFEIF0_Pos  = 0x0       // Position of CFEIF0 field.
	DMA_LIFCR_CFEIF0_Msk  = 0x1       // Bit mask of CFEIF0 field.
	DMA_LIFCR_CFEIF0      = 0x1       // Bit CFEIF0.

	// HIFCR: high interrupt flag clear           register
	DMA_HIFCR_CTCIF7_Pos  = 0x1b      // Position of CTCIF7 field.
	DMA_HIFCR_CTCIF7_Msk  = 0x8000000 // Bit mask of CTCIF7 field.
	DMA_HIFCR_CTCIF7      = 0x8000000 // Bit CTCIF7.
	DMA_HIFCR_CHTIF7_Pos  = 0x1a      // Position of CHTIF7 field.
	DMA_HIFCR_CHTIF7_Msk  = 0x4000000 // Bit mask of CHTIF7 field.
	DMA_HIFCR_CHTIF7      = 0x4000000 // Bit CHTIF7.
	DMA_HIFCR_CTEIF7_Pos  = 0x19      // Position of CTEIF7 field.
	DMA_HIFCR_CTEIF7_Msk  = 0x2000000 // Bit mask of CTEIF7 field.
	DMA_HIFCR_CTEIF7      = 0x2000000 // Bit CTEIF7.
	DMA_HIFCR_CDMEIF7_Pos = 0x18      // Position of CDMEIF7 field.
	DMA_HIFCR_CDMEIF7_Msk = 0x1000000 // Bit mask of CDMEIF7 field.
	DMA_HIFCR_CDMEIF7     = 0x1000000 // Bit CDMEIF7.
	DMA_HIFCR_CFEIF7_Pos  = 0x16      // Position of CFEIF7 field.
	DMA_HIFCR_CFEIF7_Msk  = 0x400000  // Bit mask of CFEIF7 field.
	DMA_HIFCR_CFEIF7      = 0x400000  // Bit CFEIF7.
	DMA_HIFCR_CTCIF6_Pos  = 0x15      // Position of CTCIF6 field.
	DMA_HIFCR_CTCIF6_Msk  = 0x200000  // Bit mask of CTCIF6 field.
	DMA_HIFCR_CTCIF6      = 0x200000  // Bit CTCIF6.
	DMA_HIFCR_CHTIF6_Pos  = 0x14      // Position of CHTIF6 field.
	DMA_HIFCR_CHTIF6_Msk  = 0x100000  // Bit mask of CHTIF6 field.
	DMA_HIFCR_CHTIF6      = 0x100000  // Bit CHTIF6.
	DMA_HIFCR_CTEIF6_Pos  = 0x13      // Position of CTEIF6 field.
	DMA_HIFCR_CTEIF6_Msk  = 0x80000   // Bit mask of CTEIF6 field.
	DMA_HIFCR_CTEIF6      = 0x80000   // Bit CTEIF6.
	DMA_HIFCR_CDMEIF6_Pos = 0x12      // Position of CDMEIF6 field.
	DMA_HIFCR_CDMEIF6_Msk = 0x40000   // Bit mask of CDMEIF6 field.
	DMA_HIFCR_CDMEIF6     = 0x40000   // Bit CDMEIF6.
	DMA_HIFCR_CFEIF6_Pos  = 0x10      // Position of CFEIF6 field.
	DMA_HIFCR_CFEIF6_Msk  = 0x10000   // Bit mask of CFEIF6 field.
	DMA_HIFCR_CFEIF6      = 0x10000   // Bit CFEIF6.
	DMA_HIFCR_CTCIF5_Pos  = 0xb       // Position of CTCIF5 field.
	DMA_HIFCR_CTCIF5_Msk  = 0x800     // Bit mask of CTCIF5 field.
	DMA_HIFCR_CTCIF5      = 0x800     // Bit CTCIF5.
	DMA_HIFCR_CHTIF5_Pos  = 0xa       // Position of CHTIF5 field.
	DMA_HIFCR_CHTIF5_Msk  = 0x400     // Bit mask of CHTIF5 field.
	DMA_HIFCR_CHTIF5      = 0x400     // Bit CHTIF5.
	DMA_HIFCR_CTEIF5_Pos  = 0x9       // Position of CTEIF5 field.
	DMA_HIFCR_CTEIF5_Msk  = 0x200     // Bit mask of CTEIF5 field.
	DMA_HIFCR_CTEIF5      = 0x200     // Bit CTEIF5.
	DMA_HIFCR_CDMEIF5_Pos = 0x8       // Position of CDMEIF5 field.
	DMA_HIFCR_CDMEIF5_Msk = 0x100     // Bit mask of CDMEIF5 field.
	DMA_HIFCR_CDMEIF5     = 0x100     // Bit CDMEIF5.
	DMA_HIFCR_CFEIF5_Pos  = 0x6       // Position of CFEIF5 field.
	DMA_HIFCR_CFEIF5_Msk  = 0x40      // Bit mask of CFEIF5 field.
	DMA_HIFCR_CFEIF5      = 0x40      // Bit CFEIF5.
	DMA_HIFCR_CTCIF4_Pos  = 0x5       // Position of CTCIF4 field.
	DMA_HIFCR_CTCIF4_Msk  = 0x20      // Bit mask of CTCIF4 field.
	DMA_HIFCR_CTCIF4      = 0x20      // Bit CTCIF4.
	DMA_HIFCR_CHTIF4_Pos  = 0x4       // Position of CHTIF4 field.
	DMA_HIFCR_CHTIF4_Msk  = 0x10      // Bit mask of CHTIF4 field.
	DMA_HIFCR_CHTIF4      = 0x10      // Bit CHTIF4.
	DMA_HIFCR_CTEIF4_Pos  = 0x3       // Position of CTEIF4 field.
	DMA_HIFCR_CTEIF4_Msk  = 0x8       // Bit mask of CTEIF4 field.
	DMA_HIFCR_CTEIF4      = 0x8       // Bit CTEIF4.
	DMA_HIFCR_CDMEIF4_Pos = 0x2       // Position of CDMEIF4 field.
	DMA_HIFCR_CDMEIF4_Msk = 0x4       // Bit mask of CDMEIF4 field.
	DMA_HIFCR_CDMEIF4     = 0x4       // Bit CDMEIF4.
	DMA_HIFCR_CFEIF4_Pos  = 0x0       // Position of CFEIF4 field.
	DMA_HIFCR_CFEIF4_Msk  = 0x1       // Bit mask of CFEIF4 field.
	DMA_HIFCR_CFEIF4      = 0x1       // Bit CFEIF4.

	// S0CR: stream x configuration           register
	DMA_S0CR_CHSEL_Pos  = 0x19       // Position of CHSEL field.
	DMA_S0CR_CHSEL_Msk  = 0x1e000000 // Bit mask of CHSEL field.
	DMA_S0CR_MBURST_Pos = 0x17       // Position of MBURST field.
	DMA_S0CR_MBURST_Msk = 0x1800000  // Bit mask of MBURST field.
	DMA_S0CR_PBURST_Pos = 0x15       // Position of PBURST field.
	DMA_S0CR_PBURST_Msk = 0x600000   // Bit mask of PBURST field.
	DMA_S0CR_CT_Pos     = 0x13       // Position of CT field.
	DMA_S0CR_CT_Msk     = 0x80000    // Bit mask of CT field.
	DMA_S0CR_CT         = 0x80000    // Bit CT.
	DMA_S0CR_DBM_Pos    = 0x12       // Position of DBM field.
	DMA_S0CR_DBM_Msk    = 0x40000    // Bit mask of DBM field.
	DMA_S0CR_DBM        = 0x40000    // Bit DBM.
	DMA_S0CR_PL_Pos     = 0x10       // Position of PL field.
	DMA_S0CR_PL_Msk     = 0x30000    // Bit mask of PL field.
	DMA_S0CR_PINCOS_Pos = 0xf        // Position of PINCOS field.
	DMA_S0CR_PINCOS_Msk = 0x8000     // Bit mask of PINCOS field.
	DMA_S0CR_PINCOS     = 0x8000     // Bit PINCOS.
	DMA_S0CR_MSIZE_Pos  = 0xd        // Position of MSIZE field.
	DMA_S0CR_MSIZE_Msk  = 0x6000     // Bit mask of MSIZE field.
	DMA_S0CR_PSIZE_Pos  = 0xb        // Position of PSIZE field.
	DMA_S0CR_PSIZE_Msk  = 0x1800     // Bit mask of PSIZE field.
	DMA_S0CR_MINC_Pos   = 0xa        // Position of MINC field.
	DMA_S0CR_MINC_Msk   = 0x400      // Bit mask of MINC field.
	DMA_S0CR_MINC       = 0x400      // Bit MINC.
	DMA_S0CR_PINC_Pos   = 0x9        // Position of PINC field.
	DMA_S0CR_PINC_Msk   = 0x200      // Bit mask of PINC field.
	DMA_S0CR_PINC       = 0x200      // Bit PINC.
	DMA_S0CR_CIRC_Pos   = 0x8        // Position of CIRC field.
	DMA_S0CR_CIRC_Msk   = 0x100      // Bit mask of CIRC field.
	DMA_S0CR_CIRC       = 0x100      // Bit CIRC.
	DMA_S0CR_DIR_Pos    = 0x6        // Position of DIR field.
	DMA_S0CR_DIR_Msk    = 0xc0       // Bit mask of DIR field.
	DMA_S0CR_PFCTRL_Pos = 0x5        // Position of PFCTRL field.
	DMA_S0CR_PFCTRL_Msk = 0x20       // Bit mask of PFCTRL field.
	DMA_S0CR_PFCTRL     = 0x20       // Bit PFCTRL.
	DMA_S0CR_TCIE_Pos   = 0x4        // Position of TCIE field.
	DMA_S0CR_TCIE_Msk   = 0x10       // Bit mask of TCIE field.
	DMA_S0CR_TCIE       = 0x10       // Bit TCIE.
	DMA_S0CR_HTIE_Pos   = 0x3        // Position of HTIE field.
	DMA_S0CR_HTIE_Msk   = 0x8        // Bit mask of HTIE field.
	DMA_S0CR_HTIE       = 0x8        // Bit HTIE.
	DMA_S0CR_TEIE_Pos   = 0x2        // Position of TEIE field.
	DMA_S0CR_TEIE_Msk   = 0x4        // Bit mask of TEIE field.
	DMA_S0CR_TEIE       = 0x4        // Bit TEIE.
	DMA_S0CR_DMEIE_Pos  = 0x1        // Position of DMEIE field.
	DMA_S0CR_DMEIE_Msk  = 0x2        // Bit mask of DMEIE field.
	DMA_S0CR_DMEIE      = 0x2        // Bit DMEIE.
	DMA_S0CR_EN_Pos     = 0x0        // Position of EN field.
	DMA_S0CR_EN_Msk     = 0x1        // Bit mask of EN field.
	DMA_S0CR_EN         = 0x1        // Bit EN.

	// S0NDTR: stream x number of data           register
	DMA_S0NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S0NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S0PAR: stream x peripheral address           register
	DMA_S0PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S0PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S0M0AR: stream x memory 0 address           register
	DMA_S0M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S0M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S0M1AR: stream x memory 1 address           register
	DMA_S0M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S0M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S0FCR: stream x FIFO control register
	DMA_S0FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S0FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S0FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S0FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S0FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S0FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S0FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S0FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S0FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S0FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S1CR: stream x configuration           register
	DMA_S1CR_CHSEL_Pos  = 0x19       // Position of CHSEL field.
	DMA_S1CR_CHSEL_Msk  = 0x1e000000 // Bit mask of CHSEL field.
	DMA_S1CR_MBURST_Pos = 0x17       // Position of MBURST field.
	DMA_S1CR_MBURST_Msk = 0x1800000  // Bit mask of MBURST field.
	DMA_S1CR_PBURST_Pos = 0x15       // Position of PBURST field.
	DMA_S1CR_PBURST_Msk = 0x600000   // Bit mask of PBURST field.
	DMA_S1CR_ACK_Pos    = 0x14       // Position of ACK field.
	DMA_S1CR_ACK_Msk    = 0x100000   // Bit mask of ACK field.
	DMA_S1CR_ACK        = 0x100000   // Bit ACK.
	DMA_S1CR_CT_Pos     = 0x13       // Position of CT field.
	DMA_S1CR_CT_Msk     = 0x80000    // Bit mask of CT field.
	DMA_S1CR_CT         = 0x80000    // Bit CT.
	DMA_S1CR_DBM_Pos    = 0x12       // Position of DBM field.
	DMA_S1CR_DBM_Msk    = 0x40000    // Bit mask of DBM field.
	DMA_S1CR_DBM        = 0x40000    // Bit DBM.
	DMA_S1CR_PL_Pos     = 0x10       // Position of PL field.
	DMA_S1CR_PL_Msk     = 0x30000    // Bit mask of PL field.
	DMA_S1CR_PINCOS_Pos = 0xf        // Position of PINCOS field.
	DMA_S1CR_PINCOS_Msk = 0x8000     // Bit mask of PINCOS field.
	DMA_S1CR_PINCOS     = 0x8000     // Bit PINCOS.
	DMA_S1CR_MSIZE_Pos  = 0xd        // Position of MSIZE field.
	DMA_S1CR_MSIZE_Msk  = 0x6000     // Bit mask of MSIZE field.
	DMA_S1CR_PSIZE_Pos  = 0xb        // Position of PSIZE field.
	DMA_S1CR_PSIZE_Msk  = 0x1800     // Bit mask of PSIZE field.
	DMA_S1CR_MINC_Pos   = 0xa        // Position of MINC field.
	DMA_S1CR_MINC_Msk   = 0x400      // Bit mask of MINC field.
	DMA_S1CR_MINC       = 0x400      // Bit MINC.
	DMA_S1CR_PINC_Pos   = 0x9        // Position of PINC field.
	DMA_S1CR_PINC_Msk   = 0x200      // Bit mask of PINC field.
	DMA_S1CR_PINC       = 0x200      // Bit PINC.
	DMA_S1CR_CIRC_Pos   = 0x8        // Position of CIRC field.
	DMA_S1CR_CIRC_Msk   = 0x100      // Bit mask of CIRC field.
	DMA_S1CR_CIRC       = 0x100      // Bit CIRC.
	DMA_S1CR_DIR_Pos    = 0x6        // Position of DIR field.
	DMA_S1CR_DIR_Msk    = 0xc0       // Bit mask of DIR field.
	DMA_S1CR_PFCTRL_Pos = 0x5        // Position of PFCTRL field.
	DMA_S1CR_PFCTRL_Msk = 0x20       // Bit mask of PFCTRL field.
	DMA_S1CR_PFCTRL     = 0x20       // Bit PFCTRL.
	DMA_S1CR_TCIE_Pos   = 0x4        // Position of TCIE field.
	DMA_S1CR_TCIE_Msk   = 0x10       // Bit mask of TCIE field.
	DMA_S1CR_TCIE       = 0x10       // Bit TCIE.
	DMA_S1CR_HTIE_Pos   = 0x3        // Position of HTIE field.
	DMA_S1CR_HTIE_Msk   = 0x8        // Bit mask of HTIE field.
	DMA_S1CR_HTIE       = 0x8        // Bit HTIE.
	DMA_S1CR_TEIE_Pos   = 0x2        // Position of TEIE field.
	DMA_S1CR_TEIE_Msk   = 0x4        // Bit mask of TEIE field.
	DMA_S1CR_TEIE       = 0x4        // Bit TEIE.
	DMA_S1CR_DMEIE_Pos  = 0x1        // Position of DMEIE field.
	DMA_S1CR_DMEIE_Msk  = 0x2        // Bit mask of DMEIE field.
	DMA_S1CR_DMEIE      = 0x2        // Bit DMEIE.
	DMA_S1CR_EN_Pos     = 0x0        // Position of EN field.
	DMA_S1CR_EN_Msk     = 0x1        // Bit mask of EN field.
	DMA_S1CR_EN         = 0x1        // Bit EN.

	// S1NDTR: stream x number of data           register
	DMA_S1NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S1NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S1PAR: stream x peripheral address           register
	DMA_S1PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S1PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S1M0AR: stream x memory 0 address           register
	DMA_S1M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S1M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S1M1AR: stream x memory 1 address           register
	DMA_S1M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S1M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S1FCR: stream x FIFO control register
	DMA_S1FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S1FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S1FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S1FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S1FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S1FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S1FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S1FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S1FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S1FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S2CR: stream x configuration           register
	DMA_S2CR_CHSEL_Pos  = 0x19       // Position of CHSEL field.
	DMA_S2CR_CHSEL_Msk  = 0x1e000000 // Bit mask of CHSEL field.
	DMA_S2CR_MBURST_Pos = 0x17       // Position of MBURST field.
	DMA_S2CR_MBURST_Msk = 0x1800000  // Bit mask of MBURST field.
	DMA_S2CR_PBURST_Pos = 0x15       // Position of PBURST field.
	DMA_S2CR_PBURST_Msk = 0x600000   // Bit mask of PBURST field.
	DMA_S2CR_ACK_Pos    = 0x14       // Position of ACK field.
	DMA_S2CR_ACK_Msk    = 0x100000   // Bit mask of ACK field.
	DMA_S2CR_ACK        = 0x100000   // Bit ACK.
	DMA_S2CR_CT_Pos     = 0x13       // Position of CT field.
	DMA_S2CR_CT_Msk     = 0x80000    // Bit mask of CT field.
	DMA_S2CR_CT         = 0x80000    // Bit CT.
	DMA_S2CR_DBM_Pos    = 0x12       // Position of DBM field.
	DMA_S2CR_DBM_Msk    = 0x40000    // Bit mask of DBM field.
	DMA_S2CR_DBM        = 0x40000    // Bit DBM.
	DMA_S2CR_PL_Pos     = 0x10       // Position of PL field.
	DMA_S2CR_PL_Msk     = 0x30000    // Bit mask of PL field.
	DMA_S2CR_PINCOS_Pos = 0xf        // Position of PINCOS field.
	DMA_S2CR_PINCOS_Msk = 0x8000     // Bit mask of PINCOS field.
	DMA_S2CR_PINCOS     = 0x8000     // Bit PINCOS.
	DMA_S2CR_MSIZE_Pos  = 0xd        // Position of MSIZE field.
	DMA_S2CR_MSIZE_Msk  = 0x6000     // Bit mask of MSIZE field.
	DMA_S2CR_PSIZE_Pos  = 0xb        // Position of PSIZE field.
	DMA_S2CR_PSIZE_Msk  = 0x1800     // Bit mask of PSIZE field.
	DMA_S2CR_MINC_Pos   = 0xa        // Position of MINC field.
	DMA_S2CR_MINC_Msk   = 0x400      // Bit mask of MINC field.
	DMA_S2CR_MINC       = 0x400      // Bit MINC.
	DMA_S2CR_PINC_Pos   = 0x9        // Position of PINC field.
	DMA_S2CR_PINC_Msk   = 0x200      // Bit mask of PINC field.
	DMA_S2CR_PINC       = 0x200      // Bit PINC.
	DMA_S2CR_CIRC_Pos   = 0x8        // Position of CIRC field.
	DMA_S2CR_CIRC_Msk   = 0x100      // Bit mask of CIRC field.
	DMA_S2CR_CIRC       = 0x100      // Bit CIRC.
	DMA_S2CR_DIR_Pos    = 0x6        // Position of DIR field.
	DMA_S2CR_DIR_Msk    = 0xc0       // Bit mask of DIR field.
	DMA_S2CR_PFCTRL_Pos = 0x5        // Position of PFCTRL field.
	DMA_S2CR_PFCTRL_Msk = 0x20       // Bit mask of PFCTRL field.
	DMA_S2CR_PFCTRL     = 0x20       // Bit PFCTRL.
	DMA_S2CR_TCIE_Pos   = 0x4        // Position of TCIE field.
	DMA_S2CR_TCIE_Msk   = 0x10       // Bit mask of TCIE field.
	DMA_S2CR_TCIE       = 0x10       // Bit TCIE.
	DMA_S2CR_HTIE_Pos   = 0x3        // Position of HTIE field.
	DMA_S2CR_HTIE_Msk   = 0x8        // Bit mask of HTIE field.
	DMA_S2CR_HTIE       = 0x8        // Bit HTIE.
	DMA_S2CR_TEIE_Pos   = 0x2        // Position of TEIE field.
	DMA_S2CR_TEIE_Msk   = 0x4        // Bit mask of TEIE field.
	DMA_S2CR_TEIE       = 0x4        // Bit TEIE.
	DMA_S2CR_DMEIE_Pos  = 0x1        // Position of DMEIE field.
	DMA_S2CR_DMEIE_Msk  = 0x2        // Bit mask of DMEIE field.
	DMA_S2CR_DMEIE      = 0x2        // Bit DMEIE.
	DMA_S2CR_EN_Pos     = 0x0        // Position of EN field.
	DMA_S2CR_EN_Msk     = 0x1        // Bit mask of EN field.
	DMA_S2CR_EN         = 0x1        // Bit EN.

	// S2NDTR: stream x number of data           register
	DMA_S2NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S2NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S2PAR: stream x peripheral address           register
	DMA_S2PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S2PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S2M0AR: stream x memory 0 address           register
	DMA_S2M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S2M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S2M1AR: stream x memory 1 address           register
	DMA_S2M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S2M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S2FCR: stream x FIFO control register
	DMA_S2FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S2FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S2FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S2FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S2FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S2FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S2FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S2FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S2FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S2FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S3CR: stream x configuration           register
	DMA_S3CR_CHSEL_Pos  = 0x19       // Position of CHSEL field.
	DMA_S3CR_CHSEL_Msk  = 0x1e000000 // Bit mask of CHSEL field.
	DMA_S3CR_MBURST_Pos = 0x17       // Position of MBURST field.
	DMA_S3CR_MBURST_Msk = 0x1800000  // Bit mask of MBURST field.
	DMA_S3CR_PBURST_Pos = 0x15       // Position of PBURST field.
	DMA_S3CR_PBURST_Msk = 0x600000   // Bit mask of PBURST field.
	DMA_S3CR_ACK_Pos    = 0x14       // Position of ACK field.
	DMA_S3CR_ACK_Msk    = 0x100000   // Bit mask of ACK field.
	DMA_S3CR_ACK        = 0x100000   // Bit ACK.
	DMA_S3CR_CT_Pos     = 0x13       // Position of CT field.
	DMA_S3CR_CT_Msk     = 0x80000    // Bit mask of CT field.
	DMA_S3CR_CT         = 0x80000    // Bit CT.
	DMA_S3CR_DBM_Pos    = 0x12       // Position of DBM field.
	DMA_S3CR_DBM_Msk    = 0x40000    // Bit mask of DBM field.
	DMA_S3CR_DBM        = 0x40000    // Bit DBM.
	DMA_S3CR_PL_Pos     = 0x10       // Position of PL field.
	DMA_S3CR_PL_Msk     = 0x30000    // Bit mask of PL field.
	DMA_S3CR_PINCOS_Pos = 0xf        // Position of PINCOS field.
	DMA_S3CR_PINCOS_Msk = 0x8000     // Bit mask of PINCOS field.
	DMA_S3CR_PINCOS     = 0x8000     // Bit PINCOS.
	DMA_S3CR_MSIZE_Pos  = 0xd        // Position of MSIZE field.
	DMA_S3CR_MSIZE_Msk  = 0x6000     // Bit mask of MSIZE field.
	DMA_S3CR_PSIZE_Pos  = 0xb        // Position of PSIZE field.
	DMA_S3CR_PSIZE_Msk  = 0x1800     // Bit mask of PSIZE field.
	DMA_S3CR_MINC_Pos   = 0xa        // Position of MINC field.
	DMA_S3CR_MINC_Msk   = 0x400      // Bit mask of MINC field.
	DMA_S3CR_MINC       = 0x400      // Bit MINC.
	DMA_S3CR_PINC_Pos   = 0x9        // Position of PINC field.
	DMA_S3CR_PINC_Msk   = 0x200      // Bit mask of PINC field.
	DMA_S3CR_PINC       = 0x200      // Bit PINC.
	DMA_S3CR_CIRC_Pos   = 0x8        // Position of CIRC field.
	DMA_S3CR_CIRC_Msk   = 0x100      // Bit mask of CIRC field.
	DMA_S3CR_CIRC       = 0x100      // Bit CIRC.
	DMA_S3CR_DIR_Pos    = 0x6        // Position of DIR field.
	DMA_S3CR_DIR_Msk    = 0xc0       // Bit mask of DIR field.
	DMA_S3CR_PFCTRL_Pos = 0x5        // Position of PFCTRL field.
	DMA_S3CR_PFCTRL_Msk = 0x20       // Bit mask of PFCTRL field.
	DMA_S3CR_PFCTRL     = 0x20       // Bit PFCTRL.
	DMA_S3CR_TCIE_Pos   = 0x4        // Position of TCIE field.
	DMA_S3CR_TCIE_Msk   = 0x10       // Bit mask of TCIE field.
	DMA_S3CR_TCIE       = 0x10       // Bit TCIE.
	DMA_S3CR_HTIE_Pos   = 0x3        // Position of HTIE field.
	DMA_S3CR_HTIE_Msk   = 0x8        // Bit mask of HTIE field.
	DMA_S3CR_HTIE       = 0x8        // Bit HTIE.
	DMA_S3CR_TEIE_Pos   = 0x2        // Position of TEIE field.
	DMA_S3CR_TEIE_Msk   = 0x4        // Bit mask of TEIE field.
	DMA_S3CR_TEIE       = 0x4        // Bit TEIE.
	DMA_S3CR_DMEIE_Pos  = 0x1        // Position of DMEIE field.
	DMA_S3CR_DMEIE_Msk  = 0x2        // Bit mask of DMEIE field.
	DMA_S3CR_DMEIE      = 0x2        // Bit DMEIE.
	DMA_S3CR_EN_Pos     = 0x0        // Position of EN field.
	DMA_S3CR_EN_Msk     = 0x1        // Bit mask of EN field.
	DMA_S3CR_EN         = 0x1        // Bit EN.

	// S3NDTR: stream x number of data           register
	DMA_S3NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S3NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S3PAR: stream x peripheral address           register
	DMA_S3PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S3PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S3M0AR: stream x memory 0 address           register
	DMA_S3M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S3M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S3M1AR: stream x memory 1 address           register
	DMA_S3M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S3M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S3FCR: stream x FIFO control register
	DMA_S3FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S3FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S3FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S3FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S3FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S3FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S3FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S3FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S3FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S3FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S4CR: stream x configuration           register
	DMA_S4CR_CHSEL_Pos  = 0x19      // Position of CHSEL field.
	DMA_S4CR_CHSEL_Msk  = 0xe000000 // Bit mask of CHSEL field.
	DMA_S4CR_MBURST_Pos = 0x17      // Position of MBURST field.
	DMA_S4CR_MBURST_Msk = 0x1800000 // Bit mask of MBURST field.
	DMA_S4CR_PBURST_Pos = 0x15      // Position of PBURST field.
	DMA_S4CR_PBURST_Msk = 0x600000  // Bit mask of PBURST field.
	DMA_S4CR_ACK_Pos    = 0x14      // Position of ACK field.
	DMA_S4CR_ACK_Msk    = 0x100000  // Bit mask of ACK field.
	DMA_S4CR_ACK        = 0x100000  // Bit ACK.
	DMA_S4CR_CT_Pos     = 0x13      // Position of CT field.
	DMA_S4CR_CT_Msk     = 0x80000   // Bit mask of CT field.
	DMA_S4CR_CT         = 0x80000   // Bit CT.
	DMA_S4CR_DBM_Pos    = 0x12      // Position of DBM field.
	DMA_S4CR_DBM_Msk    = 0x40000   // Bit mask of DBM field.
	DMA_S4CR_DBM        = 0x40000   // Bit DBM.
	DMA_S4CR_PL_Pos     = 0x10      // Position of PL field.
	DMA_S4CR_PL_Msk     = 0x30000   // Bit mask of PL field.
	DMA_S4CR_PINCOS_Pos = 0xf       // Position of PINCOS field.
	DMA_S4CR_PINCOS_Msk = 0x8000    // Bit mask of PINCOS field.
	DMA_S4CR_PINCOS     = 0x8000    // Bit PINCOS.
	DMA_S4CR_MSIZE_Pos  = 0xd       // Position of MSIZE field.
	DMA_S4CR_MSIZE_Msk  = 0x6000    // Bit mask of MSIZE field.
	DMA_S4CR_PSIZE_Pos  = 0xb       // Position of PSIZE field.
	DMA_S4CR_PSIZE_Msk  = 0x1800    // Bit mask of PSIZE field.
	DMA_S4CR_MINC_Pos   = 0xa       // Position of MINC field.
	DMA_S4CR_MINC_Msk   = 0x400     // Bit mask of MINC field.
	DMA_S4CR_MINC       = 0x400     // Bit MINC.
	DMA_S4CR_PINC_Pos   = 0x9       // Position of PINC field.
	DMA_S4CR_PINC_Msk   = 0x200     // Bit mask of PINC field.
	DMA_S4CR_PINC       = 0x200     // Bit PINC.
	DMA_S4CR_CIRC_Pos   = 0x8       // Position of CIRC field.
	DMA_S4CR_CIRC_Msk   = 0x100     // Bit mask of CIRC field.
	DMA_S4CR_CIRC       = 0x100     // Bit CIRC.
	DMA_S4CR_DIR_Pos    = 0x6       // Position of DIR field.
	DMA_S4CR_DIR_Msk    = 0xc0      // Bit mask of DIR field.
	DMA_S4CR_PFCTRL_Pos = 0x5       // Position of PFCTRL field.
	DMA_S4CR_PFCTRL_Msk = 0x20      // Bit mask of PFCTRL field.
	DMA_S4CR_PFCTRL     = 0x20      // Bit PFCTRL.
	DMA_S4CR_TCIE_Pos   = 0x4       // Position of TCIE field.
	DMA_S4CR_TCIE_Msk   = 0x10      // Bit mask of TCIE field.
	DMA_S4CR_TCIE       = 0x10      // Bit TCIE.
	DMA_S4CR_HTIE_Pos   = 0x3       // Position of HTIE field.
	DMA_S4CR_HTIE_Msk   = 0x8       // Bit mask of HTIE field.
	DMA_S4CR_HTIE       = 0x8       // Bit HTIE.
	DMA_S4CR_TEIE_Pos   = 0x2       // Position of TEIE field.
	DMA_S4CR_TEIE_Msk   = 0x4       // Bit mask of TEIE field.
	DMA_S4CR_TEIE       = 0x4       // Bit TEIE.
	DMA_S4CR_DMEIE_Pos  = 0x1       // Position of DMEIE field.
	DMA_S4CR_DMEIE_Msk  = 0x2       // Bit mask of DMEIE field.
	DMA_S4CR_DMEIE      = 0x2       // Bit DMEIE.
	DMA_S4CR_EN_Pos     = 0x0       // Position of EN field.
	DMA_S4CR_EN_Msk     = 0x1       // Bit mask of EN field.
	DMA_S4CR_EN         = 0x1       // Bit EN.

	// S4NDTR: stream x number of data           register
	DMA_S4NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S4NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S4PAR: stream x peripheral address           register
	DMA_S4PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S4PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S4M0AR: stream x memory 0 address           register
	DMA_S4M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S4M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S4M1AR: stream x memory 1 address           register
	DMA_S4M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S4M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S4FCR: stream x FIFO control register
	DMA_S4FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S4FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S4FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S4FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S4FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S4FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S4FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S4FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S4FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S4FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S5CR: stream x configuration           register
	DMA_S5CR_CHSEL_Pos  = 0x19       // Position of CHSEL field.
	DMA_S5CR_CHSEL_Msk  = 0x1e000000 // Bit mask of CHSEL field.
	DMA_S5CR_MBURST_Pos = 0x17       // Position of MBURST field.
	DMA_S5CR_MBURST_Msk = 0x1800000  // Bit mask of MBURST field.
	DMA_S5CR_PBURST_Pos = 0x15       // Position of PBURST field.
	DMA_S5CR_PBURST_Msk = 0x600000   // Bit mask of PBURST field.
	DMA_S5CR_ACK_Pos    = 0x14       // Position of ACK field.
	DMA_S5CR_ACK_Msk    = 0x100000   // Bit mask of ACK field.
	DMA_S5CR_ACK        = 0x100000   // Bit ACK.
	DMA_S5CR_CT_Pos     = 0x13       // Position of CT field.
	DMA_S5CR_CT_Msk     = 0x80000    // Bit mask of CT field.
	DMA_S5CR_CT         = 0x80000    // Bit CT.
	DMA_S5CR_DBM_Pos    = 0x12       // Position of DBM field.
	DMA_S5CR_DBM_Msk    = 0x40000    // Bit mask of DBM field.
	DMA_S5CR_DBM        = 0x40000    // Bit DBM.
	DMA_S5CR_PL_Pos     = 0x10       // Position of PL field.
	DMA_S5CR_PL_Msk     = 0x30000    // Bit mask of PL field.
	DMA_S5CR_PINCOS_Pos = 0xf        // Position of PINCOS field.
	DMA_S5CR_PINCOS_Msk = 0x8000     // Bit mask of PINCOS field.
	DMA_S5CR_PINCOS     = 0x8000     // Bit PINCOS.
	DMA_S5CR_MSIZE_Pos  = 0xd        // Position of MSIZE field.
	DMA_S5CR_MSIZE_Msk  = 0x6000     // Bit mask of MSIZE field.
	DMA_S5CR_PSIZE_Pos  = 0xb        // Position of PSIZE field.
	DMA_S5CR_PSIZE_Msk  = 0x1800     // Bit mask of PSIZE field.
	DMA_S5CR_MINC_Pos   = 0xa        // Position of MINC field.
	DMA_S5CR_MINC_Msk   = 0x400      // Bit mask of MINC field.
	DMA_S5CR_MINC       = 0x400      // Bit MINC.
	DMA_S5CR_PINC_Pos   = 0x9        // Position of PINC field.
	DMA_S5CR_PINC_Msk   = 0x200      // Bit mask of PINC field.
	DMA_S5CR_PINC       = 0x200      // Bit PINC.
	DMA_S5CR_CIRC_Pos   = 0x8        // Position of CIRC field.
	DMA_S5CR_CIRC_Msk   = 0x100      // Bit mask of CIRC field.
	DMA_S5CR_CIRC       = 0x100      // Bit CIRC.
	DMA_S5CR_DIR_Pos    = 0x6        // Position of DIR field.
	DMA_S5CR_DIR_Msk    = 0xc0       // Bit mask of DIR field.
	DMA_S5CR_PFCTRL_Pos = 0x5        // Position of PFCTRL field.
	DMA_S5CR_PFCTRL_Msk = 0x20       // Bit mask of PFCTRL field.
	DMA_S5CR_PFCTRL     = 0x20       // Bit PFCTRL.
	DMA_S5CR_TCIE_Pos   = 0x4        // Position of TCIE field.
	DMA_S5CR_TCIE_Msk   = 0x10       // Bit mask of TCIE field.
	DMA_S5CR_TCIE       = 0x10       // Bit TCIE.
	DMA_S5CR_HTIE_Pos   = 0x3        // Position of HTIE field.
	DMA_S5CR_HTIE_Msk   = 0x8        // Bit mask of HTIE field.
	DMA_S5CR_HTIE       = 0x8        // Bit HTIE.
	DMA_S5CR_TEIE_Pos   = 0x2        // Position of TEIE field.
	DMA_S5CR_TEIE_Msk   = 0x4        // Bit mask of TEIE field.
	DMA_S5CR_TEIE       = 0x4        // Bit TEIE.
	DMA_S5CR_DMEIE_Pos  = 0x1        // Position of DMEIE field.
	DMA_S5CR_DMEIE_Msk  = 0x2        // Bit mask of DMEIE field.
	DMA_S5CR_DMEIE      = 0x2        // Bit DMEIE.
	DMA_S5CR_EN_Pos     = 0x0        // Position of EN field.
	DMA_S5CR_EN_Msk     = 0x1        // Bit mask of EN field.
	DMA_S5CR_EN         = 0x1        // Bit EN.

	// S5NDTR: stream x number of data           register
	DMA_S5NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S5NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S5PAR: stream x peripheral address           register
	DMA_S5PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S5PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S5M0AR: stream x memory 0 address           register
	DMA_S5M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S5M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S5M1AR: stream x memory 1 address           register
	DMA_S5M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S5M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S5FCR: stream x FIFO control register
	DMA_S5FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S5FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S5FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S5FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S5FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S5FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S5FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S5FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S5FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S5FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S6CR: stream x configuration           register
	DMA_S6CR_CHSEL_Pos  = 0x19       // Position of CHSEL field.
	DMA_S6CR_CHSEL_Msk  = 0x1e000000 // Bit mask of CHSEL field.
	DMA_S6CR_MBURST_Pos = 0x17       // Position of MBURST field.
	DMA_S6CR_MBURST_Msk = 0x1800000  // Bit mask of MBURST field.
	DMA_S6CR_PBURST_Pos = 0x15       // Position of PBURST field.
	DMA_S6CR_PBURST_Msk = 0x600000   // Bit mask of PBURST field.
	DMA_S6CR_ACK_Pos    = 0x14       // Position of ACK field.
	DMA_S6CR_ACK_Msk    = 0x100000   // Bit mask of ACK field.
	DMA_S6CR_ACK        = 0x100000   // Bit ACK.
	DMA_S6CR_CT_Pos     = 0x13       // Position of CT field.
	DMA_S6CR_CT_Msk     = 0x80000    // Bit mask of CT field.
	DMA_S6CR_CT         = 0x80000    // Bit CT.
	DMA_S6CR_DBM_Pos    = 0x12       // Position of DBM field.
	DMA_S6CR_DBM_Msk    = 0x40000    // Bit mask of DBM field.
	DMA_S6CR_DBM        = 0x40000    // Bit DBM.
	DMA_S6CR_PL_Pos     = 0x10       // Position of PL field.
	DMA_S6CR_PL_Msk     = 0x30000    // Bit mask of PL field.
	DMA_S6CR_PINCOS_Pos = 0xf        // Position of PINCOS field.
	DMA_S6CR_PINCOS_Msk = 0x8000     // Bit mask of PINCOS field.
	DMA_S6CR_PINCOS     = 0x8000     // Bit PINCOS.
	DMA_S6CR_MSIZE_Pos  = 0xd        // Position of MSIZE field.
	DMA_S6CR_MSIZE_Msk  = 0x6000     // Bit mask of MSIZE field.
	DMA_S6CR_PSIZE_Pos  = 0xb        // Position of PSIZE field.
	DMA_S6CR_PSIZE_Msk  = 0x1800     // Bit mask of PSIZE field.
	DMA_S6CR_MINC_Pos   = 0xa        // Position of MINC field.
	DMA_S6CR_MINC_Msk   = 0x400      // Bit mask of MINC field.
	DMA_S6CR_MINC       = 0x400      // Bit MINC.
	DMA_S6CR_PINC_Pos   = 0x9        // Position of PINC field.
	DMA_S6CR_PINC_Msk   = 0x200      // Bit mask of PINC field.
	DMA_S6CR_PINC       = 0x200      // Bit PINC.
	DMA_S6CR_CIRC_Pos   = 0x8        // Position of CIRC field.
	DMA_S6CR_CIRC_Msk   = 0x100      // Bit mask of CIRC field.
	DMA_S6CR_CIRC       = 0x100      // Bit CIRC.
	DMA_S6CR_DIR_Pos    = 0x6        // Position of DIR field.
	DMA_S6CR_DIR_Msk    = 0xc0       // Bit mask of DIR field.
	DMA_S6CR_PFCTRL_Pos = 0x5        // Position of PFCTRL field.
	DMA_S6CR_PFCTRL_Msk = 0x20       // Bit mask of PFCTRL field.
	DMA_S6CR_PFCTRL     = 0x20       // Bit PFCTRL.
	DMA_S6CR_TCIE_Pos   = 0x4        // Position of TCIE field.
	DMA_S6CR_TCIE_Msk   = 0x10       // Bit mask of TCIE field.
	DMA_S6CR_TCIE       = 0x10       // Bit TCIE.
	DMA_S6CR_HTIE_Pos   = 0x3        // Position of HTIE field.
	DMA_S6CR_HTIE_Msk   = 0x8        // Bit mask of HTIE field.
	DMA_S6CR_HTIE       = 0x8        // Bit HTIE.
	DMA_S6CR_TEIE_Pos   = 0x2        // Position of TEIE field.
	DMA_S6CR_TEIE_Msk   = 0x4        // Bit mask of TEIE field.
	DMA_S6CR_TEIE       = 0x4        // Bit TEIE.
	DMA_S6CR_DMEIE_Pos  = 0x1        // Position of DMEIE field.
	DMA_S6CR_DMEIE_Msk  = 0x2        // Bit mask of DMEIE field.
	DMA_S6CR_DMEIE      = 0x2        // Bit DMEIE.
	DMA_S6CR_EN_Pos     = 0x0        // Position of EN field.
	DMA_S6CR_EN_Msk     = 0x1        // Bit mask of EN field.
	DMA_S6CR_EN         = 0x1        // Bit EN.

	// S6NDTR: stream x number of data           register
	DMA_S6NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S6NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S6PAR: stream x peripheral address           register
	DMA_S6PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S6PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S6M0AR: stream x memory 0 address           register
	DMA_S6M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S6M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S6M1AR: stream x memory 1 address           register
	DMA_S6M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S6M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S6FCR: stream x FIFO control register
	DMA_S6FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S6FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S6FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S6FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S6FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S6FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S6FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S6FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S6FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S6FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S7CR: stream x configuration           register
	DMA_S7CR_CHSEL_Pos  = 0x19       // Position of CHSEL field.
	DMA_S7CR_CHSEL_Msk  = 0x1e000000 // Bit mask of CHSEL field.
	DMA_S7CR_MBURST_Pos = 0x17       // Position of MBURST field.
	DMA_S7CR_MBURST_Msk = 0x1800000  // Bit mask of MBURST field.
	DMA_S7CR_PBURST_Pos = 0x15       // Position of PBURST field.
	DMA_S7CR_PBURST_Msk = 0x600000   // Bit mask of PBURST field.
	DMA_S7CR_ACK_Pos    = 0x14       // Position of ACK field.
	DMA_S7CR_ACK_Msk    = 0x100000   // Bit mask of ACK field.
	DMA_S7CR_ACK        = 0x100000   // Bit ACK.
	DMA_S7CR_CT_Pos     = 0x13       // Position of CT field.
	DMA_S7CR_CT_Msk     = 0x80000    // Bit mask of CT field.
	DMA_S7CR_CT         = 0x80000    // Bit CT.
	DMA_S7CR_DBM_Pos    = 0x12       // Position of DBM field.
	DMA_S7CR_DBM_Msk    = 0x40000    // Bit mask of DBM field.
	DMA_S7CR_DBM        = 0x40000    // Bit DBM.
	DMA_S7CR_PL_Pos     = 0x10       // Position of PL field.
	DMA_S7CR_PL_Msk     = 0x30000    // Bit mask of PL field.
	DMA_S7CR_PINCOS_Pos = 0xf        // Position of PINCOS field.
	DMA_S7CR_PINCOS_Msk = 0x8000     // Bit mask of PINCOS field.
	DMA_S7CR_PINCOS     = 0x8000     // Bit PINCOS.
	DMA_S7CR_MSIZE_Pos  = 0xd        // Position of MSIZE field.
	DMA_S7CR_MSIZE_Msk  = 0x6000     // Bit mask of MSIZE field.
	DMA_S7CR_PSIZE_Pos  = 0xb        // Position of PSIZE field.
	DMA_S7CR_PSIZE_Msk  = 0x1800     // Bit mask of PSIZE field.
	DMA_S7CR_MINC_Pos   = 0xa        // Position of MINC field.
	DMA_S7CR_MINC_Msk   = 0x400      // Bit mask of MINC field.
	DMA_S7CR_MINC       = 0x400      // Bit MINC.
	DMA_S7CR_PINC_Pos   = 0x9        // Position of PINC field.
	DMA_S7CR_PINC_Msk   = 0x200      // Bit mask of PINC field.
	DMA_S7CR_PINC       = 0x200      // Bit PINC.
	DMA_S7CR_CIRC_Pos   = 0x8        // Position of CIRC field.
	DMA_S7CR_CIRC_Msk   = 0x100      // Bit mask of CIRC field.
	DMA_S7CR_CIRC       = 0x100      // Bit CIRC.
	DMA_S7CR_DIR_Pos    = 0x6        // Position of DIR field.
	DMA_S7CR_DIR_Msk    = 0xc0       // Bit mask of DIR field.
	DMA_S7CR_PFCTRL_Pos = 0x5        // Position of PFCTRL field.
	DMA_S7CR_PFCTRL_Msk = 0x20       // Bit mask of PFCTRL field.
	DMA_S7CR_PFCTRL     = 0x20       // Bit PFCTRL.
	DMA_S7CR_TCIE_Pos   = 0x4        // Position of TCIE field.
	DMA_S7CR_TCIE_Msk   = 0x10       // Bit mask of TCIE field.
	DMA_S7CR_TCIE       = 0x10       // Bit TCIE.
	DMA_S7CR_HTIE_Pos   = 0x3        // Position of HTIE field.
	DMA_S7CR_HTIE_Msk   = 0x8        // Bit mask of HTIE field.
	DMA_S7CR_HTIE       = 0x8        // Bit HTIE.
	DMA_S7CR_TEIE_Pos   = 0x2        // Position of TEIE field.
	DMA_S7CR_TEIE_Msk   = 0x4        // Bit mask of TEIE field.
	DMA_S7CR_TEIE       = 0x4        // Bit TEIE.
	DMA_S7CR_DMEIE_Pos  = 0x1        // Position of DMEIE field.
	DMA_S7CR_DMEIE_Msk  = 0x2        // Bit mask of DMEIE field.
	DMA_S7CR_DMEIE      = 0x2        // Bit DMEIE.
	DMA_S7CR_EN_Pos     = 0x0        // Position of EN field.
	DMA_S7CR_EN_Msk     = 0x1        // Bit mask of EN field.
	DMA_S7CR_EN         = 0x1        // Bit EN.

	// S7NDTR: stream x number of data           register
	DMA_S7NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S7NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S7PAR: stream x peripheral address           register
	DMA_S7PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S7PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S7M0AR: stream x memory 0 address           register
	DMA_S7M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S7M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S7M1AR: stream x memory 1 address           register
	DMA_S7M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S7M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S7FCR: stream x FIFO control register
	DMA_S7FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S7FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S7FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S7FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S7FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S7FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S7FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S7FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S7FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S7FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.
)

// Bitfields for RCC: Reset and clock control
const (
	// CR: clock control register
	RCC_CR_PLLI2SRDY_Pos = 0x1b      // Position of PLLI2SRDY field.
	RCC_CR_PLLI2SRDY_Msk = 0x8000000 // Bit mask of PLLI2SRDY field.
	RCC_CR_PLLI2SRDY     = 0x8000000 // Bit PLLI2SRDY.
	RCC_CR_PLLI2SON_Pos  = 0x1a      // Position of PLLI2SON field.
	RCC_CR_PLLI2SON_Msk  = 0x4000000 // Bit mask of PLLI2SON field.
	RCC_CR_PLLI2SON      = 0x4000000 // Bit PLLI2SON.
	RCC_CR_PLLRDY_Pos    = 0x19      // Position of PLLRDY field.
	RCC_CR_PLLRDY_Msk    = 0x2000000 // Bit mask of PLLRDY field.
	RCC_CR_PLLRDY        = 0x2000000 // Bit PLLRDY.
	RCC_CR_PLLON_Pos     = 0x18      // Position of PLLON field.
	RCC_CR_PLLON_Msk     = 0x1000000 // Bit mask of PLLON field.
	RCC_CR_PLLON         = 0x1000000 // Bit PLLON.
	RCC_CR_CSSON_Pos     = 0x13      // Position of CSSON field.
	RCC_CR_CSSON_Msk     = 0x80000   // Bit mask of CSSON field.
	RCC_CR_CSSON         = 0x80000   // Bit CSSON.
	RCC_CR_HSEBYP_Pos    = 0x12      // Position of HSEBYP field.
	RCC_CR_HSEBYP_Msk    = 0x40000   // Bit mask of HSEBYP field.
	RCC_CR_HSEBYP        = 0x40000   // Bit HSEBYP.
	RCC_CR_HSERDY_Pos    = 0x11      // Position of HSERDY field.
	RCC_CR_HSERDY_Msk    = 0x20000   // Bit mask of HSERDY field.
	RCC_CR_HSERDY        = 0x20000   // Bit HSERDY.
	RCC_CR_HSEON_Pos     = 0x10      // Position of HSEON field.
	RCC_CR_HSEON_Msk     = 0x10000   // Bit mask of HSEON field.
	RCC_CR_HSEON         = 0x10000   // Bit HSEON.
	RCC_CR_HSICAL_Pos    = 0x8       // Position of HSICAL field.
	RCC_CR_HSICAL_Msk    = 0xff00    // Bit mask of HSICAL field.
	RCC_CR_HSITRIM_Pos   = 0x3       // Position of HSITRIM field.
	RCC_CR_HSITRIM_Msk   = 0xf8      // Bit mask of HSITRIM field.
	RCC_CR_HSIRDY_Pos    = 0x1       // Position of HSIRDY field.
	RCC_CR_HSIRDY_Msk    = 0x2       // Bit mask of HSIRDY field.
	RCC_CR_HSIRDY        = 0x2       // Bit HSIRDY.
	RCC_CR_HSION_Pos     = 0x0       // Position of HSION field.
	RCC_CR_HSION_Msk     = 0x1       // Bit mask of HSION field.
	RCC_CR_HSION         = 0x1       // Bit HSION.

	// PLLCFGR: PLL configuration register
	RCC_PLLCFGR_PLLQ3_Pos  = 0x1b      // Position of PLLQ3 field.
	RCC_PLLCFGR_PLLQ3_Msk  = 0x8000000 // Bit mask of PLLQ3 field.
	RCC_PLLCFGR_PLLQ3      = 0x8000000 // Bit PLLQ3.
	RCC_PLLCFGR_PLLQ2_Pos  = 0x1a      // Position of PLLQ2 field.
	RCC_PLLCFGR_PLLQ2_Msk  = 0x4000000 // Bit mask of PLLQ2 field.
	RCC_PLLCFGR_PLLQ2      = 0x4000000 // Bit PLLQ2.
	RCC_PLLCFGR_PLLQ1_Pos  = 0x19      // Position of PLLQ1 field.
	RCC_PLLCFGR_PLLQ1_Msk  = 0x2000000 // Bit mask of PLLQ1 field.
	RCC_PLLCFGR_PLLQ1      = 0x2000000 // Bit PLLQ1.
	RCC_PLLCFGR_PLLQ0_Pos  = 0x18      // Position of PLLQ0 field.
	RCC_PLLCFGR_PLLQ0_Msk  = 0x1000000 // Bit mask of PLLQ0 field.
	RCC_PLLCFGR_PLLQ0      = 0x1000000 // Bit PLLQ0.
	RCC_PLLCFGR_PLLSRC_Pos = 0x16      // Position of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Msk = 0x400000  // Bit mask of PLLSRC field.
	RCC_PLLCFGR_PLLSRC     = 0x400000  // Bit PLLSRC.
	RCC_PLLCFGR_PLLP1_Pos  = 0x11      // Position of PLLP1 field.
	RCC_PLLCFGR_PLLP1_Msk  = 0x20000   // Bit mask of PLLP1 field.
	RCC_PLLCFGR_PLLP1      = 0x20000   // Bit PLLP1.
	RCC_PLLCFGR_PLLP0_Pos  = 0x10      // Position of PLLP0 field.
	RCC_PLLCFGR_PLLP0_Msk  = 0x10000   // Bit mask of PLLP0 field.
	RCC_PLLCFGR_PLLP0      = 0x10000   // Bit PLLP0.
	RCC_PLLCFGR_PLLN8_Pos  = 0xe       // Position of PLLN8 field.
	RCC_PLLCFGR_PLLN8_Msk  = 0x4000    // Bit mask of PLLN8 field.
	RCC_PLLCFGR_PLLN8      = 0x4000    // Bit PLLN8.
	RCC_PLLCFGR_PLLN7_Pos  = 0xd       // Position of PLLN7 field.
	RCC_PLLCFGR_PLLN7_Msk  = 0x2000    // Bit mask of PLLN7 field.
	RCC_PLLCFGR_PLLN7      = 0x2000    // Bit PLLN7.
	RCC_PLLCFGR_PLLN6_Pos  = 0xc       // Position of PLLN6 field.
	RCC_PLLCFGR_PLLN6_Msk  = 0x1000    // Bit mask of PLLN6 field.
	RCC_PLLCFGR_PLLN6      = 0x1000    // Bit PLLN6.
	RCC_PLLCFGR_PLLN5_Pos  = 0xb       // Position of PLLN5 field.
	RCC_PLLCFGR_PLLN5_Msk  = 0x800     // Bit mask of PLLN5 field.
	RCC_PLLCFGR_PLLN5      = 0x800     // Bit PLLN5.
	RCC_PLLCFGR_PLLN4_Pos  = 0xa       // Position of PLLN4 field.
	RCC_PLLCFGR_PLLN4_Msk  = 0x400     // Bit mask of PLLN4 field.
	RCC_PLLCFGR_PLLN4      = 0x400     // Bit PLLN4.
	RCC_PLLCFGR_PLLN3_Pos  = 0x9       // Position of PLLN3 field.
	RCC_PLLCFGR_PLLN3_Msk  = 0x200     // Bit mask of PLLN3 field.
	RCC_PLLCFGR_PLLN3      = 0x200     // Bit PLLN3.
	RCC_PLLCFGR_PLLN2_Pos  = 0x8       // Position of PLLN2 field.
	RCC_PLLCFGR_PLLN2_Msk  = 0x100     // Bit mask of PLLN2 field.
	RCC_PLLCFGR_PLLN2      = 0x100     // Bit PLLN2.
	RCC_PLLCFGR_PLLN1_Pos  = 0x7       // Position of PLLN1 field.
	RCC_PLLCFGR_PLLN1_Msk  = 0x80      // Bit mask of PLLN1 field.
	RCC_PLLCFGR_PLLN1      = 0x80      // Bit PLLN1.
	RCC_PLLCFGR_PLLN0_Pos  = 0x6       // Position of PLLN0 field.
	RCC_PLLCFGR_PLLN0_Msk  = 0x40      // Bit mask of PLLN0 field.
	RCC_PLLCFGR_PLLN0      = 0x40      // Bit PLLN0.
	RCC_PLLCFGR_PLLM5_Pos  = 0x5       // Position of PLLM5 field.
	RCC_PLLCFGR_PLLM5_Msk  = 0x20      // Bit mask of PLLM5 field.
	RCC_PLLCFGR_PLLM5      = 0x20      // Bit PLLM5.
	RCC_PLLCFGR_PLLM4_Pos  = 0x4       // Position of PLLM4 field.
	RCC_PLLCFGR_PLLM4_Msk  = 0x10      // Bit mask of PLLM4 field.
	RCC_PLLCFGR_PLLM4      = 0x10      // Bit PLLM4.
	RCC_PLLCFGR_PLLM3_Pos  = 0x3       // Position of PLLM3 field.
	RCC_PLLCFGR_PLLM3_Msk  = 0x8       // Bit mask of PLLM3 field.
	RCC_PLLCFGR_PLLM3      = 0x8       // Bit PLLM3.
	RCC_PLLCFGR_PLLM2_Pos  = 0x2       // Position of PLLM2 field.
	RCC_PLLCFGR_PLLM2_Msk  = 0x4       // Bit mask of PLLM2 field.
	RCC_PLLCFGR_PLLM2      = 0x4       // Bit PLLM2.
	RCC_PLLCFGR_PLLM1_Pos  = 0x1       // Position of PLLM1 field.
	RCC_PLLCFGR_PLLM1_Msk  = 0x2       // Bit mask of PLLM1 field.
	RCC_PLLCFGR_PLLM1      = 0x2       // Bit PLLM1.
	RCC_PLLCFGR_PLLM0_Pos  = 0x0       // Position of PLLM0 field.
	RCC_PLLCFGR_PLLM0_Msk  = 0x1       // Bit mask of PLLM0 field.
	RCC_PLLCFGR_PLLM0      = 0x1       // Bit PLLM0.

	// CFGR: clock configuration register
	RCC_CFGR_MCO2_Pos    = 0x1e       // Position of MCO2 field.
	RCC_CFGR_MCO2_Msk    = 0xc0000000 // Bit mask of MCO2 field.
	RCC_CFGR_MCO2PRE_Pos = 0x1b       // Position of MCO2PRE field.
	RCC_CFGR_MCO2PRE_Msk = 0x38000000 // Bit mask of MCO2PRE field.
	RCC_CFGR_MCO1PRE_Pos = 0x18       // Position of MCO1PRE field.
	RCC_CFGR_MCO1PRE_Msk = 0x7000000  // Bit mask of MCO1PRE field.
	RCC_CFGR_I2SSRC_Pos  = 0x17       // Position of I2SSRC field.
	RCC_CFGR_I2SSRC_Msk  = 0x800000   // Bit mask of I2SSRC field.
	RCC_CFGR_I2SSRC      = 0x800000   // Bit I2SSRC.
	RCC_CFGR_MCO1_Pos    = 0x15       // Position of MCO1 field.
	RCC_CFGR_MCO1_Msk    = 0x600000   // Bit mask of MCO1 field.
	RCC_CFGR_RTCPRE_Pos  = 0x10       // Position of RTCPRE field.
	RCC_CFGR_RTCPRE_Msk  = 0x1f0000   // Bit mask of RTCPRE field.
	RCC_CFGR_PPRE2_Pos   = 0xd        // Position of PPRE2 field.
	RCC_CFGR_PPRE2_Msk   = 0xe000     // Bit mask of PPRE2 field.
	RCC_CFGR_PPRE1_Pos   = 0xa        // Position of PPRE1 field.
	RCC_CFGR_PPRE1_Msk   = 0x1c00     // Bit mask of PPRE1 field.
	RCC_CFGR_HPRE_Pos    = 0x4        // Position of HPRE field.
	RCC_CFGR_HPRE_Msk    = 0xf0       // Bit mask of HPRE field.
	RCC_CFGR_SWS1_Pos    = 0x3        // Position of SWS1 field.
	RCC_CFGR_SWS1_Msk    = 0x8        // Bit mask of SWS1 field.
	RCC_CFGR_SWS1        = 0x8        // Bit SWS1.
	RCC_CFGR_SWS0_Pos    = 0x2        // Position of SWS0 field.
	RCC_CFGR_SWS0_Msk    = 0x4        // Bit mask of SWS0 field.
	RCC_CFGR_SWS0        = 0x4        // Bit SWS0.
	RCC_CFGR_SW1_Pos     = 0x1        // Position of SW1 field.
	RCC_CFGR_SW1_Msk     = 0x2        // Bit mask of SW1 field.
	RCC_CFGR_SW1         = 0x2        // Bit SW1.
	RCC_CFGR_SW0_Pos     = 0x0        // Position of SW0 field.
	RCC_CFGR_SW0_Msk     = 0x1        // Bit mask of SW0 field.
	RCC_CFGR_SW0         = 0x1        // Bit SW0.

	// CIR: clock interrupt register
	RCC_CIR_CSSC_Pos        = 0x17     // Position of CSSC field.
	RCC_CIR_CSSC_Msk        = 0x800000 // Bit mask of CSSC field.
	RCC_CIR_CSSC            = 0x800000 // Bit CSSC.
	RCC_CIR_PLLSAIRDYC_Pos  = 0x16     // Position of PLLSAIRDYC field.
	RCC_CIR_PLLSAIRDYC_Msk  = 0x400000 // Bit mask of PLLSAIRDYC field.
	RCC_CIR_PLLSAIRDYC      = 0x400000 // Bit PLLSAIRDYC.
	RCC_CIR_PLLI2SRDYC_Pos  = 0x15     // Position of PLLI2SRDYC field.
	RCC_CIR_PLLI2SRDYC_Msk  = 0x200000 // Bit mask of PLLI2SRDYC field.
	RCC_CIR_PLLI2SRDYC      = 0x200000 // Bit PLLI2SRDYC.
	RCC_CIR_PLLRDYC_Pos     = 0x14     // Position of PLLRDYC field.
	RCC_CIR_PLLRDYC_Msk     = 0x100000 // Bit mask of PLLRDYC field.
	RCC_CIR_PLLRDYC         = 0x100000 // Bit PLLRDYC.
	RCC_CIR_HSERDYC_Pos     = 0x13     // Position of HSERDYC field.
	RCC_CIR_HSERDYC_Msk     = 0x80000  // Bit mask of HSERDYC field.
	RCC_CIR_HSERDYC         = 0x80000  // Bit HSERDYC.
	RCC_CIR_HSIRDYC_Pos     = 0x12     // Position of HSIRDYC field.
	RCC_CIR_HSIRDYC_Msk     = 0x40000  // Bit mask of HSIRDYC field.
	RCC_CIR_HSIRDYC         = 0x40000  // Bit HSIRDYC.
	RCC_CIR_LSERDYC_Pos     = 0x11     // Position of LSERDYC field.
	RCC_CIR_LSERDYC_Msk     = 0x20000  // Bit mask of LSERDYC field.
	RCC_CIR_LSERDYC         = 0x20000  // Bit LSERDYC.
	RCC_CIR_LSIRDYC_Pos     = 0x10     // Position of LSIRDYC field.
	RCC_CIR_LSIRDYC_Msk     = 0x10000  // Bit mask of LSIRDYC field.
	RCC_CIR_LSIRDYC         = 0x10000  // Bit LSIRDYC.
	RCC_CIR_PLLSAIRDYIE_Pos = 0xe      // Position of PLLSAIRDYIE field.
	RCC_CIR_PLLSAIRDYIE_Msk = 0x4000   // Bit mask of PLLSAIRDYIE field.
	RCC_CIR_PLLSAIRDYIE     = 0x4000   // Bit PLLSAIRDYIE.
	RCC_CIR_PLLI2SRDYIE_Pos = 0xd      // Position of PLLI2SRDYIE field.
	RCC_CIR_PLLI2SRDYIE_Msk = 0x2000   // Bit mask of PLLI2SRDYIE field.
	RCC_CIR_PLLI2SRDYIE     = 0x2000   // Bit PLLI2SRDYIE.
	RCC_CIR_PLLRDYIE_Pos    = 0xc      // Position of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Msk    = 0x1000   // Bit mask of PLLRDYIE field.
	RCC_CIR_PLLRDYIE        = 0x1000   // Bit PLLRDYIE.
	RCC_CIR_HSERDYIE_Pos    = 0xb      // Position of HSERDYIE field.
	RCC_CIR_HSERDYIE_Msk    = 0x800    // Bit mask of HSERDYIE field.
	RCC_CIR_HSERDYIE        = 0x800    // Bit HSERDYIE.
	RCC_CIR_HSIRDYIE_Pos    = 0xa      // Position of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Msk    = 0x400    // Bit mask of HSIRDYIE field.
	RCC_CIR_HSIRDYIE        = 0x400    // Bit HSIRDYIE.
	RCC_CIR_LSERDYIE_Pos    = 0x9      // Position of LSERDYIE field.
	RCC_CIR_LSERDYIE_Msk    = 0x200    // Bit mask of LSERDYIE field.
	RCC_CIR_LSERDYIE        = 0x200    // Bit LSERDYIE.
	RCC_CIR_LSIRDYIE_Pos    = 0x8      // Position of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Msk    = 0x100    // Bit mask of LSIRDYIE field.
	RCC_CIR_LSIRDYIE        = 0x100    // Bit LSIRDYIE.
	RCC_CIR_CSSF_Pos        = 0x7      // Position of CSSF field.
	RCC_CIR_CSSF_Msk        = 0x80     // Bit mask of CSSF field.
	RCC_CIR_CSSF            = 0x80     // Bit CSSF.
	RCC_CIR_PLLSAIRDYF_Pos  = 0x6      // Position of PLLSAIRDYF field.
	RCC_CIR_PLLSAIRDYF_Msk  = 0x40     // Bit mask of PLLSAIRDYF field.
	RCC_CIR_PLLSAIRDYF      = 0x40     // Bit PLLSAIRDYF.
	RCC_CIR_PLLI2SRDYF_Pos  = 0x5      // Position of PLLI2SRDYF field.
	RCC_CIR_PLLI2SRDYF_Msk  = 0x20     // Bit mask of PLLI2SRDYF field.
	RCC_CIR_PLLI2SRDYF      = 0x20     // Bit PLLI2SRDYF.
	RCC_CIR_PLLRDYF_Pos     = 0x4      // Position of PLLRDYF field.
	RCC_CIR_PLLRDYF_Msk     = 0x10     // Bit mask of PLLRDYF field.
	RCC_CIR_PLLRDYF         = 0x10     // Bit PLLRDYF.
	RCC_CIR_HSERDYF_Pos     = 0x3      // Position of HSERDYF field.
	RCC_CIR_HSERDYF_Msk     = 0x8      // Bit mask of HSERDYF field.
	RCC_CIR_HSERDYF         = 0x8      // Bit HSERDYF.
	RCC_CIR_HSIRDYF_Pos     = 0x2      // Position of HSIRDYF field.
	RCC_CIR_HSIRDYF_Msk     = 0x4      // Bit mask of HSIRDYF field.
	RCC_CIR_HSIRDYF         = 0x4      // Bit HSIRDYF.
	RCC_CIR_LSERDYF_Pos     = 0x1      // Position of LSERDYF field.
	RCC_CIR_LSERDYF_Msk     = 0x2      // Bit mask of LSERDYF field.
	RCC_CIR_LSERDYF         = 0x2      // Bit LSERDYF.
	RCC_CIR_LSIRDYF_Pos     = 0x0      // Position of LSIRDYF field.
	RCC_CIR_LSIRDYF_Msk     = 0x1      // Bit mask of LSIRDYF field.
	RCC_CIR_LSIRDYF         = 0x1      // Bit LSIRDYF.

	// AHB1RSTR: AHB1 peripheral reset register
	RCC_AHB1RSTR_OTGHSRST_Pos  = 0x1d       // Position of OTGHSRST field.
	RCC_AHB1RSTR_OTGHSRST_Msk  = 0x20000000 // Bit mask of OTGHSRST field.
	RCC_AHB1RSTR_OTGHSRST      = 0x20000000 // Bit OTGHSRST.
	RCC_AHB1RSTR_ETHMACRST_Pos = 0x19       // Position of ETHMACRST field.
	RCC_AHB1RSTR_ETHMACRST_Msk = 0x2000000  // Bit mask of ETHMACRST field.
	RCC_AHB1RSTR_ETHMACRST     = 0x2000000  // Bit ETHMACRST.
	RCC_AHB1RSTR_DMA2DRST_Pos  = 0x17       // Position of DMA2DRST field.
	RCC_AHB1RSTR_DMA2DRST_Msk  = 0x800000   // Bit mask of DMA2DRST field.
	RCC_AHB1RSTR_DMA2DRST      = 0x800000   // Bit DMA2DRST.
	RCC_AHB1RSTR_DMA2RST_Pos   = 0x16       // Position of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Msk   = 0x400000   // Bit mask of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST       = 0x400000   // Bit DMA2RST.
	RCC_AHB1RSTR_DMA1RST_Pos   = 0x15       // Position of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Msk   = 0x200000   // Bit mask of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST       = 0x200000   // Bit DMA1RST.
	RCC_AHB1RSTR_CRCRST_Pos    = 0xc        // Position of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Msk    = 0x1000     // Bit mask of CRCRST field.
	RCC_AHB1RSTR_CRCRST        = 0x1000     // Bit CRCRST.
	RCC_AHB1RSTR_GPIOKRST_Pos  = 0xa        // Position of GPIOKRST field.
	RCC_AHB1RSTR_GPIOKRST_Msk  = 0x400      // Bit mask of GPIOKRST field.
	RCC_AHB1RSTR_GPIOKRST      = 0x400      // Bit GPIOKRST.
	RCC_AHB1RSTR_GPIOJRST_Pos  = 0x9        // Position of GPIOJRST field.
	RCC_AHB1RSTR_GPIOJRST_Msk  = 0x200      // Bit mask of GPIOJRST field.
	RCC_AHB1RSTR_GPIOJRST      = 0x200      // Bit GPIOJRST.
	RCC_AHB1RSTR_GPIOIRST_Pos  = 0x8        // Position of GPIOIRST field.
	RCC_AHB1RSTR_GPIOIRST_Msk  = 0x100      // Bit mask of GPIOIRST field.
	RCC_AHB1RSTR_GPIOIRST      = 0x100      // Bit GPIOIRST.
	RCC_AHB1RSTR_GPIOHRST_Pos  = 0x7        // Position of GPIOHRST field.
	RCC_AHB1RSTR_GPIOHRST_Msk  = 0x80       // Bit mask of GPIOHRST field.
	RCC_AHB1RSTR_GPIOHRST      = 0x80       // Bit GPIOHRST.
	RCC_AHB1RSTR_GPIOGRST_Pos  = 0x6        // Position of GPIOGRST field.
	RCC_AHB1RSTR_GPIOGRST_Msk  = 0x40       // Bit mask of GPIOGRST field.
	RCC_AHB1RSTR_GPIOGRST      = 0x40       // Bit GPIOGRST.
	RCC_AHB1RSTR_GPIOFRST_Pos  = 0x5        // Position of GPIOFRST field.
	RCC_AHB1RSTR_GPIOFRST_Msk  = 0x20       // Bit mask of GPIOFRST field.
	RCC_AHB1RSTR_GPIOFRST      = 0x20       // Bit GPIOFRST.
	RCC_AHB1RSTR_GPIOERST_Pos  = 0x4        // Position of GPIOERST field.
	RCC_AHB1RSTR_GPIOERST_Msk  = 0x10       // Bit mask of GPIOERST field.
	RCC_AHB1RSTR_GPIOERST      = 0x10       // Bit GPIOERST.
	RCC_AHB1RSTR_GPIODRST_Pos  = 0x3        // Position of GPIODRST field.
	RCC_AHB1RSTR_GPIODRST_Msk  = 0x8        // Bit mask of GPIODRST field.
	RCC_AHB1RSTR_GPIODRST      = 0x8        // Bit GPIODRST.
	RCC_AHB1RSTR_GPIOCRST_Pos  = 0x2        // Position of GPIOCRST field.
	RCC_AHB1RSTR_GPIOCRST_Msk  = 0x4        // Bit mask of GPIOCRST field.
	RCC_AHB1RSTR_GPIOCRST      = 0x4        // Bit GPIOCRST.
	RCC_AHB1RSTR_GPIOBRST_Pos  = 0x1        // Position of GPIOBRST field.
	RCC_AHB1RSTR_GPIOBRST_Msk  = 0x2        // Bit mask of GPIOBRST field.
	RCC_AHB1RSTR_GPIOBRST      = 0x2        // Bit GPIOBRST.
	RCC_AHB1RSTR_GPIOARST_Pos  = 0x0        // Position of GPIOARST field.
	RCC_AHB1RSTR_GPIOARST_Msk  = 0x1        // Bit mask of GPIOARST field.
	RCC_AHB1RSTR_GPIOARST      = 0x1        // Bit GPIOARST.

	// AHB2RSTR: AHB2 peripheral reset register
	RCC_AHB2RSTR_OTGFSRST_Pos = 0x7  // Position of OTGFSRST field.
	RCC_AHB2RSTR_OTGFSRST_Msk = 0x80 // Bit mask of OTGFSRST field.
	RCC_AHB2RSTR_OTGFSRST     = 0x80 // Bit OTGFSRST.
	RCC_AHB2RSTR_RNGRST_Pos   = 0x6  // Position of RNGRST field.
	RCC_AHB2RSTR_RNGRST_Msk   = 0x40 // Bit mask of RNGRST field.
	RCC_AHB2RSTR_RNGRST       = 0x40 // Bit RNGRST.
	RCC_AHB2RSTR_HSAHRST_Pos  = 0x5  // Position of HSAHRST field.
	RCC_AHB2RSTR_HSAHRST_Msk  = 0x20 // Bit mask of HSAHRST field.
	RCC_AHB2RSTR_HSAHRST      = 0x20 // Bit HSAHRST.
	RCC_AHB2RSTR_CRYPRST_Pos  = 0x4  // Position of CRYPRST field.
	RCC_AHB2RSTR_CRYPRST_Msk  = 0x10 // Bit mask of CRYPRST field.
	RCC_AHB2RSTR_CRYPRST      = 0x10 // Bit CRYPRST.
	RCC_AHB2RSTR_DCMIRST_Pos  = 0x0  // Position of DCMIRST field.
	RCC_AHB2RSTR_DCMIRST_Msk  = 0x1  // Bit mask of DCMIRST field.
	RCC_AHB2RSTR_DCMIRST      = 0x1  // Bit DCMIRST.

	// AHB3RSTR: AHB3 peripheral reset register
	RCC_AHB3RSTR_FMCRST_Pos  = 0x0 // Position of FMCRST field.
	RCC_AHB3RSTR_FMCRST_Msk  = 0x1 // Bit mask of FMCRST field.
	RCC_AHB3RSTR_FMCRST      = 0x1 // Bit FMCRST.
	RCC_AHB3RSTR_QSPIRST_Pos = 0x1 // Position of QSPIRST field.
	RCC_AHB3RSTR_QSPIRST_Msk = 0x2 // Bit mask of QSPIRST field.
	RCC_AHB3RSTR_QSPIRST     = 0x2 // Bit QSPIRST.

	// APB1RSTR: APB1 peripheral reset register
	RCC_APB1RSTR_TIM2RST_Pos    = 0x0        // Position of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Msk    = 0x1        // Bit mask of TIM2RST field.
	RCC_APB1RSTR_TIM2RST        = 0x1        // Bit TIM2RST.
	RCC_APB1RSTR_TIM3RST_Pos    = 0x1        // Position of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Msk    = 0x2        // Bit mask of TIM3RST field.
	RCC_APB1RSTR_TIM3RST        = 0x2        // Bit TIM3RST.
	RCC_APB1RSTR_TIM4RST_Pos    = 0x2        // Position of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Msk    = 0x4        // Bit mask of TIM4RST field.
	RCC_APB1RSTR_TIM4RST        = 0x4        // Bit TIM4RST.
	RCC_APB1RSTR_TIM5RST_Pos    = 0x3        // Position of TIM5RST field.
	RCC_APB1RSTR_TIM5RST_Msk    = 0x8        // Bit mask of TIM5RST field.
	RCC_APB1RSTR_TIM5RST        = 0x8        // Bit TIM5RST.
	RCC_APB1RSTR_TIM6RST_Pos    = 0x4        // Position of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Msk    = 0x10       // Bit mask of TIM6RST field.
	RCC_APB1RSTR_TIM6RST        = 0x10       // Bit TIM6RST.
	RCC_APB1RSTR_TIM7RST_Pos    = 0x5        // Position of TIM7RST field.
	RCC_APB1RSTR_TIM7RST_Msk    = 0x20       // Bit mask of TIM7RST field.
	RCC_APB1RSTR_TIM7RST        = 0x20       // Bit TIM7RST.
	RCC_APB1RSTR_TIM12RST_Pos   = 0x6        // Position of TIM12RST field.
	RCC_APB1RSTR_TIM12RST_Msk   = 0x40       // Bit mask of TIM12RST field.
	RCC_APB1RSTR_TIM12RST       = 0x40       // Bit TIM12RST.
	RCC_APB1RSTR_TIM13RST_Pos   = 0x7        // Position of TIM13RST field.
	RCC_APB1RSTR_TIM13RST_Msk   = 0x80       // Bit mask of TIM13RST field.
	RCC_APB1RSTR_TIM13RST       = 0x80       // Bit TIM13RST.
	RCC_APB1RSTR_TIM14RST_Pos   = 0x8        // Position of TIM14RST field.
	RCC_APB1RSTR_TIM14RST_Msk   = 0x100      // Bit mask of TIM14RST field.
	RCC_APB1RSTR_TIM14RST       = 0x100      // Bit TIM14RST.
	RCC_APB1RSTR_WWDGRST_Pos    = 0xb        // Position of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Msk    = 0x800      // Bit mask of WWDGRST field.
	RCC_APB1RSTR_WWDGRST        = 0x800      // Bit WWDGRST.
	RCC_APB1RSTR_SPI2RST_Pos    = 0xe        // Position of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Msk    = 0x4000     // Bit mask of SPI2RST field.
	RCC_APB1RSTR_SPI2RST        = 0x4000     // Bit SPI2RST.
	RCC_APB1RSTR_SPI3RST_Pos    = 0xf        // Position of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Msk    = 0x8000     // Bit mask of SPI3RST field.
	RCC_APB1RSTR_SPI3RST        = 0x8000     // Bit SPI3RST.
	RCC_APB1RSTR_UART2RST_Pos   = 0x11       // Position of UART2RST field.
	RCC_APB1RSTR_UART2RST_Msk   = 0x20000    // Bit mask of UART2RST field.
	RCC_APB1RSTR_UART2RST       = 0x20000    // Bit UART2RST.
	RCC_APB1RSTR_UART3RST_Pos   = 0x12       // Position of UART3RST field.
	RCC_APB1RSTR_UART3RST_Msk   = 0x40000    // Bit mask of UART3RST field.
	RCC_APB1RSTR_UART3RST       = 0x40000    // Bit UART3RST.
	RCC_APB1RSTR_UART4RST_Pos   = 0x13       // Position of UART4RST field.
	RCC_APB1RSTR_UART4RST_Msk   = 0x80000    // Bit mask of UART4RST field.
	RCC_APB1RSTR_UART4RST       = 0x80000    // Bit UART4RST.
	RCC_APB1RSTR_UART5RST_Pos   = 0x14       // Position of UART5RST field.
	RCC_APB1RSTR_UART5RST_Msk   = 0x100000   // Bit mask of UART5RST field.
	RCC_APB1RSTR_UART5RST       = 0x100000   // Bit UART5RST.
	RCC_APB1RSTR_I2C1RST_Pos    = 0x15       // Position of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Msk    = 0x200000   // Bit mask of I2C1RST field.
	RCC_APB1RSTR_I2C1RST        = 0x200000   // Bit I2C1RST.
	RCC_APB1RSTR_I2C2RST_Pos    = 0x16       // Position of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Msk    = 0x400000   // Bit mask of I2C2RST field.
	RCC_APB1RSTR_I2C2RST        = 0x400000   // Bit I2C2RST.
	RCC_APB1RSTR_I2C3RST_Pos    = 0x17       // Position of I2C3RST field.
	RCC_APB1RSTR_I2C3RST_Msk    = 0x800000   // Bit mask of I2C3RST field.
	RCC_APB1RSTR_I2C3RST        = 0x800000   // Bit I2C3RST.
	RCC_APB1RSTR_CAN1RST_Pos    = 0x19       // Position of CAN1RST field.
	RCC_APB1RSTR_CAN1RST_Msk    = 0x2000000  // Bit mask of CAN1RST field.
	RCC_APB1RSTR_CAN1RST        = 0x2000000  // Bit CAN1RST.
	RCC_APB1RSTR_CAN2RST_Pos    = 0x1a       // Position of CAN2RST field.
	RCC_APB1RSTR_CAN2RST_Msk    = 0x4000000  // Bit mask of CAN2RST field.
	RCC_APB1RSTR_CAN2RST        = 0x4000000  // Bit CAN2RST.
	RCC_APB1RSTR_PWRRST_Pos     = 0x1c       // Position of PWRRST field.
	RCC_APB1RSTR_PWRRST_Msk     = 0x10000000 // Bit mask of PWRRST field.
	RCC_APB1RSTR_PWRRST         = 0x10000000 // Bit PWRRST.
	RCC_APB1RSTR_DACRST_Pos     = 0x1d       // Position of DACRST field.
	RCC_APB1RSTR_DACRST_Msk     = 0x20000000 // Bit mask of DACRST field.
	RCC_APB1RSTR_DACRST         = 0x20000000 // Bit DACRST.
	RCC_APB1RSTR_UART7RST_Pos   = 0x1e       // Position of UART7RST field.
	RCC_APB1RSTR_UART7RST_Msk   = 0x40000000 // Bit mask of UART7RST field.
	RCC_APB1RSTR_UART7RST       = 0x40000000 // Bit UART7RST.
	RCC_APB1RSTR_UART8RST_Pos   = 0x1f       // Position of UART8RST field.
	RCC_APB1RSTR_UART8RST_Msk   = 0x80000000 // Bit mask of UART8RST field.
	RCC_APB1RSTR_UART8RST       = 0x80000000 // Bit UART8RST.
	RCC_APB1RSTR_SPDIFRXRST_Pos = 0x10       // Position of SPDIFRXRST field.
	RCC_APB1RSTR_SPDIFRXRST_Msk = 0x10000    // Bit mask of SPDIFRXRST field.
	RCC_APB1RSTR_SPDIFRXRST     = 0x10000    // Bit SPDIFRXRST.
	RCC_APB1RSTR_CECRST_Pos     = 0x1b       // Position of CECRST field.
	RCC_APB1RSTR_CECRST_Msk     = 0x8000000  // Bit mask of CECRST field.
	RCC_APB1RSTR_CECRST         = 0x8000000  // Bit CECRST.
	RCC_APB1RSTR_LPTIM1RST_Pos  = 0x9        // Position of LPTIM1RST field.
	RCC_APB1RSTR_LPTIM1RST_Msk  = 0x200      // Bit mask of LPTIM1RST field.
	RCC_APB1RSTR_LPTIM1RST      = 0x200      // Bit LPTIM1RST.
	RCC_APB1RSTR_I2C4RST_Pos    = 0x18       // Position of I2C4RST field.
	RCC_APB1RSTR_I2C4RST_Msk    = 0x1000000  // Bit mask of I2C4RST field.
	RCC_APB1RSTR_I2C4RST        = 0x1000000  // Bit I2C4RST.

	// APB2RSTR: APB2 peripheral reset register
	RCC_APB2RSTR_TIM1RST_Pos   = 0x0       // Position of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Msk   = 0x1       // Bit mask of TIM1RST field.
	RCC_APB2RSTR_TIM1RST       = 0x1       // Bit TIM1RST.
	RCC_APB2RSTR_TIM8RST_Pos   = 0x1       // Position of TIM8RST field.
	RCC_APB2RSTR_TIM8RST_Msk   = 0x2       // Bit mask of TIM8RST field.
	RCC_APB2RSTR_TIM8RST       = 0x2       // Bit TIM8RST.
	RCC_APB2RSTR_USART1RST_Pos = 0x4       // Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x10      // Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST     = 0x10      // Bit USART1RST.
	RCC_APB2RSTR_USART6RST_Pos = 0x5       // Position of USART6RST field.
	RCC_APB2RSTR_USART6RST_Msk = 0x20      // Bit mask of USART6RST field.
	RCC_APB2RSTR_USART6RST     = 0x20      // Bit USART6RST.
	RCC_APB2RSTR_ADCRST_Pos    = 0x8       // Position of ADCRST field.
	RCC_APB2RSTR_ADCRST_Msk    = 0x100     // Bit mask of ADCRST field.
	RCC_APB2RSTR_ADCRST        = 0x100     // Bit ADCRST.
	RCC_APB2RSTR_SPI1RST_Pos   = 0xc       // Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk   = 0x1000    // Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST       = 0x1000    // Bit SPI1RST.
	RCC_APB2RSTR_SPI4RST_Pos   = 0xd       // Position of SPI4RST field.
	RCC_APB2RSTR_SPI4RST_Msk   = 0x2000    // Bit mask of SPI4RST field.
	RCC_APB2RSTR_SPI4RST       = 0x2000    // Bit SPI4RST.
	RCC_APB2RSTR_SYSCFGRST_Pos = 0xe       // Position of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Msk = 0x4000    // Bit mask of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST     = 0x4000    // Bit SYSCFGRST.
	RCC_APB2RSTR_TIM9RST_Pos   = 0x10      // Position of TIM9RST field.
	RCC_APB2RSTR_TIM9RST_Msk   = 0x10000   // Bit mask of TIM9RST field.
	RCC_APB2RSTR_TIM9RST       = 0x10000   // Bit TIM9RST.
	RCC_APB2RSTR_TIM10RST_Pos  = 0x11      // Position of TIM10RST field.
	RCC_APB2RSTR_TIM10RST_Msk  = 0x20000   // Bit mask of TIM10RST field.
	RCC_APB2RSTR_TIM10RST      = 0x20000   // Bit TIM10RST.
	RCC_APB2RSTR_TIM11RST_Pos  = 0x12      // Position of TIM11RST field.
	RCC_APB2RSTR_TIM11RST_Msk  = 0x40000   // Bit mask of TIM11RST field.
	RCC_APB2RSTR_TIM11RST      = 0x40000   // Bit TIM11RST.
	RCC_APB2RSTR_SPI5RST_Pos   = 0x14      // Position of SPI5RST field.
	RCC_APB2RSTR_SPI5RST_Msk   = 0x100000  // Bit mask of SPI5RST field.
	RCC_APB2RSTR_SPI5RST       = 0x100000  // Bit SPI5RST.
	RCC_APB2RSTR_SPI6RST_Pos   = 0x15      // Position of SPI6RST field.
	RCC_APB2RSTR_SPI6RST_Msk   = 0x200000  // Bit mask of SPI6RST field.
	RCC_APB2RSTR_SPI6RST       = 0x200000  // Bit SPI6RST.
	RCC_APB2RSTR_SAI1RST_Pos   = 0x16      // Position of SAI1RST field.
	RCC_APB2RSTR_SAI1RST_Msk   = 0x400000  // Bit mask of SAI1RST field.
	RCC_APB2RSTR_SAI1RST       = 0x400000  // Bit SAI1RST.
	RCC_APB2RSTR_LTDCRST_Pos   = 0x1a      // Position of LTDCRST field.
	RCC_APB2RSTR_LTDCRST_Msk   = 0x4000000 // Bit mask of LTDCRST field.
	RCC_APB2RSTR_LTDCRST       = 0x4000000 // Bit LTDCRST.
	RCC_APB2RSTR_SAI2RST_Pos   = 0x17      // Position of SAI2RST field.
	RCC_APB2RSTR_SAI2RST_Msk   = 0x800000  // Bit mask of SAI2RST field.
	RCC_APB2RSTR_SAI2RST       = 0x800000  // Bit SAI2RST.
	RCC_APB2RSTR_SDMMC1RST_Pos = 0xb       // Position of SDMMC1RST field.
	RCC_APB2RSTR_SDMMC1RST_Msk = 0x800     // Bit mask of SDMMC1RST field.
	RCC_APB2RSTR_SDMMC1RST     = 0x800     // Bit SDMMC1RST.

	// AHB1ENR: AHB1 peripheral clock register
	RCC_AHB1ENR_OTGHSULPIEN_Pos  = 0x1e       // Position of OTGHSULPIEN field.
	RCC_AHB1ENR_OTGHSULPIEN_Msk  = 0x40000000 // Bit mask of OTGHSULPIEN field.
	RCC_AHB1ENR_OTGHSULPIEN      = 0x40000000 // Bit OTGHSULPIEN.
	RCC_AHB1ENR_OTGHSEN_Pos      = 0x1d       // Position of OTGHSEN field.
	RCC_AHB1ENR_OTGHSEN_Msk      = 0x20000000 // Bit mask of OTGHSEN field.
	RCC_AHB1ENR_OTGHSEN          = 0x20000000 // Bit OTGHSEN.
	RCC_AHB1ENR_ETHMACPTPEN_Pos  = 0x1c       // Position of ETHMACPTPEN field.
	RCC_AHB1ENR_ETHMACPTPEN_Msk  = 0x10000000 // Bit mask of ETHMACPTPEN field.
	RCC_AHB1ENR_ETHMACPTPEN      = 0x10000000 // Bit ETHMACPTPEN.
	RCC_AHB1ENR_ETHMACRXEN_Pos   = 0x1b       // Position of ETHMACRXEN field.
	RCC_AHB1ENR_ETHMACRXEN_Msk   = 0x8000000  // Bit mask of ETHMACRXEN field.
	RCC_AHB1ENR_ETHMACRXEN       = 0x8000000  // Bit ETHMACRXEN.
	RCC_AHB1ENR_ETHMACTXEN_Pos   = 0x1a       // Position of ETHMACTXEN field.
	RCC_AHB1ENR_ETHMACTXEN_Msk   = 0x4000000  // Bit mask of ETHMACTXEN field.
	RCC_AHB1ENR_ETHMACTXEN       = 0x4000000  // Bit ETHMACTXEN.
	RCC_AHB1ENR_ETHMACEN_Pos     = 0x19       // Position of ETHMACEN field.
	RCC_AHB1ENR_ETHMACEN_Msk     = 0x2000000  // Bit mask of ETHMACEN field.
	RCC_AHB1ENR_ETHMACEN         = 0x2000000  // Bit ETHMACEN.
	RCC_AHB1ENR_DMA2DEN_Pos      = 0x17       // Position of DMA2DEN field.
	RCC_AHB1ENR_DMA2DEN_Msk      = 0x800000   // Bit mask of DMA2DEN field.
	RCC_AHB1ENR_DMA2DEN          = 0x800000   // Bit DMA2DEN.
	RCC_AHB1ENR_DMA2EN_Pos       = 0x16       // Position of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Msk       = 0x400000   // Bit mask of DMA2EN field.
	RCC_AHB1ENR_DMA2EN           = 0x400000   // Bit DMA2EN.
	RCC_AHB1ENR_DMA1EN_Pos       = 0x15       // Position of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Msk       = 0x200000   // Bit mask of DMA1EN field.
	RCC_AHB1ENR_DMA1EN           = 0x200000   // Bit DMA1EN.
	RCC_AHB1ENR_CCMDATARAMEN_Pos = 0x14       // Position of CCMDATARAMEN field.
	RCC_AHB1ENR_CCMDATARAMEN_Msk = 0x100000   // Bit mask of CCMDATARAMEN field.
	RCC_AHB1ENR_CCMDATARAMEN     = 0x100000   // Bit CCMDATARAMEN.
	RCC_AHB1ENR_BKPSRAMEN_Pos    = 0x12       // Position of BKPSRAMEN field.
	RCC_AHB1ENR_BKPSRAMEN_Msk    = 0x40000    // Bit mask of BKPSRAMEN field.
	RCC_AHB1ENR_BKPSRAMEN        = 0x40000    // Bit BKPSRAMEN.
	RCC_AHB1ENR_CRCEN_Pos        = 0xc        // Position of CRCEN field.
	RCC_AHB1ENR_CRCEN_Msk        = 0x1000     // Bit mask of CRCEN field.
	RCC_AHB1ENR_CRCEN            = 0x1000     // Bit CRCEN.
	RCC_AHB1ENR_GPIOKEN_Pos      = 0xa        // Position of GPIOKEN field.
	RCC_AHB1ENR_GPIOKEN_Msk      = 0x400      // Bit mask of GPIOKEN field.
	RCC_AHB1ENR_GPIOKEN          = 0x400      // Bit GPIOKEN.
	RCC_AHB1ENR_GPIOJEN_Pos      = 0x9        // Position of GPIOJEN field.
	RCC_AHB1ENR_GPIOJEN_Msk      = 0x200      // Bit mask of GPIOJEN field.
	RCC_AHB1ENR_GPIOJEN          = 0x200      // Bit GPIOJEN.
	RCC_AHB1ENR_GPIOIEN_Pos      = 0x8        // Position of GPIOIEN field.
	RCC_AHB1ENR_GPIOIEN_Msk      = 0x100      // Bit mask of GPIOIEN field.
	RCC_AHB1ENR_GPIOIEN          = 0x100      // Bit GPIOIEN.
	RCC_AHB1ENR_GPIOHEN_Pos      = 0x7        // Position of GPIOHEN field.
	RCC_AHB1ENR_GPIOHEN_Msk      = 0x80       // Bit mask of GPIOHEN field.
	RCC_AHB1ENR_GPIOHEN          = 0x80       // Bit GPIOHEN.
	RCC_AHB1ENR_GPIOGEN_Pos      = 0x6        // Position of GPIOGEN field.
	RCC_AHB1ENR_GPIOGEN_Msk      = 0x40       // Bit mask of GPIOGEN field.
	RCC_AHB1ENR_GPIOGEN          = 0x40       // Bit GPIOGEN.
	RCC_AHB1ENR_GPIOFEN_Pos      = 0x5        // Position of GPIOFEN field.
	RCC_AHB1ENR_GPIOFEN_Msk      = 0x20       // Bit mask of GPIOFEN field.
	RCC_AHB1ENR_GPIOFEN          = 0x20       // Bit GPIOFEN.
	RCC_AHB1ENR_GPIOEEN_Pos      = 0x4        // Position of GPIOEEN field.
	RCC_AHB1ENR_GPIOEEN_Msk      = 0x10       // Bit mask of GPIOEEN field.
	RCC_AHB1ENR_GPIOEEN          = 0x10       // Bit GPIOEEN.
	RCC_AHB1ENR_GPIODEN_Pos      = 0x3        // Position of GPIODEN field.
	RCC_AHB1ENR_GPIODEN_Msk      = 0x8        // Bit mask of GPIODEN field.
	RCC_AHB1ENR_GPIODEN          = 0x8        // Bit GPIODEN.
	RCC_AHB1ENR_GPIOCEN_Pos      = 0x2        // Position of GPIOCEN field.
	RCC_AHB1ENR_GPIOCEN_Msk      = 0x4        // Bit mask of GPIOCEN field.
	RCC_AHB1ENR_GPIOCEN          = 0x4        // Bit GPIOCEN.
	RCC_AHB1ENR_GPIOBEN_Pos      = 0x1        // Position of GPIOBEN field.
	RCC_AHB1ENR_GPIOBEN_Msk      = 0x2        // Bit mask of GPIOBEN field.
	RCC_AHB1ENR_GPIOBEN          = 0x2        // Bit GPIOBEN.
	RCC_AHB1ENR_GPIOAEN_Pos      = 0x0        // Position of GPIOAEN field.
	RCC_AHB1ENR_GPIOAEN_Msk      = 0x1        // Bit mask of GPIOAEN field.
	RCC_AHB1ENR_GPIOAEN          = 0x1        // Bit GPIOAEN.

	// AHB2ENR: AHB2 peripheral clock enable           register
	RCC_AHB2ENR_OTGFSEN_Pos = 0x7  // Position of OTGFSEN field.
	RCC_AHB2ENR_OTGFSEN_Msk = 0x80 // Bit mask of OTGFSEN field.
	RCC_AHB2ENR_OTGFSEN     = 0x80 // Bit OTGFSEN.
	RCC_AHB2ENR_RNGEN_Pos   = 0x6  // Position of RNGEN field.
	RCC_AHB2ENR_RNGEN_Msk   = 0x40 // Bit mask of RNGEN field.
	RCC_AHB2ENR_RNGEN       = 0x40 // Bit RNGEN.
	RCC_AHB2ENR_HASHEN_Pos  = 0x5  // Position of HASHEN field.
	RCC_AHB2ENR_HASHEN_Msk  = 0x20 // Bit mask of HASHEN field.
	RCC_AHB2ENR_HASHEN      = 0x20 // Bit HASHEN.
	RCC_AHB2ENR_CRYPEN_Pos  = 0x4  // Position of CRYPEN field.
	RCC_AHB2ENR_CRYPEN_Msk  = 0x10 // Bit mask of CRYPEN field.
	RCC_AHB2ENR_CRYPEN      = 0x10 // Bit CRYPEN.
	RCC_AHB2ENR_DCMIEN_Pos  = 0x0  // Position of DCMIEN field.
	RCC_AHB2ENR_DCMIEN_Msk  = 0x1  // Bit mask of DCMIEN field.
	RCC_AHB2ENR_DCMIEN      = 0x1  // Bit DCMIEN.

	// AHB3ENR: AHB3 peripheral clock enable           register
	RCC_AHB3ENR_FMCEN_Pos  = 0x0 // Position of FMCEN field.
	RCC_AHB3ENR_FMCEN_Msk  = 0x1 // Bit mask of FMCEN field.
	RCC_AHB3ENR_FMCEN      = 0x1 // Bit FMCEN.
	RCC_AHB3ENR_QSPIEN_Pos = 0x1 // Position of QSPIEN field.
	RCC_AHB3ENR_QSPIEN_Msk = 0x2 // Bit mask of QSPIEN field.
	RCC_AHB3ENR_QSPIEN     = 0x2 // Bit QSPIEN.

	// APB1ENR: APB1 peripheral clock enable           register
	RCC_APB1ENR_TIM2EN_Pos    = 0x0        // Position of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Msk    = 0x1        // Bit mask of TIM2EN field.
	RCC_APB1ENR_TIM2EN        = 0x1        // Bit TIM2EN.
	RCC_APB1ENR_TIM3EN_Pos    = 0x1        // Position of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Msk    = 0x2        // Bit mask of TIM3EN field.
	RCC_APB1ENR_TIM3EN        = 0x2        // Bit TIM3EN.
	RCC_APB1ENR_TIM4EN_Pos    = 0x2        // Position of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Msk    = 0x4        // Bit mask of TIM4EN field.
	RCC_APB1ENR_TIM4EN        = 0x4        // Bit TIM4EN.
	RCC_APB1ENR_TIM5EN_Pos    = 0x3        // Position of TIM5EN field.
	RCC_APB1ENR_TIM5EN_Msk    = 0x8        // Bit mask of TIM5EN field.
	RCC_APB1ENR_TIM5EN        = 0x8        // Bit TIM5EN.
	RCC_APB1ENR_TIM6EN_Pos    = 0x4        // Position of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Msk    = 0x10       // Bit mask of TIM6EN field.
	RCC_APB1ENR_TIM6EN        = 0x10       // Bit TIM6EN.
	RCC_APB1ENR_TIM7EN_Pos    = 0x5        // Position of TIM7EN field.
	RCC_APB1ENR_TIM7EN_Msk    = 0x20       // Bit mask of TIM7EN field.
	RCC_APB1ENR_TIM7EN        = 0x20       // Bit TIM7EN.
	RCC_APB1ENR_TIM12EN_Pos   = 0x6        // Position of TIM12EN field.
	RCC_APB1ENR_TIM12EN_Msk   = 0x40       // Bit mask of TIM12EN field.
	RCC_APB1ENR_TIM12EN       = 0x40       // Bit TIM12EN.
	RCC_APB1ENR_TIM13EN_Pos   = 0x7        // Position of TIM13EN field.
	RCC_APB1ENR_TIM13EN_Msk   = 0x80       // Bit mask of TIM13EN field.
	RCC_APB1ENR_TIM13EN       = 0x80       // Bit TIM13EN.
	RCC_APB1ENR_TIM14EN_Pos   = 0x8        // Position of TIM14EN field.
	RCC_APB1ENR_TIM14EN_Msk   = 0x100      // Bit mask of TIM14EN field.
	RCC_APB1ENR_TIM14EN       = 0x100      // Bit TIM14EN.
	RCC_APB1ENR_WWDGEN_Pos    = 0xb        // Position of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Msk    = 0x800      // Bit mask of WWDGEN field.
	RCC_APB1ENR_WWDGEN        = 0x800      // Bit WWDGEN.
	RCC_APB1ENR_SPI2EN_Pos    = 0xe        // Position of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Msk    = 0x4000     // Bit mask of SPI2EN field.
	RCC_APB1ENR_SPI2EN        = 0x4000     // Bit SPI2EN.
	RCC_APB1ENR_SPI3EN_Pos    = 0xf        // Position of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Msk    = 0x8000     // Bit mask of SPI3EN field.
	RCC_APB1ENR_SPI3EN        = 0x8000     // Bit SPI3EN.
	RCC_APB1ENR_USART2EN_Pos  = 0x11       // Position of USART2EN field.
	RCC_APB1ENR_USART2EN_Msk  = 0x20000    // Bit mask of USART2EN field.
	RCC_APB1ENR_USART2EN      = 0x20000    // Bit USART2EN.
	RCC_APB1ENR_USART3EN_Pos  = 0x12       // Position of USART3EN field.
	RCC_APB1ENR_USART3EN_Msk  = 0x40000    // Bit mask of USART3EN field.
	RCC_APB1ENR_USART3EN      = 0x40000    // Bit USART3EN.
	RCC_APB1ENR_UART4EN_Pos   = 0x13       // Position of UART4EN field.
	RCC_APB1ENR_UART4EN_Msk   = 0x80000    // Bit mask of UART4EN field.
	RCC_APB1ENR_UART4EN       = 0x80000    // Bit UART4EN.
	RCC_APB1ENR_UART5EN_Pos   = 0x14       // Position of UART5EN field.
	RCC_APB1ENR_UART5EN_Msk   = 0x100000   // Bit mask of UART5EN field.
	RCC_APB1ENR_UART5EN       = 0x100000   // Bit UART5EN.
	RCC_APB1ENR_I2C1EN_Pos    = 0x15       // Position of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Msk    = 0x200000   // Bit mask of I2C1EN field.
	RCC_APB1ENR_I2C1EN        = 0x200000   // Bit I2C1EN.
	RCC_APB1ENR_I2C2EN_Pos    = 0x16       // Position of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Msk    = 0x400000   // Bit mask of I2C2EN field.
	RCC_APB1ENR_I2C2EN        = 0x400000   // Bit I2C2EN.
	RCC_APB1ENR_I2C3EN_Pos    = 0x17       // Position of I2C3EN field.
	RCC_APB1ENR_I2C3EN_Msk    = 0x800000   // Bit mask of I2C3EN field.
	RCC_APB1ENR_I2C3EN        = 0x800000   // Bit I2C3EN.
	RCC_APB1ENR_CAN1EN_Pos    = 0x19       // Position of CAN1EN field.
	RCC_APB1ENR_CAN1EN_Msk    = 0x2000000  // Bit mask of CAN1EN field.
	RCC_APB1ENR_CAN1EN        = 0x2000000  // Bit CAN1EN.
	RCC_APB1ENR_CAN2EN_Pos    = 0x1a       // Position of CAN2EN field.
	RCC_APB1ENR_CAN2EN_Msk    = 0x4000000  // Bit mask of CAN2EN field.
	RCC_APB1ENR_CAN2EN        = 0x4000000  // Bit CAN2EN.
	RCC_APB1ENR_PWREN_Pos     = 0x1c       // Position of PWREN field.
	RCC_APB1ENR_PWREN_Msk     = 0x10000000 // Bit mask of PWREN field.
	RCC_APB1ENR_PWREN         = 0x10000000 // Bit PWREN.
	RCC_APB1ENR_DACEN_Pos     = 0x1d       // Position of DACEN field.
	RCC_APB1ENR_DACEN_Msk     = 0x20000000 // Bit mask of DACEN field.
	RCC_APB1ENR_DACEN         = 0x20000000 // Bit DACEN.
	RCC_APB1ENR_UART7ENR_Pos  = 0x1e       // Position of UART7ENR field.
	RCC_APB1ENR_UART7ENR_Msk  = 0x40000000 // Bit mask of UART7ENR field.
	RCC_APB1ENR_UART7ENR      = 0x40000000 // Bit UART7ENR.
	RCC_APB1ENR_UART8ENR_Pos  = 0x1f       // Position of UART8ENR field.
	RCC_APB1ENR_UART8ENR_Msk  = 0x80000000 // Bit mask of UART8ENR field.
	RCC_APB1ENR_UART8ENR      = 0x80000000 // Bit UART8ENR.
	RCC_APB1ENR_SPDIFRXEN_Pos = 0x10       // Position of SPDIFRXEN field.
	RCC_APB1ENR_SPDIFRXEN_Msk = 0x10000    // Bit mask of SPDIFRXEN field.
	RCC_APB1ENR_SPDIFRXEN     = 0x10000    // Bit SPDIFRXEN.
	RCC_APB1ENR_CECEN_Pos     = 0x1b       // Position of CECEN field.
	RCC_APB1ENR_CECEN_Msk     = 0x8000000  // Bit mask of CECEN field.
	RCC_APB1ENR_CECEN         = 0x8000000  // Bit CECEN.
	RCC_APB1ENR_LPTMI1EN_Pos  = 0x9        // Position of LPTMI1EN field.
	RCC_APB1ENR_LPTMI1EN_Msk  = 0x200      // Bit mask of LPTMI1EN field.
	RCC_APB1ENR_LPTMI1EN      = 0x200      // Bit LPTMI1EN.
	RCC_APB1ENR_I2C4EN_Pos    = 0x18       // Position of I2C4EN field.
	RCC_APB1ENR_I2C4EN_Msk    = 0x1000000  // Bit mask of I2C4EN field.
	RCC_APB1ENR_I2C4EN        = 0x1000000  // Bit I2C4EN.

	// APB2ENR: APB2 peripheral clock enable           register
	RCC_APB2ENR_TIM1EN_Pos   = 0x0       // Position of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Msk   = 0x1       // Bit mask of TIM1EN field.
	RCC_APB2ENR_TIM1EN       = 0x1       // Bit TIM1EN.
	RCC_APB2ENR_TIM8EN_Pos   = 0x1       // Position of TIM8EN field.
	RCC_APB2ENR_TIM8EN_Msk   = 0x2       // Bit mask of TIM8EN field.
	RCC_APB2ENR_TIM8EN       = 0x2       // Bit TIM8EN.
	RCC_APB2ENR_USART1EN_Pos = 0x4       // Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x10      // Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN     = 0x10      // Bit USART1EN.
	RCC_APB2ENR_USART6EN_Pos = 0x5       // Position of USART6EN field.
	RCC_APB2ENR_USART6EN_Msk = 0x20      // Bit mask of USART6EN field.
	RCC_APB2ENR_USART6EN     = 0x20      // Bit USART6EN.
	RCC_APB2ENR_ADC1EN_Pos   = 0x8       // Position of ADC1EN field.
	RCC_APB2ENR_ADC1EN_Msk   = 0x100     // Bit mask of ADC1EN field.
	RCC_APB2ENR_ADC1EN       = 0x100     // Bit ADC1EN.
	RCC_APB2ENR_ADC2EN_Pos   = 0x9       // Position of ADC2EN field.
	RCC_APB2ENR_ADC2EN_Msk   = 0x200     // Bit mask of ADC2EN field.
	RCC_APB2ENR_ADC2EN       = 0x200     // Bit ADC2EN.
	RCC_APB2ENR_ADC3EN_Pos   = 0xa       // Position of ADC3EN field.
	RCC_APB2ENR_ADC3EN_Msk   = 0x400     // Bit mask of ADC3EN field.
	RCC_APB2ENR_ADC3EN       = 0x400     // Bit ADC3EN.
	RCC_APB2ENR_SPI1EN_Pos   = 0xc       // Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk   = 0x1000    // Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN       = 0x1000    // Bit SPI1EN.
	RCC_APB2ENR_SPI4ENR_Pos  = 0xd       // Position of SPI4ENR field.
	RCC_APB2ENR_SPI4ENR_Msk  = 0x2000    // Bit mask of SPI4ENR field.
	RCC_APB2ENR_SPI4ENR      = 0x2000    // Bit SPI4ENR.
	RCC_APB2ENR_SYSCFGEN_Pos = 0xe       // Position of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Msk = 0x4000    // Bit mask of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN     = 0x4000    // Bit SYSCFGEN.
	RCC_APB2ENR_TIM9EN_Pos   = 0x10      // Position of TIM9EN field.
	RCC_APB2ENR_TIM9EN_Msk   = 0x10000   // Bit mask of TIM9EN field.
	RCC_APB2ENR_TIM9EN       = 0x10000   // Bit TIM9EN.
	RCC_APB2ENR_TIM10EN_Pos  = 0x11      // Position of TIM10EN field.
	RCC_APB2ENR_TIM10EN_Msk  = 0x20000   // Bit mask of TIM10EN field.
	RCC_APB2ENR_TIM10EN      = 0x20000   // Bit TIM10EN.
	RCC_APB2ENR_TIM11EN_Pos  = 0x12      // Position of TIM11EN field.
	RCC_APB2ENR_TIM11EN_Msk  = 0x40000   // Bit mask of TIM11EN field.
	RCC_APB2ENR_TIM11EN      = 0x40000   // Bit TIM11EN.
	RCC_APB2ENR_SPI5ENR_Pos  = 0x14      // Position of SPI5ENR field.
	RCC_APB2ENR_SPI5ENR_Msk  = 0x100000  // Bit mask of SPI5ENR field.
	RCC_APB2ENR_SPI5ENR      = 0x100000  // Bit SPI5ENR.
	RCC_APB2ENR_SPI6ENR_Pos  = 0x15      // Position of SPI6ENR field.
	RCC_APB2ENR_SPI6ENR_Msk  = 0x200000  // Bit mask of SPI6ENR field.
	RCC_APB2ENR_SPI6ENR      = 0x200000  // Bit SPI6ENR.
	RCC_APB2ENR_SAI1EN_Pos   = 0x16      // Position of SAI1EN field.
	RCC_APB2ENR_SAI1EN_Msk   = 0x400000  // Bit mask of SAI1EN field.
	RCC_APB2ENR_SAI1EN       = 0x400000  // Bit SAI1EN.
	RCC_APB2ENR_LTDCEN_Pos   = 0x1a      // Position of LTDCEN field.
	RCC_APB2ENR_LTDCEN_Msk   = 0x4000000 // Bit mask of LTDCEN field.
	RCC_APB2ENR_LTDCEN       = 0x4000000 // Bit LTDCEN.
	RCC_APB2ENR_SAI2EN_Pos   = 0x17      // Position of SAI2EN field.
	RCC_APB2ENR_SAI2EN_Msk   = 0x800000  // Bit mask of SAI2EN field.
	RCC_APB2ENR_SAI2EN       = 0x800000  // Bit SAI2EN.
	RCC_APB2ENR_SDMMC1EN_Pos = 0xb       // Position of SDMMC1EN field.
	RCC_APB2ENR_SDMMC1EN_Msk = 0x800     // Bit mask of SDMMC1EN field.
	RCC_APB2ENR_SDMMC1EN     = 0x800     // Bit SDMMC1EN.

	// AHB1LPENR: AHB1 peripheral clock enable in low power           mode register
	RCC_AHB1LPENR_GPIOALPEN_Pos     = 0x0        // Position of GPIOALPEN field.
	RCC_AHB1LPENR_GPIOALPEN_Msk     = 0x1        // Bit mask of GPIOALPEN field.
	RCC_AHB1LPENR_GPIOALPEN         = 0x1        // Bit GPIOALPEN.
	RCC_AHB1LPENR_GPIOBLPEN_Pos     = 0x1        // Position of GPIOBLPEN field.
	RCC_AHB1LPENR_GPIOBLPEN_Msk     = 0x2        // Bit mask of GPIOBLPEN field.
	RCC_AHB1LPENR_GPIOBLPEN         = 0x2        // Bit GPIOBLPEN.
	RCC_AHB1LPENR_GPIOCLPEN_Pos     = 0x2        // Position of GPIOCLPEN field.
	RCC_AHB1LPENR_GPIOCLPEN_Msk     = 0x4        // Bit mask of GPIOCLPEN field.
	RCC_AHB1LPENR_GPIOCLPEN         = 0x4        // Bit GPIOCLPEN.
	RCC_AHB1LPENR_GPIODLPEN_Pos     = 0x3        // Position of GPIODLPEN field.
	RCC_AHB1LPENR_GPIODLPEN_Msk     = 0x8        // Bit mask of GPIODLPEN field.
	RCC_AHB1LPENR_GPIODLPEN         = 0x8        // Bit GPIODLPEN.
	RCC_AHB1LPENR_GPIOELPEN_Pos     = 0x4        // Position of GPIOELPEN field.
	RCC_AHB1LPENR_GPIOELPEN_Msk     = 0x10       // Bit mask of GPIOELPEN field.
	RCC_AHB1LPENR_GPIOELPEN         = 0x10       // Bit GPIOELPEN.
	RCC_AHB1LPENR_GPIOFLPEN_Pos     = 0x5        // Position of GPIOFLPEN field.
	RCC_AHB1LPENR_GPIOFLPEN_Msk     = 0x20       // Bit mask of GPIOFLPEN field.
	RCC_AHB1LPENR_GPIOFLPEN         = 0x20       // Bit GPIOFLPEN.
	RCC_AHB1LPENR_GPIOGLPEN_Pos     = 0x6        // Position of GPIOGLPEN field.
	RCC_AHB1LPENR_GPIOGLPEN_Msk     = 0x40       // Bit mask of GPIOGLPEN field.
	RCC_AHB1LPENR_GPIOGLPEN         = 0x40       // Bit GPIOGLPEN.
	RCC_AHB1LPENR_GPIOHLPEN_Pos     = 0x7        // Position of GPIOHLPEN field.
	RCC_AHB1LPENR_GPIOHLPEN_Msk     = 0x80       // Bit mask of GPIOHLPEN field.
	RCC_AHB1LPENR_GPIOHLPEN         = 0x80       // Bit GPIOHLPEN.
	RCC_AHB1LPENR_GPIOILPEN_Pos     = 0x8        // Position of GPIOILPEN field.
	RCC_AHB1LPENR_GPIOILPEN_Msk     = 0x100      // Bit mask of GPIOILPEN field.
	RCC_AHB1LPENR_GPIOILPEN         = 0x100      // Bit GPIOILPEN.
	RCC_AHB1LPENR_GPIOJLPEN_Pos     = 0x9        // Position of GPIOJLPEN field.
	RCC_AHB1LPENR_GPIOJLPEN_Msk     = 0x200      // Bit mask of GPIOJLPEN field.
	RCC_AHB1LPENR_GPIOJLPEN         = 0x200      // Bit GPIOJLPEN.
	RCC_AHB1LPENR_GPIOKLPEN_Pos     = 0xa        // Position of GPIOKLPEN field.
	RCC_AHB1LPENR_GPIOKLPEN_Msk     = 0x400      // Bit mask of GPIOKLPEN field.
	RCC_AHB1LPENR_GPIOKLPEN         = 0x400      // Bit GPIOKLPEN.
	RCC_AHB1LPENR_CRCLPEN_Pos       = 0xc        // Position of CRCLPEN field.
	RCC_AHB1LPENR_CRCLPEN_Msk       = 0x1000     // Bit mask of CRCLPEN field.
	RCC_AHB1LPENR_CRCLPEN           = 0x1000     // Bit CRCLPEN.
	RCC_AHB1LPENR_FLITFLPEN_Pos     = 0xf        // Position of FLITFLPEN field.
	RCC_AHB1LPENR_FLITFLPEN_Msk     = 0x8000     // Bit mask of FLITFLPEN field.
	RCC_AHB1LPENR_FLITFLPEN         = 0x8000     // Bit FLITFLPEN.
	RCC_AHB1LPENR_SRAM1LPEN_Pos     = 0x10       // Position of SRAM1LPEN field.
	RCC_AHB1LPENR_SRAM1LPEN_Msk     = 0x10000    // Bit mask of SRAM1LPEN field.
	RCC_AHB1LPENR_SRAM1LPEN         = 0x10000    // Bit SRAM1LPEN.
	RCC_AHB1LPENR_SRAM2LPEN_Pos     = 0x11       // Position of SRAM2LPEN field.
	RCC_AHB1LPENR_SRAM2LPEN_Msk     = 0x20000    // Bit mask of SRAM2LPEN field.
	RCC_AHB1LPENR_SRAM2LPEN         = 0x20000    // Bit SRAM2LPEN.
	RCC_AHB1LPENR_BKPSRAMLPEN_Pos   = 0x12       // Position of BKPSRAMLPEN field.
	RCC_AHB1LPENR_BKPSRAMLPEN_Msk   = 0x40000    // Bit mask of BKPSRAMLPEN field.
	RCC_AHB1LPENR_BKPSRAMLPEN       = 0x40000    // Bit BKPSRAMLPEN.
	RCC_AHB1LPENR_SRAM3LPEN_Pos     = 0x13       // Position of SRAM3LPEN field.
	RCC_AHB1LPENR_SRAM3LPEN_Msk     = 0x80000    // Bit mask of SRAM3LPEN field.
	RCC_AHB1LPENR_SRAM3LPEN         = 0x80000    // Bit SRAM3LPEN.
	RCC_AHB1LPENR_DMA1LPEN_Pos      = 0x15       // Position of DMA1LPEN field.
	RCC_AHB1LPENR_DMA1LPEN_Msk      = 0x200000   // Bit mask of DMA1LPEN field.
	RCC_AHB1LPENR_DMA1LPEN          = 0x200000   // Bit DMA1LPEN.
	RCC_AHB1LPENR_DMA2LPEN_Pos      = 0x16       // Position of DMA2LPEN field.
	RCC_AHB1LPENR_DMA2LPEN_Msk      = 0x400000   // Bit mask of DMA2LPEN field.
	RCC_AHB1LPENR_DMA2LPEN          = 0x400000   // Bit DMA2LPEN.
	RCC_AHB1LPENR_DMA2DLPEN_Pos     = 0x17       // Position of DMA2DLPEN field.
	RCC_AHB1LPENR_DMA2DLPEN_Msk     = 0x800000   // Bit mask of DMA2DLPEN field.
	RCC_AHB1LPENR_DMA2DLPEN         = 0x800000   // Bit DMA2DLPEN.
	RCC_AHB1LPENR_ETHMACLPEN_Pos    = 0x19       // Position of ETHMACLPEN field.
	RCC_AHB1LPENR_ETHMACLPEN_Msk    = 0x2000000  // Bit mask of ETHMACLPEN field.
	RCC_AHB1LPENR_ETHMACLPEN        = 0x2000000  // Bit ETHMACLPEN.
	RCC_AHB1LPENR_ETHMACTXLPEN_Pos  = 0x1a       // Position of ETHMACTXLPEN field.
	RCC_AHB1LPENR_ETHMACTXLPEN_Msk  = 0x4000000  // Bit mask of ETHMACTXLPEN field.
	RCC_AHB1LPENR_ETHMACTXLPEN      = 0x4000000  // Bit ETHMACTXLPEN.
	RCC_AHB1LPENR_ETHMACRXLPEN_Pos  = 0x1b       // Position of ETHMACRXLPEN field.
	RCC_AHB1LPENR_ETHMACRXLPEN_Msk  = 0x8000000  // Bit mask of ETHMACRXLPEN field.
	RCC_AHB1LPENR_ETHMACRXLPEN      = 0x8000000  // Bit ETHMACRXLPEN.
	RCC_AHB1LPENR_ETHMACPTPLPEN_Pos = 0x1c       // Position of ETHMACPTPLPEN field.
	RCC_AHB1LPENR_ETHMACPTPLPEN_Msk = 0x10000000 // Bit mask of ETHMACPTPLPEN field.
	RCC_AHB1LPENR_ETHMACPTPLPEN     = 0x10000000 // Bit ETHMACPTPLPEN.
	RCC_AHB1LPENR_OTGHSLPEN_Pos     = 0x1d       // Position of OTGHSLPEN field.
	RCC_AHB1LPENR_OTGHSLPEN_Msk     = 0x20000000 // Bit mask of OTGHSLPEN field.
	RCC_AHB1LPENR_OTGHSLPEN         = 0x20000000 // Bit OTGHSLPEN.
	RCC_AHB1LPENR_OTGHSULPILPEN_Pos = 0x1e       // Position of OTGHSULPILPEN field.
	RCC_AHB1LPENR_OTGHSULPILPEN_Msk = 0x40000000 // Bit mask of OTGHSULPILPEN field.
	RCC_AHB1LPENR_OTGHSULPILPEN     = 0x40000000 // Bit OTGHSULPILPEN.

	// AHB2LPENR: AHB2 peripheral clock enable in low power           mode register
	RCC_AHB2LPENR_OTGFSLPEN_Pos = 0x7  // Position of OTGFSLPEN field.
	RCC_AHB2LPENR_OTGFSLPEN_Msk = 0x80 // Bit mask of OTGFSLPEN field.
	RCC_AHB2LPENR_OTGFSLPEN     = 0x80 // Bit OTGFSLPEN.
	RCC_AHB2LPENR_RNGLPEN_Pos   = 0x6  // Position of RNGLPEN field.
	RCC_AHB2LPENR_RNGLPEN_Msk   = 0x40 // Bit mask of RNGLPEN field.
	RCC_AHB2LPENR_RNGLPEN       = 0x40 // Bit RNGLPEN.
	RCC_AHB2LPENR_HASHLPEN_Pos  = 0x5  // Position of HASHLPEN field.
	RCC_AHB2LPENR_HASHLPEN_Msk  = 0x20 // Bit mask of HASHLPEN field.
	RCC_AHB2LPENR_HASHLPEN      = 0x20 // Bit HASHLPEN.
	RCC_AHB2LPENR_CRYPLPEN_Pos  = 0x4  // Position of CRYPLPEN field.
	RCC_AHB2LPENR_CRYPLPEN_Msk  = 0x10 // Bit mask of CRYPLPEN field.
	RCC_AHB2LPENR_CRYPLPEN      = 0x10 // Bit CRYPLPEN.
	RCC_AHB2LPENR_DCMILPEN_Pos  = 0x0  // Position of DCMILPEN field.
	RCC_AHB2LPENR_DCMILPEN_Msk  = 0x1  // Bit mask of DCMILPEN field.
	RCC_AHB2LPENR_DCMILPEN      = 0x1  // Bit DCMILPEN.

	// AHB3LPENR: AHB3 peripheral clock enable in low power           mode register
	RCC_AHB3LPENR_FMCLPEN_Pos  = 0x0 // Position of FMCLPEN field.
	RCC_AHB3LPENR_FMCLPEN_Msk  = 0x1 // Bit mask of FMCLPEN field.
	RCC_AHB3LPENR_FMCLPEN      = 0x1 // Bit FMCLPEN.
	RCC_AHB3LPENR_QSPILPEN_Pos = 0x1 // Position of QSPILPEN field.
	RCC_AHB3LPENR_QSPILPEN_Msk = 0x2 // Bit mask of QSPILPEN field.
	RCC_AHB3LPENR_QSPILPEN     = 0x2 // Bit QSPILPEN.

	// APB1LPENR: APB1 peripheral clock enable in low power           mode register
	RCC_APB1LPENR_TIM2LPEN_Pos    = 0x0        // Position of TIM2LPEN field.
	RCC_APB1LPENR_TIM2LPEN_Msk    = 0x1        // Bit mask of TIM2LPEN field.
	RCC_APB1LPENR_TIM2LPEN        = 0x1        // Bit TIM2LPEN.
	RCC_APB1LPENR_TIM3LPEN_Pos    = 0x1        // Position of TIM3LPEN field.
	RCC_APB1LPENR_TIM3LPEN_Msk    = 0x2        // Bit mask of TIM3LPEN field.
	RCC_APB1LPENR_TIM3LPEN        = 0x2        // Bit TIM3LPEN.
	RCC_APB1LPENR_TIM4LPEN_Pos    = 0x2        // Position of TIM4LPEN field.
	RCC_APB1LPENR_TIM4LPEN_Msk    = 0x4        // Bit mask of TIM4LPEN field.
	RCC_APB1LPENR_TIM4LPEN        = 0x4        // Bit TIM4LPEN.
	RCC_APB1LPENR_TIM5LPEN_Pos    = 0x3        // Position of TIM5LPEN field.
	RCC_APB1LPENR_TIM5LPEN_Msk    = 0x8        // Bit mask of TIM5LPEN field.
	RCC_APB1LPENR_TIM5LPEN        = 0x8        // Bit TIM5LPEN.
	RCC_APB1LPENR_TIM6LPEN_Pos    = 0x4        // Position of TIM6LPEN field.
	RCC_APB1LPENR_TIM6LPEN_Msk    = 0x10       // Bit mask of TIM6LPEN field.
	RCC_APB1LPENR_TIM6LPEN        = 0x10       // Bit TIM6LPEN.
	RCC_APB1LPENR_TIM7LPEN_Pos    = 0x5        // Position of TIM7LPEN field.
	RCC_APB1LPENR_TIM7LPEN_Msk    = 0x20       // Bit mask of TIM7LPEN field.
	RCC_APB1LPENR_TIM7LPEN        = 0x20       // Bit TIM7LPEN.
	RCC_APB1LPENR_TIM12LPEN_Pos   = 0x6        // Position of TIM12LPEN field.
	RCC_APB1LPENR_TIM12LPEN_Msk   = 0x40       // Bit mask of TIM12LPEN field.
	RCC_APB1LPENR_TIM12LPEN       = 0x40       // Bit TIM12LPEN.
	RCC_APB1LPENR_TIM13LPEN_Pos   = 0x7        // Position of TIM13LPEN field.
	RCC_APB1LPENR_TIM13LPEN_Msk   = 0x80       // Bit mask of TIM13LPEN field.
	RCC_APB1LPENR_TIM13LPEN       = 0x80       // Bit TIM13LPEN.
	RCC_APB1LPENR_TIM14LPEN_Pos   = 0x8        // Position of TIM14LPEN field.
	RCC_APB1LPENR_TIM14LPEN_Msk   = 0x100      // Bit mask of TIM14LPEN field.
	RCC_APB1LPENR_TIM14LPEN       = 0x100      // Bit TIM14LPEN.
	RCC_APB1LPENR_WWDGLPEN_Pos    = 0xb        // Position of WWDGLPEN field.
	RCC_APB1LPENR_WWDGLPEN_Msk    = 0x800      // Bit mask of WWDGLPEN field.
	RCC_APB1LPENR_WWDGLPEN        = 0x800      // Bit WWDGLPEN.
	RCC_APB1LPENR_SPI2LPEN_Pos    = 0xe        // Position of SPI2LPEN field.
	RCC_APB1LPENR_SPI2LPEN_Msk    = 0x4000     // Bit mask of SPI2LPEN field.
	RCC_APB1LPENR_SPI2LPEN        = 0x4000     // Bit SPI2LPEN.
	RCC_APB1LPENR_SPI3LPEN_Pos    = 0xf        // Position of SPI3LPEN field.
	RCC_APB1LPENR_SPI3LPEN_Msk    = 0x8000     // Bit mask of SPI3LPEN field.
	RCC_APB1LPENR_SPI3LPEN        = 0x8000     // Bit SPI3LPEN.
	RCC_APB1LPENR_USART2LPEN_Pos  = 0x11       // Position of USART2LPEN field.
	RCC_APB1LPENR_USART2LPEN_Msk  = 0x20000    // Bit mask of USART2LPEN field.
	RCC_APB1LPENR_USART2LPEN      = 0x20000    // Bit USART2LPEN.
	RCC_APB1LPENR_USART3LPEN_Pos  = 0x12       // Position of USART3LPEN field.
	RCC_APB1LPENR_USART3LPEN_Msk  = 0x40000    // Bit mask of USART3LPEN field.
	RCC_APB1LPENR_USART3LPEN      = 0x40000    // Bit USART3LPEN.
	RCC_APB1LPENR_UART4LPEN_Pos   = 0x13       // Position of UART4LPEN field.
	RCC_APB1LPENR_UART4LPEN_Msk   = 0x80000    // Bit mask of UART4LPEN field.
	RCC_APB1LPENR_UART4LPEN       = 0x80000    // Bit UART4LPEN.
	RCC_APB1LPENR_UART5LPEN_Pos   = 0x14       // Position of UART5LPEN field.
	RCC_APB1LPENR_UART5LPEN_Msk   = 0x100000   // Bit mask of UART5LPEN field.
	RCC_APB1LPENR_UART5LPEN       = 0x100000   // Bit UART5LPEN.
	RCC_APB1LPENR_I2C1LPEN_Pos    = 0x15       // Position of I2C1LPEN field.
	RCC_APB1LPENR_I2C1LPEN_Msk    = 0x200000   // Bit mask of I2C1LPEN field.
	RCC_APB1LPENR_I2C1LPEN        = 0x200000   // Bit I2C1LPEN.
	RCC_APB1LPENR_I2C2LPEN_Pos    = 0x16       // Position of I2C2LPEN field.
	RCC_APB1LPENR_I2C2LPEN_Msk    = 0x400000   // Bit mask of I2C2LPEN field.
	RCC_APB1LPENR_I2C2LPEN        = 0x400000   // Bit I2C2LPEN.
	RCC_APB1LPENR_I2C3LPEN_Pos    = 0x17       // Position of I2C3LPEN field.
	RCC_APB1LPENR_I2C3LPEN_Msk    = 0x800000   // Bit mask of I2C3LPEN field.
	RCC_APB1LPENR_I2C3LPEN        = 0x800000   // Bit I2C3LPEN.
	RCC_APB1LPENR_CAN1LPEN_Pos    = 0x19       // Position of CAN1LPEN field.
	RCC_APB1LPENR_CAN1LPEN_Msk    = 0x2000000  // Bit mask of CAN1LPEN field.
	RCC_APB1LPENR_CAN1LPEN        = 0x2000000  // Bit CAN1LPEN.
	RCC_APB1LPENR_CAN2LPEN_Pos    = 0x1a       // Position of CAN2LPEN field.
	RCC_APB1LPENR_CAN2LPEN_Msk    = 0x4000000  // Bit mask of CAN2LPEN field.
	RCC_APB1LPENR_CAN2LPEN        = 0x4000000  // Bit CAN2LPEN.
	RCC_APB1LPENR_PWRLPEN_Pos     = 0x1c       // Position of PWRLPEN field.
	RCC_APB1LPENR_PWRLPEN_Msk     = 0x10000000 // Bit mask of PWRLPEN field.
	RCC_APB1LPENR_PWRLPEN         = 0x10000000 // Bit PWRLPEN.
	RCC_APB1LPENR_DACLPEN_Pos     = 0x1d       // Position of DACLPEN field.
	RCC_APB1LPENR_DACLPEN_Msk     = 0x20000000 // Bit mask of DACLPEN field.
	RCC_APB1LPENR_DACLPEN         = 0x20000000 // Bit DACLPEN.
	RCC_APB1LPENR_UART7LPEN_Pos   = 0x1e       // Position of UART7LPEN field.
	RCC_APB1LPENR_UART7LPEN_Msk   = 0x40000000 // Bit mask of UART7LPEN field.
	RCC_APB1LPENR_UART7LPEN       = 0x40000000 // Bit UART7LPEN.
	RCC_APB1LPENR_UART8LPEN_Pos   = 0x1f       // Position of UART8LPEN field.
	RCC_APB1LPENR_UART8LPEN_Msk   = 0x80000000 // Bit mask of UART8LPEN field.
	RCC_APB1LPENR_UART8LPEN       = 0x80000000 // Bit UART8LPEN.
	RCC_APB1LPENR_SPDIFRXLPEN_Pos = 0x10       // Position of SPDIFRXLPEN field.
	RCC_APB1LPENR_SPDIFRXLPEN_Msk = 0x10000    // Bit mask of SPDIFRXLPEN field.
	RCC_APB1LPENR_SPDIFRXLPEN     = 0x10000    // Bit SPDIFRXLPEN.
	RCC_APB1LPENR_CECLPEN_Pos     = 0x1b       // Position of CECLPEN field.
	RCC_APB1LPENR_CECLPEN_Msk     = 0x8000000  // Bit mask of CECLPEN field.
	RCC_APB1LPENR_CECLPEN         = 0x8000000  // Bit CECLPEN.
	RCC_APB1LPENR_LPTIM1LPEN_Pos  = 0x9        // Position of LPTIM1LPEN field.
	RCC_APB1LPENR_LPTIM1LPEN_Msk  = 0x200      // Bit mask of LPTIM1LPEN field.
	RCC_APB1LPENR_LPTIM1LPEN      = 0x200      // Bit LPTIM1LPEN.
	RCC_APB1LPENR_I2C4LPEN_Pos    = 0x18       // Position of I2C4LPEN field.
	RCC_APB1LPENR_I2C4LPEN_Msk    = 0x1000000  // Bit mask of I2C4LPEN field.
	RCC_APB1LPENR_I2C4LPEN        = 0x1000000  // Bit I2C4LPEN.

	// APB2LPENR: APB2 peripheral clock enabled in low power           mode register
	RCC_APB2LPENR_TIM1LPEN_Pos   = 0x0       // Position of TIM1LPEN field.
	RCC_APB2LPENR_TIM1LPEN_Msk   = 0x1       // Bit mask of TIM1LPEN field.
	RCC_APB2LPENR_TIM1LPEN       = 0x1       // Bit TIM1LPEN.
	RCC_APB2LPENR_TIM8LPEN_Pos   = 0x1       // Position of TIM8LPEN field.
	RCC_APB2LPENR_TIM8LPEN_Msk   = 0x2       // Bit mask of TIM8LPEN field.
	RCC_APB2LPENR_TIM8LPEN       = 0x2       // Bit TIM8LPEN.
	RCC_APB2LPENR_USART1LPEN_Pos = 0x4       // Position of USART1LPEN field.
	RCC_APB2LPENR_USART1LPEN_Msk = 0x10      // Bit mask of USART1LPEN field.
	RCC_APB2LPENR_USART1LPEN     = 0x10      // Bit USART1LPEN.
	RCC_APB2LPENR_USART6LPEN_Pos = 0x5       // Position of USART6LPEN field.
	RCC_APB2LPENR_USART6LPEN_Msk = 0x20      // Bit mask of USART6LPEN field.
	RCC_APB2LPENR_USART6LPEN     = 0x20      // Bit USART6LPEN.
	RCC_APB2LPENR_ADC1LPEN_Pos   = 0x8       // Position of ADC1LPEN field.
	RCC_APB2LPENR_ADC1LPEN_Msk   = 0x100     // Bit mask of ADC1LPEN field.
	RCC_APB2LPENR_ADC1LPEN       = 0x100     // Bit ADC1LPEN.
	RCC_APB2LPENR_ADC2LPEN_Pos   = 0x9       // Position of ADC2LPEN field.
	RCC_APB2LPENR_ADC2LPEN_Msk   = 0x200     // Bit mask of ADC2LPEN field.
	RCC_APB2LPENR_ADC2LPEN       = 0x200     // Bit ADC2LPEN.
	RCC_APB2LPENR_ADC3LPEN_Pos   = 0xa       // Position of ADC3LPEN field.
	RCC_APB2LPENR_ADC3LPEN_Msk   = 0x400     // Bit mask of ADC3LPEN field.
	RCC_APB2LPENR_ADC3LPEN       = 0x400     // Bit ADC3LPEN.
	RCC_APB2LPENR_SPI1LPEN_Pos   = 0xc       // Position of SPI1LPEN field.
	RCC_APB2LPENR_SPI1LPEN_Msk   = 0x1000    // Bit mask of SPI1LPEN field.
	RCC_APB2LPENR_SPI1LPEN       = 0x1000    // Bit SPI1LPEN.
	RCC_APB2LPENR_SPI4LPEN_Pos   = 0xd       // Position of SPI4LPEN field.
	RCC_APB2LPENR_SPI4LPEN_Msk   = 0x2000    // Bit mask of SPI4LPEN field.
	RCC_APB2LPENR_SPI4LPEN       = 0x2000    // Bit SPI4LPEN.
	RCC_APB2LPENR_SYSCFGLPEN_Pos = 0xe       // Position of SYSCFGLPEN field.
	RCC_APB2LPENR_SYSCFGLPEN_Msk = 0x4000    // Bit mask of SYSCFGLPEN field.
	RCC_APB2LPENR_SYSCFGLPEN     = 0x4000    // Bit SYSCFGLPEN.
	RCC_APB2LPENR_TIM9LPEN_Pos   = 0x10      // Position of TIM9LPEN field.
	RCC_APB2LPENR_TIM9LPEN_Msk   = 0x10000   // Bit mask of TIM9LPEN field.
	RCC_APB2LPENR_TIM9LPEN       = 0x10000   // Bit TIM9LPEN.
	RCC_APB2LPENR_TIM10LPEN_Pos  = 0x11      // Position of TIM10LPEN field.
	RCC_APB2LPENR_TIM10LPEN_Msk  = 0x20000   // Bit mask of TIM10LPEN field.
	RCC_APB2LPENR_TIM10LPEN      = 0x20000   // Bit TIM10LPEN.
	RCC_APB2LPENR_TIM11LPEN_Pos  = 0x12      // Position of TIM11LPEN field.
	RCC_APB2LPENR_TIM11LPEN_Msk  = 0x40000   // Bit mask of TIM11LPEN field.
	RCC_APB2LPENR_TIM11LPEN      = 0x40000   // Bit TIM11LPEN.
	RCC_APB2LPENR_SPI5LPEN_Pos   = 0x14      // Position of SPI5LPEN field.
	RCC_APB2LPENR_SPI5LPEN_Msk   = 0x100000  // Bit mask of SPI5LPEN field.
	RCC_APB2LPENR_SPI5LPEN       = 0x100000  // Bit SPI5LPEN.
	RCC_APB2LPENR_SPI6LPEN_Pos   = 0x15      // Position of SPI6LPEN field.
	RCC_APB2LPENR_SPI6LPEN_Msk   = 0x200000  // Bit mask of SPI6LPEN field.
	RCC_APB2LPENR_SPI6LPEN       = 0x200000  // Bit SPI6LPEN.
	RCC_APB2LPENR_SAI1LPEN_Pos   = 0x16      // Position of SAI1LPEN field.
	RCC_APB2LPENR_SAI1LPEN_Msk   = 0x400000  // Bit mask of SAI1LPEN field.
	RCC_APB2LPENR_SAI1LPEN       = 0x400000  // Bit SAI1LPEN.
	RCC_APB2LPENR_LTDCLPEN_Pos   = 0x1a      // Position of LTDCLPEN field.
	RCC_APB2LPENR_LTDCLPEN_Msk   = 0x4000000 // Bit mask of LTDCLPEN field.
	RCC_APB2LPENR_LTDCLPEN       = 0x4000000 // Bit LTDCLPEN.
	RCC_APB2LPENR_SAI2LPEN_Pos   = 0x17      // Position of SAI2LPEN field.
	RCC_APB2LPENR_SAI2LPEN_Msk   = 0x800000  // Bit mask of SAI2LPEN field.
	RCC_APB2LPENR_SAI2LPEN       = 0x800000  // Bit SAI2LPEN.
	RCC_APB2LPENR_SDMMC1LPEN_Pos = 0xb       // Position of SDMMC1LPEN field.
	RCC_APB2LPENR_SDMMC1LPEN_Msk = 0x800     // Bit mask of SDMMC1LPEN field.
	RCC_APB2LPENR_SDMMC1LPEN     = 0x800     // Bit SDMMC1LPEN.

	// BDCR: Backup domain control register
	RCC_BDCR_BDRST_Pos   = 0x10    // Position of BDRST field.
	RCC_BDCR_BDRST_Msk   = 0x10000 // Bit mask of BDRST field.
	RCC_BDCR_BDRST       = 0x10000 // Bit BDRST.
	RCC_BDCR_RTCEN_Pos   = 0xf     // Position of RTCEN field.
	RCC_BDCR_RTCEN_Msk   = 0x8000  // Bit mask of RTCEN field.
	RCC_BDCR_RTCEN       = 0x8000  // Bit RTCEN.
	RCC_BDCR_RTCSEL1_Pos = 0x9     // Position of RTCSEL1 field.
	RCC_BDCR_RTCSEL1_Msk = 0x200   // Bit mask of RTCSEL1 field.
	RCC_BDCR_RTCSEL1     = 0x200   // Bit RTCSEL1.
	RCC_BDCR_RTCSEL0_Pos = 0x8     // Position of RTCSEL0 field.
	RCC_BDCR_RTCSEL0_Msk = 0x100   // Bit mask of RTCSEL0 field.
	RCC_BDCR_RTCSEL0     = 0x100   // Bit RTCSEL0.
	RCC_BDCR_LSEBYP_Pos  = 0x2     // Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk  = 0x4     // Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP      = 0x4     // Bit LSEBYP.
	RCC_BDCR_LSERDY_Pos  = 0x1     // Position of LSERDY field.
	RCC_BDCR_LSERDY_Msk  = 0x2     // Bit mask of LSERDY field.
	RCC_BDCR_LSERDY      = 0x2     // Bit LSERDY.
	RCC_BDCR_LSEON_Pos   = 0x0     // Position of LSEON field.
	RCC_BDCR_LSEON_Msk   = 0x1     // Bit mask of LSEON field.
	RCC_BDCR_LSEON       = 0x1     // Bit LSEON.

	// CSR: clock control & status           register
	RCC_CSR_LPWRRSTF_Pos = 0x1f       // Position of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Msk = 0x80000000 // Bit mask of LPWRRSTF field.
	RCC_CSR_LPWRRSTF     = 0x80000000 // Bit LPWRRSTF.
	RCC_CSR_WWDGRSTF_Pos = 0x1e       // Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000 // Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF     = 0x40000000 // Bit WWDGRSTF.
	RCC_CSR_WDGRSTF_Pos  = 0x1d       // Position of WDGRSTF field.
	RCC_CSR_WDGRSTF_Msk  = 0x20000000 // Bit mask of WDGRSTF field.
	RCC_CSR_WDGRSTF      = 0x20000000 // Bit WDGRSTF.
	RCC_CSR_SFTRSTF_Pos  = 0x1c       // Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk  = 0x10000000 // Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF      = 0x10000000 // Bit SFTRSTF.
	RCC_CSR_PORRSTF_Pos  = 0x1b       // Position of PORRSTF field.
	RCC_CSR_PORRSTF_Msk  = 0x8000000  // Bit mask of PORRSTF field.
	RCC_CSR_PORRSTF      = 0x8000000  // Bit PORRSTF.
	RCC_CSR_PADRSTF_Pos  = 0x1a       // Position of PADRSTF field.
	RCC_CSR_PADRSTF_Msk  = 0x4000000  // Bit mask of PADRSTF field.
	RCC_CSR_PADRSTF      = 0x4000000  // Bit PADRSTF.
	RCC_CSR_BORRSTF_Pos  = 0x19       // Position of BORRSTF field.
	RCC_CSR_BORRSTF_Msk  = 0x2000000  // Bit mask of BORRSTF field.
	RCC_CSR_BORRSTF      = 0x2000000  // Bit BORRSTF.
	RCC_CSR_RMVF_Pos     = 0x18       // Position of RMVF field.
	RCC_CSR_RMVF_Msk     = 0x1000000  // Bit mask of RMVF field.
	RCC_CSR_RMVF         = 0x1000000  // Bit RMVF.
	RCC_CSR_LSIRDY_Pos   = 0x1        // Position of LSIRDY field.
	RCC_CSR_LSIRDY_Msk   = 0x2        // Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY       = 0x2        // Bit LSIRDY.
	RCC_CSR_LSION_Pos    = 0x0        // Position of LSION field.
	RCC_CSR_LSION_Msk    = 0x1        // Bit mask of LSION field.
	RCC_CSR_LSION        = 0x1        // Bit LSION.

	// SSCGR: spread spectrum clock generation           register
	RCC_SSCGR_SSCGEN_Pos    = 0x1f       // Position of SSCGEN field.
	RCC_SSCGR_SSCGEN_Msk    = 0x80000000 // Bit mask of SSCGEN field.
	RCC_SSCGR_SSCGEN        = 0x80000000 // Bit SSCGEN.
	RCC_SSCGR_SPREADSEL_Pos = 0x1e       // Position of SPREADSEL field.
	RCC_SSCGR_SPREADSEL_Msk = 0x40000000 // Bit mask of SPREADSEL field.
	RCC_SSCGR_SPREADSEL     = 0x40000000 // Bit SPREADSEL.
	RCC_SSCGR_INCSTEP_Pos   = 0xd        // Position of INCSTEP field.
	RCC_SSCGR_INCSTEP_Msk   = 0xfffe000  // Bit mask of INCSTEP field.
	RCC_SSCGR_MODPER_Pos    = 0x0        // Position of MODPER field.
	RCC_SSCGR_MODPER_Msk    = 0x1fff     // Bit mask of MODPER field.

	// PLLI2SCFGR: PLLI2S configuration register
	RCC_PLLI2SCFGR_PLLI2SR_Pos = 0x1c       // Position of PLLI2SR field.
	RCC_PLLI2SCFGR_PLLI2SR_Msk = 0x70000000 // Bit mask of PLLI2SR field.
	RCC_PLLI2SCFGR_PLLI2SQ_Pos = 0x18       // Position of PLLI2SQ field.
	RCC_PLLI2SCFGR_PLLI2SQ_Msk = 0xf000000  // Bit mask of PLLI2SQ field.
	RCC_PLLI2SCFGR_PLLI2SN_Pos = 0x6        // Position of PLLI2SN field.
	RCC_PLLI2SCFGR_PLLI2SN_Msk = 0x7fc0     // Bit mask of PLLI2SN field.

	// PLLSAICFGR: PLL configuration register
	RCC_PLLSAICFGR_PLLSAIN_Pos = 0x6        // Position of PLLSAIN field.
	RCC_PLLSAICFGR_PLLSAIN_Msk = 0x7fc0     // Bit mask of PLLSAIN field.
	RCC_PLLSAICFGR_PLLSAIP_Pos = 0x10       // Position of PLLSAIP field.
	RCC_PLLSAICFGR_PLLSAIP_Msk = 0x30000    // Bit mask of PLLSAIP field.
	RCC_PLLSAICFGR_PLLSAIQ_Pos = 0x18       // Position of PLLSAIQ field.
	RCC_PLLSAICFGR_PLLSAIQ_Msk = 0xf000000  // Bit mask of PLLSAIQ field.
	RCC_PLLSAICFGR_PLLSAIR_Pos = 0x1c       // Position of PLLSAIR field.
	RCC_PLLSAICFGR_PLLSAIR_Msk = 0x70000000 // Bit mask of PLLSAIR field.

	// DKCFGR1: dedicated clocks configuration           register
	RCC_DKCFGR1_PLLI2SDIV_Pos  = 0x0       // Position of PLLI2SDIV field.
	RCC_DKCFGR1_PLLI2SDIV_Msk  = 0x1f      // Bit mask of PLLI2SDIV field.
	RCC_DKCFGR1_PLLSAIDIVQ_Pos = 0x8       // Position of PLLSAIDIVQ field.
	RCC_DKCFGR1_PLLSAIDIVQ_Msk = 0x1f00    // Bit mask of PLLSAIDIVQ field.
	RCC_DKCFGR1_PLLSAIDIVR_Pos = 0x10      // Position of PLLSAIDIVR field.
	RCC_DKCFGR1_PLLSAIDIVR_Msk = 0x30000   // Bit mask of PLLSAIDIVR field.
	RCC_DKCFGR1_SAI1SEL_Pos    = 0x14      // Position of SAI1SEL field.
	RCC_DKCFGR1_SAI1SEL_Msk    = 0x300000  // Bit mask of SAI1SEL field.
	RCC_DKCFGR1_SAI2SEL_Pos    = 0x16      // Position of SAI2SEL field.
	RCC_DKCFGR1_SAI2SEL_Msk    = 0xc00000  // Bit mask of SAI2SEL field.
	RCC_DKCFGR1_TIMPRE_Pos     = 0x18      // Position of TIMPRE field.
	RCC_DKCFGR1_TIMPRE_Msk     = 0x1000000 // Bit mask of TIMPRE field.
	RCC_DKCFGR1_TIMPRE         = 0x1000000 // Bit TIMPRE.

	// DKCFGR2: dedicated clocks configuration           register
	RCC_DKCFGR2_USART1SEL_Pos = 0x0        // Position of USART1SEL field.
	RCC_DKCFGR2_USART1SEL_Msk = 0x3        // Bit mask of USART1SEL field.
	RCC_DKCFGR2_USART2SEL_Pos = 0x2        // Position of USART2SEL field.
	RCC_DKCFGR2_USART2SEL_Msk = 0xc        // Bit mask of USART2SEL field.
	RCC_DKCFGR2_USART3SEL_Pos = 0x4        // Position of USART3SEL field.
	RCC_DKCFGR2_USART3SEL_Msk = 0x30       // Bit mask of USART3SEL field.
	RCC_DKCFGR2_UART4SEL_Pos  = 0x6        // Position of UART4SEL field.
	RCC_DKCFGR2_UART4SEL_Msk  = 0xc0       // Bit mask of UART4SEL field.
	RCC_DKCFGR2_UART5SEL_Pos  = 0x8        // Position of UART5SEL field.
	RCC_DKCFGR2_UART5SEL_Msk  = 0x300      // Bit mask of UART5SEL field.
	RCC_DKCFGR2_USART6SEL_Pos = 0xa        // Position of USART6SEL field.
	RCC_DKCFGR2_USART6SEL_Msk = 0xc00      // Bit mask of USART6SEL field.
	RCC_DKCFGR2_UART7SEL_Pos  = 0xc        // Position of UART7SEL field.
	RCC_DKCFGR2_UART7SEL_Msk  = 0x3000     // Bit mask of UART7SEL field.
	RCC_DKCFGR2_UART8SEL_Pos  = 0xe        // Position of UART8SEL field.
	RCC_DKCFGR2_UART8SEL_Msk  = 0xc000     // Bit mask of UART8SEL field.
	RCC_DKCFGR2_I2C1SEL_Pos   = 0x10       // Position of I2C1SEL field.
	RCC_DKCFGR2_I2C1SEL_Msk   = 0x30000    // Bit mask of I2C1SEL field.
	RCC_DKCFGR2_I2C2SEL_Pos   = 0x12       // Position of I2C2SEL field.
	RCC_DKCFGR2_I2C2SEL_Msk   = 0xc0000    // Bit mask of I2C2SEL field.
	RCC_DKCFGR2_I2C3SEL_Pos   = 0x14       // Position of I2C3SEL field.
	RCC_DKCFGR2_I2C3SEL_Msk   = 0x300000   // Bit mask of I2C3SEL field.
	RCC_DKCFGR2_I2C4SEL_Pos   = 0x16       // Position of I2C4SEL field.
	RCC_DKCFGR2_I2C4SEL_Msk   = 0xc00000   // Bit mask of I2C4SEL field.
	RCC_DKCFGR2_LPTIM1SEL_Pos = 0x18       // Position of LPTIM1SEL field.
	RCC_DKCFGR2_LPTIM1SEL_Msk = 0x3000000  // Bit mask of LPTIM1SEL field.
	RCC_DKCFGR2_CECSEL_Pos    = 0x1a       // Position of CECSEL field.
	RCC_DKCFGR2_CECSEL_Msk    = 0x4000000  // Bit mask of CECSEL field.
	RCC_DKCFGR2_CECSEL        = 0x4000000  // Bit CECSEL.
	RCC_DKCFGR2_CK48MSEL_Pos  = 0x1b       // Position of CK48MSEL field.
	RCC_DKCFGR2_CK48MSEL_Msk  = 0x8000000  // Bit mask of CK48MSEL field.
	RCC_DKCFGR2_CK48MSEL      = 0x8000000  // Bit CK48MSEL.
	RCC_DKCFGR2_SDMMCSEL_Pos  = 0x1c       // Position of SDMMCSEL field.
	RCC_DKCFGR2_SDMMCSEL_Msk  = 0x10000000 // Bit mask of SDMMCSEL field.
	RCC_DKCFGR2_SDMMCSEL      = 0x10000000 // Bit SDMMCSEL.
)

// Bitfields for GPIOD: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	GPIO_MODER_MODER15_Pos = 0x1e       // Position of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000 // Bit mask of MODER15 field.
	GPIO_MODER_MODER14_Pos = 0x1c       // Position of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000 // Bit mask of MODER14 field.
	GPIO_MODER_MODER13_Pos = 0x1a       // Position of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000  // Bit mask of MODER13 field.
	GPIO_MODER_MODER12_Pos = 0x18       // Position of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000  // Bit mask of MODER12 field.
	GPIO_MODER_MODER11_Pos = 0x16       // Position of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000   // Bit mask of MODER11 field.
	GPIO_MODER_MODER10_Pos = 0x14       // Position of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000   // Bit mask of MODER10 field.
	GPIO_MODER_MODER9_Pos  = 0x12       // Position of MODER9 field.
	GPIO_MODER_MODER9_Msk  = 0xc0000    // Bit mask of MODER9 field.
	GPIO_MODER_MODER8_Pos  = 0x10       // Position of MODER8 field.
	GPIO_MODER_MODER8_Msk  = 0x30000    // Bit mask of MODER8 field.
	GPIO_MODER_MODER7_Pos  = 0xe        // Position of MODER7 field.
	GPIO_MODER_MODER7_Msk  = 0xc000     // Bit mask of MODER7 field.
	GPIO_MODER_MODER6_Pos  = 0xc        // Position of MODER6 field.
	GPIO_MODER_MODER6_Msk  = 0x3000     // Bit mask of MODER6 field.
	GPIO_MODER_MODER5_Pos  = 0xa        // Position of MODER5 field.
	GPIO_MODER_MODER5_Msk  = 0xc00      // Bit mask of MODER5 field.
	GPIO_MODER_MODER4_Pos  = 0x8        // Position of MODER4 field.
	GPIO_MODER_MODER4_Msk  = 0x300      // Bit mask of MODER4 field.
	GPIO_MODER_MODER3_Pos  = 0x6        // Position of MODER3 field.
	GPIO_MODER_MODER3_Msk  = 0xc0       // Bit mask of MODER3 field.
	GPIO_MODER_MODER2_Pos  = 0x4        // Position of MODER2 field.
	GPIO_MODER_MODER2_Msk  = 0x30       // Bit mask of MODER2 field.
	GPIO_MODER_MODER1_Pos  = 0x2        // Position of MODER1 field.
	GPIO_MODER_MODER1_Msk  = 0xc        // Bit mask of MODER1 field.
	GPIO_MODER_MODER0_Pos  = 0x0        // Position of MODER0 field.
	GPIO_MODER_MODER0_Msk  = 0x3        // Bit mask of MODER0 field.

	// OTYPER: GPIO port output type register
	GPIO_OTYPER_OT15_Pos = 0xf    // Position of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000 // Bit mask of OT15 field.
	GPIO_OTYPER_OT15     = 0x8000 // Bit OT15.
	GPIO_OTYPER_OT14_Pos = 0xe    // Position of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000 // Bit mask of OT14 field.
	GPIO_OTYPER_OT14     = 0x4000 // Bit OT14.
	GPIO_OTYPER_OT13_Pos = 0xd    // Position of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000 // Bit mask of OT13 field.
	GPIO_OTYPER_OT13     = 0x2000 // Bit OT13.
	GPIO_OTYPER_OT12_Pos = 0xc    // Position of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000 // Bit mask of OT12 field.
	GPIO_OTYPER_OT12     = 0x1000 // Bit OT12.
	GPIO_OTYPER_OT11_Pos = 0xb    // Position of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800  // Bit mask of OT11 field.
	GPIO_OTYPER_OT11     = 0x800  // Bit OT11.
	GPIO_OTYPER_OT10_Pos = 0xa    // Position of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400  // Bit mask of OT10 field.
	GPIO_OTYPER_OT10     = 0x400  // Bit OT10.
	GPIO_OTYPER_OT9_Pos  = 0x9    // Position of OT9 field.
	GPIO_OTYPER_OT9_Msk  = 0x200  // Bit mask of OT9 field.
	GPIO_OTYPER_OT9      = 0x200  // Bit OT9.
	GPIO_OTYPER_OT8_Pos  = 0x8    // Position of OT8 field.
	GPIO_OTYPER_OT8_Msk  = 0x100  // Bit mask of OT8 field.
	GPIO_OTYPER_OT8      = 0x100  // Bit OT8.
	GPIO_OTYPER_OT7_Pos  = 0x7    // Position of OT7 field.
	GPIO_OTYPER_OT7_Msk  = 0x80   // Bit mask of OT7 field.
	GPIO_OTYPER_OT7      = 0x80   // Bit OT7.
	GPIO_OTYPER_OT6_Pos  = 0x6    // Position of OT6 field.
	GPIO_OTYPER_OT6_Msk  = 0x40   // Bit mask of OT6 field.
	GPIO_OTYPER_OT6      = 0x40   // Bit OT6.
	GPIO_OTYPER_OT5_Pos  = 0x5    // Position of OT5 field.
	GPIO_OTYPER_OT5_Msk  = 0x20   // Bit mask of OT5 field.
	GPIO_OTYPER_OT5      = 0x20   // Bit OT5.
	GPIO_OTYPER_OT4_Pos  = 0x4    // Position of OT4 field.
	GPIO_OTYPER_OT4_Msk  = 0x10   // Bit mask of OT4 field.
	GPIO_OTYPER_OT4      = 0x10   // Bit OT4.
	GPIO_OTYPER_OT3_Pos  = 0x3    // Position of OT3 field.
	GPIO_OTYPER_OT3_Msk  = 0x8    // Bit mask of OT3 field.
	GPIO_OTYPER_OT3      = 0x8    // Bit OT3.
	GPIO_OTYPER_OT2_Pos  = 0x2    // Position of OT2 field.
	GPIO_OTYPER_OT2_Msk  = 0x4    // Bit mask of OT2 field.
	GPIO_OTYPER_OT2      = 0x4    // Bit OT2.
	GPIO_OTYPER_OT1_Pos  = 0x1    // Position of OT1 field.
	GPIO_OTYPER_OT1_Msk  = 0x2    // Bit mask of OT1 field.
	GPIO_OTYPER_OT1      = 0x2    // Bit OT1.
	GPIO_OTYPER_OT0_Pos  = 0x0    // Position of OT0 field.
	GPIO_OTYPER_OT0_Msk  = 0x1    // Bit mask of OT0 field.
	GPIO_OTYPER_OT0      = 0x1    // Bit OT0.

	// GPIOB_OSPEEDR: GPIO port output speed           register
	GPIO_GPIOB_OSPEEDR_OSPEEDR15_Pos = 0x1e       // Position of OSPEEDR15 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR15_Msk = 0xc0000000 // Bit mask of OSPEEDR15 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR14_Pos = 0x1c       // Position of OSPEEDR14 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR14_Msk = 0x30000000 // Bit mask of OSPEEDR14 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR13_Pos = 0x1a       // Position of OSPEEDR13 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR13_Msk = 0xc000000  // Bit mask of OSPEEDR13 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR12_Pos = 0x18       // Position of OSPEEDR12 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR12_Msk = 0x3000000  // Bit mask of OSPEEDR12 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR11_Pos = 0x16       // Position of OSPEEDR11 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR11_Msk = 0xc00000   // Bit mask of OSPEEDR11 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR10_Pos = 0x14       // Position of OSPEEDR10 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR10_Msk = 0x300000   // Bit mask of OSPEEDR10 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR9_Pos  = 0x12       // Position of OSPEEDR9 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR9_Msk  = 0xc0000    // Bit mask of OSPEEDR9 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR8_Pos  = 0x10       // Position of OSPEEDR8 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR8_Msk  = 0x30000    // Bit mask of OSPEEDR8 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR7_Pos  = 0xe        // Position of OSPEEDR7 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR7_Msk  = 0xc000     // Bit mask of OSPEEDR7 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR6_Pos  = 0xc        // Position of OSPEEDR6 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR6_Msk  = 0x3000     // Bit mask of OSPEEDR6 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR5_Pos  = 0xa        // Position of OSPEEDR5 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR5_Msk  = 0xc00      // Bit mask of OSPEEDR5 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR4_Pos  = 0x8        // Position of OSPEEDR4 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR4_Msk  = 0x300      // Bit mask of OSPEEDR4 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR3_Pos  = 0x6        // Position of OSPEEDR3 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR3_Msk  = 0xc0       // Bit mask of OSPEEDR3 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR2_Pos  = 0x4        // Position of OSPEEDR2 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR2_Msk  = 0x30       // Bit mask of OSPEEDR2 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR1_Pos  = 0x2        // Position of OSPEEDR1 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR1_Msk  = 0xc        // Bit mask of OSPEEDR1 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR0_Pos  = 0x0        // Position of OSPEEDR0 field.
	GPIO_GPIOB_OSPEEDR_OSPEEDR0_Msk  = 0x3        // Bit mask of OSPEEDR0 field.

	// PUPDR: GPIO port pull-up/pull-down           register
	GPIO_PUPDR_PUPDR15_Pos = 0x1e       // Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000 // Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c       // Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000 // Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a       // Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000  // Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18       // Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000  // Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16       // Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000   // Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14       // Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000   // Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR9_Pos  = 0x12       // Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk  = 0xc0000    // Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR8_Pos  = 0x10       // Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk  = 0x30000    // Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR7_Pos  = 0xe        // Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk  = 0xc000     // Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR6_Pos  = 0xc        // Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk  = 0x3000     // Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR5_Pos  = 0xa        // Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk  = 0xc00      // Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR4_Pos  = 0x8        // Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk  = 0x300      // Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR3_Pos  = 0x6        // Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk  = 0xc0       // Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR2_Pos  = 0x4        // Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk  = 0x30       // Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR1_Pos  = 0x2        // Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk  = 0xc        // Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR0_Pos  = 0x0        // Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk  = 0x3        // Bit mask of PUPDR0 field.

	// IDR: GPIO port input data register
	GPIO_IDR_IDR15_Pos = 0xf    // Position of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000 // Bit mask of IDR15 field.
	GPIO_IDR_IDR15     = 0x8000 // Bit IDR15.
	GPIO_IDR_IDR14_Pos = 0xe    // Position of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000 // Bit mask of IDR14 field.
	GPIO_IDR_IDR14     = 0x4000 // Bit IDR14.
	GPIO_IDR_IDR13_Pos = 0xd    // Position of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000 // Bit mask of IDR13 field.
	GPIO_IDR_IDR13     = 0x2000 // Bit IDR13.
	GPIO_IDR_IDR12_Pos = 0xc    // Position of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000 // Bit mask of IDR12 field.
	GPIO_IDR_IDR12     = 0x1000 // Bit IDR12.
	GPIO_IDR_IDR11_Pos = 0xb    // Position of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800  // Bit mask of IDR11 field.
	GPIO_IDR_IDR11     = 0x800  // Bit IDR11.
	GPIO_IDR_IDR10_Pos = 0xa    // Position of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400  // Bit mask of IDR10 field.
	GPIO_IDR_IDR10     = 0x400  // Bit IDR10.
	GPIO_IDR_IDR9_Pos  = 0x9    // Position of IDR9 field.
	GPIO_IDR_IDR9_Msk  = 0x200  // Bit mask of IDR9 field.
	GPIO_IDR_IDR9      = 0x200  // Bit IDR9.
	GPIO_IDR_IDR8_Pos  = 0x8    // Position of IDR8 field.
	GPIO_IDR_IDR8_Msk  = 0x100  // Bit mask of IDR8 field.
	GPIO_IDR_IDR8      = 0x100  // Bit IDR8.
	GPIO_IDR_IDR7_Pos  = 0x7    // Position of IDR7 field.
	GPIO_IDR_IDR7_Msk  = 0x80   // Bit mask of IDR7 field.
	GPIO_IDR_IDR7      = 0x80   // Bit IDR7.
	GPIO_IDR_IDR6_Pos  = 0x6    // Position of IDR6 field.
	GPIO_IDR_IDR6_Msk  = 0x40   // Bit mask of IDR6 field.
	GPIO_IDR_IDR6      = 0x40   // Bit IDR6.
	GPIO_IDR_IDR5_Pos  = 0x5    // Position of IDR5 field.
	GPIO_IDR_IDR5_Msk  = 0x20   // Bit mask of IDR5 field.
	GPIO_IDR_IDR5      = 0x20   // Bit IDR5.
	GPIO_IDR_IDR4_Pos  = 0x4    // Position of IDR4 field.
	GPIO_IDR_IDR4_Msk  = 0x10   // Bit mask of IDR4 field.
	GPIO_IDR_IDR4      = 0x10   // Bit IDR4.
	GPIO_IDR_IDR3_Pos  = 0x3    // Position of IDR3 field.
	GPIO_IDR_IDR3_Msk  = 0x8    // Bit mask of IDR3 field.
	GPIO_IDR_IDR3      = 0x8    // Bit IDR3.
	GPIO_IDR_IDR2_Pos  = 0x2    // Position of IDR2 field.
	GPIO_IDR_IDR2_Msk  = 0x4    // Bit mask of IDR2 field.
	GPIO_IDR_IDR2      = 0x4    // Bit IDR2.
	GPIO_IDR_IDR1_Pos  = 0x1    // Position of IDR1 field.
	GPIO_IDR_IDR1_Msk  = 0x2    // Bit mask of IDR1 field.
	GPIO_IDR_IDR1      = 0x2    // Bit IDR1.
	GPIO_IDR_IDR0_Pos  = 0x0    // Position of IDR0 field.
	GPIO_IDR_IDR0_Msk  = 0x1    // Bit mask of IDR0 field.
	GPIO_IDR_IDR0      = 0x1    // Bit IDR0.

	// ODR: GPIO port output data register
	GPIO_ODR_ODR15_Pos = 0xf    // Position of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000 // Bit mask of ODR15 field.
	GPIO_ODR_ODR15     = 0x8000 // Bit ODR15.
	GPIO_ODR_ODR14_Pos = 0xe    // Position of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000 // Bit mask of ODR14 field.
	GPIO_ODR_ODR14     = 0x4000 // Bit ODR14.
	GPIO_ODR_ODR13_Pos = 0xd    // Position of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000 // Bit mask of ODR13 field.
	GPIO_ODR_ODR13     = 0x2000 // Bit ODR13.
	GPIO_ODR_ODR12_Pos = 0xc    // Position of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000 // Bit mask of ODR12 field.
	GPIO_ODR_ODR12     = 0x1000 // Bit ODR12.
	GPIO_ODR_ODR11_Pos = 0xb    // Position of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800  // Bit mask of ODR11 field.
	GPIO_ODR_ODR11     = 0x800  // Bit ODR11.
	GPIO_ODR_ODR10_Pos = 0xa    // Position of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400  // Bit mask of ODR10 field.
	GPIO_ODR_ODR10     = 0x400  // Bit ODR10.
	GPIO_ODR_ODR9_Pos  = 0x9    // Position of ODR9 field.
	GPIO_ODR_ODR9_Msk  = 0x200  // Bit mask of ODR9 field.
	GPIO_ODR_ODR9      = 0x200  // Bit ODR9.
	GPIO_ODR_ODR8_Pos  = 0x8    // Position of ODR8 field.
	GPIO_ODR_ODR8_Msk  = 0x100  // Bit mask of ODR8 field.
	GPIO_ODR_ODR8      = 0x100  // Bit ODR8.
	GPIO_ODR_ODR7_Pos  = 0x7    // Position of ODR7 field.
	GPIO_ODR_ODR7_Msk  = 0x80   // Bit mask of ODR7 field.
	GPIO_ODR_ODR7      = 0x80   // Bit ODR7.
	GPIO_ODR_ODR6_Pos  = 0x6    // Position of ODR6 field.
	GPIO_ODR_ODR6_Msk  = 0x40   // Bit mask of ODR6 field.
	GPIO_ODR_ODR6      = 0x40   // Bit ODR6.
	GPIO_ODR_ODR5_Pos  = 0x5    // Position of ODR5 field.
	GPIO_ODR_ODR5_Msk  = 0x20   // Bit mask of ODR5 field.
	GPIO_ODR_ODR5      = 0x20   // Bit ODR5.
	GPIO_ODR_ODR4_Pos  = 0x4    // Position of ODR4 field.
	GPIO_ODR_ODR4_Msk  = 0x10   // Bit mask of ODR4 field.
	GPIO_ODR_ODR4      = 0x10   // Bit ODR4.
	GPIO_ODR_ODR3_Pos  = 0x3    // Position of ODR3 field.
	GPIO_ODR_ODR3_Msk  = 0x8    // Bit mask of ODR3 field.
	GPIO_ODR_ODR3      = 0x8    // Bit ODR3.
	GPIO_ODR_ODR2_Pos  = 0x2    // Position of ODR2 field.
	GPIO_ODR_ODR2_Msk  = 0x4    // Bit mask of ODR2 field.
	GPIO_ODR_ODR2      = 0x4    // Bit ODR2.
	GPIO_ODR_ODR1_Pos  = 0x1    // Position of ODR1 field.
	GPIO_ODR_ODR1_Msk  = 0x2    // Bit mask of ODR1 field.
	GPIO_ODR_ODR1      = 0x2    // Bit ODR1.
	GPIO_ODR_ODR0_Pos  = 0x0    // Position of ODR0 field.
	GPIO_ODR_ODR0_Msk  = 0x1    // Bit mask of ODR0 field.
	GPIO_ODR_ODR0      = 0x1    // Bit ODR0.

	// BSRR: GPIO port bit set/reset           register
	GPIO_BSRR_BR15_Pos = 0x1f       // Position of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000 // Bit mask of BR15 field.
	GPIO_BSRR_BR15     = 0x80000000 // Bit BR15.
	GPIO_BSRR_BR14_Pos = 0x1e       // Position of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000 // Bit mask of BR14 field.
	GPIO_BSRR_BR14     = 0x40000000 // Bit BR14.
	GPIO_BSRR_BR13_Pos = 0x1d       // Position of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000 // Bit mask of BR13 field.
	GPIO_BSRR_BR13     = 0x20000000 // Bit BR13.
	GPIO_BSRR_BR12_Pos = 0x1c       // Position of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000 // Bit mask of BR12 field.
	GPIO_BSRR_BR12     = 0x10000000 // Bit BR12.
	GPIO_BSRR_BR11_Pos = 0x1b       // Position of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000  // Bit mask of BR11 field.
	GPIO_BSRR_BR11     = 0x8000000  // Bit BR11.
	GPIO_BSRR_BR10_Pos = 0x1a       // Position of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000  // Bit mask of BR10 field.
	GPIO_BSRR_BR10     = 0x4000000  // Bit BR10.
	GPIO_BSRR_BR9_Pos  = 0x19       // Position of BR9 field.
	GPIO_BSRR_BR9_Msk  = 0x2000000  // Bit mask of BR9 field.
	GPIO_BSRR_BR9      = 0x2000000  // Bit BR9.
	GPIO_BSRR_BR8_Pos  = 0x18       // Position of BR8 field.
	GPIO_BSRR_BR8_Msk  = 0x1000000  // Bit mask of BR8 field.
	GPIO_BSRR_BR8      = 0x1000000  // Bit BR8.
	GPIO_BSRR_BR7_Pos  = 0x17       // Position of BR7 field.
	GPIO_BSRR_BR7_Msk  = 0x800000   // Bit mask of BR7 field.
	GPIO_BSRR_BR7      = 0x800000   // Bit BR7.
	GPIO_BSRR_BR6_Pos  = 0x16       // Position of BR6 field.
	GPIO_BSRR_BR6_Msk  = 0x400000   // Bit mask of BR6 field.
	GPIO_BSRR_BR6      = 0x400000   // Bit BR6.
	GPIO_BSRR_BR5_Pos  = 0x15       // Position of BR5 field.
	GPIO_BSRR_BR5_Msk  = 0x200000   // Bit mask of BR5 field.
	GPIO_BSRR_BR5      = 0x200000   // Bit BR5.
	GPIO_BSRR_BR4_Pos  = 0x14       // Position of BR4 field.
	GPIO_BSRR_BR4_Msk  = 0x100000   // Bit mask of BR4 field.
	GPIO_BSRR_BR4      = 0x100000   // Bit BR4.
	GPIO_BSRR_BR3_Pos  = 0x13       // Position of BR3 field.
	GPIO_BSRR_BR3_Msk  = 0x80000    // Bit mask of BR3 field.
	GPIO_BSRR_BR3      = 0x80000    // Bit BR3.
	GPIO_BSRR_BR2_Pos  = 0x12       // Position of BR2 field.
	GPIO_BSRR_BR2_Msk  = 0x40000    // Bit mask of BR2 field.
	GPIO_BSRR_BR2      = 0x40000    // Bit BR2.
	GPIO_BSRR_BR1_Pos  = 0x11       // Position of BR1 field.
	GPIO_BSRR_BR1_Msk  = 0x20000    // Bit mask of BR1 field.
	GPIO_BSRR_BR1      = 0x20000    // Bit BR1.
	GPIO_BSRR_BR0_Pos  = 0x10       // Position of BR0 field.
	GPIO_BSRR_BR0_Msk  = 0x10000    // Bit mask of BR0 field.
	GPIO_BSRR_BR0      = 0x10000    // Bit BR0.
	GPIO_BSRR_BS15_Pos = 0xf        // Position of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000     // Bit mask of BS15 field.
	GPIO_BSRR_BS15     = 0x8000     // Bit BS15.
	GPIO_BSRR_BS14_Pos = 0xe        // Position of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000     // Bit mask of BS14 field.
	GPIO_BSRR_BS14     = 0x4000     // Bit BS14.
	GPIO_BSRR_BS13_Pos = 0xd        // Position of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000     // Bit mask of BS13 field.
	GPIO_BSRR_BS13     = 0x2000     // Bit BS13.
	GPIO_BSRR_BS12_Pos = 0xc        // Position of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000     // Bit mask of BS12 field.
	GPIO_BSRR_BS12     = 0x1000     // Bit BS12.
	GPIO_BSRR_BS11_Pos = 0xb        // Position of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800      // Bit mask of BS11 field.
	GPIO_BSRR_BS11     = 0x800      // Bit BS11.
	GPIO_BSRR_BS10_Pos = 0xa        // Position of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400      // Bit mask of BS10 field.
	GPIO_BSRR_BS10     = 0x400      // Bit BS10.
	GPIO_BSRR_BS9_Pos  = 0x9        // Position of BS9 field.
	GPIO_BSRR_BS9_Msk  = 0x200      // Bit mask of BS9 field.
	GPIO_BSRR_BS9      = 0x200      // Bit BS9.
	GPIO_BSRR_BS8_Pos  = 0x8        // Position of BS8 field.
	GPIO_BSRR_BS8_Msk  = 0x100      // Bit mask of BS8 field.
	GPIO_BSRR_BS8      = 0x100      // Bit BS8.
	GPIO_BSRR_BS7_Pos  = 0x7        // Position of BS7 field.
	GPIO_BSRR_BS7_Msk  = 0x80       // Bit mask of BS7 field.
	GPIO_BSRR_BS7      = 0x80       // Bit BS7.
	GPIO_BSRR_BS6_Pos  = 0x6        // Position of BS6 field.
	GPIO_BSRR_BS6_Msk  = 0x40       // Bit mask of BS6 field.
	GPIO_BSRR_BS6      = 0x40       // Bit BS6.
	GPIO_BSRR_BS5_Pos  = 0x5        // Position of BS5 field.
	GPIO_BSRR_BS5_Msk  = 0x20       // Bit mask of BS5 field.
	GPIO_BSRR_BS5      = 0x20       // Bit BS5.
	GPIO_BSRR_BS4_Pos  = 0x4        // Position of BS4 field.
	GPIO_BSRR_BS4_Msk  = 0x10       // Bit mask of BS4 field.
	GPIO_BSRR_BS4      = 0x10       // Bit BS4.
	GPIO_BSRR_BS3_Pos  = 0x3        // Position of BS3 field.
	GPIO_BSRR_BS3_Msk  = 0x8        // Bit mask of BS3 field.
	GPIO_BSRR_BS3      = 0x8        // Bit BS3.
	GPIO_BSRR_BS2_Pos  = 0x2        // Position of BS2 field.
	GPIO_BSRR_BS2_Msk  = 0x4        // Bit mask of BS2 field.
	GPIO_BSRR_BS2      = 0x4        // Bit BS2.
	GPIO_BSRR_BS1_Pos  = 0x1        // Position of BS1 field.
	GPIO_BSRR_BS1_Msk  = 0x2        // Bit mask of BS1 field.
	GPIO_BSRR_BS1      = 0x2        // Bit BS1.
	GPIO_BSRR_BS0_Pos  = 0x0        // Position of BS0 field.
	GPIO_BSRR_BS0_Msk  = 0x1        // Bit mask of BS0 field.
	GPIO_BSRR_BS0      = 0x1        // Bit BS0.

	// LCKR: GPIO port configuration lock           register
	GPIO_LCKR_LCKK_Pos  = 0x10    // Position of LCKK field.
	GPIO_LCKR_LCKK_Msk  = 0x10000 // Bit mask of LCKK field.
	GPIO_LCKR_LCKK      = 0x10000 // Bit LCKK.
	GPIO_LCKR_LCK15_Pos = 0xf     // Position of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000  // Bit mask of LCK15 field.
	GPIO_LCKR_LCK15     = 0x8000  // Bit LCK15.
	GPIO_LCKR_LCK14_Pos = 0xe     // Position of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000  // Bit mask of LCK14 field.
	GPIO_LCKR_LCK14     = 0x4000  // Bit LCK14.
	GPIO_LCKR_LCK13_Pos = 0xd     // Position of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000  // Bit mask of LCK13 field.
	GPIO_LCKR_LCK13     = 0x2000  // Bit LCK13.
	GPIO_LCKR_LCK12_Pos = 0xc     // Position of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000  // Bit mask of LCK12 field.
	GPIO_LCKR_LCK12     = 0x1000  // Bit LCK12.
	GPIO_LCKR_LCK11_Pos = 0xb     // Position of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800   // Bit mask of LCK11 field.
	GPIO_LCKR_LCK11     = 0x800   // Bit LCK11.
	GPIO_LCKR_LCK10_Pos = 0xa     // Position of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400   // Bit mask of LCK10 field.
	GPIO_LCKR_LCK10     = 0x400   // Bit LCK10.
	GPIO_LCKR_LCK9_Pos  = 0x9     // Position of LCK9 field.
	GPIO_LCKR_LCK9_Msk  = 0x200   // Bit mask of LCK9 field.
	GPIO_LCKR_LCK9      = 0x200   // Bit LCK9.
	GPIO_LCKR_LCK8_Pos  = 0x8     // Position of LCK8 field.
	GPIO_LCKR_LCK8_Msk  = 0x100   // Bit mask of LCK8 field.
	GPIO_LCKR_LCK8      = 0x100   // Bit LCK8.
	GPIO_LCKR_LCK7_Pos  = 0x7     // Position of LCK7 field.
	GPIO_LCKR_LCK7_Msk  = 0x80    // Bit mask of LCK7 field.
	GPIO_LCKR_LCK7      = 0x80    // Bit LCK7.
	GPIO_LCKR_LCK6_Pos  = 0x6     // Position of LCK6 field.
	GPIO_LCKR_LCK6_Msk  = 0x40    // Bit mask of LCK6 field.
	GPIO_LCKR_LCK6      = 0x40    // Bit LCK6.
	GPIO_LCKR_LCK5_Pos  = 0x5     // Position of LCK5 field.
	GPIO_LCKR_LCK5_Msk  = 0x20    // Bit mask of LCK5 field.
	GPIO_LCKR_LCK5      = 0x20    // Bit LCK5.
	GPIO_LCKR_LCK4_Pos  = 0x4     // Position of LCK4 field.
	GPIO_LCKR_LCK4_Msk  = 0x10    // Bit mask of LCK4 field.
	GPIO_LCKR_LCK4      = 0x10    // Bit LCK4.
	GPIO_LCKR_LCK3_Pos  = 0x3     // Position of LCK3 field.
	GPIO_LCKR_LCK3_Msk  = 0x8     // Bit mask of LCK3 field.
	GPIO_LCKR_LCK3      = 0x8     // Bit LCK3.
	GPIO_LCKR_LCK2_Pos  = 0x2     // Position of LCK2 field.
	GPIO_LCKR_LCK2_Msk  = 0x4     // Bit mask of LCK2 field.
	GPIO_LCKR_LCK2      = 0x4     // Bit LCK2.
	GPIO_LCKR_LCK1_Pos  = 0x1     // Position of LCK1 field.
	GPIO_LCKR_LCK1_Msk  = 0x2     // Bit mask of LCK1 field.
	GPIO_LCKR_LCK1      = 0x2     // Bit LCK1.
	GPIO_LCKR_LCK0_Pos  = 0x0     // Position of LCK0 field.
	GPIO_LCKR_LCK0_Msk  = 0x1     // Bit mask of LCK0 field.
	GPIO_LCKR_LCK0      = 0x1     // Bit LCK0.

	// AFRL: GPIO alternate function           lowregister
	GPIO_AFRL_AFRL7_Pos = 0x1c       // Position of AFRL7 field.
	GPIO_AFRL_AFRL7_Msk = 0xf0000000 // Bit mask of AFRL7 field.
	GPIO_AFRL_AFRL6_Pos = 0x18       // Position of AFRL6 field.
	GPIO_AFRL_AFRL6_Msk = 0xf000000  // Bit mask of AFRL6 field.
	GPIO_AFRL_AFRL5_Pos = 0x14       // Position of AFRL5 field.
	GPIO_AFRL_AFRL5_Msk = 0xf00000   // Bit mask of AFRL5 field.
	GPIO_AFRL_AFRL4_Pos = 0x10       // Position of AFRL4 field.
	GPIO_AFRL_AFRL4_Msk = 0xf0000    // Bit mask of AFRL4 field.
	GPIO_AFRL_AFRL3_Pos = 0xc        // Position of AFRL3 field.
	GPIO_AFRL_AFRL3_Msk = 0xf000     // Bit mask of AFRL3 field.
	GPIO_AFRL_AFRL2_Pos = 0x8        // Position of AFRL2 field.
	GPIO_AFRL_AFRL2_Msk = 0xf00      // Bit mask of AFRL2 field.
	GPIO_AFRL_AFRL1_Pos = 0x4        // Position of AFRL1 field.
	GPIO_AFRL_AFRL1_Msk = 0xf0       // Bit mask of AFRL1 field.
	GPIO_AFRL_AFRL0_Pos = 0x0        // Position of AFRL0 field.
	GPIO_AFRL_AFRL0_Msk = 0xf        // Bit mask of AFRL0 field.

	// AFRH: GPIO alternate function high           register
	GPIO_AFRH_AFRH15_Pos = 0x1c       // Position of AFRH15 field.
	GPIO_AFRH_AFRH15_Msk = 0xf0000000 // Bit mask of AFRH15 field.
	GPIO_AFRH_AFRH14_Pos = 0x18       // Position of AFRH14 field.
	GPIO_AFRH_AFRH14_Msk = 0xf000000  // Bit mask of AFRH14 field.
	GPIO_AFRH_AFRH13_Pos = 0x14       // Position of AFRH13 field.
	GPIO_AFRH_AFRH13_Msk = 0xf00000   // Bit mask of AFRH13 field.
	GPIO_AFRH_AFRH12_Pos = 0x10       // Position of AFRH12 field.
	GPIO_AFRH_AFRH12_Msk = 0xf0000    // Bit mask of AFRH12 field.
	GPIO_AFRH_AFRH11_Pos = 0xc        // Position of AFRH11 field.
	GPIO_AFRH_AFRH11_Msk = 0xf000     // Bit mask of AFRH11 field.
	GPIO_AFRH_AFRH10_Pos = 0x8        // Position of AFRH10 field.
	GPIO_AFRH_AFRH10_Msk = 0xf00      // Bit mask of AFRH10 field.
	GPIO_AFRH_AFRH9_Pos  = 0x4        // Position of AFRH9 field.
	GPIO_AFRH_AFRH9_Msk  = 0xf0       // Bit mask of AFRH9 field.
	GPIO_AFRH_AFRH8_Pos  = 0x0        // Position of AFRH8 field.
	GPIO_AFRH_AFRH8_Msk  = 0xf        // Bit mask of AFRH8 field.

	// BRR: GPIO port bit reset register
	GPIO_BRR_BR0_Pos  = 0x0    // Position of BR0 field.
	GPIO_BRR_BR0_Msk  = 0x1    // Bit mask of BR0 field.
	GPIO_BRR_BR0      = 0x1    // Bit BR0.
	GPIO_BRR_BR1_Pos  = 0x1    // Position of BR1 field.
	GPIO_BRR_BR1_Msk  = 0x2    // Bit mask of BR1 field.
	GPIO_BRR_BR1      = 0x2    // Bit BR1.
	GPIO_BRR_BR2_Pos  = 0x2    // Position of BR2 field.
	GPIO_BRR_BR2_Msk  = 0x4    // Bit mask of BR2 field.
	GPIO_BRR_BR2      = 0x4    // Bit BR2.
	GPIO_BRR_BR3_Pos  = 0x3    // Position of BR3 field.
	GPIO_BRR_BR3_Msk  = 0x8    // Bit mask of BR3 field.
	GPIO_BRR_BR3      = 0x8    // Bit BR3.
	GPIO_BRR_BR4_Pos  = 0x4    // Position of BR4 field.
	GPIO_BRR_BR4_Msk  = 0x10   // Bit mask of BR4 field.
	GPIO_BRR_BR4      = 0x10   // Bit BR4.
	GPIO_BRR_BR5_Pos  = 0x5    // Position of BR5 field.
	GPIO_BRR_BR5_Msk  = 0x20   // Bit mask of BR5 field.
	GPIO_BRR_BR5      = 0x20   // Bit BR5.
	GPIO_BRR_BR6_Pos  = 0x6    // Position of BR6 field.
	GPIO_BRR_BR6_Msk  = 0x40   // Bit mask of BR6 field.
	GPIO_BRR_BR6      = 0x40   // Bit BR6.
	GPIO_BRR_BR7_Pos  = 0x7    // Position of BR7 field.
	GPIO_BRR_BR7_Msk  = 0x80   // Bit mask of BR7 field.
	GPIO_BRR_BR7      = 0x80   // Bit BR7.
	GPIO_BRR_BR8_Pos  = 0x8    // Position of BR8 field.
	GPIO_BRR_BR8_Msk  = 0x100  // Bit mask of BR8 field.
	GPIO_BRR_BR8      = 0x100  // Bit BR8.
	GPIO_BRR_BR9_Pos  = 0x9    // Position of BR9 field.
	GPIO_BRR_BR9_Msk  = 0x200  // Bit mask of BR9 field.
	GPIO_BRR_BR9      = 0x200  // Bit BR9.
	GPIO_BRR_BR10_Pos = 0xa    // Position of BR10 field.
	GPIO_BRR_BR10_Msk = 0x400  // Bit mask of BR10 field.
	GPIO_BRR_BR10     = 0x400  // Bit BR10.
	GPIO_BRR_BR11_Pos = 0xb    // Position of BR11 field.
	GPIO_BRR_BR11_Msk = 0x800  // Bit mask of BR11 field.
	GPIO_BRR_BR11     = 0x800  // Bit BR11.
	GPIO_BRR_BR12_Pos = 0xc    // Position of BR12 field.
	GPIO_BRR_BR12_Msk = 0x1000 // Bit mask of BR12 field.
	GPIO_BRR_BR12     = 0x1000 // Bit BR12.
	GPIO_BRR_BR13_Pos = 0xd    // Position of BR13 field.
	GPIO_BRR_BR13_Msk = 0x2000 // Bit mask of BR13 field.
	GPIO_BRR_BR13     = 0x2000 // Bit BR13.
	GPIO_BRR_BR14_Pos = 0xe    // Position of BR14 field.
	GPIO_BRR_BR14_Msk = 0x4000 // Bit mask of BR14 field.
	GPIO_BRR_BR14     = 0x4000 // Bit BR14.
	GPIO_BRR_BR15_Pos = 0xf    // Position of BR15 field.
	GPIO_BRR_BR15_Msk = 0x8000 // Bit mask of BR15 field.
	GPIO_BRR_BR15     = 0x8000 // Bit BR15.
)

// Bitfields for SYSCFG: System configuration controller
const (
	// MEMRM: memory remap register
	SYSCFG_MEMRM_MEM_MODE_Pos = 0x0   // Position of MEM_MODE field.
	SYSCFG_MEMRM_MEM_MODE_Msk = 0x7   // Bit mask of MEM_MODE field.
	SYSCFG_MEMRM_FB_MODE_Pos  = 0x8   // Position of FB_MODE field.
	SYSCFG_MEMRM_FB_MODE_Msk  = 0x100 // Bit mask of FB_MODE field.
	SYSCFG_MEMRM_FB_MODE      = 0x100 // Bit FB_MODE.
	SYSCFG_MEMRM_SWP_FMC_Pos  = 0xa   // Position of SWP_FMC field.
	SYSCFG_MEMRM_SWP_FMC_Msk  = 0xc00 // Bit mask of SWP_FMC field.

	// PMC: peripheral mode configuration           register
	SYSCFG_PMC_MII_RMII_SEL_Pos = 0x17     // Position of MII_RMII_SEL field.
	SYSCFG_PMC_MII_RMII_SEL_Msk = 0x800000 // Bit mask of MII_RMII_SEL field.
	SYSCFG_PMC_MII_RMII_SEL     = 0x800000 // Bit MII_RMII_SEL.
	SYSCFG_PMC_ADC1DC2_Pos      = 0x10     // Position of ADC1DC2 field.
	SYSCFG_PMC_ADC1DC2_Msk      = 0x10000  // Bit mask of ADC1DC2 field.
	SYSCFG_PMC_ADC1DC2          = 0x10000  // Bit ADC1DC2.
	SYSCFG_PMC_ADC2DC2_Pos      = 0x11     // Position of ADC2DC2 field.
	SYSCFG_PMC_ADC2DC2_Msk      = 0x20000  // Bit mask of ADC2DC2 field.
	SYSCFG_PMC_ADC2DC2          = 0x20000  // Bit ADC2DC2.
	SYSCFG_PMC_ADC3DC2_Pos      = 0x12     // Position of ADC3DC2 field.
	SYSCFG_PMC_ADC3DC2_Msk      = 0x40000  // Bit mask of ADC3DC2 field.
	SYSCFG_PMC_ADC3DC2          = 0x40000  // Bit ADC3DC2.

	// EXTICR1: external interrupt configuration register           1
	SYSCFG_EXTICR1_EXTI3_Pos = 0xc    // Position of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Msk = 0xf000 // Bit mask of EXTI3 field.
	SYSCFG_EXTICR1_EXTI2_Pos = 0x8    // Position of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Msk = 0xf00  // Bit mask of EXTI2 field.
	SYSCFG_EXTICR1_EXTI1_Pos = 0x4    // Position of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Msk = 0xf0   // Bit mask of EXTI1 field.
	SYSCFG_EXTICR1_EXTI0_Pos = 0x0    // Position of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Msk = 0xf    // Bit mask of EXTI0 field.

	// EXTICR2: external interrupt configuration register           2
	SYSCFG_EXTICR2_EXTI7_Pos = 0xc    // Position of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Msk = 0xf000 // Bit mask of EXTI7 field.
	SYSCFG_EXTICR2_EXTI6_Pos = 0x8    // Position of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Msk = 0xf00  // Bit mask of EXTI6 field.
	SYSCFG_EXTICR2_EXTI5_Pos = 0x4    // Position of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Msk = 0xf0   // Bit mask of EXTI5 field.
	SYSCFG_EXTICR2_EXTI4_Pos = 0x0    // Position of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Msk = 0xf    // Bit mask of EXTI4 field.

	// EXTICR3: external interrupt configuration register           3
	SYSCFG_EXTICR3_EXTI11_Pos = 0xc    // Position of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Msk = 0xf000 // Bit mask of EXTI11 field.
	SYSCFG_EXTICR3_EXTI10_Pos = 0x8    // Position of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Msk = 0xf00  // Bit mask of EXTI10 field.
	SYSCFG_EXTICR3_EXTI9_Pos  = 0x4    // Position of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Msk  = 0xf0   // Bit mask of EXTI9 field.
	SYSCFG_EXTICR3_EXTI8_Pos  = 0x0    // Position of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Msk  = 0xf    // Bit mask of EXTI8 field.

	// EXTICR4: external interrupt configuration register           4
	SYSCFG_EXTICR4_EXTI15_Pos = 0xc    // Position of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Msk = 0xf000 // Bit mask of EXTI15 field.
	SYSCFG_EXTICR4_EXTI14_Pos = 0x8    // Position of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Msk = 0xf00  // Bit mask of EXTI14 field.
	SYSCFG_EXTICR4_EXTI13_Pos = 0x4    // Position of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Msk = 0xf0   // Bit mask of EXTI13 field.
	SYSCFG_EXTICR4_EXTI12_Pos = 0x0    // Position of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Msk = 0xf    // Bit mask of EXTI12 field.

	// CMPCR: Compensation cell control           register
	SYSCFG_CMPCR_READY_Pos  = 0x8   // Position of READY field.
	SYSCFG_CMPCR_READY_Msk  = 0x100 // Bit mask of READY field.
	SYSCFG_CMPCR_READY      = 0x100 // Bit READY.
	SYSCFG_CMPCR_CMP_PD_Pos = 0x0   // Position of CMP_PD field.
	SYSCFG_CMPCR_CMP_PD_Msk = 0x1   // Bit mask of CMP_PD field.
	SYSCFG_CMPCR_CMP_PD     = 0x1   // Bit CMP_PD.
)

// Bitfields for SPI1: Serial peripheral interface
const (
	// CR1: control register 1
	SPI_CR1_BIDIMODE_Pos = 0xf    // Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000 // Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE     = 0x8000 // Bit BIDIMODE.
	SPI_CR1_BIDIOE_Pos   = 0xe    // Position of BIDIOE field.
	SPI_CR1_BIDIOE_Msk   = 0x4000 // Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE       = 0x4000 // Bit BIDIOE.
	SPI_CR1_CRCEN_Pos    = 0xd    // Position of CRCEN field.
	SPI_CR1_CRCEN_Msk    = 0x2000 // Bit mask of CRCEN field.
	SPI_CR1_CRCEN        = 0x2000 // Bit CRCEN.
	SPI_CR1_CRCNEXT_Pos  = 0xc    // Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk  = 0x1000 // Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT      = 0x1000 // Bit CRCNEXT.
	SPI_CR1_CRCL_Pos     = 0xb    // Position of CRCL field.
	SPI_CR1_CRCL_Msk     = 0x800  // Bit mask of CRCL field.
	SPI_CR1_CRCL         = 0x800  // Bit CRCL.
	SPI_CR1_RXONLY_Pos   = 0xa    // Position of RXONLY field.
	SPI_CR1_RXONLY_Msk   = 0x400  // Bit mask of RXONLY field.
	SPI_CR1_RXONLY       = 0x400  // Bit RXONLY.
	SPI_CR1_SSM_Pos      = 0x9    // Position of SSM field.
	SPI_CR1_SSM_Msk      = 0x200  // Bit mask of SSM field.
	SPI_CR1_SSM          = 0x200  // Bit SSM.
	SPI_CR1_SSI_Pos      = 0x8    // Position of SSI field.
	SPI_CR1_SSI_Msk      = 0x100  // Bit mask of SSI field.
	SPI_CR1_SSI          = 0x100  // Bit SSI.
	SPI_CR1_LSBFIRST_Pos = 0x7    // Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80   // Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST     = 0x80   // Bit LSBFIRST.
	SPI_CR1_SPE_Pos      = 0x6    // Position of SPE field.
	SPI_CR1_SPE_Msk      = 0x40   // Bit mask of SPE field.
	SPI_CR1_SPE          = 0x40   // Bit SPE.
	SPI_CR1_BR_Pos       = 0x3    // Position of BR field.
	SPI_CR1_BR_Msk       = 0x38   // Bit mask of BR field.
	SPI_CR1_MSTR_Pos     = 0x2    // Position of MSTR field.
	SPI_CR1_MSTR_Msk     = 0x4    // Bit mask of MSTR field.
	SPI_CR1_MSTR         = 0x4    // Bit MSTR.
	SPI_CR1_CPOL_Pos     = 0x1    // Position of CPOL field.
	SPI_CR1_CPOL_Msk     = 0x2    // Bit mask of CPOL field.
	SPI_CR1_CPOL         = 0x2    // Bit CPOL.
	SPI_CR1_CPHA_Pos     = 0x0    // Position of CPHA field.
	SPI_CR1_CPHA_Msk     = 0x1    // Bit mask of CPHA field.
	SPI_CR1_CPHA         = 0x1    // Bit CPHA.

	// CR2: control register 2
	SPI_CR2_RXDMAEN_Pos = 0x0    // Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1    // Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN     = 0x1    // Bit RXDMAEN.
	SPI_CR2_TXDMAEN_Pos = 0x1    // Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2    // Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN     = 0x2    // Bit TXDMAEN.
	SPI_CR2_SSOE_Pos    = 0x2    // Position of SSOE field.
	SPI_CR2_SSOE_Msk    = 0x4    // Bit mask of SSOE field.
	SPI_CR2_SSOE        = 0x4    // Bit SSOE.
	SPI_CR2_NSSP_Pos    = 0x3    // Position of NSSP field.
	SPI_CR2_NSSP_Msk    = 0x8    // Bit mask of NSSP field.
	SPI_CR2_NSSP        = 0x8    // Bit NSSP.
	SPI_CR2_FRF_Pos     = 0x4    // Position of FRF field.
	SPI_CR2_FRF_Msk     = 0x10   // Bit mask of FRF field.
	SPI_CR2_FRF         = 0x10   // Bit FRF.
	SPI_CR2_ERRIE_Pos   = 0x5    // Position of ERRIE field.
	SPI_CR2_ERRIE_Msk   = 0x20   // Bit mask of ERRIE field.
	SPI_CR2_ERRIE       = 0x20   // Bit ERRIE.
	SPI_CR2_RXNEIE_Pos  = 0x6    // Position of RXNEIE field.
	SPI_CR2_RXNEIE_Msk  = 0x40   // Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE      = 0x40   // Bit RXNEIE.
	SPI_CR2_TXEIE_Pos   = 0x7    // Position of TXEIE field.
	SPI_CR2_TXEIE_Msk   = 0x80   // Bit mask of TXEIE field.
	SPI_CR2_TXEIE       = 0x80   // Bit TXEIE.
	SPI_CR2_DS_Pos      = 0x8    // Position of DS field.
	SPI_CR2_DS_Msk      = 0xf00  // Bit mask of DS field.
	SPI_CR2_FRXTH_Pos   = 0xc    // Position of FRXTH field.
	SPI_CR2_FRXTH_Msk   = 0x1000 // Bit mask of FRXTH field.
	SPI_CR2_FRXTH       = 0x1000 // Bit FRXTH.
	SPI_CR2_LDMA_RX_Pos = 0xd    // Position of LDMA_RX field.
	SPI_CR2_LDMA_RX_Msk = 0x2000 // Bit mask of LDMA_RX field.
	SPI_CR2_LDMA_RX     = 0x2000 // Bit LDMA_RX.
	SPI_CR2_LDMA_TX_Pos = 0xe    // Position of LDMA_TX field.
	SPI_CR2_LDMA_TX_Msk = 0x4000 // Bit mask of LDMA_TX field.
	SPI_CR2_LDMA_TX     = 0x4000 // Bit LDMA_TX.

	// SR: status register
	SPI_SR_FRE_Pos    = 0x8    // Position of FRE field.
	SPI_SR_FRE_Msk    = 0x100  // Bit mask of FRE field.
	SPI_SR_FRE        = 0x100  // Bit FRE.
	SPI_SR_BSY_Pos    = 0x7    // Position of BSY field.
	SPI_SR_BSY_Msk    = 0x80   // Bit mask of BSY field.
	SPI_SR_BSY        = 0x80   // Bit BSY.
	SPI_SR_OVR_Pos    = 0x6    // Position of OVR field.
	SPI_SR_OVR_Msk    = 0x40   // Bit mask of OVR field.
	SPI_SR_OVR        = 0x40   // Bit OVR.
	SPI_SR_MODF_Pos   = 0x5    // Position of MODF field.
	SPI_SR_MODF_Msk   = 0x20   // Bit mask of MODF field.
	SPI_SR_MODF       = 0x20   // Bit MODF.
	SPI_SR_CRCERR_Pos = 0x4    // Position of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10   // Bit mask of CRCERR field.
	SPI_SR_CRCERR     = 0x10   // Bit CRCERR.
	SPI_SR_UDR_Pos    = 0x3    // Position of UDR field.
	SPI_SR_UDR_Msk    = 0x8    // Bit mask of UDR field.
	SPI_SR_UDR        = 0x8    // Bit UDR.
	SPI_SR_CHSIDE_Pos = 0x2    // Position of CHSIDE field.
	SPI_SR_CHSIDE_Msk = 0x4    // Bit mask of CHSIDE field.
	SPI_SR_CHSIDE     = 0x4    // Bit CHSIDE.
	SPI_SR_TXE_Pos    = 0x1    // Position of TXE field.
	SPI_SR_TXE_Msk    = 0x2    // Bit mask of TXE field.
	SPI_SR_TXE        = 0x2    // Bit TXE.
	SPI_SR_RXNE_Pos   = 0x0    // Position of RXNE field.
	SPI_SR_RXNE_Msk   = 0x1    // Bit mask of RXNE field.
	SPI_SR_RXNE       = 0x1    // Bit RXNE.
	SPI_SR_FRLVL_Pos  = 0x9    // Position of FRLVL field.
	SPI_SR_FRLVL_Msk  = 0x600  // Bit mask of FRLVL field.
	SPI_SR_FTLVL_Pos  = 0xb    // Position of FTLVL field.
	SPI_SR_FTLVL_Msk  = 0x1800 // Bit mask of FTLVL field.

	// DR: data register
	SPI_DR_DR_Pos = 0x0    // Position of DR field.
	SPI_DR_DR_Msk = 0xffff // Bit mask of DR field.

	// CRCPR: CRC polynomial register
	SPI_CRCPR_CRCPOLY_Pos = 0x0    // Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff // Bit mask of CRCPOLY field.

	// RXCRCR: RX CRC register
	SPI_RXCRCR_RxCRC_Pos = 0x0    // Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff // Bit mask of RxCRC field.

	// TXCRCR: TX CRC register
	SPI_TXCRCR_TxCRC_Pos = 0x0    // Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff // Bit mask of TxCRC field.

	// I2SCFGR: I2S configuration register
	SPI_I2SCFGR_I2SMOD_Pos  = 0xb    // Position of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Msk  = 0x800  // Bit mask of I2SMOD field.
	SPI_I2SCFGR_I2SMOD      = 0x800  // Bit I2SMOD.
	SPI_I2SCFGR_I2SE_Pos    = 0xa    // Position of I2SE field.
	SPI_I2SCFGR_I2SE_Msk    = 0x400  // Bit mask of I2SE field.
	SPI_I2SCFGR_I2SE        = 0x400  // Bit I2SE.
	SPI_I2SCFGR_I2SCFG_Pos  = 0x8    // Position of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Msk  = 0x300  // Bit mask of I2SCFG field.
	SPI_I2SCFGR_PCMSYNC_Pos = 0x7    // Position of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Msk = 0x80   // Bit mask of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC     = 0x80   // Bit PCMSYNC.
	SPI_I2SCFGR_I2SSTD_Pos  = 0x4    // Position of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Msk  = 0x30   // Bit mask of I2SSTD field.
	SPI_I2SCFGR_CKPOL_Pos   = 0x3    // Position of CKPOL field.
	SPI_I2SCFGR_CKPOL_Msk   = 0x8    // Bit mask of CKPOL field.
	SPI_I2SCFGR_CKPOL       = 0x8    // Bit CKPOL.
	SPI_I2SCFGR_DATLEN_Pos  = 0x1    // Position of DATLEN field.
	SPI_I2SCFGR_DATLEN_Msk  = 0x6    // Bit mask of DATLEN field.
	SPI_I2SCFGR_CHLEN_Pos   = 0x0    // Position of CHLEN field.
	SPI_I2SCFGR_CHLEN_Msk   = 0x1    // Bit mask of CHLEN field.
	SPI_I2SCFGR_CHLEN       = 0x1    // Bit CHLEN.
	SPI_I2SCFGR_ASTRTEN_Pos = 0xc    // Position of ASTRTEN field.
	SPI_I2SCFGR_ASTRTEN_Msk = 0x1000 // Bit mask of ASTRTEN field.
	SPI_I2SCFGR_ASTRTEN     = 0x1000 // Bit ASTRTEN.

	// I2SPR: I2S prescaler register
	SPI_I2SPR_MCKOE_Pos  = 0x9   // Position of MCKOE field.
	SPI_I2SPR_MCKOE_Msk  = 0x200 // Bit mask of MCKOE field.
	SPI_I2SPR_MCKOE      = 0x200 // Bit MCKOE.
	SPI_I2SPR_ODD_Pos    = 0x8   // Position of ODD field.
	SPI_I2SPR_ODD_Msk    = 0x100 // Bit mask of ODD field.
	SPI_I2SPR_ODD        = 0x100 // Bit ODD.
	SPI_I2SPR_I2SDIV_Pos = 0x0   // Position of I2SDIV field.
	SPI_I2SPR_I2SDIV_Msk = 0xff  // Bit mask of I2SDIV field.
)

// Bitfields for ADC1: Analog-to-digital converter
const (
	// SR: status register
	ADC_SR_OVR_Pos   = 0x5  // Position of OVR field.
	ADC_SR_OVR_Msk   = 0x20 // Bit mask of OVR field.
	ADC_SR_OVR       = 0x20 // Bit OVR.
	ADC_SR_STRT_Pos  = 0x4  // Position of STRT field.
	ADC_SR_STRT_Msk  = 0x10 // Bit mask of STRT field.
	ADC_SR_STRT      = 0x10 // Bit STRT.
	ADC_SR_JSTRT_Pos = 0x3  // Position of JSTRT field.
	ADC_SR_JSTRT_Msk = 0x8  // Bit mask of JSTRT field.
	ADC_SR_JSTRT     = 0x8  // Bit JSTRT.
	ADC_SR_JEOC_Pos  = 0x2  // Position of JEOC field.
	ADC_SR_JEOC_Msk  = 0x4  // Bit mask of JEOC field.
	ADC_SR_JEOC      = 0x4  // Bit JEOC.
	ADC_SR_EOC_Pos   = 0x1  // Position of EOC field.
	ADC_SR_EOC_Msk   = 0x2  // Bit mask of EOC field.
	ADC_SR_EOC       = 0x2  // Bit EOC.
	ADC_SR_AWD_Pos   = 0x0  // Position of AWD field.
	ADC_SR_AWD_Msk   = 0x1  // Bit mask of AWD field.
	ADC_SR_AWD       = 0x1  // Bit AWD.

	// CR1: control register 1
	ADC_CR1_OVRIE_Pos   = 0x1a      // Position of OVRIE field.
	ADC_CR1_OVRIE_Msk   = 0x4000000 // Bit mask of OVRIE field.
	ADC_CR1_OVRIE       = 0x4000000 // Bit OVRIE.
	ADC_CR1_RES_Pos     = 0x18      // Position of RES field.
	ADC_CR1_RES_Msk     = 0x3000000 // Bit mask of RES field.
	ADC_CR1_AWDEN_Pos   = 0x17      // Position of AWDEN field.
	ADC_CR1_AWDEN_Msk   = 0x800000  // Bit mask of AWDEN field.
	ADC_CR1_AWDEN       = 0x800000  // Bit AWDEN.
	ADC_CR1_JAWDEN_Pos  = 0x16      // Position of JAWDEN field.
	ADC_CR1_JAWDEN_Msk  = 0x400000  // Bit mask of JAWDEN field.
	ADC_CR1_JAWDEN      = 0x400000  // Bit JAWDEN.
	ADC_CR1_DISCNUM_Pos = 0xd       // Position of DISCNUM field.
	ADC_CR1_DISCNUM_Msk = 0xe000    // Bit mask of DISCNUM field.
	ADC_CR1_JDISCEN_Pos = 0xc       // Position of JDISCEN field.
	ADC_CR1_JDISCEN_Msk = 0x1000    // Bit mask of JDISCEN field.
	ADC_CR1_JDISCEN     = 0x1000    // Bit JDISCEN.
	ADC_CR1_DISCEN_Pos  = 0xb       // Position of DISCEN field.
	ADC_CR1_DISCEN_Msk  = 0x800     // Bit mask of DISCEN field.
	ADC_CR1_DISCEN      = 0x800     // Bit DISCEN.
	ADC_CR1_JAUTO_Pos   = 0xa       // Position of JAUTO field.
	ADC_CR1_JAUTO_Msk   = 0x400     // Bit mask of JAUTO field.
	ADC_CR1_JAUTO       = 0x400     // Bit JAUTO.
	ADC_CR1_AWDSGL_Pos  = 0x9       // Position of AWDSGL field.
	ADC_CR1_AWDSGL_Msk  = 0x200     // Bit mask of AWDSGL field.
	ADC_CR1_AWDSGL      = 0x200     // Bit AWDSGL.
	ADC_CR1_SCAN_Pos    = 0x8       // Position of SCAN field.
	ADC_CR1_SCAN_Msk    = 0x100     // Bit mask of SCAN field.
	ADC_CR1_SCAN        = 0x100     // Bit SCAN.
	ADC_CR1_JEOCIE_Pos  = 0x7       // Position of JEOCIE field.
	ADC_CR1_JEOCIE_Msk  = 0x80      // Bit mask of JEOCIE field.
	ADC_CR1_JEOCIE      = 0x80      // Bit JEOCIE.
	ADC_CR1_AWDIE_Pos   = 0x6       // Position of AWDIE field.
	ADC_CR1_AWDIE_Msk   = 0x40      // Bit mask of AWDIE field.
	ADC_CR1_AWDIE       = 0x40      // Bit AWDIE.
	ADC_CR1_EOCIE_Pos   = 0x5       // Position of EOCIE field.
	ADC_CR1_EOCIE_Msk   = 0x20      // Bit mask of EOCIE field.
	ADC_CR1_EOCIE       = 0x20      // Bit EOCIE.
	ADC_CR1_AWDCH_Pos   = 0x0       // Position of AWDCH field.
	ADC_CR1_AWDCH_Msk   = 0x1f      // Bit mask of AWDCH field.

	// CR2: control register 2
	ADC_CR2_SWSTART_Pos  = 0x1e       // Position of SWSTART field.
	ADC_CR2_SWSTART_Msk  = 0x40000000 // Bit mask of SWSTART field.
	ADC_CR2_SWSTART      = 0x40000000 // Bit SWSTART.
	ADC_CR2_EXTEN_Pos    = 0x1c       // Position of EXTEN field.
	ADC_CR2_EXTEN_Msk    = 0x30000000 // Bit mask of EXTEN field.
	ADC_CR2_EXTSEL_Pos   = 0x18       // Position of EXTSEL field.
	ADC_CR2_EXTSEL_Msk   = 0xf000000  // Bit mask of EXTSEL field.
	ADC_CR2_JSWSTART_Pos = 0x16       // Position of JSWSTART field.
	ADC_CR2_JSWSTART_Msk = 0x400000   // Bit mask of JSWSTART field.
	ADC_CR2_JSWSTART     = 0x400000   // Bit JSWSTART.
	ADC_CR2_JEXTEN_Pos   = 0x14       // Position of JEXTEN field.
	ADC_CR2_JEXTEN_Msk   = 0x300000   // Bit mask of JEXTEN field.
	ADC_CR2_JEXTSEL_Pos  = 0x10       // Position of JEXTSEL field.
	ADC_CR2_JEXTSEL_Msk  = 0xf0000    // Bit mask of JEXTSEL field.
	ADC_CR2_ALIGN_Pos    = 0xb        // Position of ALIGN field.
	ADC_CR2_ALIGN_Msk    = 0x800      // Bit mask of ALIGN field.
	ADC_CR2_ALIGN        = 0x800      // Bit ALIGN.
	ADC_CR2_EOCS_Pos     = 0xa        // Position of EOCS field.
	ADC_CR2_EOCS_Msk     = 0x400      // Bit mask of EOCS field.
	ADC_CR2_EOCS         = 0x400      // Bit EOCS.
	ADC_CR2_DDS_Pos      = 0x9        // Position of DDS field.
	ADC_CR2_DDS_Msk      = 0x200      // Bit mask of DDS field.
	ADC_CR2_DDS          = 0x200      // Bit DDS.
	ADC_CR2_DMA_Pos      = 0x8        // Position of DMA field.
	ADC_CR2_DMA_Msk      = 0x100      // Bit mask of DMA field.
	ADC_CR2_DMA          = 0x100      // Bit DMA.
	ADC_CR2_CONT_Pos     = 0x1        // Position of CONT field.
	ADC_CR2_CONT_Msk     = 0x2        // Bit mask of CONT field.
	ADC_CR2_CONT         = 0x2        // Bit CONT.
	ADC_CR2_ADON_Pos     = 0x0        // Position of ADON field.
	ADC_CR2_ADON_Msk     = 0x1        // Bit mask of ADON field.
	ADC_CR2_ADON         = 0x1        // Bit ADON.

	// SMPR1: sample time register 1
	ADC_SMPR1_SMPx_x_Pos = 0x0        // Position of SMPx_x field.
	ADC_SMPR1_SMPx_x_Msk = 0xffffffff // Bit mask of SMPx_x field.

	// SMPR2: sample time register 2
	ADC_SMPR2_SMPx_x_Pos = 0x0        // Position of SMPx_x field.
	ADC_SMPR2_SMPx_x_Msk = 0xffffffff // Bit mask of SMPx_x field.

	// JOFR1: injected channel data offset register           x
	ADC_JOFR1_JOFFSET1_Pos = 0x0   // Position of JOFFSET1 field.
	ADC_JOFR1_JOFFSET1_Msk = 0xfff // Bit mask of JOFFSET1 field.

	// JOFR2: injected channel data offset register           x
	ADC_JOFR2_JOFFSET2_Pos = 0x0   // Position of JOFFSET2 field.
	ADC_JOFR2_JOFFSET2_Msk = 0xfff // Bit mask of JOFFSET2 field.

	// JOFR3: injected channel data offset register           x
	ADC_JOFR3_JOFFSET3_Pos = 0x0   // Position of JOFFSET3 field.
	ADC_JOFR3_JOFFSET3_Msk = 0xfff // Bit mask of JOFFSET3 field.

	// JOFR4: injected channel data offset register           x
	ADC_JOFR4_JOFFSET4_Pos = 0x0   // Position of JOFFSET4 field.
	ADC_JOFR4_JOFFSET4_Msk = 0xfff // Bit mask of JOFFSET4 field.

	// HTR: watchdog higher threshold           register
	ADC_HTR_HT_Pos = 0x0   // Position of HT field.
	ADC_HTR_HT_Msk = 0xfff // Bit mask of HT field.

	// LTR: watchdog lower threshold           register
	ADC_LTR_LT_Pos = 0x0   // Position of LT field.
	ADC_LTR_LT_Msk = 0xfff // Bit mask of LT field.

	// SQR1: regular sequence register 1
	ADC_SQR1_L_Pos    = 0x14     // Position of L field.
	ADC_SQR1_L_Msk    = 0xf00000 // Bit mask of L field.
	ADC_SQR1_SQ16_Pos = 0xf      // Position of SQ16 field.
	ADC_SQR1_SQ16_Msk = 0xf8000  // Bit mask of SQ16 field.
	ADC_SQR1_SQ15_Pos = 0xa      // Position of SQ15 field.
	ADC_SQR1_SQ15_Msk = 0x7c00   // Bit mask of SQ15 field.
	ADC_SQR1_SQ14_Pos = 0x5      // Position of SQ14 field.
	ADC_SQR1_SQ14_Msk = 0x3e0    // Bit mask of SQ14 field.
	ADC_SQR1_SQ13_Pos = 0x0      // Position of SQ13 field.
	ADC_SQR1_SQ13_Msk = 0x1f     // Bit mask of SQ13 field.

	// SQR2: regular sequence register 2
	ADC_SQR2_SQ12_Pos = 0x19       // Position of SQ12 field.
	ADC_SQR2_SQ12_Msk = 0x3e000000 // Bit mask of SQ12 field.
	ADC_SQR2_SQ11_Pos = 0x14       // Position of SQ11 field.
	ADC_SQR2_SQ11_Msk = 0x1f00000  // Bit mask of SQ11 field.
	ADC_SQR2_SQ10_Pos = 0xf        // Position of SQ10 field.
	ADC_SQR2_SQ10_Msk = 0xf8000    // Bit mask of SQ10 field.
	ADC_SQR2_SQ9_Pos  = 0xa        // Position of SQ9 field.
	ADC_SQR2_SQ9_Msk  = 0x7c00     // Bit mask of SQ9 field.
	ADC_SQR2_SQ8_Pos  = 0x5        // Position of SQ8 field.
	ADC_SQR2_SQ8_Msk  = 0x3e0      // Bit mask of SQ8 field.
	ADC_SQR2_SQ7_Pos  = 0x0        // Position of SQ7 field.
	ADC_SQR2_SQ7_Msk  = 0x1f       // Bit mask of SQ7 field.

	// SQR3: regular sequence register 3
	ADC_SQR3_SQ6_Pos = 0x19       // Position of SQ6 field.
	ADC_SQR3_SQ6_Msk = 0x3e000000 // Bit mask of SQ6 field.
	ADC_SQR3_SQ5_Pos = 0x14       // Position of SQ5 field.
	ADC_SQR3_SQ5_Msk = 0x1f00000  // Bit mask of SQ5 field.
	ADC_SQR3_SQ4_Pos = 0xf        // Position of SQ4 field.
	ADC_SQR3_SQ4_Msk = 0xf8000    // Bit mask of SQ4 field.
	ADC_SQR3_SQ3_Pos = 0xa        // Position of SQ3 field.
	ADC_SQR3_SQ3_Msk = 0x7c00     // Bit mask of SQ3 field.
	ADC_SQR3_SQ2_Pos = 0x5        // Position of SQ2 field.
	ADC_SQR3_SQ2_Msk = 0x3e0      // Bit mask of SQ2 field.
	ADC_SQR3_SQ1_Pos = 0x0        // Position of SQ1 field.
	ADC_SQR3_SQ1_Msk = 0x1f       // Bit mask of SQ1 field.

	// JSQR: injected sequence register
	ADC_JSQR_JL_Pos   = 0x14     // Position of JL field.
	ADC_JSQR_JL_Msk   = 0x300000 // Bit mask of JL field.
	ADC_JSQR_JSQ4_Pos = 0xf      // Position of JSQ4 field.
	ADC_JSQR_JSQ4_Msk = 0xf8000  // Bit mask of JSQ4 field.
	ADC_JSQR_JSQ3_Pos = 0xa      // Position of JSQ3 field.
	ADC_JSQR_JSQ3_Msk = 0x7c00   // Bit mask of JSQ3 field.
	ADC_JSQR_JSQ2_Pos = 0x5      // Position of JSQ2 field.
	ADC_JSQR_JSQ2_Msk = 0x3e0    // Bit mask of JSQ2 field.
	ADC_JSQR_JSQ1_Pos = 0x0      // Position of JSQ1 field.
	ADC_JSQR_JSQ1_Msk = 0x1f     // Bit mask of JSQ1 field.

	// JDR1: injected data register x
	ADC_JDR1_JDATA_Pos = 0x0    // Position of JDATA field.
	ADC_JDR1_JDATA_Msk = 0xffff // Bit mask of JDATA field.

	// JDR2: injected data register x
	ADC_JDR2_JDATA_Pos = 0x0    // Position of JDATA field.
	ADC_JDR2_JDATA_Msk = 0xffff // Bit mask of JDATA field.

	// JDR3: injected data register x
	ADC_JDR3_JDATA_Pos = 0x0    // Position of JDATA field.
	ADC_JDR3_JDATA_Msk = 0xffff // Bit mask of JDATA field.

	// JDR4: injected data register x
	ADC_JDR4_JDATA_Pos = 0x0    // Position of JDATA field.
	ADC_JDR4_JDATA_Msk = 0xffff // Bit mask of JDATA field.

	// DR: regular data register
	ADC_DR_DATA_Pos = 0x0    // Position of DATA field.
	ADC_DR_DATA_Msk = 0xffff // Bit mask of DATA field.
)

// Bitfields for DAC: Digital-to-analog converter
const (
	// CR: control register
	DAC_CR_DMAUDRIE2_Pos = 0x1d       // Position of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Msk = 0x20000000 // Bit mask of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2     = 0x20000000 // Bit DMAUDRIE2.
	DAC_CR_DMAEN2_Pos    = 0x1c       // Position of DMAEN2 field.
	DAC_CR_DMAEN2_Msk    = 0x10000000 // Bit mask of DMAEN2 field.
	DAC_CR_DMAEN2        = 0x10000000 // Bit DMAEN2.
	DAC_CR_MAMP2_Pos     = 0x18       // Position of MAMP2 field.
	DAC_CR_MAMP2_Msk     = 0xf000000  // Bit mask of MAMP2 field.
	DAC_CR_WAVE2_Pos     = 0x16       // Position of WAVE2 field.
	DAC_CR_WAVE2_Msk     = 0xc00000   // Bit mask of WAVE2 field.
	DAC_CR_TSEL2_Pos     = 0x13       // Position of TSEL2 field.
	DAC_CR_TSEL2_Msk     = 0x380000   // Bit mask of TSEL2 field.
	DAC_CR_TEN2_Pos      = 0x12       // Position of TEN2 field.
	DAC_CR_TEN2_Msk      = 0x40000    // Bit mask of TEN2 field.
	DAC_CR_TEN2          = 0x40000    // Bit TEN2.
	DAC_CR_BOFF2_Pos     = 0x11       // Position of BOFF2 field.
	DAC_CR_BOFF2_Msk     = 0x20000    // Bit mask of BOFF2 field.
	DAC_CR_BOFF2         = 0x20000    // Bit BOFF2.
	DAC_CR_EN2_Pos       = 0x10       // Position of EN2 field.
	DAC_CR_EN2_Msk       = 0x10000    // Bit mask of EN2 field.
	DAC_CR_EN2           = 0x10000    // Bit EN2.
	DAC_CR_DMAUDRIE1_Pos = 0xd        // Position of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Msk = 0x2000     // Bit mask of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1     = 0x2000     // Bit DMAUDRIE1.
	DAC_CR_DMAEN1_Pos    = 0xc        // Position of DMAEN1 field.
	DAC_CR_DMAEN1_Msk    = 0x1000     // Bit mask of DMAEN1 field.
	DAC_CR_DMAEN1        = 0x1000     // Bit DMAEN1.
	DAC_CR_MAMP1_Pos     = 0x8        // Position of MAMP1 field.
	DAC_CR_MAMP1_Msk     = 0xf00      // Bit mask of MAMP1 field.
	DAC_CR_WAVE1_Pos     = 0x6        // Position of WAVE1 field.
	DAC_CR_WAVE1_Msk     = 0xc0       // Bit mask of WAVE1 field.
	DAC_CR_TSEL1_Pos     = 0x3        // Position of TSEL1 field.
	DAC_CR_TSEL1_Msk     = 0x38       // Bit mask of TSEL1 field.
	DAC_CR_TEN1_Pos      = 0x2        // Position of TEN1 field.
	DAC_CR_TEN1_Msk      = 0x4        // Bit mask of TEN1 field.
	DAC_CR_TEN1          = 0x4        // Bit TEN1.
	DAC_CR_BOFF1_Pos     = 0x1        // Position of BOFF1 field.
	DAC_CR_BOFF1_Msk     = 0x2        // Bit mask of BOFF1 field.
	DAC_CR_BOFF1         = 0x2        // Bit BOFF1.
	DAC_CR_EN1_Pos       = 0x0        // Position of EN1 field.
	DAC_CR_EN1_Msk       = 0x1        // Bit mask of EN1 field.
	DAC_CR_EN1           = 0x1        // Bit EN1.

	// SWTRIGR: software trigger register
	DAC_SWTRIGR_SWTRIG2_Pos = 0x1 // Position of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Msk = 0x2 // Bit mask of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2     = 0x2 // Bit SWTRIG2.
	DAC_SWTRIGR_SWTRIG1_Pos = 0x0 // Position of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Msk = 0x1 // Bit mask of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1     = 0x1 // Bit SWTRIG1.

	// DHR12R1: channel1 12-bit right-aligned data holding           register
	DAC_DHR12R1_DACC1DHR_Pos = 0x0   // Position of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Msk = 0xfff // Bit mask of DACC1DHR field.

	// DHR12L1: channel1 12-bit left aligned data holding           register
	DAC_DHR12L1_DACC1DHR_Pos = 0x4    // Position of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Msk = 0xfff0 // Bit mask of DACC1DHR field.

	// DHR8R1: channel1 8-bit right aligned data holding           register
	DAC_DHR8R1_DACC1DHR_Pos = 0x0  // Position of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Msk = 0xff // Bit mask of DACC1DHR field.

	// DHR12R2: channel2 12-bit right aligned data holding           register
	DAC_DHR12R2_DACC2DHR_Pos = 0x0   // Position of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Msk = 0xfff // Bit mask of DACC2DHR field.

	// DHR12L2: channel2 12-bit left aligned data holding           register
	DAC_DHR12L2_DACC2DHR_Pos = 0x4    // Position of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Msk = 0xfff0 // Bit mask of DACC2DHR field.

	// DHR8R2: channel2 8-bit right-aligned data holding           register
	DAC_DHR8R2_DACC2DHR_Pos = 0x0  // Position of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Msk = 0xff // Bit mask of DACC2DHR field.

	// DHR12RD: Dual DAC 12-bit right-aligned data holding           register
	DAC_DHR12RD_DACC2DHR_Pos = 0x10      // Position of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Msk = 0xfff0000 // Bit mask of DACC2DHR field.
	DAC_DHR12RD_DACC1DHR_Pos = 0x0       // Position of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Msk = 0xfff     // Bit mask of DACC1DHR field.

	// DHR12LD: DUAL DAC 12-bit left aligned data holding           register
	DAC_DHR12LD_DACC2DHR_Pos = 0x14       // Position of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Msk = 0xfff00000 // Bit mask of DACC2DHR field.
	DAC_DHR12LD_DACC1DHR_Pos = 0x4        // Position of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Msk = 0xfff0     // Bit mask of DACC1DHR field.

	// DHR8RD: DUAL DAC 8-bit right aligned data holding           register
	DAC_DHR8RD_DACC2DHR_Pos = 0x8    // Position of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Msk = 0xff00 // Bit mask of DACC2DHR field.
	DAC_DHR8RD_DACC1DHR_Pos = 0x0    // Position of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Msk = 0xff   // Bit mask of DACC1DHR field.

	// DOR1: channel1 data output register
	DAC_DOR1_DACC1DOR_Pos = 0x0   // Position of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Msk = 0xfff // Bit mask of DACC1DOR field.

	// DOR2: channel2 data output register
	DAC_DOR2_DACC2DOR_Pos = 0x0   // Position of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Msk = 0xfff // Bit mask of DACC2DOR field.

	// SR: status register
	DAC_SR_DMAUDR2_Pos = 0x1d       // Position of DMAUDR2 field.
	DAC_SR_DMAUDR2_Msk = 0x20000000 // Bit mask of DMAUDR2 field.
	DAC_SR_DMAUDR2     = 0x20000000 // Bit DMAUDR2.
	DAC_SR_DMAUDR1_Pos = 0xd        // Position of DMAUDR1 field.
	DAC_SR_DMAUDR1_Msk = 0x2000     // Bit mask of DMAUDR1 field.
	DAC_SR_DMAUDR1     = 0x2000     // Bit DMAUDR1.
)

// Bitfields for PWR: Power control
const (
	// CR1: power control register
	PWR_CR1_LPDS_Pos   = 0x0     // Position of LPDS field.
	PWR_CR1_LPDS_Msk   = 0x1     // Bit mask of LPDS field.
	PWR_CR1_LPDS       = 0x1     // Bit LPDS.
	PWR_CR1_PDDS_Pos   = 0x1     // Position of PDDS field.
	PWR_CR1_PDDS_Msk   = 0x2     // Bit mask of PDDS field.
	PWR_CR1_PDDS       = 0x2     // Bit PDDS.
	PWR_CR1_CSBF_Pos   = 0x3     // Position of CSBF field.
	PWR_CR1_CSBF_Msk   = 0x8     // Bit mask of CSBF field.
	PWR_CR1_CSBF       = 0x8     // Bit CSBF.
	PWR_CR1_PVDE_Pos   = 0x4     // Position of PVDE field.
	PWR_CR1_PVDE_Msk   = 0x10    // Bit mask of PVDE field.
	PWR_CR1_PVDE       = 0x10    // Bit PVDE.
	PWR_CR1_PLS_Pos    = 0x5     // Position of PLS field.
	PWR_CR1_PLS_Msk    = 0xe0    // Bit mask of PLS field.
	PWR_CR1_DBP_Pos    = 0x8     // Position of DBP field.
	PWR_CR1_DBP_Msk    = 0x100   // Bit mask of DBP field.
	PWR_CR1_DBP        = 0x100   // Bit DBP.
	PWR_CR1_FPDS_Pos   = 0x9     // Position of FPDS field.
	PWR_CR1_FPDS_Msk   = 0x200   // Bit mask of FPDS field.
	PWR_CR1_FPDS       = 0x200   // Bit FPDS.
	PWR_CR1_LPUDS_Pos  = 0xa     // Position of LPUDS field.
	PWR_CR1_LPUDS_Msk  = 0x400   // Bit mask of LPUDS field.
	PWR_CR1_LPUDS      = 0x400   // Bit LPUDS.
	PWR_CR1_MRUDS_Pos  = 0xb     // Position of MRUDS field.
	PWR_CR1_MRUDS_Msk  = 0x800   // Bit mask of MRUDS field.
	PWR_CR1_MRUDS      = 0x800   // Bit MRUDS.
	PWR_CR1_ADCDC1_Pos = 0xd     // Position of ADCDC1 field.
	PWR_CR1_ADCDC1_Msk = 0x2000  // Bit mask of ADCDC1 field.
	PWR_CR1_ADCDC1     = 0x2000  // Bit ADCDC1.
	PWR_CR1_VOS_Pos    = 0xe     // Position of VOS field.
	PWR_CR1_VOS_Msk    = 0xc000  // Bit mask of VOS field.
	PWR_CR1_ODEN_Pos   = 0x10    // Position of ODEN field.
	PWR_CR1_ODEN_Msk   = 0x10000 // Bit mask of ODEN field.
	PWR_CR1_ODEN       = 0x10000 // Bit ODEN.
	PWR_CR1_ODSWEN_Pos = 0x11    // Position of ODSWEN field.
	PWR_CR1_ODSWEN_Msk = 0x20000 // Bit mask of ODSWEN field.
	PWR_CR1_ODSWEN     = 0x20000 // Bit ODSWEN.
	PWR_CR1_UDEN_Pos   = 0x12    // Position of UDEN field.
	PWR_CR1_UDEN_Msk   = 0xc0000 // Bit mask of UDEN field.

	// CSR1: power control/status register
	PWR_CSR1_WUIF_Pos    = 0x0     // Position of WUIF field.
	PWR_CSR1_WUIF_Msk    = 0x1     // Bit mask of WUIF field.
	PWR_CSR1_WUIF        = 0x1     // Bit WUIF.
	PWR_CSR1_SBF_Pos     = 0x1     // Position of SBF field.
	PWR_CSR1_SBF_Msk     = 0x2     // Bit mask of SBF field.
	PWR_CSR1_SBF         = 0x2     // Bit SBF.
	PWR_CSR1_PVDO_Pos    = 0x2     // Position of PVDO field.
	PWR_CSR1_PVDO_Msk    = 0x4     // Bit mask of PVDO field.
	PWR_CSR1_PVDO        = 0x4     // Bit PVDO.
	PWR_CSR1_BRR_Pos     = 0x3     // Position of BRR field.
	PWR_CSR1_BRR_Msk     = 0x8     // Bit mask of BRR field.
	PWR_CSR1_BRR         = 0x8     // Bit BRR.
	PWR_CSR1_BRE_Pos     = 0x9     // Position of BRE field.
	PWR_CSR1_BRE_Msk     = 0x200   // Bit mask of BRE field.
	PWR_CSR1_BRE         = 0x200   // Bit BRE.
	PWR_CSR1_VOSRDY_Pos  = 0xe     // Position of VOSRDY field.
	PWR_CSR1_VOSRDY_Msk  = 0x4000  // Bit mask of VOSRDY field.
	PWR_CSR1_VOSRDY      = 0x4000  // Bit VOSRDY.
	PWR_CSR1_ODRDY_Pos   = 0x10    // Position of ODRDY field.
	PWR_CSR1_ODRDY_Msk   = 0x10000 // Bit mask of ODRDY field.
	PWR_CSR1_ODRDY       = 0x10000 // Bit ODRDY.
	PWR_CSR1_ODSWRDY_Pos = 0x11    // Position of ODSWRDY field.
	PWR_CSR1_ODSWRDY_Msk = 0x20000 // Bit mask of ODSWRDY field.
	PWR_CSR1_ODSWRDY     = 0x20000 // Bit ODSWRDY.
	PWR_CSR1_UDRDY_Pos   = 0x12    // Position of UDRDY field.
	PWR_CSR1_UDRDY_Msk   = 0xc0000 // Bit mask of UDRDY field.

	// CR2: power control register
	PWR_CR2_CWUPF1_Pos = 0x0    // Position of CWUPF1 field.
	PWR_CR2_CWUPF1_Msk = 0x1    // Bit mask of CWUPF1 field.
	PWR_CR2_CWUPF1     = 0x1    // Bit CWUPF1.
	PWR_CR2_CWUPF2_Pos = 0x1    // Position of CWUPF2 field.
	PWR_CR2_CWUPF2_Msk = 0x2    // Bit mask of CWUPF2 field.
	PWR_CR2_CWUPF2     = 0x2    // Bit CWUPF2.
	PWR_CR2_CWUPF3_Pos = 0x2    // Position of CWUPF3 field.
	PWR_CR2_CWUPF3_Msk = 0x4    // Bit mask of CWUPF3 field.
	PWR_CR2_CWUPF3     = 0x4    // Bit CWUPF3.
	PWR_CR2_CWUPF4_Pos = 0x3    // Position of CWUPF4 field.
	PWR_CR2_CWUPF4_Msk = 0x8    // Bit mask of CWUPF4 field.
	PWR_CR2_CWUPF4     = 0x8    // Bit CWUPF4.
	PWR_CR2_CWUPF5_Pos = 0x4    // Position of CWUPF5 field.
	PWR_CR2_CWUPF5_Msk = 0x10   // Bit mask of CWUPF5 field.
	PWR_CR2_CWUPF5     = 0x10   // Bit CWUPF5.
	PWR_CR2_CWUPF6_Pos = 0x5    // Position of CWUPF6 field.
	PWR_CR2_CWUPF6_Msk = 0x20   // Bit mask of CWUPF6 field.
	PWR_CR2_CWUPF6     = 0x20   // Bit CWUPF6.
	PWR_CR2_WUPP1_Pos  = 0x8    // Position of WUPP1 field.
	PWR_CR2_WUPP1_Msk  = 0x100  // Bit mask of WUPP1 field.
	PWR_CR2_WUPP1      = 0x100  // Bit WUPP1.
	PWR_CR2_WUPP2_Pos  = 0x9    // Position of WUPP2 field.
	PWR_CR2_WUPP2_Msk  = 0x200  // Bit mask of WUPP2 field.
	PWR_CR2_WUPP2      = 0x200  // Bit WUPP2.
	PWR_CR2_WUPP3_Pos  = 0xa    // Position of WUPP3 field.
	PWR_CR2_WUPP3_Msk  = 0x400  // Bit mask of WUPP3 field.
	PWR_CR2_WUPP3      = 0x400  // Bit WUPP3.
	PWR_CR2_WUPP4_Pos  = 0xb    // Position of WUPP4 field.
	PWR_CR2_WUPP4_Msk  = 0x800  // Bit mask of WUPP4 field.
	PWR_CR2_WUPP4      = 0x800  // Bit WUPP4.
	PWR_CR2_WUPP5_Pos  = 0xc    // Position of WUPP5 field.
	PWR_CR2_WUPP5_Msk  = 0x1000 // Bit mask of WUPP5 field.
	PWR_CR2_WUPP5      = 0x1000 // Bit WUPP5.
	PWR_CR2_WUPP6_Pos  = 0xd    // Position of WUPP6 field.
	PWR_CR2_WUPP6_Msk  = 0x2000 // Bit mask of WUPP6 field.
	PWR_CR2_WUPP6      = 0x2000 // Bit WUPP6.

	// CSR2: power control/status register
	PWR_CSR2_WUPF1_Pos = 0x0    // Position of WUPF1 field.
	PWR_CSR2_WUPF1_Msk = 0x1    // Bit mask of WUPF1 field.
	PWR_CSR2_WUPF1     = 0x1    // Bit WUPF1.
	PWR_CSR2_WUPF2_Pos = 0x1    // Position of WUPF2 field.
	PWR_CSR2_WUPF2_Msk = 0x2    // Bit mask of WUPF2 field.
	PWR_CSR2_WUPF2     = 0x2    // Bit WUPF2.
	PWR_CSR2_WUPF3_Pos = 0x2    // Position of WUPF3 field.
	PWR_CSR2_WUPF3_Msk = 0x4    // Bit mask of WUPF3 field.
	PWR_CSR2_WUPF3     = 0x4    // Bit WUPF3.
	PWR_CSR2_WUPF4_Pos = 0x3    // Position of WUPF4 field.
	PWR_CSR2_WUPF4_Msk = 0x8    // Bit mask of WUPF4 field.
	PWR_CSR2_WUPF4     = 0x8    // Bit WUPF4.
	PWR_CSR2_WUPF5_Pos = 0x4    // Position of WUPF5 field.
	PWR_CSR2_WUPF5_Msk = 0x10   // Bit mask of WUPF5 field.
	PWR_CSR2_WUPF5     = 0x10   // Bit WUPF5.
	PWR_CSR2_WUPF6_Pos = 0x5    // Position of WUPF6 field.
	PWR_CSR2_WUPF6_Msk = 0x20   // Bit mask of WUPF6 field.
	PWR_CSR2_WUPF6     = 0x20   // Bit WUPF6.
	PWR_CSR2_EWUP1_Pos = 0x8    // Position of EWUP1 field.
	PWR_CSR2_EWUP1_Msk = 0x100  // Bit mask of EWUP1 field.
	PWR_CSR2_EWUP1     = 0x100  // Bit EWUP1.
	PWR_CSR2_EWUP2_Pos = 0x9    // Position of EWUP2 field.
	PWR_CSR2_EWUP2_Msk = 0x200  // Bit mask of EWUP2 field.
	PWR_CSR2_EWUP2     = 0x200  // Bit EWUP2.
	PWR_CSR2_EWUP3_Pos = 0xa    // Position of EWUP3 field.
	PWR_CSR2_EWUP3_Msk = 0x400  // Bit mask of EWUP3 field.
	PWR_CSR2_EWUP3     = 0x400  // Bit EWUP3.
	PWR_CSR2_EWUP4_Pos = 0xb    // Position of EWUP4 field.
	PWR_CSR2_EWUP4_Msk = 0x800  // Bit mask of EWUP4 field.
	PWR_CSR2_EWUP4     = 0x800  // Bit EWUP4.
	PWR_CSR2_EWUP5_Pos = 0xc    // Position of EWUP5 field.
	PWR_CSR2_EWUP5_Msk = 0x1000 // Bit mask of EWUP5 field.
	PWR_CSR2_EWUP5     = 0x1000 // Bit EWUP5.
	PWR_CSR2_EWUP6_Pos = 0xd    // Position of EWUP6 field.
	PWR_CSR2_EWUP6_Msk = 0x2000 // Bit mask of EWUP6 field.
	PWR_CSR2_EWUP6     = 0x2000 // Bit EWUP6.
)

// Bitfields for IWDG: Independent watchdog
const (
	// KR: Key register
	IWDG_KR_KEY_Pos = 0x0    // Position of KEY field.
	IWDG_KR_KEY_Msk = 0xffff // Bit mask of KEY field.

	// PR: Prescaler register
	IWDG_PR_PR_Pos = 0x0 // Position of PR field.
	IWDG_PR_PR_Msk = 0x7 // Bit mask of PR field.

	// RLR: Reload register
	IWDG_RLR_RL_Pos = 0x0   // Position of RL field.
	IWDG_RLR_RL_Msk = 0xfff // Bit mask of RL field.

	// SR: Status register
	IWDG_SR_RVU_Pos = 0x1 // Position of RVU field.
	IWDG_SR_RVU_Msk = 0x2 // Bit mask of RVU field.
	IWDG_SR_RVU     = 0x2 // Bit RVU.
	IWDG_SR_PVU_Pos = 0x0 // Position of PVU field.
	IWDG_SR_PVU_Msk = 0x1 // Bit mask of PVU field.
	IWDG_SR_PVU     = 0x1 // Bit PVU.

	// WINR: Window register
	IWDG_WINR_WIN_Pos = 0x0   // Position of WIN field.
	IWDG_WINR_WIN_Msk = 0xfff // Bit mask of WIN field.
)

// Bitfields for WWDG: Window watchdog
const (
	// CR: Control register
	WWDG_CR_WDGA_Pos = 0x7  // Position of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80 // Bit mask of WDGA field.
	WWDG_CR_WDGA     = 0x80 // Bit WDGA.
	WWDG_CR_T_Pos    = 0x0  // Position of T field.
	WWDG_CR_T_Msk    = 0x7f // Bit mask of T field.

	// CFR: Configuration register
	WWDG_CFR_EWI_Pos    = 0x9   // Position of EWI field.
	WWDG_CFR_EWI_Msk    = 0x200 // Bit mask of EWI field.
	WWDG_CFR_EWI        = 0x200 // Bit EWI.
	WWDG_CFR_WDGTB1_Pos = 0x8   // Position of WDGTB1 field.
	WWDG_CFR_WDGTB1_Msk = 0x100 // Bit mask of WDGTB1 field.
	WWDG_CFR_WDGTB1     = 0x100 // Bit WDGTB1.
	WWDG_CFR_WDGTB0_Pos = 0x7   // Position of WDGTB0 field.
	WWDG_CFR_WDGTB0_Msk = 0x80  // Bit mask of WDGTB0 field.
	WWDG_CFR_WDGTB0     = 0x80  // Bit WDGTB0.
	WWDG_CFR_W_Pos      = 0x0   // Position of W field.
	WWDG_CFR_W_Msk      = 0x7f  // Bit mask of W field.

	// SR: Status register
	WWDG_SR_EWIF_Pos = 0x0 // Position of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1 // Bit mask of EWIF field.
	WWDG_SR_EWIF     = 0x1 // Bit EWIF.
)

// Bitfields for TIM1: Advanced-timers
const (
	// CR1: control register 1
	TIM_CR1_CKD_Pos  = 0x8   // Position of CKD field.
	TIM_CR1_CKD_Msk  = 0x300 // Bit mask of CKD field.
	TIM_CR1_ARPE_Pos = 0x7   // Position of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80  // Bit mask of ARPE field.
	TIM_CR1_ARPE     = 0x80  // Bit ARPE.
	TIM_CR1_CMS_Pos  = 0x5   // Position of CMS field.
	TIM_CR1_CMS_Msk  = 0x60  // Bit mask of CMS field.
	TIM_CR1_DIR_Pos  = 0x4   // Position of DIR field.
	TIM_CR1_DIR_Msk  = 0x10  // Bit mask of DIR field.
	TIM_CR1_DIR      = 0x10  // Bit DIR.
	TIM_CR1_OPM_Pos  = 0x3   // Position of OPM field.
	TIM_CR1_OPM_Msk  = 0x8   // Bit mask of OPM field.
	TIM_CR1_OPM      = 0x8   // Bit OPM.
	TIM_CR1_URS_Pos  = 0x2   // Position of URS field.
	TIM_CR1_URS_Msk  = 0x4   // Bit mask of URS field.
	TIM_CR1_URS      = 0x4   // Bit URS.
	TIM_CR1_UDIS_Pos = 0x1   // Position of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2   // Bit mask of UDIS field.
	TIM_CR1_UDIS     = 0x2   // Bit UDIS.
	TIM_CR1_CEN_Pos  = 0x0   // Position of CEN field.
	TIM_CR1_CEN_Msk  = 0x1   // Bit mask of CEN field.
	TIM_CR1_CEN      = 0x1   // Bit CEN.

	// CR2: control register 2
	TIM_CR2_OIS4_Pos  = 0xe    // Position of OIS4 field.
	TIM_CR2_OIS4_Msk  = 0x4000 // Bit mask of OIS4 field.
	TIM_CR2_OIS4      = 0x4000 // Bit OIS4.
	TIM_CR2_OIS3N_Pos = 0xd    // Position of OIS3N field.
	TIM_CR2_OIS3N_Msk = 0x2000 // Bit mask of OIS3N field.
	TIM_CR2_OIS3N     = 0x2000 // Bit OIS3N.
	TIM_CR2_OIS3_Pos  = 0xc    // Position of OIS3 field.
	TIM_CR2_OIS3_Msk  = 0x1000 // Bit mask of OIS3 field.
	TIM_CR2_OIS3      = 0x1000 // Bit OIS3.
	TIM_CR2_OIS2N_Pos = 0xb    // Position of OIS2N field.
	TIM_CR2_OIS2N_Msk = 0x800  // Bit mask of OIS2N field.
	TIM_CR2_OIS2N     = 0x800  // Bit OIS2N.
	TIM_CR2_OIS2_Pos  = 0xa    // Position of OIS2 field.
	TIM_CR2_OIS2_Msk  = 0x400  // Bit mask of OIS2 field.
	TIM_CR2_OIS2      = 0x400  // Bit OIS2.
	TIM_CR2_OIS1N_Pos = 0x9    // Position of OIS1N field.
	TIM_CR2_OIS1N_Msk = 0x200  // Bit mask of OIS1N field.
	TIM_CR2_OIS1N     = 0x200  // Bit OIS1N.
	TIM_CR2_OIS1_Pos  = 0x8    // Position of OIS1 field.
	TIM_CR2_OIS1_Msk  = 0x100  // Bit mask of OIS1 field.
	TIM_CR2_OIS1      = 0x100  // Bit OIS1.
	TIM_CR2_TI1S_Pos  = 0x7    // Position of TI1S field.
	TIM_CR2_TI1S_Msk  = 0x80   // Bit mask of TI1S field.
	TIM_CR2_TI1S      = 0x80   // Bit TI1S.
	TIM_CR2_MMS_Pos   = 0x4    // Position of MMS field.
	TIM_CR2_MMS_Msk   = 0x70   // Bit mask of MMS field.
	TIM_CR2_CCDS_Pos  = 0x3    // Position of CCDS field.
	TIM_CR2_CCDS_Msk  = 0x8    // Bit mask of CCDS field.
	TIM_CR2_CCDS      = 0x8    // Bit CCDS.
	TIM_CR2_CCUS_Pos  = 0x2    // Position of CCUS field.
	TIM_CR2_CCUS_Msk  = 0x4    // Bit mask of CCUS field.
	TIM_CR2_CCUS      = 0x4    // Bit CCUS.
	TIM_CR2_CCPC_Pos  = 0x0    // Position of CCPC field.
	TIM_CR2_CCPC_Msk  = 0x1    // Bit mask of CCPC field.
	TIM_CR2_CCPC      = 0x1    // Bit CCPC.

	// SMCR: slave mode control register
	TIM_SMCR_ETP_Pos  = 0xf    // Position of ETP field.
	TIM_SMCR_ETP_Msk  = 0x8000 // Bit mask of ETP field.
	TIM_SMCR_ETP      = 0x8000 // Bit ETP.
	TIM_SMCR_ECE_Pos  = 0xe    // Position of ECE field.
	TIM_SMCR_ECE_Msk  = 0x4000 // Bit mask of ECE field.
	TIM_SMCR_ECE      = 0x4000 // Bit ECE.
	TIM_SMCR_ETPS_Pos = 0xc    // Position of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000 // Bit mask of ETPS field.
	TIM_SMCR_ETF_Pos  = 0x8    // Position of ETF field.
	TIM_SMCR_ETF_Msk  = 0xf00  // Bit mask of ETF field.
	TIM_SMCR_MSM_Pos  = 0x7    // Position of MSM field.
	TIM_SMCR_MSM_Msk  = 0x80   // Bit mask of MSM field.
	TIM_SMCR_MSM      = 0x80   // Bit MSM.
	TIM_SMCR_TS_Pos   = 0x4    // Position of TS field.
	TIM_SMCR_TS_Msk   = 0x70   // Bit mask of TS field.
	TIM_SMCR_SMS_Pos  = 0x0    // Position of SMS field.
	TIM_SMCR_SMS_Msk  = 0x7    // Bit mask of SMS field.

	// DIER: DMA/Interrupt enable register
	TIM_DIER_TDE_Pos   = 0xe    // Position of TDE field.
	TIM_DIER_TDE_Msk   = 0x4000 // Bit mask of TDE field.
	TIM_DIER_TDE       = 0x4000 // Bit TDE.
	TIM_DIER_COMDE_Pos = 0xd    // Position of COMDE field.
	TIM_DIER_COMDE_Msk = 0x2000 // Bit mask of COMDE field.
	TIM_DIER_COMDE     = 0x2000 // Bit COMDE.
	TIM_DIER_CC4DE_Pos = 0xc    // Position of CC4DE field.
	TIM_DIER_CC4DE_Msk = 0x1000 // Bit mask of CC4DE field.
	TIM_DIER_CC4DE     = 0x1000 // Bit CC4DE.
	TIM_DIER_CC3DE_Pos = 0xb    // Position of CC3DE field.
	TIM_DIER_CC3DE_Msk = 0x800  // Bit mask of CC3DE field.
	TIM_DIER_CC3DE     = 0x800  // Bit CC3DE.
	TIM_DIER_CC2DE_Pos = 0xa    // Position of CC2DE field.
	TIM_DIER_CC2DE_Msk = 0x400  // Bit mask of CC2DE field.
	TIM_DIER_CC2DE     = 0x400  // Bit CC2DE.
	TIM_DIER_CC1DE_Pos = 0x9    // Position of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200  // Bit mask of CC1DE field.
	TIM_DIER_CC1DE     = 0x200  // Bit CC1DE.
	TIM_DIER_UDE_Pos   = 0x8    // Position of UDE field.
	TIM_DIER_UDE_Msk   = 0x100  // Bit mask of UDE field.
	TIM_DIER_UDE       = 0x100  // Bit UDE.
	TIM_DIER_TIE_Pos   = 0x6    // Position of TIE field.
	TIM_DIER_TIE_Msk   = 0x40   // Bit mask of TIE field.
	TIM_DIER_TIE       = 0x40   // Bit TIE.
	TIM_DIER_CC4IE_Pos = 0x4    // Position of CC4IE field.
	TIM_DIER_CC4IE_Msk = 0x10   // Bit mask of CC4IE field.
	TIM_DIER_CC4IE     = 0x10   // Bit CC4IE.
	TIM_DIER_CC3IE_Pos = 0x3    // Position of CC3IE field.
	TIM_DIER_CC3IE_Msk = 0x8    // Bit mask of CC3IE field.
	TIM_DIER_CC3IE     = 0x8    // Bit CC3IE.
	TIM_DIER_CC2IE_Pos = 0x2    // Position of CC2IE field.
	TIM_DIER_CC2IE_Msk = 0x4    // Bit mask of CC2IE field.
	TIM_DIER_CC2IE     = 0x4    // Bit CC2IE.
	TIM_DIER_CC1IE_Pos = 0x1    // Position of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2    // Bit mask of CC1IE field.
	TIM_DIER_CC1IE     = 0x2    // Bit CC1IE.
	TIM_DIER_UIE_Pos   = 0x0    // Position of UIE field.
	TIM_DIER_UIE_Msk   = 0x1    // Bit mask of UIE field.
	TIM_DIER_UIE       = 0x1    // Bit UIE.
	TIM_DIER_BIE_Pos   = 0x7    // Position of BIE field.
	TIM_DIER_BIE_Msk   = 0x80   // Bit mask of BIE field.
	TIM_DIER_BIE       = 0x80   // Bit BIE.
	TIM_DIER_COMIE_Pos = 0x5    // Position of COMIE field.
	TIM_DIER_COMIE_Msk = 0x20   // Bit mask of COMIE field.
	TIM_DIER_COMIE     = 0x20   // Bit COMIE.

	// SR: status register
	TIM_SR_CC4OF_Pos = 0xc    // Position of CC4OF field.
	TIM_SR_CC4OF_Msk = 0x1000 // Bit mask of CC4OF field.
	TIM_SR_CC4OF     = 0x1000 // Bit CC4OF.
	TIM_SR_CC3OF_Pos = 0xb    // Position of CC3OF field.
	TIM_SR_CC3OF_Msk = 0x800  // Bit mask of CC3OF field.
	TIM_SR_CC3OF     = 0x800  // Bit CC3OF.
	TIM_SR_CC2OF_Pos = 0xa    // Position of CC2OF field.
	TIM_SR_CC2OF_Msk = 0x400  // Bit mask of CC2OF field.
	TIM_SR_CC2OF     = 0x400  // Bit CC2OF.
	TIM_SR_CC1OF_Pos = 0x9    // Position of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200  // Bit mask of CC1OF field.
	TIM_SR_CC1OF     = 0x200  // Bit CC1OF.
	TIM_SR_BIF_Pos   = 0x7    // Position of BIF field.
	TIM_SR_BIF_Msk   = 0x80   // Bit mask of BIF field.
	TIM_SR_BIF       = 0x80   // Bit BIF.
	TIM_SR_TIF_Pos   = 0x6    // Position of TIF field.
	TIM_SR_TIF_Msk   = 0x40   // Bit mask of TIF field.
	TIM_SR_TIF       = 0x40   // Bit TIF.
	TIM_SR_COMIF_Pos = 0x5    // Position of COMIF field.
	TIM_SR_COMIF_Msk = 0x20   // Bit mask of COMIF field.
	TIM_SR_COMIF     = 0x20   // Bit COMIF.
	TIM_SR_CC4IF_Pos = 0x4    // Position of CC4IF field.
	TIM_SR_CC4IF_Msk = 0x10   // Bit mask of CC4IF field.
	TIM_SR_CC4IF     = 0x10   // Bit CC4IF.
	TIM_SR_CC3IF_Pos = 0x3    // Position of CC3IF field.
	TIM_SR_CC3IF_Msk = 0x8    // Bit mask of CC3IF field.
	TIM_SR_CC3IF     = 0x8    // Bit CC3IF.
	TIM_SR_CC2IF_Pos = 0x2    // Position of CC2IF field.
	TIM_SR_CC2IF_Msk = 0x4    // Bit mask of CC2IF field.
	TIM_SR_CC2IF     = 0x4    // Bit CC2IF.
	TIM_SR_CC1IF_Pos = 0x1    // Position of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2    // Bit mask of CC1IF field.
	TIM_SR_CC1IF     = 0x2    // Bit CC1IF.
	TIM_SR_UIF_Pos   = 0x0    // Position of UIF field.
	TIM_SR_UIF_Msk   = 0x1    // Bit mask of UIF field.
	TIM_SR_UIF       = 0x1    // Bit UIF.

	// EGR: event generation register
	TIM_EGR_BG_Pos   = 0x7  // Position of BG field.
	TIM_EGR_BG_Msk   = 0x80 // Bit mask of BG field.
	TIM_EGR_BG       = 0x80 // Bit BG.
	TIM_EGR_TG_Pos   = 0x6  // Position of TG field.
	TIM_EGR_TG_Msk   = 0x40 // Bit mask of TG field.
	TIM_EGR_TG       = 0x40 // Bit TG.
	TIM_EGR_COMG_Pos = 0x5  // Position of COMG field.
	TIM_EGR_COMG_Msk = 0x20 // Bit mask of COMG field.
	TIM_EGR_COMG     = 0x20 // Bit COMG.
	TIM_EGR_CC4G_Pos = 0x4  // Position of CC4G field.
	TIM_EGR_CC4G_Msk = 0x10 // Bit mask of CC4G field.
	TIM_EGR_CC4G     = 0x10 // Bit CC4G.
	TIM_EGR_CC3G_Pos = 0x3  // Position of CC3G field.
	TIM_EGR_CC3G_Msk = 0x8  // Bit mask of CC3G field.
	TIM_EGR_CC3G     = 0x8  // Bit CC3G.
	TIM_EGR_CC2G_Pos = 0x2  // Position of CC2G field.
	TIM_EGR_CC2G_Msk = 0x4  // Bit mask of CC2G field.
	TIM_EGR_CC2G     = 0x4  // Bit CC2G.
	TIM_EGR_CC1G_Pos = 0x1  // Position of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2  // Bit mask of CC1G field.
	TIM_EGR_CC1G     = 0x2  // Bit CC1G.
	TIM_EGR_UG_Pos   = 0x0  // Position of UG field.
	TIM_EGR_UG_Msk   = 0x1  // Bit mask of UG field.
	TIM_EGR_UG       = 0x1  // Bit UG.

	// CCMR1_Output: capture/compare mode register 1 (output           mode)
	TIM_CCMR1_Output_OC2CE_Pos = 0xf    // Position of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Msk = 0x8000 // Bit mask of OC2CE field.
	TIM_CCMR1_Output_OC2CE     = 0x8000 // Bit OC2CE.
	TIM_CCMR1_Output_OC2M_Pos  = 0xc    // Position of OC2M field.
	TIM_CCMR1_Output_OC2M_Msk  = 0x7000 // Bit mask of OC2M field.
	TIM_CCMR1_Output_OC2PE_Pos = 0xb    // Position of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Msk = 0x800  // Bit mask of OC2PE field.
	TIM_CCMR1_Output_OC2PE     = 0x800  // Bit OC2PE.
	TIM_CCMR1_Output_OC2FE_Pos = 0xa    // Position of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Msk = 0x400  // Bit mask of OC2FE field.
	TIM_CCMR1_Output_OC2FE     = 0x400  // Bit OC2FE.
	TIM_CCMR1_Output_CC2S_Pos  = 0x8    // Position of CC2S field.
	TIM_CCMR1_Output_CC2S_Msk  = 0x300  // Bit mask of CC2S field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7    // Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80   // Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE     = 0x80   // Bit OC1CE.
	TIM_CCMR1_Output_OC1M_Pos  = 0x4    // Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk  = 0x70   // Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3    // Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8    // Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE     = 0x8    // Bit OC1PE.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2    // Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4    // Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE     = 0x4    // Bit OC1FE.
	TIM_CCMR1_Output_CC1S_Pos  = 0x0    // Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk  = 0x3    // Bit mask of CC1S field.

	// CCMR1_Input: capture/compare mode register 1 (input           mode)
	TIM_CCMR1_Input_IC2F_Pos   = 0xc    // Position of IC2F field.
	TIM_CCMR1_Input_IC2F_Msk   = 0xf000 // Bit mask of IC2F field.
	TIM_CCMR1_Input_IC2PCS_Pos = 0xa    // Position of IC2PCS field.
	TIM_CCMR1_Input_IC2PCS_Msk = 0xc00  // Bit mask of IC2PCS field.
	TIM_CCMR1_Input_CC2S_Pos   = 0x8    // Position of CC2S field.
	TIM_CCMR1_Input_CC2S_Msk   = 0x300  // Bit mask of CC2S field.
	TIM_CCMR1_Input_IC1F_Pos   = 0x4    // Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk   = 0xf0   // Bit mask of IC1F field.
	TIM_CCMR1_Input_ICPCS_Pos  = 0x2    // Position of ICPCS field.
	TIM_CCMR1_Input_ICPCS_Msk  = 0xc    // Bit mask of ICPCS field.
	TIM_CCMR1_Input_CC1S_Pos   = 0x0    // Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk   = 0x3    // Bit mask of CC1S field.

	// CCMR2_Output: capture/compare mode register 2 (output           mode)
	TIM_CCMR2_Output_OC4CE_Pos = 0xf    // Position of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Msk = 0x8000 // Bit mask of OC4CE field.
	TIM_CCMR2_Output_OC4CE     = 0x8000 // Bit OC4CE.
	TIM_CCMR2_Output_OC4M_Pos  = 0xc    // Position of OC4M field.
	TIM_CCMR2_Output_OC4M_Msk  = 0x7000 // Bit mask of OC4M field.
	TIM_CCMR2_Output_OC4PE_Pos = 0xb    // Position of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Msk = 0x800  // Bit mask of OC4PE field.
	TIM_CCMR2_Output_OC4PE     = 0x800  // Bit OC4PE.
	TIM_CCMR2_Output_OC4FE_Pos = 0xa    // Position of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Msk = 0x400  // Bit mask of OC4FE field.
	TIM_CCMR2_Output_OC4FE     = 0x400  // Bit OC4FE.
	TIM_CCMR2_Output_CC4S_Pos  = 0x8    // Position of CC4S field.
	TIM_CCMR2_Output_CC4S_Msk  = 0x300  // Bit mask of CC4S field.
	TIM_CCMR2_Output_OC3CE_Pos = 0x7    // Position of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Msk = 0x80   // Bit mask of OC3CE field.
	TIM_CCMR2_Output_OC3CE     = 0x80   // Bit OC3CE.
	TIM_CCMR2_Output_OC3M_Pos  = 0x4    // Position of OC3M field.
	TIM_CCMR2_Output_OC3M_Msk  = 0x70   // Bit mask of OC3M field.
	TIM_CCMR2_Output_OC3PE_Pos = 0x3    // Position of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Msk = 0x8    // Bit mask of OC3PE field.
	TIM_CCMR2_Output_OC3PE     = 0x8    // Bit OC3PE.
	TIM_CCMR2_Output_OC3FE_Pos = 0x2    // Position of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Msk = 0x4    // Bit mask of OC3FE field.
	TIM_CCMR2_Output_OC3FE     = 0x4    // Bit OC3FE.
	TIM_CCMR2_Output_CC3S_Pos  = 0x0    // Position of CC3S field.
	TIM_CCMR2_Output_CC3S_Msk  = 0x3    // Bit mask of CC3S field.

	// CCMR2_Input: capture/compare mode register 2 (input           mode)
	TIM_CCMR2_Input_IC4F_Pos   = 0xc    // Position of IC4F field.
	TIM_CCMR2_Input_IC4F_Msk   = 0xf000 // Bit mask of IC4F field.
	TIM_CCMR2_Input_IC4PSC_Pos = 0xa    // Position of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Msk = 0xc00  // Bit mask of IC4PSC field.
	TIM_CCMR2_Input_CC4S_Pos   = 0x8    // Position of CC4S field.
	TIM_CCMR2_Input_CC4S_Msk   = 0x300  // Bit mask of CC4S field.
	TIM_CCMR2_Input_IC3F_Pos   = 0x4    // Position of IC3F field.
	TIM_CCMR2_Input_IC3F_Msk   = 0xf0   // Bit mask of IC3F field.
	TIM_CCMR2_Input_IC3PSC_Pos = 0x2    // Position of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Msk = 0xc    // Bit mask of IC3PSC field.
	TIM_CCMR2_Input_CC3S_Pos   = 0x0    // Position of CC3S field.
	TIM_CCMR2_Input_CC3S_Msk   = 0x3    // Bit mask of CC3S field.

	// CCER: capture/compare enable           register
	TIM_CCER_CC4P_Pos  = 0xd    // Position of CC4P field.
	TIM_CCER_CC4P_Msk  = 0x2000 // Bit mask of CC4P field.
	TIM_CCER_CC4P      = 0x2000 // Bit CC4P.
	TIM_CCER_CC4E_Pos  = 0xc    // Position of CC4E field.
	TIM_CCER_CC4E_Msk  = 0x1000 // Bit mask of CC4E field.
	TIM_CCER_CC4E      = 0x1000 // Bit CC4E.
	TIM_CCER_CC3NP_Pos = 0xb    // Position of CC3NP field.
	TIM_CCER_CC3NP_Msk = 0x800  // Bit mask of CC3NP field.
	TIM_CCER_CC3NP     = 0x800  // Bit CC3NP.
	TIM_CCER_CC3NE_Pos = 0xa    // Position of CC3NE field.
	TIM_CCER_CC3NE_Msk = 0x400  // Bit mask of CC3NE field.
	TIM_CCER_CC3NE     = 0x400  // Bit CC3NE.
	TIM_CCER_CC3P_Pos  = 0x9    // Position of CC3P field.
	TIM_CCER_CC3P_Msk  = 0x200  // Bit mask of CC3P field.
	TIM_CCER_CC3P      = 0x200  // Bit CC3P.
	TIM_CCER_CC3E_Pos  = 0x8    // Position of CC3E field.
	TIM_CCER_CC3E_Msk  = 0x100  // Bit mask of CC3E field.
	TIM_CCER_CC3E      = 0x100  // Bit CC3E.
	TIM_CCER_CC2NP_Pos = 0x7    // Position of CC2NP field.
	TIM_CCER_CC2NP_Msk = 0x80   // Bit mask of CC2NP field.
	TIM_CCER_CC2NP     = 0x80   // Bit CC2NP.
	TIM_CCER_CC2NE_Pos = 0x6    // Position of CC2NE field.
	TIM_CCER_CC2NE_Msk = 0x40   // Bit mask of CC2NE field.
	TIM_CCER_CC2NE     = 0x40   // Bit CC2NE.
	TIM_CCER_CC2P_Pos  = 0x5    // Position of CC2P field.
	TIM_CCER_CC2P_Msk  = 0x20   // Bit mask of CC2P field.
	TIM_CCER_CC2P      = 0x20   // Bit CC2P.
	TIM_CCER_CC2E_Pos  = 0x4    // Position of CC2E field.
	TIM_CCER_CC2E_Msk  = 0x10   // Bit mask of CC2E field.
	TIM_CCER_CC2E      = 0x10   // Bit CC2E.
	TIM_CCER_CC1NP_Pos = 0x3    // Position of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8    // Bit mask of CC1NP field.
	TIM_CCER_CC1NP     = 0x8    // Bit CC1NP.
	TIM_CCER_CC1NE_Pos = 0x2    // Position of CC1NE field.
	TIM_CCER_CC1NE_Msk = 0x4    // Bit mask of CC1NE field.
	TIM_CCER_CC1NE     = 0x4    // Bit CC1NE.
	TIM_CCER_CC1P_Pos  = 0x1    // Position of CC1P field.
	TIM_CCER_CC1P_Msk  = 0x2    // Bit mask of CC1P field.
	TIM_CCER_CC1P      = 0x2    // Bit CC1P.
	TIM_CCER_CC1E_Pos  = 0x0    // Position of CC1E field.
	TIM_CCER_CC1E_Msk  = 0x1    // Bit mask of CC1E field.
	TIM_CCER_CC1E      = 0x1    // Bit CC1E.

	// CNT: counter
	TIM_CNT_CNT_Pos = 0x0    // Position of CNT field.
	TIM_CNT_CNT_Msk = 0xffff // Bit mask of CNT field.

	// PSC: prescaler
	TIM_PSC_PSC_Pos = 0x0    // Position of PSC field.
	TIM_PSC_PSC_Msk = 0xffff // Bit mask of PSC field.

	// ARR: auto-reload register
	TIM_ARR_ARR_Pos = 0x0    // Position of ARR field.
	TIM_ARR_ARR_Msk = 0xffff // Bit mask of ARR field.

	// RCR: repetition counter register
	TIM_RCR_REP_Pos = 0x0  // Position of REP field.
	TIM_RCR_REP_Msk = 0xff // Bit mask of REP field.

	// CCR1: capture/compare register 1
	TIM_CCR1_CCR1_Pos = 0x0    // Position of CCR1 field.
	TIM_CCR1_CCR1_Msk = 0xffff // Bit mask of CCR1 field.

	// CCR2: capture/compare register 2
	TIM_CCR2_CCR2_Pos = 0x0    // Position of CCR2 field.
	TIM_CCR2_CCR2_Msk = 0xffff // Bit mask of CCR2 field.

	// CCR3: capture/compare register 3
	TIM_CCR3_CCR3_Pos = 0x0    // Position of CCR3 field.
	TIM_CCR3_CCR3_Msk = 0xffff // Bit mask of CCR3 field.

	// CCR4: capture/compare register 4
	TIM_CCR4_CCR4_Pos = 0x0    // Position of CCR4 field.
	TIM_CCR4_CCR4_Msk = 0xffff // Bit mask of CCR4 field.

	// BDTR: break and dead-time register
	TIM_BDTR_DTG_Pos  = 0x0       // Position of DTG field.
	TIM_BDTR_DTG_Msk  = 0xff      // Bit mask of DTG field.
	TIM_BDTR_LOCK_Pos = 0x8       // Position of LOCK field.
	TIM_BDTR_LOCK_Msk = 0x300     // Bit mask of LOCK field.
	TIM_BDTR_OSSI_Pos = 0xa       // Position of OSSI field.
	TIM_BDTR_OSSI_Msk = 0x400     // Bit mask of OSSI field.
	TIM_BDTR_OSSI     = 0x400     // Bit OSSI.
	TIM_BDTR_OSSR_Pos = 0xb       // Position of OSSR field.
	TIM_BDTR_OSSR_Msk = 0x800     // Bit mask of OSSR field.
	TIM_BDTR_OSSR     = 0x800     // Bit OSSR.
	TIM_BDTR_BKE_Pos  = 0xc       // Position of BKE field.
	TIM_BDTR_BKE_Msk  = 0x1000    // Bit mask of BKE field.
	TIM_BDTR_BKE      = 0x1000    // Bit BKE.
	TIM_BDTR_BKP_Pos  = 0xd       // Position of BKP field.
	TIM_BDTR_BKP_Msk  = 0x2000    // Bit mask of BKP field.
	TIM_BDTR_BKP      = 0x2000    // Bit BKP.
	TIM_BDTR_AOE_Pos  = 0xe       // Position of AOE field.
	TIM_BDTR_AOE_Msk  = 0x4000    // Bit mask of AOE field.
	TIM_BDTR_AOE      = 0x4000    // Bit AOE.
	TIM_BDTR_MOE_Pos  = 0xf       // Position of MOE field.
	TIM_BDTR_MOE_Msk  = 0x8000    // Bit mask of MOE field.
	TIM_BDTR_MOE      = 0x8000    // Bit MOE.
	TIM_BDTR_BKF_Pos  = 0x10      // Position of BKF field.
	TIM_BDTR_BKF_Msk  = 0xf0000   // Bit mask of BKF field.
	TIM_BDTR_BK2F_Pos = 0x14      // Position of BK2F field.
	TIM_BDTR_BK2F_Msk = 0xf00000  // Bit mask of BK2F field.
	TIM_BDTR_BK2E_Pos = 0x18      // Position of BK2E field.
	TIM_BDTR_BK2E_Msk = 0x1000000 // Bit mask of BK2E field.
	TIM_BDTR_BK2E     = 0x1000000 // Bit BK2E.
	TIM_BDTR_BK2P_Pos = 0x19      // Position of BK2P field.
	TIM_BDTR_BK2P_Msk = 0x2000000 // Bit mask of BK2P field.
	TIM_BDTR_BK2P     = 0x2000000 // Bit BK2P.

	// DCR: DMA control register
	TIM_DCR_DBL_Pos = 0x8    // Position of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00 // Bit mask of DBL field.
	TIM_DCR_DBA_Pos = 0x0    // Position of DBA field.
	TIM_DCR_DBA_Msk = 0x1f   // Bit mask of DBA field.

	// DMAR: DMA address for full transfer
	TIM_DMAR_DMAB_Pos = 0x0    // Position of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffff // Bit mask of DMAB field.

	// CCMR3_Output: capture/compare mode register 3 (output           mode)
	TIM_CCMR3_Output_OC5FE_Pos = 0x2       // Position of OC5FE field.
	TIM_CCMR3_Output_OC5FE_Msk = 0x4       // Bit mask of OC5FE field.
	TIM_CCMR3_Output_OC5FE     = 0x4       // Bit OC5FE.
	TIM_CCMR3_Output_OC5PE_Pos = 0x3       // Position of OC5PE field.
	TIM_CCMR3_Output_OC5PE_Msk = 0x8       // Bit mask of OC5PE field.
	TIM_CCMR3_Output_OC5PE     = 0x8       // Bit OC5PE.
	TIM_CCMR3_Output_OC5M_Pos  = 0x4       // Position of OC5M field.
	TIM_CCMR3_Output_OC5M_Msk  = 0x70      // Bit mask of OC5M field.
	TIM_CCMR3_Output_OC5CE_Pos = 0x7       // Position of OC5CE field.
	TIM_CCMR3_Output_OC5CE_Msk = 0x80      // Bit mask of OC5CE field.
	TIM_CCMR3_Output_OC5CE     = 0x80      // Bit OC5CE.
	TIM_CCMR3_Output_OC6FE_Pos = 0xa       // Position of OC6FE field.
	TIM_CCMR3_Output_OC6FE_Msk = 0x400     // Bit mask of OC6FE field.
	TIM_CCMR3_Output_OC6FE     = 0x400     // Bit OC6FE.
	TIM_CCMR3_Output_OC6PE_Pos = 0xb       // Position of OC6PE field.
	TIM_CCMR3_Output_OC6PE_Msk = 0x800     // Bit mask of OC6PE field.
	TIM_CCMR3_Output_OC6PE     = 0x800     // Bit OC6PE.
	TIM_CCMR3_Output_OC6M_Pos  = 0xc       // Position of OC6M field.
	TIM_CCMR3_Output_OC6M_Msk  = 0x7000    // Bit mask of OC6M field.
	TIM_CCMR3_Output_OC6CE_Pos = 0xf       // Position of OC6CE field.
	TIM_CCMR3_Output_OC6CE_Msk = 0x8000    // Bit mask of OC6CE field.
	TIM_CCMR3_Output_OC6CE     = 0x8000    // Bit OC6CE.
	TIM_CCMR3_Output_OC5M3_Pos = 0x10      // Position of OC5M3 field.
	TIM_CCMR3_Output_OC5M3_Msk = 0x10000   // Bit mask of OC5M3 field.
	TIM_CCMR3_Output_OC5M3     = 0x10000   // Bit OC5M3.
	TIM_CCMR3_Output_OC6M3_Pos = 0x18      // Position of OC6M3 field.
	TIM_CCMR3_Output_OC6M3_Msk = 0x1000000 // Bit mask of OC6M3 field.
	TIM_CCMR3_Output_OC6M3     = 0x1000000 // Bit OC6M3.

	// CCR5: capture/compare register 5
	TIM_CCR5_CCR5_Pos  = 0x0        // Position of CCR5 field.
	TIM_CCR5_CCR5_Msk  = 0xffff     // Bit mask of CCR5 field.
	TIM_CCR5_GC5C1_Pos = 0x1d       // Position of GC5C1 field.
	TIM_CCR5_GC5C1_Msk = 0x20000000 // Bit mask of GC5C1 field.
	TIM_CCR5_GC5C1     = 0x20000000 // Bit GC5C1.
	TIM_CCR5_GC5C2_Pos = 0x1e       // Position of GC5C2 field.
	TIM_CCR5_GC5C2_Msk = 0x40000000 // Bit mask of GC5C2 field.
	TIM_CCR5_GC5C2     = 0x40000000 // Bit GC5C2.
	TIM_CCR5_GC5C3_Pos = 0x1f       // Position of GC5C3 field.
	TIM_CCR5_GC5C3_Msk = 0x80000000 // Bit mask of GC5C3 field.
	TIM_CCR5_GC5C3     = 0x80000000 // Bit GC5C3.

	// CRR6: capture/compare register 6
	TIM_CRR6_CCR6_Pos = 0x0    // Position of CCR6 field.
	TIM_CRR6_CCR6_Msk = 0xffff // Bit mask of CCR6 field.

	// AF1: alternate function option register           1
	TIM_AF1_BKINE_Pos   = 0x0   // Position of BKINE field.
	TIM_AF1_BKINE_Msk   = 0x1   // Bit mask of BKINE field.
	TIM_AF1_BKINE       = 0x1   // Bit BKINE.
	TIM_AF1_BKDFBKE_Pos = 0x8   // Position of BKDFBKE field.
	TIM_AF1_BKDFBKE_Msk = 0x100 // Bit mask of BKDFBKE field.
	TIM_AF1_BKDFBKE     = 0x100 // Bit BKDFBKE.
	TIM_AF1_BKINP_Pos   = 0x9   // Position of BKINP field.
	TIM_AF1_BKINP_Msk   = 0x200 // Bit mask of BKINP field.
	TIM_AF1_BKINP       = 0x200 // Bit BKINP.

	// AF2: alternate function option register           2
	TIM_AF2_BK2INE_Pos   = 0x0   // Position of BK2INE field.
	TIM_AF2_BK2INE_Msk   = 0x1   // Bit mask of BK2INE field.
	TIM_AF2_BK2INE       = 0x1   // Bit BK2INE.
	TIM_AF2_BK2DFBKE_Pos = 0x8   // Position of BK2DFBKE field.
	TIM_AF2_BK2DFBKE_Msk = 0x100 // Bit mask of BK2DFBKE field.
	TIM_AF2_BK2DFBKE     = 0x100 // Bit BK2DFBKE.
	TIM_AF2_BK2INP_Pos   = 0x9   // Position of BK2INP field.
	TIM_AF2_BK2INP_Msk   = 0x200 // Bit mask of BK2INP field.
	TIM_AF2_BK2INP       = 0x200 // Bit BK2INP.
)

// Bitfields for Ethernet_MAC: Ethernet: media access control (MAC)
const (
	// MACCR: Ethernet MAC configuration           register
	Ethernet_MACCR_RE_Pos   = 0x2       // Position of RE field.
	Ethernet_MACCR_RE_Msk   = 0x4       // Bit mask of RE field.
	Ethernet_MACCR_RE       = 0x4       // Bit RE.
	Ethernet_MACCR_TE_Pos   = 0x3       // Position of TE field.
	Ethernet_MACCR_TE_Msk   = 0x8       // Bit mask of TE field.
	Ethernet_MACCR_TE       = 0x8       // Bit TE.
	Ethernet_MACCR_DC_Pos   = 0x4       // Position of DC field.
	Ethernet_MACCR_DC_Msk   = 0x10      // Bit mask of DC field.
	Ethernet_MACCR_DC       = 0x10      // Bit DC.
	Ethernet_MACCR_BL_Pos   = 0x5       // Position of BL field.
	Ethernet_MACCR_BL_Msk   = 0x60      // Bit mask of BL field.
	Ethernet_MACCR_APCS_Pos = 0x7       // Position of APCS field.
	Ethernet_MACCR_APCS_Msk = 0x80      // Bit mask of APCS field.
	Ethernet_MACCR_APCS     = 0x80      // Bit APCS.
	Ethernet_MACCR_RD_Pos   = 0x9       // Position of RD field.
	Ethernet_MACCR_RD_Msk   = 0x200     // Bit mask of RD field.
	Ethernet_MACCR_RD       = 0x200     // Bit RD.
	Ethernet_MACCR_IPCO_Pos = 0xa       // Position of IPCO field.
	Ethernet_MACCR_IPCO_Msk = 0x400     // Bit mask of IPCO field.
	Ethernet_MACCR_IPCO     = 0x400     // Bit IPCO.
	Ethernet_MACCR_DM_Pos   = 0xb       // Position of DM field.
	Ethernet_MACCR_DM_Msk   = 0x800     // Bit mask of DM field.
	Ethernet_MACCR_DM       = 0x800     // Bit DM.
	Ethernet_MACCR_LM_Pos   = 0xc       // Position of LM field.
	Ethernet_MACCR_LM_Msk   = 0x1000    // Bit mask of LM field.
	Ethernet_MACCR_LM       = 0x1000    // Bit LM.
	Ethernet_MACCR_ROD_Pos  = 0xd       // Position of ROD field.
	Ethernet_MACCR_ROD_Msk  = 0x2000    // Bit mask of ROD field.
	Ethernet_MACCR_ROD      = 0x2000    // Bit ROD.
	Ethernet_MACCR_FES_Pos  = 0xe       // Position of FES field.
	Ethernet_MACCR_FES_Msk  = 0x4000    // Bit mask of FES field.
	Ethernet_MACCR_FES      = 0x4000    // Bit FES.
	Ethernet_MACCR_CSD_Pos  = 0x10      // Position of CSD field.
	Ethernet_MACCR_CSD_Msk  = 0x10000   // Bit mask of CSD field.
	Ethernet_MACCR_CSD      = 0x10000   // Bit CSD.
	Ethernet_MACCR_IFG_Pos  = 0x11      // Position of IFG field.
	Ethernet_MACCR_IFG_Msk  = 0xe0000   // Bit mask of IFG field.
	Ethernet_MACCR_JD_Pos   = 0x16      // Position of JD field.
	Ethernet_MACCR_JD_Msk   = 0x400000  // Bit mask of JD field.
	Ethernet_MACCR_JD       = 0x400000  // Bit JD.
	Ethernet_MACCR_WD_Pos   = 0x17      // Position of WD field.
	Ethernet_MACCR_WD_Msk   = 0x800000  // Bit mask of WD field.
	Ethernet_MACCR_WD       = 0x800000  // Bit WD.
	Ethernet_MACCR_CSTF_Pos = 0x19      // Position of CSTF field.
	Ethernet_MACCR_CSTF_Msk = 0x2000000 // Bit mask of CSTF field.
	Ethernet_MACCR_CSTF     = 0x2000000 // Bit CSTF.

	// MACFFR: Ethernet MAC frame filter           register
	Ethernet_MACFFR_PM_Pos   = 0x0        // Position of PM field.
	Ethernet_MACFFR_PM_Msk   = 0x1        // Bit mask of PM field.
	Ethernet_MACFFR_PM       = 0x1        // Bit PM.
	Ethernet_MACFFR_HU_Pos   = 0x1        // Position of HU field.
	Ethernet_MACFFR_HU_Msk   = 0x2        // Bit mask of HU field.
	Ethernet_MACFFR_HU       = 0x2        // Bit HU.
	Ethernet_MACFFR_HM_Pos   = 0x2        // Position of HM field.
	Ethernet_MACFFR_HM_Msk   = 0x4        // Bit mask of HM field.
	Ethernet_MACFFR_HM       = 0x4        // Bit HM.
	Ethernet_MACFFR_DAIF_Pos = 0x3        // Position of DAIF field.
	Ethernet_MACFFR_DAIF_Msk = 0x8        // Bit mask of DAIF field.
	Ethernet_MACFFR_DAIF     = 0x8        // Bit DAIF.
	Ethernet_MACFFR_RAM_Pos  = 0x4        // Position of RAM field.
	Ethernet_MACFFR_RAM_Msk  = 0x10       // Bit mask of RAM field.
	Ethernet_MACFFR_RAM      = 0x10       // Bit RAM.
	Ethernet_MACFFR_BFD_Pos  = 0x5        // Position of BFD field.
	Ethernet_MACFFR_BFD_Msk  = 0x20       // Bit mask of BFD field.
	Ethernet_MACFFR_BFD      = 0x20       // Bit BFD.
	Ethernet_MACFFR_PCF_Pos  = 0x6        // Position of PCF field.
	Ethernet_MACFFR_PCF_Msk  = 0x40       // Bit mask of PCF field.
	Ethernet_MACFFR_PCF      = 0x40       // Bit PCF.
	Ethernet_MACFFR_SAIF_Pos = 0x7        // Position of SAIF field.
	Ethernet_MACFFR_SAIF_Msk = 0x80       // Bit mask of SAIF field.
	Ethernet_MACFFR_SAIF     = 0x80       // Bit SAIF.
	Ethernet_MACFFR_SAF_Pos  = 0x8        // Position of SAF field.
	Ethernet_MACFFR_SAF_Msk  = 0x100      // Bit mask of SAF field.
	Ethernet_MACFFR_SAF      = 0x100      // Bit SAF.
	Ethernet_MACFFR_HPF_Pos  = 0x9        // Position of HPF field.
	Ethernet_MACFFR_HPF_Msk  = 0x200      // Bit mask of HPF field.
	Ethernet_MACFFR_HPF      = 0x200      // Bit HPF.
	Ethernet_MACFFR_RA_Pos   = 0x1f       // Position of RA field.
	Ethernet_MACFFR_RA_Msk   = 0x80000000 // Bit mask of RA field.
	Ethernet_MACFFR_RA       = 0x80000000 // Bit RA.

	// MACHTHR: Ethernet MAC hash table high           register
	Ethernet_MACHTHR_HTH_Pos = 0x0        // Position of HTH field.
	Ethernet_MACHTHR_HTH_Msk = 0xffffffff // Bit mask of HTH field.

	// MACHTLR: Ethernet MAC hash table low           register
	Ethernet_MACHTLR_HTL_Pos = 0x0        // Position of HTL field.
	Ethernet_MACHTLR_HTL_Msk = 0xffffffff // Bit mask of HTL field.

	// MACMIIAR: Ethernet MAC MII address           register
	Ethernet_MACMIIAR_MB_Pos = 0x0    // Position of MB field.
	Ethernet_MACMIIAR_MB_Msk = 0x1    // Bit mask of MB field.
	Ethernet_MACMIIAR_MB     = 0x1    // Bit MB.
	Ethernet_MACMIIAR_MW_Pos = 0x1    // Position of MW field.
	Ethernet_MACMIIAR_MW_Msk = 0x2    // Bit mask of MW field.
	Ethernet_MACMIIAR_MW     = 0x2    // Bit MW.
	Ethernet_MACMIIAR_CR_Pos = 0x2    // Position of CR field.
	Ethernet_MACMIIAR_CR_Msk = 0x1c   // Bit mask of CR field.
	Ethernet_MACMIIAR_MR_Pos = 0x6    // Position of MR field.
	Ethernet_MACMIIAR_MR_Msk = 0x7c0  // Bit mask of MR field.
	Ethernet_MACMIIAR_PA_Pos = 0xb    // Position of PA field.
	Ethernet_MACMIIAR_PA_Msk = 0xf800 // Bit mask of PA field.

	// MACMIIDR: Ethernet MAC MII data register
	Ethernet_MACMIIDR_TD_Pos = 0x0    // Position of TD field.
	Ethernet_MACMIIDR_TD_Msk = 0xffff // Bit mask of TD field.

	// MACFCR: Ethernet MAC flow control           register
	Ethernet_MACFCR_FCB_Pos  = 0x0        // Position of FCB field.
	Ethernet_MACFCR_FCB_Msk  = 0x1        // Bit mask of FCB field.
	Ethernet_MACFCR_FCB      = 0x1        // Bit FCB.
	Ethernet_MACFCR_TFCE_Pos = 0x1        // Position of TFCE field.
	Ethernet_MACFCR_TFCE_Msk = 0x2        // Bit mask of TFCE field.
	Ethernet_MACFCR_TFCE     = 0x2        // Bit TFCE.
	Ethernet_MACFCR_RFCE_Pos = 0x2        // Position of RFCE field.
	Ethernet_MACFCR_RFCE_Msk = 0x4        // Bit mask of RFCE field.
	Ethernet_MACFCR_RFCE     = 0x4        // Bit RFCE.
	Ethernet_MACFCR_UPFD_Pos = 0x3        // Position of UPFD field.
	Ethernet_MACFCR_UPFD_Msk = 0x8        // Bit mask of UPFD field.
	Ethernet_MACFCR_UPFD     = 0x8        // Bit UPFD.
	Ethernet_MACFCR_PLT_Pos  = 0x4        // Position of PLT field.
	Ethernet_MACFCR_PLT_Msk  = 0x30       // Bit mask of PLT field.
	Ethernet_MACFCR_ZQPD_Pos = 0x7        // Position of ZQPD field.
	Ethernet_MACFCR_ZQPD_Msk = 0x80       // Bit mask of ZQPD field.
	Ethernet_MACFCR_ZQPD     = 0x80       // Bit ZQPD.
	Ethernet_MACFCR_PT_Pos   = 0x10       // Position of PT field.
	Ethernet_MACFCR_PT_Msk   = 0xffff0000 // Bit mask of PT field.

	// MACVLANTR: Ethernet MAC VLAN tag register
	Ethernet_MACVLANTR_VLANTI_Pos = 0x0     // Position of VLANTI field.
	Ethernet_MACVLANTR_VLANTI_Msk = 0xffff  // Bit mask of VLANTI field.
	Ethernet_MACVLANTR_VLANTC_Pos = 0x10    // Position of VLANTC field.
	Ethernet_MACVLANTR_VLANTC_Msk = 0x10000 // Bit mask of VLANTC field.
	Ethernet_MACVLANTR_VLANTC     = 0x10000 // Bit VLANTC.

	// MACPMTCSR: Ethernet MAC PMT control and status           register
	Ethernet_MACPMTCSR_PD_Pos     = 0x0        // Position of PD field.
	Ethernet_MACPMTCSR_PD_Msk     = 0x1        // Bit mask of PD field.
	Ethernet_MACPMTCSR_PD         = 0x1        // Bit PD.
	Ethernet_MACPMTCSR_MPE_Pos    = 0x1        // Position of MPE field.
	Ethernet_MACPMTCSR_MPE_Msk    = 0x2        // Bit mask of MPE field.
	Ethernet_MACPMTCSR_MPE        = 0x2        // Bit MPE.
	Ethernet_MACPMTCSR_WFE_Pos    = 0x2        // Position of WFE field.
	Ethernet_MACPMTCSR_WFE_Msk    = 0x4        // Bit mask of WFE field.
	Ethernet_MACPMTCSR_WFE        = 0x4        // Bit WFE.
	Ethernet_MACPMTCSR_MPR_Pos    = 0x5        // Position of MPR field.
	Ethernet_MACPMTCSR_MPR_Msk    = 0x20       // Bit mask of MPR field.
	Ethernet_MACPMTCSR_MPR        = 0x20       // Bit MPR.
	Ethernet_MACPMTCSR_WFR_Pos    = 0x6        // Position of WFR field.
	Ethernet_MACPMTCSR_WFR_Msk    = 0x40       // Bit mask of WFR field.
	Ethernet_MACPMTCSR_WFR        = 0x40       // Bit WFR.
	Ethernet_MACPMTCSR_GU_Pos     = 0x9        // Position of GU field.
	Ethernet_MACPMTCSR_GU_Msk     = 0x200      // Bit mask of GU field.
	Ethernet_MACPMTCSR_GU         = 0x200      // Bit GU.
	Ethernet_MACPMTCSR_WFFRPR_Pos = 0x1f       // Position of WFFRPR field.
	Ethernet_MACPMTCSR_WFFRPR_Msk = 0x80000000 // Bit mask of WFFRPR field.
	Ethernet_MACPMTCSR_WFFRPR     = 0x80000000 // Bit WFFRPR.

	// MACDBGR: Ethernet MAC debug register
	Ethernet_MACDBGR_CR_Pos    = 0x0  // Position of CR field.
	Ethernet_MACDBGR_CR_Msk    = 0x1  // Bit mask of CR field.
	Ethernet_MACDBGR_CR        = 0x1  // Bit CR.
	Ethernet_MACDBGR_CSR_Pos   = 0x1  // Position of CSR field.
	Ethernet_MACDBGR_CSR_Msk   = 0x2  // Bit mask of CSR field.
	Ethernet_MACDBGR_CSR       = 0x2  // Bit CSR.
	Ethernet_MACDBGR_ROR_Pos   = 0x2  // Position of ROR field.
	Ethernet_MACDBGR_ROR_Msk   = 0x4  // Bit mask of ROR field.
	Ethernet_MACDBGR_ROR       = 0x4  // Bit ROR.
	Ethernet_MACDBGR_MCF_Pos   = 0x3  // Position of MCF field.
	Ethernet_MACDBGR_MCF_Msk   = 0x8  // Bit mask of MCF field.
	Ethernet_MACDBGR_MCF       = 0x8  // Bit MCF.
	Ethernet_MACDBGR_MCP_Pos   = 0x4  // Position of MCP field.
	Ethernet_MACDBGR_MCP_Msk   = 0x10 // Bit mask of MCP field.
	Ethernet_MACDBGR_MCP       = 0x10 // Bit MCP.
	Ethernet_MACDBGR_MCFHP_Pos = 0x5  // Position of MCFHP field.
	Ethernet_MACDBGR_MCFHP_Msk = 0x20 // Bit mask of MCFHP field.
	Ethernet_MACDBGR_MCFHP     = 0x20 // Bit MCFHP.

	// MACSR: Ethernet MAC interrupt status           register
	Ethernet_MACSR_PMTS_Pos  = 0x3   // Position of PMTS field.
	Ethernet_MACSR_PMTS_Msk  = 0x8   // Bit mask of PMTS field.
	Ethernet_MACSR_PMTS      = 0x8   // Bit PMTS.
	Ethernet_MACSR_MMCS_Pos  = 0x4   // Position of MMCS field.
	Ethernet_MACSR_MMCS_Msk  = 0x10  // Bit mask of MMCS field.
	Ethernet_MACSR_MMCS      = 0x10  // Bit MMCS.
	Ethernet_MACSR_MMCRS_Pos = 0x5   // Position of MMCRS field.
	Ethernet_MACSR_MMCRS_Msk = 0x20  // Bit mask of MMCRS field.
	Ethernet_MACSR_MMCRS     = 0x20  // Bit MMCRS.
	Ethernet_MACSR_MMCTS_Pos = 0x6   // Position of MMCTS field.
	Ethernet_MACSR_MMCTS_Msk = 0x40  // Bit mask of MMCTS field.
	Ethernet_MACSR_MMCTS     = 0x40  // Bit MMCTS.
	Ethernet_MACSR_TSTS_Pos  = 0x9   // Position of TSTS field.
	Ethernet_MACSR_TSTS_Msk  = 0x200 // Bit mask of TSTS field.
	Ethernet_MACSR_TSTS      = 0x200 // Bit TSTS.

	// MACIMR: Ethernet MAC interrupt mask           register
	Ethernet_MACIMR_PMTIM_Pos = 0x3   // Position of PMTIM field.
	Ethernet_MACIMR_PMTIM_Msk = 0x8   // Bit mask of PMTIM field.
	Ethernet_MACIMR_PMTIM     = 0x8   // Bit PMTIM.
	Ethernet_MACIMR_TSTIM_Pos = 0x9   // Position of TSTIM field.
	Ethernet_MACIMR_TSTIM_Msk = 0x200 // Bit mask of TSTIM field.
	Ethernet_MACIMR_TSTIM     = 0x200 // Bit TSTIM.

	// MACA0HR: Ethernet MAC address 0 high           register
	Ethernet_MACA0HR_MACA0H_Pos = 0x0        // Position of MACA0H field.
	Ethernet_MACA0HR_MACA0H_Msk = 0xffff     // Bit mask of MACA0H field.
	Ethernet_MACA0HR_MO_Pos     = 0x1f       // Position of MO field.
	Ethernet_MACA0HR_MO_Msk     = 0x80000000 // Bit mask of MO field.
	Ethernet_MACA0HR_MO         = 0x80000000 // Bit MO.

	// MACA0LR: Ethernet MAC address 0 low           register
	Ethernet_MACA0LR_MACA0L_Pos = 0x0        // Position of MACA0L field.
	Ethernet_MACA0LR_MACA0L_Msk = 0xffffffff // Bit mask of MACA0L field.

	// MACA1HR: Ethernet MAC address 1 high           register
	Ethernet_MACA1HR_MACA1H_Pos = 0x0        // Position of MACA1H field.
	Ethernet_MACA1HR_MACA1H_Msk = 0xffff     // Bit mask of MACA1H field.
	Ethernet_MACA1HR_MBC_Pos    = 0x18       // Position of MBC field.
	Ethernet_MACA1HR_MBC_Msk    = 0x3f000000 // Bit mask of MBC field.
	Ethernet_MACA1HR_SA_Pos     = 0x1e       // Position of SA field.
	Ethernet_MACA1HR_SA_Msk     = 0x40000000 // Bit mask of SA field.
	Ethernet_MACA1HR_SA         = 0x40000000 // Bit SA.
	Ethernet_MACA1HR_AE_Pos     = 0x1f       // Position of AE field.
	Ethernet_MACA1HR_AE_Msk     = 0x80000000 // Bit mask of AE field.
	Ethernet_MACA1HR_AE         = 0x80000000 // Bit AE.

	// MACA1LR: Ethernet MAC address1 low           register
	Ethernet_MACA1LR_MACA1LR_Pos = 0x0        // Position of MACA1LR field.
	Ethernet_MACA1LR_MACA1LR_Msk = 0xffffffff // Bit mask of MACA1LR field.

	// MACA2HR: Ethernet MAC address 2 high           register
	Ethernet_MACA2HR_MAC2AH_Pos = 0x0        // Position of MAC2AH field.
	Ethernet_MACA2HR_MAC2AH_Msk = 0xffff     // Bit mask of MAC2AH field.
	Ethernet_MACA2HR_MBC_Pos    = 0x18       // Position of MBC field.
	Ethernet_MACA2HR_MBC_Msk    = 0x3f000000 // Bit mask of MBC field.
	Ethernet_MACA2HR_SA_Pos     = 0x1e       // Position of SA field.
	Ethernet_MACA2HR_SA_Msk     = 0x40000000 // Bit mask of SA field.
	Ethernet_MACA2HR_SA         = 0x40000000 // Bit SA.
	Ethernet_MACA2HR_AE_Pos     = 0x1f       // Position of AE field.
	Ethernet_MACA2HR_AE_Msk     = 0x80000000 // Bit mask of AE field.
	Ethernet_MACA2HR_AE         = 0x80000000 // Bit AE.

	// MACA2LR: Ethernet MAC address 2 low           register
	Ethernet_MACA2LR_MACA2L_Pos = 0x0        // Position of MACA2L field.
	Ethernet_MACA2LR_MACA2L_Msk = 0x7fffffff // Bit mask of MACA2L field.

	// MACA3HR: Ethernet MAC address 3 high           register
	Ethernet_MACA3HR_MACA3H_Pos = 0x0        // Position of MACA3H field.
	Ethernet_MACA3HR_MACA3H_Msk = 0xffff     // Bit mask of MACA3H field.
	Ethernet_MACA3HR_MBC_Pos    = 0x18       // Position of MBC field.
	Ethernet_MACA3HR_MBC_Msk    = 0x3f000000 // Bit mask of MBC field.
	Ethernet_MACA3HR_SA_Pos     = 0x1e       // Position of SA field.
	Ethernet_MACA3HR_SA_Msk     = 0x40000000 // Bit mask of SA field.
	Ethernet_MACA3HR_SA         = 0x40000000 // Bit SA.
	Ethernet_MACA3HR_AE_Pos     = 0x1f       // Position of AE field.
	Ethernet_MACA3HR_AE_Msk     = 0x80000000 // Bit mask of AE field.
	Ethernet_MACA3HR_AE         = 0x80000000 // Bit AE.

	// MACA3LR: Ethernet MAC address 3 low           register
	Ethernet_MACA3LR_MBCA3L_Pos = 0x0        // Position of MBCA3L field.
	Ethernet_MACA3LR_MBCA3L_Msk = 0xffffffff // Bit mask of MBCA3L field.
)

// Bitfields for CRC: Cryptographic processor
const (
	// DR: Data register
	CRC_DR_DR_Pos = 0x0        // Position of DR field.
	CRC_DR_DR_Msk = 0xffffffff // Bit mask of DR field.

	// IDR: Independent Data register
	CRC_IDR_IDR_Pos = 0x0  // Position of IDR field.
	CRC_IDR_IDR_Msk = 0xff // Bit mask of IDR field.

	// CR: Control register
	CRC_CR_CR_Pos = 0x0 // Position of CR field.
	CRC_CR_CR_Msk = 0x1 // Bit mask of CR field.
	CRC_CR_CR     = 0x1 // Bit CR.

	// INIT: Initial CRC value
	CRC_INIT_CRC_INIT_Pos = 0x0        // Position of CRC_INIT field.
	CRC_INIT_CRC_INIT_Msk = 0xffffffff // Bit mask of CRC_INIT field.

	// POL: CRC polynomial
	CRC_POL_POL_Pos = 0x0        // Position of POL field.
	CRC_POL_POL_Msk = 0xffffffff // Bit mask of POL field.
)

// Bitfields for CAN1: Controller area network
const (
	// MCR: master control register
	CAN_MCR_DBF_Pos   = 0x10    // Position of DBF field.
	CAN_MCR_DBF_Msk   = 0x10000 // Bit mask of DBF field.
	CAN_MCR_DBF       = 0x10000 // Bit DBF.
	CAN_MCR_RESET_Pos = 0xf     // Position of RESET field.
	CAN_MCR_RESET_Msk = 0x8000  // Bit mask of RESET field.
	CAN_MCR_RESET     = 0x8000  // Bit RESET.
	CAN_MCR_TTCM_Pos  = 0x7     // Position of TTCM field.
	CAN_MCR_TTCM_Msk  = 0x80    // Bit mask of TTCM field.
	CAN_MCR_TTCM      = 0x80    // Bit TTCM.
	CAN_MCR_ABOM_Pos  = 0x6     // Position of ABOM field.
	CAN_MCR_ABOM_Msk  = 0x40    // Bit mask of ABOM field.
	CAN_MCR_ABOM      = 0x40    // Bit ABOM.
	CAN_MCR_AWUM_Pos  = 0x5     // Position of AWUM field.
	CAN_MCR_AWUM_Msk  = 0x20    // Bit mask of AWUM field.
	CAN_MCR_AWUM      = 0x20    // Bit AWUM.
	CAN_MCR_NART_Pos  = 0x4     // Position of NART field.
	CAN_MCR_NART_Msk  = 0x10    // Bit mask of NART field.
	CAN_MCR_NART      = 0x10    // Bit NART.
	CAN_MCR_RFLM_Pos  = 0x3     // Position of RFLM field.
	CAN_MCR_RFLM_Msk  = 0x8     // Bit mask of RFLM field.
	CAN_MCR_RFLM      = 0x8     // Bit RFLM.
	CAN_MCR_TXFP_Pos  = 0x2     // Position of TXFP field.
	CAN_MCR_TXFP_Msk  = 0x4     // Bit mask of TXFP field.
	CAN_MCR_TXFP      = 0x4     // Bit TXFP.
	CAN_MCR_SLEEP_Pos = 0x1     // Position of SLEEP field.
	CAN_MCR_SLEEP_Msk = 0x2     // Bit mask of SLEEP field.
	CAN_MCR_SLEEP     = 0x2     // Bit SLEEP.
	CAN_MCR_INRQ_Pos  = 0x0     // Position of INRQ field.
	CAN_MCR_INRQ_Msk  = 0x1     // Bit mask of INRQ field.
	CAN_MCR_INRQ      = 0x1     // Bit INRQ.

	// MSR: master status register
	CAN_MSR_RX_Pos    = 0xb   // Position of RX field.
	CAN_MSR_RX_Msk    = 0x800 // Bit mask of RX field.
	CAN_MSR_RX        = 0x800 // Bit RX.
	CAN_MSR_SAMP_Pos  = 0xa   // Position of SAMP field.
	CAN_MSR_SAMP_Msk  = 0x400 // Bit mask of SAMP field.
	CAN_MSR_SAMP      = 0x400 // Bit SAMP.
	CAN_MSR_RXM_Pos   = 0x9   // Position of RXM field.
	CAN_MSR_RXM_Msk   = 0x200 // Bit mask of RXM field.
	CAN_MSR_RXM       = 0x200 // Bit RXM.
	CAN_MSR_TXM_Pos   = 0x8   // Position of TXM field.
	CAN_MSR_TXM_Msk   = 0x100 // Bit mask of TXM field.
	CAN_MSR_TXM       = 0x100 // Bit TXM.
	CAN_MSR_SLAKI_Pos = 0x4   // Position of SLAKI field.
	CAN_MSR_SLAKI_Msk = 0x10  // Bit mask of SLAKI field.
	CAN_MSR_SLAKI     = 0x10  // Bit SLAKI.
	CAN_MSR_WKUI_Pos  = 0x3   // Position of WKUI field.
	CAN_MSR_WKUI_Msk  = 0x8   // Bit mask of WKUI field.
	CAN_MSR_WKUI      = 0x8   // Bit WKUI.
	CAN_MSR_ERRI_Pos  = 0x2   // Position of ERRI field.
	CAN_MSR_ERRI_Msk  = 0x4   // Bit mask of ERRI field.
	CAN_MSR_ERRI      = 0x4   // Bit ERRI.
	CAN_MSR_SLAK_Pos  = 0x1   // Position of SLAK field.
	CAN_MSR_SLAK_Msk  = 0x2   // Bit mask of SLAK field.
	CAN_MSR_SLAK      = 0x2   // Bit SLAK.
	CAN_MSR_INAK_Pos  = 0x0   // Position of INAK field.
	CAN_MSR_INAK_Msk  = 0x1   // Bit mask of INAK field.
	CAN_MSR_INAK      = 0x1   // Bit INAK.

	// TSR: transmit status register
	CAN_TSR_LOW2_Pos  = 0x1f       // Position of LOW2 field.
	CAN_TSR_LOW2_Msk  = 0x80000000 // Bit mask of LOW2 field.
	CAN_TSR_LOW2      = 0x80000000 // Bit LOW2.
	CAN_TSR_LOW1_Pos  = 0x1e       // Position of LOW1 field.
	CAN_TSR_LOW1_Msk  = 0x40000000 // Bit mask of LOW1 field.
	CAN_TSR_LOW1      = 0x40000000 // Bit LOW1.
	CAN_TSR_LOW0_Pos  = 0x1d       // Position of LOW0 field.
	CAN_TSR_LOW0_Msk  = 0x20000000 // Bit mask of LOW0 field.
	CAN_TSR_LOW0      = 0x20000000 // Bit LOW0.
	CAN_TSR_TME2_Pos  = 0x1c       // Position of TME2 field.
	CAN_TSR_TME2_Msk  = 0x10000000 // Bit mask of TME2 field.
	CAN_TSR_TME2      = 0x10000000 // Bit TME2.
	CAN_TSR_TME1_Pos  = 0x1b       // Position of TME1 field.
	CAN_TSR_TME1_Msk  = 0x8000000  // Bit mask of TME1 field.
	CAN_TSR_TME1      = 0x8000000  // Bit TME1.
	CAN_TSR_TME0_Pos  = 0x1a       // Position of TME0 field.
	CAN_TSR_TME0_Msk  = 0x4000000  // Bit mask of TME0 field.
	CAN_TSR_TME0      = 0x4000000  // Bit TME0.
	CAN_TSR_CODE_Pos  = 0x18       // Position of CODE field.
	CAN_TSR_CODE_Msk  = 0x3000000  // Bit mask of CODE field.
	CAN_TSR_ABRQ2_Pos = 0x17       // Position of ABRQ2 field.
	CAN_TSR_ABRQ2_Msk = 0x800000   // Bit mask of ABRQ2 field.
	CAN_TSR_ABRQ2     = 0x800000   // Bit ABRQ2.
	CAN_TSR_TERR2_Pos = 0x13       // Position of TERR2 field.
	CAN_TSR_TERR2_Msk = 0x80000    // Bit mask of TERR2 field.
	CAN_TSR_TERR2     = 0x80000    // Bit TERR2.
	CAN_TSR_ALST2_Pos = 0x12       // Position of ALST2 field.
	CAN_TSR_ALST2_Msk = 0x40000    // Bit mask of ALST2 field.
	CAN_TSR_ALST2     = 0x40000    // Bit ALST2.
	CAN_TSR_TXOK2_Pos = 0x11       // Position of TXOK2 field.
	CAN_TSR_TXOK2_Msk = 0x20000    // Bit mask of TXOK2 field.
	CAN_TSR_TXOK2     = 0x20000    // Bit TXOK2.
	CAN_TSR_RQCP2_Pos = 0x10       // Position of RQCP2 field.
	CAN_TSR_RQCP2_Msk = 0x10000    // Bit mask of RQCP2 field.
	CAN_TSR_RQCP2     = 0x10000    // Bit RQCP2.
	CAN_TSR_ABRQ1_Pos = 0xf        // Position of ABRQ1 field.
	CAN_TSR_ABRQ1_Msk = 0x8000     // Bit mask of ABRQ1 field.
	CAN_TSR_ABRQ1     = 0x8000     // Bit ABRQ1.
	CAN_TSR_TERR1_Pos = 0xb        // Position of TERR1 field.
	CAN_TSR_TERR1_Msk = 0x800      // Bit mask of TERR1 field.
	CAN_TSR_TERR1     = 0x800      // Bit TERR1.
	CAN_TSR_ALST1_Pos = 0xa        // Position of ALST1 field.
	CAN_TSR_ALST1_Msk = 0x400      // Bit mask of ALST1 field.
	CAN_TSR_ALST1     = 0x400      // Bit ALST1.
	CAN_TSR_TXOK1_Pos = 0x9        // Position of TXOK1 field.
	CAN_TSR_TXOK1_Msk = 0x200      // Bit mask of TXOK1 field.
	CAN_TSR_TXOK1     = 0x200      // Bit TXOK1.
	CAN_TSR_RQCP1_Pos = 0x8        // Position of RQCP1 field.
	CAN_TSR_RQCP1_Msk = 0x100      // Bit mask of RQCP1 field.
	CAN_TSR_RQCP1     = 0x100      // Bit RQCP1.
	CAN_TSR_ABRQ0_Pos = 0x7        // Position of ABRQ0 field.
	CAN_TSR_ABRQ0_Msk = 0x80       // Bit mask of ABRQ0 field.
	CAN_TSR_ABRQ0     = 0x80       // Bit ABRQ0.
	CAN_TSR_TERR0_Pos = 0x3        // Position of TERR0 field.
	CAN_TSR_TERR0_Msk = 0x8        // Bit mask of TERR0 field.
	CAN_TSR_TERR0     = 0x8        // Bit TERR0.
	CAN_TSR_ALST0_Pos = 0x2        // Position of ALST0 field.
	CAN_TSR_ALST0_Msk = 0x4        // Bit mask of ALST0 field.
	CAN_TSR_ALST0     = 0x4        // Bit ALST0.
	CAN_TSR_TXOK0_Pos = 0x1        // Position of TXOK0 field.
	CAN_TSR_TXOK0_Msk = 0x2        // Bit mask of TXOK0 field.
	CAN_TSR_TXOK0     = 0x2        // Bit TXOK0.
	CAN_TSR_RQCP0_Pos = 0x0        // Position of RQCP0 field.
	CAN_TSR_RQCP0_Msk = 0x1        // Bit mask of RQCP0 field.
	CAN_TSR_RQCP0     = 0x1        // Bit RQCP0.

	// RF0R: receive FIFO 0 register
	CAN_RF0R_RFOM0_Pos = 0x5  // Position of RFOM0 field.
	CAN_RF0R_RFOM0_Msk = 0x20 // Bit mask of RFOM0 field.
	CAN_RF0R_RFOM0     = 0x20 // Bit RFOM0.
	CAN_RF0R_FOVR0_Pos = 0x4  // Position of FOVR0 field.
	CAN_RF0R_FOVR0_Msk = 0x10 // Bit mask of FOVR0 field.
	CAN_RF0R_FOVR0     = 0x10 // Bit FOVR0.
	CAN_RF0R_FULL0_Pos = 0x3  // Position of FULL0 field.
	CAN_RF0R_FULL0_Msk = 0x8  // Bit mask of FULL0 field.
	CAN_RF0R_FULL0     = 0x8  // Bit FULL0.
	CAN_RF0R_FMP0_Pos  = 0x0  // Position of FMP0 field.
	CAN_RF0R_FMP0_Msk  = 0x3  // Bit mask of FMP0 field.

	// RF1R: receive FIFO 1 register
	CAN_RF1R_RFOM1_Pos = 0x5  // Position of RFOM1 field.
	CAN_RF1R_RFOM1_Msk = 0x20 // Bit mask of RFOM1 field.
	CAN_RF1R_RFOM1     = 0x20 // Bit RFOM1.
	CAN_RF1R_FOVR1_Pos = 0x4  // Position of FOVR1 field.
	CAN_RF1R_FOVR1_Msk = 0x10 // Bit mask of FOVR1 field.
	CAN_RF1R_FOVR1     = 0x10 // Bit FOVR1.
	CAN_RF1R_FULL1_Pos = 0x3  // Position of FULL1 field.
	CAN_RF1R_FULL1_Msk = 0x8  // Bit mask of FULL1 field.
	CAN_RF1R_FULL1     = 0x8  // Bit FULL1.
	CAN_RF1R_FMP1_Pos  = 0x0  // Position of FMP1 field.
	CAN_RF1R_FMP1_Msk  = 0x3  // Bit mask of FMP1 field.

	// IER: interrupt enable register
	CAN_IER_SLKIE_Pos  = 0x11    // Position of SLKIE field.
	CAN_IER_SLKIE_Msk  = 0x20000 // Bit mask of SLKIE field.
	CAN_IER_SLKIE      = 0x20000 // Bit SLKIE.
	CAN_IER_WKUIE_Pos  = 0x10    // Position of WKUIE field.
	CAN_IER_WKUIE_Msk  = 0x10000 // Bit mask of WKUIE field.
	CAN_IER_WKUIE      = 0x10000 // Bit WKUIE.
	CAN_IER_ERRIE_Pos  = 0xf     // Position of ERRIE field.
	CAN_IER_ERRIE_Msk  = 0x8000  // Bit mask of ERRIE field.
	CAN_IER_ERRIE      = 0x8000  // Bit ERRIE.
	CAN_IER_LECIE_Pos  = 0xb     // Position of LECIE field.
	CAN_IER_LECIE_Msk  = 0x800   // Bit mask of LECIE field.
	CAN_IER_LECIE      = 0x800   // Bit LECIE.
	CAN_IER_BOFIE_Pos  = 0xa     // Position of BOFIE field.
	CAN_IER_BOFIE_Msk  = 0x400   // Bit mask of BOFIE field.
	CAN_IER_BOFIE      = 0x400   // Bit BOFIE.
	CAN_IER_EPVIE_Pos  = 0x9     // Position of EPVIE field.
	CAN_IER_EPVIE_Msk  = 0x200   // Bit mask of EPVIE field.
	CAN_IER_EPVIE      = 0x200   // Bit EPVIE.
	CAN_IER_EWGIE_Pos  = 0x8     // Position of EWGIE field.
	CAN_IER_EWGIE_Msk  = 0x100   // Bit mask of EWGIE field.
	CAN_IER_EWGIE      = 0x100   // Bit EWGIE.
	CAN_IER_FOVIE1_Pos = 0x6     // Position of FOVIE1 field.
	CAN_IER_FOVIE1_Msk = 0x40    // Bit mask of FOVIE1 field.
	CAN_IER_FOVIE1     = 0x40    // Bit FOVIE1.
	CAN_IER_FFIE1_Pos  = 0x5     // Position of FFIE1 field.
	CAN_IER_FFIE1_Msk  = 0x20    // Bit mask of FFIE1 field.
	CAN_IER_FFIE1      = 0x20    // Bit FFIE1.
	CAN_IER_FMPIE1_Pos = 0x4     // Position of FMPIE1 field.
	CAN_IER_FMPIE1_Msk = 0x10    // Bit mask of FMPIE1 field.
	CAN_IER_FMPIE1     = 0x10    // Bit FMPIE1.
	CAN_IER_FOVIE0_Pos = 0x3     // Position of FOVIE0 field.
	CAN_IER_FOVIE0_Msk = 0x8     // Bit mask of FOVIE0 field.
	CAN_IER_FOVIE0     = 0x8     // Bit FOVIE0.
	CAN_IER_FFIE0_Pos  = 0x2     // Position of FFIE0 field.
	CAN_IER_FFIE0_Msk  = 0x4     // Bit mask of FFIE0 field.
	CAN_IER_FFIE0      = 0x4     // Bit FFIE0.
	CAN_IER_FMPIE0_Pos = 0x1     // Position of FMPIE0 field.
	CAN_IER_FMPIE0_Msk = 0x2     // Bit mask of FMPIE0 field.
	CAN_IER_FMPIE0     = 0x2     // Bit FMPIE0.
	CAN_IER_TMEIE_Pos  = 0x0     // Position of TMEIE field.
	CAN_IER_TMEIE_Msk  = 0x1     // Bit mask of TMEIE field.
	CAN_IER_TMEIE      = 0x1     // Bit TMEIE.

	// ESR: interrupt enable register
	CAN_ESR_REC_Pos  = 0x18       // Position of REC field.
	CAN_ESR_REC_Msk  = 0xff000000 // Bit mask of REC field.
	CAN_ESR_TEC_Pos  = 0x10       // Position of TEC field.
	CAN_ESR_TEC_Msk  = 0xff0000   // Bit mask of TEC field.
	CAN_ESR_LEC_Pos  = 0x4        // Position of LEC field.
	CAN_ESR_LEC_Msk  = 0x70       // Bit mask of LEC field.
	CAN_ESR_BOFF_Pos = 0x2        // Position of BOFF field.
	CAN_ESR_BOFF_Msk = 0x4        // Bit mask of BOFF field.
	CAN_ESR_BOFF     = 0x4        // Bit BOFF.
	CAN_ESR_EPVF_Pos = 0x1        // Position of EPVF field.
	CAN_ESR_EPVF_Msk = 0x2        // Bit mask of EPVF field.
	CAN_ESR_EPVF     = 0x2        // Bit EPVF.
	CAN_ESR_EWGF_Pos = 0x0        // Position of EWGF field.
	CAN_ESR_EWGF_Msk = 0x1        // Bit mask of EWGF field.
	CAN_ESR_EWGF     = 0x1        // Bit EWGF.

	// BTR: bit timing register
	CAN_BTR_SILM_Pos = 0x1f       // Position of SILM field.
	CAN_BTR_SILM_Msk = 0x80000000 // Bit mask of SILM field.
	CAN_BTR_SILM     = 0x80000000 // Bit SILM.
	CAN_BTR_LBKM_Pos = 0x1e       // Position of LBKM field.
	CAN_BTR_LBKM_Msk = 0x40000000 // Bit mask of LBKM field.
	CAN_BTR_LBKM     = 0x40000000 // Bit LBKM.
	CAN_BTR_SJW_Pos  = 0x18       // Position of SJW field.
	CAN_BTR_SJW_Msk  = 0x3000000  // Bit mask of SJW field.
	CAN_BTR_TS2_Pos  = 0x14       // Position of TS2 field.
	CAN_BTR_TS2_Msk  = 0x700000   // Bit mask of TS2 field.
	CAN_BTR_TS1_Pos  = 0x10       // Position of TS1 field.
	CAN_BTR_TS1_Msk  = 0xf0000    // Bit mask of TS1 field.
	CAN_BTR_BRP_Pos  = 0x0        // Position of BRP field.
	CAN_BTR_BRP_Msk  = 0x3ff      // Bit mask of BRP field.

	// TI0R: TX mailbox identifier register
	CAN_TI0R_STID_Pos = 0x15       // Position of STID field.
	CAN_TI0R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_TI0R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_TI0R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_TI0R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_TI0R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_TI0R_IDE      = 0x4        // Bit IDE.
	CAN_TI0R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_TI0R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_TI0R_RTR      = 0x2        // Bit RTR.
	CAN_TI0R_TXRQ_Pos = 0x0        // Position of TXRQ field.
	CAN_TI0R_TXRQ_Msk = 0x1        // Bit mask of TXRQ field.
	CAN_TI0R_TXRQ     = 0x1        // Bit TXRQ.

	// TDT0R: mailbox data length control and time stamp           register
	CAN_TDT0R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_TDT0R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_TDT0R_TGT_Pos  = 0x8        // Position of TGT field.
	CAN_TDT0R_TGT_Msk  = 0x100      // Bit mask of TGT field.
	CAN_TDT0R_TGT      = 0x100      // Bit TGT.
	CAN_TDT0R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_TDT0R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// TDL0R: mailbox data low register
	CAN_TDL0R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_TDL0R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_TDL0R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_TDL0R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_TDL0R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_TDL0R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_TDL0R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_TDL0R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// TDH0R: mailbox data high register
	CAN_TDH0R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_TDH0R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_TDH0R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_TDH0R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_TDH0R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_TDH0R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_TDH0R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_TDH0R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// TI1R: mailbox identifier register
	CAN_TI1R_STID_Pos = 0x15       // Position of STID field.
	CAN_TI1R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_TI1R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_TI1R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_TI1R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_TI1R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_TI1R_IDE      = 0x4        // Bit IDE.
	CAN_TI1R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_TI1R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_TI1R_RTR      = 0x2        // Bit RTR.
	CAN_TI1R_TXRQ_Pos = 0x0        // Position of TXRQ field.
	CAN_TI1R_TXRQ_Msk = 0x1        // Bit mask of TXRQ field.
	CAN_TI1R_TXRQ     = 0x1        // Bit TXRQ.

	// TDT1R: mailbox data length control and time stamp           register
	CAN_TDT1R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_TDT1R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_TDT1R_TGT_Pos  = 0x8        // Position of TGT field.
	CAN_TDT1R_TGT_Msk  = 0x100      // Bit mask of TGT field.
	CAN_TDT1R_TGT      = 0x100      // Bit TGT.
	CAN_TDT1R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_TDT1R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// TDL1R: mailbox data low register
	CAN_TDL1R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_TDL1R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_TDL1R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_TDL1R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_TDL1R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_TDL1R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_TDL1R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_TDL1R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// TDH1R: mailbox data high register
	CAN_TDH1R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_TDH1R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_TDH1R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_TDH1R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_TDH1R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_TDH1R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_TDH1R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_TDH1R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// TI2R: mailbox identifier register
	CAN_TI2R_STID_Pos = 0x15       // Position of STID field.
	CAN_TI2R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_TI2R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_TI2R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_TI2R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_TI2R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_TI2R_IDE      = 0x4        // Bit IDE.
	CAN_TI2R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_TI2R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_TI2R_RTR      = 0x2        // Bit RTR.
	CAN_TI2R_TXRQ_Pos = 0x0        // Position of TXRQ field.
	CAN_TI2R_TXRQ_Msk = 0x1        // Bit mask of TXRQ field.
	CAN_TI2R_TXRQ     = 0x1        // Bit TXRQ.

	// TDT2R: mailbox data length control and time stamp           register
	CAN_TDT2R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_TDT2R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_TDT2R_TGT_Pos  = 0x8        // Position of TGT field.
	CAN_TDT2R_TGT_Msk  = 0x100      // Bit mask of TGT field.
	CAN_TDT2R_TGT      = 0x100      // Bit TGT.
	CAN_TDT2R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_TDT2R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// TDL2R: mailbox data low register
	CAN_TDL2R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_TDL2R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_TDL2R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_TDL2R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_TDL2R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_TDL2R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_TDL2R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_TDL2R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// TDH2R: mailbox data high register
	CAN_TDH2R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_TDH2R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_TDH2R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_TDH2R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_TDH2R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_TDH2R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_TDH2R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_TDH2R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// RI0R: receive FIFO mailbox identifier           register
	CAN_RI0R_STID_Pos = 0x15       // Position of STID field.
	CAN_RI0R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_RI0R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_RI0R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_RI0R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_RI0R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_RI0R_IDE      = 0x4        // Bit IDE.
	CAN_RI0R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_RI0R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_RI0R_RTR      = 0x2        // Bit RTR.

	// RDT0R: mailbox data high register
	CAN_RDT0R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_RDT0R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_RDT0R_FMI_Pos  = 0x8        // Position of FMI field.
	CAN_RDT0R_FMI_Msk  = 0xff00     // Bit mask of FMI field.
	CAN_RDT0R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_RDT0R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// RDL0R: mailbox data high register
	CAN_RDL0R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_RDL0R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_RDL0R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_RDL0R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_RDL0R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_RDL0R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_RDL0R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_RDL0R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// RDH0R: receive FIFO mailbox data high           register
	CAN_RDH0R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_RDH0R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_RDH0R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_RDH0R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_RDH0R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_RDH0R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_RDH0R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_RDH0R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// RI1R: mailbox data high register
	CAN_RI1R_STID_Pos = 0x15       // Position of STID field.
	CAN_RI1R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_RI1R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_RI1R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_RI1R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_RI1R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_RI1R_IDE      = 0x4        // Bit IDE.
	CAN_RI1R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_RI1R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_RI1R_RTR      = 0x2        // Bit RTR.

	// RDT1R: mailbox data high register
	CAN_RDT1R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_RDT1R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_RDT1R_FMI_Pos  = 0x8        // Position of FMI field.
	CAN_RDT1R_FMI_Msk  = 0xff00     // Bit mask of FMI field.
	CAN_RDT1R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_RDT1R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// RDL1R: mailbox data high register
	CAN_RDL1R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_RDL1R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_RDL1R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_RDL1R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_RDL1R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_RDL1R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_RDL1R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_RDL1R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// RDH1R: mailbox data high register
	CAN_RDH1R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_RDH1R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_RDH1R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_RDH1R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_RDH1R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_RDH1R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_RDH1R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_RDH1R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// FMR: filter master register
	CAN_FMR_CAN2SB_Pos = 0x8    // Position of CAN2SB field.
	CAN_FMR_CAN2SB_Msk = 0x3f00 // Bit mask of CAN2SB field.
	CAN_FMR_FINIT_Pos  = 0x0    // Position of FINIT field.
	CAN_FMR_FINIT_Msk  = 0x1    // Bit mask of FINIT field.
	CAN_FMR_FINIT      = 0x1    // Bit FINIT.

	// FM1R: filter mode register
	CAN_FM1R_FBM0_Pos  = 0x0       // Position of FBM0 field.
	CAN_FM1R_FBM0_Msk  = 0x1       // Bit mask of FBM0 field.
	CAN_FM1R_FBM0      = 0x1       // Bit FBM0.
	CAN_FM1R_FBM1_Pos  = 0x1       // Position of FBM1 field.
	CAN_FM1R_FBM1_Msk  = 0x2       // Bit mask of FBM1 field.
	CAN_FM1R_FBM1      = 0x2       // Bit FBM1.
	CAN_FM1R_FBM2_Pos  = 0x2       // Position of FBM2 field.
	CAN_FM1R_FBM2_Msk  = 0x4       // Bit mask of FBM2 field.
	CAN_FM1R_FBM2      = 0x4       // Bit FBM2.
	CAN_FM1R_FBM3_Pos  = 0x3       // Position of FBM3 field.
	CAN_FM1R_FBM3_Msk  = 0x8       // Bit mask of FBM3 field.
	CAN_FM1R_FBM3      = 0x8       // Bit FBM3.
	CAN_FM1R_FBM4_Pos  = 0x4       // Position of FBM4 field.
	CAN_FM1R_FBM4_Msk  = 0x10      // Bit mask of FBM4 field.
	CAN_FM1R_FBM4      = 0x10      // Bit FBM4.
	CAN_FM1R_FBM5_Pos  = 0x5       // Position of FBM5 field.
	CAN_FM1R_FBM5_Msk  = 0x20      // Bit mask of FBM5 field.
	CAN_FM1R_FBM5      = 0x20      // Bit FBM5.
	CAN_FM1R_FBM6_Pos  = 0x6       // Position of FBM6 field.
	CAN_FM1R_FBM6_Msk  = 0x40      // Bit mask of FBM6 field.
	CAN_FM1R_FBM6      = 0x40      // Bit FBM6.
	CAN_FM1R_FBM7_Pos  = 0x7       // Position of FBM7 field.
	CAN_FM1R_FBM7_Msk  = 0x80      // Bit mask of FBM7 field.
	CAN_FM1R_FBM7      = 0x80      // Bit FBM7.
	CAN_FM1R_FBM8_Pos  = 0x8       // Position of FBM8 field.
	CAN_FM1R_FBM8_Msk  = 0x100     // Bit mask of FBM8 field.
	CAN_FM1R_FBM8      = 0x100     // Bit FBM8.
	CAN_FM1R_FBM9_Pos  = 0x9       // Position of FBM9 field.
	CAN_FM1R_FBM9_Msk  = 0x200     // Bit mask of FBM9 field.
	CAN_FM1R_FBM9      = 0x200     // Bit FBM9.
	CAN_FM1R_FBM10_Pos = 0xa       // Position of FBM10 field.
	CAN_FM1R_FBM10_Msk = 0x400     // Bit mask of FBM10 field.
	CAN_FM1R_FBM10     = 0x400     // Bit FBM10.
	CAN_FM1R_FBM11_Pos = 0xb       // Position of FBM11 field.
	CAN_FM1R_FBM11_Msk = 0x800     // Bit mask of FBM11 field.
	CAN_FM1R_FBM11     = 0x800     // Bit FBM11.
	CAN_FM1R_FBM12_Pos = 0xc       // Position of FBM12 field.
	CAN_FM1R_FBM12_Msk = 0x1000    // Bit mask of FBM12 field.
	CAN_FM1R_FBM12     = 0x1000    // Bit FBM12.
	CAN_FM1R_FBM13_Pos = 0xd       // Position of FBM13 field.
	CAN_FM1R_FBM13_Msk = 0x2000    // Bit mask of FBM13 field.
	CAN_FM1R_FBM13     = 0x2000    // Bit FBM13.
	CAN_FM1R_FBM14_Pos = 0xe       // Position of FBM14 field.
	CAN_FM1R_FBM14_Msk = 0x4000    // Bit mask of FBM14 field.
	CAN_FM1R_FBM14     = 0x4000    // Bit FBM14.
	CAN_FM1R_FBM15_Pos = 0xf       // Position of FBM15 field.
	CAN_FM1R_FBM15_Msk = 0x8000    // Bit mask of FBM15 field.
	CAN_FM1R_FBM15     = 0x8000    // Bit FBM15.
	CAN_FM1R_FBM16_Pos = 0x10      // Position of FBM16 field.
	CAN_FM1R_FBM16_Msk = 0x10000   // Bit mask of FBM16 field.
	CAN_FM1R_FBM16     = 0x10000   // Bit FBM16.
	CAN_FM1R_FBM17_Pos = 0x11      // Position of FBM17 field.
	CAN_FM1R_FBM17_Msk = 0x20000   // Bit mask of FBM17 field.
	CAN_FM1R_FBM17     = 0x20000   // Bit FBM17.
	CAN_FM1R_FBM18_Pos = 0x12      // Position of FBM18 field.
	CAN_FM1R_FBM18_Msk = 0x40000   // Bit mask of FBM18 field.
	CAN_FM1R_FBM18     = 0x40000   // Bit FBM18.
	CAN_FM1R_FBM19_Pos = 0x13      // Position of FBM19 field.
	CAN_FM1R_FBM19_Msk = 0x80000   // Bit mask of FBM19 field.
	CAN_FM1R_FBM19     = 0x80000   // Bit FBM19.
	CAN_FM1R_FBM20_Pos = 0x14      // Position of FBM20 field.
	CAN_FM1R_FBM20_Msk = 0x100000  // Bit mask of FBM20 field.
	CAN_FM1R_FBM20     = 0x100000  // Bit FBM20.
	CAN_FM1R_FBM21_Pos = 0x15      // Position of FBM21 field.
	CAN_FM1R_FBM21_Msk = 0x200000  // Bit mask of FBM21 field.
	CAN_FM1R_FBM21     = 0x200000  // Bit FBM21.
	CAN_FM1R_FBM22_Pos = 0x16      // Position of FBM22 field.
	CAN_FM1R_FBM22_Msk = 0x400000  // Bit mask of FBM22 field.
	CAN_FM1R_FBM22     = 0x400000  // Bit FBM22.
	CAN_FM1R_FBM23_Pos = 0x17      // Position of FBM23 field.
	CAN_FM1R_FBM23_Msk = 0x800000  // Bit mask of FBM23 field.
	CAN_FM1R_FBM23     = 0x800000  // Bit FBM23.
	CAN_FM1R_FBM24_Pos = 0x18      // Position of FBM24 field.
	CAN_FM1R_FBM24_Msk = 0x1000000 // Bit mask of FBM24 field.
	CAN_FM1R_FBM24     = 0x1000000 // Bit FBM24.
	CAN_FM1R_FBM25_Pos = 0x19      // Position of FBM25 field.
	CAN_FM1R_FBM25_Msk = 0x2000000 // Bit mask of FBM25 field.
	CAN_FM1R_FBM25     = 0x2000000 // Bit FBM25.
	CAN_FM1R_FBM26_Pos = 0x1a      // Position of FBM26 field.
	CAN_FM1R_FBM26_Msk = 0x4000000 // Bit mask of FBM26 field.
	CAN_FM1R_FBM26     = 0x4000000 // Bit FBM26.
	CAN_FM1R_FBM27_Pos = 0x1b      // Position of FBM27 field.
	CAN_FM1R_FBM27_Msk = 0x8000000 // Bit mask of FBM27 field.
	CAN_FM1R_FBM27     = 0x8000000 // Bit FBM27.

	// FS1R: filter scale register
	CAN_FS1R_FSC0_Pos  = 0x0       // Position of FSC0 field.
	CAN_FS1R_FSC0_Msk  = 0x1       // Bit mask of FSC0 field.
	CAN_FS1R_FSC0      = 0x1       // Bit FSC0.
	CAN_FS1R_FSC1_Pos  = 0x1       // Position of FSC1 field.
	CAN_FS1R_FSC1_Msk  = 0x2       // Bit mask of FSC1 field.
	CAN_FS1R_FSC1      = 0x2       // Bit FSC1.
	CAN_FS1R_FSC2_Pos  = 0x2       // Position of FSC2 field.
	CAN_FS1R_FSC2_Msk  = 0x4       // Bit mask of FSC2 field.
	CAN_FS1R_FSC2      = 0x4       // Bit FSC2.
	CAN_FS1R_FSC3_Pos  = 0x3       // Position of FSC3 field.
	CAN_FS1R_FSC3_Msk  = 0x8       // Bit mask of FSC3 field.
	CAN_FS1R_FSC3      = 0x8       // Bit FSC3.
	CAN_FS1R_FSC4_Pos  = 0x4       // Position of FSC4 field.
	CAN_FS1R_FSC4_Msk  = 0x10      // Bit mask of FSC4 field.
	CAN_FS1R_FSC4      = 0x10      // Bit FSC4.
	CAN_FS1R_FSC5_Pos  = 0x5       // Position of FSC5 field.
	CAN_FS1R_FSC5_Msk  = 0x20      // Bit mask of FSC5 field.
	CAN_FS1R_FSC5      = 0x20      // Bit FSC5.
	CAN_FS1R_FSC6_Pos  = 0x6       // Position of FSC6 field.
	CAN_FS1R_FSC6_Msk  = 0x40      // Bit mask of FSC6 field.
	CAN_FS1R_FSC6      = 0x40      // Bit FSC6.
	CAN_FS1R_FSC7_Pos  = 0x7       // Position of FSC7 field.
	CAN_FS1R_FSC7_Msk  = 0x80      // Bit mask of FSC7 field.
	CAN_FS1R_FSC7      = 0x80      // Bit FSC7.
	CAN_FS1R_FSC8_Pos  = 0x8       // Position of FSC8 field.
	CAN_FS1R_FSC8_Msk  = 0x100     // Bit mask of FSC8 field.
	CAN_FS1R_FSC8      = 0x100     // Bit FSC8.
	CAN_FS1R_FSC9_Pos  = 0x9       // Position of FSC9 field.
	CAN_FS1R_FSC9_Msk  = 0x200     // Bit mask of FSC9 field.
	CAN_FS1R_FSC9      = 0x200     // Bit FSC9.
	CAN_FS1R_FSC10_Pos = 0xa       // Position of FSC10 field.
	CAN_FS1R_FSC10_Msk = 0x400     // Bit mask of FSC10 field.
	CAN_FS1R_FSC10     = 0x400     // Bit FSC10.
	CAN_FS1R_FSC11_Pos = 0xb       // Position of FSC11 field.
	CAN_FS1R_FSC11_Msk = 0x800     // Bit mask of FSC11 field.
	CAN_FS1R_FSC11     = 0x800     // Bit FSC11.
	CAN_FS1R_FSC12_Pos = 0xc       // Position of FSC12 field.
	CAN_FS1R_FSC12_Msk = 0x1000    // Bit mask of FSC12 field.
	CAN_FS1R_FSC12     = 0x1000    // Bit FSC12.
	CAN_FS1R_FSC13_Pos = 0xd       // Position of FSC13 field.
	CAN_FS1R_FSC13_Msk = 0x2000    // Bit mask of FSC13 field.
	CAN_FS1R_FSC13     = 0x2000    // Bit FSC13.
	CAN_FS1R_FSC14_Pos = 0xe       // Position of FSC14 field.
	CAN_FS1R_FSC14_Msk = 0x4000    // Bit mask of FSC14 field.
	CAN_FS1R_FSC14     = 0x4000    // Bit FSC14.
	CAN_FS1R_FSC15_Pos = 0xf       // Position of FSC15 field.
	CAN_FS1R_FSC15_Msk = 0x8000    // Bit mask of FSC15 field.
	CAN_FS1R_FSC15     = 0x8000    // Bit FSC15.
	CAN_FS1R_FSC16_Pos = 0x10      // Position of FSC16 field.
	CAN_FS1R_FSC16_Msk = 0x10000   // Bit mask of FSC16 field.
	CAN_FS1R_FSC16     = 0x10000   // Bit FSC16.
	CAN_FS1R_FSC17_Pos = 0x11      // Position of FSC17 field.
	CAN_FS1R_FSC17_Msk = 0x20000   // Bit mask of FSC17 field.
	CAN_FS1R_FSC17     = 0x20000   // Bit FSC17.
	CAN_FS1R_FSC18_Pos = 0x12      // Position of FSC18 field.
	CAN_FS1R_FSC18_Msk = 0x40000   // Bit mask of FSC18 field.
	CAN_FS1R_FSC18     = 0x40000   // Bit FSC18.
	CAN_FS1R_FSC19_Pos = 0x13      // Position of FSC19 field.
	CAN_FS1R_FSC19_Msk = 0x80000   // Bit mask of FSC19 field.
	CAN_FS1R_FSC19     = 0x80000   // Bit FSC19.
	CAN_FS1R_FSC20_Pos = 0x14      // Position of FSC20 field.
	CAN_FS1R_FSC20_Msk = 0x100000  // Bit mask of FSC20 field.
	CAN_FS1R_FSC20     = 0x100000  // Bit FSC20.
	CAN_FS1R_FSC21_Pos = 0x15      // Position of FSC21 field.
	CAN_FS1R_FSC21_Msk = 0x200000  // Bit mask of FSC21 field.
	CAN_FS1R_FSC21     = 0x200000  // Bit FSC21.
	CAN_FS1R_FSC22_Pos = 0x16      // Position of FSC22 field.
	CAN_FS1R_FSC22_Msk = 0x400000  // Bit mask of FSC22 field.
	CAN_FS1R_FSC22     = 0x400000  // Bit FSC22.
	CAN_FS1R_FSC23_Pos = 0x17      // Position of FSC23 field.
	CAN_FS1R_FSC23_Msk = 0x800000  // Bit mask of FSC23 field.
	CAN_FS1R_FSC23     = 0x800000  // Bit FSC23.
	CAN_FS1R_FSC24_Pos = 0x18      // Position of FSC24 field.
	CAN_FS1R_FSC24_Msk = 0x1000000 // Bit mask of FSC24 field.
	CAN_FS1R_FSC24     = 0x1000000 // Bit FSC24.
	CAN_FS1R_FSC25_Pos = 0x19      // Position of FSC25 field.
	CAN_FS1R_FSC25_Msk = 0x2000000 // Bit mask of FSC25 field.
	CAN_FS1R_FSC25     = 0x2000000 // Bit FSC25.
	CAN_FS1R_FSC26_Pos = 0x1a      // Position of FSC26 field.
	CAN_FS1R_FSC26_Msk = 0x4000000 // Bit mask of FSC26 field.
	CAN_FS1R_FSC26     = 0x4000000 // Bit FSC26.
	CAN_FS1R_FSC27_Pos = 0x1b      // Position of FSC27 field.
	CAN_FS1R_FSC27_Msk = 0x8000000 // Bit mask of FSC27 field.
	CAN_FS1R_FSC27     = 0x8000000 // Bit FSC27.

	// FFA1R: filter FIFO assignment           register
	CAN_FFA1R_FFA0_Pos  = 0x0       // Position of FFA0 field.
	CAN_FFA1R_FFA0_Msk  = 0x1       // Bit mask of FFA0 field.
	CAN_FFA1R_FFA0      = 0x1       // Bit FFA0.
	CAN_FFA1R_FFA1_Pos  = 0x1       // Position of FFA1 field.
	CAN_FFA1R_FFA1_Msk  = 0x2       // Bit mask of FFA1 field.
	CAN_FFA1R_FFA1      = 0x2       // Bit FFA1.
	CAN_FFA1R_FFA2_Pos  = 0x2       // Position of FFA2 field.
	CAN_FFA1R_FFA2_Msk  = 0x4       // Bit mask of FFA2 field.
	CAN_FFA1R_FFA2      = 0x4       // Bit FFA2.
	CAN_FFA1R_FFA3_Pos  = 0x3       // Position of FFA3 field.
	CAN_FFA1R_FFA3_Msk  = 0x8       // Bit mask of FFA3 field.
	CAN_FFA1R_FFA3      = 0x8       // Bit FFA3.
	CAN_FFA1R_FFA4_Pos  = 0x4       // Position of FFA4 field.
	CAN_FFA1R_FFA4_Msk  = 0x10      // Bit mask of FFA4 field.
	CAN_FFA1R_FFA4      = 0x10      // Bit FFA4.
	CAN_FFA1R_FFA5_Pos  = 0x5       // Position of FFA5 field.
	CAN_FFA1R_FFA5_Msk  = 0x20      // Bit mask of FFA5 field.
	CAN_FFA1R_FFA5      = 0x20      // Bit FFA5.
	CAN_FFA1R_FFA6_Pos  = 0x6       // Position of FFA6 field.
	CAN_FFA1R_FFA6_Msk  = 0x40      // Bit mask of FFA6 field.
	CAN_FFA1R_FFA6      = 0x40      // Bit FFA6.
	CAN_FFA1R_FFA7_Pos  = 0x7       // Position of FFA7 field.
	CAN_FFA1R_FFA7_Msk  = 0x80      // Bit mask of FFA7 field.
	CAN_FFA1R_FFA7      = 0x80      // Bit FFA7.
	CAN_FFA1R_FFA8_Pos  = 0x8       // Position of FFA8 field.
	CAN_FFA1R_FFA8_Msk  = 0x100     // Bit mask of FFA8 field.
	CAN_FFA1R_FFA8      = 0x100     // Bit FFA8.
	CAN_FFA1R_FFA9_Pos  = 0x9       // Position of FFA9 field.
	CAN_FFA1R_FFA9_Msk  = 0x200     // Bit mask of FFA9 field.
	CAN_FFA1R_FFA9      = 0x200     // Bit FFA9.
	CAN_FFA1R_FFA10_Pos = 0xa       // Position of FFA10 field.
	CAN_FFA1R_FFA10_Msk = 0x400     // Bit mask of FFA10 field.
	CAN_FFA1R_FFA10     = 0x400     // Bit FFA10.
	CAN_FFA1R_FFA11_Pos = 0xb       // Position of FFA11 field.
	CAN_FFA1R_FFA11_Msk = 0x800     // Bit mask of FFA11 field.
	CAN_FFA1R_FFA11     = 0x800     // Bit FFA11.
	CAN_FFA1R_FFA12_Pos = 0xc       // Position of FFA12 field.
	CAN_FFA1R_FFA12_Msk = 0x1000    // Bit mask of FFA12 field.
	CAN_FFA1R_FFA12     = 0x1000    // Bit FFA12.
	CAN_FFA1R_FFA13_Pos = 0xd       // Position of FFA13 field.
	CAN_FFA1R_FFA13_Msk = 0x2000    // Bit mask of FFA13 field.
	CAN_FFA1R_FFA13     = 0x2000    // Bit FFA13.
	CAN_FFA1R_FFA14_Pos = 0xe       // Position of FFA14 field.
	CAN_FFA1R_FFA14_Msk = 0x4000    // Bit mask of FFA14 field.
	CAN_FFA1R_FFA14     = 0x4000    // Bit FFA14.
	CAN_FFA1R_FFA15_Pos = 0xf       // Position of FFA15 field.
	CAN_FFA1R_FFA15_Msk = 0x8000    // Bit mask of FFA15 field.
	CAN_FFA1R_FFA15     = 0x8000    // Bit FFA15.
	CAN_FFA1R_FFA16_Pos = 0x10      // Position of FFA16 field.
	CAN_FFA1R_FFA16_Msk = 0x10000   // Bit mask of FFA16 field.
	CAN_FFA1R_FFA16     = 0x10000   // Bit FFA16.
	CAN_FFA1R_FFA17_Pos = 0x11      // Position of FFA17 field.
	CAN_FFA1R_FFA17_Msk = 0x20000   // Bit mask of FFA17 field.
	CAN_FFA1R_FFA17     = 0x20000   // Bit FFA17.
	CAN_FFA1R_FFA18_Pos = 0x12      // Position of FFA18 field.
	CAN_FFA1R_FFA18_Msk = 0x40000   // Bit mask of FFA18 field.
	CAN_FFA1R_FFA18     = 0x40000   // Bit FFA18.
	CAN_FFA1R_FFA19_Pos = 0x13      // Position of FFA19 field.
	CAN_FFA1R_FFA19_Msk = 0x80000   // Bit mask of FFA19 field.
	CAN_FFA1R_FFA19     = 0x80000   // Bit FFA19.
	CAN_FFA1R_FFA20_Pos = 0x14      // Position of FFA20 field.
	CAN_FFA1R_FFA20_Msk = 0x100000  // Bit mask of FFA20 field.
	CAN_FFA1R_FFA20     = 0x100000  // Bit FFA20.
	CAN_FFA1R_FFA21_Pos = 0x15      // Position of FFA21 field.
	CAN_FFA1R_FFA21_Msk = 0x200000  // Bit mask of FFA21 field.
	CAN_FFA1R_FFA21     = 0x200000  // Bit FFA21.
	CAN_FFA1R_FFA22_Pos = 0x16      // Position of FFA22 field.
	CAN_FFA1R_FFA22_Msk = 0x400000  // Bit mask of FFA22 field.
	CAN_FFA1R_FFA22     = 0x400000  // Bit FFA22.
	CAN_FFA1R_FFA23_Pos = 0x17      // Position of FFA23 field.
	CAN_FFA1R_FFA23_Msk = 0x800000  // Bit mask of FFA23 field.
	CAN_FFA1R_FFA23     = 0x800000  // Bit FFA23.
	CAN_FFA1R_FFA24_Pos = 0x18      // Position of FFA24 field.
	CAN_FFA1R_FFA24_Msk = 0x1000000 // Bit mask of FFA24 field.
	CAN_FFA1R_FFA24     = 0x1000000 // Bit FFA24.
	CAN_FFA1R_FFA25_Pos = 0x19      // Position of FFA25 field.
	CAN_FFA1R_FFA25_Msk = 0x2000000 // Bit mask of FFA25 field.
	CAN_FFA1R_FFA25     = 0x2000000 // Bit FFA25.
	CAN_FFA1R_FFA26_Pos = 0x1a      // Position of FFA26 field.
	CAN_FFA1R_FFA26_Msk = 0x4000000 // Bit mask of FFA26 field.
	CAN_FFA1R_FFA26     = 0x4000000 // Bit FFA26.
	CAN_FFA1R_FFA27_Pos = 0x1b      // Position of FFA27 field.
	CAN_FFA1R_FFA27_Msk = 0x8000000 // Bit mask of FFA27 field.
	CAN_FFA1R_FFA27     = 0x8000000 // Bit FFA27.

	// FA1R: filter activation register
	CAN_FA1R_FACT0_Pos  = 0x0       // Position of FACT0 field.
	CAN_FA1R_FACT0_Msk  = 0x1       // Bit mask of FACT0 field.
	CAN_FA1R_FACT0      = 0x1       // Bit FACT0.
	CAN_FA1R_FACT1_Pos  = 0x1       // Position of FACT1 field.
	CAN_FA1R_FACT1_Msk  = 0x2       // Bit mask of FACT1 field.
	CAN_FA1R_FACT1      = 0x2       // Bit FACT1.
	CAN_FA1R_FACT2_Pos  = 0x2       // Position of FACT2 field.
	CAN_FA1R_FACT2_Msk  = 0x4       // Bit mask of FACT2 field.
	CAN_FA1R_FACT2      = 0x4       // Bit FACT2.
	CAN_FA1R_FACT3_Pos  = 0x3       // Position of FACT3 field.
	CAN_FA1R_FACT3_Msk  = 0x8       // Bit mask of FACT3 field.
	CAN_FA1R_FACT3      = 0x8       // Bit FACT3.
	CAN_FA1R_FACT4_Pos  = 0x4       // Position of FACT4 field.
	CAN_FA1R_FACT4_Msk  = 0x10      // Bit mask of FACT4 field.
	CAN_FA1R_FACT4      = 0x10      // Bit FACT4.
	CAN_FA1R_FACT5_Pos  = 0x5       // Position of FACT5 field.
	CAN_FA1R_FACT5_Msk  = 0x20      // Bit mask of FACT5 field.
	CAN_FA1R_FACT5      = 0x20      // Bit FACT5.
	CAN_FA1R_FACT6_Pos  = 0x6       // Position of FACT6 field.
	CAN_FA1R_FACT6_Msk  = 0x40      // Bit mask of FACT6 field.
	CAN_FA1R_FACT6      = 0x40      // Bit FACT6.
	CAN_FA1R_FACT7_Pos  = 0x7       // Position of FACT7 field.
	CAN_FA1R_FACT7_Msk  = 0x80      // Bit mask of FACT7 field.
	CAN_FA1R_FACT7      = 0x80      // Bit FACT7.
	CAN_FA1R_FACT8_Pos  = 0x8       // Position of FACT8 field.
	CAN_FA1R_FACT8_Msk  = 0x100     // Bit mask of FACT8 field.
	CAN_FA1R_FACT8      = 0x100     // Bit FACT8.
	CAN_FA1R_FACT9_Pos  = 0x9       // Position of FACT9 field.
	CAN_FA1R_FACT9_Msk  = 0x200     // Bit mask of FACT9 field.
	CAN_FA1R_FACT9      = 0x200     // Bit FACT9.
	CAN_FA1R_FACT10_Pos = 0xa       // Position of FACT10 field.
	CAN_FA1R_FACT10_Msk = 0x400     // Bit mask of FACT10 field.
	CAN_FA1R_FACT10     = 0x400     // Bit FACT10.
	CAN_FA1R_FACT11_Pos = 0xb       // Position of FACT11 field.
	CAN_FA1R_FACT11_Msk = 0x800     // Bit mask of FACT11 field.
	CAN_FA1R_FACT11     = 0x800     // Bit FACT11.
	CAN_FA1R_FACT12_Pos = 0xc       // Position of FACT12 field.
	CAN_FA1R_FACT12_Msk = 0x1000    // Bit mask of FACT12 field.
	CAN_FA1R_FACT12     = 0x1000    // Bit FACT12.
	CAN_FA1R_FACT13_Pos = 0xd       // Position of FACT13 field.
	CAN_FA1R_FACT13_Msk = 0x2000    // Bit mask of FACT13 field.
	CAN_FA1R_FACT13     = 0x2000    // Bit FACT13.
	CAN_FA1R_FACT14_Pos = 0xe       // Position of FACT14 field.
	CAN_FA1R_FACT14_Msk = 0x4000    // Bit mask of FACT14 field.
	CAN_FA1R_FACT14     = 0x4000    // Bit FACT14.
	CAN_FA1R_FACT15_Pos = 0xf       // Position of FACT15 field.
	CAN_FA1R_FACT15_Msk = 0x8000    // Bit mask of FACT15 field.
	CAN_FA1R_FACT15     = 0x8000    // Bit FACT15.
	CAN_FA1R_FACT16_Pos = 0x10      // Position of FACT16 field.
	CAN_FA1R_FACT16_Msk = 0x10000   // Bit mask of FACT16 field.
	CAN_FA1R_FACT16     = 0x10000   // Bit FACT16.
	CAN_FA1R_FACT17_Pos = 0x11      // Position of FACT17 field.
	CAN_FA1R_FACT17_Msk = 0x20000   // Bit mask of FACT17 field.
	CAN_FA1R_FACT17     = 0x20000   // Bit FACT17.
	CAN_FA1R_FACT18_Pos = 0x12      // Position of FACT18 field.
	CAN_FA1R_FACT18_Msk = 0x40000   // Bit mask of FACT18 field.
	CAN_FA1R_FACT18     = 0x40000   // Bit FACT18.
	CAN_FA1R_FACT19_Pos = 0x13      // Position of FACT19 field.
	CAN_FA1R_FACT19_Msk = 0x80000   // Bit mask of FACT19 field.
	CAN_FA1R_FACT19     = 0x80000   // Bit FACT19.
	CAN_FA1R_FACT20_Pos = 0x14      // Position of FACT20 field.
	CAN_FA1R_FACT20_Msk = 0x100000  // Bit mask of FACT20 field.
	CAN_FA1R_FACT20     = 0x100000  // Bit FACT20.
	CAN_FA1R_FACT21_Pos = 0x15      // Position of FACT21 field.
	CAN_FA1R_FACT21_Msk = 0x200000  // Bit mask of FACT21 field.
	CAN_FA1R_FACT21     = 0x200000  // Bit FACT21.
	CAN_FA1R_FACT22_Pos = 0x16      // Position of FACT22 field.
	CAN_FA1R_FACT22_Msk = 0x400000  // Bit mask of FACT22 field.
	CAN_FA1R_FACT22     = 0x400000  // Bit FACT22.
	CAN_FA1R_FACT23_Pos = 0x17      // Position of FACT23 field.
	CAN_FA1R_FACT23_Msk = 0x800000  // Bit mask of FACT23 field.
	CAN_FA1R_FACT23     = 0x800000  // Bit FACT23.
	CAN_FA1R_FACT24_Pos = 0x18      // Position of FACT24 field.
	CAN_FA1R_FACT24_Msk = 0x1000000 // Bit mask of FACT24 field.
	CAN_FA1R_FACT24     = 0x1000000 // Bit FACT24.
	CAN_FA1R_FACT25_Pos = 0x19      // Position of FACT25 field.
	CAN_FA1R_FACT25_Msk = 0x2000000 // Bit mask of FACT25 field.
	CAN_FA1R_FACT25     = 0x2000000 // Bit FACT25.
	CAN_FA1R_FACT26_Pos = 0x1a      // Position of FACT26 field.
	CAN_FA1R_FACT26_Msk = 0x4000000 // Bit mask of FACT26 field.
	CAN_FA1R_FACT26     = 0x4000000 // Bit FACT26.
	CAN_FA1R_FACT27_Pos = 0x1b      // Position of FACT27 field.
	CAN_FA1R_FACT27_Msk = 0x8000000 // Bit mask of FACT27 field.
	CAN_FA1R_FACT27     = 0x8000000 // Bit FACT27.

	// F0R1: Filter bank 0 register 1
	CAN_F0R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F0R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F0R1_FB0      = 0x1        // Bit FB0.
	CAN_F0R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F0R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F0R1_FB1      = 0x2        // Bit FB1.
	CAN_F0R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F0R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F0R1_FB2      = 0x4        // Bit FB2.
	CAN_F0R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F0R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F0R1_FB3      = 0x8        // Bit FB3.
	CAN_F0R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F0R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F0R1_FB4      = 0x10       // Bit FB4.
	CAN_F0R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F0R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F0R1_FB5      = 0x20       // Bit FB5.
	CAN_F0R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F0R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F0R1_FB6      = 0x40       // Bit FB6.
	CAN_F0R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F0R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F0R1_FB7      = 0x80       // Bit FB7.
	CAN_F0R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F0R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F0R1_FB8      = 0x100      // Bit FB8.
	CAN_F0R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F0R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F0R1_FB9      = 0x200      // Bit FB9.
	CAN_F0R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F0R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F0R1_FB10     = 0x400      // Bit FB10.
	CAN_F0R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F0R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F0R1_FB11     = 0x800      // Bit FB11.
	CAN_F0R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F0R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F0R1_FB12     = 0x1000     // Bit FB12.
	CAN_F0R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F0R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F0R1_FB13     = 0x2000     // Bit FB13.
	CAN_F0R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F0R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F0R1_FB14     = 0x4000     // Bit FB14.
	CAN_F0R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F0R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F0R1_FB15     = 0x8000     // Bit FB15.
	CAN_F0R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F0R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F0R1_FB16     = 0x10000    // Bit FB16.
	CAN_F0R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F0R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F0R1_FB17     = 0x20000    // Bit FB17.
	CAN_F0R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F0R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F0R1_FB18     = 0x40000    // Bit FB18.
	CAN_F0R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F0R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F0R1_FB19     = 0x80000    // Bit FB19.
	CAN_F0R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F0R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F0R1_FB20     = 0x100000   // Bit FB20.
	CAN_F0R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F0R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F0R1_FB21     = 0x200000   // Bit FB21.
	CAN_F0R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F0R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F0R1_FB22     = 0x400000   // Bit FB22.
	CAN_F0R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F0R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F0R1_FB23     = 0x800000   // Bit FB23.
	CAN_F0R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F0R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F0R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F0R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F0R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F0R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F0R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F0R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F0R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F0R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F0R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F0R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F0R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F0R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F0R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F0R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F0R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F0R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F0R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F0R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F0R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F0R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F0R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F0R1_FB31     = 0x80000000 // Bit FB31.

	// F0R2: Filter bank 0 register 2
	CAN_F0R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F0R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F0R2_FB0      = 0x1        // Bit FB0.
	CAN_F0R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F0R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F0R2_FB1      = 0x2        // Bit FB1.
	CAN_F0R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F0R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F0R2_FB2      = 0x4        // Bit FB2.
	CAN_F0R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F0R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F0R2_FB3      = 0x8        // Bit FB3.
	CAN_F0R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F0R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F0R2_FB4      = 0x10       // Bit FB4.
	CAN_F0R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F0R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F0R2_FB5      = 0x20       // Bit FB5.
	CAN_F0R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F0R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F0R2_FB6      = 0x40       // Bit FB6.
	CAN_F0R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F0R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F0R2_FB7      = 0x80       // Bit FB7.
	CAN_F0R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F0R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F0R2_FB8      = 0x100      // Bit FB8.
	CAN_F0R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F0R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F0R2_FB9      = 0x200      // Bit FB9.
	CAN_F0R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F0R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F0R2_FB10     = 0x400      // Bit FB10.
	CAN_F0R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F0R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F0R2_FB11     = 0x800      // Bit FB11.
	CAN_F0R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F0R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F0R2_FB12     = 0x1000     // Bit FB12.
	CAN_F0R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F0R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F0R2_FB13     = 0x2000     // Bit FB13.
	CAN_F0R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F0R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F0R2_FB14     = 0x4000     // Bit FB14.
	CAN_F0R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F0R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F0R2_FB15     = 0x8000     // Bit FB15.
	CAN_F0R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F0R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F0R2_FB16     = 0x10000    // Bit FB16.
	CAN_F0R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F0R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F0R2_FB17     = 0x20000    // Bit FB17.
	CAN_F0R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F0R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F0R2_FB18     = 0x40000    // Bit FB18.
	CAN_F0R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F0R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F0R2_FB19     = 0x80000    // Bit FB19.
	CAN_F0R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F0R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F0R2_FB20     = 0x100000   // Bit FB20.
	CAN_F0R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F0R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F0R2_FB21     = 0x200000   // Bit FB21.
	CAN_F0R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F0R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F0R2_FB22     = 0x400000   // Bit FB22.
	CAN_F0R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F0R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F0R2_FB23     = 0x800000   // Bit FB23.
	CAN_F0R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F0R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F0R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F0R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F0R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F0R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F0R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F0R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F0R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F0R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F0R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F0R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F0R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F0R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F0R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F0R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F0R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F0R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F0R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F0R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F0R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F0R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F0R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F0R2_FB31     = 0x80000000 // Bit FB31.

	// F1R1: Filter bank 1 register 1
	CAN_F1R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F1R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F1R1_FB0      = 0x1        // Bit FB0.
	CAN_F1R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F1R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F1R1_FB1      = 0x2        // Bit FB1.
	CAN_F1R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F1R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F1R1_FB2      = 0x4        // Bit FB2.
	CAN_F1R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F1R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F1R1_FB3      = 0x8        // Bit FB3.
	CAN_F1R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F1R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F1R1_FB4      = 0x10       // Bit FB4.
	CAN_F1R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F1R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F1R1_FB5      = 0x20       // Bit FB5.
	CAN_F1R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F1R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F1R1_FB6      = 0x40       // Bit FB6.
	CAN_F1R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F1R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F1R1_FB7      = 0x80       // Bit FB7.
	CAN_F1R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F1R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F1R1_FB8      = 0x100      // Bit FB8.
	CAN_F1R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F1R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F1R1_FB9      = 0x200      // Bit FB9.
	CAN_F1R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F1R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F1R1_FB10     = 0x400      // Bit FB10.
	CAN_F1R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F1R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F1R1_FB11     = 0x800      // Bit FB11.
	CAN_F1R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F1R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F1R1_FB12     = 0x1000     // Bit FB12.
	CAN_F1R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F1R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F1R1_FB13     = 0x2000     // Bit FB13.
	CAN_F1R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F1R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F1R1_FB14     = 0x4000     // Bit FB14.
	CAN_F1R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F1R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F1R1_FB15     = 0x8000     // Bit FB15.
	CAN_F1R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F1R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F1R1_FB16     = 0x10000    // Bit FB16.
	CAN_F1R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F1R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F1R1_FB17     = 0x20000    // Bit FB17.
	CAN_F1R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F1R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F1R1_FB18     = 0x40000    // Bit FB18.
	CAN_F1R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F1R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F1R1_FB19     = 0x80000    // Bit FB19.
	CAN_F1R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F1R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F1R1_FB20     = 0x100000   // Bit FB20.
	CAN_F1R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F1R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F1R1_FB21     = 0x200000   // Bit FB21.
	CAN_F1R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F1R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F1R1_FB22     = 0x400000   // Bit FB22.
	CAN_F1R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F1R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F1R1_FB23     = 0x800000   // Bit FB23.
	CAN_F1R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F1R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F1R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F1R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F1R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F1R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F1R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F1R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F1R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F1R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F1R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F1R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F1R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F1R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F1R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F1R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F1R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F1R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F1R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F1R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F1R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F1R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F1R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F1R1_FB31     = 0x80000000 // Bit FB31.

	// F1R2: Filter bank 1 register 2
	CAN_F1R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F1R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F1R2_FB0      = 0x1        // Bit FB0.
	CAN_F1R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F1R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F1R2_FB1      = 0x2        // Bit FB1.
	CAN_F1R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F1R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F1R2_FB2      = 0x4        // Bit FB2.
	CAN_F1R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F1R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F1R2_FB3      = 0x8        // Bit FB3.
	CAN_F1R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F1R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F1R2_FB4      = 0x10       // Bit FB4.
	CAN_F1R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F1R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F1R2_FB5      = 0x20       // Bit FB5.
	CAN_F1R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F1R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F1R2_FB6      = 0x40       // Bit FB6.
	CAN_F1R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F1R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F1R2_FB7      = 0x80       // Bit FB7.
	CAN_F1R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F1R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F1R2_FB8      = 0x100      // Bit FB8.
	CAN_F1R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F1R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F1R2_FB9      = 0x200      // Bit FB9.
	CAN_F1R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F1R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F1R2_FB10     = 0x400      // Bit FB10.
	CAN_F1R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F1R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F1R2_FB11     = 0x800      // Bit FB11.
	CAN_F1R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F1R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F1R2_FB12     = 0x1000     // Bit FB12.
	CAN_F1R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F1R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F1R2_FB13     = 0x2000     // Bit FB13.
	CAN_F1R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F1R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F1R2_FB14     = 0x4000     // Bit FB14.
	CAN_F1R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F1R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F1R2_FB15     = 0x8000     // Bit FB15.
	CAN_F1R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F1R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F1R2_FB16     = 0x10000    // Bit FB16.
	CAN_F1R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F1R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F1R2_FB17     = 0x20000    // Bit FB17.
	CAN_F1R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F1R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F1R2_FB18     = 0x40000    // Bit FB18.
	CAN_F1R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F1R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F1R2_FB19     = 0x80000    // Bit FB19.
	CAN_F1R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F1R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F1R2_FB20     = 0x100000   // Bit FB20.
	CAN_F1R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F1R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F1R2_FB21     = 0x200000   // Bit FB21.
	CAN_F1R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F1R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F1R2_FB22     = 0x400000   // Bit FB22.
	CAN_F1R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F1R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F1R2_FB23     = 0x800000   // Bit FB23.
	CAN_F1R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F1R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F1R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F1R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F1R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F1R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F1R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F1R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F1R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F1R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F1R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F1R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F1R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F1R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F1R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F1R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F1R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F1R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F1R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F1R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F1R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F1R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F1R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F1R2_FB31     = 0x80000000 // Bit FB31.

	// F2R1: Filter bank 2 register 1
	CAN_F2R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F2R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F2R1_FB0      = 0x1        // Bit FB0.
	CAN_F2R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F2R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F2R1_FB1      = 0x2        // Bit FB1.
	CAN_F2R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F2R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F2R1_FB2      = 0x4        // Bit FB2.
	CAN_F2R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F2R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F2R1_FB3      = 0x8        // Bit FB3.
	CAN_F2R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F2R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F2R1_FB4      = 0x10       // Bit FB4.
	CAN_F2R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F2R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F2R1_FB5      = 0x20       // Bit FB5.
	CAN_F2R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F2R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F2R1_FB6      = 0x40       // Bit FB6.
	CAN_F2R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F2R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F2R1_FB7      = 0x80       // Bit FB7.
	CAN_F2R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F2R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F2R1_FB8      = 0x100      // Bit FB8.
	CAN_F2R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F2R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F2R1_FB9      = 0x200      // Bit FB9.
	CAN_F2R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F2R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F2R1_FB10     = 0x400      // Bit FB10.
	CAN_F2R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F2R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F2R1_FB11     = 0x800      // Bit FB11.
	CAN_F2R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F2R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F2R1_FB12     = 0x1000     // Bit FB12.
	CAN_F2R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F2R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F2R1_FB13     = 0x2000     // Bit FB13.
	CAN_F2R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F2R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F2R1_FB14     = 0x4000     // Bit FB14.
	CAN_F2R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F2R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F2R1_FB15     = 0x8000     // Bit FB15.
	CAN_F2R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F2R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F2R1_FB16     = 0x10000    // Bit FB16.
	CAN_F2R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F2R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F2R1_FB17     = 0x20000    // Bit FB17.
	CAN_F2R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F2R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F2R1_FB18     = 0x40000    // Bit FB18.
	CAN_F2R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F2R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F2R1_FB19     = 0x80000    // Bit FB19.
	CAN_F2R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F2R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F2R1_FB20     = 0x100000   // Bit FB20.
	CAN_F2R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F2R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F2R1_FB21     = 0x200000   // Bit FB21.
	CAN_F2R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F2R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F2R1_FB22     = 0x400000   // Bit FB22.
	CAN_F2R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F2R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F2R1_FB23     = 0x800000   // Bit FB23.
	CAN_F2R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F2R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F2R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F2R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F2R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F2R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F2R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F2R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F2R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F2R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F2R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F2R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F2R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F2R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F2R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F2R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F2R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F2R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F2R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F2R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F2R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F2R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F2R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F2R1_FB31     = 0x80000000 // Bit FB31.

	// F2R2: Filter bank 2 register 2
	CAN_F2R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F2R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F2R2_FB0      = 0x1        // Bit FB0.
	CAN_F2R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F2R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F2R2_FB1      = 0x2        // Bit FB1.
	CAN_F2R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F2R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F2R2_FB2      = 0x4        // Bit FB2.
	CAN_F2R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F2R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F2R2_FB3      = 0x8        // Bit FB3.
	CAN_F2R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F2R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F2R2_FB4      = 0x10       // Bit FB4.
	CAN_F2R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F2R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F2R2_FB5      = 0x20       // Bit FB5.
	CAN_F2R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F2R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F2R2_FB6      = 0x40       // Bit FB6.
	CAN_F2R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F2R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F2R2_FB7      = 0x80       // Bit FB7.
	CAN_F2R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F2R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F2R2_FB8      = 0x100      // Bit FB8.
	CAN_F2R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F2R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F2R2_FB9      = 0x200      // Bit FB9.
	CAN_F2R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F2R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F2R2_FB10     = 0x400      // Bit FB10.
	CAN_F2R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F2R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F2R2_FB11     = 0x800      // Bit FB11.
	CAN_F2R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F2R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F2R2_FB12     = 0x1000     // Bit FB12.
	CAN_F2R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F2R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F2R2_FB13     = 0x2000     // Bit FB13.
	CAN_F2R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F2R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F2R2_FB14     = 0x4000     // Bit FB14.
	CAN_F2R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F2R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F2R2_FB15     = 0x8000     // Bit FB15.
	CAN_F2R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F2R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F2R2_FB16     = 0x10000    // Bit FB16.
	CAN_F2R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F2R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F2R2_FB17     = 0x20000    // Bit FB17.
	CAN_F2R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F2R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F2R2_FB18     = 0x40000    // Bit FB18.
	CAN_F2R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F2R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F2R2_FB19     = 0x80000    // Bit FB19.
	CAN_F2R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F2R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F2R2_FB20     = 0x100000   // Bit FB20.
	CAN_F2R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F2R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F2R2_FB21     = 0x200000   // Bit FB21.
	CAN_F2R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F2R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F2R2_FB22     = 0x400000   // Bit FB22.
	CAN_F2R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F2R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F2R2_FB23     = 0x800000   // Bit FB23.
	CAN_F2R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F2R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F2R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F2R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F2R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F2R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F2R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F2R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F2R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F2R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F2R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F2R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F2R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F2R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F2R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F2R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F2R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F2R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F2R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F2R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F2R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F2R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F2R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F2R2_FB31     = 0x80000000 // Bit FB31.

	// F3R1: Filter bank 3 register 1
	CAN_F3R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F3R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F3R1_FB0      = 0x1        // Bit FB0.
	CAN_F3R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F3R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F3R1_FB1      = 0x2        // Bit FB1.
	CAN_F3R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F3R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F3R1_FB2      = 0x4        // Bit FB2.
	CAN_F3R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F3R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F3R1_FB3      = 0x8        // Bit FB3.
	CAN_F3R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F3R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F3R1_FB4      = 0x10       // Bit FB4.
	CAN_F3R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F3R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F3R1_FB5      = 0x20       // Bit FB5.
	CAN_F3R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F3R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F3R1_FB6      = 0x40       // Bit FB6.
	CAN_F3R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F3R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F3R1_FB7      = 0x80       // Bit FB7.
	CAN_F3R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F3R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F3R1_FB8      = 0x100      // Bit FB8.
	CAN_F3R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F3R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F3R1_FB9      = 0x200      // Bit FB9.
	CAN_F3R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F3R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F3R1_FB10     = 0x400      // Bit FB10.
	CAN_F3R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F3R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F3R1_FB11     = 0x800      // Bit FB11.
	CAN_F3R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F3R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F3R1_FB12     = 0x1000     // Bit FB12.
	CAN_F3R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F3R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F3R1_FB13     = 0x2000     // Bit FB13.
	CAN_F3R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F3R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F3R1_FB14     = 0x4000     // Bit FB14.
	CAN_F3R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F3R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F3R1_FB15     = 0x8000     // Bit FB15.
	CAN_F3R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F3R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F3R1_FB16     = 0x10000    // Bit FB16.
	CAN_F3R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F3R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F3R1_FB17     = 0x20000    // Bit FB17.
	CAN_F3R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F3R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F3R1_FB18     = 0x40000    // Bit FB18.
	CAN_F3R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F3R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F3R1_FB19     = 0x80000    // Bit FB19.
	CAN_F3R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F3R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F3R1_FB20     = 0x100000   // Bit FB20.
	CAN_F3R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F3R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F3R1_FB21     = 0x200000   // Bit FB21.
	CAN_F3R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F3R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F3R1_FB22     = 0x400000   // Bit FB22.
	CAN_F3R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F3R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F3R1_FB23     = 0x800000   // Bit FB23.
	CAN_F3R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F3R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F3R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F3R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F3R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F3R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F3R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F3R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F3R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F3R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F3R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F3R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F3R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F3R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F3R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F3R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F3R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F3R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F3R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F3R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F3R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F3R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F3R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F3R1_FB31     = 0x80000000 // Bit FB31.

	// F3R2: Filter bank 3 register 2
	CAN_F3R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F3R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F3R2_FB0      = 0x1        // Bit FB0.
	CAN_F3R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F3R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F3R2_FB1      = 0x2        // Bit FB1.
	CAN_F3R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F3R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F3R2_FB2      = 0x4        // Bit FB2.
	CAN_F3R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F3R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F3R2_FB3      = 0x8        // Bit FB3.
	CAN_F3R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F3R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F3R2_FB4      = 0x10       // Bit FB4.
	CAN_F3R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F3R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F3R2_FB5      = 0x20       // Bit FB5.
	CAN_F3R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F3R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F3R2_FB6      = 0x40       // Bit FB6.
	CAN_F3R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F3R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F3R2_FB7      = 0x80       // Bit FB7.
	CAN_F3R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F3R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F3R2_FB8      = 0x100      // Bit FB8.
	CAN_F3R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F3R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F3R2_FB9      = 0x200      // Bit FB9.
	CAN_F3R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F3R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F3R2_FB10     = 0x400      // Bit FB10.
	CAN_F3R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F3R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F3R2_FB11     = 0x800      // Bit FB11.
	CAN_F3R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F3R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F3R2_FB12     = 0x1000     // Bit FB12.
	CAN_F3R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F3R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F3R2_FB13     = 0x2000     // Bit FB13.
	CAN_F3R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F3R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F3R2_FB14     = 0x4000     // Bit FB14.
	CAN_F3R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F3R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F3R2_FB15     = 0x8000     // Bit FB15.
	CAN_F3R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F3R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F3R2_FB16     = 0x10000    // Bit FB16.
	CAN_F3R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F3R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F3R2_FB17     = 0x20000    // Bit FB17.
	CAN_F3R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F3R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F3R2_FB18     = 0x40000    // Bit FB18.
	CAN_F3R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F3R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F3R2_FB19     = 0x80000    // Bit FB19.
	CAN_F3R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F3R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F3R2_FB20     = 0x100000   // Bit FB20.
	CAN_F3R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F3R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F3R2_FB21     = 0x200000   // Bit FB21.
	CAN_F3R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F3R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F3R2_FB22     = 0x400000   // Bit FB22.
	CAN_F3R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F3R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F3R2_FB23     = 0x800000   // Bit FB23.
	CAN_F3R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F3R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F3R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F3R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F3R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F3R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F3R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F3R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F3R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F3R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F3R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F3R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F3R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F3R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F3R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F3R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F3R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F3R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F3R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F3R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F3R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F3R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F3R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F3R2_FB31     = 0x80000000 // Bit FB31.

	// F4R1: Filter bank 4 register 1
	CAN_F4R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F4R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F4R1_FB0      = 0x1        // Bit FB0.
	CAN_F4R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F4R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F4R1_FB1      = 0x2        // Bit FB1.
	CAN_F4R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F4R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F4R1_FB2      = 0x4        // Bit FB2.
	CAN_F4R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F4R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F4R1_FB3      = 0x8        // Bit FB3.
	CAN_F4R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F4R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F4R1_FB4      = 0x10       // Bit FB4.
	CAN_F4R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F4R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F4R1_FB5      = 0x20       // Bit FB5.
	CAN_F4R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F4R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F4R1_FB6      = 0x40       // Bit FB6.
	CAN_F4R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F4R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F4R1_FB7      = 0x80       // Bit FB7.
	CAN_F4R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F4R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F4R1_FB8      = 0x100      // Bit FB8.
	CAN_F4R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F4R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F4R1_FB9      = 0x200      // Bit FB9.
	CAN_F4R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F4R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F4R1_FB10     = 0x400      // Bit FB10.
	CAN_F4R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F4R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F4R1_FB11     = 0x800      // Bit FB11.
	CAN_F4R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F4R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F4R1_FB12     = 0x1000     // Bit FB12.
	CAN_F4R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F4R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F4R1_FB13     = 0x2000     // Bit FB13.
	CAN_F4R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F4R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F4R1_FB14     = 0x4000     // Bit FB14.
	CAN_F4R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F4R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F4R1_FB15     = 0x8000     // Bit FB15.
	CAN_F4R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F4R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F4R1_FB16     = 0x10000    // Bit FB16.
	CAN_F4R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F4R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F4R1_FB17     = 0x20000    // Bit FB17.
	CAN_F4R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F4R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F4R1_FB18     = 0x40000    // Bit FB18.
	CAN_F4R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F4R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F4R1_FB19     = 0x80000    // Bit FB19.
	CAN_F4R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F4R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F4R1_FB20     = 0x100000   // Bit FB20.
	CAN_F4R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F4R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F4R1_FB21     = 0x200000   // Bit FB21.
	CAN_F4R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F4R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F4R1_FB22     = 0x400000   // Bit FB22.
	CAN_F4R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F4R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F4R1_FB23     = 0x800000   // Bit FB23.
	CAN_F4R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F4R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F4R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F4R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F4R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F4R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F4R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F4R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F4R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F4R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F4R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F4R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F4R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F4R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F4R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F4R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F4R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F4R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F4R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F4R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F4R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F4R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F4R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F4R1_FB31     = 0x80000000 // Bit FB31.

	// F4R2: Filter bank 4 register 2
	CAN_F4R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F4R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F4R2_FB0      = 0x1        // Bit FB0.
	CAN_F4R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F4R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F4R2_FB1      = 0x2        // Bit FB1.
	CAN_F4R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F4R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F4R2_FB2      = 0x4        // Bit FB2.
	CAN_F4R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F4R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F4R2_FB3      = 0x8        // Bit FB3.
	CAN_F4R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F4R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F4R2_FB4      = 0x10       // Bit FB4.
	CAN_F4R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F4R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F4R2_FB5      = 0x20       // Bit FB5.
	CAN_F4R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F4R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F4R2_FB6      = 0x40       // Bit FB6.
	CAN_F4R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F4R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F4R2_FB7      = 0x80       // Bit FB7.
	CAN_F4R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F4R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F4R2_FB8      = 0x100      // Bit FB8.
	CAN_F4R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F4R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F4R2_FB9      = 0x200      // Bit FB9.
	CAN_F4R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F4R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F4R2_FB10     = 0x400      // Bit FB10.
	CAN_F4R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F4R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F4R2_FB11     = 0x800      // Bit FB11.
	CAN_F4R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F4R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F4R2_FB12     = 0x1000     // Bit FB12.
	CAN_F4R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F4R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F4R2_FB13     = 0x2000     // Bit FB13.
	CAN_F4R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F4R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F4R2_FB14     = 0x4000     // Bit FB14.
	CAN_F4R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F4R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F4R2_FB15     = 0x8000     // Bit FB15.
	CAN_F4R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F4R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F4R2_FB16     = 0x10000    // Bit FB16.
	CAN_F4R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F4R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F4R2_FB17     = 0x20000    // Bit FB17.
	CAN_F4R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F4R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F4R2_FB18     = 0x40000    // Bit FB18.
	CAN_F4R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F4R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F4R2_FB19     = 0x80000    // Bit FB19.
	CAN_F4R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F4R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F4R2_FB20     = 0x100000   // Bit FB20.
	CAN_F4R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F4R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F4R2_FB21     = 0x200000   // Bit FB21.
	CAN_F4R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F4R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F4R2_FB22     = 0x400000   // Bit FB22.
	CAN_F4R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F4R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F4R2_FB23     = 0x800000   // Bit FB23.
	CAN_F4R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F4R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F4R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F4R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F4R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F4R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F4R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F4R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F4R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F4R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F4R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F4R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F4R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F4R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F4R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F4R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F4R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F4R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F4R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F4R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F4R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F4R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F4R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F4R2_FB31     = 0x80000000 // Bit FB31.

	// F5R1: Filter bank 5 register 1
	CAN_F5R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F5R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F5R1_FB0      = 0x1        // Bit FB0.
	CAN_F5R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F5R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F5R1_FB1      = 0x2        // Bit FB1.
	CAN_F5R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F5R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F5R1_FB2      = 0x4        // Bit FB2.
	CAN_F5R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F5R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F5R1_FB3      = 0x8        // Bit FB3.
	CAN_F5R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F5R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F5R1_FB4      = 0x10       // Bit FB4.
	CAN_F5R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F5R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F5R1_FB5      = 0x20       // Bit FB5.
	CAN_F5R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F5R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F5R1_FB6      = 0x40       // Bit FB6.
	CAN_F5R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F5R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F5R1_FB7      = 0x80       // Bit FB7.
	CAN_F5R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F5R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F5R1_FB8      = 0x100      // Bit FB8.
	CAN_F5R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F5R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F5R1_FB9      = 0x200      // Bit FB9.
	CAN_F5R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F5R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F5R1_FB10     = 0x400      // Bit FB10.
	CAN_F5R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F5R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F5R1_FB11     = 0x800      // Bit FB11.
	CAN_F5R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F5R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F5R1_FB12     = 0x1000     // Bit FB12.
	CAN_F5R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F5R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F5R1_FB13     = 0x2000     // Bit FB13.
	CAN_F5R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F5R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F5R1_FB14     = 0x4000     // Bit FB14.
	CAN_F5R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F5R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F5R1_FB15     = 0x8000     // Bit FB15.
	CAN_F5R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F5R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F5R1_FB16     = 0x10000    // Bit FB16.
	CAN_F5R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F5R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F5R1_FB17     = 0x20000    // Bit FB17.
	CAN_F5R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F5R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F5R1_FB18     = 0x40000    // Bit FB18.
	CAN_F5R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F5R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F5R1_FB19     = 0x80000    // Bit FB19.
	CAN_F5R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F5R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F5R1_FB20     = 0x100000   // Bit FB20.
	CAN_F5R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F5R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F5R1_FB21     = 0x200000   // Bit FB21.
	CAN_F5R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F5R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F5R1_FB22     = 0x400000   // Bit FB22.
	CAN_F5R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F5R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F5R1_FB23     = 0x800000   // Bit FB23.
	CAN_F5R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F5R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F5R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F5R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F5R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F5R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F5R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F5R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F5R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F5R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F5R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F5R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F5R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F5R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F5R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F5R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F5R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F5R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F5R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F5R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F5R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F5R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F5R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F5R1_FB31     = 0x80000000 // Bit FB31.

	// F5R2: Filter bank 5 register 2
	CAN_F5R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F5R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F5R2_FB0      = 0x1        // Bit FB0.
	CAN_F5R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F5R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F5R2_FB1      = 0x2        // Bit FB1.
	CAN_F5R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F5R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F5R2_FB2      = 0x4        // Bit FB2.
	CAN_F5R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F5R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F5R2_FB3      = 0x8        // Bit FB3.
	CAN_F5R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F5R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F5R2_FB4      = 0x10       // Bit FB4.
	CAN_F5R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F5R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F5R2_FB5      = 0x20       // Bit FB5.
	CAN_F5R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F5R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F5R2_FB6      = 0x40       // Bit FB6.
	CAN_F5R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F5R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F5R2_FB7      = 0x80       // Bit FB7.
	CAN_F5R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F5R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F5R2_FB8      = 0x100      // Bit FB8.
	CAN_F5R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F5R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F5R2_FB9      = 0x200      // Bit FB9.
	CAN_F5R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F5R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F5R2_FB10     = 0x400      // Bit FB10.
	CAN_F5R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F5R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F5R2_FB11     = 0x800      // Bit FB11.
	CAN_F5R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F5R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F5R2_FB12     = 0x1000     // Bit FB12.
	CAN_F5R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F5R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F5R2_FB13     = 0x2000     // Bit FB13.
	CAN_F5R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F5R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F5R2_FB14     = 0x4000     // Bit FB14.
	CAN_F5R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F5R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F5R2_FB15     = 0x8000     // Bit FB15.
	CAN_F5R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F5R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F5R2_FB16     = 0x10000    // Bit FB16.
	CAN_F5R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F5R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F5R2_FB17     = 0x20000    // Bit FB17.
	CAN_F5R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F5R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F5R2_FB18     = 0x40000    // Bit FB18.
	CAN_F5R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F5R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F5R2_FB19     = 0x80000    // Bit FB19.
	CAN_F5R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F5R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F5R2_FB20     = 0x100000   // Bit FB20.
	CAN_F5R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F5R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F5R2_FB21     = 0x200000   // Bit FB21.
	CAN_F5R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F5R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F5R2_FB22     = 0x400000   // Bit FB22.
	CAN_F5R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F5R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F5R2_FB23     = 0x800000   // Bit FB23.
	CAN_F5R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F5R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F5R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F5R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F5R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F5R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F5R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F5R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F5R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F5R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F5R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F5R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F5R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F5R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F5R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F5R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F5R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F5R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F5R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F5R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F5R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F5R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F5R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F5R2_FB31     = 0x80000000 // Bit FB31.

	// F6R1: Filter bank 6 register 1
	CAN_F6R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F6R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F6R1_FB0      = 0x1        // Bit FB0.
	CAN_F6R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F6R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F6R1_FB1      = 0x2        // Bit FB1.
	CAN_F6R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F6R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F6R1_FB2      = 0x4        // Bit FB2.
	CAN_F6R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F6R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F6R1_FB3      = 0x8        // Bit FB3.
	CAN_F6R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F6R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F6R1_FB4      = 0x10       // Bit FB4.
	CAN_F6R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F6R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F6R1_FB5      = 0x20       // Bit FB5.
	CAN_F6R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F6R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F6R1_FB6      = 0x40       // Bit FB6.
	CAN_F6R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F6R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F6R1_FB7      = 0x80       // Bit FB7.
	CAN_F6R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F6R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F6R1_FB8      = 0x100      // Bit FB8.
	CAN_F6R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F6R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F6R1_FB9      = 0x200      // Bit FB9.
	CAN_F6R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F6R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F6R1_FB10     = 0x400      // Bit FB10.
	CAN_F6R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F6R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F6R1_FB11     = 0x800      // Bit FB11.
	CAN_F6R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F6R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F6R1_FB12     = 0x1000     // Bit FB12.
	CAN_F6R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F6R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F6R1_FB13     = 0x2000     // Bit FB13.
	CAN_F6R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F6R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F6R1_FB14     = 0x4000     // Bit FB14.
	CAN_F6R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F6R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F6R1_FB15     = 0x8000     // Bit FB15.
	CAN_F6R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F6R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F6R1_FB16     = 0x10000    // Bit FB16.
	CAN_F6R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F6R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F6R1_FB17     = 0x20000    // Bit FB17.
	CAN_F6R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F6R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F6R1_FB18     = 0x40000    // Bit FB18.
	CAN_F6R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F6R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F6R1_FB19     = 0x80000    // Bit FB19.
	CAN_F6R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F6R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F6R1_FB20     = 0x100000   // Bit FB20.
	CAN_F6R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F6R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F6R1_FB21     = 0x200000   // Bit FB21.
	CAN_F6R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F6R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F6R1_FB22     = 0x400000   // Bit FB22.
	CAN_F6R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F6R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F6R1_FB23     = 0x800000   // Bit FB23.
	CAN_F6R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F6R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F6R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F6R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F6R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F6R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F6R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F6R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F6R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F6R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F6R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F6R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F6R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F6R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F6R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F6R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F6R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F6R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F6R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F6R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F6R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F6R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F6R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F6R1_FB31     = 0x80000000 // Bit FB31.

	// F6R2: Filter bank 6 register 2
	CAN_F6R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F6R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F6R2_FB0      = 0x1        // Bit FB0.
	CAN_F6R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F6R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F6R2_FB1      = 0x2        // Bit FB1.
	CAN_F6R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F6R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F6R2_FB2      = 0x4        // Bit FB2.
	CAN_F6R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F6R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F6R2_FB3      = 0x8        // Bit FB3.
	CAN_F6R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F6R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F6R2_FB4      = 0x10       // Bit FB4.
	CAN_F6R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F6R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F6R2_FB5      = 0x20       // Bit FB5.
	CAN_F6R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F6R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F6R2_FB6      = 0x40       // Bit FB6.
	CAN_F6R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F6R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F6R2_FB7      = 0x80       // Bit FB7.
	CAN_F6R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F6R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F6R2_FB8      = 0x100      // Bit FB8.
	CAN_F6R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F6R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F6R2_FB9      = 0x200      // Bit FB9.
	CAN_F6R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F6R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F6R2_FB10     = 0x400      // Bit FB10.
	CAN_F6R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F6R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F6R2_FB11     = 0x800      // Bit FB11.
	CAN_F6R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F6R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F6R2_FB12     = 0x1000     // Bit FB12.
	CAN_F6R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F6R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F6R2_FB13     = 0x2000     // Bit FB13.
	CAN_F6R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F6R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F6R2_FB14     = 0x4000     // Bit FB14.
	CAN_F6R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F6R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F6R2_FB15     = 0x8000     // Bit FB15.
	CAN_F6R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F6R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F6R2_FB16     = 0x10000    // Bit FB16.
	CAN_F6R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F6R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F6R2_FB17     = 0x20000    // Bit FB17.
	CAN_F6R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F6R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F6R2_FB18     = 0x40000    // Bit FB18.
	CAN_F6R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F6R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F6R2_FB19     = 0x80000    // Bit FB19.
	CAN_F6R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F6R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F6R2_FB20     = 0x100000   // Bit FB20.
	CAN_F6R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F6R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F6R2_FB21     = 0x200000   // Bit FB21.
	CAN_F6R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F6R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F6R2_FB22     = 0x400000   // Bit FB22.
	CAN_F6R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F6R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F6R2_FB23     = 0x800000   // Bit FB23.
	CAN_F6R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F6R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F6R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F6R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F6R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F6R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F6R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F6R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F6R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F6R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F6R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F6R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F6R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F6R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F6R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F6R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F6R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F6R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F6R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F6R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F6R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F6R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F6R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F6R2_FB31     = 0x80000000 // Bit FB31.

	// F7R1: Filter bank 7 register 1
	CAN_F7R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F7R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F7R1_FB0      = 0x1        // Bit FB0.
	CAN_F7R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F7R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F7R1_FB1      = 0x2        // Bit FB1.
	CAN_F7R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F7R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F7R1_FB2      = 0x4        // Bit FB2.
	CAN_F7R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F7R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F7R1_FB3      = 0x8        // Bit FB3.
	CAN_F7R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F7R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F7R1_FB4      = 0x10       // Bit FB4.
	CAN_F7R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F7R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F7R1_FB5      = 0x20       // Bit FB5.
	CAN_F7R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F7R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F7R1_FB6      = 0x40       // Bit FB6.
	CAN_F7R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F7R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F7R1_FB7      = 0x80       // Bit FB7.
	CAN_F7R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F7R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F7R1_FB8      = 0x100      // Bit FB8.
	CAN_F7R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F7R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F7R1_FB9      = 0x200      // Bit FB9.
	CAN_F7R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F7R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F7R1_FB10     = 0x400      // Bit FB10.
	CAN_F7R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F7R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F7R1_FB11     = 0x800      // Bit FB11.
	CAN_F7R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F7R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F7R1_FB12     = 0x1000     // Bit FB12.
	CAN_F7R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F7R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F7R1_FB13     = 0x2000     // Bit FB13.
	CAN_F7R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F7R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F7R1_FB14     = 0x4000     // Bit FB14.
	CAN_F7R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F7R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F7R1_FB15     = 0x8000     // Bit FB15.
	CAN_F7R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F7R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F7R1_FB16     = 0x10000    // Bit FB16.
	CAN_F7R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F7R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F7R1_FB17     = 0x20000    // Bit FB17.
	CAN_F7R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F7R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F7R1_FB18     = 0x40000    // Bit FB18.
	CAN_F7R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F7R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F7R1_FB19     = 0x80000    // Bit FB19.
	CAN_F7R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F7R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F7R1_FB20     = 0x100000   // Bit FB20.
	CAN_F7R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F7R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F7R1_FB21     = 0x200000   // Bit FB21.
	CAN_F7R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F7R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F7R1_FB22     = 0x400000   // Bit FB22.
	CAN_F7R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F7R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F7R1_FB23     = 0x800000   // Bit FB23.
	CAN_F7R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F7R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F7R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F7R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F7R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F7R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F7R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F7R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F7R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F7R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F7R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F7R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F7R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F7R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F7R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F7R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F7R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F7R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F7R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F7R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F7R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F7R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F7R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F7R1_FB31     = 0x80000000 // Bit FB31.

	// F7R2: Filter bank 7 register 2
	CAN_F7R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F7R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F7R2_FB0      = 0x1        // Bit FB0.
	CAN_F7R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F7R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F7R2_FB1      = 0x2        // Bit FB1.
	CAN_F7R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F7R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F7R2_FB2      = 0x4        // Bit FB2.
	CAN_F7R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F7R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F7R2_FB3      = 0x8        // Bit FB3.
	CAN_F7R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F7R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F7R2_FB4      = 0x10       // Bit FB4.
	CAN_F7R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F7R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F7R2_FB5      = 0x20       // Bit FB5.
	CAN_F7R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F7R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F7R2_FB6      = 0x40       // Bit FB6.
	CAN_F7R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F7R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F7R2_FB7      = 0x80       // Bit FB7.
	CAN_F7R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F7R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F7R2_FB8      = 0x100      // Bit FB8.
	CAN_F7R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F7R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F7R2_FB9      = 0x200      // Bit FB9.
	CAN_F7R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F7R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F7R2_FB10     = 0x400      // Bit FB10.
	CAN_F7R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F7R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F7R2_FB11     = 0x800      // Bit FB11.
	CAN_F7R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F7R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F7R2_FB12     = 0x1000     // Bit FB12.
	CAN_F7R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F7R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F7R2_FB13     = 0x2000     // Bit FB13.
	CAN_F7R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F7R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F7R2_FB14     = 0x4000     // Bit FB14.
	CAN_F7R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F7R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F7R2_FB15     = 0x8000     // Bit FB15.
	CAN_F7R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F7R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F7R2_FB16     = 0x10000    // Bit FB16.
	CAN_F7R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F7R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F7R2_FB17     = 0x20000    // Bit FB17.
	CAN_F7R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F7R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F7R2_FB18     = 0x40000    // Bit FB18.
	CAN_F7R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F7R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F7R2_FB19     = 0x80000    // Bit FB19.
	CAN_F7R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F7R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F7R2_FB20     = 0x100000   // Bit FB20.
	CAN_F7R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F7R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F7R2_FB21     = 0x200000   // Bit FB21.
	CAN_F7R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F7R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F7R2_FB22     = 0x400000   // Bit FB22.
	CAN_F7R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F7R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F7R2_FB23     = 0x800000   // Bit FB23.
	CAN_F7R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F7R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F7R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F7R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F7R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F7R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F7R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F7R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F7R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F7R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F7R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F7R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F7R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F7R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F7R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F7R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F7R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F7R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F7R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F7R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F7R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F7R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F7R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F7R2_FB31     = 0x80000000 // Bit FB31.

	// F8R1: Filter bank 8 register 1
	CAN_F8R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F8R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F8R1_FB0      = 0x1        // Bit FB0.
	CAN_F8R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F8R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F8R1_FB1      = 0x2        // Bit FB1.
	CAN_F8R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F8R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F8R1_FB2      = 0x4        // Bit FB2.
	CAN_F8R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F8R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F8R1_FB3      = 0x8        // Bit FB3.
	CAN_F8R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F8R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F8R1_FB4      = 0x10       // Bit FB4.
	CAN_F8R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F8R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F8R1_FB5      = 0x20       // Bit FB5.
	CAN_F8R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F8R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F8R1_FB6      = 0x40       // Bit FB6.
	CAN_F8R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F8R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F8R1_FB7      = 0x80       // Bit FB7.
	CAN_F8R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F8R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F8R1_FB8      = 0x100      // Bit FB8.
	CAN_F8R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F8R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F8R1_FB9      = 0x200      // Bit FB9.
	CAN_F8R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F8R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F8R1_FB10     = 0x400      // Bit FB10.
	CAN_F8R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F8R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F8R1_FB11     = 0x800      // Bit FB11.
	CAN_F8R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F8R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F8R1_FB12     = 0x1000     // Bit FB12.
	CAN_F8R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F8R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F8R1_FB13     = 0x2000     // Bit FB13.
	CAN_F8R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F8R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F8R1_FB14     = 0x4000     // Bit FB14.
	CAN_F8R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F8R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F8R1_FB15     = 0x8000     // Bit FB15.
	CAN_F8R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F8R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F8R1_FB16     = 0x10000    // Bit FB16.
	CAN_F8R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F8R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F8R1_FB17     = 0x20000    // Bit FB17.
	CAN_F8R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F8R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F8R1_FB18     = 0x40000    // Bit FB18.
	CAN_F8R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F8R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F8R1_FB19     = 0x80000    // Bit FB19.
	CAN_F8R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F8R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F8R1_FB20     = 0x100000   // Bit FB20.
	CAN_F8R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F8R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F8R1_FB21     = 0x200000   // Bit FB21.
	CAN_F8R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F8R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F8R1_FB22     = 0x400000   // Bit FB22.
	CAN_F8R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F8R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F8R1_FB23     = 0x800000   // Bit FB23.
	CAN_F8R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F8R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F8R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F8R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F8R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F8R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F8R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F8R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F8R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F8R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F8R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F8R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F8R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F8R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F8R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F8R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F8R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F8R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F8R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F8R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F8R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F8R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F8R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F8R1_FB31     = 0x80000000 // Bit FB31.

	// F8R2: Filter bank 8 register 2
	CAN_F8R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F8R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F8R2_FB0      = 0x1        // Bit FB0.
	CAN_F8R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F8R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F8R2_FB1      = 0x2        // Bit FB1.
	CAN_F8R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F8R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F8R2_FB2      = 0x4        // Bit FB2.
	CAN_F8R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F8R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F8R2_FB3      = 0x8        // Bit FB3.
	CAN_F8R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F8R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F8R2_FB4      = 0x10       // Bit FB4.
	CAN_F8R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F8R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F8R2_FB5      = 0x20       // Bit FB5.
	CAN_F8R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F8R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F8R2_FB6      = 0x40       // Bit FB6.
	CAN_F8R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F8R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F8R2_FB7      = 0x80       // Bit FB7.
	CAN_F8R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F8R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F8R2_FB8      = 0x100      // Bit FB8.
	CAN_F8R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F8R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F8R2_FB9      = 0x200      // Bit FB9.
	CAN_F8R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F8R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F8R2_FB10     = 0x400      // Bit FB10.
	CAN_F8R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F8R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F8R2_FB11     = 0x800      // Bit FB11.
	CAN_F8R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F8R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F8R2_FB12     = 0x1000     // Bit FB12.
	CAN_F8R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F8R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F8R2_FB13     = 0x2000     // Bit FB13.
	CAN_F8R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F8R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F8R2_FB14     = 0x4000     // Bit FB14.
	CAN_F8R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F8R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F8R2_FB15     = 0x8000     // Bit FB15.
	CAN_F8R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F8R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F8R2_FB16     = 0x10000    // Bit FB16.
	CAN_F8R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F8R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F8R2_FB17     = 0x20000    // Bit FB17.
	CAN_F8R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F8R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F8R2_FB18     = 0x40000    // Bit FB18.
	CAN_F8R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F8R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F8R2_FB19     = 0x80000    // Bit FB19.
	CAN_F8R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F8R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F8R2_FB20     = 0x100000   // Bit FB20.
	CAN_F8R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F8R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F8R2_FB21     = 0x200000   // Bit FB21.
	CAN_F8R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F8R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F8R2_FB22     = 0x400000   // Bit FB22.
	CAN_F8R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F8R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F8R2_FB23     = 0x800000   // Bit FB23.
	CAN_F8R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F8R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F8R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F8R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F8R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F8R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F8R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F8R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F8R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F8R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F8R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F8R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F8R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F8R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F8R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F8R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F8R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F8R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F8R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F8R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F8R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F8R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F8R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F8R2_FB31     = 0x80000000 // Bit FB31.

	// F9R1: Filter bank 9 register 1
	CAN_F9R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F9R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F9R1_FB0      = 0x1        // Bit FB0.
	CAN_F9R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F9R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F9R1_FB1      = 0x2        // Bit FB1.
	CAN_F9R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F9R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F9R1_FB2      = 0x4        // Bit FB2.
	CAN_F9R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F9R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F9R1_FB3      = 0x8        // Bit FB3.
	CAN_F9R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F9R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F9R1_FB4      = 0x10       // Bit FB4.
	CAN_F9R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F9R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F9R1_FB5      = 0x20       // Bit FB5.
	CAN_F9R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F9R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F9R1_FB6      = 0x40       // Bit FB6.
	CAN_F9R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F9R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F9R1_FB7      = 0x80       // Bit FB7.
	CAN_F9R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F9R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F9R1_FB8      = 0x100      // Bit FB8.
	CAN_F9R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F9R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F9R1_FB9      = 0x200      // Bit FB9.
	CAN_F9R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F9R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F9R1_FB10     = 0x400      // Bit FB10.
	CAN_F9R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F9R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F9R1_FB11     = 0x800      // Bit FB11.
	CAN_F9R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F9R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F9R1_FB12     = 0x1000     // Bit FB12.
	CAN_F9R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F9R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F9R1_FB13     = 0x2000     // Bit FB13.
	CAN_F9R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F9R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F9R1_FB14     = 0x4000     // Bit FB14.
	CAN_F9R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F9R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F9R1_FB15     = 0x8000     // Bit FB15.
	CAN_F9R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F9R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F9R1_FB16     = 0x10000    // Bit FB16.
	CAN_F9R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F9R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F9R1_FB17     = 0x20000    // Bit FB17.
	CAN_F9R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F9R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F9R1_FB18     = 0x40000    // Bit FB18.
	CAN_F9R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F9R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F9R1_FB19     = 0x80000    // Bit FB19.
	CAN_F9R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F9R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F9R1_FB20     = 0x100000   // Bit FB20.
	CAN_F9R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F9R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F9R1_FB21     = 0x200000   // Bit FB21.
	CAN_F9R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F9R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F9R1_FB22     = 0x400000   // Bit FB22.
	CAN_F9R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F9R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F9R1_FB23     = 0x800000   // Bit FB23.
	CAN_F9R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F9R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F9R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F9R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F9R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F9R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F9R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F9R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F9R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F9R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F9R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F9R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F9R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F9R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F9R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F9R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F9R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F9R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F9R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F9R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F9R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F9R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F9R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F9R1_FB31     = 0x80000000 // Bit FB31.

	// F9R2: Filter bank 9 register 2
	CAN_F9R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F9R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F9R2_FB0      = 0x1        // Bit FB0.
	CAN_F9R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F9R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F9R2_FB1      = 0x2        // Bit FB1.
	CAN_F9R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F9R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F9R2_FB2      = 0x4        // Bit FB2.
	CAN_F9R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F9R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F9R2_FB3      = 0x8        // Bit FB3.
	CAN_F9R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F9R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F9R2_FB4      = 0x10       // Bit FB4.
	CAN_F9R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F9R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F9R2_FB5      = 0x20       // Bit FB5.
	CAN_F9R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F9R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F9R2_FB6      = 0x40       // Bit FB6.
	CAN_F9R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F9R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F9R2_FB7      = 0x80       // Bit FB7.
	CAN_F9R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F9R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F9R2_FB8      = 0x100      // Bit FB8.
	CAN_F9R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F9R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F9R2_FB9      = 0x200      // Bit FB9.
	CAN_F9R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F9R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F9R2_FB10     = 0x400      // Bit FB10.
	CAN_F9R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F9R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F9R2_FB11     = 0x800      // Bit FB11.
	CAN_F9R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F9R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F9R2_FB12     = 0x1000     // Bit FB12.
	CAN_F9R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F9R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F9R2_FB13     = 0x2000     // Bit FB13.
	CAN_F9R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F9R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F9R2_FB14     = 0x4000     // Bit FB14.
	CAN_F9R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F9R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F9R2_FB15     = 0x8000     // Bit FB15.
	CAN_F9R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F9R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F9R2_FB16     = 0x10000    // Bit FB16.
	CAN_F9R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F9R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F9R2_FB17     = 0x20000    // Bit FB17.
	CAN_F9R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F9R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F9R2_FB18     = 0x40000    // Bit FB18.
	CAN_F9R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F9R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F9R2_FB19     = 0x80000    // Bit FB19.
	CAN_F9R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F9R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F9R2_FB20     = 0x100000   // Bit FB20.
	CAN_F9R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F9R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F9R2_FB21     = 0x200000   // Bit FB21.
	CAN_F9R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F9R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F9R2_FB22     = 0x400000   // Bit FB22.
	CAN_F9R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F9R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F9R2_FB23     = 0x800000   // Bit FB23.
	CAN_F9R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F9R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F9R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F9R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F9R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F9R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F9R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F9R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F9R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F9R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F9R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F9R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F9R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F9R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F9R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F9R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F9R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F9R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F9R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F9R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F9R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F9R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F9R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F9R2_FB31     = 0x80000000 // Bit FB31.

	// F10R1: Filter bank 10 register 1
	CAN_F10R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F10R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F10R1_FB0      = 0x1        // Bit FB0.
	CAN_F10R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F10R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F10R1_FB1      = 0x2        // Bit FB1.
	CAN_F10R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F10R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F10R1_FB2      = 0x4        // Bit FB2.
	CAN_F10R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F10R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F10R1_FB3      = 0x8        // Bit FB3.
	CAN_F10R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F10R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F10R1_FB4      = 0x10       // Bit FB4.
	CAN_F10R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F10R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F10R1_FB5      = 0x20       // Bit FB5.
	CAN_F10R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F10R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F10R1_FB6      = 0x40       // Bit FB6.
	CAN_F10R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F10R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F10R1_FB7      = 0x80       // Bit FB7.
	CAN_F10R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F10R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F10R1_FB8      = 0x100      // Bit FB8.
	CAN_F10R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F10R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F10R1_FB9      = 0x200      // Bit FB9.
	CAN_F10R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F10R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F10R1_FB10     = 0x400      // Bit FB10.
	CAN_F10R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F10R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F10R1_FB11     = 0x800      // Bit FB11.
	CAN_F10R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F10R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F10R1_FB12     = 0x1000     // Bit FB12.
	CAN_F10R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F10R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F10R1_FB13     = 0x2000     // Bit FB13.
	CAN_F10R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F10R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F10R1_FB14     = 0x4000     // Bit FB14.
	CAN_F10R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F10R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F10R1_FB15     = 0x8000     // Bit FB15.
	CAN_F10R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F10R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F10R1_FB16     = 0x10000    // Bit FB16.
	CAN_F10R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F10R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F10R1_FB17     = 0x20000    // Bit FB17.
	CAN_F10R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F10R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F10R1_FB18     = 0x40000    // Bit FB18.
	CAN_F10R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F10R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F10R1_FB19     = 0x80000    // Bit FB19.
	CAN_F10R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F10R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F10R1_FB20     = 0x100000   // Bit FB20.
	CAN_F10R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F10R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F10R1_FB21     = 0x200000   // Bit FB21.
	CAN_F10R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F10R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F10R1_FB22     = 0x400000   // Bit FB22.
	CAN_F10R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F10R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F10R1_FB23     = 0x800000   // Bit FB23.
	CAN_F10R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F10R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F10R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F10R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F10R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F10R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F10R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F10R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F10R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F10R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F10R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F10R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F10R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F10R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F10R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F10R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F10R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F10R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F10R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F10R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F10R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F10R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F10R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F10R1_FB31     = 0x80000000 // Bit FB31.

	// F10R2: Filter bank 10 register 2
	CAN_F10R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F10R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F10R2_FB0      = 0x1        // Bit FB0.
	CAN_F10R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F10R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F10R2_FB1      = 0x2        // Bit FB1.
	CAN_F10R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F10R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F10R2_FB2      = 0x4        // Bit FB2.
	CAN_F10R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F10R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F10R2_FB3      = 0x8        // Bit FB3.
	CAN_F10R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F10R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F10R2_FB4      = 0x10       // Bit FB4.
	CAN_F10R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F10R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F10R2_FB5      = 0x20       // Bit FB5.
	CAN_F10R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F10R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F10R2_FB6      = 0x40       // Bit FB6.
	CAN_F10R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F10R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F10R2_FB7      = 0x80       // Bit FB7.
	CAN_F10R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F10R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F10R2_FB8      = 0x100      // Bit FB8.
	CAN_F10R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F10R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F10R2_FB9      = 0x200      // Bit FB9.
	CAN_F10R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F10R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F10R2_FB10     = 0x400      // Bit FB10.
	CAN_F10R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F10R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F10R2_FB11     = 0x800      // Bit FB11.
	CAN_F10R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F10R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F10R2_FB12     = 0x1000     // Bit FB12.
	CAN_F10R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F10R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F10R2_FB13     = 0x2000     // Bit FB13.
	CAN_F10R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F10R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F10R2_FB14     = 0x4000     // Bit FB14.
	CAN_F10R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F10R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F10R2_FB15     = 0x8000     // Bit FB15.
	CAN_F10R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F10R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F10R2_FB16     = 0x10000    // Bit FB16.
	CAN_F10R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F10R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F10R2_FB17     = 0x20000    // Bit FB17.
	CAN_F10R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F10R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F10R2_FB18     = 0x40000    // Bit FB18.
	CAN_F10R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F10R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F10R2_FB19     = 0x80000    // Bit FB19.
	CAN_F10R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F10R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F10R2_FB20     = 0x100000   // Bit FB20.
	CAN_F10R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F10R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F10R2_FB21     = 0x200000   // Bit FB21.
	CAN_F10R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F10R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F10R2_FB22     = 0x400000   // Bit FB22.
	CAN_F10R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F10R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F10R2_FB23     = 0x800000   // Bit FB23.
	CAN_F10R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F10R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F10R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F10R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F10R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F10R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F10R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F10R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F10R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F10R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F10R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F10R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F10R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F10R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F10R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F10R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F10R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F10R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F10R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F10R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F10R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F10R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F10R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F10R2_FB31     = 0x80000000 // Bit FB31.

	// F11R1: Filter bank 11 register 1
	CAN_F11R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F11R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F11R1_FB0      = 0x1        // Bit FB0.
	CAN_F11R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F11R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F11R1_FB1      = 0x2        // Bit FB1.
	CAN_F11R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F11R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F11R1_FB2      = 0x4        // Bit FB2.
	CAN_F11R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F11R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F11R1_FB3      = 0x8        // Bit FB3.
	CAN_F11R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F11R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F11R1_FB4      = 0x10       // Bit FB4.
	CAN_F11R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F11R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F11R1_FB5      = 0x20       // Bit FB5.
	CAN_F11R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F11R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F11R1_FB6      = 0x40       // Bit FB6.
	CAN_F11R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F11R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F11R1_FB7      = 0x80       // Bit FB7.
	CAN_F11R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F11R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F11R1_FB8      = 0x100      // Bit FB8.
	CAN_F11R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F11R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F11R1_FB9      = 0x200      // Bit FB9.
	CAN_F11R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F11R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F11R1_FB10     = 0x400      // Bit FB10.
	CAN_F11R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F11R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F11R1_FB11     = 0x800      // Bit FB11.
	CAN_F11R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F11R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F11R1_FB12     = 0x1000     // Bit FB12.
	CAN_F11R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F11R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F11R1_FB13     = 0x2000     // Bit FB13.
	CAN_F11R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F11R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F11R1_FB14     = 0x4000     // Bit FB14.
	CAN_F11R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F11R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F11R1_FB15     = 0x8000     // Bit FB15.
	CAN_F11R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F11R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F11R1_FB16     = 0x10000    // Bit FB16.
	CAN_F11R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F11R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F11R1_FB17     = 0x20000    // Bit FB17.
	CAN_F11R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F11R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F11R1_FB18     = 0x40000    // Bit FB18.
	CAN_F11R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F11R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F11R1_FB19     = 0x80000    // Bit FB19.
	CAN_F11R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F11R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F11R1_FB20     = 0x100000   // Bit FB20.
	CAN_F11R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F11R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F11R1_FB21     = 0x200000   // Bit FB21.
	CAN_F11R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F11R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F11R1_FB22     = 0x400000   // Bit FB22.
	CAN_F11R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F11R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F11R1_FB23     = 0x800000   // Bit FB23.
	CAN_F11R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F11R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F11R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F11R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F11R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F11R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F11R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F11R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F11R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F11R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F11R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F11R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F11R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F11R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F11R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F11R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F11R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F11R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F11R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F11R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F11R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F11R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F11R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F11R1_FB31     = 0x80000000 // Bit FB31.

	// F11R2: Filter bank 11 register 2
	CAN_F11R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F11R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F11R2_FB0      = 0x1        // Bit FB0.
	CAN_F11R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F11R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F11R2_FB1      = 0x2        // Bit FB1.
	CAN_F11R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F11R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F11R2_FB2      = 0x4        // Bit FB2.
	CAN_F11R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F11R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F11R2_FB3      = 0x8        // Bit FB3.
	CAN_F11R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F11R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F11R2_FB4      = 0x10       // Bit FB4.
	CAN_F11R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F11R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F11R2_FB5      = 0x20       // Bit FB5.
	CAN_F11R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F11R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F11R2_FB6      = 0x40       // Bit FB6.
	CAN_F11R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F11R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F11R2_FB7      = 0x80       // Bit FB7.
	CAN_F11R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F11R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F11R2_FB8      = 0x100      // Bit FB8.
	CAN_F11R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F11R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F11R2_FB9      = 0x200      // Bit FB9.
	CAN_F11R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F11R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F11R2_FB10     = 0x400      // Bit FB10.
	CAN_F11R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F11R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F11R2_FB11     = 0x800      // Bit FB11.
	CAN_F11R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F11R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F11R2_FB12     = 0x1000     // Bit FB12.
	CAN_F11R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F11R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F11R2_FB13     = 0x2000     // Bit FB13.
	CAN_F11R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F11R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F11R2_FB14     = 0x4000     // Bit FB14.
	CAN_F11R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F11R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F11R2_FB15     = 0x8000     // Bit FB15.
	CAN_F11R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F11R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F11R2_FB16     = 0x10000    // Bit FB16.
	CAN_F11R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F11R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F11R2_FB17     = 0x20000    // Bit FB17.
	CAN_F11R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F11R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F11R2_FB18     = 0x40000    // Bit FB18.
	CAN_F11R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F11R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F11R2_FB19     = 0x80000    // Bit FB19.
	CAN_F11R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F11R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F11R2_FB20     = 0x100000   // Bit FB20.
	CAN_F11R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F11R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F11R2_FB21     = 0x200000   // Bit FB21.
	CAN_F11R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F11R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F11R2_FB22     = 0x400000   // Bit FB22.
	CAN_F11R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F11R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F11R2_FB23     = 0x800000   // Bit FB23.
	CAN_F11R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F11R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F11R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F11R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F11R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F11R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F11R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F11R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F11R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F11R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F11R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F11R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F11R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F11R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F11R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F11R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F11R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F11R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F11R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F11R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F11R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F11R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F11R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F11R2_FB31     = 0x80000000 // Bit FB31.

	// F12R1: Filter bank 4 register 1
	CAN_F12R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F12R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F12R1_FB0      = 0x1        // Bit FB0.
	CAN_F12R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F12R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F12R1_FB1      = 0x2        // Bit FB1.
	CAN_F12R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F12R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F12R1_FB2      = 0x4        // Bit FB2.
	CAN_F12R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F12R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F12R1_FB3      = 0x8        // Bit FB3.
	CAN_F12R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F12R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F12R1_FB4      = 0x10       // Bit FB4.
	CAN_F12R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F12R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F12R1_FB5      = 0x20       // Bit FB5.
	CAN_F12R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F12R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F12R1_FB6      = 0x40       // Bit FB6.
	CAN_F12R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F12R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F12R1_FB7      = 0x80       // Bit FB7.
	CAN_F12R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F12R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F12R1_FB8      = 0x100      // Bit FB8.
	CAN_F12R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F12R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F12R1_FB9      = 0x200      // Bit FB9.
	CAN_F12R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F12R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F12R1_FB10     = 0x400      // Bit FB10.
	CAN_F12R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F12R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F12R1_FB11     = 0x800      // Bit FB11.
	CAN_F12R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F12R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F12R1_FB12     = 0x1000     // Bit FB12.
	CAN_F12R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F12R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F12R1_FB13     = 0x2000     // Bit FB13.
	CAN_F12R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F12R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F12R1_FB14     = 0x4000     // Bit FB14.
	CAN_F12R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F12R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F12R1_FB15     = 0x8000     // Bit FB15.
	CAN_F12R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F12R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F12R1_FB16     = 0x10000    // Bit FB16.
	CAN_F12R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F12R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F12R1_FB17     = 0x20000    // Bit FB17.
	CAN_F12R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F12R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F12R1_FB18     = 0x40000    // Bit FB18.
	CAN_F12R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F12R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F12R1_FB19     = 0x80000    // Bit FB19.
	CAN_F12R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F12R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F12R1_FB20     = 0x100000   // Bit FB20.
	CAN_F12R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F12R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F12R1_FB21     = 0x200000   // Bit FB21.
	CAN_F12R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F12R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F12R1_FB22     = 0x400000   // Bit FB22.
	CAN_F12R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F12R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F12R1_FB23     = 0x800000   // Bit FB23.
	CAN_F12R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F12R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F12R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F12R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F12R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F12R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F12R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F12R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F12R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F12R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F12R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F12R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F12R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F12R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F12R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F12R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F12R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F12R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F12R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F12R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F12R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F12R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F12R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F12R1_FB31     = 0x80000000 // Bit FB31.

	// F12R2: Filter bank 12 register 2
	CAN_F12R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F12R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F12R2_FB0      = 0x1        // Bit FB0.
	CAN_F12R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F12R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F12R2_FB1      = 0x2        // Bit FB1.
	CAN_F12R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F12R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F12R2_FB2      = 0x4        // Bit FB2.
	CAN_F12R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F12R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F12R2_FB3      = 0x8        // Bit FB3.
	CAN_F12R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F12R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F12R2_FB4      = 0x10       // Bit FB4.
	CAN_F12R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F12R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F12R2_FB5      = 0x20       // Bit FB5.
	CAN_F12R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F12R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F12R2_FB6      = 0x40       // Bit FB6.
	CAN_F12R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F12R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F12R2_FB7      = 0x80       // Bit FB7.
	CAN_F12R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F12R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F12R2_FB8      = 0x100      // Bit FB8.
	CAN_F12R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F12R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F12R2_FB9      = 0x200      // Bit FB9.
	CAN_F12R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F12R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F12R2_FB10     = 0x400      // Bit FB10.
	CAN_F12R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F12R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F12R2_FB11     = 0x800      // Bit FB11.
	CAN_F12R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F12R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F12R2_FB12     = 0x1000     // Bit FB12.
	CAN_F12R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F12R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F12R2_FB13     = 0x2000     // Bit FB13.
	CAN_F12R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F12R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F12R2_FB14     = 0x4000     // Bit FB14.
	CAN_F12R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F12R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F12R2_FB15     = 0x8000     // Bit FB15.
	CAN_F12R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F12R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F12R2_FB16     = 0x10000    // Bit FB16.
	CAN_F12R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F12R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F12R2_FB17     = 0x20000    // Bit FB17.
	CAN_F12R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F12R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F12R2_FB18     = 0x40000    // Bit FB18.
	CAN_F12R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F12R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F12R2_FB19     = 0x80000    // Bit FB19.
	CAN_F12R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F12R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F12R2_FB20     = 0x100000   // Bit FB20.
	CAN_F12R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F12R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F12R2_FB21     = 0x200000   // Bit FB21.
	CAN_F12R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F12R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F12R2_FB22     = 0x400000   // Bit FB22.
	CAN_F12R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F12R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F12R2_FB23     = 0x800000   // Bit FB23.
	CAN_F12R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F12R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F12R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F12R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F12R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F12R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F12R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F12R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F12R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F12R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F12R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F12R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F12R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F12R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F12R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F12R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F12R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F12R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F12R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F12R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F12R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F12R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F12R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F12R2_FB31     = 0x80000000 // Bit FB31.

	// F13R1: Filter bank 13 register 1
	CAN_F13R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F13R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F13R1_FB0      = 0x1        // Bit FB0.
	CAN_F13R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F13R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F13R1_FB1      = 0x2        // Bit FB1.
	CAN_F13R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F13R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F13R1_FB2      = 0x4        // Bit FB2.
	CAN_F13R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F13R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F13R1_FB3      = 0x8        // Bit FB3.
	CAN_F13R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F13R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F13R1_FB4      = 0x10       // Bit FB4.
	CAN_F13R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F13R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F13R1_FB5      = 0x20       // Bit FB5.
	CAN_F13R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F13R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F13R1_FB6      = 0x40       // Bit FB6.
	CAN_F13R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F13R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F13R1_FB7      = 0x80       // Bit FB7.
	CAN_F13R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F13R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F13R1_FB8      = 0x100      // Bit FB8.
	CAN_F13R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F13R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F13R1_FB9      = 0x200      // Bit FB9.
	CAN_F13R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F13R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F13R1_FB10     = 0x400      // Bit FB10.
	CAN_F13R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F13R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F13R1_FB11     = 0x800      // Bit FB11.
	CAN_F13R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F13R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F13R1_FB12     = 0x1000     // Bit FB12.
	CAN_F13R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F13R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F13R1_FB13     = 0x2000     // Bit FB13.
	CAN_F13R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F13R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F13R1_FB14     = 0x4000     // Bit FB14.
	CAN_F13R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F13R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F13R1_FB15     = 0x8000     // Bit FB15.
	CAN_F13R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F13R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F13R1_FB16     = 0x10000    // Bit FB16.
	CAN_F13R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F13R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F13R1_FB17     = 0x20000    // Bit FB17.
	CAN_F13R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F13R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F13R1_FB18     = 0x40000    // Bit FB18.
	CAN_F13R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F13R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F13R1_FB19     = 0x80000    // Bit FB19.
	CAN_F13R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F13R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F13R1_FB20     = 0x100000   // Bit FB20.
	CAN_F13R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F13R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F13R1_FB21     = 0x200000   // Bit FB21.
	CAN_F13R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F13R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F13R1_FB22     = 0x400000   // Bit FB22.
	CAN_F13R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F13R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F13R1_FB23     = 0x800000   // Bit FB23.
	CAN_F13R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F13R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F13R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F13R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F13R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F13R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F13R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F13R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F13R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F13R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F13R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F13R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F13R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F13R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F13R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F13R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F13R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F13R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F13R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F13R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F13R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F13R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F13R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F13R1_FB31     = 0x80000000 // Bit FB31.

	// F13R2: Filter bank 13 register 2
	CAN_F13R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F13R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F13R2_FB0      = 0x1        // Bit FB0.
	CAN_F13R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F13R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F13R2_FB1      = 0x2        // Bit FB1.
	CAN_F13R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F13R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F13R2_FB2      = 0x4        // Bit FB2.
	CAN_F13R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F13R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F13R2_FB3      = 0x8        // Bit FB3.
	CAN_F13R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F13R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F13R2_FB4      = 0x10       // Bit FB4.
	CAN_F13R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F13R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F13R2_FB5      = 0x20       // Bit FB5.
	CAN_F13R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F13R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F13R2_FB6      = 0x40       // Bit FB6.
	CAN_F13R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F13R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F13R2_FB7      = 0x80       // Bit FB7.
	CAN_F13R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F13R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F13R2_FB8      = 0x100      // Bit FB8.
	CAN_F13R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F13R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F13R2_FB9      = 0x200      // Bit FB9.
	CAN_F13R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F13R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F13R2_FB10     = 0x400      // Bit FB10.
	CAN_F13R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F13R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F13R2_FB11     = 0x800      // Bit FB11.
	CAN_F13R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F13R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F13R2_FB12     = 0x1000     // Bit FB12.
	CAN_F13R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F13R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F13R2_FB13     = 0x2000     // Bit FB13.
	CAN_F13R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F13R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F13R2_FB14     = 0x4000     // Bit FB14.
	CAN_F13R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F13R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F13R2_FB15     = 0x8000     // Bit FB15.
	CAN_F13R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F13R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F13R2_FB16     = 0x10000    // Bit FB16.
	CAN_F13R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F13R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F13R2_FB17     = 0x20000    // Bit FB17.
	CAN_F13R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F13R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F13R2_FB18     = 0x40000    // Bit FB18.
	CAN_F13R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F13R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F13R2_FB19     = 0x80000    // Bit FB19.
	CAN_F13R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F13R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F13R2_FB20     = 0x100000   // Bit FB20.
	CAN_F13R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F13R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F13R2_FB21     = 0x200000   // Bit FB21.
	CAN_F13R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F13R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F13R2_FB22     = 0x400000   // Bit FB22.
	CAN_F13R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F13R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F13R2_FB23     = 0x800000   // Bit FB23.
	CAN_F13R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F13R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F13R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F13R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F13R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F13R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F13R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F13R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F13R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F13R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F13R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F13R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F13R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F13R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F13R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F13R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F13R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F13R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F13R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F13R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F13R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F13R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F13R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F13R2_FB31     = 0x80000000 // Bit FB31.

	// F14R1: Filter bank 14 register 1
	CAN_F14R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F14R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F14R1_FB0      = 0x1        // Bit FB0.
	CAN_F14R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F14R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F14R1_FB1      = 0x2        // Bit FB1.
	CAN_F14R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F14R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F14R1_FB2      = 0x4        // Bit FB2.
	CAN_F14R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F14R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F14R1_FB3      = 0x8        // Bit FB3.
	CAN_F14R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F14R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F14R1_FB4      = 0x10       // Bit FB4.
	CAN_F14R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F14R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F14R1_FB5      = 0x20       // Bit FB5.
	CAN_F14R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F14R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F14R1_FB6      = 0x40       // Bit FB6.
	CAN_F14R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F14R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F14R1_FB7      = 0x80       // Bit FB7.
	CAN_F14R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F14R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F14R1_FB8      = 0x100      // Bit FB8.
	CAN_F14R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F14R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F14R1_FB9      = 0x200      // Bit FB9.
	CAN_F14R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F14R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F14R1_FB10     = 0x400      // Bit FB10.
	CAN_F14R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F14R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F14R1_FB11     = 0x800      // Bit FB11.
	CAN_F14R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F14R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F14R1_FB12     = 0x1000     // Bit FB12.
	CAN_F14R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F14R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F14R1_FB13     = 0x2000     // Bit FB13.
	CAN_F14R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F14R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F14R1_FB14     = 0x4000     // Bit FB14.
	CAN_F14R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F14R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F14R1_FB15     = 0x8000     // Bit FB15.
	CAN_F14R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F14R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F14R1_FB16     = 0x10000    // Bit FB16.
	CAN_F14R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F14R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F14R1_FB17     = 0x20000    // Bit FB17.
	CAN_F14R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F14R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F14R1_FB18     = 0x40000    // Bit FB18.
	CAN_F14R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F14R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F14R1_FB19     = 0x80000    // Bit FB19.
	CAN_F14R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F14R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F14R1_FB20     = 0x100000   // Bit FB20.
	CAN_F14R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F14R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F14R1_FB21     = 0x200000   // Bit FB21.
	CAN_F14R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F14R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F14R1_FB22     = 0x400000   // Bit FB22.
	CAN_F14R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F14R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F14R1_FB23     = 0x800000   // Bit FB23.
	CAN_F14R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F14R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F14R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F14R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F14R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F14R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F14R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F14R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F14R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F14R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F14R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F14R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F14R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F14R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F14R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F14R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F14R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F14R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F14R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F14R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F14R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F14R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F14R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F14R1_FB31     = 0x80000000 // Bit FB31.

	// F14R2: Filter bank 14 register 2
	CAN_F14R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F14R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F14R2_FB0      = 0x1        // Bit FB0.
	CAN_F14R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F14R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F14R2_FB1      = 0x2        // Bit FB1.
	CAN_F14R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F14R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F14R2_FB2      = 0x4        // Bit FB2.
	CAN_F14R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F14R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F14R2_FB3      = 0x8        // Bit FB3.
	CAN_F14R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F14R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F14R2_FB4      = 0x10       // Bit FB4.
	CAN_F14R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F14R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F14R2_FB5      = 0x20       // Bit FB5.
	CAN_F14R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F14R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F14R2_FB6      = 0x40       // Bit FB6.
	CAN_F14R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F14R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F14R2_FB7      = 0x80       // Bit FB7.
	CAN_F14R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F14R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F14R2_FB8      = 0x100      // Bit FB8.
	CAN_F14R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F14R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F14R2_FB9      = 0x200      // Bit FB9.
	CAN_F14R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F14R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F14R2_FB10     = 0x400      // Bit FB10.
	CAN_F14R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F14R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F14R2_FB11     = 0x800      // Bit FB11.
	CAN_F14R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F14R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F14R2_FB12     = 0x1000     // Bit FB12.
	CAN_F14R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F14R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F14R2_FB13     = 0x2000     // Bit FB13.
	CAN_F14R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F14R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F14R2_FB14     = 0x4000     // Bit FB14.
	CAN_F14R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F14R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F14R2_FB15     = 0x8000     // Bit FB15.
	CAN_F14R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F14R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F14R2_FB16     = 0x10000    // Bit FB16.
	CAN_F14R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F14R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F14R2_FB17     = 0x20000    // Bit FB17.
	CAN_F14R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F14R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F14R2_FB18     = 0x40000    // Bit FB18.
	CAN_F14R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F14R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F14R2_FB19     = 0x80000    // Bit FB19.
	CAN_F14R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F14R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F14R2_FB20     = 0x100000   // Bit FB20.
	CAN_F14R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F14R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F14R2_FB21     = 0x200000   // Bit FB21.
	CAN_F14R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F14R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F14R2_FB22     = 0x400000   // Bit FB22.
	CAN_F14R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F14R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F14R2_FB23     = 0x800000   // Bit FB23.
	CAN_F14R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F14R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F14R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F14R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F14R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F14R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F14R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F14R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F14R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F14R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F14R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F14R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F14R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F14R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F14R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F14R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F14R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F14R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F14R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F14R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F14R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F14R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F14R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F14R2_FB31     = 0x80000000 // Bit FB31.

	// F15R1: Filter bank 15 register 1
	CAN_F15R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F15R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F15R1_FB0      = 0x1        // Bit FB0.
	CAN_F15R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F15R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F15R1_FB1      = 0x2        // Bit FB1.
	CAN_F15R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F15R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F15R1_FB2      = 0x4        // Bit FB2.
	CAN_F15R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F15R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F15R1_FB3      = 0x8        // Bit FB3.
	CAN_F15R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F15R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F15R1_FB4      = 0x10       // Bit FB4.
	CAN_F15R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F15R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F15R1_FB5      = 0x20       // Bit FB5.
	CAN_F15R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F15R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F15R1_FB6      = 0x40       // Bit FB6.
	CAN_F15R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F15R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F15R1_FB7      = 0x80       // Bit FB7.
	CAN_F15R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F15R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F15R1_FB8      = 0x100      // Bit FB8.
	CAN_F15R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F15R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F15R1_FB9      = 0x200      // Bit FB9.
	CAN_F15R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F15R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F15R1_FB10     = 0x400      // Bit FB10.
	CAN_F15R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F15R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F15R1_FB11     = 0x800      // Bit FB11.
	CAN_F15R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F15R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F15R1_FB12     = 0x1000     // Bit FB12.
	CAN_F15R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F15R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F15R1_FB13     = 0x2000     // Bit FB13.
	CAN_F15R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F15R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F15R1_FB14     = 0x4000     // Bit FB14.
	CAN_F15R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F15R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F15R1_FB15     = 0x8000     // Bit FB15.
	CAN_F15R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F15R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F15R1_FB16     = 0x10000    // Bit FB16.
	CAN_F15R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F15R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F15R1_FB17     = 0x20000    // Bit FB17.
	CAN_F15R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F15R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F15R1_FB18     = 0x40000    // Bit FB18.
	CAN_F15R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F15R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F15R1_FB19     = 0x80000    // Bit FB19.
	CAN_F15R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F15R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F15R1_FB20     = 0x100000   // Bit FB20.
	CAN_F15R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F15R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F15R1_FB21     = 0x200000   // Bit FB21.
	CAN_F15R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F15R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F15R1_FB22     = 0x400000   // Bit FB22.
	CAN_F15R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F15R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F15R1_FB23     = 0x800000   // Bit FB23.
	CAN_F15R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F15R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F15R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F15R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F15R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F15R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F15R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F15R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F15R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F15R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F15R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F15R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F15R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F15R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F15R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F15R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F15R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F15R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F15R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F15R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F15R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F15R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F15R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F15R1_FB31     = 0x80000000 // Bit FB31.

	// F15R2: Filter bank 15 register 2
	CAN_F15R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F15R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F15R2_FB0      = 0x1        // Bit FB0.
	CAN_F15R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F15R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F15R2_FB1      = 0x2        // Bit FB1.
	CAN_F15R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F15R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F15R2_FB2      = 0x4        // Bit FB2.
	CAN_F15R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F15R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F15R2_FB3      = 0x8        // Bit FB3.
	CAN_F15R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F15R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F15R2_FB4      = 0x10       // Bit FB4.
	CAN_F15R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F15R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F15R2_FB5      = 0x20       // Bit FB5.
	CAN_F15R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F15R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F15R2_FB6      = 0x40       // Bit FB6.
	CAN_F15R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F15R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F15R2_FB7      = 0x80       // Bit FB7.
	CAN_F15R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F15R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F15R2_FB8      = 0x100      // Bit FB8.
	CAN_F15R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F15R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F15R2_FB9      = 0x200      // Bit FB9.
	CAN_F15R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F15R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F15R2_FB10     = 0x400      // Bit FB10.
	CAN_F15R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F15R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F15R2_FB11     = 0x800      // Bit FB11.
	CAN_F15R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F15R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F15R2_FB12     = 0x1000     // Bit FB12.
	CAN_F15R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F15R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F15R2_FB13     = 0x2000     // Bit FB13.
	CAN_F15R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F15R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F15R2_FB14     = 0x4000     // Bit FB14.
	CAN_F15R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F15R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F15R2_FB15     = 0x8000     // Bit FB15.
	CAN_F15R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F15R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F15R2_FB16     = 0x10000    // Bit FB16.
	CAN_F15R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F15R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F15R2_FB17     = 0x20000    // Bit FB17.
	CAN_F15R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F15R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F15R2_FB18     = 0x40000    // Bit FB18.
	CAN_F15R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F15R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F15R2_FB19     = 0x80000    // Bit FB19.
	CAN_F15R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F15R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F15R2_FB20     = 0x100000   // Bit FB20.
	CAN_F15R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F15R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F15R2_FB21     = 0x200000   // Bit FB21.
	CAN_F15R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F15R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F15R2_FB22     = 0x400000   // Bit FB22.
	CAN_F15R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F15R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F15R2_FB23     = 0x800000   // Bit FB23.
	CAN_F15R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F15R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F15R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F15R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F15R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F15R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F15R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F15R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F15R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F15R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F15R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F15R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F15R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F15R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F15R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F15R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F15R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F15R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F15R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F15R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F15R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F15R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F15R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F15R2_FB31     = 0x80000000 // Bit FB31.

	// F16R1: Filter bank 16 register 1
	CAN_F16R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F16R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F16R1_FB0      = 0x1        // Bit FB0.
	CAN_F16R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F16R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F16R1_FB1      = 0x2        // Bit FB1.
	CAN_F16R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F16R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F16R1_FB2      = 0x4        // Bit FB2.
	CAN_F16R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F16R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F16R1_FB3      = 0x8        // Bit FB3.
	CAN_F16R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F16R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F16R1_FB4      = 0x10       // Bit FB4.
	CAN_F16R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F16R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F16R1_FB5      = 0x20       // Bit FB5.
	CAN_F16R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F16R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F16R1_FB6      = 0x40       // Bit FB6.
	CAN_F16R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F16R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F16R1_FB7      = 0x80       // Bit FB7.
	CAN_F16R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F16R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F16R1_FB8      = 0x100      // Bit FB8.
	CAN_F16R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F16R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F16R1_FB9      = 0x200      // Bit FB9.
	CAN_F16R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F16R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F16R1_FB10     = 0x400      // Bit FB10.
	CAN_F16R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F16R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F16R1_FB11     = 0x800      // Bit FB11.
	CAN_F16R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F16R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F16R1_FB12     = 0x1000     // Bit FB12.
	CAN_F16R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F16R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F16R1_FB13     = 0x2000     // Bit FB13.
	CAN_F16R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F16R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F16R1_FB14     = 0x4000     // Bit FB14.
	CAN_F16R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F16R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F16R1_FB15     = 0x8000     // Bit FB15.
	CAN_F16R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F16R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F16R1_FB16     = 0x10000    // Bit FB16.
	CAN_F16R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F16R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F16R1_FB17     = 0x20000    // Bit FB17.
	CAN_F16R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F16R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F16R1_FB18     = 0x40000    // Bit FB18.
	CAN_F16R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F16R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F16R1_FB19     = 0x80000    // Bit FB19.
	CAN_F16R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F16R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F16R1_FB20     = 0x100000   // Bit FB20.
	CAN_F16R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F16R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F16R1_FB21     = 0x200000   // Bit FB21.
	CAN_F16R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F16R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F16R1_FB22     = 0x400000   // Bit FB22.
	CAN_F16R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F16R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F16R1_FB23     = 0x800000   // Bit FB23.
	CAN_F16R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F16R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F16R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F16R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F16R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F16R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F16R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F16R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F16R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F16R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F16R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F16R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F16R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F16R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F16R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F16R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F16R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F16R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F16R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F16R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F16R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F16R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F16R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F16R1_FB31     = 0x80000000 // Bit FB31.

	// F16R2: Filter bank 16 register 2
	CAN_F16R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F16R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F16R2_FB0      = 0x1        // Bit FB0.
	CAN_F16R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F16R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F16R2_FB1      = 0x2        // Bit FB1.
	CAN_F16R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F16R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F16R2_FB2      = 0x4        // Bit FB2.
	CAN_F16R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F16R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F16R2_FB3      = 0x8        // Bit FB3.
	CAN_F16R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F16R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F16R2_FB4      = 0x10       // Bit FB4.
	CAN_F16R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F16R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F16R2_FB5      = 0x20       // Bit FB5.
	CAN_F16R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F16R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F16R2_FB6      = 0x40       // Bit FB6.
	CAN_F16R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F16R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F16R2_FB7      = 0x80       // Bit FB7.
	CAN_F16R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F16R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F16R2_FB8      = 0x100      // Bit FB8.
	CAN_F16R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F16R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F16R2_FB9      = 0x200      // Bit FB9.
	CAN_F16R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F16R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F16R2_FB10     = 0x400      // Bit FB10.
	CAN_F16R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F16R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F16R2_FB11     = 0x800      // Bit FB11.
	CAN_F16R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F16R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F16R2_FB12     = 0x1000     // Bit FB12.
	CAN_F16R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F16R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F16R2_FB13     = 0x2000     // Bit FB13.
	CAN_F16R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F16R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F16R2_FB14     = 0x4000     // Bit FB14.
	CAN_F16R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F16R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F16R2_FB15     = 0x8000     // Bit FB15.
	CAN_F16R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F16R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F16R2_FB16     = 0x10000    // Bit FB16.
	CAN_F16R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F16R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F16R2_FB17     = 0x20000    // Bit FB17.
	CAN_F16R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F16R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F16R2_FB18     = 0x40000    // Bit FB18.
	CAN_F16R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F16R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F16R2_FB19     = 0x80000    // Bit FB19.
	CAN_F16R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F16R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F16R2_FB20     = 0x100000   // Bit FB20.
	CAN_F16R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F16R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F16R2_FB21     = 0x200000   // Bit FB21.
	CAN_F16R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F16R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F16R2_FB22     = 0x400000   // Bit FB22.
	CAN_F16R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F16R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F16R2_FB23     = 0x800000   // Bit FB23.
	CAN_F16R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F16R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F16R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F16R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F16R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F16R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F16R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F16R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F16R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F16R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F16R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F16R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F16R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F16R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F16R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F16R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F16R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F16R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F16R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F16R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F16R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F16R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F16R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F16R2_FB31     = 0x80000000 // Bit FB31.

	// F17R1: Filter bank 17 register 1
	CAN_F17R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F17R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F17R1_FB0      = 0x1        // Bit FB0.
	CAN_F17R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F17R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F17R1_FB1      = 0x2        // Bit FB1.
	CAN_F17R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F17R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F17R1_FB2      = 0x4        // Bit FB2.
	CAN_F17R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F17R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F17R1_FB3      = 0x8        // Bit FB3.
	CAN_F17R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F17R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F17R1_FB4      = 0x10       // Bit FB4.
	CAN_F17R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F17R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F17R1_FB5      = 0x20       // Bit FB5.
	CAN_F17R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F17R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F17R1_FB6      = 0x40       // Bit FB6.
	CAN_F17R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F17R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F17R1_FB7      = 0x80       // Bit FB7.
	CAN_F17R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F17R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F17R1_FB8      = 0x100      // Bit FB8.
	CAN_F17R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F17R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F17R1_FB9      = 0x200      // Bit FB9.
	CAN_F17R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F17R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F17R1_FB10     = 0x400      // Bit FB10.
	CAN_F17R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F17R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F17R1_FB11     = 0x800      // Bit FB11.
	CAN_F17R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F17R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F17R1_FB12     = 0x1000     // Bit FB12.
	CAN_F17R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F17R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F17R1_FB13     = 0x2000     // Bit FB13.
	CAN_F17R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F17R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F17R1_FB14     = 0x4000     // Bit FB14.
	CAN_F17R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F17R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F17R1_FB15     = 0x8000     // Bit FB15.
	CAN_F17R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F17R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F17R1_FB16     = 0x10000    // Bit FB16.
	CAN_F17R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F17R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F17R1_FB17     = 0x20000    // Bit FB17.
	CAN_F17R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F17R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F17R1_FB18     = 0x40000    // Bit FB18.
	CAN_F17R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F17R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F17R1_FB19     = 0x80000    // Bit FB19.
	CAN_F17R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F17R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F17R1_FB20     = 0x100000   // Bit FB20.
	CAN_F17R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F17R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F17R1_FB21     = 0x200000   // Bit FB21.
	CAN_F17R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F17R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F17R1_FB22     = 0x400000   // Bit FB22.
	CAN_F17R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F17R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F17R1_FB23     = 0x800000   // Bit FB23.
	CAN_F17R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F17R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F17R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F17R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F17R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F17R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F17R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F17R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F17R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F17R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F17R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F17R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F17R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F17R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F17R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F17R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F17R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F17R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F17R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F17R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F17R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F17R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F17R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F17R1_FB31     = 0x80000000 // Bit FB31.

	// F17R2: Filter bank 17 register 2
	CAN_F17R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F17R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F17R2_FB0      = 0x1        // Bit FB0.
	CAN_F17R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F17R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F17R2_FB1      = 0x2        // Bit FB1.
	CAN_F17R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F17R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F17R2_FB2      = 0x4        // Bit FB2.
	CAN_F17R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F17R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F17R2_FB3      = 0x8        // Bit FB3.
	CAN_F17R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F17R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F17R2_FB4      = 0x10       // Bit FB4.
	CAN_F17R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F17R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F17R2_FB5      = 0x20       // Bit FB5.
	CAN_F17R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F17R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F17R2_FB6      = 0x40       // Bit FB6.
	CAN_F17R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F17R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F17R2_FB7      = 0x80       // Bit FB7.
	CAN_F17R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F17R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F17R2_FB8      = 0x100      // Bit FB8.
	CAN_F17R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F17R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F17R2_FB9      = 0x200      // Bit FB9.
	CAN_F17R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F17R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F17R2_FB10     = 0x400      // Bit FB10.
	CAN_F17R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F17R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F17R2_FB11     = 0x800      // Bit FB11.
	CAN_F17R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F17R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F17R2_FB12     = 0x1000     // Bit FB12.
	CAN_F17R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F17R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F17R2_FB13     = 0x2000     // Bit FB13.
	CAN_F17R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F17R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F17R2_FB14     = 0x4000     // Bit FB14.
	CAN_F17R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F17R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F17R2_FB15     = 0x8000     // Bit FB15.
	CAN_F17R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F17R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F17R2_FB16     = 0x10000    // Bit FB16.
	CAN_F17R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F17R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F17R2_FB17     = 0x20000    // Bit FB17.
	CAN_F17R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F17R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F17R2_FB18     = 0x40000    // Bit FB18.
	CAN_F17R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F17R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F17R2_FB19     = 0x80000    // Bit FB19.
	CAN_F17R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F17R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F17R2_FB20     = 0x100000   // Bit FB20.
	CAN_F17R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F17R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F17R2_FB21     = 0x200000   // Bit FB21.
	CAN_F17R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F17R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F17R2_FB22     = 0x400000   // Bit FB22.
	CAN_F17R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F17R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F17R2_FB23     = 0x800000   // Bit FB23.
	CAN_F17R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F17R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F17R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F17R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F17R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F17R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F17R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F17R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F17R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F17R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F17R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F17R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F17R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F17R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F17R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F17R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F17R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F17R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F17R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F17R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F17R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F17R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F17R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F17R2_FB31     = 0x80000000 // Bit FB31.

	// F18R1: Filter bank 18 register 1
	CAN_F18R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F18R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F18R1_FB0      = 0x1        // Bit FB0.
	CAN_F18R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F18R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F18R1_FB1      = 0x2        // Bit FB1.
	CAN_F18R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F18R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F18R1_FB2      = 0x4        // Bit FB2.
	CAN_F18R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F18R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F18R1_FB3      = 0x8        // Bit FB3.
	CAN_F18R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F18R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F18R1_FB4      = 0x10       // Bit FB4.
	CAN_F18R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F18R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F18R1_FB5      = 0x20       // Bit FB5.
	CAN_F18R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F18R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F18R1_FB6      = 0x40       // Bit FB6.
	CAN_F18R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F18R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F18R1_FB7      = 0x80       // Bit FB7.
	CAN_F18R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F18R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F18R1_FB8      = 0x100      // Bit FB8.
	CAN_F18R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F18R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F18R1_FB9      = 0x200      // Bit FB9.
	CAN_F18R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F18R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F18R1_FB10     = 0x400      // Bit FB10.
	CAN_F18R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F18R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F18R1_FB11     = 0x800      // Bit FB11.
	CAN_F18R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F18R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F18R1_FB12     = 0x1000     // Bit FB12.
	CAN_F18R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F18R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F18R1_FB13     = 0x2000     // Bit FB13.
	CAN_F18R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F18R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F18R1_FB14     = 0x4000     // Bit FB14.
	CAN_F18R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F18R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F18R1_FB15     = 0x8000     // Bit FB15.
	CAN_F18R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F18R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F18R1_FB16     = 0x10000    // Bit FB16.
	CAN_F18R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F18R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F18R1_FB17     = 0x20000    // Bit FB17.
	CAN_F18R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F18R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F18R1_FB18     = 0x40000    // Bit FB18.
	CAN_F18R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F18R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F18R1_FB19     = 0x80000    // Bit FB19.
	CAN_F18R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F18R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F18R1_FB20     = 0x100000   // Bit FB20.
	CAN_F18R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F18R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F18R1_FB21     = 0x200000   // Bit FB21.
	CAN_F18R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F18R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F18R1_FB22     = 0x400000   // Bit FB22.
	CAN_F18R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F18R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F18R1_FB23     = 0x800000   // Bit FB23.
	CAN_F18R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F18R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F18R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F18R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F18R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F18R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F18R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F18R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F18R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F18R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F18R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F18R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F18R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F18R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F18R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F18R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F18R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F18R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F18R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F18R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F18R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F18R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F18R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F18R1_FB31     = 0x80000000 // Bit FB31.

	// F18R2: Filter bank 18 register 2
	CAN_F18R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F18R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F18R2_FB0      = 0x1        // Bit FB0.
	CAN_F18R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F18R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F18R2_FB1      = 0x2        // Bit FB1.
	CAN_F18R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F18R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F18R2_FB2      = 0x4        // Bit FB2.
	CAN_F18R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F18R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F18R2_FB3      = 0x8        // Bit FB3.
	CAN_F18R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F18R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F18R2_FB4      = 0x10       // Bit FB4.
	CAN_F18R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F18R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F18R2_FB5      = 0x20       // Bit FB5.
	CAN_F18R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F18R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F18R2_FB6      = 0x40       // Bit FB6.
	CAN_F18R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F18R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F18R2_FB7      = 0x80       // Bit FB7.
	CAN_F18R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F18R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F18R2_FB8      = 0x100      // Bit FB8.
	CAN_F18R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F18R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F18R2_FB9      = 0x200      // Bit FB9.
	CAN_F18R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F18R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F18R2_FB10     = 0x400      // Bit FB10.
	CAN_F18R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F18R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F18R2_FB11     = 0x800      // Bit FB11.
	CAN_F18R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F18R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F18R2_FB12     = 0x1000     // Bit FB12.
	CAN_F18R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F18R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F18R2_FB13     = 0x2000     // Bit FB13.
	CAN_F18R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F18R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F18R2_FB14     = 0x4000     // Bit FB14.
	CAN_F18R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F18R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F18R2_FB15     = 0x8000     // Bit FB15.
	CAN_F18R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F18R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F18R2_FB16     = 0x10000    // Bit FB16.
	CAN_F18R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F18R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F18R2_FB17     = 0x20000    // Bit FB17.
	CAN_F18R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F18R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F18R2_FB18     = 0x40000    // Bit FB18.
	CAN_F18R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F18R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F18R2_FB19     = 0x80000    // Bit FB19.
	CAN_F18R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F18R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F18R2_FB20     = 0x100000   // Bit FB20.
	CAN_F18R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F18R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F18R2_FB21     = 0x200000   // Bit FB21.
	CAN_F18R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F18R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F18R2_FB22     = 0x400000   // Bit FB22.
	CAN_F18R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F18R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F18R2_FB23     = 0x800000   // Bit FB23.
	CAN_F18R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F18R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F18R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F18R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F18R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F18R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F18R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F18R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F18R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F18R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F18R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F18R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F18R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F18R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F18R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F18R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F18R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F18R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F18R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F18R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F18R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F18R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F18R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F18R2_FB31     = 0x80000000 // Bit FB31.

	// F19R1: Filter bank 19 register 1
	CAN_F19R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F19R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F19R1_FB0      = 0x1        // Bit FB0.
	CAN_F19R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F19R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F19R1_FB1      = 0x2        // Bit FB1.
	CAN_F19R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F19R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F19R1_FB2      = 0x4        // Bit FB2.
	CAN_F19R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F19R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F19R1_FB3      = 0x8        // Bit FB3.
	CAN_F19R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F19R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F19R1_FB4      = 0x10       // Bit FB4.
	CAN_F19R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F19R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F19R1_FB5      = 0x20       // Bit FB5.
	CAN_F19R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F19R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F19R1_FB6      = 0x40       // Bit FB6.
	CAN_F19R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F19R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F19R1_FB7      = 0x80       // Bit FB7.
	CAN_F19R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F19R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F19R1_FB8      = 0x100      // Bit FB8.
	CAN_F19R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F19R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F19R1_FB9      = 0x200      // Bit FB9.
	CAN_F19R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F19R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F19R1_FB10     = 0x400      // Bit FB10.
	CAN_F19R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F19R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F19R1_FB11     = 0x800      // Bit FB11.
	CAN_F19R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F19R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F19R1_FB12     = 0x1000     // Bit FB12.
	CAN_F19R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F19R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F19R1_FB13     = 0x2000     // Bit FB13.
	CAN_F19R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F19R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F19R1_FB14     = 0x4000     // Bit FB14.
	CAN_F19R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F19R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F19R1_FB15     = 0x8000     // Bit FB15.
	CAN_F19R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F19R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F19R1_FB16     = 0x10000    // Bit FB16.
	CAN_F19R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F19R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F19R1_FB17     = 0x20000    // Bit FB17.
	CAN_F19R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F19R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F19R1_FB18     = 0x40000    // Bit FB18.
	CAN_F19R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F19R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F19R1_FB19     = 0x80000    // Bit FB19.
	CAN_F19R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F19R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F19R1_FB20     = 0x100000   // Bit FB20.
	CAN_F19R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F19R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F19R1_FB21     = 0x200000   // Bit FB21.
	CAN_F19R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F19R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F19R1_FB22     = 0x400000   // Bit FB22.
	CAN_F19R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F19R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F19R1_FB23     = 0x800000   // Bit FB23.
	CAN_F19R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F19R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F19R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F19R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F19R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F19R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F19R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F19R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F19R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F19R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F19R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F19R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F19R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F19R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F19R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F19R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F19R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F19R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F19R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F19R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F19R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F19R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F19R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F19R1_FB31     = 0x80000000 // Bit FB31.

	// F19R2: Filter bank 19 register 2
	CAN_F19R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F19R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F19R2_FB0      = 0x1        // Bit FB0.
	CAN_F19R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F19R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F19R2_FB1      = 0x2        // Bit FB1.
	CAN_F19R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F19R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F19R2_FB2      = 0x4        // Bit FB2.
	CAN_F19R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F19R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F19R2_FB3      = 0x8        // Bit FB3.
	CAN_F19R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F19R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F19R2_FB4      = 0x10       // Bit FB4.
	CAN_F19R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F19R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F19R2_FB5      = 0x20       // Bit FB5.
	CAN_F19R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F19R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F19R2_FB6      = 0x40       // Bit FB6.
	CAN_F19R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F19R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F19R2_FB7      = 0x80       // Bit FB7.
	CAN_F19R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F19R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F19R2_FB8      = 0x100      // Bit FB8.
	CAN_F19R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F19R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F19R2_FB9      = 0x200      // Bit FB9.
	CAN_F19R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F19R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F19R2_FB10     = 0x400      // Bit FB10.
	CAN_F19R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F19R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F19R2_FB11     = 0x800      // Bit FB11.
	CAN_F19R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F19R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F19R2_FB12     = 0x1000     // Bit FB12.
	CAN_F19R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F19R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F19R2_FB13     = 0x2000     // Bit FB13.
	CAN_F19R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F19R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F19R2_FB14     = 0x4000     // Bit FB14.
	CAN_F19R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F19R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F19R2_FB15     = 0x8000     // Bit FB15.
	CAN_F19R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F19R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F19R2_FB16     = 0x10000    // Bit FB16.
	CAN_F19R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F19R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F19R2_FB17     = 0x20000    // Bit FB17.
	CAN_F19R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F19R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F19R2_FB18     = 0x40000    // Bit FB18.
	CAN_F19R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F19R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F19R2_FB19     = 0x80000    // Bit FB19.
	CAN_F19R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F19R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F19R2_FB20     = 0x100000   // Bit FB20.
	CAN_F19R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F19R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F19R2_FB21     = 0x200000   // Bit FB21.
	CAN_F19R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F19R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F19R2_FB22     = 0x400000   // Bit FB22.
	CAN_F19R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F19R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F19R2_FB23     = 0x800000   // Bit FB23.
	CAN_F19R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F19R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F19R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F19R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F19R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F19R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F19R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F19R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F19R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F19R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F19R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F19R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F19R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F19R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F19R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F19R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F19R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F19R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F19R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F19R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F19R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F19R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F19R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F19R2_FB31     = 0x80000000 // Bit FB31.

	// F20R1: Filter bank 20 register 1
	CAN_F20R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F20R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F20R1_FB0      = 0x1        // Bit FB0.
	CAN_F20R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F20R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F20R1_FB1      = 0x2        // Bit FB1.
	CAN_F20R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F20R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F20R1_FB2      = 0x4        // Bit FB2.
	CAN_F20R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F20R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F20R1_FB3      = 0x8        // Bit FB3.
	CAN_F20R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F20R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F20R1_FB4      = 0x10       // Bit FB4.
	CAN_F20R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F20R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F20R1_FB5      = 0x20       // Bit FB5.
	CAN_F20R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F20R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F20R1_FB6      = 0x40       // Bit FB6.
	CAN_F20R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F20R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F20R1_FB7      = 0x80       // Bit FB7.
	CAN_F20R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F20R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F20R1_FB8      = 0x100      // Bit FB8.
	CAN_F20R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F20R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F20R1_FB9      = 0x200      // Bit FB9.
	CAN_F20R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F20R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F20R1_FB10     = 0x400      // Bit FB10.
	CAN_F20R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F20R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F20R1_FB11     = 0x800      // Bit FB11.
	CAN_F20R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F20R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F20R1_FB12     = 0x1000     // Bit FB12.
	CAN_F20R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F20R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F20R1_FB13     = 0x2000     // Bit FB13.
	CAN_F20R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F20R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F20R1_FB14     = 0x4000     // Bit FB14.
	CAN_F20R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F20R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F20R1_FB15     = 0x8000     // Bit FB15.
	CAN_F20R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F20R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F20R1_FB16     = 0x10000    // Bit FB16.
	CAN_F20R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F20R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F20R1_FB17     = 0x20000    // Bit FB17.
	CAN_F20R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F20R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F20R1_FB18     = 0x40000    // Bit FB18.
	CAN_F20R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F20R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F20R1_FB19     = 0x80000    // Bit FB19.
	CAN_F20R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F20R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F20R1_FB20     = 0x100000   // Bit FB20.
	CAN_F20R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F20R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F20R1_FB21     = 0x200000   // Bit FB21.
	CAN_F20R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F20R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F20R1_FB22     = 0x400000   // Bit FB22.
	CAN_F20R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F20R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F20R1_FB23     = 0x800000   // Bit FB23.
	CAN_F20R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F20R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F20R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F20R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F20R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F20R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F20R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F20R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F20R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F20R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F20R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F20R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F20R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F20R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F20R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F20R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F20R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F20R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F20R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F20R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F20R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F20R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F20R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F20R1_FB31     = 0x80000000 // Bit FB31.

	// F20R2: Filter bank 20 register 2
	CAN_F20R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F20R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F20R2_FB0      = 0x1        // Bit FB0.
	CAN_F20R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F20R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F20R2_FB1      = 0x2        // Bit FB1.
	CAN_F20R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F20R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F20R2_FB2      = 0x4        // Bit FB2.
	CAN_F20R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F20R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F20R2_FB3      = 0x8        // Bit FB3.
	CAN_F20R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F20R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F20R2_FB4      = 0x10       // Bit FB4.
	CAN_F20R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F20R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F20R2_FB5      = 0x20       // Bit FB5.
	CAN_F20R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F20R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F20R2_FB6      = 0x40       // Bit FB6.
	CAN_F20R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F20R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F20R2_FB7      = 0x80       // Bit FB7.
	CAN_F20R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F20R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F20R2_FB8      = 0x100      // Bit FB8.
	CAN_F20R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F20R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F20R2_FB9      = 0x200      // Bit FB9.
	CAN_F20R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F20R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F20R2_FB10     = 0x400      // Bit FB10.
	CAN_F20R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F20R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F20R2_FB11     = 0x800      // Bit FB11.
	CAN_F20R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F20R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F20R2_FB12     = 0x1000     // Bit FB12.
	CAN_F20R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F20R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F20R2_FB13     = 0x2000     // Bit FB13.
	CAN_F20R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F20R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F20R2_FB14     = 0x4000     // Bit FB14.
	CAN_F20R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F20R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F20R2_FB15     = 0x8000     // Bit FB15.
	CAN_F20R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F20R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F20R2_FB16     = 0x10000    // Bit FB16.
	CAN_F20R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F20R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F20R2_FB17     = 0x20000    // Bit FB17.
	CAN_F20R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F20R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F20R2_FB18     = 0x40000    // Bit FB18.
	CAN_F20R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F20R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F20R2_FB19     = 0x80000    // Bit FB19.
	CAN_F20R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F20R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F20R2_FB20     = 0x100000   // Bit FB20.
	CAN_F20R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F20R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F20R2_FB21     = 0x200000   // Bit FB21.
	CAN_F20R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F20R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F20R2_FB22     = 0x400000   // Bit FB22.
	CAN_F20R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F20R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F20R2_FB23     = 0x800000   // Bit FB23.
	CAN_F20R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F20R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F20R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F20R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F20R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F20R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F20R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F20R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F20R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F20R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F20R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F20R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F20R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F20R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F20R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F20R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F20R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F20R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F20R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F20R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F20R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F20R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F20R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F20R2_FB31     = 0x80000000 // Bit FB31.

	// F21R1: Filter bank 21 register 1
	CAN_F21R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F21R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F21R1_FB0      = 0x1        // Bit FB0.
	CAN_F21R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F21R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F21R1_FB1      = 0x2        // Bit FB1.
	CAN_F21R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F21R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F21R1_FB2      = 0x4        // Bit FB2.
	CAN_F21R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F21R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F21R1_FB3      = 0x8        // Bit FB3.
	CAN_F21R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F21R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F21R1_FB4      = 0x10       // Bit FB4.
	CAN_F21R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F21R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F21R1_FB5      = 0x20       // Bit FB5.
	CAN_F21R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F21R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F21R1_FB6      = 0x40       // Bit FB6.
	CAN_F21R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F21R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F21R1_FB7      = 0x80       // Bit FB7.
	CAN_F21R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F21R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F21R1_FB8      = 0x100      // Bit FB8.
	CAN_F21R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F21R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F21R1_FB9      = 0x200      // Bit FB9.
	CAN_F21R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F21R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F21R1_FB10     = 0x400      // Bit FB10.
	CAN_F21R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F21R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F21R1_FB11     = 0x800      // Bit FB11.
	CAN_F21R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F21R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F21R1_FB12     = 0x1000     // Bit FB12.
	CAN_F21R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F21R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F21R1_FB13     = 0x2000     // Bit FB13.
	CAN_F21R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F21R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F21R1_FB14     = 0x4000     // Bit FB14.
	CAN_F21R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F21R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F21R1_FB15     = 0x8000     // Bit FB15.
	CAN_F21R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F21R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F21R1_FB16     = 0x10000    // Bit FB16.
	CAN_F21R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F21R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F21R1_FB17     = 0x20000    // Bit FB17.
	CAN_F21R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F21R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F21R1_FB18     = 0x40000    // Bit FB18.
	CAN_F21R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F21R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F21R1_FB19     = 0x80000    // Bit FB19.
	CAN_F21R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F21R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F21R1_FB20     = 0x100000   // Bit FB20.
	CAN_F21R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F21R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F21R1_FB21     = 0x200000   // Bit FB21.
	CAN_F21R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F21R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F21R1_FB22     = 0x400000   // Bit FB22.
	CAN_F21R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F21R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F21R1_FB23     = 0x800000   // Bit FB23.
	CAN_F21R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F21R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F21R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F21R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F21R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F21R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F21R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F21R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F21R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F21R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F21R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F21R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F21R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F21R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F21R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F21R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F21R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F21R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F21R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F21R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F21R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F21R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F21R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F21R1_FB31     = 0x80000000 // Bit FB31.

	// F21R2: Filter bank 21 register 2
	CAN_F21R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F21R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F21R2_FB0      = 0x1        // Bit FB0.
	CAN_F21R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F21R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F21R2_FB1      = 0x2        // Bit FB1.
	CAN_F21R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F21R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F21R2_FB2      = 0x4        // Bit FB2.
	CAN_F21R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F21R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F21R2_FB3      = 0x8        // Bit FB3.
	CAN_F21R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F21R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F21R2_FB4      = 0x10       // Bit FB4.
	CAN_F21R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F21R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F21R2_FB5      = 0x20       // Bit FB5.
	CAN_F21R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F21R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F21R2_FB6      = 0x40       // Bit FB6.
	CAN_F21R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F21R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F21R2_FB7      = 0x80       // Bit FB7.
	CAN_F21R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F21R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F21R2_FB8      = 0x100      // Bit FB8.
	CAN_F21R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F21R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F21R2_FB9      = 0x200      // Bit FB9.
	CAN_F21R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F21R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F21R2_FB10     = 0x400      // Bit FB10.
	CAN_F21R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F21R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F21R2_FB11     = 0x800      // Bit FB11.
	CAN_F21R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F21R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F21R2_FB12     = 0x1000     // Bit FB12.
	CAN_F21R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F21R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F21R2_FB13     = 0x2000     // Bit FB13.
	CAN_F21R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F21R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F21R2_FB14     = 0x4000     // Bit FB14.
	CAN_F21R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F21R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F21R2_FB15     = 0x8000     // Bit FB15.
	CAN_F21R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F21R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F21R2_FB16     = 0x10000    // Bit FB16.
	CAN_F21R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F21R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F21R2_FB17     = 0x20000    // Bit FB17.
	CAN_F21R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F21R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F21R2_FB18     = 0x40000    // Bit FB18.
	CAN_F21R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F21R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F21R2_FB19     = 0x80000    // Bit FB19.
	CAN_F21R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F21R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F21R2_FB20     = 0x100000   // Bit FB20.
	CAN_F21R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F21R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F21R2_FB21     = 0x200000   // Bit FB21.
	CAN_F21R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F21R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F21R2_FB22     = 0x400000   // Bit FB22.
	CAN_F21R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F21R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F21R2_FB23     = 0x800000   // Bit FB23.
	CAN_F21R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F21R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F21R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F21R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F21R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F21R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F21R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F21R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F21R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F21R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F21R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F21R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F21R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F21R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F21R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F21R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F21R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F21R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F21R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F21R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F21R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F21R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F21R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F21R2_FB31     = 0x80000000 // Bit FB31.

	// F22R1: Filter bank 22 register 1
	CAN_F22R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F22R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F22R1_FB0      = 0x1        // Bit FB0.
	CAN_F22R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F22R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F22R1_FB1      = 0x2        // Bit FB1.
	CAN_F22R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F22R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F22R1_FB2      = 0x4        // Bit FB2.
	CAN_F22R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F22R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F22R1_FB3      = 0x8        // Bit FB3.
	CAN_F22R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F22R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F22R1_FB4      = 0x10       // Bit FB4.
	CAN_F22R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F22R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F22R1_FB5      = 0x20       // Bit FB5.
	CAN_F22R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F22R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F22R1_FB6      = 0x40       // Bit FB6.
	CAN_F22R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F22R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F22R1_FB7      = 0x80       // Bit FB7.
	CAN_F22R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F22R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F22R1_FB8      = 0x100      // Bit FB8.
	CAN_F22R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F22R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F22R1_FB9      = 0x200      // Bit FB9.
	CAN_F22R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F22R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F22R1_FB10     = 0x400      // Bit FB10.
	CAN_F22R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F22R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F22R1_FB11     = 0x800      // Bit FB11.
	CAN_F22R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F22R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F22R1_FB12     = 0x1000     // Bit FB12.
	CAN_F22R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F22R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F22R1_FB13     = 0x2000     // Bit FB13.
	CAN_F22R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F22R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F22R1_FB14     = 0x4000     // Bit FB14.
	CAN_F22R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F22R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F22R1_FB15     = 0x8000     // Bit FB15.
	CAN_F22R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F22R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F22R1_FB16     = 0x10000    // Bit FB16.
	CAN_F22R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F22R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F22R1_FB17     = 0x20000    // Bit FB17.
	CAN_F22R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F22R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F22R1_FB18     = 0x40000    // Bit FB18.
	CAN_F22R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F22R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F22R1_FB19     = 0x80000    // Bit FB19.
	CAN_F22R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F22R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F22R1_FB20     = 0x100000   // Bit FB20.
	CAN_F22R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F22R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F22R1_FB21     = 0x200000   // Bit FB21.
	CAN_F22R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F22R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F22R1_FB22     = 0x400000   // Bit FB22.
	CAN_F22R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F22R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F22R1_FB23     = 0x800000   // Bit FB23.
	CAN_F22R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F22R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F22R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F22R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F22R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F22R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F22R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F22R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F22R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F22R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F22R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F22R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F22R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F22R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F22R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F22R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F22R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F22R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F22R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F22R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F22R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F22R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F22R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F22R1_FB31     = 0x80000000 // Bit FB31.

	// F22R2: Filter bank 22 register 2
	CAN_F22R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F22R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F22R2_FB0      = 0x1        // Bit FB0.
	CAN_F22R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F22R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F22R2_FB1      = 0x2        // Bit FB1.
	CAN_F22R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F22R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F22R2_FB2      = 0x4        // Bit FB2.
	CAN_F22R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F22R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F22R2_FB3      = 0x8        // Bit FB3.
	CAN_F22R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F22R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F22R2_FB4      = 0x10       // Bit FB4.
	CAN_F22R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F22R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F22R2_FB5      = 0x20       // Bit FB5.
	CAN_F22R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F22R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F22R2_FB6      = 0x40       // Bit FB6.
	CAN_F22R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F22R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F22R2_FB7      = 0x80       // Bit FB7.
	CAN_F22R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F22R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F22R2_FB8      = 0x100      // Bit FB8.
	CAN_F22R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F22R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F22R2_FB9      = 0x200      // Bit FB9.
	CAN_F22R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F22R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F22R2_FB10     = 0x400      // Bit FB10.
	CAN_F22R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F22R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F22R2_FB11     = 0x800      // Bit FB11.
	CAN_F22R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F22R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F22R2_FB12     = 0x1000     // Bit FB12.
	CAN_F22R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F22R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F22R2_FB13     = 0x2000     // Bit FB13.
	CAN_F22R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F22R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F22R2_FB14     = 0x4000     // Bit FB14.
	CAN_F22R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F22R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F22R2_FB15     = 0x8000     // Bit FB15.
	CAN_F22R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F22R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F22R2_FB16     = 0x10000    // Bit FB16.
	CAN_F22R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F22R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F22R2_FB17     = 0x20000    // Bit FB17.
	CAN_F22R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F22R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F22R2_FB18     = 0x40000    // Bit FB18.
	CAN_F22R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F22R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F22R2_FB19     = 0x80000    // Bit FB19.
	CAN_F22R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F22R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F22R2_FB20     = 0x100000   // Bit FB20.
	CAN_F22R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F22R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F22R2_FB21     = 0x200000   // Bit FB21.
	CAN_F22R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F22R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F22R2_FB22     = 0x400000   // Bit FB22.
	CAN_F22R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F22R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F22R2_FB23     = 0x800000   // Bit FB23.
	CAN_F22R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F22R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F22R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F22R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F22R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F22R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F22R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F22R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F22R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F22R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F22R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F22R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F22R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F22R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F22R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F22R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F22R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F22R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F22R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F22R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F22R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F22R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F22R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F22R2_FB31     = 0x80000000 // Bit FB31.

	// F23R1: Filter bank 23 register 1
	CAN_F23R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F23R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F23R1_FB0      = 0x1        // Bit FB0.
	CAN_F23R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F23R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F23R1_FB1      = 0x2        // Bit FB1.
	CAN_F23R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F23R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F23R1_FB2      = 0x4        // Bit FB2.
	CAN_F23R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F23R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F23R1_FB3      = 0x8        // Bit FB3.
	CAN_F23R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F23R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F23R1_FB4      = 0x10       // Bit FB4.
	CAN_F23R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F23R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F23R1_FB5      = 0x20       // Bit FB5.
	CAN_F23R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F23R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F23R1_FB6      = 0x40       // Bit FB6.
	CAN_F23R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F23R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F23R1_FB7      = 0x80       // Bit FB7.
	CAN_F23R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F23R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F23R1_FB8      = 0x100      // Bit FB8.
	CAN_F23R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F23R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F23R1_FB9      = 0x200      // Bit FB9.
	CAN_F23R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F23R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F23R1_FB10     = 0x400      // Bit FB10.
	CAN_F23R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F23R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F23R1_FB11     = 0x800      // Bit FB11.
	CAN_F23R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F23R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F23R1_FB12     = 0x1000     // Bit FB12.
	CAN_F23R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F23R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F23R1_FB13     = 0x2000     // Bit FB13.
	CAN_F23R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F23R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F23R1_FB14     = 0x4000     // Bit FB14.
	CAN_F23R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F23R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F23R1_FB15     = 0x8000     // Bit FB15.
	CAN_F23R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F23R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F23R1_FB16     = 0x10000    // Bit FB16.
	CAN_F23R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F23R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F23R1_FB17     = 0x20000    // Bit FB17.
	CAN_F23R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F23R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F23R1_FB18     = 0x40000    // Bit FB18.
	CAN_F23R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F23R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F23R1_FB19     = 0x80000    // Bit FB19.
	CAN_F23R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F23R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F23R1_FB20     = 0x100000   // Bit FB20.
	CAN_F23R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F23R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F23R1_FB21     = 0x200000   // Bit FB21.
	CAN_F23R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F23R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F23R1_FB22     = 0x400000   // Bit FB22.
	CAN_F23R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F23R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F23R1_FB23     = 0x800000   // Bit FB23.
	CAN_F23R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F23R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F23R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F23R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F23R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F23R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F23R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F23R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F23R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F23R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F23R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F23R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F23R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F23R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F23R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F23R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F23R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F23R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F23R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F23R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F23R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F23R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F23R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F23R1_FB31     = 0x80000000 // Bit FB31.

	// F23R2: Filter bank 23 register 2
	CAN_F23R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F23R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F23R2_FB0      = 0x1        // Bit FB0.
	CAN_F23R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F23R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F23R2_FB1      = 0x2        // Bit FB1.
	CAN_F23R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F23R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F23R2_FB2      = 0x4        // Bit FB2.
	CAN_F23R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F23R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F23R2_FB3      = 0x8        // Bit FB3.
	CAN_F23R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F23R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F23R2_FB4      = 0x10       // Bit FB4.
	CAN_F23R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F23R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F23R2_FB5      = 0x20       // Bit FB5.
	CAN_F23R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F23R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F23R2_FB6      = 0x40       // Bit FB6.
	CAN_F23R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F23R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F23R2_FB7      = 0x80       // Bit FB7.
	CAN_F23R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F23R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F23R2_FB8      = 0x100      // Bit FB8.
	CAN_F23R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F23R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F23R2_FB9      = 0x200      // Bit FB9.
	CAN_F23R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F23R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F23R2_FB10     = 0x400      // Bit FB10.
	CAN_F23R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F23R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F23R2_FB11     = 0x800      // Bit FB11.
	CAN_F23R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F23R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F23R2_FB12     = 0x1000     // Bit FB12.
	CAN_F23R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F23R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F23R2_FB13     = 0x2000     // Bit FB13.
	CAN_F23R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F23R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F23R2_FB14     = 0x4000     // Bit FB14.
	CAN_F23R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F23R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F23R2_FB15     = 0x8000     // Bit FB15.
	CAN_F23R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F23R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F23R2_FB16     = 0x10000    // Bit FB16.
	CAN_F23R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F23R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F23R2_FB17     = 0x20000    // Bit FB17.
	CAN_F23R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F23R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F23R2_FB18     = 0x40000    // Bit FB18.
	CAN_F23R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F23R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F23R2_FB19     = 0x80000    // Bit FB19.
	CAN_F23R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F23R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F23R2_FB20     = 0x100000   // Bit FB20.
	CAN_F23R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F23R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F23R2_FB21     = 0x200000   // Bit FB21.
	CAN_F23R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F23R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F23R2_FB22     = 0x400000   // Bit FB22.
	CAN_F23R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F23R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F23R2_FB23     = 0x800000   // Bit FB23.
	CAN_F23R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F23R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F23R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F23R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F23R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F23R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F23R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F23R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F23R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F23R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F23R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F23R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F23R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F23R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F23R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F23R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F23R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F23R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F23R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F23R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F23R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F23R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F23R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F23R2_FB31     = 0x80000000 // Bit FB31.

	// F24R1: Filter bank 24 register 1
	CAN_F24R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F24R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F24R1_FB0      = 0x1        // Bit FB0.
	CAN_F24R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F24R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F24R1_FB1      = 0x2        // Bit FB1.
	CAN_F24R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F24R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F24R1_FB2      = 0x4        // Bit FB2.
	CAN_F24R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F24R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F24R1_FB3      = 0x8        // Bit FB3.
	CAN_F24R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F24R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F24R1_FB4      = 0x10       // Bit FB4.
	CAN_F24R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F24R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F24R1_FB5      = 0x20       // Bit FB5.
	CAN_F24R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F24R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F24R1_FB6      = 0x40       // Bit FB6.
	CAN_F24R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F24R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F24R1_FB7      = 0x80       // Bit FB7.
	CAN_F24R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F24R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F24R1_FB8      = 0x100      // Bit FB8.
	CAN_F24R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F24R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F24R1_FB9      = 0x200      // Bit FB9.
	CAN_F24R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F24R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F24R1_FB10     = 0x400      // Bit FB10.
	CAN_F24R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F24R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F24R1_FB11     = 0x800      // Bit FB11.
	CAN_F24R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F24R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F24R1_FB12     = 0x1000     // Bit FB12.
	CAN_F24R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F24R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F24R1_FB13     = 0x2000     // Bit FB13.
	CAN_F24R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F24R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F24R1_FB14     = 0x4000     // Bit FB14.
	CAN_F24R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F24R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F24R1_FB15     = 0x8000     // Bit FB15.
	CAN_F24R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F24R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F24R1_FB16     = 0x10000    // Bit FB16.
	CAN_F24R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F24R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F24R1_FB17     = 0x20000    // Bit FB17.
	CAN_F24R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F24R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F24R1_FB18     = 0x40000    // Bit FB18.
	CAN_F24R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F24R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F24R1_FB19     = 0x80000    // Bit FB19.
	CAN_F24R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F24R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F24R1_FB20     = 0x100000   // Bit FB20.
	CAN_F24R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F24R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F24R1_FB21     = 0x200000   // Bit FB21.
	CAN_F24R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F24R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F24R1_FB22     = 0x400000   // Bit FB22.
	CAN_F24R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F24R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F24R1_FB23     = 0x800000   // Bit FB23.
	CAN_F24R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F24R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F24R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F24R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F24R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F24R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F24R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F24R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F24R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F24R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F24R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F24R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F24R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F24R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F24R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F24R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F24R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F24R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F24R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F24R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F24R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F24R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F24R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F24R1_FB31     = 0x80000000 // Bit FB31.

	// F24R2: Filter bank 24 register 2
	CAN_F24R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F24R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F24R2_FB0      = 0x1        // Bit FB0.
	CAN_F24R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F24R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F24R2_FB1      = 0x2        // Bit FB1.
	CAN_F24R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F24R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F24R2_FB2      = 0x4        // Bit FB2.
	CAN_F24R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F24R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F24R2_FB3      = 0x8        // Bit FB3.
	CAN_F24R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F24R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F24R2_FB4      = 0x10       // Bit FB4.
	CAN_F24R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F24R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F24R2_FB5      = 0x20       // Bit FB5.
	CAN_F24R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F24R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F24R2_FB6      = 0x40       // Bit FB6.
	CAN_F24R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F24R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F24R2_FB7      = 0x80       // Bit FB7.
	CAN_F24R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F24R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F24R2_FB8      = 0x100      // Bit FB8.
	CAN_F24R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F24R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F24R2_FB9      = 0x200      // Bit FB9.
	CAN_F24R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F24R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F24R2_FB10     = 0x400      // Bit FB10.
	CAN_F24R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F24R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F24R2_FB11     = 0x800      // Bit FB11.
	CAN_F24R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F24R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F24R2_FB12     = 0x1000     // Bit FB12.
	CAN_F24R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F24R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F24R2_FB13     = 0x2000     // Bit FB13.
	CAN_F24R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F24R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F24R2_FB14     = 0x4000     // Bit FB14.
	CAN_F24R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F24R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F24R2_FB15     = 0x8000     // Bit FB15.
	CAN_F24R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F24R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F24R2_FB16     = 0x10000    // Bit FB16.
	CAN_F24R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F24R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F24R2_FB17     = 0x20000    // Bit FB17.
	CAN_F24R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F24R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F24R2_FB18     = 0x40000    // Bit FB18.
	CAN_F24R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F24R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F24R2_FB19     = 0x80000    // Bit FB19.
	CAN_F24R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F24R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F24R2_FB20     = 0x100000   // Bit FB20.
	CAN_F24R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F24R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F24R2_FB21     = 0x200000   // Bit FB21.
	CAN_F24R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F24R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F24R2_FB22     = 0x400000   // Bit FB22.
	CAN_F24R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F24R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F24R2_FB23     = 0x800000   // Bit FB23.
	CAN_F24R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F24R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F24R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F24R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F24R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F24R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F24R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F24R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F24R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F24R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F24R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F24R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F24R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F24R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F24R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F24R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F24R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F24R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F24R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F24R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F24R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F24R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F24R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F24R2_FB31     = 0x80000000 // Bit FB31.

	// F25R1: Filter bank 25 register 1
	CAN_F25R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F25R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F25R1_FB0      = 0x1        // Bit FB0.
	CAN_F25R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F25R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F25R1_FB1      = 0x2        // Bit FB1.
	CAN_F25R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F25R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F25R1_FB2      = 0x4        // Bit FB2.
	CAN_F25R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F25R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F25R1_FB3      = 0x8        // Bit FB3.
	CAN_F25R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F25R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F25R1_FB4      = 0x10       // Bit FB4.
	CAN_F25R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F25R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F25R1_FB5      = 0x20       // Bit FB5.
	CAN_F25R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F25R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F25R1_FB6      = 0x40       // Bit FB6.
	CAN_F25R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F25R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F25R1_FB7      = 0x80       // Bit FB7.
	CAN_F25R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F25R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F25R1_FB8      = 0x100      // Bit FB8.
	CAN_F25R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F25R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F25R1_FB9      = 0x200      // Bit FB9.
	CAN_F25R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F25R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F25R1_FB10     = 0x400      // Bit FB10.
	CAN_F25R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F25R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F25R1_FB11     = 0x800      // Bit FB11.
	CAN_F25R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F25R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F25R1_FB12     = 0x1000     // Bit FB12.
	CAN_F25R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F25R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F25R1_FB13     = 0x2000     // Bit FB13.
	CAN_F25R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F25R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F25R1_FB14     = 0x4000     // Bit FB14.
	CAN_F25R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F25R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F25R1_FB15     = 0x8000     // Bit FB15.
	CAN_F25R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F25R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F25R1_FB16     = 0x10000    // Bit FB16.
	CAN_F25R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F25R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F25R1_FB17     = 0x20000    // Bit FB17.
	CAN_F25R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F25R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F25R1_FB18     = 0x40000    // Bit FB18.
	CAN_F25R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F25R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F25R1_FB19     = 0x80000    // Bit FB19.
	CAN_F25R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F25R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F25R1_FB20     = 0x100000   // Bit FB20.
	CAN_F25R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F25R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F25R1_FB21     = 0x200000   // Bit FB21.
	CAN_F25R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F25R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F25R1_FB22     = 0x400000   // Bit FB22.
	CAN_F25R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F25R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F25R1_FB23     = 0x800000   // Bit FB23.
	CAN_F25R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F25R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F25R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F25R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F25R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F25R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F25R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F25R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F25R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F25R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F25R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F25R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F25R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F25R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F25R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F25R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F25R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F25R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F25R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F25R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F25R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F25R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F25R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F25R1_FB31     = 0x80000000 // Bit FB31.

	// F25R2: Filter bank 25 register 2
	CAN_F25R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F25R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F25R2_FB0      = 0x1        // Bit FB0.
	CAN_F25R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F25R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F25R2_FB1      = 0x2        // Bit FB1.
	CAN_F25R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F25R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F25R2_FB2      = 0x4        // Bit FB2.
	CAN_F25R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F25R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F25R2_FB3      = 0x8        // Bit FB3.
	CAN_F25R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F25R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F25R2_FB4      = 0x10       // Bit FB4.
	CAN_F25R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F25R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F25R2_FB5      = 0x20       // Bit FB5.
	CAN_F25R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F25R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F25R2_FB6      = 0x40       // Bit FB6.
	CAN_F25R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F25R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F25R2_FB7      = 0x80       // Bit FB7.
	CAN_F25R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F25R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F25R2_FB8      = 0x100      // Bit FB8.
	CAN_F25R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F25R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F25R2_FB9      = 0x200      // Bit FB9.
	CAN_F25R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F25R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F25R2_FB10     = 0x400      // Bit FB10.
	CAN_F25R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F25R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F25R2_FB11     = 0x800      // Bit FB11.
	CAN_F25R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F25R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F25R2_FB12     = 0x1000     // Bit FB12.
	CAN_F25R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F25R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F25R2_FB13     = 0x2000     // Bit FB13.
	CAN_F25R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F25R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F25R2_FB14     = 0x4000     // Bit FB14.
	CAN_F25R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F25R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F25R2_FB15     = 0x8000     // Bit FB15.
	CAN_F25R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F25R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F25R2_FB16     = 0x10000    // Bit FB16.
	CAN_F25R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F25R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F25R2_FB17     = 0x20000    // Bit FB17.
	CAN_F25R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F25R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F25R2_FB18     = 0x40000    // Bit FB18.
	CAN_F25R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F25R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F25R2_FB19     = 0x80000    // Bit FB19.
	CAN_F25R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F25R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F25R2_FB20     = 0x100000   // Bit FB20.
	CAN_F25R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F25R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F25R2_FB21     = 0x200000   // Bit FB21.
	CAN_F25R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F25R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F25R2_FB22     = 0x400000   // Bit FB22.
	CAN_F25R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F25R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F25R2_FB23     = 0x800000   // Bit FB23.
	CAN_F25R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F25R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F25R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F25R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F25R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F25R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F25R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F25R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F25R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F25R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F25R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F25R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F25R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F25R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F25R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F25R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F25R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F25R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F25R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F25R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F25R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F25R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F25R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F25R2_FB31     = 0x80000000 // Bit FB31.

	// F26R1: Filter bank 26 register 1
	CAN_F26R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F26R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F26R1_FB0      = 0x1        // Bit FB0.
	CAN_F26R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F26R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F26R1_FB1      = 0x2        // Bit FB1.
	CAN_F26R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F26R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F26R1_FB2      = 0x4        // Bit FB2.
	CAN_F26R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F26R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F26R1_FB3      = 0x8        // Bit FB3.
	CAN_F26R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F26R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F26R1_FB4      = 0x10       // Bit FB4.
	CAN_F26R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F26R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F26R1_FB5      = 0x20       // Bit FB5.
	CAN_F26R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F26R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F26R1_FB6      = 0x40       // Bit FB6.
	CAN_F26R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F26R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F26R1_FB7      = 0x80       // Bit FB7.
	CAN_F26R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F26R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F26R1_FB8      = 0x100      // Bit FB8.
	CAN_F26R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F26R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F26R1_FB9      = 0x200      // Bit FB9.
	CAN_F26R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F26R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F26R1_FB10     = 0x400      // Bit FB10.
	CAN_F26R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F26R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F26R1_FB11     = 0x800      // Bit FB11.
	CAN_F26R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F26R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F26R1_FB12     = 0x1000     // Bit FB12.
	CAN_F26R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F26R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F26R1_FB13     = 0x2000     // Bit FB13.
	CAN_F26R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F26R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F26R1_FB14     = 0x4000     // Bit FB14.
	CAN_F26R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F26R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F26R1_FB15     = 0x8000     // Bit FB15.
	CAN_F26R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F26R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F26R1_FB16     = 0x10000    // Bit FB16.
	CAN_F26R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F26R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F26R1_FB17     = 0x20000    // Bit FB17.
	CAN_F26R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F26R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F26R1_FB18     = 0x40000    // Bit FB18.
	CAN_F26R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F26R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F26R1_FB19     = 0x80000    // Bit FB19.
	CAN_F26R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F26R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F26R1_FB20     = 0x100000   // Bit FB20.
	CAN_F26R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F26R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F26R1_FB21     = 0x200000   // Bit FB21.
	CAN_F26R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F26R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F26R1_FB22     = 0x400000   // Bit FB22.
	CAN_F26R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F26R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F26R1_FB23     = 0x800000   // Bit FB23.
	CAN_F26R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F26R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F26R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F26R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F26R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F26R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F26R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F26R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F26R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F26R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F26R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F26R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F26R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F26R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F26R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F26R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F26R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F26R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F26R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F26R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F26R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F26R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F26R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F26R1_FB31     = 0x80000000 // Bit FB31.

	// F26R2: Filter bank 26 register 2
	CAN_F26R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F26R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F26R2_FB0      = 0x1        // Bit FB0.
	CAN_F26R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F26R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F26R2_FB1      = 0x2        // Bit FB1.
	CAN_F26R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F26R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F26R2_FB2      = 0x4        // Bit FB2.
	CAN_F26R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F26R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F26R2_FB3      = 0x8        // Bit FB3.
	CAN_F26R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F26R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F26R2_FB4      = 0x10       // Bit FB4.
	CAN_F26R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F26R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F26R2_FB5      = 0x20       // Bit FB5.
	CAN_F26R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F26R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F26R2_FB6      = 0x40       // Bit FB6.
	CAN_F26R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F26R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F26R2_FB7      = 0x80       // Bit FB7.
	CAN_F26R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F26R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F26R2_FB8      = 0x100      // Bit FB8.
	CAN_F26R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F26R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F26R2_FB9      = 0x200      // Bit FB9.
	CAN_F26R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F26R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F26R2_FB10     = 0x400      // Bit FB10.
	CAN_F26R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F26R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F26R2_FB11     = 0x800      // Bit FB11.
	CAN_F26R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F26R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F26R2_FB12     = 0x1000     // Bit FB12.
	CAN_F26R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F26R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F26R2_FB13     = 0x2000     // Bit FB13.
	CAN_F26R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F26R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F26R2_FB14     = 0x4000     // Bit FB14.
	CAN_F26R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F26R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F26R2_FB15     = 0x8000     // Bit FB15.
	CAN_F26R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F26R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F26R2_FB16     = 0x10000    // Bit FB16.
	CAN_F26R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F26R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F26R2_FB17     = 0x20000    // Bit FB17.
	CAN_F26R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F26R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F26R2_FB18     = 0x40000    // Bit FB18.
	CAN_F26R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F26R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F26R2_FB19     = 0x80000    // Bit FB19.
	CAN_F26R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F26R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F26R2_FB20     = 0x100000   // Bit FB20.
	CAN_F26R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F26R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F26R2_FB21     = 0x200000   // Bit FB21.
	CAN_F26R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F26R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F26R2_FB22     = 0x400000   // Bit FB22.
	CAN_F26R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F26R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F26R2_FB23     = 0x800000   // Bit FB23.
	CAN_F26R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F26R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F26R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F26R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F26R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F26R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F26R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F26R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F26R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F26R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F26R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F26R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F26R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F26R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F26R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F26R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F26R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F26R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F26R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F26R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F26R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F26R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F26R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F26R2_FB31     = 0x80000000 // Bit FB31.

	// F27R1: Filter bank 27 register 1
	CAN_F27R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F27R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F27R1_FB0      = 0x1        // Bit FB0.
	CAN_F27R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F27R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F27R1_FB1      = 0x2        // Bit FB1.
	CAN_F27R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F27R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F27R1_FB2      = 0x4        // Bit FB2.
	CAN_F27R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F27R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F27R1_FB3      = 0x8        // Bit FB3.
	CAN_F27R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F27R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F27R1_FB4      = 0x10       // Bit FB4.
	CAN_F27R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F27R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F27R1_FB5      = 0x20       // Bit FB5.
	CAN_F27R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F27R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F27R1_FB6      = 0x40       // Bit FB6.
	CAN_F27R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F27R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F27R1_FB7      = 0x80       // Bit FB7.
	CAN_F27R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F27R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F27R1_FB8      = 0x100      // Bit FB8.
	CAN_F27R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F27R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F27R1_FB9      = 0x200      // Bit FB9.
	CAN_F27R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F27R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F27R1_FB10     = 0x400      // Bit FB10.
	CAN_F27R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F27R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F27R1_FB11     = 0x800      // Bit FB11.
	CAN_F27R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F27R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F27R1_FB12     = 0x1000     // Bit FB12.
	CAN_F27R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F27R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F27R1_FB13     = 0x2000     // Bit FB13.
	CAN_F27R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F27R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F27R1_FB14     = 0x4000     // Bit FB14.
	CAN_F27R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F27R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F27R1_FB15     = 0x8000     // Bit FB15.
	CAN_F27R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F27R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F27R1_FB16     = 0x10000    // Bit FB16.
	CAN_F27R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F27R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F27R1_FB17     = 0x20000    // Bit FB17.
	CAN_F27R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F27R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F27R1_FB18     = 0x40000    // Bit FB18.
	CAN_F27R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F27R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F27R1_FB19     = 0x80000    // Bit FB19.
	CAN_F27R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F27R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F27R1_FB20     = 0x100000   // Bit FB20.
	CAN_F27R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F27R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F27R1_FB21     = 0x200000   // Bit FB21.
	CAN_F27R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F27R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F27R1_FB22     = 0x400000   // Bit FB22.
	CAN_F27R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F27R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F27R1_FB23     = 0x800000   // Bit FB23.
	CAN_F27R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F27R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F27R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F27R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F27R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F27R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F27R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F27R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F27R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F27R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F27R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F27R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F27R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F27R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F27R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F27R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F27R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F27R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F27R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F27R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F27R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F27R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F27R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F27R1_FB31     = 0x80000000 // Bit FB31.

	// F27R2: Filter bank 27 register 2
	CAN_F27R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F27R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F27R2_FB0      = 0x1        // Bit FB0.
	CAN_F27R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F27R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F27R2_FB1      = 0x2        // Bit FB1.
	CAN_F27R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F27R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F27R2_FB2      = 0x4        // Bit FB2.
	CAN_F27R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F27R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F27R2_FB3      = 0x8        // Bit FB3.
	CAN_F27R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F27R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F27R2_FB4      = 0x10       // Bit FB4.
	CAN_F27R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F27R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F27R2_FB5      = 0x20       // Bit FB5.
	CAN_F27R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F27R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F27R2_FB6      = 0x40       // Bit FB6.
	CAN_F27R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F27R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F27R2_FB7      = 0x80       // Bit FB7.
	CAN_F27R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F27R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F27R2_FB8      = 0x100      // Bit FB8.
	CAN_F27R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F27R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F27R2_FB9      = 0x200      // Bit FB9.
	CAN_F27R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F27R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F27R2_FB10     = 0x400      // Bit FB10.
	CAN_F27R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F27R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F27R2_FB11     = 0x800      // Bit FB11.
	CAN_F27R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F27R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F27R2_FB12     = 0x1000     // Bit FB12.
	CAN_F27R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F27R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F27R2_FB13     = 0x2000     // Bit FB13.
	CAN_F27R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F27R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F27R2_FB14     = 0x4000     // Bit FB14.
	CAN_F27R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F27R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F27R2_FB15     = 0x8000     // Bit FB15.
	CAN_F27R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F27R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F27R2_FB16     = 0x10000    // Bit FB16.
	CAN_F27R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F27R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F27R2_FB17     = 0x20000    // Bit FB17.
	CAN_F27R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F27R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F27R2_FB18     = 0x40000    // Bit FB18.
	CAN_F27R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F27R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F27R2_FB19     = 0x80000    // Bit FB19.
	CAN_F27R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F27R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F27R2_FB20     = 0x100000   // Bit FB20.
	CAN_F27R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F27R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F27R2_FB21     = 0x200000   // Bit FB21.
	CAN_F27R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F27R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F27R2_FB22     = 0x400000   // Bit FB22.
	CAN_F27R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F27R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F27R2_FB23     = 0x800000   // Bit FB23.
	CAN_F27R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F27R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F27R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F27R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F27R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F27R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F27R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F27R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F27R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F27R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F27R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F27R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F27R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F27R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F27R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F27R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F27R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F27R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F27R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F27R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F27R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F27R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F27R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F27R2_FB31     = 0x80000000 // Bit FB31.
)

// Bitfields for Flash: FLASH
const (
	// ACR: Flash access control register
	FLASH_ACR_LATENCY_Pos = 0x0   // Position of LATENCY field.
	FLASH_ACR_LATENCY_Msk = 0xf   // Bit mask of LATENCY field.
	FLASH_ACR_PRFTEN_Pos  = 0x8   // Position of PRFTEN field.
	FLASH_ACR_PRFTEN_Msk  = 0x100 // Bit mask of PRFTEN field.
	FLASH_ACR_PRFTEN      = 0x100 // Bit PRFTEN.
	FLASH_ACR_ARTEN_Pos   = 0x9   // Position of ARTEN field.
	FLASH_ACR_ARTEN_Msk   = 0x200 // Bit mask of ARTEN field.
	FLASH_ACR_ARTEN       = 0x200 // Bit ARTEN.
	FLASH_ACR_ARTRST_Pos  = 0xb   // Position of ARTRST field.
	FLASH_ACR_ARTRST_Msk  = 0x800 // Bit mask of ARTRST field.
	FLASH_ACR_ARTRST      = 0x800 // Bit ARTRST.

	// KEYR: Flash key register
	FLASH_KEYR_KEY_Pos = 0x0        // Position of KEY field.
	FLASH_KEYR_KEY_Msk = 0xffffffff // Bit mask of KEY field.

	// OPTKEYR: Flash option key register
	FLASH_OPTKEYR_OPTKEY_Pos = 0x0        // Position of OPTKEY field.
	FLASH_OPTKEYR_OPTKEY_Msk = 0xffffffff // Bit mask of OPTKEY field.

	// SR: Status register
	FLASH_SR_EOP_Pos    = 0x0     // Position of EOP field.
	FLASH_SR_EOP_Msk    = 0x1     // Bit mask of EOP field.
	FLASH_SR_EOP        = 0x1     // Bit EOP.
	FLASH_SR_OPERR_Pos  = 0x1     // Position of OPERR field.
	FLASH_SR_OPERR_Msk  = 0x2     // Bit mask of OPERR field.
	FLASH_SR_OPERR      = 0x2     // Bit OPERR.
	FLASH_SR_WRPERR_Pos = 0x4     // Position of WRPERR field.
	FLASH_SR_WRPERR_Msk = 0x10    // Bit mask of WRPERR field.
	FLASH_SR_WRPERR     = 0x10    // Bit WRPERR.
	FLASH_SR_PGAERR_Pos = 0x5     // Position of PGAERR field.
	FLASH_SR_PGAERR_Msk = 0x20    // Bit mask of PGAERR field.
	FLASH_SR_PGAERR     = 0x20    // Bit PGAERR.
	FLASH_SR_PGPERR_Pos = 0x6     // Position of PGPERR field.
	FLASH_SR_PGPERR_Msk = 0x40    // Bit mask of PGPERR field.
	FLASH_SR_PGPERR     = 0x40    // Bit PGPERR.
	FLASH_SR_ERSERR_Pos = 0x7     // Position of ERSERR field.
	FLASH_SR_ERSERR_Msk = 0x80    // Bit mask of ERSERR field.
	FLASH_SR_ERSERR     = 0x80    // Bit ERSERR.
	FLASH_SR_BSY_Pos    = 0x10    // Position of BSY field.
	FLASH_SR_BSY_Msk    = 0x10000 // Bit mask of BSY field.
	FLASH_SR_BSY        = 0x10000 // Bit BSY.

	// CR: Control register
	FLASH_CR_PG_Pos    = 0x0        // Position of PG field.
	FLASH_CR_PG_Msk    = 0x1        // Bit mask of PG field.
	FLASH_CR_PG        = 0x1        // Bit PG.
	FLASH_CR_SER_Pos   = 0x1        // Position of SER field.
	FLASH_CR_SER_Msk   = 0x2        // Bit mask of SER field.
	FLASH_CR_SER       = 0x2        // Bit SER.
	FLASH_CR_MER1_Pos  = 0x2        // Position of MER1 field.
	FLASH_CR_MER1_Msk  = 0x4        // Bit mask of MER1 field.
	FLASH_CR_MER1      = 0x4        // Bit MER1.
	FLASH_CR_SNB_Pos   = 0x3        // Position of SNB field.
	FLASH_CR_SNB_Msk   = 0xf8       // Bit mask of SNB field.
	FLASH_CR_PSIZE_Pos = 0x8        // Position of PSIZE field.
	FLASH_CR_PSIZE_Msk = 0x300      // Bit mask of PSIZE field.
	FLASH_CR_MER2_Pos  = 0xf        // Position of MER2 field.
	FLASH_CR_MER2_Msk  = 0x8000     // Bit mask of MER2 field.
	FLASH_CR_MER2      = 0x8000     // Bit MER2.
	FLASH_CR_STRT_Pos  = 0x10       // Position of STRT field.
	FLASH_CR_STRT_Msk  = 0x10000    // Bit mask of STRT field.
	FLASH_CR_STRT      = 0x10000    // Bit STRT.
	FLASH_CR_EOPIE_Pos = 0x18       // Position of EOPIE field.
	FLASH_CR_EOPIE_Msk = 0x1000000  // Bit mask of EOPIE field.
	FLASH_CR_EOPIE     = 0x1000000  // Bit EOPIE.
	FLASH_CR_ERRIE_Pos = 0x19       // Position of ERRIE field.
	FLASH_CR_ERRIE_Msk = 0x2000000  // Bit mask of ERRIE field.
	FLASH_CR_ERRIE     = 0x2000000  // Bit ERRIE.
	FLASH_CR_LOCK_Pos  = 0x1f       // Position of LOCK field.
	FLASH_CR_LOCK_Msk  = 0x80000000 // Bit mask of LOCK field.
	FLASH_CR_LOCK      = 0x80000000 // Bit LOCK.

	// OPTCR: Flash option control register
	FLASH_OPTCR_OPTLOCK_Pos    = 0x0        // Position of OPTLOCK field.
	FLASH_OPTCR_OPTLOCK_Msk    = 0x1        // Bit mask of OPTLOCK field.
	FLASH_OPTCR_OPTLOCK        = 0x1        // Bit OPTLOCK.
	FLASH_OPTCR_OPTSTRT_Pos    = 0x1        // Position of OPTSTRT field.
	FLASH_OPTCR_OPTSTRT_Msk    = 0x2        // Bit mask of OPTSTRT field.
	FLASH_OPTCR_OPTSTRT        = 0x2        // Bit OPTSTRT.
	FLASH_OPTCR_BOR_LEV_Pos    = 0x2        // Position of BOR_LEV field.
	FLASH_OPTCR_BOR_LEV_Msk    = 0xc        // Bit mask of BOR_LEV field.
	FLASH_OPTCR_WWDG_SW_Pos    = 0x4        // Position of WWDG_SW field.
	FLASH_OPTCR_WWDG_SW_Msk    = 0x10       // Bit mask of WWDG_SW field.
	FLASH_OPTCR_WWDG_SW        = 0x10       // Bit WWDG_SW.
	FLASH_OPTCR_IWDG_SW_Pos    = 0x5        // Position of IWDG_SW field.
	FLASH_OPTCR_IWDG_SW_Msk    = 0x20       // Bit mask of IWDG_SW field.
	FLASH_OPTCR_IWDG_SW        = 0x20       // Bit IWDG_SW.
	FLASH_OPTCR_NRST_STOP_Pos  = 0x6        // Position of NRST_STOP field.
	FLASH_OPTCR_NRST_STOP_Msk  = 0x40       // Bit mask of NRST_STOP field.
	FLASH_OPTCR_NRST_STOP      = 0x40       // Bit NRST_STOP.
	FLASH_OPTCR_NRST_STDBY_Pos = 0x7        // Position of NRST_STDBY field.
	FLASH_OPTCR_NRST_STDBY_Msk = 0x80       // Bit mask of NRST_STDBY field.
	FLASH_OPTCR_NRST_STDBY     = 0x80       // Bit NRST_STDBY.
	FLASH_OPTCR_RDP_Pos        = 0x8        // Position of RDP field.
	FLASH_OPTCR_RDP_Msk        = 0xff00     // Bit mask of RDP field.
	FLASH_OPTCR_NWRP_Pos       = 0x10       // Position of NWRP field.
	FLASH_OPTCR_NWRP_Msk       = 0xfff0000  // Bit mask of NWRP field.
	FLASH_OPTCR_NDBOOT_Pos     = 0x1c       // Position of NDBOOT field.
	FLASH_OPTCR_NDBOOT_Msk     = 0x10000000 // Bit mask of NDBOOT field.
	FLASH_OPTCR_NDBOOT         = 0x10000000 // Bit NDBOOT.
	FLASH_OPTCR_NDBANK_Pos     = 0x1d       // Position of NDBANK field.
	FLASH_OPTCR_NDBANK_Msk     = 0x20000000 // Bit mask of NDBANK field.
	FLASH_OPTCR_NDBANK         = 0x20000000 // Bit NDBANK.
	FLASH_OPTCR_IWDG_STDBY_Pos = 0x1e       // Position of IWDG_STDBY field.
	FLASH_OPTCR_IWDG_STDBY_Msk = 0x40000000 // Bit mask of IWDG_STDBY field.
	FLASH_OPTCR_IWDG_STDBY     = 0x40000000 // Bit IWDG_STDBY.
	FLASH_OPTCR_IWDG_STOP_Pos  = 0x1f       // Position of IWDG_STOP field.
	FLASH_OPTCR_IWDG_STOP_Msk  = 0x80000000 // Bit mask of IWDG_STOP field.
	FLASH_OPTCR_IWDG_STOP      = 0x80000000 // Bit IWDG_STOP.

	// OPTCR1: Flash option control register           1
	FLASH_OPTCR1_BOOT_ADD0_Pos = 0x0        // Position of BOOT_ADD0 field.
	FLASH_OPTCR1_BOOT_ADD0_Msk = 0xffff     // Bit mask of BOOT_ADD0 field.
	FLASH_OPTCR1_BOOT_ADD1_Pos = 0x10       // Position of BOOT_ADD1 field.
	FLASH_OPTCR1_BOOT_ADD1_Msk = 0xffff0000 // Bit mask of BOOT_ADD1 field.
)

// Bitfields for EXTI: External interrupt/event controller
const (
	// IMR: Interrupt mask register           (EXTI_IMR)
	EXTI_IMR_MR0_Pos  = 0x0      // Position of MR0 field.
	EXTI_IMR_MR0_Msk  = 0x1      // Bit mask of MR0 field.
	EXTI_IMR_MR0      = 0x1      // Bit MR0.
	EXTI_IMR_MR1_Pos  = 0x1      // Position of MR1 field.
	EXTI_IMR_MR1_Msk  = 0x2      // Bit mask of MR1 field.
	EXTI_IMR_MR1      = 0x2      // Bit MR1.
	EXTI_IMR_MR2_Pos  = 0x2      // Position of MR2 field.
	EXTI_IMR_MR2_Msk  = 0x4      // Bit mask of MR2 field.
	EXTI_IMR_MR2      = 0x4      // Bit MR2.
	EXTI_IMR_MR3_Pos  = 0x3      // Position of MR3 field.
	EXTI_IMR_MR3_Msk  = 0x8      // Bit mask of MR3 field.
	EXTI_IMR_MR3      = 0x8      // Bit MR3.
	EXTI_IMR_MR4_Pos  = 0x4      // Position of MR4 field.
	EXTI_IMR_MR4_Msk  = 0x10     // Bit mask of MR4 field.
	EXTI_IMR_MR4      = 0x10     // Bit MR4.
	EXTI_IMR_MR5_Pos  = 0x5      // Position of MR5 field.
	EXTI_IMR_MR5_Msk  = 0x20     // Bit mask of MR5 field.
	EXTI_IMR_MR5      = 0x20     // Bit MR5.
	EXTI_IMR_MR6_Pos  = 0x6      // Position of MR6 field.
	EXTI_IMR_MR6_Msk  = 0x40     // Bit mask of MR6 field.
	EXTI_IMR_MR6      = 0x40     // Bit MR6.
	EXTI_IMR_MR7_Pos  = 0x7      // Position of MR7 field.
	EXTI_IMR_MR7_Msk  = 0x80     // Bit mask of MR7 field.
	EXTI_IMR_MR7      = 0x80     // Bit MR7.
	EXTI_IMR_MR8_Pos  = 0x8      // Position of MR8 field.
	EXTI_IMR_MR8_Msk  = 0x100    // Bit mask of MR8 field.
	EXTI_IMR_MR8      = 0x100    // Bit MR8.
	EXTI_IMR_MR9_Pos  = 0x9      // Position of MR9 field.
	EXTI_IMR_MR9_Msk  = 0x200    // Bit mask of MR9 field.
	EXTI_IMR_MR9      = 0x200    // Bit MR9.
	EXTI_IMR_MR10_Pos = 0xa      // Position of MR10 field.
	EXTI_IMR_MR10_Msk = 0x400    // Bit mask of MR10 field.
	EXTI_IMR_MR10     = 0x400    // Bit MR10.
	EXTI_IMR_MR11_Pos = 0xb      // Position of MR11 field.
	EXTI_IMR_MR11_Msk = 0x800    // Bit mask of MR11 field.
	EXTI_IMR_MR11     = 0x800    // Bit MR11.
	EXTI_IMR_MR12_Pos = 0xc      // Position of MR12 field.
	EXTI_IMR_MR12_Msk = 0x1000   // Bit mask of MR12 field.
	EXTI_IMR_MR12     = 0x1000   // Bit MR12.
	EXTI_IMR_MR13_Pos = 0xd      // Position of MR13 field.
	EXTI_IMR_MR13_Msk = 0x2000   // Bit mask of MR13 field.
	EXTI_IMR_MR13     = 0x2000   // Bit MR13.
	EXTI_IMR_MR14_Pos = 0xe      // Position of MR14 field.
	EXTI_IMR_MR14_Msk = 0x4000   // Bit mask of MR14 field.
	EXTI_IMR_MR14     = 0x4000   // Bit MR14.
	EXTI_IMR_MR15_Pos = 0xf      // Position of MR15 field.
	EXTI_IMR_MR15_Msk = 0x8000   // Bit mask of MR15 field.
	EXTI_IMR_MR15     = 0x8000   // Bit MR15.
	EXTI_IMR_MR16_Pos = 0x10     // Position of MR16 field.
	EXTI_IMR_MR16_Msk = 0x10000  // Bit mask of MR16 field.
	EXTI_IMR_MR16     = 0x10000  // Bit MR16.
	EXTI_IMR_MR17_Pos = 0x11     // Position of MR17 field.
	EXTI_IMR_MR17_Msk = 0x20000  // Bit mask of MR17 field.
	EXTI_IMR_MR17     = 0x20000  // Bit MR17.
	EXTI_IMR_MR18_Pos = 0x12     // Position of MR18 field.
	EXTI_IMR_MR18_Msk = 0x40000  // Bit mask of MR18 field.
	EXTI_IMR_MR18     = 0x40000  // Bit MR18.
	EXTI_IMR_MR19_Pos = 0x13     // Position of MR19 field.
	EXTI_IMR_MR19_Msk = 0x80000  // Bit mask of MR19 field.
	EXTI_IMR_MR19     = 0x80000  // Bit MR19.
	EXTI_IMR_MR20_Pos = 0x14     // Position of MR20 field.
	EXTI_IMR_MR20_Msk = 0x100000 // Bit mask of MR20 field.
	EXTI_IMR_MR20     = 0x100000 // Bit MR20.
	EXTI_IMR_MR21_Pos = 0x15     // Position of MR21 field.
	EXTI_IMR_MR21_Msk = 0x200000 // Bit mask of MR21 field.
	EXTI_IMR_MR21     = 0x200000 // Bit MR21.
	EXTI_IMR_MR22_Pos = 0x16     // Position of MR22 field.
	EXTI_IMR_MR22_Msk = 0x400000 // Bit mask of MR22 field.
	EXTI_IMR_MR22     = 0x400000 // Bit MR22.

	// EMR: Event mask register (EXTI_EMR)
	EXTI_EMR_MR0_Pos  = 0x0      // Position of MR0 field.
	EXTI_EMR_MR0_Msk  = 0x1      // Bit mask of MR0 field.
	EXTI_EMR_MR0      = 0x1      // Bit MR0.
	EXTI_EMR_MR1_Pos  = 0x1      // Position of MR1 field.
	EXTI_EMR_MR1_Msk  = 0x2      // Bit mask of MR1 field.
	EXTI_EMR_MR1      = 0x2      // Bit MR1.
	EXTI_EMR_MR2_Pos  = 0x2      // Position of MR2 field.
	EXTI_EMR_MR2_Msk  = 0x4      // Bit mask of MR2 field.
	EXTI_EMR_MR2      = 0x4      // Bit MR2.
	EXTI_EMR_MR3_Pos  = 0x3      // Position of MR3 field.
	EXTI_EMR_MR3_Msk  = 0x8      // Bit mask of MR3 field.
	EXTI_EMR_MR3      = 0x8      // Bit MR3.
	EXTI_EMR_MR4_Pos  = 0x4      // Position of MR4 field.
	EXTI_EMR_MR4_Msk  = 0x10     // Bit mask of MR4 field.
	EXTI_EMR_MR4      = 0x10     // Bit MR4.
	EXTI_EMR_MR5_Pos  = 0x5      // Position of MR5 field.
	EXTI_EMR_MR5_Msk  = 0x20     // Bit mask of MR5 field.
	EXTI_EMR_MR5      = 0x20     // Bit MR5.
	EXTI_EMR_MR6_Pos  = 0x6      // Position of MR6 field.
	EXTI_EMR_MR6_Msk  = 0x40     // Bit mask of MR6 field.
	EXTI_EMR_MR6      = 0x40     // Bit MR6.
	EXTI_EMR_MR7_Pos  = 0x7      // Position of MR7 field.
	EXTI_EMR_MR7_Msk  = 0x80     // Bit mask of MR7 field.
	EXTI_EMR_MR7      = 0x80     // Bit MR7.
	EXTI_EMR_MR8_Pos  = 0x8      // Position of MR8 field.
	EXTI_EMR_MR8_Msk  = 0x100    // Bit mask of MR8 field.
	EXTI_EMR_MR8      = 0x100    // Bit MR8.
	EXTI_EMR_MR9_Pos  = 0x9      // Position of MR9 field.
	EXTI_EMR_MR9_Msk  = 0x200    // Bit mask of MR9 field.
	EXTI_EMR_MR9      = 0x200    // Bit MR9.
	EXTI_EMR_MR10_Pos = 0xa      // Position of MR10 field.
	EXTI_EMR_MR10_Msk = 0x400    // Bit mask of MR10 field.
	EXTI_EMR_MR10     = 0x400    // Bit MR10.
	EXTI_EMR_MR11_Pos = 0xb      // Position of MR11 field.
	EXTI_EMR_MR11_Msk = 0x800    // Bit mask of MR11 field.
	EXTI_EMR_MR11     = 0x800    // Bit MR11.
	EXTI_EMR_MR12_Pos = 0xc      // Position of MR12 field.
	EXTI_EMR_MR12_Msk = 0x1000   // Bit mask of MR12 field.
	EXTI_EMR_MR12     = 0x1000   // Bit MR12.
	EXTI_EMR_MR13_Pos = 0xd      // Position of MR13 field.
	EXTI_EMR_MR13_Msk = 0x2000   // Bit mask of MR13 field.
	EXTI_EMR_MR13     = 0x2000   // Bit MR13.
	EXTI_EMR_MR14_Pos = 0xe      // Position of MR14 field.
	EXTI_EMR_MR14_Msk = 0x4000   // Bit mask of MR14 field.
	EXTI_EMR_MR14     = 0x4000   // Bit MR14.
	EXTI_EMR_MR15_Pos = 0xf      // Position of MR15 field.
	EXTI_EMR_MR15_Msk = 0x8000   // Bit mask of MR15 field.
	EXTI_EMR_MR15     = 0x8000   // Bit MR15.
	EXTI_EMR_MR16_Pos = 0x10     // Position of MR16 field.
	EXTI_EMR_MR16_Msk = 0x10000  // Bit mask of MR16 field.
	EXTI_EMR_MR16     = 0x10000  // Bit MR16.
	EXTI_EMR_MR17_Pos = 0x11     // Position of MR17 field.
	EXTI_EMR_MR17_Msk = 0x20000  // Bit mask of MR17 field.
	EXTI_EMR_MR17     = 0x20000  // Bit MR17.
	EXTI_EMR_MR18_Pos = 0x12     // Position of MR18 field.
	EXTI_EMR_MR18_Msk = 0x40000  // Bit mask of MR18 field.
	EXTI_EMR_MR18     = 0x40000  // Bit MR18.
	EXTI_EMR_MR19_Pos = 0x13     // Position of MR19 field.
	EXTI_EMR_MR19_Msk = 0x80000  // Bit mask of MR19 field.
	EXTI_EMR_MR19     = 0x80000  // Bit MR19.
	EXTI_EMR_MR20_Pos = 0x14     // Position of MR20 field.
	EXTI_EMR_MR20_Msk = 0x100000 // Bit mask of MR20 field.
	EXTI_EMR_MR20     = 0x100000 // Bit MR20.
	EXTI_EMR_MR21_Pos = 0x15     // Position of MR21 field.
	EXTI_EMR_MR21_Msk = 0x200000 // Bit mask of MR21 field.
	EXTI_EMR_MR21     = 0x200000 // Bit MR21.
	EXTI_EMR_MR22_Pos = 0x16     // Position of MR22 field.
	EXTI_EMR_MR22_Msk = 0x400000 // Bit mask of MR22 field.
	EXTI_EMR_MR22     = 0x400000 // Bit MR22.

	// RTSR: Rising Trigger selection register           (EXTI_RTSR)
	EXTI_RTSR_TR0_Pos  = 0x0      // Position of TR0 field.
	EXTI_RTSR_TR0_Msk  = 0x1      // Bit mask of TR0 field.
	EXTI_RTSR_TR0      = 0x1      // Bit TR0.
	EXTI_RTSR_TR1_Pos  = 0x1      // Position of TR1 field.
	EXTI_RTSR_TR1_Msk  = 0x2      // Bit mask of TR1 field.
	EXTI_RTSR_TR1      = 0x2      // Bit TR1.
	EXTI_RTSR_TR2_Pos  = 0x2      // Position of TR2 field.
	EXTI_RTSR_TR2_Msk  = 0x4      // Bit mask of TR2 field.
	EXTI_RTSR_TR2      = 0x4      // Bit TR2.
	EXTI_RTSR_TR3_Pos  = 0x3      // Position of TR3 field.
	EXTI_RTSR_TR3_Msk  = 0x8      // Bit mask of TR3 field.
	EXTI_RTSR_TR3      = 0x8      // Bit TR3.
	EXTI_RTSR_TR4_Pos  = 0x4      // Position of TR4 field.
	EXTI_RTSR_TR4_Msk  = 0x10     // Bit mask of TR4 field.
	EXTI_RTSR_TR4      = 0x10     // Bit TR4.
	EXTI_RTSR_TR5_Pos  = 0x5      // Position of TR5 field.
	EXTI_RTSR_TR5_Msk  = 0x20     // Bit mask of TR5 field.
	EXTI_RTSR_TR5      = 0x20     // Bit TR5.
	EXTI_RTSR_TR6_Pos  = 0x6      // Position of TR6 field.
	EXTI_RTSR_TR6_Msk  = 0x40     // Bit mask of TR6 field.
	EXTI_RTSR_TR6      = 0x40     // Bit TR6.
	EXTI_RTSR_TR7_Pos  = 0x7      // Position of TR7 field.
	EXTI_RTSR_TR7_Msk  = 0x80     // Bit mask of TR7 field.
	EXTI_RTSR_TR7      = 0x80     // Bit TR7.
	EXTI_RTSR_TR8_Pos  = 0x8      // Position of TR8 field.
	EXTI_RTSR_TR8_Msk  = 0x100    // Bit mask of TR8 field.
	EXTI_RTSR_TR8      = 0x100    // Bit TR8.
	EXTI_RTSR_TR9_Pos  = 0x9      // Position of TR9 field.
	EXTI_RTSR_TR9_Msk  = 0x200    // Bit mask of TR9 field.
	EXTI_RTSR_TR9      = 0x200    // Bit TR9.
	EXTI_RTSR_TR10_Pos = 0xa      // Position of TR10 field.
	EXTI_RTSR_TR10_Msk = 0x400    // Bit mask of TR10 field.
	EXTI_RTSR_TR10     = 0x400    // Bit TR10.
	EXTI_RTSR_TR11_Pos = 0xb      // Position of TR11 field.
	EXTI_RTSR_TR11_Msk = 0x800    // Bit mask of TR11 field.
	EXTI_RTSR_TR11     = 0x800    // Bit TR11.
	EXTI_RTSR_TR12_Pos = 0xc      // Position of TR12 field.
	EXTI_RTSR_TR12_Msk = 0x1000   // Bit mask of TR12 field.
	EXTI_RTSR_TR12     = 0x1000   // Bit TR12.
	EXTI_RTSR_TR13_Pos = 0xd      // Position of TR13 field.
	EXTI_RTSR_TR13_Msk = 0x2000   // Bit mask of TR13 field.
	EXTI_RTSR_TR13     = 0x2000   // Bit TR13.
	EXTI_RTSR_TR14_Pos = 0xe      // Position of TR14 field.
	EXTI_RTSR_TR14_Msk = 0x4000   // Bit mask of TR14 field.
	EXTI_RTSR_TR14     = 0x4000   // Bit TR14.
	EXTI_RTSR_TR15_Pos = 0xf      // Position of TR15 field.
	EXTI_RTSR_TR15_Msk = 0x8000   // Bit mask of TR15 field.
	EXTI_RTSR_TR15     = 0x8000   // Bit TR15.
	EXTI_RTSR_TR16_Pos = 0x10     // Position of TR16 field.
	EXTI_RTSR_TR16_Msk = 0x10000  // Bit mask of TR16 field.
	EXTI_RTSR_TR16     = 0x10000  // Bit TR16.
	EXTI_RTSR_TR17_Pos = 0x11     // Position of TR17 field.
	EXTI_RTSR_TR17_Msk = 0x20000  // Bit mask of TR17 field.
	EXTI_RTSR_TR17     = 0x20000  // Bit TR17.
	EXTI_RTSR_TR18_Pos = 0x12     // Position of TR18 field.
	EXTI_RTSR_TR18_Msk = 0x40000  // Bit mask of TR18 field.
	EXTI_RTSR_TR18     = 0x40000  // Bit TR18.
	EXTI_RTSR_TR19_Pos = 0x13     // Position of TR19 field.
	EXTI_RTSR_TR19_Msk = 0x80000  // Bit mask of TR19 field.
	EXTI_RTSR_TR19     = 0x80000  // Bit TR19.
	EXTI_RTSR_TR20_Pos = 0x14     // Position of TR20 field.
	EXTI_RTSR_TR20_Msk = 0x100000 // Bit mask of TR20 field.
	EXTI_RTSR_TR20     = 0x100000 // Bit TR20.
	EXTI_RTSR_TR21_Pos = 0x15     // Position of TR21 field.
	EXTI_RTSR_TR21_Msk = 0x200000 // Bit mask of TR21 field.
	EXTI_RTSR_TR21     = 0x200000 // Bit TR21.
	EXTI_RTSR_TR22_Pos = 0x16     // Position of TR22 field.
	EXTI_RTSR_TR22_Msk = 0x400000 // Bit mask of TR22 field.
	EXTI_RTSR_TR22     = 0x400000 // Bit TR22.

	// FTSR: Falling Trigger selection register           (EXTI_FTSR)
	EXTI_FTSR_TR0_Pos  = 0x0      // Position of TR0 field.
	EXTI_FTSR_TR0_Msk  = 0x1      // Bit mask of TR0 field.
	EXTI_FTSR_TR0      = 0x1      // Bit TR0.
	EXTI_FTSR_TR1_Pos  = 0x1      // Position of TR1 field.
	EXTI_FTSR_TR1_Msk  = 0x2      // Bit mask of TR1 field.
	EXTI_FTSR_TR1      = 0x2      // Bit TR1.
	EXTI_FTSR_TR2_Pos  = 0x2      // Position of TR2 field.
	EXTI_FTSR_TR2_Msk  = 0x4      // Bit mask of TR2 field.
	EXTI_FTSR_TR2      = 0x4      // Bit TR2.
	EXTI_FTSR_TR3_Pos  = 0x3      // Position of TR3 field.
	EXTI_FTSR_TR3_Msk  = 0x8      // Bit mask of TR3 field.
	EXTI_FTSR_TR3      = 0x8      // Bit TR3.
	EXTI_FTSR_TR4_Pos  = 0x4      // Position of TR4 field.
	EXTI_FTSR_TR4_Msk  = 0x10     // Bit mask of TR4 field.
	EXTI_FTSR_TR4      = 0x10     // Bit TR4.
	EXTI_FTSR_TR5_Pos  = 0x5      // Position of TR5 field.
	EXTI_FTSR_TR5_Msk  = 0x20     // Bit mask of TR5 field.
	EXTI_FTSR_TR5      = 0x20     // Bit TR5.
	EXTI_FTSR_TR6_Pos  = 0x6      // Position of TR6 field.
	EXTI_FTSR_TR6_Msk  = 0x40     // Bit mask of TR6 field.
	EXTI_FTSR_TR6      = 0x40     // Bit TR6.
	EXTI_FTSR_TR7_Pos  = 0x7      // Position of TR7 field.
	EXTI_FTSR_TR7_Msk  = 0x80     // Bit mask of TR7 field.
	EXTI_FTSR_TR7      = 0x80     // Bit TR7.
	EXTI_FTSR_TR8_Pos  = 0x8      // Position of TR8 field.
	EXTI_FTSR_TR8_Msk  = 0x100    // Bit mask of TR8 field.
	EXTI_FTSR_TR8      = 0x100    // Bit TR8.
	EXTI_FTSR_TR9_Pos  = 0x9      // Position of TR9 field.
	EXTI_FTSR_TR9_Msk  = 0x200    // Bit mask of TR9 field.
	EXTI_FTSR_TR9      = 0x200    // Bit TR9.
	EXTI_FTSR_TR10_Pos = 0xa      // Position of TR10 field.
	EXTI_FTSR_TR10_Msk = 0x400    // Bit mask of TR10 field.
	EXTI_FTSR_TR10     = 0x400    // Bit TR10.
	EXTI_FTSR_TR11_Pos = 0xb      // Position of TR11 field.
	EXTI_FTSR_TR11_Msk = 0x800    // Bit mask of TR11 field.
	EXTI_FTSR_TR11     = 0x800    // Bit TR11.
	EXTI_FTSR_TR12_Pos = 0xc      // Position of TR12 field.
	EXTI_FTSR_TR12_Msk = 0x1000   // Bit mask of TR12 field.
	EXTI_FTSR_TR12     = 0x1000   // Bit TR12.
	EXTI_FTSR_TR13_Pos = 0xd      // Position of TR13 field.
	EXTI_FTSR_TR13_Msk = 0x2000   // Bit mask of TR13 field.
	EXTI_FTSR_TR13     = 0x2000   // Bit TR13.
	EXTI_FTSR_TR14_Pos = 0xe      // Position of TR14 field.
	EXTI_FTSR_TR14_Msk = 0x4000   // Bit mask of TR14 field.
	EXTI_FTSR_TR14     = 0x4000   // Bit TR14.
	EXTI_FTSR_TR15_Pos = 0xf      // Position of TR15 field.
	EXTI_FTSR_TR15_Msk = 0x8000   // Bit mask of TR15 field.
	EXTI_FTSR_TR15     = 0x8000   // Bit TR15.
	EXTI_FTSR_TR16_Pos = 0x10     // Position of TR16 field.
	EXTI_FTSR_TR16_Msk = 0x10000  // Bit mask of TR16 field.
	EXTI_FTSR_TR16     = 0x10000  // Bit TR16.
	EXTI_FTSR_TR17_Pos = 0x11     // Position of TR17 field.
	EXTI_FTSR_TR17_Msk = 0x20000  // Bit mask of TR17 field.
	EXTI_FTSR_TR17     = 0x20000  // Bit TR17.
	EXTI_FTSR_TR18_Pos = 0x12     // Position of TR18 field.
	EXTI_FTSR_TR18_Msk = 0x40000  // Bit mask of TR18 field.
	EXTI_FTSR_TR18     = 0x40000  // Bit TR18.
	EXTI_FTSR_TR19_Pos = 0x13     // Position of TR19 field.
	EXTI_FTSR_TR19_Msk = 0x80000  // Bit mask of TR19 field.
	EXTI_FTSR_TR19     = 0x80000  // Bit TR19.
	EXTI_FTSR_TR20_Pos = 0x14     // Position of TR20 field.
	EXTI_FTSR_TR20_Msk = 0x100000 // Bit mask of TR20 field.
	EXTI_FTSR_TR20     = 0x100000 // Bit TR20.
	EXTI_FTSR_TR21_Pos = 0x15     // Position of TR21 field.
	EXTI_FTSR_TR21_Msk = 0x200000 // Bit mask of TR21 field.
	EXTI_FTSR_TR21     = 0x200000 // Bit TR21.
	EXTI_FTSR_TR22_Pos = 0x16     // Position of TR22 field.
	EXTI_FTSR_TR22_Msk = 0x400000 // Bit mask of TR22 field.
	EXTI_FTSR_TR22     = 0x400000 // Bit TR22.

	// SWIER: Software interrupt event register           (EXTI_SWIER)
	EXTI_SWIER_SWIER0_Pos  = 0x0      // Position of SWIER0 field.
	EXTI_SWIER_SWIER0_Msk  = 0x1      // Bit mask of SWIER0 field.
	EXTI_SWIER_SWIER0      = 0x1      // Bit SWIER0.
	EXTI_SWIER_SWIER1_Pos  = 0x1      // Position of SWIER1 field.
	EXTI_SWIER_SWIER1_Msk  = 0x2      // Bit mask of SWIER1 field.
	EXTI_SWIER_SWIER1      = 0x2      // Bit SWIER1.
	EXTI_SWIER_SWIER2_Pos  = 0x2      // Position of SWIER2 field.
	EXTI_SWIER_SWIER2_Msk  = 0x4      // Bit mask of SWIER2 field.
	EXTI_SWIER_SWIER2      = 0x4      // Bit SWIER2.
	EXTI_SWIER_SWIER3_Pos  = 0x3      // Position of SWIER3 field.
	EXTI_SWIER_SWIER3_Msk  = 0x8      // Bit mask of SWIER3 field.
	EXTI_SWIER_SWIER3      = 0x8      // Bit SWIER3.
	EXTI_SWIER_SWIER4_Pos  = 0x4      // Position of SWIER4 field.
	EXTI_SWIER_SWIER4_Msk  = 0x10     // Bit mask of SWIER4 field.
	EXTI_SWIER_SWIER4      = 0x10     // Bit SWIER4.
	EXTI_SWIER_SWIER5_Pos  = 0x5      // Position of SWIER5 field.
	EXTI_SWIER_SWIER5_Msk  = 0x20     // Bit mask of SWIER5 field.
	EXTI_SWIER_SWIER5      = 0x20     // Bit SWIER5.
	EXTI_SWIER_SWIER6_Pos  = 0x6      // Position of SWIER6 field.
	EXTI_SWIER_SWIER6_Msk  = 0x40     // Bit mask of SWIER6 field.
	EXTI_SWIER_SWIER6      = 0x40     // Bit SWIER6.
	EXTI_SWIER_SWIER7_Pos  = 0x7      // Position of SWIER7 field.
	EXTI_SWIER_SWIER7_Msk  = 0x80     // Bit mask of SWIER7 field.
	EXTI_SWIER_SWIER7      = 0x80     // Bit SWIER7.
	EXTI_SWIER_SWIER8_Pos  = 0x8      // Position of SWIER8 field.
	EXTI_SWIER_SWIER8_Msk  = 0x100    // Bit mask of SWIER8 field.
	EXTI_SWIER_SWIER8      = 0x100    // Bit SWIER8.
	EXTI_SWIER_SWIER9_Pos  = 0x9      // Position of SWIER9 field.
	EXTI_SWIER_SWIER9_Msk  = 0x200    // Bit mask of SWIER9 field.
	EXTI_SWIER_SWIER9      = 0x200    // Bit SWIER9.
	EXTI_SWIER_SWIER10_Pos = 0xa      // Position of SWIER10 field.
	EXTI_SWIER_SWIER10_Msk = 0x400    // Bit mask of SWIER10 field.
	EXTI_SWIER_SWIER10     = 0x400    // Bit SWIER10.
	EXTI_SWIER_SWIER11_Pos = 0xb      // Position of SWIER11 field.
	EXTI_SWIER_SWIER11_Msk = 0x800    // Bit mask of SWIER11 field.
	EXTI_SWIER_SWIER11     = 0x800    // Bit SWIER11.
	EXTI_SWIER_SWIER12_Pos = 0xc      // Position of SWIER12 field.
	EXTI_SWIER_SWIER12_Msk = 0x1000   // Bit mask of SWIER12 field.
	EXTI_SWIER_SWIER12     = 0x1000   // Bit SWIER12.
	EXTI_SWIER_SWIER13_Pos = 0xd      // Position of SWIER13 field.
	EXTI_SWIER_SWIER13_Msk = 0x2000   // Bit mask of SWIER13 field.
	EXTI_SWIER_SWIER13     = 0x2000   // Bit SWIER13.
	EXTI_SWIER_SWIER14_Pos = 0xe      // Position of SWIER14 field.
	EXTI_SWIER_SWIER14_Msk = 0x4000   // Bit mask of SWIER14 field.
	EXTI_SWIER_SWIER14     = 0x4000   // Bit SWIER14.
	EXTI_SWIER_SWIER15_Pos = 0xf      // Position of SWIER15 field.
	EXTI_SWIER_SWIER15_Msk = 0x8000   // Bit mask of SWIER15 field.
	EXTI_SWIER_SWIER15     = 0x8000   // Bit SWIER15.
	EXTI_SWIER_SWIER16_Pos = 0x10     // Position of SWIER16 field.
	EXTI_SWIER_SWIER16_Msk = 0x10000  // Bit mask of SWIER16 field.
	EXTI_SWIER_SWIER16     = 0x10000  // Bit SWIER16.
	EXTI_SWIER_SWIER17_Pos = 0x11     // Position of SWIER17 field.
	EXTI_SWIER_SWIER17_Msk = 0x20000  // Bit mask of SWIER17 field.
	EXTI_SWIER_SWIER17     = 0x20000  // Bit SWIER17.
	EXTI_SWIER_SWIER18_Pos = 0x12     // Position of SWIER18 field.
	EXTI_SWIER_SWIER18_Msk = 0x40000  // Bit mask of SWIER18 field.
	EXTI_SWIER_SWIER18     = 0x40000  // Bit SWIER18.
	EXTI_SWIER_SWIER19_Pos = 0x13     // Position of SWIER19 field.
	EXTI_SWIER_SWIER19_Msk = 0x80000  // Bit mask of SWIER19 field.
	EXTI_SWIER_SWIER19     = 0x80000  // Bit SWIER19.
	EXTI_SWIER_SWIER20_Pos = 0x14     // Position of SWIER20 field.
	EXTI_SWIER_SWIER20_Msk = 0x100000 // Bit mask of SWIER20 field.
	EXTI_SWIER_SWIER20     = 0x100000 // Bit SWIER20.
	EXTI_SWIER_SWIER21_Pos = 0x15     // Position of SWIER21 field.
	EXTI_SWIER_SWIER21_Msk = 0x200000 // Bit mask of SWIER21 field.
	EXTI_SWIER_SWIER21     = 0x200000 // Bit SWIER21.
	EXTI_SWIER_SWIER22_Pos = 0x16     // Position of SWIER22 field.
	EXTI_SWIER_SWIER22_Msk = 0x400000 // Bit mask of SWIER22 field.
	EXTI_SWIER_SWIER22     = 0x400000 // Bit SWIER22.

	// PR: Pending register (EXTI_PR)
	EXTI_PR_PR0_Pos  = 0x0      // Position of PR0 field.
	EXTI_PR_PR0_Msk  = 0x1      // Bit mask of PR0 field.
	EXTI_PR_PR0      = 0x1      // Bit PR0.
	EXTI_PR_PR1_Pos  = 0x1      // Position of PR1 field.
	EXTI_PR_PR1_Msk  = 0x2      // Bit mask of PR1 field.
	EXTI_PR_PR1      = 0x2      // Bit PR1.
	EXTI_PR_PR2_Pos  = 0x2      // Position of PR2 field.
	EXTI_PR_PR2_Msk  = 0x4      // Bit mask of PR2 field.
	EXTI_PR_PR2      = 0x4      // Bit PR2.
	EXTI_PR_PR3_Pos  = 0x3      // Position of PR3 field.
	EXTI_PR_PR3_Msk  = 0x8      // Bit mask of PR3 field.
	EXTI_PR_PR3      = 0x8      // Bit PR3.
	EXTI_PR_PR4_Pos  = 0x4      // Position of PR4 field.
	EXTI_PR_PR4_Msk  = 0x10     // Bit mask of PR4 field.
	EXTI_PR_PR4      = 0x10     // Bit PR4.
	EXTI_PR_PR5_Pos  = 0x5      // Position of PR5 field.
	EXTI_PR_PR5_Msk  = 0x20     // Bit mask of PR5 field.
	EXTI_PR_PR5      = 0x20     // Bit PR5.
	EXTI_PR_PR6_Pos  = 0x6      // Position of PR6 field.
	EXTI_PR_PR6_Msk  = 0x40     // Bit mask of PR6 field.
	EXTI_PR_PR6      = 0x40     // Bit PR6.
	EXTI_PR_PR7_Pos  = 0x7      // Position of PR7 field.
	EXTI_PR_PR7_Msk  = 0x80     // Bit mask of PR7 field.
	EXTI_PR_PR7      = 0x80     // Bit PR7.
	EXTI_PR_PR8_Pos  = 0x8      // Position of PR8 field.
	EXTI_PR_PR8_Msk  = 0x100    // Bit mask of PR8 field.
	EXTI_PR_PR8      = 0x100    // Bit PR8.
	EXTI_PR_PR9_Pos  = 0x9      // Position of PR9 field.
	EXTI_PR_PR9_Msk  = 0x200    // Bit mask of PR9 field.
	EXTI_PR_PR9      = 0x200    // Bit PR9.
	EXTI_PR_PR10_Pos = 0xa      // Position of PR10 field.
	EXTI_PR_PR10_Msk = 0x400    // Bit mask of PR10 field.
	EXTI_PR_PR10     = 0x400    // Bit PR10.
	EXTI_PR_PR11_Pos = 0xb      // Position of PR11 field.
	EXTI_PR_PR11_Msk = 0x800    // Bit mask of PR11 field.
	EXTI_PR_PR11     = 0x800    // Bit PR11.
	EXTI_PR_PR12_Pos = 0xc      // Position of PR12 field.
	EXTI_PR_PR12_Msk = 0x1000   // Bit mask of PR12 field.
	EXTI_PR_PR12     = 0x1000   // Bit PR12.
	EXTI_PR_PR13_Pos = 0xd      // Position of PR13 field.
	EXTI_PR_PR13_Msk = 0x2000   // Bit mask of PR13 field.
	EXTI_PR_PR13     = 0x2000   // Bit PR13.
	EXTI_PR_PR14_Pos = 0xe      // Position of PR14 field.
	EXTI_PR_PR14_Msk = 0x4000   // Bit mask of PR14 field.
	EXTI_PR_PR14     = 0x4000   // Bit PR14.
	EXTI_PR_PR15_Pos = 0xf      // Position of PR15 field.
	EXTI_PR_PR15_Msk = 0x8000   // Bit mask of PR15 field.
	EXTI_PR_PR15     = 0x8000   // Bit PR15.
	EXTI_PR_PR16_Pos = 0x10     // Position of PR16 field.
	EXTI_PR_PR16_Msk = 0x10000  // Bit mask of PR16 field.
	EXTI_PR_PR16     = 0x10000  // Bit PR16.
	EXTI_PR_PR17_Pos = 0x11     // Position of PR17 field.
	EXTI_PR_PR17_Msk = 0x20000  // Bit mask of PR17 field.
	EXTI_PR_PR17     = 0x20000  // Bit PR17.
	EXTI_PR_PR18_Pos = 0x12     // Position of PR18 field.
	EXTI_PR_PR18_Msk = 0x40000  // Bit mask of PR18 field.
	EXTI_PR_PR18     = 0x40000  // Bit PR18.
	EXTI_PR_PR19_Pos = 0x13     // Position of PR19 field.
	EXTI_PR_PR19_Msk = 0x80000  // Bit mask of PR19 field.
	EXTI_PR_PR19     = 0x80000  // Bit PR19.
	EXTI_PR_PR20_Pos = 0x14     // Position of PR20 field.
	EXTI_PR_PR20_Msk = 0x100000 // Bit mask of PR20 field.
	EXTI_PR_PR20     = 0x100000 // Bit PR20.
	EXTI_PR_PR21_Pos = 0x15     // Position of PR21 field.
	EXTI_PR_PR21_Msk = 0x200000 // Bit mask of PR21 field.
	EXTI_PR_PR21     = 0x200000 // Bit PR21.
	EXTI_PR_PR22_Pos = 0x16     // Position of PR22 field.
	EXTI_PR_PR22_Msk = 0x400000 // Bit mask of PR22 field.
	EXTI_PR_PR22     = 0x400000 // Bit PR22.
)

// Bitfields for LTCD: LCD-TFT Controller
const (
	// SSCR: Synchronization Size Configuration           Register
	LTDC_SSCR_HSW_Pos = 0x10      // Position of HSW field.
	LTDC_SSCR_HSW_Msk = 0x3ff0000 // Bit mask of HSW field.
	LTDC_SSCR_VSH_Pos = 0x0       // Position of VSH field.
	LTDC_SSCR_VSH_Msk = 0x7ff     // Bit mask of VSH field.

	// BPCR: Back Porch Configuration           Register
	LTDC_BPCR_AHBP_Pos = 0x10      // Position of AHBP field.
	LTDC_BPCR_AHBP_Msk = 0x3ff0000 // Bit mask of AHBP field.
	LTDC_BPCR_AVBP_Pos = 0x0       // Position of AVBP field.
	LTDC_BPCR_AVBP_Msk = 0x7ff     // Bit mask of AVBP field.

	// AWCR: Active Width Configuration           Register
	LTDC_AWCR_AAV_Pos = 0x10      // Position of AAV field.
	LTDC_AWCR_AAV_Msk = 0x3ff0000 // Bit mask of AAV field.
	LTDC_AWCR_AAH_Pos = 0x0       // Position of AAH field.
	LTDC_AWCR_AAH_Msk = 0x7ff     // Bit mask of AAH field.

	// TWCR: Total Width Configuration           Register
	LTDC_TWCR_TOTALW_Pos = 0x10      // Position of TOTALW field.
	LTDC_TWCR_TOTALW_Msk = 0x3ff0000 // Bit mask of TOTALW field.
	LTDC_TWCR_TOTALH_Pos = 0x0       // Position of TOTALH field.
	LTDC_TWCR_TOTALH_Msk = 0x7ff     // Bit mask of TOTALH field.

	// GCR: Global Control Register
	LTDC_GCR_HSPOL_Pos  = 0x1f       // Position of HSPOL field.
	LTDC_GCR_HSPOL_Msk  = 0x80000000 // Bit mask of HSPOL field.
	LTDC_GCR_HSPOL      = 0x80000000 // Bit HSPOL.
	LTDC_GCR_VSPOL_Pos  = 0x1e       // Position of VSPOL field.
	LTDC_GCR_VSPOL_Msk  = 0x40000000 // Bit mask of VSPOL field.
	LTDC_GCR_VSPOL      = 0x40000000 // Bit VSPOL.
	LTDC_GCR_DEPOL_Pos  = 0x1d       // Position of DEPOL field.
	LTDC_GCR_DEPOL_Msk  = 0x20000000 // Bit mask of DEPOL field.
	LTDC_GCR_DEPOL      = 0x20000000 // Bit DEPOL.
	LTDC_GCR_PCPOL_Pos  = 0x1c       // Position of PCPOL field.
	LTDC_GCR_PCPOL_Msk  = 0x10000000 // Bit mask of PCPOL field.
	LTDC_GCR_PCPOL      = 0x10000000 // Bit PCPOL.
	LTDC_GCR_DEN_Pos    = 0x10       // Position of DEN field.
	LTDC_GCR_DEN_Msk    = 0x10000    // Bit mask of DEN field.
	LTDC_GCR_DEN        = 0x10000    // Bit DEN.
	LTDC_GCR_DRW_Pos    = 0xc        // Position of DRW field.
	LTDC_GCR_DRW_Msk    = 0x7000     // Bit mask of DRW field.
	LTDC_GCR_DGW_Pos    = 0x8        // Position of DGW field.
	LTDC_GCR_DGW_Msk    = 0x700      // Bit mask of DGW field.
	LTDC_GCR_DBW_Pos    = 0x4        // Position of DBW field.
	LTDC_GCR_DBW_Msk    = 0x70       // Bit mask of DBW field.
	LTDC_GCR_LTDCEN_Pos = 0x0        // Position of LTDCEN field.
	LTDC_GCR_LTDCEN_Msk = 0x1        // Bit mask of LTDCEN field.
	LTDC_GCR_LTDCEN     = 0x1        // Bit LTDCEN.

	// SRCR: Shadow Reload Configuration           Register
	LTDC_SRCR_VBR_Pos = 0x1 // Position of VBR field.
	LTDC_SRCR_VBR_Msk = 0x2 // Bit mask of VBR field.
	LTDC_SRCR_VBR     = 0x2 // Bit VBR.
	LTDC_SRCR_IMR_Pos = 0x0 // Position of IMR field.
	LTDC_SRCR_IMR_Msk = 0x1 // Bit mask of IMR field.
	LTDC_SRCR_IMR     = 0x1 // Bit IMR.

	// BCCR: Background Color Configuration           Register
	LTDC_BCCR_BC_Pos = 0x0      // Position of BC field.
	LTDC_BCCR_BC_Msk = 0xffffff // Bit mask of BC field.

	// IER: Interrupt Enable Register
	LTDC_IER_RRIE_Pos   = 0x3 // Position of RRIE field.
	LTDC_IER_RRIE_Msk   = 0x8 // Bit mask of RRIE field.
	LTDC_IER_RRIE       = 0x8 // Bit RRIE.
	LTDC_IER_TERRIE_Pos = 0x2 // Position of TERRIE field.
	LTDC_IER_TERRIE_Msk = 0x4 // Bit mask of TERRIE field.
	LTDC_IER_TERRIE     = 0x4 // Bit TERRIE.
	LTDC_IER_FUIE_Pos   = 0x1 // Position of FUIE field.
	LTDC_IER_FUIE_Msk   = 0x2 // Bit mask of FUIE field.
	LTDC_IER_FUIE       = 0x2 // Bit FUIE.
	LTDC_IER_LIE_Pos    = 0x0 // Position of LIE field.
	LTDC_IER_LIE_Msk    = 0x1 // Bit mask of LIE field.
	LTDC_IER_LIE        = 0x1 // Bit LIE.

	// ISR: Interrupt Status Register
	LTDC_ISR_RRIF_Pos   = 0x3 // Position of RRIF field.
	LTDC_ISR_RRIF_Msk   = 0x8 // Bit mask of RRIF field.
	LTDC_ISR_RRIF       = 0x8 // Bit RRIF.
	LTDC_ISR_TERRIF_Pos = 0x2 // Position of TERRIF field.
	LTDC_ISR_TERRIF_Msk = 0x4 // Bit mask of TERRIF field.
	LTDC_ISR_TERRIF     = 0x4 // Bit TERRIF.
	LTDC_ISR_FUIF_Pos   = 0x1 // Position of FUIF field.
	LTDC_ISR_FUIF_Msk   = 0x2 // Bit mask of FUIF field.
	LTDC_ISR_FUIF       = 0x2 // Bit FUIF.
	LTDC_ISR_LIF_Pos    = 0x0 // Position of LIF field.
	LTDC_ISR_LIF_Msk    = 0x1 // Bit mask of LIF field.
	LTDC_ISR_LIF        = 0x1 // Bit LIF.

	// ICR: Interrupt Clear Register
	LTDC_ICR_CRRIF_Pos   = 0x3 // Position of CRRIF field.
	LTDC_ICR_CRRIF_Msk   = 0x8 // Bit mask of CRRIF field.
	LTDC_ICR_CRRIF       = 0x8 // Bit CRRIF.
	LTDC_ICR_CTERRIF_Pos = 0x2 // Position of CTERRIF field.
	LTDC_ICR_CTERRIF_Msk = 0x4 // Bit mask of CTERRIF field.
	LTDC_ICR_CTERRIF     = 0x4 // Bit CTERRIF.
	LTDC_ICR_CFUIF_Pos   = 0x1 // Position of CFUIF field.
	LTDC_ICR_CFUIF_Msk   = 0x2 // Bit mask of CFUIF field.
	LTDC_ICR_CFUIF       = 0x2 // Bit CFUIF.
	LTDC_ICR_CLIF_Pos    = 0x0 // Position of CLIF field.
	LTDC_ICR_CLIF_Msk    = 0x1 // Bit mask of CLIF field.
	LTDC_ICR_CLIF        = 0x1 // Bit CLIF.

	// LIPCR: Line Interrupt Position Configuration           Register
	LTDC_LIPCR_LIPOS_Pos = 0x0   // Position of LIPOS field.
	LTDC_LIPCR_LIPOS_Msk = 0x7ff // Bit mask of LIPOS field.

	// CPSR: Current Position Status           Register
	LTDC_CPSR_CXPOS_Pos = 0x10       // Position of CXPOS field.
	LTDC_CPSR_CXPOS_Msk = 0xffff0000 // Bit mask of CXPOS field.
	LTDC_CPSR_CYPOS_Pos = 0x0        // Position of CYPOS field.
	LTDC_CPSR_CYPOS_Msk = 0xffff     // Bit mask of CYPOS field.

	// CDSR: Current Display Status           Register
	LTDC_CDSR_HSYNCS_Pos = 0x3 // Position of HSYNCS field.
	LTDC_CDSR_HSYNCS_Msk = 0x8 // Bit mask of HSYNCS field.
	LTDC_CDSR_HSYNCS     = 0x8 // Bit HSYNCS.
	LTDC_CDSR_VSYNCS_Pos = 0x2 // Position of VSYNCS field.
	LTDC_CDSR_VSYNCS_Msk = 0x4 // Bit mask of VSYNCS field.
	LTDC_CDSR_VSYNCS     = 0x4 // Bit VSYNCS.
	LTDC_CDSR_HDES_Pos   = 0x1 // Position of HDES field.
	LTDC_CDSR_HDES_Msk   = 0x2 // Bit mask of HDES field.
	LTDC_CDSR_HDES       = 0x2 // Bit HDES.
	LTDC_CDSR_VDES_Pos   = 0x0 // Position of VDES field.
	LTDC_CDSR_VDES_Msk   = 0x1 // Bit mask of VDES field.
	LTDC_CDSR_VDES       = 0x1 // Bit VDES.

	// L1CR: Layerx Control Register
	LTDC_L1CR_CLUTEN_Pos = 0x4  // Position of CLUTEN field.
	LTDC_L1CR_CLUTEN_Msk = 0x10 // Bit mask of CLUTEN field.
	LTDC_L1CR_CLUTEN     = 0x10 // Bit CLUTEN.
	LTDC_L1CR_COLKEN_Pos = 0x1  // Position of COLKEN field.
	LTDC_L1CR_COLKEN_Msk = 0x2  // Bit mask of COLKEN field.
	LTDC_L1CR_COLKEN     = 0x2  // Bit COLKEN.
	LTDC_L1CR_LEN_Pos    = 0x0  // Position of LEN field.
	LTDC_L1CR_LEN_Msk    = 0x1  // Bit mask of LEN field.
	LTDC_L1CR_LEN        = 0x1  // Bit LEN.

	// L1WHPCR: Layerx Window Horizontal Position           Configuration Register
	LTDC_L1WHPCR_WHSPPOS_Pos = 0x10      // Position of WHSPPOS field.
	LTDC_L1WHPCR_WHSPPOS_Msk = 0xfff0000 // Bit mask of WHSPPOS field.
	LTDC_L1WHPCR_WHSTPOS_Pos = 0x0       // Position of WHSTPOS field.
	LTDC_L1WHPCR_WHSTPOS_Msk = 0xfff     // Bit mask of WHSTPOS field.

	// L1WVPCR: Layerx Window Vertical Position           Configuration Register
	LTDC_L1WVPCR_WVSPPOS_Pos = 0x10      // Position of WVSPPOS field.
	LTDC_L1WVPCR_WVSPPOS_Msk = 0x7ff0000 // Bit mask of WVSPPOS field.
	LTDC_L1WVPCR_WVSTPOS_Pos = 0x0       // Position of WVSTPOS field.
	LTDC_L1WVPCR_WVSTPOS_Msk = 0x7ff     // Bit mask of WVSTPOS field.

	// L1CKCR: Layerx Color Keying Configuration           Register
	LTDC_L1CKCR_CKRED_Pos   = 0x10     // Position of CKRED field.
	LTDC_L1CKCR_CKRED_Msk   = 0xff0000 // Bit mask of CKRED field.
	LTDC_L1CKCR_CKGREEN_Pos = 0x8      // Position of CKGREEN field.
	LTDC_L1CKCR_CKGREEN_Msk = 0xff00   // Bit mask of CKGREEN field.
	LTDC_L1CKCR_CKBLUE_Pos  = 0x0      // Position of CKBLUE field.
	LTDC_L1CKCR_CKBLUE_Msk  = 0xff     // Bit mask of CKBLUE field.

	// L1PFCR: Layerx Pixel Format Configuration           Register
	LTDC_L1PFCR_PF_Pos = 0x0 // Position of PF field.
	LTDC_L1PFCR_PF_Msk = 0x7 // Bit mask of PF field.

	// L1CACR: Layerx Constant Alpha Configuration           Register
	LTDC_L1CACR_CONSTA_Pos = 0x0  // Position of CONSTA field.
	LTDC_L1CACR_CONSTA_Msk = 0xff // Bit mask of CONSTA field.

	// L1DCCR: Layerx Default Color Configuration           Register
	LTDC_L1DCCR_DCALPHA_Pos = 0x18       // Position of DCALPHA field.
	LTDC_L1DCCR_DCALPHA_Msk = 0xff000000 // Bit mask of DCALPHA field.
	LTDC_L1DCCR_DCRED_Pos   = 0x10       // Position of DCRED field.
	LTDC_L1DCCR_DCRED_Msk   = 0xff0000   // Bit mask of DCRED field.
	LTDC_L1DCCR_DCGREEN_Pos = 0x8        // Position of DCGREEN field.
	LTDC_L1DCCR_DCGREEN_Msk = 0xff00     // Bit mask of DCGREEN field.
	LTDC_L1DCCR_DCBLUE_Pos  = 0x0        // Position of DCBLUE field.
	LTDC_L1DCCR_DCBLUE_Msk  = 0xff       // Bit mask of DCBLUE field.

	// L1BFCR: Layerx Blending Factors Configuration           Register
	LTDC_L1BFCR_BF1_Pos = 0x8   // Position of BF1 field.
	LTDC_L1BFCR_BF1_Msk = 0x700 // Bit mask of BF1 field.
	LTDC_L1BFCR_BF2_Pos = 0x0   // Position of BF2 field.
	LTDC_L1BFCR_BF2_Msk = 0x7   // Bit mask of BF2 field.

	// L1CFBAR: Layerx Color Frame Buffer Address           Register
	LTDC_L1CFBAR_CFBADD_Pos = 0x0        // Position of CFBADD field.
	LTDC_L1CFBAR_CFBADD_Msk = 0xffffffff // Bit mask of CFBADD field.

	// L1CFBLR: Layerx Color Frame Buffer Length           Register
	LTDC_L1CFBLR_CFBP_Pos  = 0x10       // Position of CFBP field.
	LTDC_L1CFBLR_CFBP_Msk  = 0x1fff0000 // Bit mask of CFBP field.
	LTDC_L1CFBLR_CFBLL_Pos = 0x0        // Position of CFBLL field.
	LTDC_L1CFBLR_CFBLL_Msk = 0x1fff     // Bit mask of CFBLL field.

	// L1CFBLNR: Layerx ColorFrame Buffer Line Number           Register
	LTDC_L1CFBLNR_CFBLNBR_Pos = 0x0   // Position of CFBLNBR field.
	LTDC_L1CFBLNR_CFBLNBR_Msk = 0x7ff // Bit mask of CFBLNBR field.

	// L1CLUTWR: Layerx CLUT Write Register
	LTDC_L1CLUTWR_CLUTADD_Pos = 0x18       // Position of CLUTADD field.
	LTDC_L1CLUTWR_CLUTADD_Msk = 0xff000000 // Bit mask of CLUTADD field.
	LTDC_L1CLUTWR_RED_Pos     = 0x10       // Position of RED field.
	LTDC_L1CLUTWR_RED_Msk     = 0xff0000   // Bit mask of RED field.
	LTDC_L1CLUTWR_GREEN_Pos   = 0x8        // Position of GREEN field.
	LTDC_L1CLUTWR_GREEN_Msk   = 0xff00     // Bit mask of GREEN field.
	LTDC_L1CLUTWR_BLUE_Pos    = 0x0        // Position of BLUE field.
	LTDC_L1CLUTWR_BLUE_Msk    = 0xff       // Bit mask of BLUE field.

	// L2CR: Layerx Control Register
	LTDC_L2CR_CLUTEN_Pos = 0x4  // Position of CLUTEN field.
	LTDC_L2CR_CLUTEN_Msk = 0x10 // Bit mask of CLUTEN field.
	LTDC_L2CR_CLUTEN     = 0x10 // Bit CLUTEN.
	LTDC_L2CR_COLKEN_Pos = 0x1  // Position of COLKEN field.
	LTDC_L2CR_COLKEN_Msk = 0x2  // Bit mask of COLKEN field.
	LTDC_L2CR_COLKEN     = 0x2  // Bit COLKEN.
	LTDC_L2CR_LEN_Pos    = 0x0  // Position of LEN field.
	LTDC_L2CR_LEN_Msk    = 0x1  // Bit mask of LEN field.
	LTDC_L2CR_LEN        = 0x1  // Bit LEN.

	// L2WHPCR: Layerx Window Horizontal Position           Configuration Register
	LTDC_L2WHPCR_WHSPPOS_Pos = 0x10      // Position of WHSPPOS field.
	LTDC_L2WHPCR_WHSPPOS_Msk = 0xfff0000 // Bit mask of WHSPPOS field.
	LTDC_L2WHPCR_WHSTPOS_Pos = 0x0       // Position of WHSTPOS field.
	LTDC_L2WHPCR_WHSTPOS_Msk = 0xfff     // Bit mask of WHSTPOS field.

	// L2WVPCR: Layerx Window Vertical Position           Configuration Register
	LTDC_L2WVPCR_WVSPPOS_Pos = 0x10      // Position of WVSPPOS field.
	LTDC_L2WVPCR_WVSPPOS_Msk = 0x7ff0000 // Bit mask of WVSPPOS field.
	LTDC_L2WVPCR_WVSTPOS_Pos = 0x0       // Position of WVSTPOS field.
	LTDC_L2WVPCR_WVSTPOS_Msk = 0x7ff     // Bit mask of WVSTPOS field.

	// L2CKCR: Layerx Color Keying Configuration           Register
	LTDC_L2CKCR_CKRED_Pos   = 0xf      // Position of CKRED field.
	LTDC_L2CKCR_CKRED_Msk   = 0xff8000 // Bit mask of CKRED field.
	LTDC_L2CKCR_CKGREEN_Pos = 0x8      // Position of CKGREEN field.
	LTDC_L2CKCR_CKGREEN_Msk = 0x7f00   // Bit mask of CKGREEN field.
	LTDC_L2CKCR_CKBLUE_Pos  = 0x0      // Position of CKBLUE field.
	LTDC_L2CKCR_CKBLUE_Msk  = 0xff     // Bit mask of CKBLUE field.

	// L2PFCR: Layerx Pixel Format Configuration           Register
	LTDC_L2PFCR_PF_Pos = 0x0 // Position of PF field.
	LTDC_L2PFCR_PF_Msk = 0x7 // Bit mask of PF field.

	// L2CACR: Layerx Constant Alpha Configuration           Register
	LTDC_L2CACR_CONSTA_Pos = 0x0  // Position of CONSTA field.
	LTDC_L2CACR_CONSTA_Msk = 0xff // Bit mask of CONSTA field.

	// L2DCCR: Layerx Default Color Configuration           Register
	LTDC_L2DCCR_DCALPHA_Pos = 0x18       // Position of DCALPHA field.
	LTDC_L2DCCR_DCALPHA_Msk = 0xff000000 // Bit mask of DCALPHA field.
	LTDC_L2DCCR_DCRED_Pos   = 0x10       // Position of DCRED field.
	LTDC_L2DCCR_DCRED_Msk   = 0xff0000   // Bit mask of DCRED field.
	LTDC_L2DCCR_DCGREEN_Pos = 0x8        // Position of DCGREEN field.
	LTDC_L2DCCR_DCGREEN_Msk = 0xff00     // Bit mask of DCGREEN field.
	LTDC_L2DCCR_DCBLUE_Pos  = 0x0        // Position of DCBLUE field.
	LTDC_L2DCCR_DCBLUE_Msk  = 0xff       // Bit mask of DCBLUE field.

	// L2BFCR: Layerx Blending Factors Configuration           Register
	LTDC_L2BFCR_BF1_Pos = 0x8   // Position of BF1 field.
	LTDC_L2BFCR_BF1_Msk = 0x700 // Bit mask of BF1 field.
	LTDC_L2BFCR_BF2_Pos = 0x0   // Position of BF2 field.
	LTDC_L2BFCR_BF2_Msk = 0x7   // Bit mask of BF2 field.

	// L2CFBAR: Layerx Color Frame Buffer Address           Register
	LTDC_L2CFBAR_CFBADD_Pos = 0x0        // Position of CFBADD field.
	LTDC_L2CFBAR_CFBADD_Msk = 0xffffffff // Bit mask of CFBADD field.

	// L2CFBLR: Layerx Color Frame Buffer Length           Register
	LTDC_L2CFBLR_CFBP_Pos  = 0x10       // Position of CFBP field.
	LTDC_L2CFBLR_CFBP_Msk  = 0x1fff0000 // Bit mask of CFBP field.
	LTDC_L2CFBLR_CFBLL_Pos = 0x0        // Position of CFBLL field.
	LTDC_L2CFBLR_CFBLL_Msk = 0x1fff     // Bit mask of CFBLL field.

	// L2CFBLNR: Layerx ColorFrame Buffer Line Number           Register
	LTDC_L2CFBLNR_CFBLNBR_Pos = 0x0   // Position of CFBLNBR field.
	LTDC_L2CFBLNR_CFBLNBR_Msk = 0x7ff // Bit mask of CFBLNBR field.

	// L2CLUTWR: Layerx CLUT Write Register
	LTDC_L2CLUTWR_CLUTADD_Pos = 0x18       // Position of CLUTADD field.
	LTDC_L2CLUTWR_CLUTADD_Msk = 0xff000000 // Bit mask of CLUTADD field.
	LTDC_L2CLUTWR_RED_Pos     = 0x10       // Position of RED field.
	LTDC_L2CLUTWR_RED_Msk     = 0xff0000   // Bit mask of RED field.
	LTDC_L2CLUTWR_GREEN_Pos   = 0x8        // Position of GREEN field.
	LTDC_L2CLUTWR_GREEN_Msk   = 0xff00     // Bit mask of GREEN field.
	LTDC_L2CLUTWR_BLUE_Pos    = 0x0        // Position of BLUE field.
	LTDC_L2CLUTWR_BLUE_Msk    = 0xff       // Bit mask of BLUE field.
)

// Bitfields for SAI1: Serial audio interface
const (
	// GCR: Global configuration register
	SAI_GCR_SYNCIN_Pos  = 0x0  // Position of SYNCIN field.
	SAI_GCR_SYNCIN_Msk  = 0x3  // Bit mask of SYNCIN field.
	SAI_GCR_SYNCOUT_Pos = 0x4  // Position of SYNCOUT field.
	SAI_GCR_SYNCOUT_Msk = 0x30 // Bit mask of SYNCOUT field.

	// ACR1: AConfiguration register 1
	SAI_ACR1_MCJDIV_Pos   = 0x14     // Position of MCJDIV field.
	SAI_ACR1_MCJDIV_Msk   = 0xf00000 // Bit mask of MCJDIV field.
	SAI_ACR1_NODIV_Pos    = 0x13     // Position of NODIV field.
	SAI_ACR1_NODIV_Msk    = 0x80000  // Bit mask of NODIV field.
	SAI_ACR1_NODIV        = 0x80000  // Bit NODIV.
	SAI_ACR1_DMAEN_Pos    = 0x11     // Position of DMAEN field.
	SAI_ACR1_DMAEN_Msk    = 0x20000  // Bit mask of DMAEN field.
	SAI_ACR1_DMAEN        = 0x20000  // Bit DMAEN.
	SAI_ACR1_SAIAEN_Pos   = 0x10     // Position of SAIAEN field.
	SAI_ACR1_SAIAEN_Msk   = 0x10000  // Bit mask of SAIAEN field.
	SAI_ACR1_SAIAEN       = 0x10000  // Bit SAIAEN.
	SAI_ACR1_OutDri_Pos   = 0xd      // Position of OutDri field.
	SAI_ACR1_OutDri_Msk   = 0x2000   // Bit mask of OutDri field.
	SAI_ACR1_OutDri       = 0x2000   // Bit OutDri.
	SAI_ACR1_MONO_Pos     = 0xc      // Position of MONO field.
	SAI_ACR1_MONO_Msk     = 0x1000   // Bit mask of MONO field.
	SAI_ACR1_MONO         = 0x1000   // Bit MONO.
	SAI_ACR1_SYNCEN_Pos   = 0xa      // Position of SYNCEN field.
	SAI_ACR1_SYNCEN_Msk   = 0xc00    // Bit mask of SYNCEN field.
	SAI_ACR1_CKSTR_Pos    = 0x9      // Position of CKSTR field.
	SAI_ACR1_CKSTR_Msk    = 0x200    // Bit mask of CKSTR field.
	SAI_ACR1_CKSTR        = 0x200    // Bit CKSTR.
	SAI_ACR1_LSBFIRST_Pos = 0x8      // Position of LSBFIRST field.
	SAI_ACR1_LSBFIRST_Msk = 0x100    // Bit mask of LSBFIRST field.
	SAI_ACR1_LSBFIRST     = 0x100    // Bit LSBFIRST.
	SAI_ACR1_DS_Pos       = 0x5      // Position of DS field.
	SAI_ACR1_DS_Msk       = 0xe0     // Bit mask of DS field.
	SAI_ACR1_PRTCFG_Pos   = 0x2      // Position of PRTCFG field.
	SAI_ACR1_PRTCFG_Msk   = 0xc      // Bit mask of PRTCFG field.
	SAI_ACR1_MODE_Pos     = 0x0      // Position of MODE field.
	SAI_ACR1_MODE_Msk     = 0x3      // Bit mask of MODE field.

	// ACR2: AConfiguration register 2
	SAI_ACR2_COMP_Pos    = 0xe    // Position of COMP field.
	SAI_ACR2_COMP_Msk    = 0xc000 // Bit mask of COMP field.
	SAI_ACR2_CPL_Pos     = 0xd    // Position of CPL field.
	SAI_ACR2_CPL_Msk     = 0x2000 // Bit mask of CPL field.
	SAI_ACR2_CPL         = 0x2000 // Bit CPL.
	SAI_ACR2_MUTECN_Pos  = 0x7    // Position of MUTECN field.
	SAI_ACR2_MUTECN_Msk  = 0x1f80 // Bit mask of MUTECN field.
	SAI_ACR2_MUTEVAL_Pos = 0x6    // Position of MUTEVAL field.
	SAI_ACR2_MUTEVAL_Msk = 0x40   // Bit mask of MUTEVAL field.
	SAI_ACR2_MUTEVAL     = 0x40   // Bit MUTEVAL.
	SAI_ACR2_MUTE_Pos    = 0x5    // Position of MUTE field.
	SAI_ACR2_MUTE_Msk    = 0x20   // Bit mask of MUTE field.
	SAI_ACR2_MUTE        = 0x20   // Bit MUTE.
	SAI_ACR2_TRIS_Pos    = 0x4    // Position of TRIS field.
	SAI_ACR2_TRIS_Msk    = 0x10   // Bit mask of TRIS field.
	SAI_ACR2_TRIS        = 0x10   // Bit TRIS.
	SAI_ACR2_FFLUS_Pos   = 0x3    // Position of FFLUS field.
	SAI_ACR2_FFLUS_Msk   = 0x8    // Bit mask of FFLUS field.
	SAI_ACR2_FFLUS       = 0x8    // Bit FFLUS.
	SAI_ACR2_FTH_Pos     = 0x0    // Position of FTH field.
	SAI_ACR2_FTH_Msk     = 0x7    // Bit mask of FTH field.

	// AFRCR: AFRCR
	SAI_AFRCR_FSOFF_Pos = 0x12    // Position of FSOFF field.
	SAI_AFRCR_FSOFF_Msk = 0x40000 // Bit mask of FSOFF field.
	SAI_AFRCR_FSOFF     = 0x40000 // Bit FSOFF.
	SAI_AFRCR_FSPOL_Pos = 0x11    // Position of FSPOL field.
	SAI_AFRCR_FSPOL_Msk = 0x20000 // Bit mask of FSPOL field.
	SAI_AFRCR_FSPOL     = 0x20000 // Bit FSPOL.
	SAI_AFRCR_FSDEF_Pos = 0x10    // Position of FSDEF field.
	SAI_AFRCR_FSDEF_Msk = 0x10000 // Bit mask of FSDEF field.
	SAI_AFRCR_FSDEF     = 0x10000 // Bit FSDEF.
	SAI_AFRCR_FSALL_Pos = 0x8     // Position of FSALL field.
	SAI_AFRCR_FSALL_Msk = 0x7f00  // Bit mask of FSALL field.
	SAI_AFRCR_FRL_Pos   = 0x0     // Position of FRL field.
	SAI_AFRCR_FRL_Msk   = 0xff    // Bit mask of FRL field.

	// ASLOTR: ASlot register
	SAI_ASLOTR_SLOTEN_Pos = 0x10       // Position of SLOTEN field.
	SAI_ASLOTR_SLOTEN_Msk = 0xffff0000 // Bit mask of SLOTEN field.
	SAI_ASLOTR_NBSLOT_Pos = 0x8        // Position of NBSLOT field.
	SAI_ASLOTR_NBSLOT_Msk = 0xf00      // Bit mask of NBSLOT field.
	SAI_ASLOTR_SLOTSZ_Pos = 0x6        // Position of SLOTSZ field.
	SAI_ASLOTR_SLOTSZ_Msk = 0xc0       // Bit mask of SLOTSZ field.
	SAI_ASLOTR_FBOFF_Pos  = 0x0        // Position of FBOFF field.
	SAI_ASLOTR_FBOFF_Msk  = 0x1f       // Bit mask of FBOFF field.

	// AIM: AInterrupt mask register2
	SAI_AIM_LFSDET_Pos   = 0x6  // Position of LFSDET field.
	SAI_AIM_LFSDET_Msk   = 0x40 // Bit mask of LFSDET field.
	SAI_AIM_LFSDET       = 0x40 // Bit LFSDET.
	SAI_AIM_AFSDETIE_Pos = 0x5  // Position of AFSDETIE field.
	SAI_AIM_AFSDETIE_Msk = 0x20 // Bit mask of AFSDETIE field.
	SAI_AIM_AFSDETIE     = 0x20 // Bit AFSDETIE.
	SAI_AIM_CNRDYIE_Pos  = 0x4  // Position of CNRDYIE field.
	SAI_AIM_CNRDYIE_Msk  = 0x10 // Bit mask of CNRDYIE field.
	SAI_AIM_CNRDYIE      = 0x10 // Bit CNRDYIE.
	SAI_AIM_FREQIE_Pos   = 0x3  // Position of FREQIE field.
	SAI_AIM_FREQIE_Msk   = 0x8  // Bit mask of FREQIE field.
	SAI_AIM_FREQIE       = 0x8  // Bit FREQIE.
	SAI_AIM_WCKCFG_Pos   = 0x2  // Position of WCKCFG field.
	SAI_AIM_WCKCFG_Msk   = 0x4  // Bit mask of WCKCFG field.
	SAI_AIM_WCKCFG       = 0x4  // Bit WCKCFG.
	SAI_AIM_MUTEDET_Pos  = 0x1  // Position of MUTEDET field.
	SAI_AIM_MUTEDET_Msk  = 0x2  // Bit mask of MUTEDET field.
	SAI_AIM_MUTEDET      = 0x2  // Bit MUTEDET.
	SAI_AIM_OVRUDRIE_Pos = 0x0  // Position of OVRUDRIE field.
	SAI_AIM_OVRUDRIE_Msk = 0x1  // Bit mask of OVRUDRIE field.
	SAI_AIM_OVRUDRIE     = 0x1  // Bit OVRUDRIE.

	// ASR: AStatus register
	SAI_ASR_FLVL_Pos    = 0x10    // Position of FLVL field.
	SAI_ASR_FLVL_Msk    = 0x70000 // Bit mask of FLVL field.
	SAI_ASR_LFSDET_Pos  = 0x6     // Position of LFSDET field.
	SAI_ASR_LFSDET_Msk  = 0x40    // Bit mask of LFSDET field.
	SAI_ASR_LFSDET      = 0x40    // Bit LFSDET.
	SAI_ASR_AFSDET_Pos  = 0x5     // Position of AFSDET field.
	SAI_ASR_AFSDET_Msk  = 0x20    // Bit mask of AFSDET field.
	SAI_ASR_AFSDET      = 0x20    // Bit AFSDET.
	SAI_ASR_CNRDY_Pos   = 0x4     // Position of CNRDY field.
	SAI_ASR_CNRDY_Msk   = 0x10    // Bit mask of CNRDY field.
	SAI_ASR_CNRDY       = 0x10    // Bit CNRDY.
	SAI_ASR_FREQ_Pos    = 0x3     // Position of FREQ field.
	SAI_ASR_FREQ_Msk    = 0x8     // Bit mask of FREQ field.
	SAI_ASR_FREQ        = 0x8     // Bit FREQ.
	SAI_ASR_WCKCFG_Pos  = 0x2     // Position of WCKCFG field.
	SAI_ASR_WCKCFG_Msk  = 0x4     // Bit mask of WCKCFG field.
	SAI_ASR_WCKCFG      = 0x4     // Bit WCKCFG.
	SAI_ASR_MUTEDET_Pos = 0x1     // Position of MUTEDET field.
	SAI_ASR_MUTEDET_Msk = 0x2     // Bit mask of MUTEDET field.
	SAI_ASR_MUTEDET     = 0x2     // Bit MUTEDET.
	SAI_ASR_OVRUDR_Pos  = 0x0     // Position of OVRUDR field.
	SAI_ASR_OVRUDR_Msk  = 0x1     // Bit mask of OVRUDR field.
	SAI_ASR_OVRUDR      = 0x1     // Bit OVRUDR.

	// ACLRFR: AClear flag register
	SAI_ACLRFR_LFSDET_Pos  = 0x6  // Position of LFSDET field.
	SAI_ACLRFR_LFSDET_Msk  = 0x40 // Bit mask of LFSDET field.
	SAI_ACLRFR_LFSDET      = 0x40 // Bit LFSDET.
	SAI_ACLRFR_CAFSDET_Pos = 0x5  // Position of CAFSDET field.
	SAI_ACLRFR_CAFSDET_Msk = 0x20 // Bit mask of CAFSDET field.
	SAI_ACLRFR_CAFSDET     = 0x20 // Bit CAFSDET.
	SAI_ACLRFR_CNRDY_Pos   = 0x4  // Position of CNRDY field.
	SAI_ACLRFR_CNRDY_Msk   = 0x10 // Bit mask of CNRDY field.
	SAI_ACLRFR_CNRDY       = 0x10 // Bit CNRDY.
	SAI_ACLRFR_WCKCFG_Pos  = 0x2  // Position of WCKCFG field.
	SAI_ACLRFR_WCKCFG_Msk  = 0x4  // Bit mask of WCKCFG field.
	SAI_ACLRFR_WCKCFG      = 0x4  // Bit WCKCFG.
	SAI_ACLRFR_MUTEDET_Pos = 0x1  // Position of MUTEDET field.
	SAI_ACLRFR_MUTEDET_Msk = 0x2  // Bit mask of MUTEDET field.
	SAI_ACLRFR_MUTEDET     = 0x2  // Bit MUTEDET.
	SAI_ACLRFR_OVRUDR_Pos  = 0x0  // Position of OVRUDR field.
	SAI_ACLRFR_OVRUDR_Msk  = 0x1  // Bit mask of OVRUDR field.
	SAI_ACLRFR_OVRUDR      = 0x1  // Bit OVRUDR.

	// ADR: AData register
	SAI_ADR_DATA_Pos = 0x0        // Position of DATA field.
	SAI_ADR_DATA_Msk = 0xffffffff // Bit mask of DATA field.

	// BCR1: BConfiguration register 1
	SAI_BCR1_MCJDIV_Pos   = 0x14     // Position of MCJDIV field.
	SAI_BCR1_MCJDIV_Msk   = 0xf00000 // Bit mask of MCJDIV field.
	SAI_BCR1_NODIV_Pos    = 0x13     // Position of NODIV field.
	SAI_BCR1_NODIV_Msk    = 0x80000  // Bit mask of NODIV field.
	SAI_BCR1_NODIV        = 0x80000  // Bit NODIV.
	SAI_BCR1_DMAEN_Pos    = 0x11     // Position of DMAEN field.
	SAI_BCR1_DMAEN_Msk    = 0x20000  // Bit mask of DMAEN field.
	SAI_BCR1_DMAEN        = 0x20000  // Bit DMAEN.
	SAI_BCR1_SAIBEN_Pos   = 0x10     // Position of SAIBEN field.
	SAI_BCR1_SAIBEN_Msk   = 0x10000  // Bit mask of SAIBEN field.
	SAI_BCR1_SAIBEN       = 0x10000  // Bit SAIBEN.
	SAI_BCR1_OutDri_Pos   = 0xd      // Position of OutDri field.
	SAI_BCR1_OutDri_Msk   = 0x2000   // Bit mask of OutDri field.
	SAI_BCR1_OutDri       = 0x2000   // Bit OutDri.
	SAI_BCR1_MONO_Pos     = 0xc      // Position of MONO field.
	SAI_BCR1_MONO_Msk     = 0x1000   // Bit mask of MONO field.
	SAI_BCR1_MONO         = 0x1000   // Bit MONO.
	SAI_BCR1_SYNCEN_Pos   = 0xa      // Position of SYNCEN field.
	SAI_BCR1_SYNCEN_Msk   = 0xc00    // Bit mask of SYNCEN field.
	SAI_BCR1_CKSTR_Pos    = 0x9      // Position of CKSTR field.
	SAI_BCR1_CKSTR_Msk    = 0x200    // Bit mask of CKSTR field.
	SAI_BCR1_CKSTR        = 0x200    // Bit CKSTR.
	SAI_BCR1_LSBFIRST_Pos = 0x8      // Position of LSBFIRST field.
	SAI_BCR1_LSBFIRST_Msk = 0x100    // Bit mask of LSBFIRST field.
	SAI_BCR1_LSBFIRST     = 0x100    // Bit LSBFIRST.
	SAI_BCR1_DS_Pos       = 0x5      // Position of DS field.
	SAI_BCR1_DS_Msk       = 0xe0     // Bit mask of DS field.
	SAI_BCR1_PRTCFG_Pos   = 0x2      // Position of PRTCFG field.
	SAI_BCR1_PRTCFG_Msk   = 0xc      // Bit mask of PRTCFG field.
	SAI_BCR1_MODE_Pos     = 0x0      // Position of MODE field.
	SAI_BCR1_MODE_Msk     = 0x3      // Bit mask of MODE field.

	// BCR2: BConfiguration register 2
	SAI_BCR2_COMP_Pos    = 0xe    // Position of COMP field.
	SAI_BCR2_COMP_Msk    = 0xc000 // Bit mask of COMP field.
	SAI_BCR2_CPL_Pos     = 0xd    // Position of CPL field.
	SAI_BCR2_CPL_Msk     = 0x2000 // Bit mask of CPL field.
	SAI_BCR2_CPL         = 0x2000 // Bit CPL.
	SAI_BCR2_MUTECN_Pos  = 0x7    // Position of MUTECN field.
	SAI_BCR2_MUTECN_Msk  = 0x1f80 // Bit mask of MUTECN field.
	SAI_BCR2_MUTEVAL_Pos = 0x6    // Position of MUTEVAL field.
	SAI_BCR2_MUTEVAL_Msk = 0x40   // Bit mask of MUTEVAL field.
	SAI_BCR2_MUTEVAL     = 0x40   // Bit MUTEVAL.
	SAI_BCR2_MUTE_Pos    = 0x5    // Position of MUTE field.
	SAI_BCR2_MUTE_Msk    = 0x20   // Bit mask of MUTE field.
	SAI_BCR2_MUTE        = 0x20   // Bit MUTE.
	SAI_BCR2_TRIS_Pos    = 0x4    // Position of TRIS field.
	SAI_BCR2_TRIS_Msk    = 0x10   // Bit mask of TRIS field.
	SAI_BCR2_TRIS        = 0x10   // Bit TRIS.
	SAI_BCR2_FFLUS_Pos   = 0x3    // Position of FFLUS field.
	SAI_BCR2_FFLUS_Msk   = 0x8    // Bit mask of FFLUS field.
	SAI_BCR2_FFLUS       = 0x8    // Bit FFLUS.
	SAI_BCR2_FTH_Pos     = 0x0    // Position of FTH field.
	SAI_BCR2_FTH_Msk     = 0x7    // Bit mask of FTH field.

	// BFRCR: BFRCR
	SAI_BFRCR_FSOFF_Pos = 0x12    // Position of FSOFF field.
	SAI_BFRCR_FSOFF_Msk = 0x40000 // Bit mask of FSOFF field.
	SAI_BFRCR_FSOFF     = 0x40000 // Bit FSOFF.
	SAI_BFRCR_FSPOL_Pos = 0x11    // Position of FSPOL field.
	SAI_BFRCR_FSPOL_Msk = 0x20000 // Bit mask of FSPOL field.
	SAI_BFRCR_FSPOL     = 0x20000 // Bit FSPOL.
	SAI_BFRCR_FSDEF_Pos = 0x10    // Position of FSDEF field.
	SAI_BFRCR_FSDEF_Msk = 0x10000 // Bit mask of FSDEF field.
	SAI_BFRCR_FSDEF     = 0x10000 // Bit FSDEF.
	SAI_BFRCR_FSALL_Pos = 0x8     // Position of FSALL field.
	SAI_BFRCR_FSALL_Msk = 0x7f00  // Bit mask of FSALL field.
	SAI_BFRCR_FRL_Pos   = 0x0     // Position of FRL field.
	SAI_BFRCR_FRL_Msk   = 0xff    // Bit mask of FRL field.

	// BSLOTR: BSlot register
	SAI_BSLOTR_SLOTEN_Pos = 0x10       // Position of SLOTEN field.
	SAI_BSLOTR_SLOTEN_Msk = 0xffff0000 // Bit mask of SLOTEN field.
	SAI_BSLOTR_NBSLOT_Pos = 0x8        // Position of NBSLOT field.
	SAI_BSLOTR_NBSLOT_Msk = 0xf00      // Bit mask of NBSLOT field.
	SAI_BSLOTR_SLOTSZ_Pos = 0x6        // Position of SLOTSZ field.
	SAI_BSLOTR_SLOTSZ_Msk = 0xc0       // Bit mask of SLOTSZ field.
	SAI_BSLOTR_FBOFF_Pos  = 0x0        // Position of FBOFF field.
	SAI_BSLOTR_FBOFF_Msk  = 0x1f       // Bit mask of FBOFF field.

	// BIM: BInterrupt mask register2
	SAI_BIM_LFSDETIE_Pos = 0x6  // Position of LFSDETIE field.
	SAI_BIM_LFSDETIE_Msk = 0x40 // Bit mask of LFSDETIE field.
	SAI_BIM_LFSDETIE     = 0x40 // Bit LFSDETIE.
	SAI_BIM_AFSDETIE_Pos = 0x5  // Position of AFSDETIE field.
	SAI_BIM_AFSDETIE_Msk = 0x20 // Bit mask of AFSDETIE field.
	SAI_BIM_AFSDETIE     = 0x20 // Bit AFSDETIE.
	SAI_BIM_CNRDYIE_Pos  = 0x4  // Position of CNRDYIE field.
	SAI_BIM_CNRDYIE_Msk  = 0x10 // Bit mask of CNRDYIE field.
	SAI_BIM_CNRDYIE      = 0x10 // Bit CNRDYIE.
	SAI_BIM_FREQIE_Pos   = 0x3  // Position of FREQIE field.
	SAI_BIM_FREQIE_Msk   = 0x8  // Bit mask of FREQIE field.
	SAI_BIM_FREQIE       = 0x8  // Bit FREQIE.
	SAI_BIM_WCKCFG_Pos   = 0x2  // Position of WCKCFG field.
	SAI_BIM_WCKCFG_Msk   = 0x4  // Bit mask of WCKCFG field.
	SAI_BIM_WCKCFG       = 0x4  // Bit WCKCFG.
	SAI_BIM_MUTEDET_Pos  = 0x1  // Position of MUTEDET field.
	SAI_BIM_MUTEDET_Msk  = 0x2  // Bit mask of MUTEDET field.
	SAI_BIM_MUTEDET      = 0x2  // Bit MUTEDET.
	SAI_BIM_OVRUDRIE_Pos = 0x0  // Position of OVRUDRIE field.
	SAI_BIM_OVRUDRIE_Msk = 0x1  // Bit mask of OVRUDRIE field.
	SAI_BIM_OVRUDRIE     = 0x1  // Bit OVRUDRIE.

	// BSR: BStatus register
	SAI_BSR_FLVL_Pos    = 0x10    // Position of FLVL field.
	SAI_BSR_FLVL_Msk    = 0x70000 // Bit mask of FLVL field.
	SAI_BSR_LFSDET_Pos  = 0x6     // Position of LFSDET field.
	SAI_BSR_LFSDET_Msk  = 0x40    // Bit mask of LFSDET field.
	SAI_BSR_LFSDET      = 0x40    // Bit LFSDET.
	SAI_BSR_AFSDET_Pos  = 0x5     // Position of AFSDET field.
	SAI_BSR_AFSDET_Msk  = 0x20    // Bit mask of AFSDET field.
	SAI_BSR_AFSDET      = 0x20    // Bit AFSDET.
	SAI_BSR_CNRDY_Pos   = 0x4     // Position of CNRDY field.
	SAI_BSR_CNRDY_Msk   = 0x10    // Bit mask of CNRDY field.
	SAI_BSR_CNRDY       = 0x10    // Bit CNRDY.
	SAI_BSR_FREQ_Pos    = 0x3     // Position of FREQ field.
	SAI_BSR_FREQ_Msk    = 0x8     // Bit mask of FREQ field.
	SAI_BSR_FREQ        = 0x8     // Bit FREQ.
	SAI_BSR_WCKCFG_Pos  = 0x2     // Position of WCKCFG field.
	SAI_BSR_WCKCFG_Msk  = 0x4     // Bit mask of WCKCFG field.
	SAI_BSR_WCKCFG      = 0x4     // Bit WCKCFG.
	SAI_BSR_MUTEDET_Pos = 0x1     // Position of MUTEDET field.
	SAI_BSR_MUTEDET_Msk = 0x2     // Bit mask of MUTEDET field.
	SAI_BSR_MUTEDET     = 0x2     // Bit MUTEDET.
	SAI_BSR_OVRUDR_Pos  = 0x0     // Position of OVRUDR field.
	SAI_BSR_OVRUDR_Msk  = 0x1     // Bit mask of OVRUDR field.
	SAI_BSR_OVRUDR      = 0x1     // Bit OVRUDR.

	// BCLRFR: BClear flag register
	SAI_BCLRFR_LFSDET_Pos  = 0x6  // Position of LFSDET field.
	SAI_BCLRFR_LFSDET_Msk  = 0x40 // Bit mask of LFSDET field.
	SAI_BCLRFR_LFSDET      = 0x40 // Bit LFSDET.
	SAI_BCLRFR_CAFSDET_Pos = 0x5  // Position of CAFSDET field.
	SAI_BCLRFR_CAFSDET_Msk = 0x20 // Bit mask of CAFSDET field.
	SAI_BCLRFR_CAFSDET     = 0x20 // Bit CAFSDET.
	SAI_BCLRFR_CNRDY_Pos   = 0x4  // Position of CNRDY field.
	SAI_BCLRFR_CNRDY_Msk   = 0x10 // Bit mask of CNRDY field.
	SAI_BCLRFR_CNRDY       = 0x10 // Bit CNRDY.
	SAI_BCLRFR_WCKCFG_Pos  = 0x2  // Position of WCKCFG field.
	SAI_BCLRFR_WCKCFG_Msk  = 0x4  // Bit mask of WCKCFG field.
	SAI_BCLRFR_WCKCFG      = 0x4  // Bit WCKCFG.
	SAI_BCLRFR_MUTEDET_Pos = 0x1  // Position of MUTEDET field.
	SAI_BCLRFR_MUTEDET_Msk = 0x2  // Bit mask of MUTEDET field.
	SAI_BCLRFR_MUTEDET     = 0x2  // Bit MUTEDET.
	SAI_BCLRFR_OVRUDR_Pos  = 0x0  // Position of OVRUDR field.
	SAI_BCLRFR_OVRUDR_Msk  = 0x1  // Bit mask of OVRUDR field.
	SAI_BCLRFR_OVRUDR      = 0x1  // Bit OVRUDR.

	// BDR: BData register
	SAI_BDR_DATA_Pos = 0x0        // Position of DATA field.
	SAI_BDR_DATA_Msk = 0xffffffff // Bit mask of DATA field.
)

// Bitfields for DMA2D: DMA2D controller
const (
	// CR: control register
	DMA2D_CR_MODE_Pos  = 0x10    // Position of MODE field.
	DMA2D_CR_MODE_Msk  = 0x30000 // Bit mask of MODE field.
	DMA2D_CR_CEIE_Pos  = 0xd     // Position of CEIE field.
	DMA2D_CR_CEIE_Msk  = 0x2000  // Bit mask of CEIE field.
	DMA2D_CR_CEIE      = 0x2000  // Bit CEIE.
	DMA2D_CR_CTCIE_Pos = 0xc     // Position of CTCIE field.
	DMA2D_CR_CTCIE_Msk = 0x1000  // Bit mask of CTCIE field.
	DMA2D_CR_CTCIE     = 0x1000  // Bit CTCIE.
	DMA2D_CR_CAEIE_Pos = 0xb     // Position of CAEIE field.
	DMA2D_CR_CAEIE_Msk = 0x800   // Bit mask of CAEIE field.
	DMA2D_CR_CAEIE     = 0x800   // Bit CAEIE.
	DMA2D_CR_TWIE_Pos  = 0xa     // Position of TWIE field.
	DMA2D_CR_TWIE_Msk  = 0x400   // Bit mask of TWIE field.
	DMA2D_CR_TWIE      = 0x400   // Bit TWIE.
	DMA2D_CR_TCIE_Pos  = 0x9     // Position of TCIE field.
	DMA2D_CR_TCIE_Msk  = 0x200   // Bit mask of TCIE field.
	DMA2D_CR_TCIE      = 0x200   // Bit TCIE.
	DMA2D_CR_TEIE_Pos  = 0x8     // Position of TEIE field.
	DMA2D_CR_TEIE_Msk  = 0x100   // Bit mask of TEIE field.
	DMA2D_CR_TEIE      = 0x100   // Bit TEIE.
	DMA2D_CR_ABORT_Pos = 0x2     // Position of ABORT field.
	DMA2D_CR_ABORT_Msk = 0x4     // Bit mask of ABORT field.
	DMA2D_CR_ABORT     = 0x4     // Bit ABORT.
	DMA2D_CR_SUSP_Pos  = 0x1     // Position of SUSP field.
	DMA2D_CR_SUSP_Msk  = 0x2     // Bit mask of SUSP field.
	DMA2D_CR_SUSP      = 0x2     // Bit SUSP.
	DMA2D_CR_START_Pos = 0x0     // Position of START field.
	DMA2D_CR_START_Msk = 0x1     // Bit mask of START field.
	DMA2D_CR_START     = 0x1     // Bit START.

	// ISR: Interrupt Status Register
	DMA2D_ISR_CEIF_Pos  = 0x5  // Position of CEIF field.
	DMA2D_ISR_CEIF_Msk  = 0x20 // Bit mask of CEIF field.
	DMA2D_ISR_CEIF      = 0x20 // Bit CEIF.
	DMA2D_ISR_CTCIF_Pos = 0x4  // Position of CTCIF field.
	DMA2D_ISR_CTCIF_Msk = 0x10 // Bit mask of CTCIF field.
	DMA2D_ISR_CTCIF     = 0x10 // Bit CTCIF.
	DMA2D_ISR_CAEIF_Pos = 0x3  // Position of CAEIF field.
	DMA2D_ISR_CAEIF_Msk = 0x8  // Bit mask of CAEIF field.
	DMA2D_ISR_CAEIF     = 0x8  // Bit CAEIF.
	DMA2D_ISR_TWIF_Pos  = 0x2  // Position of TWIF field.
	DMA2D_ISR_TWIF_Msk  = 0x4  // Bit mask of TWIF field.
	DMA2D_ISR_TWIF      = 0x4  // Bit TWIF.
	DMA2D_ISR_TCIF_Pos  = 0x1  // Position of TCIF field.
	DMA2D_ISR_TCIF_Msk  = 0x2  // Bit mask of TCIF field.
	DMA2D_ISR_TCIF      = 0x2  // Bit TCIF.
	DMA2D_ISR_TEIF_Pos  = 0x0  // Position of TEIF field.
	DMA2D_ISR_TEIF_Msk  = 0x1  // Bit mask of TEIF field.
	DMA2D_ISR_TEIF      = 0x1  // Bit TEIF.

	// IFCR: interrupt flag clear register
	DMA2D_IFCR_CCEIF_Pos  = 0x5  // Position of CCEIF field.
	DMA2D_IFCR_CCEIF_Msk  = 0x20 // Bit mask of CCEIF field.
	DMA2D_IFCR_CCEIF      = 0x20 // Bit CCEIF.
	DMA2D_IFCR_CCTCIF_Pos = 0x4  // Position of CCTCIF field.
	DMA2D_IFCR_CCTCIF_Msk = 0x10 // Bit mask of CCTCIF field.
	DMA2D_IFCR_CCTCIF     = 0x10 // Bit CCTCIF.
	DMA2D_IFCR_CAECIF_Pos = 0x3  // Position of CAECIF field.
	DMA2D_IFCR_CAECIF_Msk = 0x8  // Bit mask of CAECIF field.
	DMA2D_IFCR_CAECIF     = 0x8  // Bit CAECIF.
	DMA2D_IFCR_CTWIF_Pos  = 0x2  // Position of CTWIF field.
	DMA2D_IFCR_CTWIF_Msk  = 0x4  // Bit mask of CTWIF field.
	DMA2D_IFCR_CTWIF      = 0x4  // Bit CTWIF.
	DMA2D_IFCR_CTCIF_Pos  = 0x1  // Position of CTCIF field.
	DMA2D_IFCR_CTCIF_Msk  = 0x2  // Bit mask of CTCIF field.
	DMA2D_IFCR_CTCIF      = 0x2  // Bit CTCIF.
	DMA2D_IFCR_CTEIF_Pos  = 0x0  // Position of CTEIF field.
	DMA2D_IFCR_CTEIF_Msk  = 0x1  // Bit mask of CTEIF field.
	DMA2D_IFCR_CTEIF      = 0x1  // Bit CTEIF.

	// FGMAR: foreground memory address           register
	DMA2D_FGMAR_MA_Pos = 0x0        // Position of MA field.
	DMA2D_FGMAR_MA_Msk = 0xffffffff // Bit mask of MA field.

	// FGOR: foreground offset register
	DMA2D_FGOR_LO_Pos = 0x0    // Position of LO field.
	DMA2D_FGOR_LO_Msk = 0x3fff // Bit mask of LO field.

	// BGMAR: background memory address           register
	DMA2D_BGMAR_MA_Pos = 0x0        // Position of MA field.
	DMA2D_BGMAR_MA_Msk = 0xffffffff // Bit mask of MA field.

	// BGOR: background offset register
	DMA2D_BGOR_LO_Pos = 0x0    // Position of LO field.
	DMA2D_BGOR_LO_Msk = 0x3fff // Bit mask of LO field.

	// FGPFCCR: foreground PFC control           register
	DMA2D_FGPFCCR_ALPHA_Pos = 0x18       // Position of ALPHA field.
	DMA2D_FGPFCCR_ALPHA_Msk = 0xff000000 // Bit mask of ALPHA field.
	DMA2D_FGPFCCR_AM_Pos    = 0x10       // Position of AM field.
	DMA2D_FGPFCCR_AM_Msk    = 0x30000    // Bit mask of AM field.
	DMA2D_FGPFCCR_CS_Pos    = 0x8        // Position of CS field.
	DMA2D_FGPFCCR_CS_Msk    = 0xff00     // Bit mask of CS field.
	DMA2D_FGPFCCR_START_Pos = 0x5        // Position of START field.
	DMA2D_FGPFCCR_START_Msk = 0x20       // Bit mask of START field.
	DMA2D_FGPFCCR_START     = 0x20       // Bit START.
	DMA2D_FGPFCCR_CCM_Pos   = 0x4        // Position of CCM field.
	DMA2D_FGPFCCR_CCM_Msk   = 0x10       // Bit mask of CCM field.
	DMA2D_FGPFCCR_CCM       = 0x10       // Bit CCM.
	DMA2D_FGPFCCR_CM_Pos    = 0x0        // Position of CM field.
	DMA2D_FGPFCCR_CM_Msk    = 0xf        // Bit mask of CM field.

	// FGCOLR: foreground color register
	DMA2D_FGCOLR_RED_Pos   = 0x10     // Position of RED field.
	DMA2D_FGCOLR_RED_Msk   = 0xff0000 // Bit mask of RED field.
	DMA2D_FGCOLR_GREEN_Pos = 0x8      // Position of GREEN field.
	DMA2D_FGCOLR_GREEN_Msk = 0xff00   // Bit mask of GREEN field.
	DMA2D_FGCOLR_BLUE_Pos  = 0x0      // Position of BLUE field.
	DMA2D_FGCOLR_BLUE_Msk  = 0xff     // Bit mask of BLUE field.

	// BGPFCCR: background PFC control           register
	DMA2D_BGPFCCR_ALPHA_Pos = 0x18       // Position of ALPHA field.
	DMA2D_BGPFCCR_ALPHA_Msk = 0xff000000 // Bit mask of ALPHA field.
	DMA2D_BGPFCCR_AM_Pos    = 0x10       // Position of AM field.
	DMA2D_BGPFCCR_AM_Msk    = 0x30000    // Bit mask of AM field.
	DMA2D_BGPFCCR_CS_Pos    = 0x8        // Position of CS field.
	DMA2D_BGPFCCR_CS_Msk    = 0xff00     // Bit mask of CS field.
	DMA2D_BGPFCCR_START_Pos = 0x5        // Position of START field.
	DMA2D_BGPFCCR_START_Msk = 0x20       // Bit mask of START field.
	DMA2D_BGPFCCR_START     = 0x20       // Bit START.
	DMA2D_BGPFCCR_CCM_Pos   = 0x4        // Position of CCM field.
	DMA2D_BGPFCCR_CCM_Msk   = 0x10       // Bit mask of CCM field.
	DMA2D_BGPFCCR_CCM       = 0x10       // Bit CCM.
	DMA2D_BGPFCCR_CM_Pos    = 0x0        // Position of CM field.
	DMA2D_BGPFCCR_CM_Msk    = 0xf        // Bit mask of CM field.

	// BGCOLR: background color register
	DMA2D_BGCOLR_RED_Pos   = 0x10     // Position of RED field.
	DMA2D_BGCOLR_RED_Msk   = 0xff0000 // Bit mask of RED field.
	DMA2D_BGCOLR_GREEN_Pos = 0x8      // Position of GREEN field.
	DMA2D_BGCOLR_GREEN_Msk = 0xff00   // Bit mask of GREEN field.
	DMA2D_BGCOLR_BLUE_Pos  = 0x0      // Position of BLUE field.
	DMA2D_BGCOLR_BLUE_Msk  = 0xff     // Bit mask of BLUE field.

	// FGCMAR: foreground CLUT memory address           register
	DMA2D_FGCMAR_MA_Pos = 0x0        // Position of MA field.
	DMA2D_FGCMAR_MA_Msk = 0xffffffff // Bit mask of MA field.

	// BGCMAR: background CLUT memory address           register
	DMA2D_BGCMAR_MA_Pos = 0x0        // Position of MA field.
	DMA2D_BGCMAR_MA_Msk = 0xffffffff // Bit mask of MA field.

	// OPFCCR: output PFC control register
	DMA2D_OPFCCR_CM_Pos = 0x0 // Position of CM field.
	DMA2D_OPFCCR_CM_Msk = 0x7 // Bit mask of CM field.

	// OCOLR: output color register
	DMA2D_OCOLR_APLHA_Pos = 0x18       // Position of APLHA field.
	DMA2D_OCOLR_APLHA_Msk = 0xff000000 // Bit mask of APLHA field.
	DMA2D_OCOLR_RED_Pos   = 0x10       // Position of RED field.
	DMA2D_OCOLR_RED_Msk   = 0xff0000   // Bit mask of RED field.
	DMA2D_OCOLR_GREEN_Pos = 0x8        // Position of GREEN field.
	DMA2D_OCOLR_GREEN_Msk = 0xff00     // Bit mask of GREEN field.
	DMA2D_OCOLR_BLUE_Pos  = 0x0        // Position of BLUE field.
	DMA2D_OCOLR_BLUE_Msk  = 0xff       // Bit mask of BLUE field.

	// OMAR: output memory address register
	DMA2D_OMAR_MA_Pos = 0x0        // Position of MA field.
	DMA2D_OMAR_MA_Msk = 0xffffffff // Bit mask of MA field.

	// OOR: output offset register
	DMA2D_OOR_LO_Pos = 0x0    // Position of LO field.
	DMA2D_OOR_LO_Msk = 0x3fff // Bit mask of LO field.

	// NLR: number of line register
	DMA2D_NLR_PL_Pos = 0x10       // Position of PL field.
	DMA2D_NLR_PL_Msk = 0x3fff0000 // Bit mask of PL field.
	DMA2D_NLR_NL_Pos = 0x0        // Position of NL field.
	DMA2D_NLR_NL_Msk = 0xffff     // Bit mask of NL field.

	// LWR: line watermark register
	DMA2D_LWR_LW_Pos = 0x0    // Position of LW field.
	DMA2D_LWR_LW_Msk = 0xffff // Bit mask of LW field.

	// AMTCR: AHB master timer configuration           register
	DMA2D_AMTCR_DT_Pos = 0x8    // Position of DT field.
	DMA2D_AMTCR_DT_Msk = 0xff00 // Bit mask of DT field.
	DMA2D_AMTCR_EN_Pos = 0x0    // Position of EN field.
	DMA2D_AMTCR_EN_Msk = 0x1    // Bit mask of EN field.
	DMA2D_AMTCR_EN     = 0x1    // Bit EN.

	// FGCLUT: FGCLUT
	DMA2D_FGCLUT_APLHA_Pos = 0x18       // Position of APLHA field.
	DMA2D_FGCLUT_APLHA_Msk = 0xff000000 // Bit mask of APLHA field.
	DMA2D_FGCLUT_RED_Pos   = 0x10       // Position of RED field.
	DMA2D_FGCLUT_RED_Msk   = 0xff0000   // Bit mask of RED field.
	DMA2D_FGCLUT_GREEN_Pos = 0x8        // Position of GREEN field.
	DMA2D_FGCLUT_GREEN_Msk = 0xff00     // Bit mask of GREEN field.
	DMA2D_FGCLUT_BLUE_Pos  = 0x0        // Position of BLUE field.
	DMA2D_FGCLUT_BLUE_Msk  = 0xff       // Bit mask of BLUE field.

	// BGCLUT: BGCLUT
	DMA2D_BGCLUT_APLHA_Pos = 0x18       // Position of APLHA field.
	DMA2D_BGCLUT_APLHA_Msk = 0xff000000 // Bit mask of APLHA field.
	DMA2D_BGCLUT_RED_Pos   = 0x10       // Position of RED field.
	DMA2D_BGCLUT_RED_Msk   = 0xff0000   // Bit mask of RED field.
	DMA2D_BGCLUT_GREEN_Pos = 0x8        // Position of GREEN field.
	DMA2D_BGCLUT_GREEN_Msk = 0xff00     // Bit mask of GREEN field.
	DMA2D_BGCLUT_BLUE_Pos  = 0x0        // Position of BLUE field.
	DMA2D_BGCLUT_BLUE_Msk  = 0xff       // Bit mask of BLUE field.
)

// Bitfields for QUADSPI: QuadSPI interface
const (
	// CR: control register
	QUADSPI_CR_PRESCALER_Pos = 0x18       // Position of PRESCALER field.
	QUADSPI_CR_PRESCALER_Msk = 0xff000000 // Bit mask of PRESCALER field.
	QUADSPI_CR_PMM_Pos       = 0x17       // Position of PMM field.
	QUADSPI_CR_PMM_Msk       = 0x800000   // Bit mask of PMM field.
	QUADSPI_CR_PMM           = 0x800000   // Bit PMM.
	QUADSPI_CR_APMS_Pos      = 0x16       // Position of APMS field.
	QUADSPI_CR_APMS_Msk      = 0x400000   // Bit mask of APMS field.
	QUADSPI_CR_APMS          = 0x400000   // Bit APMS.
	QUADSPI_CR_TOIE_Pos      = 0x14       // Position of TOIE field.
	QUADSPI_CR_TOIE_Msk      = 0x100000   // Bit mask of TOIE field.
	QUADSPI_CR_TOIE          = 0x100000   // Bit TOIE.
	QUADSPI_CR_SMIE_Pos      = 0x13       // Position of SMIE field.
	QUADSPI_CR_SMIE_Msk      = 0x80000    // Bit mask of SMIE field.
	QUADSPI_CR_SMIE          = 0x80000    // Bit SMIE.
	QUADSPI_CR_FTIE_Pos      = 0x12       // Position of FTIE field.
	QUADSPI_CR_FTIE_Msk      = 0x40000    // Bit mask of FTIE field.
	QUADSPI_CR_FTIE          = 0x40000    // Bit FTIE.
	QUADSPI_CR_TCIE_Pos      = 0x11       // Position of TCIE field.
	QUADSPI_CR_TCIE_Msk      = 0x20000    // Bit mask of TCIE field.
	QUADSPI_CR_TCIE          = 0x20000    // Bit TCIE.
	QUADSPI_CR_TEIE_Pos      = 0x10       // Position of TEIE field.
	QUADSPI_CR_TEIE_Msk      = 0x10000    // Bit mask of TEIE field.
	QUADSPI_CR_TEIE          = 0x10000    // Bit TEIE.
	QUADSPI_CR_FTHRES_Pos    = 0x8        // Position of FTHRES field.
	QUADSPI_CR_FTHRES_Msk    = 0x1f00     // Bit mask of FTHRES field.
	QUADSPI_CR_FSEL_Pos      = 0x7        // Position of FSEL field.
	QUADSPI_CR_FSEL_Msk      = 0x80       // Bit mask of FSEL field.
	QUADSPI_CR_FSEL          = 0x80       // Bit FSEL.
	QUADSPI_CR_DFM_Pos       = 0x6        // Position of DFM field.
	QUADSPI_CR_DFM_Msk       = 0x40       // Bit mask of DFM field.
	QUADSPI_CR_DFM           = 0x40       // Bit DFM.
	QUADSPI_CR_SSHIFT_Pos    = 0x4        // Position of SSHIFT field.
	QUADSPI_CR_SSHIFT_Msk    = 0x10       // Bit mask of SSHIFT field.
	QUADSPI_CR_SSHIFT        = 0x10       // Bit SSHIFT.
	QUADSPI_CR_TCEN_Pos      = 0x3        // Position of TCEN field.
	QUADSPI_CR_TCEN_Msk      = 0x8        // Bit mask of TCEN field.
	QUADSPI_CR_TCEN          = 0x8        // Bit TCEN.
	QUADSPI_CR_DMAEN_Pos     = 0x2        // Position of DMAEN field.
	QUADSPI_CR_DMAEN_Msk     = 0x4        // Bit mask of DMAEN field.
	QUADSPI_CR_DMAEN         = 0x4        // Bit DMAEN.
	QUADSPI_CR_ABORT_Pos     = 0x1        // Position of ABORT field.
	QUADSPI_CR_ABORT_Msk     = 0x2        // Bit mask of ABORT field.
	QUADSPI_CR_ABORT         = 0x2        // Bit ABORT.
	QUADSPI_CR_EN_Pos        = 0x0        // Position of EN field.
	QUADSPI_CR_EN_Msk        = 0x1        // Bit mask of EN field.
	QUADSPI_CR_EN            = 0x1        // Bit EN.

	// DCR: device configuration register
	QUADSPI_DCR_FSIZE_Pos  = 0x10     // Position of FSIZE field.
	QUADSPI_DCR_FSIZE_Msk  = 0x1f0000 // Bit mask of FSIZE field.
	QUADSPI_DCR_CSHT_Pos   = 0x8      // Position of CSHT field.
	QUADSPI_DCR_CSHT_Msk   = 0x700    // Bit mask of CSHT field.
	QUADSPI_DCR_CKMODE_Pos = 0x0      // Position of CKMODE field.
	QUADSPI_DCR_CKMODE_Msk = 0x1      // Bit mask of CKMODE field.
	QUADSPI_DCR_CKMODE     = 0x1      // Bit CKMODE.

	// SR: status register
	QUADSPI_SR_FLEVEL_Pos = 0x8    // Position of FLEVEL field.
	QUADSPI_SR_FLEVEL_Msk = 0x7f00 // Bit mask of FLEVEL field.
	QUADSPI_SR_BUSY_Pos   = 0x5    // Position of BUSY field.
	QUADSPI_SR_BUSY_Msk   = 0x20   // Bit mask of BUSY field.
	QUADSPI_SR_BUSY       = 0x20   // Bit BUSY.
	QUADSPI_SR_TOF_Pos    = 0x4    // Position of TOF field.
	QUADSPI_SR_TOF_Msk    = 0x10   // Bit mask of TOF field.
	QUADSPI_SR_TOF        = 0x10   // Bit TOF.
	QUADSPI_SR_SMF_Pos    = 0x3    // Position of SMF field.
	QUADSPI_SR_SMF_Msk    = 0x8    // Bit mask of SMF field.
	QUADSPI_SR_SMF        = 0x8    // Bit SMF.
	QUADSPI_SR_FTF_Pos    = 0x2    // Position of FTF field.
	QUADSPI_SR_FTF_Msk    = 0x4    // Bit mask of FTF field.
	QUADSPI_SR_FTF        = 0x4    // Bit FTF.
	QUADSPI_SR_TCF_Pos    = 0x1    // Position of TCF field.
	QUADSPI_SR_TCF_Msk    = 0x2    // Bit mask of TCF field.
	QUADSPI_SR_TCF        = 0x2    // Bit TCF.
	QUADSPI_SR_TEF_Pos    = 0x0    // Position of TEF field.
	QUADSPI_SR_TEF_Msk    = 0x1    // Bit mask of TEF field.
	QUADSPI_SR_TEF        = 0x1    // Bit TEF.

	// FCR: flag clear register
	QUADSPI_FCR_CTOF_Pos = 0x4  // Position of CTOF field.
	QUADSPI_FCR_CTOF_Msk = 0x10 // Bit mask of CTOF field.
	QUADSPI_FCR_CTOF     = 0x10 // Bit CTOF.
	QUADSPI_FCR_CSMF_Pos = 0x3  // Position of CSMF field.
	QUADSPI_FCR_CSMF_Msk = 0x8  // Bit mask of CSMF field.
	QUADSPI_FCR_CSMF     = 0x8  // Bit CSMF.
	QUADSPI_FCR_CTCF_Pos = 0x1  // Position of CTCF field.
	QUADSPI_FCR_CTCF_Msk = 0x2  // Bit mask of CTCF field.
	QUADSPI_FCR_CTCF     = 0x2  // Bit CTCF.
	QUADSPI_FCR_CTEF_Pos = 0x0  // Position of CTEF field.
	QUADSPI_FCR_CTEF_Msk = 0x1  // Bit mask of CTEF field.
	QUADSPI_FCR_CTEF     = 0x1  // Bit CTEF.

	// DLR: data length register
	QUADSPI_DLR_DL_Pos = 0x0        // Position of DL field.
	QUADSPI_DLR_DL_Msk = 0xffffffff // Bit mask of DL field.

	// CCR: communication configuration           register
	QUADSPI_CCR_DDRM_Pos        = 0x1f       // Position of DDRM field.
	QUADSPI_CCR_DDRM_Msk        = 0x80000000 // Bit mask of DDRM field.
	QUADSPI_CCR_DDRM            = 0x80000000 // Bit DDRM.
	QUADSPI_CCR_DHHC_Pos        = 0x1e       // Position of DHHC field.
	QUADSPI_CCR_DHHC_Msk        = 0x40000000 // Bit mask of DHHC field.
	QUADSPI_CCR_DHHC            = 0x40000000 // Bit DHHC.
	QUADSPI_CCR_SIOO_Pos        = 0x1c       // Position of SIOO field.
	QUADSPI_CCR_SIOO_Msk        = 0x10000000 // Bit mask of SIOO field.
	QUADSPI_CCR_SIOO            = 0x10000000 // Bit SIOO.
	QUADSPI_CCR_FMODE_Pos       = 0x1a       // Position of FMODE field.
	QUADSPI_CCR_FMODE_Msk       = 0xc000000  // Bit mask of FMODE field.
	QUADSPI_CCR_DMODE_Pos       = 0x18       // Position of DMODE field.
	QUADSPI_CCR_DMODE_Msk       = 0x3000000  // Bit mask of DMODE field.
	QUADSPI_CCR_DCYC_Pos        = 0x12       // Position of DCYC field.
	QUADSPI_CCR_DCYC_Msk        = 0x7c0000   // Bit mask of DCYC field.
	QUADSPI_CCR_ABSIZE_Pos      = 0x10       // Position of ABSIZE field.
	QUADSPI_CCR_ABSIZE_Msk      = 0x30000    // Bit mask of ABSIZE field.
	QUADSPI_CCR_ABMODE_Pos      = 0xe        // Position of ABMODE field.
	QUADSPI_CCR_ABMODE_Msk      = 0xc000     // Bit mask of ABMODE field.
	QUADSPI_CCR_ADSIZE_Pos      = 0xc        // Position of ADSIZE field.
	QUADSPI_CCR_ADSIZE_Msk      = 0x3000     // Bit mask of ADSIZE field.
	QUADSPI_CCR_ADMODE_Pos      = 0xa        // Position of ADMODE field.
	QUADSPI_CCR_ADMODE_Msk      = 0xc00      // Bit mask of ADMODE field.
	QUADSPI_CCR_IMODE_Pos       = 0x8        // Position of IMODE field.
	QUADSPI_CCR_IMODE_Msk       = 0x300      // Bit mask of IMODE field.
	QUADSPI_CCR_INSTRUCTION_Pos = 0x0        // Position of INSTRUCTION field.
	QUADSPI_CCR_INSTRUCTION_Msk = 0xff       // Bit mask of INSTRUCTION field.

	// AR: address register
	QUADSPI_AR_ADDRESS_Pos = 0x0        // Position of ADDRESS field.
	QUADSPI_AR_ADDRESS_Msk = 0xffffffff // Bit mask of ADDRESS field.

	// ABR: ABR
	QUADSPI_ABR_ALTERNATE_Pos = 0x0        // Position of ALTERNATE field.
	QUADSPI_ABR_ALTERNATE_Msk = 0xffffffff // Bit mask of ALTERNATE field.

	// DR: data register
	QUADSPI_DR_DATA_Pos = 0x0        // Position of DATA field.
	QUADSPI_DR_DATA_Msk = 0xffffffff // Bit mask of DATA field.

	// PSMKR: polling status mask register
	QUADSPI_PSMKR_MASK_Pos = 0x0        // Position of MASK field.
	QUADSPI_PSMKR_MASK_Msk = 0xffffffff // Bit mask of MASK field.

	// PSMAR: polling status match register
	QUADSPI_PSMAR_MATCH_Pos = 0x0        // Position of MATCH field.
	QUADSPI_PSMAR_MATCH_Msk = 0xffffffff // Bit mask of MATCH field.

	// PIR: polling interval register
	QUADSPI_PIR_INTERVAL_Pos = 0x0    // Position of INTERVAL field.
	QUADSPI_PIR_INTERVAL_Msk = 0xffff // Bit mask of INTERVAL field.

	// LPTR: low-power timeout register
	QUADSPI_LPTR_TIMEOUT_Pos = 0x0    // Position of TIMEOUT field.
	QUADSPI_LPTR_TIMEOUT_Msk = 0xffff // Bit mask of TIMEOUT field.
)

// Bitfields for CEC: HDMI-CEC controller
const (
	// CR: control register
	CEC_CR_TXEOM_Pos = 0x2 // Position of TXEOM field.
	CEC_CR_TXEOM_Msk = 0x4 // Bit mask of TXEOM field.
	CEC_CR_TXEOM     = 0x4 // Bit TXEOM.
	CEC_CR_TXSOM_Pos = 0x1 // Position of TXSOM field.
	CEC_CR_TXSOM_Msk = 0x2 // Bit mask of TXSOM field.
	CEC_CR_TXSOM     = 0x2 // Bit TXSOM.
	CEC_CR_CECEN_Pos = 0x0 // Position of CECEN field.
	CEC_CR_CECEN_Msk = 0x1 // Bit mask of CECEN field.
	CEC_CR_CECEN     = 0x1 // Bit CECEN.

	// CFGR: configuration register
	CEC_CFGR_SFT_Pos      = 0x0        // Position of SFT field.
	CEC_CFGR_SFT_Msk      = 0x7        // Bit mask of SFT field.
	CEC_CFGR_RXTOL_Pos    = 0x3        // Position of RXTOL field.
	CEC_CFGR_RXTOL_Msk    = 0x8        // Bit mask of RXTOL field.
	CEC_CFGR_RXTOL        = 0x8        // Bit RXTOL.
	CEC_CFGR_BRESTP_Pos   = 0x4        // Position of BRESTP field.
	CEC_CFGR_BRESTP_Msk   = 0x10       // Bit mask of BRESTP field.
	CEC_CFGR_BRESTP       = 0x10       // Bit BRESTP.
	CEC_CFGR_BREGEN_Pos   = 0x5        // Position of BREGEN field.
	CEC_CFGR_BREGEN_Msk   = 0x20       // Bit mask of BREGEN field.
	CEC_CFGR_BREGEN       = 0x20       // Bit BREGEN.
	CEC_CFGR_LBPEGEN_Pos  = 0x6        // Position of LBPEGEN field.
	CEC_CFGR_LBPEGEN_Msk  = 0x40       // Bit mask of LBPEGEN field.
	CEC_CFGR_LBPEGEN      = 0x40       // Bit LBPEGEN.
	CEC_CFGR_BRDNOGEN_Pos = 0x7        // Position of BRDNOGEN field.
	CEC_CFGR_BRDNOGEN_Msk = 0x80       // Bit mask of BRDNOGEN field.
	CEC_CFGR_BRDNOGEN     = 0x80       // Bit BRDNOGEN.
	CEC_CFGR_SFTOP_Pos    = 0x8        // Position of SFTOP field.
	CEC_CFGR_SFTOP_Msk    = 0x100      // Bit mask of SFTOP field.
	CEC_CFGR_SFTOP        = 0x100      // Bit SFTOP.
	CEC_CFGR_OAR_Pos      = 0x10       // Position of OAR field.
	CEC_CFGR_OAR_Msk      = 0x7fff0000 // Bit mask of OAR field.
	CEC_CFGR_LSTN_Pos     = 0x1f       // Position of LSTN field.
	CEC_CFGR_LSTN_Msk     = 0x80000000 // Bit mask of LSTN field.
	CEC_CFGR_LSTN         = 0x80000000 // Bit LSTN.

	// TXDR: Tx data register
	CEC_TXDR_TXD_Pos = 0x0  // Position of TXD field.
	CEC_TXDR_TXD_Msk = 0xff // Bit mask of TXD field.

	// RXDR: Rx Data Register
	CEC_RXDR_RXDR_Pos = 0x0  // Position of RXDR field.
	CEC_RXDR_RXDR_Msk = 0xff // Bit mask of RXDR field.

	// ISR: Interrupt and Status Register
	CEC_ISR_TXACKE_Pos = 0xc    // Position of TXACKE field.
	CEC_ISR_TXACKE_Msk = 0x1000 // Bit mask of TXACKE field.
	CEC_ISR_TXACKE     = 0x1000 // Bit TXACKE.
	CEC_ISR_TXERR_Pos  = 0xb    // Position of TXERR field.
	CEC_ISR_TXERR_Msk  = 0x800  // Bit mask of TXERR field.
	CEC_ISR_TXERR      = 0x800  // Bit TXERR.
	CEC_ISR_TXUDR_Pos  = 0xa    // Position of TXUDR field.
	CEC_ISR_TXUDR_Msk  = 0x400  // Bit mask of TXUDR field.
	CEC_ISR_TXUDR      = 0x400  // Bit TXUDR.
	CEC_ISR_TXEND_Pos  = 0x9    // Position of TXEND field.
	CEC_ISR_TXEND_Msk  = 0x200  // Bit mask of TXEND field.
	CEC_ISR_TXEND      = 0x200  // Bit TXEND.
	CEC_ISR_TXBR_Pos   = 0x8    // Position of TXBR field.
	CEC_ISR_TXBR_Msk   = 0x100  // Bit mask of TXBR field.
	CEC_ISR_TXBR       = 0x100  // Bit TXBR.
	CEC_ISR_ARBLST_Pos = 0x7    // Position of ARBLST field.
	CEC_ISR_ARBLST_Msk = 0x80   // Bit mask of ARBLST field.
	CEC_ISR_ARBLST     = 0x80   // Bit ARBLST.
	CEC_ISR_RXACKE_Pos = 0x6    // Position of RXACKE field.
	CEC_ISR_RXACKE_Msk = 0x40   // Bit mask of RXACKE field.
	CEC_ISR_RXACKE     = 0x40   // Bit RXACKE.
	CEC_ISR_LBPE_Pos   = 0x5    // Position of LBPE field.
	CEC_ISR_LBPE_Msk   = 0x20   // Bit mask of LBPE field.
	CEC_ISR_LBPE       = 0x20   // Bit LBPE.
	CEC_ISR_SBPE_Pos   = 0x4    // Position of SBPE field.
	CEC_ISR_SBPE_Msk   = 0x10   // Bit mask of SBPE field.
	CEC_ISR_SBPE       = 0x10   // Bit SBPE.
	CEC_ISR_BRE_Pos    = 0x3    // Position of BRE field.
	CEC_ISR_BRE_Msk    = 0x8    // Bit mask of BRE field.
	CEC_ISR_BRE        = 0x8    // Bit BRE.
	CEC_ISR_RXOVR_Pos  = 0x2    // Position of RXOVR field.
	CEC_ISR_RXOVR_Msk  = 0x4    // Bit mask of RXOVR field.
	CEC_ISR_RXOVR      = 0x4    // Bit RXOVR.
	CEC_ISR_RXEND_Pos  = 0x1    // Position of RXEND field.
	CEC_ISR_RXEND_Msk  = 0x2    // Bit mask of RXEND field.
	CEC_ISR_RXEND      = 0x2    // Bit RXEND.
	CEC_ISR_RXBR_Pos   = 0x0    // Position of RXBR field.
	CEC_ISR_RXBR_Msk   = 0x1    // Bit mask of RXBR field.
	CEC_ISR_RXBR       = 0x1    // Bit RXBR.

	// IER: interrupt enable register
	CEC_IER_TXACKIE_Pos  = 0xc    // Position of TXACKIE field.
	CEC_IER_TXACKIE_Msk  = 0x1000 // Bit mask of TXACKIE field.
	CEC_IER_TXACKIE      = 0x1000 // Bit TXACKIE.
	CEC_IER_TXERRIE_Pos  = 0xb    // Position of TXERRIE field.
	CEC_IER_TXERRIE_Msk  = 0x800  // Bit mask of TXERRIE field.
	CEC_IER_TXERRIE      = 0x800  // Bit TXERRIE.
	CEC_IER_TXUDRIE_Pos  = 0xa    // Position of TXUDRIE field.
	CEC_IER_TXUDRIE_Msk  = 0x400  // Bit mask of TXUDRIE field.
	CEC_IER_TXUDRIE      = 0x400  // Bit TXUDRIE.
	CEC_IER_TXENDIE_Pos  = 0x9    // Position of TXENDIE field.
	CEC_IER_TXENDIE_Msk  = 0x200  // Bit mask of TXENDIE field.
	CEC_IER_TXENDIE      = 0x200  // Bit TXENDIE.
	CEC_IER_TXBRIE_Pos   = 0x8    // Position of TXBRIE field.
	CEC_IER_TXBRIE_Msk   = 0x100  // Bit mask of TXBRIE field.
	CEC_IER_TXBRIE       = 0x100  // Bit TXBRIE.
	CEC_IER_ARBLSTIE_Pos = 0x7    // Position of ARBLSTIE field.
	CEC_IER_ARBLSTIE_Msk = 0x80   // Bit mask of ARBLSTIE field.
	CEC_IER_ARBLSTIE     = 0x80   // Bit ARBLSTIE.
	CEC_IER_RXACKIE_Pos  = 0x6    // Position of RXACKIE field.
	CEC_IER_RXACKIE_Msk  = 0x40   // Bit mask of RXACKIE field.
	CEC_IER_RXACKIE      = 0x40   // Bit RXACKIE.
	CEC_IER_LBPEIE_Pos   = 0x5    // Position of LBPEIE field.
	CEC_IER_LBPEIE_Msk   = 0x20   // Bit mask of LBPEIE field.
	CEC_IER_LBPEIE       = 0x20   // Bit LBPEIE.
	CEC_IER_SBPEIE_Pos   = 0x4    // Position of SBPEIE field.
	CEC_IER_SBPEIE_Msk   = 0x10   // Bit mask of SBPEIE field.
	CEC_IER_SBPEIE       = 0x10   // Bit SBPEIE.
	CEC_IER_BREIE_Pos    = 0x3    // Position of BREIE field.
	CEC_IER_BREIE_Msk    = 0x8    // Bit mask of BREIE field.
	CEC_IER_BREIE        = 0x8    // Bit BREIE.
	CEC_IER_RXOVRIE_Pos  = 0x2    // Position of RXOVRIE field.
	CEC_IER_RXOVRIE_Msk  = 0x4    // Bit mask of RXOVRIE field.
	CEC_IER_RXOVRIE      = 0x4    // Bit RXOVRIE.
	CEC_IER_RXENDIE_Pos  = 0x1    // Position of RXENDIE field.
	CEC_IER_RXENDIE_Msk  = 0x2    // Bit mask of RXENDIE field.
	CEC_IER_RXENDIE      = 0x2    // Bit RXENDIE.
	CEC_IER_RXBRIE_Pos   = 0x0    // Position of RXBRIE field.
	CEC_IER_RXBRIE_Msk   = 0x1    // Bit mask of RXBRIE field.
	CEC_IER_RXBRIE       = 0x1    // Bit RXBRIE.
)

// Bitfields for SPDIFRX: Receiver Interface
const (
	// CR: Control register
	SPDIF_RX_CR_SPDIFEN_Pos = 0x0     // Position of SPDIFEN field.
	SPDIF_RX_CR_SPDIFEN_Msk = 0x3     // Bit mask of SPDIFEN field.
	SPDIF_RX_CR_RXDMAEN_Pos = 0x2     // Position of RXDMAEN field.
	SPDIF_RX_CR_RXDMAEN_Msk = 0x4     // Bit mask of RXDMAEN field.
	SPDIF_RX_CR_RXDMAEN     = 0x4     // Bit RXDMAEN.
	SPDIF_RX_CR_RXSTEO_Pos  = 0x3     // Position of RXSTEO field.
	SPDIF_RX_CR_RXSTEO_Msk  = 0x8     // Bit mask of RXSTEO field.
	SPDIF_RX_CR_RXSTEO      = 0x8     // Bit RXSTEO.
	SPDIF_RX_CR_DRFMT_Pos   = 0x4     // Position of DRFMT field.
	SPDIF_RX_CR_DRFMT_Msk   = 0x30    // Bit mask of DRFMT field.
	SPDIF_RX_CR_PMSK_Pos    = 0x6     // Position of PMSK field.
	SPDIF_RX_CR_PMSK_Msk    = 0x40    // Bit mask of PMSK field.
	SPDIF_RX_CR_PMSK        = 0x40    // Bit PMSK.
	SPDIF_RX_CR_VMSK_Pos    = 0x7     // Position of VMSK field.
	SPDIF_RX_CR_VMSK_Msk    = 0x80    // Bit mask of VMSK field.
	SPDIF_RX_CR_VMSK        = 0x80    // Bit VMSK.
	SPDIF_RX_CR_CUMSK_Pos   = 0x8     // Position of CUMSK field.
	SPDIF_RX_CR_CUMSK_Msk   = 0x100   // Bit mask of CUMSK field.
	SPDIF_RX_CR_CUMSK       = 0x100   // Bit CUMSK.
	SPDIF_RX_CR_PTMSK_Pos   = 0x9     // Position of PTMSK field.
	SPDIF_RX_CR_PTMSK_Msk   = 0x200   // Bit mask of PTMSK field.
	SPDIF_RX_CR_PTMSK       = 0x200   // Bit PTMSK.
	SPDIF_RX_CR_CBDMAEN_Pos = 0xa     // Position of CBDMAEN field.
	SPDIF_RX_CR_CBDMAEN_Msk = 0x400   // Bit mask of CBDMAEN field.
	SPDIF_RX_CR_CBDMAEN     = 0x400   // Bit CBDMAEN.
	SPDIF_RX_CR_CHSEL_Pos   = 0xb     // Position of CHSEL field.
	SPDIF_RX_CR_CHSEL_Msk   = 0x800   // Bit mask of CHSEL field.
	SPDIF_RX_CR_CHSEL       = 0x800   // Bit CHSEL.
	SPDIF_RX_CR_NBTR_Pos    = 0xc     // Position of NBTR field.
	SPDIF_RX_CR_NBTR_Msk    = 0x3000  // Bit mask of NBTR field.
	SPDIF_RX_CR_WFA_Pos     = 0xe     // Position of WFA field.
	SPDIF_RX_CR_WFA_Msk     = 0x4000  // Bit mask of WFA field.
	SPDIF_RX_CR_WFA         = 0x4000  // Bit WFA.
	SPDIF_RX_CR_INSEL_Pos   = 0x10    // Position of INSEL field.
	SPDIF_RX_CR_INSEL_Msk   = 0x70000 // Bit mask of INSEL field.

	// IMR: Interrupt mask register
	SPDIF_RX_IMR_RXNEIE_Pos  = 0x0  // Position of RXNEIE field.
	SPDIF_RX_IMR_RXNEIE_Msk  = 0x1  // Bit mask of RXNEIE field.
	SPDIF_RX_IMR_RXNEIE      = 0x1  // Bit RXNEIE.
	SPDIF_RX_IMR_CSRNEIE_Pos = 0x1  // Position of CSRNEIE field.
	SPDIF_RX_IMR_CSRNEIE_Msk = 0x2  // Bit mask of CSRNEIE field.
	SPDIF_RX_IMR_CSRNEIE     = 0x2  // Bit CSRNEIE.
	SPDIF_RX_IMR_PERRIE_Pos  = 0x2  // Position of PERRIE field.
	SPDIF_RX_IMR_PERRIE_Msk  = 0x4  // Bit mask of PERRIE field.
	SPDIF_RX_IMR_PERRIE      = 0x4  // Bit PERRIE.
	SPDIF_RX_IMR_OVRIE_Pos   = 0x3  // Position of OVRIE field.
	SPDIF_RX_IMR_OVRIE_Msk   = 0x8  // Bit mask of OVRIE field.
	SPDIF_RX_IMR_OVRIE       = 0x8  // Bit OVRIE.
	SPDIF_RX_IMR_SBLKIE_Pos  = 0x4  // Position of SBLKIE field.
	SPDIF_RX_IMR_SBLKIE_Msk  = 0x10 // Bit mask of SBLKIE field.
	SPDIF_RX_IMR_SBLKIE      = 0x10 // Bit SBLKIE.
	SPDIF_RX_IMR_SYNCDIE_Pos = 0x5  // Position of SYNCDIE field.
	SPDIF_RX_IMR_SYNCDIE_Msk = 0x20 // Bit mask of SYNCDIE field.
	SPDIF_RX_IMR_SYNCDIE     = 0x20 // Bit SYNCDIE.
	SPDIF_RX_IMR_IFEIE_Pos   = 0x6  // Position of IFEIE field.
	SPDIF_RX_IMR_IFEIE_Msk   = 0x40 // Bit mask of IFEIE field.
	SPDIF_RX_IMR_IFEIE       = 0x40 // Bit IFEIE.

	// SR: Status register
	SPDIF_RX_SR_RXNE_Pos   = 0x0        // Position of RXNE field.
	SPDIF_RX_SR_RXNE_Msk   = 0x1        // Bit mask of RXNE field.
	SPDIF_RX_SR_RXNE       = 0x1        // Bit RXNE.
	SPDIF_RX_SR_CSRNE_Pos  = 0x1        // Position of CSRNE field.
	SPDIF_RX_SR_CSRNE_Msk  = 0x2        // Bit mask of CSRNE field.
	SPDIF_RX_SR_CSRNE      = 0x2        // Bit CSRNE.
	SPDIF_RX_SR_PERR_Pos   = 0x2        // Position of PERR field.
	SPDIF_RX_SR_PERR_Msk   = 0x4        // Bit mask of PERR field.
	SPDIF_RX_SR_PERR       = 0x4        // Bit PERR.
	SPDIF_RX_SR_OVR_Pos    = 0x3        // Position of OVR field.
	SPDIF_RX_SR_OVR_Msk    = 0x8        // Bit mask of OVR field.
	SPDIF_RX_SR_OVR        = 0x8        // Bit OVR.
	SPDIF_RX_SR_SBD_Pos    = 0x4        // Position of SBD field.
	SPDIF_RX_SR_SBD_Msk    = 0x10       // Bit mask of SBD field.
	SPDIF_RX_SR_SBD        = 0x10       // Bit SBD.
	SPDIF_RX_SR_SYNCD_Pos  = 0x5        // Position of SYNCD field.
	SPDIF_RX_SR_SYNCD_Msk  = 0x20       // Bit mask of SYNCD field.
	SPDIF_RX_SR_SYNCD      = 0x20       // Bit SYNCD.
	SPDIF_RX_SR_FERR_Pos   = 0x6        // Position of FERR field.
	SPDIF_RX_SR_FERR_Msk   = 0x40       // Bit mask of FERR field.
	SPDIF_RX_SR_FERR       = 0x40       // Bit FERR.
	SPDIF_RX_SR_SERR_Pos   = 0x7        // Position of SERR field.
	SPDIF_RX_SR_SERR_Msk   = 0x80       // Bit mask of SERR field.
	SPDIF_RX_SR_SERR       = 0x80       // Bit SERR.
	SPDIF_RX_SR_TERR_Pos   = 0x8        // Position of TERR field.
	SPDIF_RX_SR_TERR_Msk   = 0x100      // Bit mask of TERR field.
	SPDIF_RX_SR_TERR       = 0x100      // Bit TERR.
	SPDIF_RX_SR_WIDTH5_Pos = 0x10       // Position of WIDTH5 field.
	SPDIF_RX_SR_WIDTH5_Msk = 0x7fff0000 // Bit mask of WIDTH5 field.

	// IFCR: Interrupt Flag Clear register
	SPDIF_RX_IFCR_PERRCF_Pos  = 0x2  // Position of PERRCF field.
	SPDIF_RX_IFCR_PERRCF_Msk  = 0x4  // Bit mask of PERRCF field.
	SPDIF_RX_IFCR_PERRCF      = 0x4  // Bit PERRCF.
	SPDIF_RX_IFCR_OVRCF_Pos   = 0x3  // Position of OVRCF field.
	SPDIF_RX_IFCR_OVRCF_Msk   = 0x8  // Bit mask of OVRCF field.
	SPDIF_RX_IFCR_OVRCF       = 0x8  // Bit OVRCF.
	SPDIF_RX_IFCR_SBDCF_Pos   = 0x4  // Position of SBDCF field.
	SPDIF_RX_IFCR_SBDCF_Msk   = 0x10 // Bit mask of SBDCF field.
	SPDIF_RX_IFCR_SBDCF       = 0x10 // Bit SBDCF.
	SPDIF_RX_IFCR_SYNCDCF_Pos = 0x5  // Position of SYNCDCF field.
	SPDIF_RX_IFCR_SYNCDCF_Msk = 0x20 // Bit mask of SYNCDCF field.
	SPDIF_RX_IFCR_SYNCDCF     = 0x20 // Bit SYNCDCF.

	// DR: Data input register
	SPDIF_RX_DR_DR_Pos = 0x0        // Position of DR field.
	SPDIF_RX_DR_DR_Msk = 0xffffff   // Bit mask of DR field.
	SPDIF_RX_DR_PE_Pos = 0x18       // Position of PE field.
	SPDIF_RX_DR_PE_Msk = 0x1000000  // Bit mask of PE field.
	SPDIF_RX_DR_PE     = 0x1000000  // Bit PE.
	SPDIF_RX_DR_V_Pos  = 0x19       // Position of V field.
	SPDIF_RX_DR_V_Msk  = 0x2000000  // Bit mask of V field.
	SPDIF_RX_DR_V      = 0x2000000  // Bit V.
	SPDIF_RX_DR_U_Pos  = 0x1a       // Position of U field.
	SPDIF_RX_DR_U_Msk  = 0x4000000  // Bit mask of U field.
	SPDIF_RX_DR_U      = 0x4000000  // Bit U.
	SPDIF_RX_DR_C_Pos  = 0x1b       // Position of C field.
	SPDIF_RX_DR_C_Msk  = 0x8000000  // Bit mask of C field.
	SPDIF_RX_DR_C      = 0x8000000  // Bit C.
	SPDIF_RX_DR_PT_Pos = 0x1c       // Position of PT field.
	SPDIF_RX_DR_PT_Msk = 0x30000000 // Bit mask of PT field.

	// CSR: Channel Status register
	SPDIF_RX_CSR_USR_Pos = 0x0       // Position of USR field.
	SPDIF_RX_CSR_USR_Msk = 0xffff    // Bit mask of USR field.
	SPDIF_RX_CSR_CS_Pos  = 0x10      // Position of CS field.
	SPDIF_RX_CSR_CS_Msk  = 0xff0000  // Bit mask of CS field.
	SPDIF_RX_CSR_SOB_Pos = 0x18      // Position of SOB field.
	SPDIF_RX_CSR_SOB_Msk = 0x1000000 // Bit mask of SOB field.
	SPDIF_RX_CSR_SOB     = 0x1000000 // Bit SOB.

	// DIR: Debug Information register
	SPDIF_RX_DIR_THI_Pos = 0x0        // Position of THI field.
	SPDIF_RX_DIR_THI_Msk = 0x1fff     // Bit mask of THI field.
	SPDIF_RX_DIR_TLO_Pos = 0x10       // Position of TLO field.
	SPDIF_RX_DIR_TLO_Msk = 0x1fff0000 // Bit mask of TLO field.
)

// Bitfields for SDMMC1: Secure digital input/output interface
const (
	// POWER: power control register
	SDMMC_POWER_PWRCTRL_Pos = 0x0 // Position of PWRCTRL field.
	SDMMC_POWER_PWRCTRL_Msk = 0x3 // Bit mask of PWRCTRL field.

	// CLKCR: SDI clock control register
	SDMMC_CLKCR_HWFC_EN_Pos = 0xe    // Position of HWFC_EN field.
	SDMMC_CLKCR_HWFC_EN_Msk = 0x4000 // Bit mask of HWFC_EN field.
	SDMMC_CLKCR_HWFC_EN     = 0x4000 // Bit HWFC_EN.
	SDMMC_CLKCR_NEGEDGE_Pos = 0xd    // Position of NEGEDGE field.
	SDMMC_CLKCR_NEGEDGE_Msk = 0x2000 // Bit mask of NEGEDGE field.
	SDMMC_CLKCR_NEGEDGE     = 0x2000 // Bit NEGEDGE.
	SDMMC_CLKCR_WIDBUS_Pos  = 0xb    // Position of WIDBUS field.
	SDMMC_CLKCR_WIDBUS_Msk  = 0x1800 // Bit mask of WIDBUS field.
	SDMMC_CLKCR_BYPASS_Pos  = 0xa    // Position of BYPASS field.
	SDMMC_CLKCR_BYPASS_Msk  = 0x400  // Bit mask of BYPASS field.
	SDMMC_CLKCR_BYPASS      = 0x400  // Bit BYPASS.
	SDMMC_CLKCR_PWRSAV_Pos  = 0x9    // Position of PWRSAV field.
	SDMMC_CLKCR_PWRSAV_Msk  = 0x200  // Bit mask of PWRSAV field.
	SDMMC_CLKCR_PWRSAV      = 0x200  // Bit PWRSAV.
	SDMMC_CLKCR_CLKEN_Pos   = 0x8    // Position of CLKEN field.
	SDMMC_CLKCR_CLKEN_Msk   = 0x100  // Bit mask of CLKEN field.
	SDMMC_CLKCR_CLKEN       = 0x100  // Bit CLKEN.
	SDMMC_CLKCR_CLKDIV_Pos  = 0x0    // Position of CLKDIV field.
	SDMMC_CLKCR_CLKDIV_Msk  = 0xff   // Bit mask of CLKDIV field.

	// ARG: argument register
	SDMMC_ARG_CMDARG_Pos = 0x0        // Position of CMDARG field.
	SDMMC_ARG_CMDARG_Msk = 0xffffffff // Bit mask of CMDARG field.

	// CMD: command register
	SDMMC_CMD_CE_ATACMD_Pos   = 0xe    // Position of CE_ATACMD field.
	SDMMC_CMD_CE_ATACMD_Msk   = 0x4000 // Bit mask of CE_ATACMD field.
	SDMMC_CMD_CE_ATACMD       = 0x4000 // Bit CE_ATACMD.
	SDMMC_CMD_NIEN_Pos        = 0xd    // Position of NIEN field.
	SDMMC_CMD_NIEN_Msk        = 0x2000 // Bit mask of NIEN field.
	SDMMC_CMD_NIEN            = 0x2000 // Bit NIEN.
	SDMMC_CMD_ENCMDcompl_Pos  = 0xc    // Position of ENCMDcompl field.
	SDMMC_CMD_ENCMDcompl_Msk  = 0x1000 // Bit mask of ENCMDcompl field.
	SDMMC_CMD_ENCMDcompl      = 0x1000 // Bit ENCMDcompl.
	SDMMC_CMD_SDIOSuspend_Pos = 0xb    // Position of SDIOSuspend field.
	SDMMC_CMD_SDIOSuspend_Msk = 0x800  // Bit mask of SDIOSuspend field.
	SDMMC_CMD_SDIOSuspend     = 0x800  // Bit SDIOSuspend.
	SDMMC_CMD_CPSMEN_Pos      = 0xa    // Position of CPSMEN field.
	SDMMC_CMD_CPSMEN_Msk      = 0x400  // Bit mask of CPSMEN field.
	SDMMC_CMD_CPSMEN          = 0x400  // Bit CPSMEN.
	SDMMC_CMD_WAITPEND_Pos    = 0x9    // Position of WAITPEND field.
	SDMMC_CMD_WAITPEND_Msk    = 0x200  // Bit mask of WAITPEND field.
	SDMMC_CMD_WAITPEND        = 0x200  // Bit WAITPEND.
	SDMMC_CMD_WAITINT_Pos     = 0x8    // Position of WAITINT field.
	SDMMC_CMD_WAITINT_Msk     = 0x100  // Bit mask of WAITINT field.
	SDMMC_CMD_WAITINT         = 0x100  // Bit WAITINT.
	SDMMC_CMD_WAITRESP_Pos    = 0x6    // Position of WAITRESP field.
	SDMMC_CMD_WAITRESP_Msk    = 0xc0   // Bit mask of WAITRESP field.
	SDMMC_CMD_CMDINDEX_Pos    = 0x0    // Position of CMDINDEX field.
	SDMMC_CMD_CMDINDEX_Msk    = 0x3f   // Bit mask of CMDINDEX field.

	// RESPCMD: command response register
	SDMMC_RESPCMD_RESPCMD_Pos = 0x0  // Position of RESPCMD field.
	SDMMC_RESPCMD_RESPCMD_Msk = 0x3f // Bit mask of RESPCMD field.

	// RESP1: response 1..4 register
	SDMMC_RESP1_CARDSTATUS1_Pos = 0x0        // Position of CARDSTATUS1 field.
	SDMMC_RESP1_CARDSTATUS1_Msk = 0xffffffff // Bit mask of CARDSTATUS1 field.

	// RESP2: response 1..4 register
	SDMMC_RESP2_CARDSTATUS2_Pos = 0x0        // Position of CARDSTATUS2 field.
	SDMMC_RESP2_CARDSTATUS2_Msk = 0xffffffff // Bit mask of CARDSTATUS2 field.

	// RESP3: response 1..4 register
	SDMMC_RESP3_CARDSTATUS3_Pos = 0x0        // Position of CARDSTATUS3 field.
	SDMMC_RESP3_CARDSTATUS3_Msk = 0xffffffff // Bit mask of CARDSTATUS3 field.

	// RESP4: response 1..4 register
	SDMMC_RESP4_CARDSTATUS4_Pos = 0x0        // Position of CARDSTATUS4 field.
	SDMMC_RESP4_CARDSTATUS4_Msk = 0xffffffff // Bit mask of CARDSTATUS4 field.

	// DTIMER: data timer register
	SDMMC_DTIMER_DATATIME_Pos = 0x0        // Position of DATATIME field.
	SDMMC_DTIMER_DATATIME_Msk = 0xffffffff // Bit mask of DATATIME field.

	// DLEN: data length register
	SDMMC_DLEN_DATALENGTH_Pos = 0x0       // Position of DATALENGTH field.
	SDMMC_DLEN_DATALENGTH_Msk = 0x1ffffff // Bit mask of DATALENGTH field.

	// DCTRL: data control register
	SDMMC_DCTRL_SDIOEN_Pos     = 0xb   // Position of SDIOEN field.
	SDMMC_DCTRL_SDIOEN_Msk     = 0x800 // Bit mask of SDIOEN field.
	SDMMC_DCTRL_SDIOEN         = 0x800 // Bit SDIOEN.
	SDMMC_DCTRL_RWMOD_Pos      = 0xa   // Position of RWMOD field.
	SDMMC_DCTRL_RWMOD_Msk      = 0x400 // Bit mask of RWMOD field.
	SDMMC_DCTRL_RWMOD          = 0x400 // Bit RWMOD.
	SDMMC_DCTRL_RWSTOP_Pos     = 0x9   // Position of RWSTOP field.
	SDMMC_DCTRL_RWSTOP_Msk     = 0x200 // Bit mask of RWSTOP field.
	SDMMC_DCTRL_RWSTOP         = 0x200 // Bit RWSTOP.
	SDMMC_DCTRL_RWSTART_Pos    = 0x8   // Position of RWSTART field.
	SDMMC_DCTRL_RWSTART_Msk    = 0x100 // Bit mask of RWSTART field.
	SDMMC_DCTRL_RWSTART        = 0x100 // Bit RWSTART.
	SDMMC_DCTRL_DBLOCKSIZE_Pos = 0x4   // Position of DBLOCKSIZE field.
	SDMMC_DCTRL_DBLOCKSIZE_Msk = 0xf0  // Bit mask of DBLOCKSIZE field.
	SDMMC_DCTRL_DMAEN_Pos      = 0x3   // Position of DMAEN field.
	SDMMC_DCTRL_DMAEN_Msk      = 0x8   // Bit mask of DMAEN field.
	SDMMC_DCTRL_DMAEN          = 0x8   // Bit DMAEN.
	SDMMC_DCTRL_DTMODE_Pos     = 0x2   // Position of DTMODE field.
	SDMMC_DCTRL_DTMODE_Msk     = 0x4   // Bit mask of DTMODE field.
	SDMMC_DCTRL_DTMODE         = 0x4   // Bit DTMODE.
	SDMMC_DCTRL_DTDIR_Pos      = 0x1   // Position of DTDIR field.
	SDMMC_DCTRL_DTDIR_Msk      = 0x2   // Bit mask of DTDIR field.
	SDMMC_DCTRL_DTDIR          = 0x2   // Bit DTDIR.
	SDMMC_DCTRL_DTEN_Pos       = 0x0   // Position of DTEN field.
	SDMMC_DCTRL_DTEN_Msk       = 0x1   // Bit mask of DTEN field.
	SDMMC_DCTRL_DTEN           = 0x1   // Bit DTEN.

	// DCOUNT: data counter register
	SDMMC_DCOUNT_DATACOUNT_Pos = 0x0       // Position of DATACOUNT field.
	SDMMC_DCOUNT_DATACOUNT_Msk = 0x1ffffff // Bit mask of DATACOUNT field.

	// STA: status register
	SDMMC_STA_CEATAEND_Pos = 0x17     // Position of CEATAEND field.
	SDMMC_STA_CEATAEND_Msk = 0x800000 // Bit mask of CEATAEND field.
	SDMMC_STA_CEATAEND     = 0x800000 // Bit CEATAEND.
	SDMMC_STA_SDIOIT_Pos   = 0x16     // Position of SDIOIT field.
	SDMMC_STA_SDIOIT_Msk   = 0x400000 // Bit mask of SDIOIT field.
	SDMMC_STA_SDIOIT       = 0x400000 // Bit SDIOIT.
	SDMMC_STA_RXDAVL_Pos   = 0x15     // Position of RXDAVL field.
	SDMMC_STA_RXDAVL_Msk   = 0x200000 // Bit mask of RXDAVL field.
	SDMMC_STA_RXDAVL       = 0x200000 // Bit RXDAVL.
	SDMMC_STA_TXDAVL_Pos   = 0x14     // Position of TXDAVL field.
	SDMMC_STA_TXDAVL_Msk   = 0x100000 // Bit mask of TXDAVL field.
	SDMMC_STA_TXDAVL       = 0x100000 // Bit TXDAVL.
	SDMMC_STA_RXFIFOE_Pos  = 0x13     // Position of RXFIFOE field.
	SDMMC_STA_RXFIFOE_Msk  = 0x80000  // Bit mask of RXFIFOE field.
	SDMMC_STA_RXFIFOE      = 0x80000  // Bit RXFIFOE.
	SDMMC_STA_TXFIFOE_Pos  = 0x12     // Position of TXFIFOE field.
	SDMMC_STA_TXFIFOE_Msk  = 0x40000  // Bit mask of TXFIFOE field.
	SDMMC_STA_TXFIFOE      = 0x40000  // Bit TXFIFOE.
	SDMMC_STA_RXFIFOF_Pos  = 0x11     // Position of RXFIFOF field.
	SDMMC_STA_RXFIFOF_Msk  = 0x20000  // Bit mask of RXFIFOF field.
	SDMMC_STA_RXFIFOF      = 0x20000  // Bit RXFIFOF.
	SDMMC_STA_TXFIFOF_Pos  = 0x10     // Position of TXFIFOF field.
	SDMMC_STA_TXFIFOF_Msk  = 0x10000  // Bit mask of TXFIFOF field.
	SDMMC_STA_TXFIFOF      = 0x10000  // Bit TXFIFOF.
	SDMMC_STA_RXFIFOHF_Pos = 0xf      // Position of RXFIFOHF field.
	SDMMC_STA_RXFIFOHF_Msk = 0x8000   // Bit mask of RXFIFOHF field.
	SDMMC_STA_RXFIFOHF     = 0x8000   // Bit RXFIFOHF.
	SDMMC_STA_TXFIFOHE_Pos = 0xe      // Position of TXFIFOHE field.
	SDMMC_STA_TXFIFOHE_Msk = 0x4000   // Bit mask of TXFIFOHE field.
	SDMMC_STA_TXFIFOHE     = 0x4000   // Bit TXFIFOHE.
	SDMMC_STA_RXACT_Pos    = 0xd      // Position of RXACT field.
	SDMMC_STA_RXACT_Msk    = 0x2000   // Bit mask of RXACT field.
	SDMMC_STA_RXACT        = 0x2000   // Bit RXACT.
	SDMMC_STA_TXACT_Pos    = 0xc      // Position of TXACT field.
	SDMMC_STA_TXACT_Msk    = 0x1000   // Bit mask of TXACT field.
	SDMMC_STA_TXACT        = 0x1000   // Bit TXACT.
	SDMMC_STA_CMDACT_Pos   = 0xb      // Position of CMDACT field.
	SDMMC_STA_CMDACT_Msk   = 0x800    // Bit mask of CMDACT field.
	SDMMC_STA_CMDACT       = 0x800    // Bit CMDACT.
	SDMMC_STA_DBCKEND_Pos  = 0xa      // Position of DBCKEND field.
	SDMMC_STA_DBCKEND_Msk  = 0x400    // Bit mask of DBCKEND field.
	SDMMC_STA_DBCKEND      = 0x400    // Bit DBCKEND.
	SDMMC_STA_STBITERR_Pos = 0x9      // Position of STBITERR field.
	SDMMC_STA_STBITERR_Msk = 0x200    // Bit mask of STBITERR field.
	SDMMC_STA_STBITERR     = 0x200    // Bit STBITERR.
	SDMMC_STA_DATAEND_Pos  = 0x8      // Position of DATAEND field.
	SDMMC_STA_DATAEND_Msk  = 0x100    // Bit mask of DATAEND field.
	SDMMC_STA_DATAEND      = 0x100    // Bit DATAEND.
	SDMMC_STA_CMDSENT_Pos  = 0x7      // Position of CMDSENT field.
	SDMMC_STA_CMDSENT_Msk  = 0x80     // Bit mask of CMDSENT field.
	SDMMC_STA_CMDSENT      = 0x80     // Bit CMDSENT.
	SDMMC_STA_CMDREND_Pos  = 0x6      // Position of CMDREND field.
	SDMMC_STA_CMDREND_Msk  = 0x40     // Bit mask of CMDREND field.
	SDMMC_STA_CMDREND      = 0x40     // Bit CMDREND.
	SDMMC_STA_RXOVERR_Pos  = 0x5      // Position of RXOVERR field.
	SDMMC_STA_RXOVERR_Msk  = 0x20     // Bit mask of RXOVERR field.
	SDMMC_STA_RXOVERR      = 0x20     // Bit RXOVERR.
	SDMMC_STA_TXUNDERR_Pos = 0x4      // Position of TXUNDERR field.
	SDMMC_STA_TXUNDERR_Msk = 0x10     // Bit mask of TXUNDERR field.
	SDMMC_STA_TXUNDERR     = 0x10     // Bit TXUNDERR.
	SDMMC_STA_DTIMEOUT_Pos = 0x3      // Position of DTIMEOUT field.
	SDMMC_STA_DTIMEOUT_Msk = 0x8      // Bit mask of DTIMEOUT field.
	SDMMC_STA_DTIMEOUT     = 0x8      // Bit DTIMEOUT.
	SDMMC_STA_CTIMEOUT_Pos = 0x2      // Position of CTIMEOUT field.
	SDMMC_STA_CTIMEOUT_Msk = 0x4      // Bit mask of CTIMEOUT field.
	SDMMC_STA_CTIMEOUT     = 0x4      // Bit CTIMEOUT.
	SDMMC_STA_DCRCFAIL_Pos = 0x1      // Position of DCRCFAIL field.
	SDMMC_STA_DCRCFAIL_Msk = 0x2      // Bit mask of DCRCFAIL field.
	SDMMC_STA_DCRCFAIL     = 0x2      // Bit DCRCFAIL.
	SDMMC_STA_CCRCFAIL_Pos = 0x0      // Position of CCRCFAIL field.
	SDMMC_STA_CCRCFAIL_Msk = 0x1      // Bit mask of CCRCFAIL field.
	SDMMC_STA_CCRCFAIL     = 0x1      // Bit CCRCFAIL.

	// ICR: interrupt clear register
	SDMMC_ICR_CEATAENDC_Pos = 0x17     // Position of CEATAENDC field.
	SDMMC_ICR_CEATAENDC_Msk = 0x800000 // Bit mask of CEATAENDC field.
	SDMMC_ICR_CEATAENDC     = 0x800000 // Bit CEATAENDC.
	SDMMC_ICR_SDIOITC_Pos   = 0x16     // Position of SDIOITC field.
	SDMMC_ICR_SDIOITC_Msk   = 0x400000 // Bit mask of SDIOITC field.
	SDMMC_ICR_SDIOITC       = 0x400000 // Bit SDIOITC.
	SDMMC_ICR_DBCKENDC_Pos  = 0xa      // Position of DBCKENDC field.
	SDMMC_ICR_DBCKENDC_Msk  = 0x400    // Bit mask of DBCKENDC field.
	SDMMC_ICR_DBCKENDC      = 0x400    // Bit DBCKENDC.
	SDMMC_ICR_STBITERRC_Pos = 0x9      // Position of STBITERRC field.
	SDMMC_ICR_STBITERRC_Msk = 0x200    // Bit mask of STBITERRC field.
	SDMMC_ICR_STBITERRC     = 0x200    // Bit STBITERRC.
	SDMMC_ICR_DATAENDC_Pos  = 0x8      // Position of DATAENDC field.
	SDMMC_ICR_DATAENDC_Msk  = 0x100    // Bit mask of DATAENDC field.
	SDMMC_ICR_DATAENDC      = 0x100    // Bit DATAENDC.
	SDMMC_ICR_CMDSENTC_Pos  = 0x7      // Position of CMDSENTC field.
	SDMMC_ICR_CMDSENTC_Msk  = 0x80     // Bit mask of CMDSENTC field.
	SDMMC_ICR_CMDSENTC      = 0x80     // Bit CMDSENTC.
	SDMMC_ICR_CMDRENDC_Pos  = 0x6      // Position of CMDRENDC field.
	SDMMC_ICR_CMDRENDC_Msk  = 0x40     // Bit mask of CMDRENDC field.
	SDMMC_ICR_CMDRENDC      = 0x40     // Bit CMDRENDC.
	SDMMC_ICR_RXOVERRC_Pos  = 0x5      // Position of RXOVERRC field.
	SDMMC_ICR_RXOVERRC_Msk  = 0x20     // Bit mask of RXOVERRC field.
	SDMMC_ICR_RXOVERRC      = 0x20     // Bit RXOVERRC.
	SDMMC_ICR_TXUNDERRC_Pos = 0x4      // Position of TXUNDERRC field.
	SDMMC_ICR_TXUNDERRC_Msk = 0x10     // Bit mask of TXUNDERRC field.
	SDMMC_ICR_TXUNDERRC     = 0x10     // Bit TXUNDERRC.
	SDMMC_ICR_DTIMEOUTC_Pos = 0x3      // Position of DTIMEOUTC field.
	SDMMC_ICR_DTIMEOUTC_Msk = 0x8      // Bit mask of DTIMEOUTC field.
	SDMMC_ICR_DTIMEOUTC     = 0x8      // Bit DTIMEOUTC.
	SDMMC_ICR_CTIMEOUTC_Pos = 0x2      // Position of CTIMEOUTC field.
	SDMMC_ICR_CTIMEOUTC_Msk = 0x4      // Bit mask of CTIMEOUTC field.
	SDMMC_ICR_CTIMEOUTC     = 0x4      // Bit CTIMEOUTC.
	SDMMC_ICR_DCRCFAILC_Pos = 0x1      // Position of DCRCFAILC field.
	SDMMC_ICR_DCRCFAILC_Msk = 0x2      // Bit mask of DCRCFAILC field.
	SDMMC_ICR_DCRCFAILC     = 0x2      // Bit DCRCFAILC.
	SDMMC_ICR_CCRCFAILC_Pos = 0x0      // Position of CCRCFAILC field.
	SDMMC_ICR_CCRCFAILC_Msk = 0x1      // Bit mask of CCRCFAILC field.
	SDMMC_ICR_CCRCFAILC     = 0x1      // Bit CCRCFAILC.

	// MASK: mask register
	SDMMC_MASK_CEATAENDIE_Pos = 0x17     // Position of CEATAENDIE field.
	SDMMC_MASK_CEATAENDIE_Msk = 0x800000 // Bit mask of CEATAENDIE field.
	SDMMC_MASK_CEATAENDIE     = 0x800000 // Bit CEATAENDIE.
	SDMMC_MASK_SDIOITIE_Pos   = 0x16     // Position of SDIOITIE field.
	SDMMC_MASK_SDIOITIE_Msk   = 0x400000 // Bit mask of SDIOITIE field.
	SDMMC_MASK_SDIOITIE       = 0x400000 // Bit SDIOITIE.
	SDMMC_MASK_RXDAVLIE_Pos   = 0x15     // Position of RXDAVLIE field.
	SDMMC_MASK_RXDAVLIE_Msk   = 0x200000 // Bit mask of RXDAVLIE field.
	SDMMC_MASK_RXDAVLIE       = 0x200000 // Bit RXDAVLIE.
	SDMMC_MASK_TXDAVLIE_Pos   = 0x14     // Position of TXDAVLIE field.
	SDMMC_MASK_TXDAVLIE_Msk   = 0x100000 // Bit mask of TXDAVLIE field.
	SDMMC_MASK_TXDAVLIE       = 0x100000 // Bit TXDAVLIE.
	SDMMC_MASK_RXFIFOEIE_Pos  = 0x13     // Position of RXFIFOEIE field.
	SDMMC_MASK_RXFIFOEIE_Msk  = 0x80000  // Bit mask of RXFIFOEIE field.
	SDMMC_MASK_RXFIFOEIE      = 0x80000  // Bit RXFIFOEIE.
	SDMMC_MASK_TXFIFOEIE_Pos  = 0x12     // Position of TXFIFOEIE field.
	SDMMC_MASK_TXFIFOEIE_Msk  = 0x40000  // Bit mask of TXFIFOEIE field.
	SDMMC_MASK_TXFIFOEIE      = 0x40000  // Bit TXFIFOEIE.
	SDMMC_MASK_RXFIFOFIE_Pos  = 0x11     // Position of RXFIFOFIE field.
	SDMMC_MASK_RXFIFOFIE_Msk  = 0x20000  // Bit mask of RXFIFOFIE field.
	SDMMC_MASK_RXFIFOFIE      = 0x20000  // Bit RXFIFOFIE.
	SDMMC_MASK_TXFIFOFIE_Pos  = 0x10     // Position of TXFIFOFIE field.
	SDMMC_MASK_TXFIFOFIE_Msk  = 0x10000  // Bit mask of TXFIFOFIE field.
	SDMMC_MASK_TXFIFOFIE      = 0x10000  // Bit TXFIFOFIE.
	SDMMC_MASK_RXFIFOHFIE_Pos = 0xf      // Position of RXFIFOHFIE field.
	SDMMC_MASK_RXFIFOHFIE_Msk = 0x8000   // Bit mask of RXFIFOHFIE field.
	SDMMC_MASK_RXFIFOHFIE     = 0x8000   // Bit RXFIFOHFIE.
	SDMMC_MASK_TXFIFOHEIE_Pos = 0xe      // Position of TXFIFOHEIE field.
	SDMMC_MASK_TXFIFOHEIE_Msk = 0x4000   // Bit mask of TXFIFOHEIE field.
	SDMMC_MASK_TXFIFOHEIE     = 0x4000   // Bit TXFIFOHEIE.
	SDMMC_MASK_RXACTIE_Pos    = 0xd      // Position of RXACTIE field.
	SDMMC_MASK_RXACTIE_Msk    = 0x2000   // Bit mask of RXACTIE field.
	SDMMC_MASK_RXACTIE        = 0x2000   // Bit RXACTIE.
	SDMMC_MASK_TXACTIE_Pos    = 0xc      // Position of TXACTIE field.
	SDMMC_MASK_TXACTIE_Msk    = 0x1000   // Bit mask of TXACTIE field.
	SDMMC_MASK_TXACTIE        = 0x1000   // Bit TXACTIE.
	SDMMC_MASK_CMDACTIE_Pos   = 0xb      // Position of CMDACTIE field.
	SDMMC_MASK_CMDACTIE_Msk   = 0x800    // Bit mask of CMDACTIE field.
	SDMMC_MASK_CMDACTIE       = 0x800    // Bit CMDACTIE.
	SDMMC_MASK_DBCKENDIE_Pos  = 0xa      // Position of DBCKENDIE field.
	SDMMC_MASK_DBCKENDIE_Msk  = 0x400    // Bit mask of DBCKENDIE field.
	SDMMC_MASK_DBCKENDIE      = 0x400    // Bit DBCKENDIE.
	SDMMC_MASK_STBITERRIE_Pos = 0x9      // Position of STBITERRIE field.
	SDMMC_MASK_STBITERRIE_Msk = 0x200    // Bit mask of STBITERRIE field.
	SDMMC_MASK_STBITERRIE     = 0x200    // Bit STBITERRIE.
	SDMMC_MASK_DATAENDIE_Pos  = 0x8      // Position of DATAENDIE field.
	SDMMC_MASK_DATAENDIE_Msk  = 0x100    // Bit mask of DATAENDIE field.
	SDMMC_MASK_DATAENDIE      = 0x100    // Bit DATAENDIE.
	SDMMC_MASK_CMDSENTIE_Pos  = 0x7      // Position of CMDSENTIE field.
	SDMMC_MASK_CMDSENTIE_Msk  = 0x80     // Bit mask of CMDSENTIE field.
	SDMMC_MASK_CMDSENTIE      = 0x80     // Bit CMDSENTIE.
	SDMMC_MASK_CMDRENDIE_Pos  = 0x6      // Position of CMDRENDIE field.
	SDMMC_MASK_CMDRENDIE_Msk  = 0x40     // Bit mask of CMDRENDIE field.
	SDMMC_MASK_CMDRENDIE      = 0x40     // Bit CMDRENDIE.
	SDMMC_MASK_RXOVERRIE_Pos  = 0x5      // Position of RXOVERRIE field.
	SDMMC_MASK_RXOVERRIE_Msk  = 0x20     // Bit mask of RXOVERRIE field.
	SDMMC_MASK_RXOVERRIE      = 0x20     // Bit RXOVERRIE.
	SDMMC_MASK_TXUNDERRIE_Pos = 0x4      // Position of TXUNDERRIE field.
	SDMMC_MASK_TXUNDERRIE_Msk = 0x10     // Bit mask of TXUNDERRIE field.
	SDMMC_MASK_TXUNDERRIE     = 0x10     // Bit TXUNDERRIE.
	SDMMC_MASK_DTIMEOUTIE_Pos = 0x3      // Position of DTIMEOUTIE field.
	SDMMC_MASK_DTIMEOUTIE_Msk = 0x8      // Bit mask of DTIMEOUTIE field.
	SDMMC_MASK_DTIMEOUTIE     = 0x8      // Bit DTIMEOUTIE.
	SDMMC_MASK_CTIMEOUTIE_Pos = 0x2      // Position of CTIMEOUTIE field.
	SDMMC_MASK_CTIMEOUTIE_Msk = 0x4      // Bit mask of CTIMEOUTIE field.
	SDMMC_MASK_CTIMEOUTIE     = 0x4      // Bit CTIMEOUTIE.
	SDMMC_MASK_DCRCFAILIE_Pos = 0x1      // Position of DCRCFAILIE field.
	SDMMC_MASK_DCRCFAILIE_Msk = 0x2      // Bit mask of DCRCFAILIE field.
	SDMMC_MASK_DCRCFAILIE     = 0x2      // Bit DCRCFAILIE.
	SDMMC_MASK_CCRCFAILIE_Pos = 0x0      // Position of CCRCFAILIE field.
	SDMMC_MASK_CCRCFAILIE_Msk = 0x1      // Bit mask of CCRCFAILIE field.
	SDMMC_MASK_CCRCFAILIE     = 0x1      // Bit CCRCFAILIE.

	// FIFOCNT: FIFO counter register
	SDMMC_FIFOCNT_FIFOCOUNT_Pos = 0x0      // Position of FIFOCOUNT field.
	SDMMC_FIFOCNT_FIFOCOUNT_Msk = 0xffffff // Bit mask of FIFOCOUNT field.

	// FIFO: data FIFO register
	SDMMC_FIFO_FIFOData_Pos = 0x0        // Position of FIFOData field.
	SDMMC_FIFO_FIFOData_Msk = 0xffffffff // Bit mask of FIFOData field.
)

// Bitfields for LPTIM1: Low power timer
const (
	// ISR: Interrupt and Status Register
	LPTIM_ISR_DOWN_Pos    = 0x6  // Position of DOWN field.
	LPTIM_ISR_DOWN_Msk    = 0x40 // Bit mask of DOWN field.
	LPTIM_ISR_DOWN        = 0x40 // Bit DOWN.
	LPTIM_ISR_UP_Pos      = 0x5  // Position of UP field.
	LPTIM_ISR_UP_Msk      = 0x20 // Bit mask of UP field.
	LPTIM_ISR_UP          = 0x20 // Bit UP.
	LPTIM_ISR_ARROK_Pos   = 0x4  // Position of ARROK field.
	LPTIM_ISR_ARROK_Msk   = 0x10 // Bit mask of ARROK field.
	LPTIM_ISR_ARROK       = 0x10 // Bit ARROK.
	LPTIM_ISR_CMPOK_Pos   = 0x3  // Position of CMPOK field.
	LPTIM_ISR_CMPOK_Msk   = 0x8  // Bit mask of CMPOK field.
	LPTIM_ISR_CMPOK       = 0x8  // Bit CMPOK.
	LPTIM_ISR_EXTTRIG_Pos = 0x2  // Position of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Msk = 0x4  // Bit mask of EXTTRIG field.
	LPTIM_ISR_EXTTRIG     = 0x4  // Bit EXTTRIG.
	LPTIM_ISR_ARRM_Pos    = 0x1  // Position of ARRM field.
	LPTIM_ISR_ARRM_Msk    = 0x2  // Bit mask of ARRM field.
	LPTIM_ISR_ARRM        = 0x2  // Bit ARRM.
	LPTIM_ISR_CMPM_Pos    = 0x0  // Position of CMPM field.
	LPTIM_ISR_CMPM_Msk    = 0x1  // Bit mask of CMPM field.
	LPTIM_ISR_CMPM        = 0x1  // Bit CMPM.

	// ICR: Interrupt Clear Register
	LPTIM_ICR_DOWNCF_Pos    = 0x6  // Position of DOWNCF field.
	LPTIM_ICR_DOWNCF_Msk    = 0x40 // Bit mask of DOWNCF field.
	LPTIM_ICR_DOWNCF        = 0x40 // Bit DOWNCF.
	LPTIM_ICR_UPCF_Pos      = 0x5  // Position of UPCF field.
	LPTIM_ICR_UPCF_Msk      = 0x20 // Bit mask of UPCF field.
	LPTIM_ICR_UPCF          = 0x20 // Bit UPCF.
	LPTIM_ICR_ARROKCF_Pos   = 0x4  // Position of ARROKCF field.
	LPTIM_ICR_ARROKCF_Msk   = 0x10 // Bit mask of ARROKCF field.
	LPTIM_ICR_ARROKCF       = 0x10 // Bit ARROKCF.
	LPTIM_ICR_CMPOKCF_Pos   = 0x3  // Position of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Msk   = 0x8  // Bit mask of CMPOKCF field.
	LPTIM_ICR_CMPOKCF       = 0x8  // Bit CMPOKCF.
	LPTIM_ICR_EXTTRIGCF_Pos = 0x2  // Position of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Msk = 0x4  // Bit mask of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF     = 0x4  // Bit EXTTRIGCF.
	LPTIM_ICR_ARRMCF_Pos    = 0x1  // Position of ARRMCF field.
	LPTIM_ICR_ARRMCF_Msk    = 0x2  // Bit mask of ARRMCF field.
	LPTIM_ICR_ARRMCF        = 0x2  // Bit ARRMCF.
	LPTIM_ICR_CMPMCF_Pos    = 0x0  // Position of CMPMCF field.
	LPTIM_ICR_CMPMCF_Msk    = 0x1  // Bit mask of CMPMCF field.
	LPTIM_ICR_CMPMCF        = 0x1  // Bit CMPMCF.

	// IER: Interrupt Enable Register
	LPTIM_IER_DOWNIE_Pos    = 0x6  // Position of DOWNIE field.
	LPTIM_IER_DOWNIE_Msk    = 0x40 // Bit mask of DOWNIE field.
	LPTIM_IER_DOWNIE        = 0x40 // Bit DOWNIE.
	LPTIM_IER_UPIE_Pos      = 0x5  // Position of UPIE field.
	LPTIM_IER_UPIE_Msk      = 0x20 // Bit mask of UPIE field.
	LPTIM_IER_UPIE          = 0x20 // Bit UPIE.
	LPTIM_IER_ARROKIE_Pos   = 0x4  // Position of ARROKIE field.
	LPTIM_IER_ARROKIE_Msk   = 0x10 // Bit mask of ARROKIE field.
	LPTIM_IER_ARROKIE       = 0x10 // Bit ARROKIE.
	LPTIM_IER_CMPOKIE_Pos   = 0x3  // Position of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Msk   = 0x8  // Bit mask of CMPOKIE field.
	LPTIM_IER_CMPOKIE       = 0x8  // Bit CMPOKIE.
	LPTIM_IER_EXTTRIGIE_Pos = 0x2  // Position of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Msk = 0x4  // Bit mask of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE     = 0x4  // Bit EXTTRIGIE.
	LPTIM_IER_ARRMIE_Pos    = 0x1  // Position of ARRMIE field.
	LPTIM_IER_ARRMIE_Msk    = 0x2  // Bit mask of ARRMIE field.
	LPTIM_IER_ARRMIE        = 0x2  // Bit ARRMIE.
	LPTIM_IER_CMPMIE_Pos    = 0x0  // Position of CMPMIE field.
	LPTIM_IER_CMPMIE_Msk    = 0x1  // Bit mask of CMPMIE field.
	LPTIM_IER_CMPMIE        = 0x1  // Bit CMPMIE.

	// CFGR: Configuration Register
	LPTIM_CFGR_ENC_Pos       = 0x18      // Position of ENC field.
	LPTIM_CFGR_ENC_Msk       = 0x1000000 // Bit mask of ENC field.
	LPTIM_CFGR_ENC           = 0x1000000 // Bit ENC.
	LPTIM_CFGR_COUNTMODE_Pos = 0x17      // Position of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Msk = 0x800000  // Bit mask of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE     = 0x800000  // Bit COUNTMODE.
	LPTIM_CFGR_PRELOAD_Pos   = 0x16      // Position of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Msk   = 0x400000  // Bit mask of PRELOAD field.
	LPTIM_CFGR_PRELOAD       = 0x400000  // Bit PRELOAD.
	LPTIM_CFGR_WAVPOL_Pos    = 0x15      // Position of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Msk    = 0x200000  // Bit mask of WAVPOL field.
	LPTIM_CFGR_WAVPOL        = 0x200000  // Bit WAVPOL.
	LPTIM_CFGR_WAVE_Pos      = 0x14      // Position of WAVE field.
	LPTIM_CFGR_WAVE_Msk      = 0x100000  // Bit mask of WAVE field.
	LPTIM_CFGR_WAVE          = 0x100000  // Bit WAVE.
	LPTIM_CFGR_TIMOUT_Pos    = 0x13      // Position of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Msk    = 0x80000   // Bit mask of TIMOUT field.
	LPTIM_CFGR_TIMOUT        = 0x80000   // Bit TIMOUT.
	LPTIM_CFGR_TRIGEN_Pos    = 0x11      // Position of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Msk    = 0x60000   // Bit mask of TRIGEN field.
	LPTIM_CFGR_TRIGSEL_Pos   = 0xd       // Position of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Msk   = 0xe000    // Bit mask of TRIGSEL field.
	LPTIM_CFGR_PRESC_Pos     = 0x9       // Position of PRESC field.
	LPTIM_CFGR_PRESC_Msk     = 0xe00     // Bit mask of PRESC field.
	LPTIM_CFGR_TRGFLT_Pos    = 0x6       // Position of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Msk    = 0xc0      // Bit mask of TRGFLT field.
	LPTIM_CFGR_CKFLT_Pos     = 0x3       // Position of CKFLT field.
	LPTIM_CFGR_CKFLT_Msk     = 0x18      // Bit mask of CKFLT field.
	LPTIM_CFGR_CKPOL_Pos     = 0x1       // Position of CKPOL field.
	LPTIM_CFGR_CKPOL_Msk     = 0x6       // Bit mask of CKPOL field.
	LPTIM_CFGR_CKSEL_Pos     = 0x0       // Position of CKSEL field.
	LPTIM_CFGR_CKSEL_Msk     = 0x1       // Bit mask of CKSEL field.
	LPTIM_CFGR_CKSEL         = 0x1       // Bit CKSEL.

	// CR: Control Register
	LPTIM_CR_CNTSTRT_Pos = 0x2 // Position of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Msk = 0x4 // Bit mask of CNTSTRT field.
	LPTIM_CR_CNTSTRT     = 0x4 // Bit CNTSTRT.
	LPTIM_CR_SNGSTRT_Pos = 0x1 // Position of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Msk = 0x2 // Bit mask of SNGSTRT field.
	LPTIM_CR_SNGSTRT     = 0x2 // Bit SNGSTRT.
	LPTIM_CR_ENABLE_Pos  = 0x0 // Position of ENABLE field.
	LPTIM_CR_ENABLE_Msk  = 0x1 // Bit mask of ENABLE field.
	LPTIM_CR_ENABLE      = 0x1 // Bit ENABLE.

	// CMP: Compare Register
	LPTIM_CMP_CMP_Pos = 0x0    // Position of CMP field.
	LPTIM_CMP_CMP_Msk = 0xffff // Bit mask of CMP field.

	// ARR: Autoreload Register
	LPTIM_ARR_ARR_Pos = 0x0    // Position of ARR field.
	LPTIM_ARR_ARR_Msk = 0xffff // Bit mask of ARR field.

	// CNT: Counter Register
	LPTIM_CNT_CNT_Pos = 0x0    // Position of CNT field.
	LPTIM_CNT_CNT_Msk = 0xffff // Bit mask of CNT field.
)

// Bitfields for I2C1: Inter-integrated circuit
const (
	// CR1: Control register 1
	I2C_CR1_PE_Pos        = 0x0      // Position of PE field.
	I2C_CR1_PE_Msk        = 0x1      // Bit mask of PE field.
	I2C_CR1_PE            = 0x1      // Bit PE.
	I2C_CR1_TXIE_Pos      = 0x1      // Position of TXIE field.
	I2C_CR1_TXIE_Msk      = 0x2      // Bit mask of TXIE field.
	I2C_CR1_TXIE          = 0x2      // Bit TXIE.
	I2C_CR1_RXIE_Pos      = 0x2      // Position of RXIE field.
	I2C_CR1_RXIE_Msk      = 0x4      // Bit mask of RXIE field.
	I2C_CR1_RXIE          = 0x4      // Bit RXIE.
	I2C_CR1_ADDRIE_Pos    = 0x3      // Position of ADDRIE field.
	I2C_CR1_ADDRIE_Msk    = 0x8      // Bit mask of ADDRIE field.
	I2C_CR1_ADDRIE        = 0x8      // Bit ADDRIE.
	I2C_CR1_NACKIE_Pos    = 0x4      // Position of NACKIE field.
	I2C_CR1_NACKIE_Msk    = 0x10     // Bit mask of NACKIE field.
	I2C_CR1_NACKIE        = 0x10     // Bit NACKIE.
	I2C_CR1_STOPIE_Pos    = 0x5      // Position of STOPIE field.
	I2C_CR1_STOPIE_Msk    = 0x20     // Bit mask of STOPIE field.
	I2C_CR1_STOPIE        = 0x20     // Bit STOPIE.
	I2C_CR1_TCIE_Pos      = 0x6      // Position of TCIE field.
	I2C_CR1_TCIE_Msk      = 0x40     // Bit mask of TCIE field.
	I2C_CR1_TCIE          = 0x40     // Bit TCIE.
	I2C_CR1_ERRIE_Pos     = 0x7      // Position of ERRIE field.
	I2C_CR1_ERRIE_Msk     = 0x80     // Bit mask of ERRIE field.
	I2C_CR1_ERRIE         = 0x80     // Bit ERRIE.
	I2C_CR1_DNF_Pos       = 0x8      // Position of DNF field.
	I2C_CR1_DNF_Msk       = 0xf00    // Bit mask of DNF field.
	I2C_CR1_ANFOFF_Pos    = 0xc      // Position of ANFOFF field.
	I2C_CR1_ANFOFF_Msk    = 0x1000   // Bit mask of ANFOFF field.
	I2C_CR1_ANFOFF        = 0x1000   // Bit ANFOFF.
	I2C_CR1_TXDMAEN_Pos   = 0xe      // Position of TXDMAEN field.
	I2C_CR1_TXDMAEN_Msk   = 0x4000   // Bit mask of TXDMAEN field.
	I2C_CR1_TXDMAEN       = 0x4000   // Bit TXDMAEN.
	I2C_CR1_RXDMAEN_Pos   = 0xf      // Position of RXDMAEN field.
	I2C_CR1_RXDMAEN_Msk   = 0x8000   // Bit mask of RXDMAEN field.
	I2C_CR1_RXDMAEN       = 0x8000   // Bit RXDMAEN.
	I2C_CR1_SBC_Pos       = 0x10     // Position of SBC field.
	I2C_CR1_SBC_Msk       = 0x10000  // Bit mask of SBC field.
	I2C_CR1_SBC           = 0x10000  // Bit SBC.
	I2C_CR1_NOSTRETCH_Pos = 0x11     // Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x20000  // Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH     = 0x20000  // Bit NOSTRETCH.
	I2C_CR1_WUPEN_Pos     = 0x12     // Position of WUPEN field.
	I2C_CR1_WUPEN_Msk     = 0x40000  // Bit mask of WUPEN field.
	I2C_CR1_WUPEN         = 0x40000  // Bit WUPEN.
	I2C_CR1_GCEN_Pos      = 0x13     // Position of GCEN field.
	I2C_CR1_GCEN_Msk      = 0x80000  // Bit mask of GCEN field.
	I2C_CR1_GCEN          = 0x80000  // Bit GCEN.
	I2C_CR1_SMBHEN_Pos    = 0x14     // Position of SMBHEN field.
	I2C_CR1_SMBHEN_Msk    = 0x100000 // Bit mask of SMBHEN field.
	I2C_CR1_SMBHEN        = 0x100000 // Bit SMBHEN.
	I2C_CR1_SMBDEN_Pos    = 0x15     // Position of SMBDEN field.
	I2C_CR1_SMBDEN_Msk    = 0x200000 // Bit mask of SMBDEN field.
	I2C_CR1_SMBDEN        = 0x200000 // Bit SMBDEN.
	I2C_CR1_ALERTEN_Pos   = 0x16     // Position of ALERTEN field.
	I2C_CR1_ALERTEN_Msk   = 0x400000 // Bit mask of ALERTEN field.
	I2C_CR1_ALERTEN       = 0x400000 // Bit ALERTEN.
	I2C_CR1_PECEN_Pos     = 0x17     // Position of PECEN field.
	I2C_CR1_PECEN_Msk     = 0x800000 // Bit mask of PECEN field.
	I2C_CR1_PECEN         = 0x800000 // Bit PECEN.

	// CR2: Control register 2
	I2C_CR2_PECBYTE_Pos = 0x1a      // Position of PECBYTE field.
	I2C_CR2_PECBYTE_Msk = 0x4000000 // Bit mask of PECBYTE field.
	I2C_CR2_PECBYTE     = 0x4000000 // Bit PECBYTE.
	I2C_CR2_AUTOEND_Pos = 0x19      // Position of AUTOEND field.
	I2C_CR2_AUTOEND_Msk = 0x2000000 // Bit mask of AUTOEND field.
	I2C_CR2_AUTOEND     = 0x2000000 // Bit AUTOEND.
	I2C_CR2_RELOAD_Pos  = 0x18      // Position of RELOAD field.
	I2C_CR2_RELOAD_Msk  = 0x1000000 // Bit mask of RELOAD field.
	I2C_CR2_RELOAD      = 0x1000000 // Bit RELOAD.
	I2C_CR2_NBYTES_Pos  = 0x10      // Position of NBYTES field.
	I2C_CR2_NBYTES_Msk  = 0xff0000  // Bit mask of NBYTES field.
	I2C_CR2_NACK_Pos    = 0xf       // Position of NACK field.
	I2C_CR2_NACK_Msk    = 0x8000    // Bit mask of NACK field.
	I2C_CR2_NACK        = 0x8000    // Bit NACK.
	I2C_CR2_STOP_Pos    = 0xe       // Position of STOP field.
	I2C_CR2_STOP_Msk    = 0x4000    // Bit mask of STOP field.
	I2C_CR2_STOP        = 0x4000    // Bit STOP.
	I2C_CR2_START_Pos   = 0xd       // Position of START field.
	I2C_CR2_START_Msk   = 0x2000    // Bit mask of START field.
	I2C_CR2_START       = 0x2000    // Bit START.
	I2C_CR2_HEAD10R_Pos = 0xc       // Position of HEAD10R field.
	I2C_CR2_HEAD10R_Msk = 0x1000    // Bit mask of HEAD10R field.
	I2C_CR2_HEAD10R     = 0x1000    // Bit HEAD10R.
	I2C_CR2_ADD10_Pos   = 0xb       // Position of ADD10 field.
	I2C_CR2_ADD10_Msk   = 0x800     // Bit mask of ADD10 field.
	I2C_CR2_ADD10       = 0x800     // Bit ADD10.
	I2C_CR2_RD_WRN_Pos  = 0xa       // Position of RD_WRN field.
	I2C_CR2_RD_WRN_Msk  = 0x400     // Bit mask of RD_WRN field.
	I2C_CR2_RD_WRN      = 0x400     // Bit RD_WRN.
	I2C_CR2_SADD_Pos    = 0x0       // Position of SADD field.
	I2C_CR2_SADD_Msk    = 0x3ff     // Bit mask of SADD field.

	// OAR1: Own address register 1
	I2C_OAR1_OA1_Pos     = 0x0    // Position of OA1 field.
	I2C_OAR1_OA1_Msk     = 0x3ff  // Bit mask of OA1 field.
	I2C_OAR1_OA1MODE_Pos = 0xa    // Position of OA1MODE field.
	I2C_OAR1_OA1MODE_Msk = 0x400  // Bit mask of OA1MODE field.
	I2C_OAR1_OA1MODE     = 0x400  // Bit OA1MODE.
	I2C_OAR1_OA1EN_Pos   = 0xf    // Position of OA1EN field.
	I2C_OAR1_OA1EN_Msk   = 0x8000 // Bit mask of OA1EN field.
	I2C_OAR1_OA1EN       = 0x8000 // Bit OA1EN.

	// OAR2: Own address register 2
	I2C_OAR2_OA2_Pos    = 0x1    // Position of OA2 field.
	I2C_OAR2_OA2_Msk    = 0xfe   // Bit mask of OA2 field.
	I2C_OAR2_OA2MSK_Pos = 0x8    // Position of OA2MSK field.
	I2C_OAR2_OA2MSK_Msk = 0x700  // Bit mask of OA2MSK field.
	I2C_OAR2_OA2EN_Pos  = 0xf    // Position of OA2EN field.
	I2C_OAR2_OA2EN_Msk  = 0x8000 // Bit mask of OA2EN field.
	I2C_OAR2_OA2EN      = 0x8000 // Bit OA2EN.

	// TIMINGR: Timing register
	I2C_TIMINGR_SCLL_Pos   = 0x0        // Position of SCLL field.
	I2C_TIMINGR_SCLL_Msk   = 0xff       // Bit mask of SCLL field.
	I2C_TIMINGR_SCLH_Pos   = 0x8        // Position of SCLH field.
	I2C_TIMINGR_SCLH_Msk   = 0xff00     // Bit mask of SCLH field.
	I2C_TIMINGR_SDADEL_Pos = 0x10       // Position of SDADEL field.
	I2C_TIMINGR_SDADEL_Msk = 0xf0000    // Bit mask of SDADEL field.
	I2C_TIMINGR_SCLDEL_Pos = 0x14       // Position of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Msk = 0xf00000   // Bit mask of SCLDEL field.
	I2C_TIMINGR_PRESC_Pos  = 0x1c       // Position of PRESC field.
	I2C_TIMINGR_PRESC_Msk  = 0xf0000000 // Bit mask of PRESC field.

	// TIMEOUTR: Status register 1
	I2C_TIMEOUTR_TIMEOUTA_Pos = 0x0        // Position of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Msk = 0xfff      // Bit mask of TIMEOUTA field.
	I2C_TIMEOUTR_TIDLE_Pos    = 0xc        // Position of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Msk    = 0x1000     // Bit mask of TIDLE field.
	I2C_TIMEOUTR_TIDLE        = 0x1000     // Bit TIDLE.
	I2C_TIMEOUTR_TIMOUTEN_Pos = 0xf        // Position of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Msk = 0x8000     // Bit mask of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN     = 0x8000     // Bit TIMOUTEN.
	I2C_TIMEOUTR_TIMEOUTB_Pos = 0x10       // Position of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Msk = 0xfff0000  // Bit mask of TIMEOUTB field.
	I2C_TIMEOUTR_TEXTEN_Pos   = 0x1f       // Position of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Msk   = 0x80000000 // Bit mask of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN       = 0x80000000 // Bit TEXTEN.

	// ISR: Interrupt and Status register
	I2C_ISR_ADDCODE_Pos = 0x11     // Position of ADDCODE field.
	I2C_ISR_ADDCODE_Msk = 0xfe0000 // Bit mask of ADDCODE field.
	I2C_ISR_DIR_Pos     = 0x10     // Position of DIR field.
	I2C_ISR_DIR_Msk     = 0x10000  // Bit mask of DIR field.
	I2C_ISR_DIR         = 0x10000  // Bit DIR.
	I2C_ISR_BUSY_Pos    = 0xf      // Position of BUSY field.
	I2C_ISR_BUSY_Msk    = 0x8000   // Bit mask of BUSY field.
	I2C_ISR_BUSY        = 0x8000   // Bit BUSY.
	I2C_ISR_ALERT_Pos   = 0xd      // Position of ALERT field.
	I2C_ISR_ALERT_Msk   = 0x2000   // Bit mask of ALERT field.
	I2C_ISR_ALERT       = 0x2000   // Bit ALERT.
	I2C_ISR_TIMEOUT_Pos = 0xc      // Position of TIMEOUT field.
	I2C_ISR_TIMEOUT_Msk = 0x1000   // Bit mask of TIMEOUT field.
	I2C_ISR_TIMEOUT     = 0x1000   // Bit TIMEOUT.
	I2C_ISR_PECERR_Pos  = 0xb      // Position of PECERR field.
	I2C_ISR_PECERR_Msk  = 0x800    // Bit mask of PECERR field.
	I2C_ISR_PECERR      = 0x800    // Bit PECERR.
	I2C_ISR_OVR_Pos     = 0xa      // Position of OVR field.
	I2C_ISR_OVR_Msk     = 0x400    // Bit mask of OVR field.
	I2C_ISR_OVR         = 0x400    // Bit OVR.
	I2C_ISR_ARLO_Pos    = 0x9      // Position of ARLO field.
	I2C_ISR_ARLO_Msk    = 0x200    // Bit mask of ARLO field.
	I2C_ISR_ARLO        = 0x200    // Bit ARLO.
	I2C_ISR_BERR_Pos    = 0x8      // Position of BERR field.
	I2C_ISR_BERR_Msk    = 0x100    // Bit mask of BERR field.
	I2C_ISR_BERR        = 0x100    // Bit BERR.
	I2C_ISR_TCR_Pos     = 0x7      // Position of TCR field.
	I2C_ISR_TCR_Msk     = 0x80     // Bit mask of TCR field.
	I2C_ISR_TCR         = 0x80     // Bit TCR.
	I2C_ISR_TC_Pos      = 0x6      // Position of TC field.
	I2C_ISR_TC_Msk      = 0x40     // Bit mask of TC field.
	I2C_ISR_TC          = 0x40     // Bit TC.
	I2C_ISR_STOPF_Pos   = 0x5      // Position of STOPF field.
	I2C_ISR_STOPF_Msk   = 0x20     // Bit mask of STOPF field.
	I2C_ISR_STOPF       = 0x20     // Bit STOPF.
	I2C_ISR_NACKF_Pos   = 0x4      // Position of NACKF field.
	I2C_ISR_NACKF_Msk   = 0x10     // Bit mask of NACKF field.
	I2C_ISR_NACKF       = 0x10     // Bit NACKF.
	I2C_ISR_ADDR_Pos    = 0x3      // Position of ADDR field.
	I2C_ISR_ADDR_Msk    = 0x8      // Bit mask of ADDR field.
	I2C_ISR_ADDR        = 0x8      // Bit ADDR.
	I2C_ISR_RXNE_Pos    = 0x2      // Position of RXNE field.
	I2C_ISR_RXNE_Msk    = 0x4      // Bit mask of RXNE field.
	I2C_ISR_RXNE        = 0x4      // Bit RXNE.
	I2C_ISR_TXIS_Pos    = 0x1      // Position of TXIS field.
	I2C_ISR_TXIS_Msk    = 0x2      // Bit mask of TXIS field.
	I2C_ISR_TXIS        = 0x2      // Bit TXIS.
	I2C_ISR_TXE_Pos     = 0x0      // Position of TXE field.
	I2C_ISR_TXE_Msk     = 0x1      // Bit mask of TXE field.
	I2C_ISR_TXE         = 0x1      // Bit TXE.

	// ICR: Interrupt clear register
	I2C_ICR_ALERTCF_Pos  = 0xd    // Position of ALERTCF field.
	I2C_ICR_ALERTCF_Msk  = 0x2000 // Bit mask of ALERTCF field.
	I2C_ICR_ALERTCF      = 0x2000 // Bit ALERTCF.
	I2C_ICR_TIMOUTCF_Pos = 0xc    // Position of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Msk = 0x1000 // Bit mask of TIMOUTCF field.
	I2C_ICR_TIMOUTCF     = 0x1000 // Bit TIMOUTCF.
	I2C_ICR_PECCF_Pos    = 0xb    // Position of PECCF field.
	I2C_ICR_PECCF_Msk    = 0x800  // Bit mask of PECCF field.
	I2C_ICR_PECCF        = 0x800  // Bit PECCF.
	I2C_ICR_OVRCF_Pos    = 0xa    // Position of OVRCF field.
	I2C_ICR_OVRCF_Msk    = 0x400  // Bit mask of OVRCF field.
	I2C_ICR_OVRCF        = 0x400  // Bit OVRCF.
	I2C_ICR_ARLOCF_Pos   = 0x9    // Position of ARLOCF field.
	I2C_ICR_ARLOCF_Msk   = 0x200  // Bit mask of ARLOCF field.
	I2C_ICR_ARLOCF       = 0x200  // Bit ARLOCF.
	I2C_ICR_BERRCF_Pos   = 0x8    // Position of BERRCF field.
	I2C_ICR_BERRCF_Msk   = 0x100  // Bit mask of BERRCF field.
	I2C_ICR_BERRCF       = 0x100  // Bit BERRCF.
	I2C_ICR_STOPCF_Pos   = 0x5    // Position of STOPCF field.
	I2C_ICR_STOPCF_Msk   = 0x20   // Bit mask of STOPCF field.
	I2C_ICR_STOPCF       = 0x20   // Bit STOPCF.
	I2C_ICR_NACKCF_Pos   = 0x4    // Position of NACKCF field.
	I2C_ICR_NACKCF_Msk   = 0x10   // Bit mask of NACKCF field.
	I2C_ICR_NACKCF       = 0x10   // Bit NACKCF.
	I2C_ICR_ADDRCF_Pos   = 0x3    // Position of ADDRCF field.
	I2C_ICR_ADDRCF_Msk   = 0x8    // Bit mask of ADDRCF field.
	I2C_ICR_ADDRCF       = 0x8    // Bit ADDRCF.

	// PECR: PEC register
	I2C_PECR_PEC_Pos = 0x0  // Position of PEC field.
	I2C_PECR_PEC_Msk = 0xff // Bit mask of PEC field.

	// RXDR: Receive data register
	I2C_RXDR_RXDATA_Pos = 0x0  // Position of RXDATA field.
	I2C_RXDR_RXDATA_Msk = 0xff // Bit mask of RXDATA field.

	// TXDR: Transmit data register
	I2C_TXDR_TXDATA_Pos = 0x0  // Position of TXDATA field.
	I2C_TXDR_TXDATA_Msk = 0xff // Bit mask of TXDATA field.
)

// Bitfields for RTC: Real-time clock
const (
	// TR: time register
	RTC_TR_PM_Pos  = 0x16     // Position of PM field.
	RTC_TR_PM_Msk  = 0x400000 // Bit mask of PM field.
	RTC_TR_PM      = 0x400000 // Bit PM.
	RTC_TR_HT_Pos  = 0x14     // Position of HT field.
	RTC_TR_HT_Msk  = 0x300000 // Bit mask of HT field.
	RTC_TR_HU_Pos  = 0x10     // Position of HU field.
	RTC_TR_HU_Msk  = 0xf0000  // Bit mask of HU field.
	RTC_TR_MNT_Pos = 0xc      // Position of MNT field.
	RTC_TR_MNT_Msk = 0x7000   // Bit mask of MNT field.
	RTC_TR_MNU_Pos = 0x8      // Position of MNU field.
	RTC_TR_MNU_Msk = 0xf00    // Bit mask of MNU field.
	RTC_TR_ST_Pos  = 0x4      // Position of ST field.
	RTC_TR_ST_Msk  = 0x70     // Bit mask of ST field.
	RTC_TR_SU_Pos  = 0x0      // Position of SU field.
	RTC_TR_SU_Msk  = 0xf      // Bit mask of SU field.

	// DR: date register
	RTC_DR_YT_Pos  = 0x14     // Position of YT field.
	RTC_DR_YT_Msk  = 0xf00000 // Bit mask of YT field.
	RTC_DR_YU_Pos  = 0x10     // Position of YU field.
	RTC_DR_YU_Msk  = 0xf0000  // Bit mask of YU field.
	RTC_DR_WDU_Pos = 0xd      // Position of WDU field.
	RTC_DR_WDU_Msk = 0xe000   // Bit mask of WDU field.
	RTC_DR_MT_Pos  = 0xc      // Position of MT field.
	RTC_DR_MT_Msk  = 0x1000   // Bit mask of MT field.
	RTC_DR_MT      = 0x1000   // Bit MT.
	RTC_DR_MU_Pos  = 0x8      // Position of MU field.
	RTC_DR_MU_Msk  = 0xf00    // Bit mask of MU field.
	RTC_DR_DT_Pos  = 0x4      // Position of DT field.
	RTC_DR_DT_Msk  = 0x30     // Bit mask of DT field.
	RTC_DR_DU_Pos  = 0x0      // Position of DU field.
	RTC_DR_DU_Msk  = 0xf      // Bit mask of DU field.

	// CR: control register
	RTC_CR_WCKSEL_Pos  = 0x0       // Position of WCKSEL field.
	RTC_CR_WCKSEL_Msk  = 0x7       // Bit mask of WCKSEL field.
	RTC_CR_TSEDGE_Pos  = 0x3       // Position of TSEDGE field.
	RTC_CR_TSEDGE_Msk  = 0x8       // Bit mask of TSEDGE field.
	RTC_CR_TSEDGE      = 0x8       // Bit TSEDGE.
	RTC_CR_REFCKON_Pos = 0x4       // Position of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10      // Bit mask of REFCKON field.
	RTC_CR_REFCKON     = 0x10      // Bit REFCKON.
	RTC_CR_BYPSHAD_Pos = 0x5       // Position of BYPSHAD field.
	RTC_CR_BYPSHAD_Msk = 0x20      // Bit mask of BYPSHAD field.
	RTC_CR_BYPSHAD     = 0x20      // Bit BYPSHAD.
	RTC_CR_FMT_Pos     = 0x6       // Position of FMT field.
	RTC_CR_FMT_Msk     = 0x40      // Bit mask of FMT field.
	RTC_CR_FMT         = 0x40      // Bit FMT.
	RTC_CR_ALRAE_Pos   = 0x8       // Position of ALRAE field.
	RTC_CR_ALRAE_Msk   = 0x100     // Bit mask of ALRAE field.
	RTC_CR_ALRAE       = 0x100     // Bit ALRAE.
	RTC_CR_ALRBE_Pos   = 0x9       // Position of ALRBE field.
	RTC_CR_ALRBE_Msk   = 0x200     // Bit mask of ALRBE field.
	RTC_CR_ALRBE       = 0x200     // Bit ALRBE.
	RTC_CR_WUTE_Pos    = 0xa       // Position of WUTE field.
	RTC_CR_WUTE_Msk    = 0x400     // Bit mask of WUTE field.
	RTC_CR_WUTE        = 0x400     // Bit WUTE.
	RTC_CR_TSE_Pos     = 0xb       // Position of TSE field.
	RTC_CR_TSE_Msk     = 0x800     // Bit mask of TSE field.
	RTC_CR_TSE         = 0x800     // Bit TSE.
	RTC_CR_ALRAIE_Pos  = 0xc       // Position of ALRAIE field.
	RTC_CR_ALRAIE_Msk  = 0x1000    // Bit mask of ALRAIE field.
	RTC_CR_ALRAIE      = 0x1000    // Bit ALRAIE.
	RTC_CR_ALRBIE_Pos  = 0xd       // Position of ALRBIE field.
	RTC_CR_ALRBIE_Msk  = 0x2000    // Bit mask of ALRBIE field.
	RTC_CR_ALRBIE      = 0x2000    // Bit ALRBIE.
	RTC_CR_WUTIE_Pos   = 0xe       // Position of WUTIE field.
	RTC_CR_WUTIE_Msk   = 0x4000    // Bit mask of WUTIE field.
	RTC_CR_WUTIE       = 0x4000    // Bit WUTIE.
	RTC_CR_TSIE_Pos    = 0xf       // Position of TSIE field.
	RTC_CR_TSIE_Msk    = 0x8000    // Bit mask of TSIE field.
	RTC_CR_TSIE        = 0x8000    // Bit TSIE.
	RTC_CR_ADD1H_Pos   = 0x10      // Position of ADD1H field.
	RTC_CR_ADD1H_Msk   = 0x10000   // Bit mask of ADD1H field.
	RTC_CR_ADD1H       = 0x10000   // Bit ADD1H.
	RTC_CR_SUB1H_Pos   = 0x11      // Position of SUB1H field.
	RTC_CR_SUB1H_Msk   = 0x20000   // Bit mask of SUB1H field.
	RTC_CR_SUB1H       = 0x20000   // Bit SUB1H.
	RTC_CR_BKP_Pos     = 0x12      // Position of BKP field.
	RTC_CR_BKP_Msk     = 0x40000   // Bit mask of BKP field.
	RTC_CR_BKP         = 0x40000   // Bit BKP.
	RTC_CR_COSEL_Pos   = 0x13      // Position of COSEL field.
	RTC_CR_COSEL_Msk   = 0x80000   // Bit mask of COSEL field.
	RTC_CR_COSEL       = 0x80000   // Bit COSEL.
	RTC_CR_POL_Pos     = 0x14      // Position of POL field.
	RTC_CR_POL_Msk     = 0x100000  // Bit mask of POL field.
	RTC_CR_POL         = 0x100000  // Bit POL.
	RTC_CR_OSEL_Pos    = 0x15      // Position of OSEL field.
	RTC_CR_OSEL_Msk    = 0x600000  // Bit mask of OSEL field.
	RTC_CR_COE_Pos     = 0x17      // Position of COE field.
	RTC_CR_COE_Msk     = 0x800000  // Bit mask of COE field.
	RTC_CR_COE         = 0x800000  // Bit COE.
	RTC_CR_ITSE_Pos    = 0x18      // Position of ITSE field.
	RTC_CR_ITSE_Msk    = 0x1000000 // Bit mask of ITSE field.
	RTC_CR_ITSE        = 0x1000000 // Bit ITSE.

	// ISR: initialization and status           register
	RTC_ISR_ALRAWF_Pos  = 0x0     // Position of ALRAWF field.
	RTC_ISR_ALRAWF_Msk  = 0x1     // Bit mask of ALRAWF field.
	RTC_ISR_ALRAWF      = 0x1     // Bit ALRAWF.
	RTC_ISR_ALRBWF_Pos  = 0x1     // Position of ALRBWF field.
	RTC_ISR_ALRBWF_Msk  = 0x2     // Bit mask of ALRBWF field.
	RTC_ISR_ALRBWF      = 0x2     // Bit ALRBWF.
	RTC_ISR_WUTWF_Pos   = 0x2     // Position of WUTWF field.
	RTC_ISR_WUTWF_Msk   = 0x4     // Bit mask of WUTWF field.
	RTC_ISR_WUTWF       = 0x4     // Bit WUTWF.
	RTC_ISR_SHPF_Pos    = 0x3     // Position of SHPF field.
	RTC_ISR_SHPF_Msk    = 0x8     // Bit mask of SHPF field.
	RTC_ISR_SHPF        = 0x8     // Bit SHPF.
	RTC_ISR_INITS_Pos   = 0x4     // Position of INITS field.
	RTC_ISR_INITS_Msk   = 0x10    // Bit mask of INITS field.
	RTC_ISR_INITS       = 0x10    // Bit INITS.
	RTC_ISR_RSF_Pos     = 0x5     // Position of RSF field.
	RTC_ISR_RSF_Msk     = 0x20    // Bit mask of RSF field.
	RTC_ISR_RSF         = 0x20    // Bit RSF.
	RTC_ISR_INITF_Pos   = 0x6     // Position of INITF field.
	RTC_ISR_INITF_Msk   = 0x40    // Bit mask of INITF field.
	RTC_ISR_INITF       = 0x40    // Bit INITF.
	RTC_ISR_INIT_Pos    = 0x7     // Position of INIT field.
	RTC_ISR_INIT_Msk    = 0x80    // Bit mask of INIT field.
	RTC_ISR_INIT        = 0x80    // Bit INIT.
	RTC_ISR_ALRAF_Pos   = 0x8     // Position of ALRAF field.
	RTC_ISR_ALRAF_Msk   = 0x100   // Bit mask of ALRAF field.
	RTC_ISR_ALRAF       = 0x100   // Bit ALRAF.
	RTC_ISR_ALRBF_Pos   = 0x9     // Position of ALRBF field.
	RTC_ISR_ALRBF_Msk   = 0x200   // Bit mask of ALRBF field.
	RTC_ISR_ALRBF       = 0x200   // Bit ALRBF.
	RTC_ISR_WUTF_Pos    = 0xa     // Position of WUTF field.
	RTC_ISR_WUTF_Msk    = 0x400   // Bit mask of WUTF field.
	RTC_ISR_WUTF        = 0x400   // Bit WUTF.
	RTC_ISR_TSF_Pos     = 0xb     // Position of TSF field.
	RTC_ISR_TSF_Msk     = 0x800   // Bit mask of TSF field.
	RTC_ISR_TSF         = 0x800   // Bit TSF.
	RTC_ISR_TSOVF_Pos   = 0xc     // Position of TSOVF field.
	RTC_ISR_TSOVF_Msk   = 0x1000  // Bit mask of TSOVF field.
	RTC_ISR_TSOVF       = 0x1000  // Bit TSOVF.
	RTC_ISR_TAMP1F_Pos  = 0xd     // Position of TAMP1F field.
	RTC_ISR_TAMP1F_Msk  = 0x2000  // Bit mask of TAMP1F field.
	RTC_ISR_TAMP1F      = 0x2000  // Bit TAMP1F.
	RTC_ISR_TAMP2F_Pos  = 0xe     // Position of TAMP2F field.
	RTC_ISR_TAMP2F_Msk  = 0x4000  // Bit mask of TAMP2F field.
	RTC_ISR_TAMP2F      = 0x4000  // Bit TAMP2F.
	RTC_ISR_TAMP3F_Pos  = 0xf     // Position of TAMP3F field.
	RTC_ISR_TAMP3F_Msk  = 0x8000  // Bit mask of TAMP3F field.
	RTC_ISR_TAMP3F      = 0x8000  // Bit TAMP3F.
	RTC_ISR_RECALPF_Pos = 0x10    // Position of RECALPF field.
	RTC_ISR_RECALPF_Msk = 0x10000 // Bit mask of RECALPF field.
	RTC_ISR_RECALPF     = 0x10000 // Bit RECALPF.

	// PRER: prescaler register
	RTC_PRER_PREDIV_A_Pos = 0x10     // Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000 // Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_S_Pos = 0x0      // Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0x7fff   // Bit mask of PREDIV_S field.

	// WUTR: wakeup timer register
	RTC_WUTR_WUT_Pos = 0x0    // Position of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff // Bit mask of WUT field.

	// ALRMAR: alarm A register
	RTC_ALRMAR_MSK4_Pos  = 0x1f       // Position of MSK4 field.
	RTC_ALRMAR_MSK4_Msk  = 0x80000000 // Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4      = 0x80000000 // Bit MSK4.
	RTC_ALRMAR_WDSEL_Pos = 0x1e       // Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000 // Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL     = 0x40000000 // Bit WDSEL.
	RTC_ALRMAR_DT_Pos    = 0x1c       // Position of DT field.
	RTC_ALRMAR_DT_Msk    = 0x30000000 // Bit mask of DT field.
	RTC_ALRMAR_DU_Pos    = 0x18       // Position of DU field.
	RTC_ALRMAR_DU_Msk    = 0xf000000  // Bit mask of DU field.
	RTC_ALRMAR_MSK3_Pos  = 0x17       // Position of MSK3 field.
	RTC_ALRMAR_MSK3_Msk  = 0x800000   // Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3      = 0x800000   // Bit MSK3.
	RTC_ALRMAR_PM_Pos    = 0x16       // Position of PM field.
	RTC_ALRMAR_PM_Msk    = 0x400000   // Bit mask of PM field.
	RTC_ALRMAR_PM        = 0x400000   // Bit PM.
	RTC_ALRMAR_HT_Pos    = 0x14       // Position of HT field.
	RTC_ALRMAR_HT_Msk    = 0x300000   // Bit mask of HT field.
	RTC_ALRMAR_HU_Pos    = 0x10       // Position of HU field.
	RTC_ALRMAR_HU_Msk    = 0xf0000    // Bit mask of HU field.
	RTC_ALRMAR_MSK2_Pos  = 0xf        // Position of MSK2 field.
	RTC_ALRMAR_MSK2_Msk  = 0x8000     // Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2      = 0x8000     // Bit MSK2.
	RTC_ALRMAR_MNT_Pos   = 0xc        // Position of MNT field.
	RTC_ALRMAR_MNT_Msk   = 0x7000     // Bit mask of MNT field.
	RTC_ALRMAR_MNU_Pos   = 0x8        // Position of MNU field.
	RTC_ALRMAR_MNU_Msk   = 0xf00      // Bit mask of MNU field.
	RTC_ALRMAR_MSK1_Pos  = 0x7        // Position of MSK1 field.
	RTC_ALRMAR_MSK1_Msk  = 0x80       // Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1      = 0x80       // Bit MSK1.
	RTC_ALRMAR_ST_Pos    = 0x4        // Position of ST field.
	RTC_ALRMAR_ST_Msk    = 0x70       // Bit mask of ST field.
	RTC_ALRMAR_SU_Pos    = 0x0        // Position of SU field.
	RTC_ALRMAR_SU_Msk    = 0xf        // Bit mask of SU field.

	// ALRMBR: alarm B register
	RTC_ALRMBR_MSK4_Pos  = 0x1f       // Position of MSK4 field.
	RTC_ALRMBR_MSK4_Msk  = 0x80000000 // Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4      = 0x80000000 // Bit MSK4.
	RTC_ALRMBR_WDSEL_Pos = 0x1e       // Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000 // Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL     = 0x40000000 // Bit WDSEL.
	RTC_ALRMBR_DT_Pos    = 0x1c       // Position of DT field.
	RTC_ALRMBR_DT_Msk    = 0x30000000 // Bit mask of DT field.
	RTC_ALRMBR_DU_Pos    = 0x18       // Position of DU field.
	RTC_ALRMBR_DU_Msk    = 0xf000000  // Bit mask of DU field.
	RTC_ALRMBR_MSK3_Pos  = 0x17       // Position of MSK3 field.
	RTC_ALRMBR_MSK3_Msk  = 0x800000   // Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3      = 0x800000   // Bit MSK3.
	RTC_ALRMBR_PM_Pos    = 0x16       // Position of PM field.
	RTC_ALRMBR_PM_Msk    = 0x400000   // Bit mask of PM field.
	RTC_ALRMBR_PM        = 0x400000   // Bit PM.
	RTC_ALRMBR_HT_Pos    = 0x14       // Position of HT field.
	RTC_ALRMBR_HT_Msk    = 0x300000   // Bit mask of HT field.
	RTC_ALRMBR_HU_Pos    = 0x10       // Position of HU field.
	RTC_ALRMBR_HU_Msk    = 0xf0000    // Bit mask of HU field.
	RTC_ALRMBR_MSK2_Pos  = 0xf        // Position of MSK2 field.
	RTC_ALRMBR_MSK2_Msk  = 0x8000     // Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2      = 0x8000     // Bit MSK2.
	RTC_ALRMBR_MNT_Pos   = 0xc        // Position of MNT field.
	RTC_ALRMBR_MNT_Msk   = 0x7000     // Bit mask of MNT field.
	RTC_ALRMBR_MNU_Pos   = 0x8        // Position of MNU field.
	RTC_ALRMBR_MNU_Msk   = 0xf00      // Bit mask of MNU field.
	RTC_ALRMBR_MSK1_Pos  = 0x7        // Position of MSK1 field.
	RTC_ALRMBR_MSK1_Msk  = 0x80       // Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1      = 0x80       // Bit MSK1.
	RTC_ALRMBR_ST_Pos    = 0x4        // Position of ST field.
	RTC_ALRMBR_ST_Msk    = 0x70       // Bit mask of ST field.
	RTC_ALRMBR_SU_Pos    = 0x0        // Position of SU field.
	RTC_ALRMBR_SU_Msk    = 0xf        // Bit mask of SU field.

	// WPR: write protection register
	RTC_WPR_KEY_Pos = 0x0  // Position of KEY field.
	RTC_WPR_KEY_Msk = 0xff // Bit mask of KEY field.

	// SSR: sub second register
	RTC_SSR_SS_Pos = 0x0    // Position of SS field.
	RTC_SSR_SS_Msk = 0xffff // Bit mask of SS field.

	// SHIFTR: shift control register
	RTC_SHIFTR_ADD1S_Pos = 0x1f       // Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000 // Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S     = 0x80000000 // Bit ADD1S.
	RTC_SHIFTR_SUBFS_Pos = 0x0        // Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff     // Bit mask of SUBFS field.

	// TSTR: time stamp time register
	RTC_TSTR_SU_Pos  = 0x0      // Position of SU field.
	RTC_TSTR_SU_Msk  = 0xf      // Bit mask of SU field.
	RTC_TSTR_ST_Pos  = 0x4      // Position of ST field.
	RTC_TSTR_ST_Msk  = 0x70     // Bit mask of ST field.
	RTC_TSTR_MNU_Pos = 0x8      // Position of MNU field.
	RTC_TSTR_MNU_Msk = 0xf00    // Bit mask of MNU field.
	RTC_TSTR_MNT_Pos = 0xc      // Position of MNT field.
	RTC_TSTR_MNT_Msk = 0x7000   // Bit mask of MNT field.
	RTC_TSTR_HU_Pos  = 0x10     // Position of HU field.
	RTC_TSTR_HU_Msk  = 0xf0000  // Bit mask of HU field.
	RTC_TSTR_HT_Pos  = 0x14     // Position of HT field.
	RTC_TSTR_HT_Msk  = 0x300000 // Bit mask of HT field.
	RTC_TSTR_PM_Pos  = 0x16     // Position of PM field.
	RTC_TSTR_PM_Msk  = 0x400000 // Bit mask of PM field.
	RTC_TSTR_PM      = 0x400000 // Bit PM.

	// TSDR: time stamp date register
	RTC_TSDR_WDU_Pos = 0xd    // Position of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000 // Bit mask of WDU field.
	RTC_TSDR_MT_Pos  = 0xc    // Position of MT field.
	RTC_TSDR_MT_Msk  = 0x1000 // Bit mask of MT field.
	RTC_TSDR_MT      = 0x1000 // Bit MT.
	RTC_TSDR_MU_Pos  = 0x8    // Position of MU field.
	RTC_TSDR_MU_Msk  = 0xf00  // Bit mask of MU field.
	RTC_TSDR_DT_Pos  = 0x4    // Position of DT field.
	RTC_TSDR_DT_Msk  = 0x30   // Bit mask of DT field.
	RTC_TSDR_DU_Pos  = 0x0    // Position of DU field.
	RTC_TSDR_DU_Msk  = 0xf    // Bit mask of DU field.

	// TSSSR: timestamp sub second register
	RTC_TSSSR_SS_Pos = 0x0    // Position of SS field.
	RTC_TSSSR_SS_Msk = 0xffff // Bit mask of SS field.

	// CALR: calibration register
	RTC_CALR_CALP_Pos   = 0xf    // Position of CALP field.
	RTC_CALR_CALP_Msk   = 0x8000 // Bit mask of CALP field.
	RTC_CALR_CALP       = 0x8000 // Bit CALP.
	RTC_CALR_CALW8_Pos  = 0xe    // Position of CALW8 field.
	RTC_CALR_CALW8_Msk  = 0x4000 // Bit mask of CALW8 field.
	RTC_CALR_CALW8      = 0x4000 // Bit CALW8.
	RTC_CALR_CALW16_Pos = 0xd    // Position of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000 // Bit mask of CALW16 field.
	RTC_CALR_CALW16     = 0x2000 // Bit CALW16.
	RTC_CALR_CALM_Pos   = 0x0    // Position of CALM field.
	RTC_CALR_CALM_Msk   = 0x1ff  // Bit mask of CALM field.

	// TAMPCR: tamper configuration register
	RTC_TAMPCR_TAMP1E_Pos       = 0x0       // Position of TAMP1E field.
	RTC_TAMPCR_TAMP1E_Msk       = 0x1       // Bit mask of TAMP1E field.
	RTC_TAMPCR_TAMP1E           = 0x1       // Bit TAMP1E.
	RTC_TAMPCR_TAMP1TRG_Pos     = 0x1       // Position of TAMP1TRG field.
	RTC_TAMPCR_TAMP1TRG_Msk     = 0x2       // Bit mask of TAMP1TRG field.
	RTC_TAMPCR_TAMP1TRG         = 0x2       // Bit TAMP1TRG.
	RTC_TAMPCR_TAMPIE_Pos       = 0x2       // Position of TAMPIE field.
	RTC_TAMPCR_TAMPIE_Msk       = 0x4       // Bit mask of TAMPIE field.
	RTC_TAMPCR_TAMPIE           = 0x4       // Bit TAMPIE.
	RTC_TAMPCR_TAMP2E_Pos       = 0x3       // Position of TAMP2E field.
	RTC_TAMPCR_TAMP2E_Msk       = 0x8       // Bit mask of TAMP2E field.
	RTC_TAMPCR_TAMP2E           = 0x8       // Bit TAMP2E.
	RTC_TAMPCR_TAMP2TRG_Pos     = 0x4       // Position of TAMP2TRG field.
	RTC_TAMPCR_TAMP2TRG_Msk     = 0x10      // Bit mask of TAMP2TRG field.
	RTC_TAMPCR_TAMP2TRG         = 0x10      // Bit TAMP2TRG.
	RTC_TAMPCR_TAMP3E_Pos       = 0x5       // Position of TAMP3E field.
	RTC_TAMPCR_TAMP3E_Msk       = 0x20      // Bit mask of TAMP3E field.
	RTC_TAMPCR_TAMP3E           = 0x20      // Bit TAMP3E.
	RTC_TAMPCR_TAMP3TRG_Pos     = 0x6       // Position of TAMP3TRG field.
	RTC_TAMPCR_TAMP3TRG_Msk     = 0x40      // Bit mask of TAMP3TRG field.
	RTC_TAMPCR_TAMP3TRG         = 0x40      // Bit TAMP3TRG.
	RTC_TAMPCR_TAMPTS_Pos       = 0x7       // Position of TAMPTS field.
	RTC_TAMPCR_TAMPTS_Msk       = 0x80      // Bit mask of TAMPTS field.
	RTC_TAMPCR_TAMPTS           = 0x80      // Bit TAMPTS.
	RTC_TAMPCR_TAMPFREQ_Pos     = 0x8       // Position of TAMPFREQ field.
	RTC_TAMPCR_TAMPFREQ_Msk     = 0x700     // Bit mask of TAMPFREQ field.
	RTC_TAMPCR_TAMPFLT_Pos      = 0xb       // Position of TAMPFLT field.
	RTC_TAMPCR_TAMPFLT_Msk      = 0x1800    // Bit mask of TAMPFLT field.
	RTC_TAMPCR_TAMPPRCH_Pos     = 0xd       // Position of TAMPPRCH field.
	RTC_TAMPCR_TAMPPRCH_Msk     = 0x6000    // Bit mask of TAMPPRCH field.
	RTC_TAMPCR_TAMPPUDIS_Pos    = 0xf       // Position of TAMPPUDIS field.
	RTC_TAMPCR_TAMPPUDIS_Msk    = 0x8000    // Bit mask of TAMPPUDIS field.
	RTC_TAMPCR_TAMPPUDIS        = 0x8000    // Bit TAMPPUDIS.
	RTC_TAMPCR_TAMP1IE_Pos      = 0x10      // Position of TAMP1IE field.
	RTC_TAMPCR_TAMP1IE_Msk      = 0x10000   // Bit mask of TAMP1IE field.
	RTC_TAMPCR_TAMP1IE          = 0x10000   // Bit TAMP1IE.
	RTC_TAMPCR_TAMP1NOERASE_Pos = 0x11      // Position of TAMP1NOERASE field.
	RTC_TAMPCR_TAMP1NOERASE_Msk = 0x20000   // Bit mask of TAMP1NOERASE field.
	RTC_TAMPCR_TAMP1NOERASE     = 0x20000   // Bit TAMP1NOERASE.
	RTC_TAMPCR_TAMP1MF_Pos      = 0x12      // Position of TAMP1MF field.
	RTC_TAMPCR_TAMP1MF_Msk      = 0x40000   // Bit mask of TAMP1MF field.
	RTC_TAMPCR_TAMP1MF          = 0x40000   // Bit TAMP1MF.
	RTC_TAMPCR_TAMP2IE_Pos      = 0x13      // Position of TAMP2IE field.
	RTC_TAMPCR_TAMP2IE_Msk      = 0x80000   // Bit mask of TAMP2IE field.
	RTC_TAMPCR_TAMP2IE          = 0x80000   // Bit TAMP2IE.
	RTC_TAMPCR_TAMP2NOERASE_Pos = 0x14      // Position of TAMP2NOERASE field.
	RTC_TAMPCR_TAMP2NOERASE_Msk = 0x100000  // Bit mask of TAMP2NOERASE field.
	RTC_TAMPCR_TAMP2NOERASE     = 0x100000  // Bit TAMP2NOERASE.
	RTC_TAMPCR_TAMP2MF_Pos      = 0x15      // Position of TAMP2MF field.
	RTC_TAMPCR_TAMP2MF_Msk      = 0x200000  // Bit mask of TAMP2MF field.
	RTC_TAMPCR_TAMP2MF          = 0x200000  // Bit TAMP2MF.
	RTC_TAMPCR_TAMP3IE_Pos      = 0x16      // Position of TAMP3IE field.
	RTC_TAMPCR_TAMP3IE_Msk      = 0x400000  // Bit mask of TAMP3IE field.
	RTC_TAMPCR_TAMP3IE          = 0x400000  // Bit TAMP3IE.
	RTC_TAMPCR_TAMP3NOERASE_Pos = 0x17      // Position of TAMP3NOERASE field.
	RTC_TAMPCR_TAMP3NOERASE_Msk = 0x800000  // Bit mask of TAMP3NOERASE field.
	RTC_TAMPCR_TAMP3NOERASE     = 0x800000  // Bit TAMP3NOERASE.
	RTC_TAMPCR_TAMP3MF_Pos      = 0x18      // Position of TAMP3MF field.
	RTC_TAMPCR_TAMP3MF_Msk      = 0x1000000 // Bit mask of TAMP3MF field.
	RTC_TAMPCR_TAMP3MF          = 0x1000000 // Bit TAMP3MF.

	// ALRMASSR: alarm A sub second register
	RTC_ALRMASSR_MASKSS_Pos = 0x18      // Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0xf000000 // Bit mask of MASKSS field.
	RTC_ALRMASSR_SS_Pos     = 0x0       // Position of SS field.
	RTC_ALRMASSR_SS_Msk     = 0x7fff    // Bit mask of SS field.

	// ALRMBSSR: alarm B sub second register
	RTC_ALRMBSSR_MASKSS_Pos = 0x18      // Position of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Msk = 0xf000000 // Bit mask of MASKSS field.
	RTC_ALRMBSSR_SS_Pos     = 0x0       // Position of SS field.
	RTC_ALRMBSSR_SS_Msk     = 0x7fff    // Bit mask of SS field.

	// OR: option register
	RTC_OR_RTC_ALARM_TYPE_Pos = 0x0 // Position of RTC_ALARM_TYPE field.
	RTC_OR_RTC_ALARM_TYPE_Msk = 0x1 // Bit mask of RTC_ALARM_TYPE field.
	RTC_OR_RTC_ALARM_TYPE     = 0x1 // Bit RTC_ALARM_TYPE.
	RTC_OR_RTC_OUT_RMP_Pos    = 0x1 // Position of RTC_OUT_RMP field.
	RTC_OR_RTC_OUT_RMP_Msk    = 0x2 // Bit mask of RTC_OUT_RMP field.
	RTC_OR_RTC_OUT_RMP        = 0x2 // Bit RTC_OUT_RMP.

	// BKP0R: backup register
	RTC_BKP0R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP0R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP1R: backup register
	RTC_BKP1R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP1R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP2R: backup register
	RTC_BKP2R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP2R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP3R: backup register
	RTC_BKP3R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP3R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP4R: backup register
	RTC_BKP4R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP4R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP5R: backup register
	RTC_BKP5R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP5R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP6R: backup register
	RTC_BKP6R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP6R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP7R: backup register
	RTC_BKP7R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP7R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP8R: backup register
	RTC_BKP8R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP8R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP9R: backup register
	RTC_BKP9R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP9R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP10R: backup register
	RTC_BKP10R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP10R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP11R: backup register
	RTC_BKP11R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP11R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP12R: backup register
	RTC_BKP12R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP12R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP13R: backup register
	RTC_BKP13R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP13R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP14R: backup register
	RTC_BKP14R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP14R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP15R: backup register
	RTC_BKP15R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP15R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP16R: backup register
	RTC_BKP16R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP16R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP17R: backup register
	RTC_BKP17R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP17R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP18R: backup register
	RTC_BKP18R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP18R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP19R: backup register
	RTC_BKP19R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP19R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP20R: backup register
	RTC_BKP20R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP20R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP21R: backup register
	RTC_BKP21R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP21R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP22R: backup register
	RTC_BKP22R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP22R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP23R: backup register
	RTC_BKP23R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP23R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP24R: backup register
	RTC_BKP24R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP24R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP25R: backup register
	RTC_BKP25R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP25R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP26R: backup register
	RTC_BKP26R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP26R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP27R: backup register
	RTC_BKP27R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP27R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP28R: backup register
	RTC_BKP28R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP28R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP29R: backup register
	RTC_BKP29R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP29R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP30R: backup register
	RTC_BKP30R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP30R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP31R: backup register
	RTC_BKP31R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP31R_BKP_Msk = 0xffffffff // Bit mask of BKP field.
)

// Bitfields for USART6: Universal synchronous asynchronous receiver transmitter
const (
	// CR1: Control register 1
	USART_CR1_M1_Pos     = 0x1c       // Position of M1 field.
	USART_CR1_M1_Msk     = 0x10000000 // Bit mask of M1 field.
	USART_CR1_M1         = 0x10000000 // Bit M1.
	USART_CR1_EOBIE_Pos  = 0x1b       // Position of EOBIE field.
	USART_CR1_EOBIE_Msk  = 0x8000000  // Bit mask of EOBIE field.
	USART_CR1_EOBIE      = 0x8000000  // Bit EOBIE.
	USART_CR1_RTOIE_Pos  = 0x1a       // Position of RTOIE field.
	USART_CR1_RTOIE_Msk  = 0x4000000  // Bit mask of RTOIE field.
	USART_CR1_RTOIE      = 0x4000000  // Bit RTOIE.
	USART_CR1_DEAT4_Pos  = 0x19       // Position of DEAT4 field.
	USART_CR1_DEAT4_Msk  = 0x2000000  // Bit mask of DEAT4 field.
	USART_CR1_DEAT4      = 0x2000000  // Bit DEAT4.
	USART_CR1_DEAT3_Pos  = 0x18       // Position of DEAT3 field.
	USART_CR1_DEAT3_Msk  = 0x1000000  // Bit mask of DEAT3 field.
	USART_CR1_DEAT3      = 0x1000000  // Bit DEAT3.
	USART_CR1_DEAT2_Pos  = 0x17       // Position of DEAT2 field.
	USART_CR1_DEAT2_Msk  = 0x800000   // Bit mask of DEAT2 field.
	USART_CR1_DEAT2      = 0x800000   // Bit DEAT2.
	USART_CR1_DEAT1_Pos  = 0x16       // Position of DEAT1 field.
	USART_CR1_DEAT1_Msk  = 0x400000   // Bit mask of DEAT1 field.
	USART_CR1_DEAT1      = 0x400000   // Bit DEAT1.
	USART_CR1_DEAT0_Pos  = 0x15       // Position of DEAT0 field.
	USART_CR1_DEAT0_Msk  = 0x200000   // Bit mask of DEAT0 field.
	USART_CR1_DEAT0      = 0x200000   // Bit DEAT0.
	USART_CR1_DEDT4_Pos  = 0x14       // Position of DEDT4 field.
	USART_CR1_DEDT4_Msk  = 0x100000   // Bit mask of DEDT4 field.
	USART_CR1_DEDT4      = 0x100000   // Bit DEDT4.
	USART_CR1_DEDT3_Pos  = 0x13       // Position of DEDT3 field.
	USART_CR1_DEDT3_Msk  = 0x80000    // Bit mask of DEDT3 field.
	USART_CR1_DEDT3      = 0x80000    // Bit DEDT3.
	USART_CR1_DEDT2_Pos  = 0x12       // Position of DEDT2 field.
	USART_CR1_DEDT2_Msk  = 0x40000    // Bit mask of DEDT2 field.
	USART_CR1_DEDT2      = 0x40000    // Bit DEDT2.
	USART_CR1_DEDT1_Pos  = 0x11       // Position of DEDT1 field.
	USART_CR1_DEDT1_Msk  = 0x20000    // Bit mask of DEDT1 field.
	USART_CR1_DEDT1      = 0x20000    // Bit DEDT1.
	USART_CR1_DEDT0_Pos  = 0x10       // Position of DEDT0 field.
	USART_CR1_DEDT0_Msk  = 0x10000    // Bit mask of DEDT0 field.
	USART_CR1_DEDT0      = 0x10000    // Bit DEDT0.
	USART_CR1_OVER8_Pos  = 0xf        // Position of OVER8 field.
	USART_CR1_OVER8_Msk  = 0x8000     // Bit mask of OVER8 field.
	USART_CR1_OVER8      = 0x8000     // Bit OVER8.
	USART_CR1_CMIE_Pos   = 0xe        // Position of CMIE field.
	USART_CR1_CMIE_Msk   = 0x4000     // Bit mask of CMIE field.
	USART_CR1_CMIE       = 0x4000     // Bit CMIE.
	USART_CR1_MME_Pos    = 0xd        // Position of MME field.
	USART_CR1_MME_Msk    = 0x2000     // Bit mask of MME field.
	USART_CR1_MME        = 0x2000     // Bit MME.
	USART_CR1_M0_Pos     = 0xc        // Position of M0 field.
	USART_CR1_M0_Msk     = 0x1000     // Bit mask of M0 field.
	USART_CR1_M0         = 0x1000     // Bit M0.
	USART_CR1_WAKE_Pos   = 0xb        // Position of WAKE field.
	USART_CR1_WAKE_Msk   = 0x800      // Bit mask of WAKE field.
	USART_CR1_WAKE       = 0x800      // Bit WAKE.
	USART_CR1_PCE_Pos    = 0xa        // Position of PCE field.
	USART_CR1_PCE_Msk    = 0x400      // Bit mask of PCE field.
	USART_CR1_PCE        = 0x400      // Bit PCE.
	USART_CR1_PS_Pos     = 0x9        // Position of PS field.
	USART_CR1_PS_Msk     = 0x200      // Bit mask of PS field.
	USART_CR1_PS         = 0x200      // Bit PS.
	USART_CR1_PEIE_Pos   = 0x8        // Position of PEIE field.
	USART_CR1_PEIE_Msk   = 0x100      // Bit mask of PEIE field.
	USART_CR1_PEIE       = 0x100      // Bit PEIE.
	USART_CR1_TXEIE_Pos  = 0x7        // Position of TXEIE field.
	USART_CR1_TXEIE_Msk  = 0x80       // Bit mask of TXEIE field.
	USART_CR1_TXEIE      = 0x80       // Bit TXEIE.
	USART_CR1_TCIE_Pos   = 0x6        // Position of TCIE field.
	USART_CR1_TCIE_Msk   = 0x40       // Bit mask of TCIE field.
	USART_CR1_TCIE       = 0x40       // Bit TCIE.
	USART_CR1_RXNEIE_Pos = 0x5        // Position of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20       // Bit mask of RXNEIE field.
	USART_CR1_RXNEIE     = 0x20       // Bit RXNEIE.
	USART_CR1_IDLEIE_Pos = 0x4        // Position of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10       // Bit mask of IDLEIE field.
	USART_CR1_IDLEIE     = 0x10       // Bit IDLEIE.
	USART_CR1_TE_Pos     = 0x3        // Position of TE field.
	USART_CR1_TE_Msk     = 0x8        // Bit mask of TE field.
	USART_CR1_TE         = 0x8        // Bit TE.
	USART_CR1_RE_Pos     = 0x2        // Position of RE field.
	USART_CR1_RE_Msk     = 0x4        // Bit mask of RE field.
	USART_CR1_RE         = 0x4        // Bit RE.
	USART_CR1_UESM_Pos   = 0x1        // Position of UESM field.
	USART_CR1_UESM_Msk   = 0x2        // Bit mask of UESM field.
	USART_CR1_UESM       = 0x2        // Bit UESM.
	USART_CR1_UE_Pos     = 0x0        // Position of UE field.
	USART_CR1_UE_Msk     = 0x1        // Bit mask of UE field.
	USART_CR1_UE         = 0x1        // Bit UE.

	// CR2: Control register 2
	USART_CR2_ADD4_7_Pos   = 0x1c       // Position of ADD4_7 field.
	USART_CR2_ADD4_7_Msk   = 0xf0000000 // Bit mask of ADD4_7 field.
	USART_CR2_ADD0_3_Pos   = 0x18       // Position of ADD0_3 field.
	USART_CR2_ADD0_3_Msk   = 0xf000000  // Bit mask of ADD0_3 field.
	USART_CR2_RTOEN_Pos    = 0x17       // Position of RTOEN field.
	USART_CR2_RTOEN_Msk    = 0x800000   // Bit mask of RTOEN field.
	USART_CR2_RTOEN        = 0x800000   // Bit RTOEN.
	USART_CR2_ABRMOD1_Pos  = 0x16       // Position of ABRMOD1 field.
	USART_CR2_ABRMOD1_Msk  = 0x400000   // Bit mask of ABRMOD1 field.
	USART_CR2_ABRMOD1      = 0x400000   // Bit ABRMOD1.
	USART_CR2_ABRMOD0_Pos  = 0x15       // Position of ABRMOD0 field.
	USART_CR2_ABRMOD0_Msk  = 0x200000   // Bit mask of ABRMOD0 field.
	USART_CR2_ABRMOD0      = 0x200000   // Bit ABRMOD0.
	USART_CR2_ABREN_Pos    = 0x14       // Position of ABREN field.
	USART_CR2_ABREN_Msk    = 0x100000   // Bit mask of ABREN field.
	USART_CR2_ABREN        = 0x100000   // Bit ABREN.
	USART_CR2_MSBFIRST_Pos = 0x13       // Position of MSBFIRST field.
	USART_CR2_MSBFIRST_Msk = 0x80000    // Bit mask of MSBFIRST field.
	USART_CR2_MSBFIRST     = 0x80000    // Bit MSBFIRST.
	USART_CR2_TAINV_Pos    = 0x12       // Position of TAINV field.
	USART_CR2_TAINV_Msk    = 0x40000    // Bit mask of TAINV field.
	USART_CR2_TAINV        = 0x40000    // Bit TAINV.
	USART_CR2_TXINV_Pos    = 0x11       // Position of TXINV field.
	USART_CR2_TXINV_Msk    = 0x20000    // Bit mask of TXINV field.
	USART_CR2_TXINV        = 0x20000    // Bit TXINV.
	USART_CR2_RXINV_Pos    = 0x10       // Position of RXINV field.
	USART_CR2_RXINV_Msk    = 0x10000    // Bit mask of RXINV field.
	USART_CR2_RXINV        = 0x10000    // Bit RXINV.
	USART_CR2_SWAP_Pos     = 0xf        // Position of SWAP field.
	USART_CR2_SWAP_Msk     = 0x8000     // Bit mask of SWAP field.
	USART_CR2_SWAP         = 0x8000     // Bit SWAP.
	USART_CR2_LINEN_Pos    = 0xe        // Position of LINEN field.
	USART_CR2_LINEN_Msk    = 0x4000     // Bit mask of LINEN field.
	USART_CR2_LINEN        = 0x4000     // Bit LINEN.
	USART_CR2_STOP_Pos     = 0xc        // Position of STOP field.
	USART_CR2_STOP_Msk     = 0x3000     // Bit mask of STOP field.
	USART_CR2_CLKEN_Pos    = 0xb        // Position of CLKEN field.
	USART_CR2_CLKEN_Msk    = 0x800      // Bit mask of CLKEN field.
	USART_CR2_CLKEN        = 0x800      // Bit CLKEN.
	USART_CR2_CPOL_Pos     = 0xa        // Position of CPOL field.
	USART_CR2_CPOL_Msk     = 0x400      // Bit mask of CPOL field.
	USART_CR2_CPOL         = 0x400      // Bit CPOL.
	USART_CR2_CPHA_Pos     = 0x9        // Position of CPHA field.
	USART_CR2_CPHA_Msk     = 0x200      // Bit mask of CPHA field.
	USART_CR2_CPHA         = 0x200      // Bit CPHA.
	USART_CR2_LBCL_Pos     = 0x8        // Position of LBCL field.
	USART_CR2_LBCL_Msk     = 0x100      // Bit mask of LBCL field.
	USART_CR2_LBCL         = 0x100      // Bit LBCL.
	USART_CR2_LBDIE_Pos    = 0x6        // Position of LBDIE field.
	USART_CR2_LBDIE_Msk    = 0x40       // Bit mask of LBDIE field.
	USART_CR2_LBDIE        = 0x40       // Bit LBDIE.
	USART_CR2_LBDL_Pos     = 0x5        // Position of LBDL field.
	USART_CR2_LBDL_Msk     = 0x20       // Bit mask of LBDL field.
	USART_CR2_LBDL         = 0x20       // Bit LBDL.
	USART_CR2_ADDM7_Pos    = 0x4        // Position of ADDM7 field.
	USART_CR2_ADDM7_Msk    = 0x10       // Bit mask of ADDM7 field.
	USART_CR2_ADDM7        = 0x10       // Bit ADDM7.

	// CR3: Control register 3
	USART_CR3_WUFIE_Pos   = 0x16     // Position of WUFIE field.
	USART_CR3_WUFIE_Msk   = 0x400000 // Bit mask of WUFIE field.
	USART_CR3_WUFIE       = 0x400000 // Bit WUFIE.
	USART_CR3_WUS_Pos     = 0x14     // Position of WUS field.
	USART_CR3_WUS_Msk     = 0x300000 // Bit mask of WUS field.
	USART_CR3_SCARCNT_Pos = 0x11     // Position of SCARCNT field.
	USART_CR3_SCARCNT_Msk = 0xe0000  // Bit mask of SCARCNT field.
	USART_CR3_DEP_Pos     = 0xf      // Position of DEP field.
	USART_CR3_DEP_Msk     = 0x8000   // Bit mask of DEP field.
	USART_CR3_DEP         = 0x8000   // Bit DEP.
	USART_CR3_DEM_Pos     = 0xe      // Position of DEM field.
	USART_CR3_DEM_Msk     = 0x4000   // Bit mask of DEM field.
	USART_CR3_DEM         = 0x4000   // Bit DEM.
	USART_CR3_DDRE_Pos    = 0xd      // Position of DDRE field.
	USART_CR3_DDRE_Msk    = 0x2000   // Bit mask of DDRE field.
	USART_CR3_DDRE        = 0x2000   // Bit DDRE.
	USART_CR3_OVRDIS_Pos  = 0xc      // Position of OVRDIS field.
	USART_CR3_OVRDIS_Msk  = 0x1000   // Bit mask of OVRDIS field.
	USART_CR3_OVRDIS      = 0x1000   // Bit OVRDIS.
	USART_CR3_ONEBIT_Pos  = 0xb      // Position of ONEBIT field.
	USART_CR3_ONEBIT_Msk  = 0x800    // Bit mask of ONEBIT field.
	USART_CR3_ONEBIT      = 0x800    // Bit ONEBIT.
	USART_CR3_CTSIE_Pos   = 0xa      // Position of CTSIE field.
	USART_CR3_CTSIE_Msk   = 0x400    // Bit mask of CTSIE field.
	USART_CR3_CTSIE       = 0x400    // Bit CTSIE.
	USART_CR3_CTSE_Pos    = 0x9      // Position of CTSE field.
	USART_CR3_CTSE_Msk    = 0x200    // Bit mask of CTSE field.
	USART_CR3_CTSE        = 0x200    // Bit CTSE.
	USART_CR3_RTSE_Pos    = 0x8      // Position of RTSE field.
	USART_CR3_RTSE_Msk    = 0x100    // Bit mask of RTSE field.
	USART_CR3_RTSE        = 0x100    // Bit RTSE.
	USART_CR3_DMAT_Pos    = 0x7      // Position of DMAT field.
	USART_CR3_DMAT_Msk    = 0x80     // Bit mask of DMAT field.
	USART_CR3_DMAT        = 0x80     // Bit DMAT.
	USART_CR3_DMAR_Pos    = 0x6      // Position of DMAR field.
	USART_CR3_DMAR_Msk    = 0x40     // Bit mask of DMAR field.
	USART_CR3_DMAR        = 0x40     // Bit DMAR.
	USART_CR3_SCEN_Pos    = 0x5      // Position of SCEN field.
	USART_CR3_SCEN_Msk    = 0x20     // Bit mask of SCEN field.
	USART_CR3_SCEN        = 0x20     // Bit SCEN.
	USART_CR3_NACK_Pos    = 0x4      // Position of NACK field.
	USART_CR3_NACK_Msk    = 0x10     // Bit mask of NACK field.
	USART_CR3_NACK        = 0x10     // Bit NACK.
	USART_CR3_HDSEL_Pos   = 0x3      // Position of HDSEL field.
	USART_CR3_HDSEL_Msk   = 0x8      // Bit mask of HDSEL field.
	USART_CR3_HDSEL       = 0x8      // Bit HDSEL.
	USART_CR3_IRLP_Pos    = 0x2      // Position of IRLP field.
	USART_CR3_IRLP_Msk    = 0x4      // Bit mask of IRLP field.
	USART_CR3_IRLP        = 0x4      // Bit IRLP.
	USART_CR3_IREN_Pos    = 0x1      // Position of IREN field.
	USART_CR3_IREN_Msk    = 0x2      // Bit mask of IREN field.
	USART_CR3_IREN        = 0x2      // Bit IREN.
	USART_CR3_EIE_Pos     = 0x0      // Position of EIE field.
	USART_CR3_EIE_Msk     = 0x1      // Bit mask of EIE field.
	USART_CR3_EIE         = 0x1      // Bit EIE.

	// BRR: Baud rate register
	USART_BRR_DIV_Mantissa_Pos = 0x4    // Position of DIV_Mantissa field.
	USART_BRR_DIV_Mantissa_Msk = 0xfff0 // Bit mask of DIV_Mantissa field.
	USART_BRR_DIV_Fraction_Pos = 0x0    // Position of DIV_Fraction field.
	USART_BRR_DIV_Fraction_Msk = 0xf    // Bit mask of DIV_Fraction field.

	// GTPR: Guard time and prescaler           register
	USART_GTPR_GT_Pos  = 0x8    // Position of GT field.
	USART_GTPR_GT_Msk  = 0xff00 // Bit mask of GT field.
	USART_GTPR_PSC_Pos = 0x0    // Position of PSC field.
	USART_GTPR_PSC_Msk = 0xff   // Bit mask of PSC field.

	// RTOR: Receiver timeout register
	USART_RTOR_BLEN_Pos = 0x18       // Position of BLEN field.
	USART_RTOR_BLEN_Msk = 0xff000000 // Bit mask of BLEN field.
	USART_RTOR_RTO_Pos  = 0x0        // Position of RTO field.
	USART_RTOR_RTO_Msk  = 0xffffff   // Bit mask of RTO field.

	// RQR: Request register
	USART_RQR_TXFRQ_Pos = 0x4  // Position of TXFRQ field.
	USART_RQR_TXFRQ_Msk = 0x10 // Bit mask of TXFRQ field.
	USART_RQR_TXFRQ     = 0x10 // Bit TXFRQ.
	USART_RQR_RXFRQ_Pos = 0x3  // Position of RXFRQ field.
	USART_RQR_RXFRQ_Msk = 0x8  // Bit mask of RXFRQ field.
	USART_RQR_RXFRQ     = 0x8  // Bit RXFRQ.
	USART_RQR_MMRQ_Pos  = 0x2  // Position of MMRQ field.
	USART_RQR_MMRQ_Msk  = 0x4  // Bit mask of MMRQ field.
	USART_RQR_MMRQ      = 0x4  // Bit MMRQ.
	USART_RQR_SBKRQ_Pos = 0x1  // Position of SBKRQ field.
	USART_RQR_SBKRQ_Msk = 0x2  // Bit mask of SBKRQ field.
	USART_RQR_SBKRQ     = 0x2  // Bit SBKRQ.
	USART_RQR_ABRRQ_Pos = 0x0  // Position of ABRRQ field.
	USART_RQR_ABRRQ_Msk = 0x1  // Bit mask of ABRRQ field.
	USART_RQR_ABRRQ     = 0x1  // Bit ABRRQ.

	// ISR: Interrupt & status           register
	USART_ISR_REACK_Pos = 0x16     // Position of REACK field.
	USART_ISR_REACK_Msk = 0x400000 // Bit mask of REACK field.
	USART_ISR_REACK     = 0x400000 // Bit REACK.
	USART_ISR_TEACK_Pos = 0x15     // Position of TEACK field.
	USART_ISR_TEACK_Msk = 0x200000 // Bit mask of TEACK field.
	USART_ISR_TEACK     = 0x200000 // Bit TEACK.
	USART_ISR_WUF_Pos   = 0x14     // Position of WUF field.
	USART_ISR_WUF_Msk   = 0x100000 // Bit mask of WUF field.
	USART_ISR_WUF       = 0x100000 // Bit WUF.
	USART_ISR_RWU_Pos   = 0x13     // Position of RWU field.
	USART_ISR_RWU_Msk   = 0x80000  // Bit mask of RWU field.
	USART_ISR_RWU       = 0x80000  // Bit RWU.
	USART_ISR_SBKF_Pos  = 0x12     // Position of SBKF field.
	USART_ISR_SBKF_Msk  = 0x40000  // Bit mask of SBKF field.
	USART_ISR_SBKF      = 0x40000  // Bit SBKF.
	USART_ISR_CMF_Pos   = 0x11     // Position of CMF field.
	USART_ISR_CMF_Msk   = 0x20000  // Bit mask of CMF field.
	USART_ISR_CMF       = 0x20000  // Bit CMF.
	USART_ISR_BUSY_Pos  = 0x10     // Position of BUSY field.
	USART_ISR_BUSY_Msk  = 0x10000  // Bit mask of BUSY field.
	USART_ISR_BUSY      = 0x10000  // Bit BUSY.
	USART_ISR_ABRF_Pos  = 0xf      // Position of ABRF field.
	USART_ISR_ABRF_Msk  = 0x8000   // Bit mask of ABRF field.
	USART_ISR_ABRF      = 0x8000   // Bit ABRF.
	USART_ISR_ABRE_Pos  = 0xe      // Position of ABRE field.
	USART_ISR_ABRE_Msk  = 0x4000   // Bit mask of ABRE field.
	USART_ISR_ABRE      = 0x4000   // Bit ABRE.
	USART_ISR_EOBF_Pos  = 0xc      // Position of EOBF field.
	USART_ISR_EOBF_Msk  = 0x1000   // Bit mask of EOBF field.
	USART_ISR_EOBF      = 0x1000   // Bit EOBF.
	USART_ISR_RTOF_Pos  = 0xb      // Position of RTOF field.
	USART_ISR_RTOF_Msk  = 0x800    // Bit mask of RTOF field.
	USART_ISR_RTOF      = 0x800    // Bit RTOF.
	USART_ISR_CTS_Pos   = 0xa      // Position of CTS field.
	USART_ISR_CTS_Msk   = 0x400    // Bit mask of CTS field.
	USART_ISR_CTS       = 0x400    // Bit CTS.
	USART_ISR_CTSIF_Pos = 0x9      // Position of CTSIF field.
	USART_ISR_CTSIF_Msk = 0x200    // Bit mask of CTSIF field.
	USART_ISR_CTSIF     = 0x200    // Bit CTSIF.
	USART_ISR_LBDF_Pos  = 0x8      // Position of LBDF field.
	USART_ISR_LBDF_Msk  = 0x100    // Bit mask of LBDF field.
	USART_ISR_LBDF      = 0x100    // Bit LBDF.
	USART_ISR_TXE_Pos   = 0x7      // Position of TXE field.
	USART_ISR_TXE_Msk   = 0x80     // Bit mask of TXE field.
	USART_ISR_TXE       = 0x80     // Bit TXE.
	USART_ISR_TC_Pos    = 0x6      // Position of TC field.
	USART_ISR_TC_Msk    = 0x40     // Bit mask of TC field.
	USART_ISR_TC        = 0x40     // Bit TC.
	USART_ISR_RXNE_Pos  = 0x5      // Position of RXNE field.
	USART_ISR_RXNE_Msk  = 0x20     // Bit mask of RXNE field.
	USART_ISR_RXNE      = 0x20     // Bit RXNE.
	USART_ISR_IDLE_Pos  = 0x4      // Position of IDLE field.
	USART_ISR_IDLE_Msk  = 0x10     // Bit mask of IDLE field.
	USART_ISR_IDLE      = 0x10     // Bit IDLE.
	USART_ISR_ORE_Pos   = 0x3      // Position of ORE field.
	USART_ISR_ORE_Msk   = 0x8      // Bit mask of ORE field.
	USART_ISR_ORE       = 0x8      // Bit ORE.
	USART_ISR_NF_Pos    = 0x2      // Position of NF field.
	USART_ISR_NF_Msk    = 0x4      // Bit mask of NF field.
	USART_ISR_NF        = 0x4      // Bit NF.
	USART_ISR_FE_Pos    = 0x1      // Position of FE field.
	USART_ISR_FE_Msk    = 0x2      // Bit mask of FE field.
	USART_ISR_FE        = 0x2      // Bit FE.
	USART_ISR_PE_Pos    = 0x0      // Position of PE field.
	USART_ISR_PE_Msk    = 0x1      // Bit mask of PE field.
	USART_ISR_PE        = 0x1      // Bit PE.

	// ICR: Interrupt flag clear register
	USART_ICR_WUCF_Pos   = 0x14     // Position of WUCF field.
	USART_ICR_WUCF_Msk   = 0x100000 // Bit mask of WUCF field.
	USART_ICR_WUCF       = 0x100000 // Bit WUCF.
	USART_ICR_CMCF_Pos   = 0x11     // Position of CMCF field.
	USART_ICR_CMCF_Msk   = 0x20000  // Bit mask of CMCF field.
	USART_ICR_CMCF       = 0x20000  // Bit CMCF.
	USART_ICR_EOBCF_Pos  = 0xc      // Position of EOBCF field.
	USART_ICR_EOBCF_Msk  = 0x1000   // Bit mask of EOBCF field.
	USART_ICR_EOBCF      = 0x1000   // Bit EOBCF.
	USART_ICR_RTOCF_Pos  = 0xb      // Position of RTOCF field.
	USART_ICR_RTOCF_Msk  = 0x800    // Bit mask of RTOCF field.
	USART_ICR_RTOCF      = 0x800    // Bit RTOCF.
	USART_ICR_CTSCF_Pos  = 0x9      // Position of CTSCF field.
	USART_ICR_CTSCF_Msk  = 0x200    // Bit mask of CTSCF field.
	USART_ICR_CTSCF      = 0x200    // Bit CTSCF.
	USART_ICR_LBDCF_Pos  = 0x8      // Position of LBDCF field.
	USART_ICR_LBDCF_Msk  = 0x100    // Bit mask of LBDCF field.
	USART_ICR_LBDCF      = 0x100    // Bit LBDCF.
	USART_ICR_TCCF_Pos   = 0x6      // Position of TCCF field.
	USART_ICR_TCCF_Msk   = 0x40     // Bit mask of TCCF field.
	USART_ICR_TCCF       = 0x40     // Bit TCCF.
	USART_ICR_IDLECF_Pos = 0x4      // Position of IDLECF field.
	USART_ICR_IDLECF_Msk = 0x10     // Bit mask of IDLECF field.
	USART_ICR_IDLECF     = 0x10     // Bit IDLECF.
	USART_ICR_ORECF_Pos  = 0x3      // Position of ORECF field.
	USART_ICR_ORECF_Msk  = 0x8      // Bit mask of ORECF field.
	USART_ICR_ORECF      = 0x8      // Bit ORECF.
	USART_ICR_NCF_Pos    = 0x2      // Position of NCF field.
	USART_ICR_NCF_Msk    = 0x4      // Bit mask of NCF field.
	USART_ICR_NCF        = 0x4      // Bit NCF.
	USART_ICR_FECF_Pos   = 0x1      // Position of FECF field.
	USART_ICR_FECF_Msk   = 0x2      // Bit mask of FECF field.
	USART_ICR_FECF       = 0x2      // Bit FECF.
	USART_ICR_PECF_Pos   = 0x0      // Position of PECF field.
	USART_ICR_PECF_Msk   = 0x1      // Bit mask of PECF field.
	USART_ICR_PECF       = 0x1      // Bit PECF.

	// RDR: Receive data register
	USART_RDR_RDR_Pos = 0x0   // Position of RDR field.
	USART_RDR_RDR_Msk = 0x1ff // Bit mask of RDR field.

	// TDR: Transmit data register
	USART_TDR_TDR_Pos = 0x0   // Position of TDR field.
	USART_TDR_TDR_Msk = 0x1ff // Bit mask of TDR field.
)

// Bitfields for OTG_FS_GLOBAL: USB on the go full speed
const (
	// OTG_FS_GOTGCTL: OTG_FS control and status register           (OTG_FS_GOTGCTL)
	USB_OTG_FS_OTG_FS_GOTGCTL_SRQSCS_Pos    = 0x0      // Position of SRQSCS field.
	USB_OTG_FS_OTG_FS_GOTGCTL_SRQSCS_Msk    = 0x1      // Bit mask of SRQSCS field.
	USB_OTG_FS_OTG_FS_GOTGCTL_SRQSCS        = 0x1      // Bit SRQSCS.
	USB_OTG_FS_OTG_FS_GOTGCTL_SRQ_Pos       = 0x1      // Position of SRQ field.
	USB_OTG_FS_OTG_FS_GOTGCTL_SRQ_Msk       = 0x2      // Bit mask of SRQ field.
	USB_OTG_FS_OTG_FS_GOTGCTL_SRQ           = 0x2      // Bit SRQ.
	USB_OTG_FS_OTG_FS_GOTGCTL_HNGSCS_Pos    = 0x8      // Position of HNGSCS field.
	USB_OTG_FS_OTG_FS_GOTGCTL_HNGSCS_Msk    = 0x100    // Bit mask of HNGSCS field.
	USB_OTG_FS_OTG_FS_GOTGCTL_HNGSCS        = 0x100    // Bit HNGSCS.
	USB_OTG_FS_OTG_FS_GOTGCTL_HNPRQ_Pos     = 0x9      // Position of HNPRQ field.
	USB_OTG_FS_OTG_FS_GOTGCTL_HNPRQ_Msk     = 0x200    // Bit mask of HNPRQ field.
	USB_OTG_FS_OTG_FS_GOTGCTL_HNPRQ         = 0x200    // Bit HNPRQ.
	USB_OTG_FS_OTG_FS_GOTGCTL_HSHNPEN_Pos   = 0xa      // Position of HSHNPEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_HSHNPEN_Msk   = 0x400    // Bit mask of HSHNPEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_HSHNPEN       = 0x400    // Bit HSHNPEN.
	USB_OTG_FS_OTG_FS_GOTGCTL_DHNPEN_Pos    = 0xb      // Position of DHNPEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_DHNPEN_Msk    = 0x800    // Bit mask of DHNPEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_DHNPEN        = 0x800    // Bit DHNPEN.
	USB_OTG_FS_OTG_FS_GOTGCTL_CIDSTS_Pos    = 0x10     // Position of CIDSTS field.
	USB_OTG_FS_OTG_FS_GOTGCTL_CIDSTS_Msk    = 0x10000  // Bit mask of CIDSTS field.
	USB_OTG_FS_OTG_FS_GOTGCTL_CIDSTS        = 0x10000  // Bit CIDSTS.
	USB_OTG_FS_OTG_FS_GOTGCTL_DBCT_Pos      = 0x11     // Position of DBCT field.
	USB_OTG_FS_OTG_FS_GOTGCTL_DBCT_Msk      = 0x20000  // Bit mask of DBCT field.
	USB_OTG_FS_OTG_FS_GOTGCTL_DBCT          = 0x20000  // Bit DBCT.
	USB_OTG_FS_OTG_FS_GOTGCTL_ASVLD_Pos     = 0x12     // Position of ASVLD field.
	USB_OTG_FS_OTG_FS_GOTGCTL_ASVLD_Msk     = 0x40000  // Bit mask of ASVLD field.
	USB_OTG_FS_OTG_FS_GOTGCTL_ASVLD         = 0x40000  // Bit ASVLD.
	USB_OTG_FS_OTG_FS_GOTGCTL_BSVLD_Pos     = 0x13     // Position of BSVLD field.
	USB_OTG_FS_OTG_FS_GOTGCTL_BSVLD_Msk     = 0x80000  // Bit mask of BSVLD field.
	USB_OTG_FS_OTG_FS_GOTGCTL_BSVLD         = 0x80000  // Bit BSVLD.
	USB_OTG_FS_OTG_FS_GOTGCTL_VBVALOEN_Pos  = 0x2      // Position of VBVALOEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_VBVALOEN_Msk  = 0x4      // Bit mask of VBVALOEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_VBVALOEN      = 0x4      // Bit VBVALOEN.
	USB_OTG_FS_OTG_FS_GOTGCTL_VBVALOVAL_Pos = 0x3      // Position of VBVALOVAL field.
	USB_OTG_FS_OTG_FS_GOTGCTL_VBVALOVAL_Msk = 0x8      // Bit mask of VBVALOVAL field.
	USB_OTG_FS_OTG_FS_GOTGCTL_VBVALOVAL     = 0x8      // Bit VBVALOVAL.
	USB_OTG_FS_OTG_FS_GOTGCTL_AVALOEN_Pos   = 0x4      // Position of AVALOEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_AVALOEN_Msk   = 0x10     // Bit mask of AVALOEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_AVALOEN       = 0x10     // Bit AVALOEN.
	USB_OTG_FS_OTG_FS_GOTGCTL_AVALOVAL_Pos  = 0x5      // Position of AVALOVAL field.
	USB_OTG_FS_OTG_FS_GOTGCTL_AVALOVAL_Msk  = 0x20     // Bit mask of AVALOVAL field.
	USB_OTG_FS_OTG_FS_GOTGCTL_AVALOVAL      = 0x20     // Bit AVALOVAL.
	USB_OTG_FS_OTG_FS_GOTGCTL_BVALOEN_Pos   = 0x6      // Position of BVALOEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_BVALOEN_Msk   = 0x40     // Bit mask of BVALOEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_BVALOEN       = 0x40     // Bit BVALOEN.
	USB_OTG_FS_OTG_FS_GOTGCTL_BVALOVAL_Pos  = 0x7      // Position of BVALOVAL field.
	USB_OTG_FS_OTG_FS_GOTGCTL_BVALOVAL_Msk  = 0x80     // Bit mask of BVALOVAL field.
	USB_OTG_FS_OTG_FS_GOTGCTL_BVALOVAL      = 0x80     // Bit BVALOVAL.
	USB_OTG_FS_OTG_FS_GOTGCTL_EHEN_Pos      = 0xc      // Position of EHEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_EHEN_Msk      = 0x1000   // Bit mask of EHEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_EHEN          = 0x1000   // Bit EHEN.
	USB_OTG_FS_OTG_FS_GOTGCTL_OTGVER_Pos    = 0x14     // Position of OTGVER field.
	USB_OTG_FS_OTG_FS_GOTGCTL_OTGVER_Msk    = 0x100000 // Bit mask of OTGVER field.
	USB_OTG_FS_OTG_FS_GOTGCTL_OTGVER        = 0x100000 // Bit OTGVER.

	// OTG_FS_GOTGINT: OTG_FS interrupt register           (OTG_FS_GOTGINT)
	USB_OTG_FS_OTG_FS_GOTGINT_SEDET_Pos   = 0x2      // Position of SEDET field.
	USB_OTG_FS_OTG_FS_GOTGINT_SEDET_Msk   = 0x4      // Bit mask of SEDET field.
	USB_OTG_FS_OTG_FS_GOTGINT_SEDET       = 0x4      // Bit SEDET.
	USB_OTG_FS_OTG_FS_GOTGINT_SRSSCHG_Pos = 0x8      // Position of SRSSCHG field.
	USB_OTG_FS_OTG_FS_GOTGINT_SRSSCHG_Msk = 0x100    // Bit mask of SRSSCHG field.
	USB_OTG_FS_OTG_FS_GOTGINT_SRSSCHG     = 0x100    // Bit SRSSCHG.
	USB_OTG_FS_OTG_FS_GOTGINT_HNSSCHG_Pos = 0x9      // Position of HNSSCHG field.
	USB_OTG_FS_OTG_FS_GOTGINT_HNSSCHG_Msk = 0x200    // Bit mask of HNSSCHG field.
	USB_OTG_FS_OTG_FS_GOTGINT_HNSSCHG     = 0x200    // Bit HNSSCHG.
	USB_OTG_FS_OTG_FS_GOTGINT_HNGDET_Pos  = 0x11     // Position of HNGDET field.
	USB_OTG_FS_OTG_FS_GOTGINT_HNGDET_Msk  = 0x20000  // Bit mask of HNGDET field.
	USB_OTG_FS_OTG_FS_GOTGINT_HNGDET      = 0x20000  // Bit HNGDET.
	USB_OTG_FS_OTG_FS_GOTGINT_ADTOCHG_Pos = 0x12     // Position of ADTOCHG field.
	USB_OTG_FS_OTG_FS_GOTGINT_ADTOCHG_Msk = 0x40000  // Bit mask of ADTOCHG field.
	USB_OTG_FS_OTG_FS_GOTGINT_ADTOCHG     = 0x40000  // Bit ADTOCHG.
	USB_OTG_FS_OTG_FS_GOTGINT_DBCDNE_Pos  = 0x13     // Position of DBCDNE field.
	USB_OTG_FS_OTG_FS_GOTGINT_DBCDNE_Msk  = 0x80000  // Bit mask of DBCDNE field.
	USB_OTG_FS_OTG_FS_GOTGINT_DBCDNE      = 0x80000  // Bit DBCDNE.
	USB_OTG_FS_OTG_FS_GOTGINT_IDCHNG_Pos  = 0x14     // Position of IDCHNG field.
	USB_OTG_FS_OTG_FS_GOTGINT_IDCHNG_Msk  = 0x100000 // Bit mask of IDCHNG field.
	USB_OTG_FS_OTG_FS_GOTGINT_IDCHNG      = 0x100000 // Bit IDCHNG.

	// OTG_FS_GAHBCFG: OTG_FS AHB configuration register           (OTG_FS_GAHBCFG)
	USB_OTG_FS_OTG_FS_GAHBCFG_GINT_Pos     = 0x0   // Position of GINT field.
	USB_OTG_FS_OTG_FS_GAHBCFG_GINT_Msk     = 0x1   // Bit mask of GINT field.
	USB_OTG_FS_OTG_FS_GAHBCFG_GINT         = 0x1   // Bit GINT.
	USB_OTG_FS_OTG_FS_GAHBCFG_TXFELVL_Pos  = 0x7   // Position of TXFELVL field.
	USB_OTG_FS_OTG_FS_GAHBCFG_TXFELVL_Msk  = 0x80  // Bit mask of TXFELVL field.
	USB_OTG_FS_OTG_FS_GAHBCFG_TXFELVL      = 0x80  // Bit TXFELVL.
	USB_OTG_FS_OTG_FS_GAHBCFG_PTXFELVL_Pos = 0x8   // Position of PTXFELVL field.
	USB_OTG_FS_OTG_FS_GAHBCFG_PTXFELVL_Msk = 0x100 // Bit mask of PTXFELVL field.
	USB_OTG_FS_OTG_FS_GAHBCFG_PTXFELVL     = 0x100 // Bit PTXFELVL.

	// OTG_FS_GUSBCFG: OTG_FS USB configuration register           (OTG_FS_GUSBCFG)
	USB_OTG_FS_OTG_FS_GUSBCFG_TOCAL_Pos  = 0x0        // Position of TOCAL field.
	USB_OTG_FS_OTG_FS_GUSBCFG_TOCAL_Msk  = 0x7        // Bit mask of TOCAL field.
	USB_OTG_FS_OTG_FS_GUSBCFG_PHYSEL_Pos = 0x6        // Position of PHYSEL field.
	USB_OTG_FS_OTG_FS_GUSBCFG_PHYSEL_Msk = 0x40       // Bit mask of PHYSEL field.
	USB_OTG_FS_OTG_FS_GUSBCFG_PHYSEL     = 0x40       // Bit PHYSEL.
	USB_OTG_FS_OTG_FS_GUSBCFG_SRPCAP_Pos = 0x8        // Position of SRPCAP field.
	USB_OTG_FS_OTG_FS_GUSBCFG_SRPCAP_Msk = 0x100      // Bit mask of SRPCAP field.
	USB_OTG_FS_OTG_FS_GUSBCFG_SRPCAP     = 0x100      // Bit SRPCAP.
	USB_OTG_FS_OTG_FS_GUSBCFG_HNPCAP_Pos = 0x9        // Position of HNPCAP field.
	USB_OTG_FS_OTG_FS_GUSBCFG_HNPCAP_Msk = 0x200      // Bit mask of HNPCAP field.
	USB_OTG_FS_OTG_FS_GUSBCFG_HNPCAP     = 0x200      // Bit HNPCAP.
	USB_OTG_FS_OTG_FS_GUSBCFG_TRDT_Pos   = 0xa        // Position of TRDT field.
	USB_OTG_FS_OTG_FS_GUSBCFG_TRDT_Msk   = 0x3c00     // Bit mask of TRDT field.
	USB_OTG_FS_OTG_FS_GUSBCFG_FHMOD_Pos  = 0x1d       // Position of FHMOD field.
	USB_OTG_FS_OTG_FS_GUSBCFG_FHMOD_Msk  = 0x20000000 // Bit mask of FHMOD field.
	USB_OTG_FS_OTG_FS_GUSBCFG_FHMOD      = 0x20000000 // Bit FHMOD.
	USB_OTG_FS_OTG_FS_GUSBCFG_FDMOD_Pos  = 0x1e       // Position of FDMOD field.
	USB_OTG_FS_OTG_FS_GUSBCFG_FDMOD_Msk  = 0x40000000 // Bit mask of FDMOD field.
	USB_OTG_FS_OTG_FS_GUSBCFG_FDMOD      = 0x40000000 // Bit FDMOD.

	// OTG_FS_GRSTCTL: OTG_FS reset register           (OTG_FS_GRSTCTL)
	USB_OTG_FS_OTG_FS_GRSTCTL_CSRST_Pos   = 0x0        // Position of CSRST field.
	USB_OTG_FS_OTG_FS_GRSTCTL_CSRST_Msk   = 0x1        // Bit mask of CSRST field.
	USB_OTG_FS_OTG_FS_GRSTCTL_CSRST       = 0x1        // Bit CSRST.
	USB_OTG_FS_OTG_FS_GRSTCTL_HSRST_Pos   = 0x1        // Position of HSRST field.
	USB_OTG_FS_OTG_FS_GRSTCTL_HSRST_Msk   = 0x2        // Bit mask of HSRST field.
	USB_OTG_FS_OTG_FS_GRSTCTL_HSRST       = 0x2        // Bit HSRST.
	USB_OTG_FS_OTG_FS_GRSTCTL_FCRST_Pos   = 0x2        // Position of FCRST field.
	USB_OTG_FS_OTG_FS_GRSTCTL_FCRST_Msk   = 0x4        // Bit mask of FCRST field.
	USB_OTG_FS_OTG_FS_GRSTCTL_FCRST       = 0x4        // Bit FCRST.
	USB_OTG_FS_OTG_FS_GRSTCTL_RXFFLSH_Pos = 0x4        // Position of RXFFLSH field.
	USB_OTG_FS_OTG_FS_GRSTCTL_RXFFLSH_Msk = 0x10       // Bit mask of RXFFLSH field.
	USB_OTG_FS_OTG_FS_GRSTCTL_RXFFLSH     = 0x10       // Bit RXFFLSH.
	USB_OTG_FS_OTG_FS_GRSTCTL_TXFFLSH_Pos = 0x5        // Position of TXFFLSH field.
	USB_OTG_FS_OTG_FS_GRSTCTL_TXFFLSH_Msk = 0x20       // Bit mask of TXFFLSH field.
	USB_OTG_FS_OTG_FS_GRSTCTL_TXFFLSH     = 0x20       // Bit TXFFLSH.
	USB_OTG_FS_OTG_FS_GRSTCTL_TXFNUM_Pos  = 0x6        // Position of TXFNUM field.
	USB_OTG_FS_OTG_FS_GRSTCTL_TXFNUM_Msk  = 0x7c0      // Bit mask of TXFNUM field.
	USB_OTG_FS_OTG_FS_GRSTCTL_AHBIDL_Pos  = 0x1f       // Position of AHBIDL field.
	USB_OTG_FS_OTG_FS_GRSTCTL_AHBIDL_Msk  = 0x80000000 // Bit mask of AHBIDL field.
	USB_OTG_FS_OTG_FS_GRSTCTL_AHBIDL      = 0x80000000 // Bit AHBIDL.

	// OTG_FS_GINTSTS: OTG_FS core interrupt register           (OTG_FS_GINTSTS)
	USB_OTG_FS_OTG_FS_GINTSTS_CMOD_Pos               = 0x0        // Position of CMOD field.
	USB_OTG_FS_OTG_FS_GINTSTS_CMOD_Msk               = 0x1        // Bit mask of CMOD field.
	USB_OTG_FS_OTG_FS_GINTSTS_CMOD                   = 0x1        // Bit CMOD.
	USB_OTG_FS_OTG_FS_GINTSTS_MMIS_Pos               = 0x1        // Position of MMIS field.
	USB_OTG_FS_OTG_FS_GINTSTS_MMIS_Msk               = 0x2        // Bit mask of MMIS field.
	USB_OTG_FS_OTG_FS_GINTSTS_MMIS                   = 0x2        // Bit MMIS.
	USB_OTG_FS_OTG_FS_GINTSTS_OTGINT_Pos             = 0x2        // Position of OTGINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_OTGINT_Msk             = 0x4        // Bit mask of OTGINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_OTGINT                 = 0x4        // Bit OTGINT.
	USB_OTG_FS_OTG_FS_GINTSTS_SOF_Pos                = 0x3        // Position of SOF field.
	USB_OTG_FS_OTG_FS_GINTSTS_SOF_Msk                = 0x8        // Bit mask of SOF field.
	USB_OTG_FS_OTG_FS_GINTSTS_SOF                    = 0x8        // Bit SOF.
	USB_OTG_FS_OTG_FS_GINTSTS_RXFLVL_Pos             = 0x4        // Position of RXFLVL field.
	USB_OTG_FS_OTG_FS_GINTSTS_RXFLVL_Msk             = 0x10       // Bit mask of RXFLVL field.
	USB_OTG_FS_OTG_FS_GINTSTS_RXFLVL                 = 0x10       // Bit RXFLVL.
	USB_OTG_FS_OTG_FS_GINTSTS_NPTXFE_Pos             = 0x5        // Position of NPTXFE field.
	USB_OTG_FS_OTG_FS_GINTSTS_NPTXFE_Msk             = 0x20       // Bit mask of NPTXFE field.
	USB_OTG_FS_OTG_FS_GINTSTS_NPTXFE                 = 0x20       // Bit NPTXFE.
	USB_OTG_FS_OTG_FS_GINTSTS_GINAKEFF_Pos           = 0x6        // Position of GINAKEFF field.
	USB_OTG_FS_OTG_FS_GINTSTS_GINAKEFF_Msk           = 0x40       // Bit mask of GINAKEFF field.
	USB_OTG_FS_OTG_FS_GINTSTS_GINAKEFF               = 0x40       // Bit GINAKEFF.
	USB_OTG_FS_OTG_FS_GINTSTS_GOUTNAKEFF_Pos         = 0x7        // Position of GOUTNAKEFF field.
	USB_OTG_FS_OTG_FS_GINTSTS_GOUTNAKEFF_Msk         = 0x80       // Bit mask of GOUTNAKEFF field.
	USB_OTG_FS_OTG_FS_GINTSTS_GOUTNAKEFF             = 0x80       // Bit GOUTNAKEFF.
	USB_OTG_FS_OTG_FS_GINTSTS_ESUSP_Pos              = 0xa        // Position of ESUSP field.
	USB_OTG_FS_OTG_FS_GINTSTS_ESUSP_Msk              = 0x400      // Bit mask of ESUSP field.
	USB_OTG_FS_OTG_FS_GINTSTS_ESUSP                  = 0x400      // Bit ESUSP.
	USB_OTG_FS_OTG_FS_GINTSTS_USBSUSP_Pos            = 0xb        // Position of USBSUSP field.
	USB_OTG_FS_OTG_FS_GINTSTS_USBSUSP_Msk            = 0x800      // Bit mask of USBSUSP field.
	USB_OTG_FS_OTG_FS_GINTSTS_USBSUSP                = 0x800      // Bit USBSUSP.
	USB_OTG_FS_OTG_FS_GINTSTS_USBRST_Pos             = 0xc        // Position of USBRST field.
	USB_OTG_FS_OTG_FS_GINTSTS_USBRST_Msk             = 0x1000     // Bit mask of USBRST field.
	USB_OTG_FS_OTG_FS_GINTSTS_USBRST                 = 0x1000     // Bit USBRST.
	USB_OTG_FS_OTG_FS_GINTSTS_ENUMDNE_Pos            = 0xd        // Position of ENUMDNE field.
	USB_OTG_FS_OTG_FS_GINTSTS_ENUMDNE_Msk            = 0x2000     // Bit mask of ENUMDNE field.
	USB_OTG_FS_OTG_FS_GINTSTS_ENUMDNE                = 0x2000     // Bit ENUMDNE.
	USB_OTG_FS_OTG_FS_GINTSTS_ISOODRP_Pos            = 0xe        // Position of ISOODRP field.
	USB_OTG_FS_OTG_FS_GINTSTS_ISOODRP_Msk            = 0x4000     // Bit mask of ISOODRP field.
	USB_OTG_FS_OTG_FS_GINTSTS_ISOODRP                = 0x4000     // Bit ISOODRP.
	USB_OTG_FS_OTG_FS_GINTSTS_EOPF_Pos               = 0xf        // Position of EOPF field.
	USB_OTG_FS_OTG_FS_GINTSTS_EOPF_Msk               = 0x8000     // Bit mask of EOPF field.
	USB_OTG_FS_OTG_FS_GINTSTS_EOPF                   = 0x8000     // Bit EOPF.
	USB_OTG_FS_OTG_FS_GINTSTS_IEPINT_Pos             = 0x12       // Position of IEPINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_IEPINT_Msk             = 0x40000    // Bit mask of IEPINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_IEPINT                 = 0x40000    // Bit IEPINT.
	USB_OTG_FS_OTG_FS_GINTSTS_OEPINT_Pos             = 0x13       // Position of OEPINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_OEPINT_Msk             = 0x80000    // Bit mask of OEPINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_OEPINT                 = 0x80000    // Bit OEPINT.
	USB_OTG_FS_OTG_FS_GINTSTS_IISOIXFR_Pos           = 0x14       // Position of IISOIXFR field.
	USB_OTG_FS_OTG_FS_GINTSTS_IISOIXFR_Msk           = 0x100000   // Bit mask of IISOIXFR field.
	USB_OTG_FS_OTG_FS_GINTSTS_IISOIXFR               = 0x100000   // Bit IISOIXFR.
	USB_OTG_FS_OTG_FS_GINTSTS_IPXFR_INCOMPISOOUT_Pos = 0x15       // Position of IPXFR_INCOMPISOOUT field.
	USB_OTG_FS_OTG_FS_GINTSTS_IPXFR_INCOMPISOOUT_Msk = 0x200000   // Bit mask of IPXFR_INCOMPISOOUT field.
	USB_OTG_FS_OTG_FS_GINTSTS_IPXFR_INCOMPISOOUT     = 0x200000   // Bit IPXFR_INCOMPISOOUT.
	USB_OTG_FS_OTG_FS_GINTSTS_HPRTINT_Pos            = 0x18       // Position of HPRTINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_HPRTINT_Msk            = 0x1000000  // Bit mask of HPRTINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_HPRTINT                = 0x1000000  // Bit HPRTINT.
	USB_OTG_FS_OTG_FS_GINTSTS_HCINT_Pos              = 0x19       // Position of HCINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_HCINT_Msk              = 0x2000000  // Bit mask of HCINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_HCINT                  = 0x2000000  // Bit HCINT.
	USB_OTG_FS_OTG_FS_GINTSTS_PTXFE_Pos              = 0x1a       // Position of PTXFE field.
	USB_OTG_FS_OTG_FS_GINTSTS_PTXFE_Msk              = 0x4000000  // Bit mask of PTXFE field.
	USB_OTG_FS_OTG_FS_GINTSTS_PTXFE                  = 0x4000000  // Bit PTXFE.
	USB_OTG_FS_OTG_FS_GINTSTS_CIDSCHG_Pos            = 0x1c       // Position of CIDSCHG field.
	USB_OTG_FS_OTG_FS_GINTSTS_CIDSCHG_Msk            = 0x10000000 // Bit mask of CIDSCHG field.
	USB_OTG_FS_OTG_FS_GINTSTS_CIDSCHG                = 0x10000000 // Bit CIDSCHG.
	USB_OTG_FS_OTG_FS_GINTSTS_DISCINT_Pos            = 0x1d       // Position of DISCINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_DISCINT_Msk            = 0x20000000 // Bit mask of DISCINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_DISCINT                = 0x20000000 // Bit DISCINT.
	USB_OTG_FS_OTG_FS_GINTSTS_SRQINT_Pos             = 0x1e       // Position of SRQINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_SRQINT_Msk             = 0x40000000 // Bit mask of SRQINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_SRQINT                 = 0x40000000 // Bit SRQINT.
	USB_OTG_FS_OTG_FS_GINTSTS_WKUPINT_Pos            = 0x1f       // Position of WKUPINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_WKUPINT_Msk            = 0x80000000 // Bit mask of WKUPINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_WKUPINT                = 0x80000000 // Bit WKUPINT.
	USB_OTG_FS_OTG_FS_GINTSTS_RSTDET_Pos             = 0x17       // Position of RSTDET field.
	USB_OTG_FS_OTG_FS_GINTSTS_RSTDET_Msk             = 0x800000   // Bit mask of RSTDET field.
	USB_OTG_FS_OTG_FS_GINTSTS_RSTDET                 = 0x800000   // Bit RSTDET.

	// OTG_FS_GINTMSK: OTG_FS interrupt mask register           (OTG_FS_GINTMSK)
	USB_OTG_FS_OTG_FS_GINTMSK_MMISM_Pos            = 0x1        // Position of MMISM field.
	USB_OTG_FS_OTG_FS_GINTMSK_MMISM_Msk            = 0x2        // Bit mask of MMISM field.
	USB_OTG_FS_OTG_FS_GINTMSK_MMISM                = 0x2        // Bit MMISM.
	USB_OTG_FS_OTG_FS_GINTMSK_OTGINT_Pos           = 0x2        // Position of OTGINT field.
	USB_OTG_FS_OTG_FS_GINTMSK_OTGINT_Msk           = 0x4        // Bit mask of OTGINT field.
	USB_OTG_FS_OTG_FS_GINTMSK_OTGINT               = 0x4        // Bit OTGINT.
	USB_OTG_FS_OTG_FS_GINTMSK_SOFM_Pos             = 0x3        // Position of SOFM field.
	USB_OTG_FS_OTG_FS_GINTMSK_SOFM_Msk             = 0x8        // Bit mask of SOFM field.
	USB_OTG_FS_OTG_FS_GINTMSK_SOFM                 = 0x8        // Bit SOFM.
	USB_OTG_FS_OTG_FS_GINTMSK_RXFLVLM_Pos          = 0x4        // Position of RXFLVLM field.
	USB_OTG_FS_OTG_FS_GINTMSK_RXFLVLM_Msk          = 0x10       // Bit mask of RXFLVLM field.
	USB_OTG_FS_OTG_FS_GINTMSK_RXFLVLM              = 0x10       // Bit RXFLVLM.
	USB_OTG_FS_OTG_FS_GINTMSK_NPTXFEM_Pos          = 0x5        // Position of NPTXFEM field.
	USB_OTG_FS_OTG_FS_GINTMSK_NPTXFEM_Msk          = 0x20       // Bit mask of NPTXFEM field.
	USB_OTG_FS_OTG_FS_GINTMSK_NPTXFEM              = 0x20       // Bit NPTXFEM.
	USB_OTG_FS_OTG_FS_GINTMSK_GINAKEFFM_Pos        = 0x6        // Position of GINAKEFFM field.
	USB_OTG_FS_OTG_FS_GINTMSK_GINAKEFFM_Msk        = 0x40       // Bit mask of GINAKEFFM field.
	USB_OTG_FS_OTG_FS_GINTMSK_GINAKEFFM            = 0x40       // Bit GINAKEFFM.
	USB_OTG_FS_OTG_FS_GINTMSK_GONAKEFFM_Pos        = 0x7        // Position of GONAKEFFM field.
	USB_OTG_FS_OTG_FS_GINTMSK_GONAKEFFM_Msk        = 0x80       // Bit mask of GONAKEFFM field.
	USB_OTG_FS_OTG_FS_GINTMSK_GONAKEFFM            = 0x80       // Bit GONAKEFFM.
	USB_OTG_FS_OTG_FS_GINTMSK_ESUSPM_Pos           = 0xa        // Position of ESUSPM field.
	USB_OTG_FS_OTG_FS_GINTMSK_ESUSPM_Msk           = 0x400      // Bit mask of ESUSPM field.
	USB_OTG_FS_OTG_FS_GINTMSK_ESUSPM               = 0x400      // Bit ESUSPM.
	USB_OTG_FS_OTG_FS_GINTMSK_USBSUSPM_Pos         = 0xb        // Position of USBSUSPM field.
	USB_OTG_FS_OTG_FS_GINTMSK_USBSUSPM_Msk         = 0x800      // Bit mask of USBSUSPM field.
	USB_OTG_FS_OTG_FS_GINTMSK_USBSUSPM             = 0x800      // Bit USBSUSPM.
	USB_OTG_FS_OTG_FS_GINTMSK_USBRST_Pos           = 0xc        // Position of USBRST field.
	USB_OTG_FS_OTG_FS_GINTMSK_USBRST_Msk           = 0x1000     // Bit mask of USBRST field.
	USB_OTG_FS_OTG_FS_GINTMSK_USBRST               = 0x1000     // Bit USBRST.
	USB_OTG_FS_OTG_FS_GINTMSK_ENUMDNEM_Pos         = 0xd        // Position of ENUMDNEM field.
	USB_OTG_FS_OTG_FS_GINTMSK_ENUMDNEM_Msk         = 0x2000     // Bit mask of ENUMDNEM field.
	USB_OTG_FS_OTG_FS_GINTMSK_ENUMDNEM             = 0x2000     // Bit ENUMDNEM.
	USB_OTG_FS_OTG_FS_GINTMSK_ISOODRPM_Pos         = 0xe        // Position of ISOODRPM field.
	USB_OTG_FS_OTG_FS_GINTMSK_ISOODRPM_Msk         = 0x4000     // Bit mask of ISOODRPM field.
	USB_OTG_FS_OTG_FS_GINTMSK_ISOODRPM             = 0x4000     // Bit ISOODRPM.
	USB_OTG_FS_OTG_FS_GINTMSK_EOPFM_Pos            = 0xf        // Position of EOPFM field.
	USB_OTG_FS_OTG_FS_GINTMSK_EOPFM_Msk            = 0x8000     // Bit mask of EOPFM field.
	USB_OTG_FS_OTG_FS_GINTMSK_EOPFM                = 0x8000     // Bit EOPFM.
	USB_OTG_FS_OTG_FS_GINTMSK_IEPINT_Pos           = 0x12       // Position of IEPINT field.
	USB_OTG_FS_OTG_FS_GINTMSK_IEPINT_Msk           = 0x40000    // Bit mask of IEPINT field.
	USB_OTG_FS_OTG_FS_GINTMSK_IEPINT               = 0x40000    // Bit IEPINT.
	USB_OTG_FS_OTG_FS_GINTMSK_OEPINT_Pos           = 0x13       // Position of OEPINT field.
	USB_OTG_FS_OTG_FS_GINTMSK_OEPINT_Msk           = 0x80000    // Bit mask of OEPINT field.
	USB_OTG_FS_OTG_FS_GINTMSK_OEPINT               = 0x80000    // Bit OEPINT.
	USB_OTG_FS_OTG_FS_GINTMSK_IISOIXFRM_Pos        = 0x14       // Position of IISOIXFRM field.
	USB_OTG_FS_OTG_FS_GINTMSK_IISOIXFRM_Msk        = 0x100000   // Bit mask of IISOIXFRM field.
	USB_OTG_FS_OTG_FS_GINTMSK_IISOIXFRM            = 0x100000   // Bit IISOIXFRM.
	USB_OTG_FS_OTG_FS_GINTMSK_IPXFRM_IISOOXFRM_Pos = 0x15       // Position of IPXFRM_IISOOXFRM field.
	USB_OTG_FS_OTG_FS_GINTMSK_IPXFRM_IISOOXFRM_Msk = 0x200000   // Bit mask of IPXFRM_IISOOXFRM field.
	USB_OTG_FS_OTG_FS_GINTMSK_IPXFRM_IISOOXFRM     = 0x200000   // Bit IPXFRM_IISOOXFRM.
	USB_OTG_FS_OTG_FS_GINTMSK_PRTIM_Pos            = 0x18       // Position of PRTIM field.
	USB_OTG_FS_OTG_FS_GINTMSK_PRTIM_Msk            = 0x1000000  // Bit mask of PRTIM field.
	USB_OTG_FS_OTG_FS_GINTMSK_PRTIM                = 0x1000000  // Bit PRTIM.
	USB_OTG_FS_OTG_FS_GINTMSK_HCIM_Pos             = 0x19       // Position of HCIM field.
	USB_OTG_FS_OTG_FS_GINTMSK_HCIM_Msk             = 0x2000000  // Bit mask of HCIM field.
	USB_OTG_FS_OTG_FS_GINTMSK_HCIM                 = 0x2000000  // Bit HCIM.
	USB_OTG_FS_OTG_FS_GINTMSK_PTXFEM_Pos           = 0x1a       // Position of PTXFEM field.
	USB_OTG_FS_OTG_FS_GINTMSK_PTXFEM_Msk           = 0x4000000  // Bit mask of PTXFEM field.
	USB_OTG_FS_OTG_FS_GINTMSK_PTXFEM               = 0x4000000  // Bit PTXFEM.
	USB_OTG_FS_OTG_FS_GINTMSK_CIDSCHGM_Pos         = 0x1c       // Position of CIDSCHGM field.
	USB_OTG_FS_OTG_FS_GINTMSK_CIDSCHGM_Msk         = 0x10000000 // Bit mask of CIDSCHGM field.
	USB_OTG_FS_OTG_FS_GINTMSK_CIDSCHGM             = 0x10000000 // Bit CIDSCHGM.
	USB_OTG_FS_OTG_FS_GINTMSK_DISCINT_Pos          = 0x1d       // Position of DISCINT field.
	USB_OTG_FS_OTG_FS_GINTMSK_DISCINT_Msk          = 0x20000000 // Bit mask of DISCINT field.
	USB_OTG_FS_OTG_FS_GINTMSK_DISCINT              = 0x20000000 // Bit DISCINT.
	USB_OTG_FS_OTG_FS_GINTMSK_SRQIM_Pos            = 0x1e       // Position of SRQIM field.
	USB_OTG_FS_OTG_FS_GINTMSK_SRQIM_Msk            = 0x40000000 // Bit mask of SRQIM field.
	USB_OTG_FS_OTG_FS_GINTMSK_SRQIM                = 0x40000000 // Bit SRQIM.
	USB_OTG_FS_OTG_FS_GINTMSK_WUIM_Pos             = 0x1f       // Position of WUIM field.
	USB_OTG_FS_OTG_FS_GINTMSK_WUIM_Msk             = 0x80000000 // Bit mask of WUIM field.
	USB_OTG_FS_OTG_FS_GINTMSK_WUIM                 = 0x80000000 // Bit WUIM.
	USB_OTG_FS_OTG_FS_GINTMSK_RSTDETM_Pos          = 0x17       // Position of RSTDETM field.
	USB_OTG_FS_OTG_FS_GINTMSK_RSTDETM_Msk          = 0x800000   // Bit mask of RSTDETM field.
	USB_OTG_FS_OTG_FS_GINTMSK_RSTDETM              = 0x800000   // Bit RSTDETM.
	USB_OTG_FS_OTG_FS_GINTMSK_LPMIN_Pos            = 0x1b       // Position of LPMIN field.
	USB_OTG_FS_OTG_FS_GINTMSK_LPMIN_Msk            = 0x8000000  // Bit mask of LPMIN field.
	USB_OTG_FS_OTG_FS_GINTMSK_LPMIN                = 0x8000000  // Bit LPMIN.

	// OTG_FS_GRXSTSR_Device: OTG_FS Receive status debug read(Device           mode)
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_EPNUM_Pos  = 0x0       // Position of EPNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_EPNUM_Msk  = 0xf       // Bit mask of EPNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_BCNT_Pos   = 0x4       // Position of BCNT field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_BCNT_Msk   = 0x7ff0    // Bit mask of BCNT field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_DPID_Pos   = 0xf       // Position of DPID field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_DPID_Msk   = 0x18000   // Bit mask of DPID field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_PKTSTS_Pos = 0x11      // Position of PKTSTS field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_PKTSTS_Msk = 0x1e0000  // Bit mask of PKTSTS field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_FRMNUM_Pos = 0x15      // Position of FRMNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_FRMNUM_Msk = 0x1e00000 // Bit mask of FRMNUM field.

	// OTG_FS_GRXSTSR_Host: OTG_FS Receive status debug read(Host           mode)
	USB_OTG_FS_OTG_FS_GRXSTSR_Host_CHNUM_Pos  = 0x0      // Position of CHNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Host_CHNUM_Msk  = 0xf      // Bit mask of CHNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Host_BCNT_Pos   = 0x4      // Position of BCNT field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Host_BCNT_Msk   = 0x7ff0   // Bit mask of BCNT field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Host_DPID_Pos   = 0xf      // Position of DPID field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Host_DPID_Msk   = 0x18000  // Bit mask of DPID field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Host_PKTSTS_Pos = 0x11     // Position of PKTSTS field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Host_PKTSTS_Msk = 0x1e0000 // Bit mask of PKTSTS field.

	// OTG_FS_GRXSTSP_Device: OTG status read and pop register (Device           mode)
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_EPNUM_Pos  = 0x0       // Position of EPNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_EPNUM_Msk  = 0xf       // Bit mask of EPNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_BCNT_Pos   = 0x4       // Position of BCNT field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_BCNT_Msk   = 0x7ff0    // Bit mask of BCNT field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_DPID_Pos   = 0xf       // Position of DPID field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_DPID_Msk   = 0x18000   // Bit mask of DPID field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_PKTSTS_Pos = 0x11      // Position of PKTSTS field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_PKTSTS_Msk = 0x1e0000  // Bit mask of PKTSTS field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_FRMNUM_Pos = 0x15      // Position of FRMNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_FRMNUM_Msk = 0x1e00000 // Bit mask of FRMNUM field.

	// OTG_FS_GRXSTSP_Host: OTG status read and pop register (Host           mode)
	USB_OTG_FS_OTG_FS_GRXSTSP_Host_CHNUM_Pos  = 0x0      // Position of CHNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Host_CHNUM_Msk  = 0xf      // Bit mask of CHNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Host_BCNT_Pos   = 0x4      // Position of BCNT field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Host_BCNT_Msk   = 0x7ff0   // Bit mask of BCNT field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Host_DPID_Pos   = 0xf      // Position of DPID field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Host_DPID_Msk   = 0x18000  // Bit mask of DPID field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Host_PKTSTS_Pos = 0x11     // Position of PKTSTS field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Host_PKTSTS_Msk = 0x1e0000 // Bit mask of PKTSTS field.

	// OTG_FS_GRXFSIZ: OTG_FS Receive FIFO size register           (OTG_FS_GRXFSIZ)
	USB_OTG_FS_OTG_FS_GRXFSIZ_RXFD_Pos = 0x0    // Position of RXFD field.
	USB_OTG_FS_OTG_FS_GRXFSIZ_RXFD_Msk = 0xffff // Bit mask of RXFD field.

	// OTG_FS_DIEPTXF0_Device: OTG_FS Endpoint 0 Transmit FIFO           size
	USB_OTG_FS_OTG_FS_DIEPTXF0_Device_TX0FSA_Pos = 0x0        // Position of TX0FSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF0_Device_TX0FSA_Msk = 0xffff     // Bit mask of TX0FSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF0_Device_TX0FD_Pos  = 0x10       // Position of TX0FD field.
	USB_OTG_FS_OTG_FS_DIEPTXF0_Device_TX0FD_Msk  = 0xffff0000 // Bit mask of TX0FD field.

	// OTG_FS_HNPTXFSIZ_Host: OTG_FS Host non-periodic transmit FIFO size           register
	USB_OTG_FS_OTG_FS_HNPTXFSIZ_Host_NPTXFSA_Pos = 0x0        // Position of NPTXFSA field.
	USB_OTG_FS_OTG_FS_HNPTXFSIZ_Host_NPTXFSA_Msk = 0xffff     // Bit mask of NPTXFSA field.
	USB_OTG_FS_OTG_FS_HNPTXFSIZ_Host_NPTXFD_Pos  = 0x10       // Position of NPTXFD field.
	USB_OTG_FS_OTG_FS_HNPTXFSIZ_Host_NPTXFD_Msk  = 0xffff0000 // Bit mask of NPTXFD field.

	// OTG_FS_HNPTXSTS: OTG_FS non-periodic transmit FIFO/queue           status register (OTG_FS_GNPTXSTS)
	USB_OTG_FS_OTG_FS_HNPTXSTS_NPTXFSAV_Pos = 0x0        // Position of NPTXFSAV field.
	USB_OTG_FS_OTG_FS_HNPTXSTS_NPTXFSAV_Msk = 0xffff     // Bit mask of NPTXFSAV field.
	USB_OTG_FS_OTG_FS_HNPTXSTS_NPTQXSAV_Pos = 0x10       // Position of NPTQXSAV field.
	USB_OTG_FS_OTG_FS_HNPTXSTS_NPTQXSAV_Msk = 0xff0000   // Bit mask of NPTQXSAV field.
	USB_OTG_FS_OTG_FS_HNPTXSTS_NPTXQTOP_Pos = 0x18       // Position of NPTXQTOP field.
	USB_OTG_FS_OTG_FS_HNPTXSTS_NPTXQTOP_Msk = 0x7f000000 // Bit mask of NPTXQTOP field.

	// OTG_FS_GI2CCTL: OTG I2C access register
	USB_OTG_FS_OTG_FS_GI2CCTL_RWDATA_Pos    = 0x0        // Position of RWDATA field.
	USB_OTG_FS_OTG_FS_GI2CCTL_RWDATA_Msk    = 0xff       // Bit mask of RWDATA field.
	USB_OTG_FS_OTG_FS_GI2CCTL_REGADDR_Pos   = 0x8        // Position of REGADDR field.
	USB_OTG_FS_OTG_FS_GI2CCTL_REGADDR_Msk   = 0xff00     // Bit mask of REGADDR field.
	USB_OTG_FS_OTG_FS_GI2CCTL_ADDR_Pos      = 0x10       // Position of ADDR field.
	USB_OTG_FS_OTG_FS_GI2CCTL_ADDR_Msk      = 0x7f0000   // Bit mask of ADDR field.
	USB_OTG_FS_OTG_FS_GI2CCTL_I2CEN_Pos     = 0x17       // Position of I2CEN field.
	USB_OTG_FS_OTG_FS_GI2CCTL_I2CEN_Msk     = 0x800000   // Bit mask of I2CEN field.
	USB_OTG_FS_OTG_FS_GI2CCTL_I2CEN         = 0x800000   // Bit I2CEN.
	USB_OTG_FS_OTG_FS_GI2CCTL_ACK_Pos       = 0x18       // Position of ACK field.
	USB_OTG_FS_OTG_FS_GI2CCTL_ACK_Msk       = 0x1000000  // Bit mask of ACK field.
	USB_OTG_FS_OTG_FS_GI2CCTL_ACK           = 0x1000000  // Bit ACK.
	USB_OTG_FS_OTG_FS_GI2CCTL_I2CDEVADR_Pos = 0x1a       // Position of I2CDEVADR field.
	USB_OTG_FS_OTG_FS_GI2CCTL_I2CDEVADR_Msk = 0xc000000  // Bit mask of I2CDEVADR field.
	USB_OTG_FS_OTG_FS_GI2CCTL_I2CDATSE0_Pos = 0x1c       // Position of I2CDATSE0 field.
	USB_OTG_FS_OTG_FS_GI2CCTL_I2CDATSE0_Msk = 0x10000000 // Bit mask of I2CDATSE0 field.
	USB_OTG_FS_OTG_FS_GI2CCTL_I2CDATSE0     = 0x10000000 // Bit I2CDATSE0.
	USB_OTG_FS_OTG_FS_GI2CCTL_RW_Pos        = 0x1e       // Position of RW field.
	USB_OTG_FS_OTG_FS_GI2CCTL_RW_Msk        = 0x40000000 // Bit mask of RW field.
	USB_OTG_FS_OTG_FS_GI2CCTL_RW            = 0x40000000 // Bit RW.
	USB_OTG_FS_OTG_FS_GI2CCTL_BSYDNE_Pos    = 0x1f       // Position of BSYDNE field.
	USB_OTG_FS_OTG_FS_GI2CCTL_BSYDNE_Msk    = 0x80000000 // Bit mask of BSYDNE field.
	USB_OTG_FS_OTG_FS_GI2CCTL_BSYDNE        = 0x80000000 // Bit BSYDNE.

	// OTG_FS_GCCFG: OTG_FS general core configuration register           (OTG_FS_GCCFG)
	USB_OTG_FS_OTG_FS_GCCFG_PWRDWN_Pos = 0x10     // Position of PWRDWN field.
	USB_OTG_FS_OTG_FS_GCCFG_PWRDWN_Msk = 0x10000  // Bit mask of PWRDWN field.
	USB_OTG_FS_OTG_FS_GCCFG_PWRDWN     = 0x10000  // Bit PWRDWN.
	USB_OTG_FS_OTG_FS_GCCFG_BCDEN_Pos  = 0x11     // Position of BCDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_BCDEN_Msk  = 0x20000  // Bit mask of BCDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_BCDEN      = 0x20000  // Bit BCDEN.
	USB_OTG_FS_OTG_FS_GCCFG_DCDEN_Pos  = 0x12     // Position of DCDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_DCDEN_Msk  = 0x40000  // Bit mask of DCDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_DCDEN      = 0x40000  // Bit DCDEN.
	USB_OTG_FS_OTG_FS_GCCFG_PDEN_Pos   = 0x13     // Position of PDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_PDEN_Msk   = 0x80000  // Bit mask of PDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_PDEN       = 0x80000  // Bit PDEN.
	USB_OTG_FS_OTG_FS_GCCFG_SDEN_Pos   = 0x14     // Position of SDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_SDEN_Msk   = 0x100000 // Bit mask of SDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_SDEN       = 0x100000 // Bit SDEN.
	USB_OTG_FS_OTG_FS_GCCFG_VBDEN_Pos  = 0x15     // Position of VBDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_VBDEN_Msk  = 0x200000 // Bit mask of VBDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_VBDEN      = 0x200000 // Bit VBDEN.
	USB_OTG_FS_OTG_FS_GCCFG_DCDET_Pos  = 0x0      // Position of DCDET field.
	USB_OTG_FS_OTG_FS_GCCFG_DCDET_Msk  = 0x1      // Bit mask of DCDET field.
	USB_OTG_FS_OTG_FS_GCCFG_DCDET      = 0x1      // Bit DCDET.
	USB_OTG_FS_OTG_FS_GCCFG_PDET_Pos   = 0x1      // Position of PDET field.
	USB_OTG_FS_OTG_FS_GCCFG_PDET_Msk   = 0x2      // Bit mask of PDET field.
	USB_OTG_FS_OTG_FS_GCCFG_PDET       = 0x2      // Bit PDET.
	USB_OTG_FS_OTG_FS_GCCFG_SDET_Pos   = 0x2      // Position of SDET field.
	USB_OTG_FS_OTG_FS_GCCFG_SDET_Msk   = 0x4      // Bit mask of SDET field.
	USB_OTG_FS_OTG_FS_GCCFG_SDET       = 0x4      // Bit SDET.
	USB_OTG_FS_OTG_FS_GCCFG_PS2DET_Pos = 0x3      // Position of PS2DET field.
	USB_OTG_FS_OTG_FS_GCCFG_PS2DET_Msk = 0x8      // Bit mask of PS2DET field.
	USB_OTG_FS_OTG_FS_GCCFG_PS2DET     = 0x8      // Bit PS2DET.

	// OTG_FS_CID: core ID register
	USB_OTG_FS_OTG_FS_CID_PRODUCT_ID_Pos = 0x0        // Position of PRODUCT_ID field.
	USB_OTG_FS_OTG_FS_CID_PRODUCT_ID_Msk = 0xffffffff // Bit mask of PRODUCT_ID field.

	// OTG_FS_GLPMCFG: OTG core LPM configuration           register
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMEN_Pos      = 0x0        // Position of LPMEN field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMEN_Msk      = 0x1        // Bit mask of LPMEN field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMEN          = 0x1        // Bit LPMEN.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMACK_Pos     = 0x1        // Position of LPMACK field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMACK_Msk     = 0x2        // Bit mask of LPMACK field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMACK         = 0x2        // Bit LPMACK.
	USB_OTG_FS_OTG_FS_GLPMCFG_BESL_Pos       = 0x2        // Position of BESL field.
	USB_OTG_FS_OTG_FS_GLPMCFG_BESL_Msk       = 0x3c       // Bit mask of BESL field.
	USB_OTG_FS_OTG_FS_GLPMCFG_REMWAKE_Pos    = 0x6        // Position of REMWAKE field.
	USB_OTG_FS_OTG_FS_GLPMCFG_REMWAKE_Msk    = 0x40       // Bit mask of REMWAKE field.
	USB_OTG_FS_OTG_FS_GLPMCFG_REMWAKE        = 0x40       // Bit REMWAKE.
	USB_OTG_FS_OTG_FS_GLPMCFG_L1SSEN_Pos     = 0x7        // Position of L1SSEN field.
	USB_OTG_FS_OTG_FS_GLPMCFG_L1SSEN_Msk     = 0x80       // Bit mask of L1SSEN field.
	USB_OTG_FS_OTG_FS_GLPMCFG_L1SSEN         = 0x80       // Bit L1SSEN.
	USB_OTG_FS_OTG_FS_GLPMCFG_BESLTHRS_Pos   = 0x8        // Position of BESLTHRS field.
	USB_OTG_FS_OTG_FS_GLPMCFG_BESLTHRS_Msk   = 0xf00      // Bit mask of BESLTHRS field.
	USB_OTG_FS_OTG_FS_GLPMCFG_L1DSEN_Pos     = 0xc        // Position of L1DSEN field.
	USB_OTG_FS_OTG_FS_GLPMCFG_L1DSEN_Msk     = 0x1000     // Bit mask of L1DSEN field.
	USB_OTG_FS_OTG_FS_GLPMCFG_L1DSEN         = 0x1000     // Bit L1DSEN.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMRST_Pos     = 0xd        // Position of LPMRST field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMRST_Msk     = 0x6000     // Bit mask of LPMRST field.
	USB_OTG_FS_OTG_FS_GLPMCFG_SLPSTS_Pos     = 0xf        // Position of SLPSTS field.
	USB_OTG_FS_OTG_FS_GLPMCFG_SLPSTS_Msk     = 0x8000     // Bit mask of SLPSTS field.
	USB_OTG_FS_OTG_FS_GLPMCFG_SLPSTS         = 0x8000     // Bit SLPSTS.
	USB_OTG_FS_OTG_FS_GLPMCFG_L1RSMOK_Pos    = 0x10       // Position of L1RSMOK field.
	USB_OTG_FS_OTG_FS_GLPMCFG_L1RSMOK_Msk    = 0x10000    // Bit mask of L1RSMOK field.
	USB_OTG_FS_OTG_FS_GLPMCFG_L1RSMOK        = 0x10000    // Bit L1RSMOK.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMCHIDX_Pos   = 0x11       // Position of LPMCHIDX field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMCHIDX_Msk   = 0x1e0000   // Bit mask of LPMCHIDX field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMRCNT_Pos    = 0x15       // Position of LPMRCNT field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMRCNT_Msk    = 0xe00000   // Bit mask of LPMRCNT field.
	USB_OTG_FS_OTG_FS_GLPMCFG_SNDLPM_Pos     = 0x18       // Position of SNDLPM field.
	USB_OTG_FS_OTG_FS_GLPMCFG_SNDLPM_Msk     = 0x1000000  // Bit mask of SNDLPM field.
	USB_OTG_FS_OTG_FS_GLPMCFG_SNDLPM         = 0x1000000  // Bit SNDLPM.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMRCNTSTS_Pos = 0x19       // Position of LPMRCNTSTS field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMRCNTSTS_Msk = 0xe000000  // Bit mask of LPMRCNTSTS field.
	USB_OTG_FS_OTG_FS_GLPMCFG_ENBESL_Pos     = 0x1c       // Position of ENBESL field.
	USB_OTG_FS_OTG_FS_GLPMCFG_ENBESL_Msk     = 0x10000000 // Bit mask of ENBESL field.
	USB_OTG_FS_OTG_FS_GLPMCFG_ENBESL         = 0x10000000 // Bit ENBESL.

	// OTG_FS_GPWRDN: OTG power down register
	USB_OTG_FS_OTG_FS_GPWRDN_ADPMEN_Pos = 0x0      // Position of ADPMEN field.
	USB_OTG_FS_OTG_FS_GPWRDN_ADPMEN_Msk = 0x1      // Bit mask of ADPMEN field.
	USB_OTG_FS_OTG_FS_GPWRDN_ADPMEN     = 0x1      // Bit ADPMEN.
	USB_OTG_FS_OTG_FS_GPWRDN_ADPIF_Pos  = 0x17     // Position of ADPIF field.
	USB_OTG_FS_OTG_FS_GPWRDN_ADPIF_Msk  = 0x800000 // Bit mask of ADPIF field.
	USB_OTG_FS_OTG_FS_GPWRDN_ADPIF      = 0x800000 // Bit ADPIF.

	// OTG_FS_GADPCTL: OTG ADP timer, control and status           register
	USB_OTG_FS_OTG_FS_GADPCTL_PRBDSCHG_Pos = 0x0        // Position of PRBDSCHG field.
	USB_OTG_FS_OTG_FS_GADPCTL_PRBDSCHG_Msk = 0x3        // Bit mask of PRBDSCHG field.
	USB_OTG_FS_OTG_FS_GADPCTL_PRBDELTA_Pos = 0x2        // Position of PRBDELTA field.
	USB_OTG_FS_OTG_FS_GADPCTL_PRBDELTA_Msk = 0xc        // Bit mask of PRBDELTA field.
	USB_OTG_FS_OTG_FS_GADPCTL_PRBPER_Pos   = 0x4        // Position of PRBPER field.
	USB_OTG_FS_OTG_FS_GADPCTL_PRBPER_Msk   = 0x30       // Bit mask of PRBPER field.
	USB_OTG_FS_OTG_FS_GADPCTL_RTIM_Pos     = 0x6        // Position of RTIM field.
	USB_OTG_FS_OTG_FS_GADPCTL_RTIM_Msk     = 0x1ffc0    // Bit mask of RTIM field.
	USB_OTG_FS_OTG_FS_GADPCTL_ENAPRB_Pos   = 0x11       // Position of ENAPRB field.
	USB_OTG_FS_OTG_FS_GADPCTL_ENAPRB_Msk   = 0x20000    // Bit mask of ENAPRB field.
	USB_OTG_FS_OTG_FS_GADPCTL_ENAPRB       = 0x20000    // Bit ENAPRB.
	USB_OTG_FS_OTG_FS_GADPCTL_ENASNS_Pos   = 0x12       // Position of ENASNS field.
	USB_OTG_FS_OTG_FS_GADPCTL_ENASNS_Msk   = 0x40000    // Bit mask of ENASNS field.
	USB_OTG_FS_OTG_FS_GADPCTL_ENASNS       = 0x40000    // Bit ENASNS.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPRST_Pos   = 0x13       // Position of ADPRST field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPRST_Msk   = 0x80000    // Bit mask of ADPRST field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPRST       = 0x80000    // Bit ADPRST.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPEN_Pos    = 0x14       // Position of ADPEN field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPEN_Msk    = 0x100000   // Bit mask of ADPEN field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPEN        = 0x100000   // Bit ADPEN.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPPRBIF_Pos = 0x15       // Position of ADPPRBIF field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPPRBIF_Msk = 0x200000   // Bit mask of ADPPRBIF field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPPRBIF     = 0x200000   // Bit ADPPRBIF.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPSNSIF_Pos = 0x16       // Position of ADPSNSIF field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPSNSIF_Msk = 0x400000   // Bit mask of ADPSNSIF field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPSNSIF     = 0x400000   // Bit ADPSNSIF.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPTOIF_Pos  = 0x17       // Position of ADPTOIF field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPTOIF_Msk  = 0x800000   // Bit mask of ADPTOIF field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPTOIF      = 0x800000   // Bit ADPTOIF.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPPRBIM_Pos = 0x18       // Position of ADPPRBIM field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPPRBIM_Msk = 0x1000000  // Bit mask of ADPPRBIM field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPPRBIM     = 0x1000000  // Bit ADPPRBIM.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPSNSIM_Pos = 0x19       // Position of ADPSNSIM field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPSNSIM_Msk = 0x2000000  // Bit mask of ADPSNSIM field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPSNSIM     = 0x2000000  // Bit ADPSNSIM.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPTOIM_Pos  = 0x1a       // Position of ADPTOIM field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPTOIM_Msk  = 0x4000000  // Bit mask of ADPTOIM field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPTOIM      = 0x4000000  // Bit ADPTOIM.
	USB_OTG_FS_OTG_FS_GADPCTL_AR_Pos       = 0x1b       // Position of AR field.
	USB_OTG_FS_OTG_FS_GADPCTL_AR_Msk       = 0x18000000 // Bit mask of AR field.

	// OTG_FS_HPTXFSIZ: OTG_FS Host periodic transmit FIFO size           register (OTG_FS_HPTXFSIZ)
	USB_OTG_FS_OTG_FS_HPTXFSIZ_PTXSA_Pos   = 0x0        // Position of PTXSA field.
	USB_OTG_FS_OTG_FS_HPTXFSIZ_PTXSA_Msk   = 0xffff     // Bit mask of PTXSA field.
	USB_OTG_FS_OTG_FS_HPTXFSIZ_PTXFSIZ_Pos = 0x10       // Position of PTXFSIZ field.
	USB_OTG_FS_OTG_FS_HPTXFSIZ_PTXFSIZ_Msk = 0xffff0000 // Bit mask of PTXFSIZ field.

	// OTG_FS_DIEPTXF1: OTG_FS device IN endpoint transmit FIFO size           register (OTG_FS_DIEPTXF1)
	USB_OTG_FS_OTG_FS_DIEPTXF1_INEPTXSA_Pos = 0x0        // Position of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF1_INEPTXSA_Msk = 0xffff     // Bit mask of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF1_INEPTXFD_Pos = 0x10       // Position of INEPTXFD field.
	USB_OTG_FS_OTG_FS_DIEPTXF1_INEPTXFD_Msk = 0xffff0000 // Bit mask of INEPTXFD field.

	// OTG_FS_DIEPTXF2: OTG_FS device IN endpoint transmit FIFO size           register (OTG_FS_DIEPTXF2)
	USB_OTG_FS_OTG_FS_DIEPTXF2_INEPTXSA_Pos = 0x0        // Position of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF2_INEPTXSA_Msk = 0xffff     // Bit mask of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF2_INEPTXFD_Pos = 0x10       // Position of INEPTXFD field.
	USB_OTG_FS_OTG_FS_DIEPTXF2_INEPTXFD_Msk = 0xffff0000 // Bit mask of INEPTXFD field.

	// OTG_FS_DIEPTXF3: OTG_FS device IN endpoint transmit FIFO size           register (OTG_FS_DIEPTXF3)
	USB_OTG_FS_OTG_FS_DIEPTXF3_INEPTXSA_Pos = 0x0        // Position of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF3_INEPTXSA_Msk = 0xffff     // Bit mask of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF3_INEPTXFD_Pos = 0x10       // Position of INEPTXFD field.
	USB_OTG_FS_OTG_FS_DIEPTXF3_INEPTXFD_Msk = 0xffff0000 // Bit mask of INEPTXFD field.

	// OTG_FS_DIEPTXF4: OTG_FS device IN endpoint transmit FIFO size           register (OTG_FS_DIEPTXF4)
	USB_OTG_FS_OTG_FS_DIEPTXF4_INEPTXSA_Pos = 0x0        // Position of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF4_INEPTXSA_Msk = 0xffff     // Bit mask of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF4_INEPTXFD_Pos = 0x10       // Position of INEPTXFD field.
	USB_OTG_FS_OTG_FS_DIEPTXF4_INEPTXFD_Msk = 0xffff0000 // Bit mask of INEPTXFD field.

	// OTG_FS_DIEPTXF5: OTG_FS device IN endpoint transmit FIFO size           register (OTG_FS_DIEPTXF5)
	USB_OTG_FS_OTG_FS_DIEPTXF5_INEPTXSA_Pos = 0x0        // Position of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF5_INEPTXSA_Msk = 0xffff     // Bit mask of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF5_INEPTXFD_Pos = 0x10       // Position of INEPTXFD field.
	USB_OTG_FS_OTG_FS_DIEPTXF5_INEPTXFD_Msk = 0xffff0000 // Bit mask of INEPTXFD field.
)

// Bitfields for OTG_HS_GLOBAL: USB on the go high speed
const (
	// OTG_HS_GOTGCTL: OTG_HS control and status           register
	USB_OTG_HS_OTG_HS_GOTGCTL_SRQSCS_Pos  = 0x0     // Position of SRQSCS field.
	USB_OTG_HS_OTG_HS_GOTGCTL_SRQSCS_Msk  = 0x1     // Bit mask of SRQSCS field.
	USB_OTG_HS_OTG_HS_GOTGCTL_SRQSCS      = 0x1     // Bit SRQSCS.
	USB_OTG_HS_OTG_HS_GOTGCTL_SRQ_Pos     = 0x1     // Position of SRQ field.
	USB_OTG_HS_OTG_HS_GOTGCTL_SRQ_Msk     = 0x2     // Bit mask of SRQ field.
	USB_OTG_HS_OTG_HS_GOTGCTL_SRQ         = 0x2     // Bit SRQ.
	USB_OTG_HS_OTG_HS_GOTGCTL_HNGSCS_Pos  = 0x8     // Position of HNGSCS field.
	USB_OTG_HS_OTG_HS_GOTGCTL_HNGSCS_Msk  = 0x100   // Bit mask of HNGSCS field.
	USB_OTG_HS_OTG_HS_GOTGCTL_HNGSCS      = 0x100   // Bit HNGSCS.
	USB_OTG_HS_OTG_HS_GOTGCTL_HNPRQ_Pos   = 0x9     // Position of HNPRQ field.
	USB_OTG_HS_OTG_HS_GOTGCTL_HNPRQ_Msk   = 0x200   // Bit mask of HNPRQ field.
	USB_OTG_HS_OTG_HS_GOTGCTL_HNPRQ       = 0x200   // Bit HNPRQ.
	USB_OTG_HS_OTG_HS_GOTGCTL_HSHNPEN_Pos = 0xa     // Position of HSHNPEN field.
	USB_OTG_HS_OTG_HS_GOTGCTL_HSHNPEN_Msk = 0x400   // Bit mask of HSHNPEN field.
	USB_OTG_HS_OTG_HS_GOTGCTL_HSHNPEN     = 0x400   // Bit HSHNPEN.
	USB_OTG_HS_OTG_HS_GOTGCTL_DHNPEN_Pos  = 0xb     // Position of DHNPEN field.
	USB_OTG_HS_OTG_HS_GOTGCTL_DHNPEN_Msk  = 0x800   // Bit mask of DHNPEN field.
	USB_OTG_HS_OTG_HS_GOTGCTL_DHNPEN      = 0x800   // Bit DHNPEN.
	USB_OTG_HS_OTG_HS_GOTGCTL_CIDSTS_Pos  = 0x10    // Position of CIDSTS field.
	USB_OTG_HS_OTG_HS_GOTGCTL_CIDSTS_Msk  = 0x10000 // Bit mask of CIDSTS field.
	USB_OTG_HS_OTG_HS_GOTGCTL_CIDSTS      = 0x10000 // Bit CIDSTS.
	USB_OTG_HS_OTG_HS_GOTGCTL_DBCT_Pos    = 0x11    // Position of DBCT field.
	USB_OTG_HS_OTG_HS_GOTGCTL_DBCT_Msk    = 0x20000 // Bit mask of DBCT field.
	USB_OTG_HS_OTG_HS_GOTGCTL_DBCT        = 0x20000 // Bit DBCT.
	USB_OTG_HS_OTG_HS_GOTGCTL_ASVLD_Pos   = 0x12    // Position of ASVLD field.
	USB_OTG_HS_OTG_HS_GOTGCTL_ASVLD_Msk   = 0x40000 // Bit mask of ASVLD field.
	USB_OTG_HS_OTG_HS_GOTGCTL_ASVLD       = 0x40000 // Bit ASVLD.
	USB_OTG_HS_OTG_HS_GOTGCTL_BSVLD_Pos   = 0x13    // Position of BSVLD field.
	USB_OTG_HS_OTG_HS_GOTGCTL_BSVLD_Msk   = 0x80000 // Bit mask of BSVLD field.
	USB_OTG_HS_OTG_HS_GOTGCTL_BSVLD       = 0x80000 // Bit BSVLD.
	USB_OTG_HS_OTG_HS_GOTGCTL_EHEN_Pos    = 0xc     // Position of EHEN field.
	USB_OTG_HS_OTG_HS_GOTGCTL_EHEN_Msk    = 0x1000  // Bit mask of EHEN field.
	USB_OTG_HS_OTG_HS_GOTGCTL_EHEN        = 0x1000  // Bit EHEN.

	// OTG_HS_GOTGINT: OTG_HS interrupt register
	USB_OTG_HS_OTG_HS_GOTGINT_SEDET_Pos   = 0x2      // Position of SEDET field.
	USB_OTG_HS_OTG_HS_GOTGINT_SEDET_Msk   = 0x4      // Bit mask of SEDET field.
	USB_OTG_HS_OTG_HS_GOTGINT_SEDET       = 0x4      // Bit SEDET.
	USB_OTG_HS_OTG_HS_GOTGINT_SRSSCHG_Pos = 0x8      // Position of SRSSCHG field.
	USB_OTG_HS_OTG_HS_GOTGINT_SRSSCHG_Msk = 0x100    // Bit mask of SRSSCHG field.
	USB_OTG_HS_OTG_HS_GOTGINT_SRSSCHG     = 0x100    // Bit SRSSCHG.
	USB_OTG_HS_OTG_HS_GOTGINT_HNSSCHG_Pos = 0x9      // Position of HNSSCHG field.
	USB_OTG_HS_OTG_HS_GOTGINT_HNSSCHG_Msk = 0x200    // Bit mask of HNSSCHG field.
	USB_OTG_HS_OTG_HS_GOTGINT_HNSSCHG     = 0x200    // Bit HNSSCHG.
	USB_OTG_HS_OTG_HS_GOTGINT_HNGDET_Pos  = 0x11     // Position of HNGDET field.
	USB_OTG_HS_OTG_HS_GOTGINT_HNGDET_Msk  = 0x20000  // Bit mask of HNGDET field.
	USB_OTG_HS_OTG_HS_GOTGINT_HNGDET      = 0x20000  // Bit HNGDET.
	USB_OTG_HS_OTG_HS_GOTGINT_ADTOCHG_Pos = 0x12     // Position of ADTOCHG field.
	USB_OTG_HS_OTG_HS_GOTGINT_ADTOCHG_Msk = 0x40000  // Bit mask of ADTOCHG field.
	USB_OTG_HS_OTG_HS_GOTGINT_ADTOCHG     = 0x40000  // Bit ADTOCHG.
	USB_OTG_HS_OTG_HS_GOTGINT_DBCDNE_Pos  = 0x13     // Position of DBCDNE field.
	USB_OTG_HS_OTG_HS_GOTGINT_DBCDNE_Msk  = 0x80000  // Bit mask of DBCDNE field.
	USB_OTG_HS_OTG_HS_GOTGINT_DBCDNE      = 0x80000  // Bit DBCDNE.
	USB_OTG_HS_OTG_HS_GOTGINT_IDCHNG_Pos  = 0x14     // Position of IDCHNG field.
	USB_OTG_HS_OTG_HS_GOTGINT_IDCHNG_Msk  = 0x100000 // Bit mask of IDCHNG field.
	USB_OTG_HS_OTG_HS_GOTGINT_IDCHNG      = 0x100000 // Bit IDCHNG.

	// OTG_HS_GAHBCFG: OTG_HS AHB configuration           register
	USB_OTG_HS_OTG_HS_GAHBCFG_GINT_Pos     = 0x0   // Position of GINT field.
	USB_OTG_HS_OTG_HS_GAHBCFG_GINT_Msk     = 0x1   // Bit mask of GINT field.
	USB_OTG_HS_OTG_HS_GAHBCFG_GINT         = 0x1   // Bit GINT.
	USB_OTG_HS_OTG_HS_GAHBCFG_HBSTLEN_Pos  = 0x1   // Position of HBSTLEN field.
	USB_OTG_HS_OTG_HS_GAHBCFG_HBSTLEN_Msk  = 0x1e  // Bit mask of HBSTLEN field.
	USB_OTG_HS_OTG_HS_GAHBCFG_DMAEN_Pos    = 0x5   // Position of DMAEN field.
	USB_OTG_HS_OTG_HS_GAHBCFG_DMAEN_Msk    = 0x20  // Bit mask of DMAEN field.
	USB_OTG_HS_OTG_HS_GAHBCFG_DMAEN        = 0x20  // Bit DMAEN.
	USB_OTG_HS_OTG_HS_GAHBCFG_TXFELVL_Pos  = 0x7   // Position of TXFELVL field.
	USB_OTG_HS_OTG_HS_GAHBCFG_TXFELVL_Msk  = 0x80  // Bit mask of TXFELVL field.
	USB_OTG_HS_OTG_HS_GAHBCFG_TXFELVL      = 0x80  // Bit TXFELVL.
	USB_OTG_HS_OTG_HS_GAHBCFG_PTXFELVL_Pos = 0x8   // Position of PTXFELVL field.
	USB_OTG_HS_OTG_HS_GAHBCFG_PTXFELVL_Msk = 0x100 // Bit mask of PTXFELVL field.
	USB_OTG_HS_OTG_HS_GAHBCFG_PTXFELVL     = 0x100 // Bit PTXFELVL.

	// OTG_HS_GUSBCFG: OTG_HS USB configuration           register
	USB_OTG_HS_OTG_HS_GUSBCFG_TOCAL_Pos      = 0x0        // Position of TOCAL field.
	USB_OTG_HS_OTG_HS_GUSBCFG_TOCAL_Msk      = 0x7        // Bit mask of TOCAL field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PHYSEL_Pos     = 0x6        // Position of PHYSEL field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PHYSEL_Msk     = 0x40       // Bit mask of PHYSEL field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PHYSEL         = 0x40       // Bit PHYSEL.
	USB_OTG_HS_OTG_HS_GUSBCFG_SRPCAP_Pos     = 0x8        // Position of SRPCAP field.
	USB_OTG_HS_OTG_HS_GUSBCFG_SRPCAP_Msk     = 0x100      // Bit mask of SRPCAP field.
	USB_OTG_HS_OTG_HS_GUSBCFG_SRPCAP         = 0x100      // Bit SRPCAP.
	USB_OTG_HS_OTG_HS_GUSBCFG_HNPCAP_Pos     = 0x9        // Position of HNPCAP field.
	USB_OTG_HS_OTG_HS_GUSBCFG_HNPCAP_Msk     = 0x200      // Bit mask of HNPCAP field.
	USB_OTG_HS_OTG_HS_GUSBCFG_HNPCAP         = 0x200      // Bit HNPCAP.
	USB_OTG_HS_OTG_HS_GUSBCFG_TRDT_Pos       = 0xa        // Position of TRDT field.
	USB_OTG_HS_OTG_HS_GUSBCFG_TRDT_Msk       = 0x3c00     // Bit mask of TRDT field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PHYLPCS_Pos    = 0xf        // Position of PHYLPCS field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PHYLPCS_Msk    = 0x8000     // Bit mask of PHYLPCS field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PHYLPCS        = 0x8000     // Bit PHYLPCS.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIFSLS_Pos   = 0x11       // Position of ULPIFSLS field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIFSLS_Msk   = 0x20000    // Bit mask of ULPIFSLS field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIFSLS       = 0x20000    // Bit ULPIFSLS.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIAR_Pos     = 0x12       // Position of ULPIAR field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIAR_Msk     = 0x40000    // Bit mask of ULPIAR field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIAR         = 0x40000    // Bit ULPIAR.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPICSM_Pos    = 0x13       // Position of ULPICSM field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPICSM_Msk    = 0x80000    // Bit mask of ULPICSM field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPICSM        = 0x80000    // Bit ULPICSM.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIEVBUSD_Pos = 0x14       // Position of ULPIEVBUSD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIEVBUSD_Msk = 0x100000   // Bit mask of ULPIEVBUSD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIEVBUSD     = 0x100000   // Bit ULPIEVBUSD.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIEVBUSI_Pos = 0x15       // Position of ULPIEVBUSI field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIEVBUSI_Msk = 0x200000   // Bit mask of ULPIEVBUSI field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIEVBUSI     = 0x200000   // Bit ULPIEVBUSI.
	USB_OTG_HS_OTG_HS_GUSBCFG_TSDPS_Pos      = 0x16       // Position of TSDPS field.
	USB_OTG_HS_OTG_HS_GUSBCFG_TSDPS_Msk      = 0x400000   // Bit mask of TSDPS field.
	USB_OTG_HS_OTG_HS_GUSBCFG_TSDPS          = 0x400000   // Bit TSDPS.
	USB_OTG_HS_OTG_HS_GUSBCFG_PCCI_Pos       = 0x17       // Position of PCCI field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PCCI_Msk       = 0x800000   // Bit mask of PCCI field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PCCI           = 0x800000   // Bit PCCI.
	USB_OTG_HS_OTG_HS_GUSBCFG_PTCI_Pos       = 0x18       // Position of PTCI field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PTCI_Msk       = 0x1000000  // Bit mask of PTCI field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PTCI           = 0x1000000  // Bit PTCI.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIIPD_Pos    = 0x19       // Position of ULPIIPD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIIPD_Msk    = 0x2000000  // Bit mask of ULPIIPD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIIPD        = 0x2000000  // Bit ULPIIPD.
	USB_OTG_HS_OTG_HS_GUSBCFG_FHMOD_Pos      = 0x1d       // Position of FHMOD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_FHMOD_Msk      = 0x20000000 // Bit mask of FHMOD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_FHMOD          = 0x20000000 // Bit FHMOD.
	USB_OTG_HS_OTG_HS_GUSBCFG_FDMOD_Pos      = 0x1e       // Position of FDMOD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_FDMOD_Msk      = 0x40000000 // Bit mask of FDMOD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_FDMOD          = 0x40000000 // Bit FDMOD.

	// OTG_HS_GRSTCTL: OTG_HS reset register
	USB_OTG_HS_OTG_HS_GRSTCTL_CSRST_Pos   = 0x0        // Position of CSRST field.
	USB_OTG_HS_OTG_HS_GRSTCTL_CSRST_Msk   = 0x1        // Bit mask of CSRST field.
	USB_OTG_HS_OTG_HS_GRSTCTL_CSRST       = 0x1        // Bit CSRST.
	USB_OTG_HS_OTG_HS_GRSTCTL_HSRST_Pos   = 0x1        // Position of HSRST field.
	USB_OTG_HS_OTG_HS_GRSTCTL_HSRST_Msk   = 0x2        // Bit mask of HSRST field.
	USB_OTG_HS_OTG_HS_GRSTCTL_HSRST       = 0x2        // Bit HSRST.
	USB_OTG_HS_OTG_HS_GRSTCTL_FCRST_Pos   = 0x2        // Position of FCRST field.
	USB_OTG_HS_OTG_HS_GRSTCTL_FCRST_Msk   = 0x4        // Bit mask of FCRST field.
	USB_OTG_HS_OTG_HS_GRSTCTL_FCRST       = 0x4        // Bit FCRST.
	USB_OTG_HS_OTG_HS_GRSTCTL_RXFFLSH_Pos = 0x4        // Position of RXFFLSH field.
	USB_OTG_HS_OTG_HS_GRSTCTL_RXFFLSH_Msk = 0x10       // Bit mask of RXFFLSH field.
	USB_OTG_HS_OTG_HS_GRSTCTL_RXFFLSH     = 0x10       // Bit RXFFLSH.
	USB_OTG_HS_OTG_HS_GRSTCTL_TXFFLSH_Pos = 0x5        // Position of TXFFLSH field.
	USB_OTG_HS_OTG_HS_GRSTCTL_TXFFLSH_Msk = 0x20       // Bit mask of TXFFLSH field.
	USB_OTG_HS_OTG_HS_GRSTCTL_TXFFLSH     = 0x20       // Bit TXFFLSH.
	USB_OTG_HS_OTG_HS_GRSTCTL_TXFNUM_Pos  = 0x6        // Position of TXFNUM field.
	USB_OTG_HS_OTG_HS_GRSTCTL_TXFNUM_Msk  = 0x7c0      // Bit mask of TXFNUM field.
	USB_OTG_HS_OTG_HS_GRSTCTL_AHBIDL_Pos  = 0x1f       // Position of AHBIDL field.
	USB_OTG_HS_OTG_HS_GRSTCTL_AHBIDL_Msk  = 0x80000000 // Bit mask of AHBIDL field.
	USB_OTG_HS_OTG_HS_GRSTCTL_AHBIDL      = 0x80000000 // Bit AHBIDL.
	USB_OTG_HS_OTG_HS_GRSTCTL_DMAREQ_Pos  = 0x1e       // Position of DMAREQ field.
	USB_OTG_HS_OTG_HS_GRSTCTL_DMAREQ_Msk  = 0x40000000 // Bit mask of DMAREQ field.
	USB_OTG_HS_OTG_HS_GRSTCTL_DMAREQ      = 0x40000000 // Bit DMAREQ.

	// OTG_HS_GINTSTS: OTG_HS core interrupt register
	USB_OTG_HS_OTG_HS_GINTSTS_CMOD_Pos              = 0x0        // Position of CMOD field.
	USB_OTG_HS_OTG_HS_GINTSTS_CMOD_Msk              = 0x1        // Bit mask of CMOD field.
	USB_OTG_HS_OTG_HS_GINTSTS_CMOD                  = 0x1        // Bit CMOD.
	USB_OTG_HS_OTG_HS_GINTSTS_MMIS_Pos              = 0x1        // Position of MMIS field.
	USB_OTG_HS_OTG_HS_GINTSTS_MMIS_Msk              = 0x2        // Bit mask of MMIS field.
	USB_OTG_HS_OTG_HS_GINTSTS_MMIS                  = 0x2        // Bit MMIS.
	USB_OTG_HS_OTG_HS_GINTSTS_OTGINT_Pos            = 0x2        // Position of OTGINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_OTGINT_Msk            = 0x4        // Bit mask of OTGINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_OTGINT                = 0x4        // Bit OTGINT.
	USB_OTG_HS_OTG_HS_GINTSTS_SOF_Pos               = 0x3        // Position of SOF field.
	USB_OTG_HS_OTG_HS_GINTSTS_SOF_Msk               = 0x8        // Bit mask of SOF field.
	USB_OTG_HS_OTG_HS_GINTSTS_SOF                   = 0x8        // Bit SOF.
	USB_OTG_HS_OTG_HS_GINTSTS_RXFLVL_Pos            = 0x4        // Position of RXFLVL field.
	USB_OTG_HS_OTG_HS_GINTSTS_RXFLVL_Msk            = 0x10       // Bit mask of RXFLVL field.
	USB_OTG_HS_OTG_HS_GINTSTS_RXFLVL                = 0x10       // Bit RXFLVL.
	USB_OTG_HS_OTG_HS_GINTSTS_NPTXFE_Pos            = 0x5        // Position of NPTXFE field.
	USB_OTG_HS_OTG_HS_GINTSTS_NPTXFE_Msk            = 0x20       // Bit mask of NPTXFE field.
	USB_OTG_HS_OTG_HS_GINTSTS_NPTXFE                = 0x20       // Bit NPTXFE.
	USB_OTG_HS_OTG_HS_GINTSTS_GINAKEFF_Pos          = 0x6        // Position of GINAKEFF field.
	USB_OTG_HS_OTG_HS_GINTSTS_GINAKEFF_Msk          = 0x40       // Bit mask of GINAKEFF field.
	USB_OTG_HS_OTG_HS_GINTSTS_GINAKEFF              = 0x40       // Bit GINAKEFF.
	USB_OTG_HS_OTG_HS_GINTSTS_BOUTNAKEFF_Pos        = 0x7        // Position of BOUTNAKEFF field.
	USB_OTG_HS_OTG_HS_GINTSTS_BOUTNAKEFF_Msk        = 0x80       // Bit mask of BOUTNAKEFF field.
	USB_OTG_HS_OTG_HS_GINTSTS_BOUTNAKEFF            = 0x80       // Bit BOUTNAKEFF.
	USB_OTG_HS_OTG_HS_GINTSTS_ESUSP_Pos             = 0xa        // Position of ESUSP field.
	USB_OTG_HS_OTG_HS_GINTSTS_ESUSP_Msk             = 0x400      // Bit mask of ESUSP field.
	USB_OTG_HS_OTG_HS_GINTSTS_ESUSP                 = 0x400      // Bit ESUSP.
	USB_OTG_HS_OTG_HS_GINTSTS_USBSUSP_Pos           = 0xb        // Position of USBSUSP field.
	USB_OTG_HS_OTG_HS_GINTSTS_USBSUSP_Msk           = 0x800      // Bit mask of USBSUSP field.
	USB_OTG_HS_OTG_HS_GINTSTS_USBSUSP               = 0x800      // Bit USBSUSP.
	USB_OTG_HS_OTG_HS_GINTSTS_USBRST_Pos            = 0xc        // Position of USBRST field.
	USB_OTG_HS_OTG_HS_GINTSTS_USBRST_Msk            = 0x1000     // Bit mask of USBRST field.
	USB_OTG_HS_OTG_HS_GINTSTS_USBRST                = 0x1000     // Bit USBRST.
	USB_OTG_HS_OTG_HS_GINTSTS_ENUMDNE_Pos           = 0xd        // Position of ENUMDNE field.
	USB_OTG_HS_OTG_HS_GINTSTS_ENUMDNE_Msk           = 0x2000     // Bit mask of ENUMDNE field.
	USB_OTG_HS_OTG_HS_GINTSTS_ENUMDNE               = 0x2000     // Bit ENUMDNE.
	USB_OTG_HS_OTG_HS_GINTSTS_ISOODRP_Pos           = 0xe        // Position of ISOODRP field.
	USB_OTG_HS_OTG_HS_GINTSTS_ISOODRP_Msk           = 0x4000     // Bit mask of ISOODRP field.
	USB_OTG_HS_OTG_HS_GINTSTS_ISOODRP               = 0x4000     // Bit ISOODRP.
	USB_OTG_HS_OTG_HS_GINTSTS_EOPF_Pos              = 0xf        // Position of EOPF field.
	USB_OTG_HS_OTG_HS_GINTSTS_EOPF_Msk              = 0x8000     // Bit mask of EOPF field.
	USB_OTG_HS_OTG_HS_GINTSTS_EOPF                  = 0x8000     // Bit EOPF.
	USB_OTG_HS_OTG_HS_GINTSTS_IEPINT_Pos            = 0x12       // Position of IEPINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_IEPINT_Msk            = 0x40000    // Bit mask of IEPINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_IEPINT                = 0x40000    // Bit IEPINT.
	USB_OTG_HS_OTG_HS_GINTSTS_OEPINT_Pos            = 0x13       // Position of OEPINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_OEPINT_Msk            = 0x80000    // Bit mask of OEPINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_OEPINT                = 0x80000    // Bit OEPINT.
	USB_OTG_HS_OTG_HS_GINTSTS_IISOIXFR_Pos          = 0x14    