/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value;

import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.AbstractValueManager;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.Value;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public abstract class LengthManager
extends AbstractValueManager {
    static final double SQRT2 = Math.sqrt(2.0);
    protected static final int HORIZONTAL_ORIENTATION = 0;
    protected static final int VERTICAL_ORIENTATION = 1;
    protected static final int BOTH_ORIENTATION = 2;

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 15: {
                return new FloatValue(3, lexicalUnit.getFloatValue());
            }
            case 16: {
                return new FloatValue(4, lexicalUnit.getFloatValue());
            }
            case 17: {
                return new FloatValue(5, lexicalUnit.getFloatValue());
            }
            case 19: {
                return new FloatValue(6, lexicalUnit.getFloatValue());
            }
            case 20: {
                return new FloatValue(7, lexicalUnit.getFloatValue());
            }
            case 18: {
                return new FloatValue(8, lexicalUnit.getFloatValue());
            }
            case 21: {
                return new FloatValue(9, lexicalUnit.getFloatValue());
            }
            case 22: {
                return new FloatValue(10, lexicalUnit.getFloatValue());
            }
            case 13: {
                return new FloatValue(1, lexicalUnit.getIntegerValue());
            }
            case 14: {
                return new FloatValue(1, lexicalUnit.getFloatValue());
            }
            case 23: {
                return new FloatValue(2, lexicalUnit.getFloatValue());
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    @Override
    public Value createFloatValue(short s, float f) throws DOMException {
        switch (s) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return new FloatValue(s, f);
            }
        }
        throw this.createInvalidFloatTypeDOMException(s);
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value.getCssValueType() != 1) {
            return value;
        }
        switch (value.getPrimitiveType()) {
            case 1: 
            case 5: {
                return value;
            }
            case 7: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f = value.getFloatValue();
                return new FloatValue(1, f / cSSContext.getPixelUnitToMillimeter());
            }
            case 6: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f = value.getFloatValue();
                return new FloatValue(1, f * 10.0f / cSSContext.getPixelUnitToMillimeter());
            }
            case 8: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f = value.getFloatValue();
                return new FloatValue(1, f * 25.4f / cSSContext.getPixelUnitToMillimeter());
            }
            case 9: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f = value.getFloatValue();
                return new FloatValue(1, f * 25.4f / (72.0f * cSSContext.getPixelUnitToMillimeter()));
            }
            case 10: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f = value.getFloatValue();
                return new FloatValue(1, f * 25.4f / (6.0f * cSSContext.getPixelUnitToMillimeter()));
            }
            case 3: {
                styleMap.putFontSizeRelative(n, true);
                float f = value.getFloatValue();
                int n2 = cSSEngine.getFontSizeIndex();
                float f2 = cSSEngine.getComputedStyle(cSSStylableElement, string, n2).getFloatValue();
                return new FloatValue(1, f * f2);
            }
            case 4: {
                styleMap.putFontSizeRelative(n, true);
                float f = value.getFloatValue();
                int n3 = cSSEngine.getFontSizeIndex();
                float f3 = cSSEngine.getComputedStyle(cSSStylableElement, string, n3).getFloatValue();
                return new FloatValue(1, f * f3 * 0.5f);
            }
            case 2: {
                float f;
                CSSContext cSSContext = cSSEngine.getCSSContext();
                switch (this.getOrientation()) {
                    case 0: {
                        styleMap.putBlockWidthRelative(n, true);
                        f = value.getFloatValue() * cSSContext.getBlockWidth(cSSStylableElement) / 100.0f;
                        break;
                    }
                    case 1: {
                        styleMap.putBlockHeightRelative(n, true);
                        f = value.getFloatValue() * cSSContext.getBlockHeight(cSSStylableElement) / 100.0f;
                        break;
                    }
                    default: {
                        styleMap.putBlockWidthRelative(n, true);
                        styleMap.putBlockHeightRelative(n, true);
                        double d = cSSContext.getBlockWidth(cSSStylableElement);
                        double d2 = cSSContext.getBlockHeight(cSSStylableElement);
                        f = (float)((double)value.getFloatValue() * (Math.sqrt(d * d + d2 * d2) / SQRT2) / 100.0);
                    }
                }
                return new FloatValue(1, f);
            }
        }
        return value;
    }

    protected abstract int getOrientation();
}

