/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.data.UpdateGPSLongitude;
import org.fibs.geotag.tasks.UndoableBackgroundTask;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class EditLongitudeTask
extends UndoableBackgroundTask<ImageInfo> {
    private static final I18n i18n = I18nFactory.getI18n(EditLongitudeTask.class);
    private ImageInfo imageInfo;
    private String newLongitude;
    private ImageInfo.DATA_SOURCE dataSource;

    public EditLongitudeTask(String name, ImageInfo imageInfo, String newLongitude, ImageInfo.DATA_SOURCE dataSource) {
        super(null, name);
        this.imageInfo = imageInfo;
        this.newLongitude = newLongitude;
        this.dataSource = dataSource;
    }

    @Override
    public int getCurrentProgress() {
        return 1;
    }

    @Override
    public int getMaxProgress() {
        return 1;
    }

    @Override
    public int getMinProgress() {
        return 1;
    }

    @Override
    protected String doInBackground() throws Exception {
        if (this.imageInfo != null) {
            if (this.newLongitude.length() == 0) {
                new UpdateGPSLongitude(this.imageInfo, null, this.dataSource);
            } else {
                new UpdateGPSLongitude(this.imageInfo, this.newLongitude, this.dataSource);
            }
            this.publish(this.imageInfo);
        }
        return i18n.tr("Longitude edited");
    }
}

