/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.proto.jeditresource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.annotation.Nonnull;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class PluginResURLConnection
extends URLConnection {
    private InputStream in;
    private String plugin;
    private String resource;

    public PluginResURLConnection(URL uRL) throws IOException {
        super(uRL);
        String string = uRL.getFile();
        int n = string.indexOf(33, 0);
        if (n == -1) {
            this.plugin = null;
            this.resource = string;
        } else {
            int n2 = string.charAt(0) == '/' ? 1 : 0;
            this.plugin = string.substring(n2, n);
            this.resource = string.substring(n + 1);
        }
        if (this.plugin != null && this.resource.startsWith("/")) {
            this.resource = this.resource.substring(1);
        }
    }

    @Override
    public void connect() throws IOException, FileNotFoundException {
        if (!this.connected) {
            File file;
            if (this.plugin == null) {
                this.in = jEdit.class.getResourceAsStream(this.resource);
            } else {
                PluginJAR[] pluginJARArray;
                boolean bl = false;
                for (PluginJAR pluginJAR : pluginJARArray = jEdit.getPluginJARs()) {
                    String string = MiscUtilities.getFileName(pluginJAR.getPath()).toLowerCase();
                    if (!this.plugin.equalsIgnoreCase(string)) continue;
                    bl = true;
                    this.in = pluginJAR.getClassLoader().getResourceAsStream(this.resource);
                    break;
                }
                if (!bl) {
                    Log.log(1, PluginResURLConnection.class, "reading resource from not loaded plugin  => will always fail !");
                }
            }
            if (this.in == null && this.plugin == null && (file = new File(jEdit.getJEditHome(), this.resource)).exists()) {
                this.in = new FileInputStream(file);
            }
            this.connected = true;
        }
        if (this.in == null) {
            if (this.plugin != null) {
                throw new FileNotFoundException("Resource not found: " + this.plugin + "!" + this.resource);
            }
            throw new FileNotFoundException("Resource not found: " + this.getURL());
        }
    }

    @Override
    @Nonnull
    public InputStream getInputStream() throws IOException, FileNotFoundException {
        this.connect();
        return this.in;
    }

    @Override
    public String getHeaderField(String string) {
        if (string.equals("content-type")) {
            String string2 = this.resource.toLowerCase();
            if (string2.endsWith(".html")) {
                return "text/html";
            }
            if (string2.endsWith(".txt")) {
                return "text/plain";
            }
            if (string2.endsWith(".rtf")) {
                return "text/rtf";
            }
            if (string2.endsWith(".gif")) {
                return "image/gif";
            }
            if (string2.endsWith(".jpg") || string2.endsWith(".jpeg")) {
                return "image/jpeg";
            }
            return null;
        }
        return null;
    }
}

