/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.ParserRule;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.SyntaxUtilities;
import org.gjt.sp.jedit.syntax.TokenHandler;
import org.gjt.sp.util.SegmentCharSequence;

public class TokenMarker {
    public static final ParserRuleSet[] EMPTY_PARSER_RULE_SETS_ARRAY = new ParserRuleSet[0];
    private final Map<String, ParserRuleSet> ruleSets = new Hashtable<String, ParserRuleSet>(64);
    private ParserRuleSet mainRuleSet;
    private TokenHandler tokenHandler;
    private Segment line;
    private LineContext context;
    private KeywordMap keywords;
    private final Segment pattern = new Segment();
    private int lastOffset;
    private int lineLength;
    private int pos;
    private int whitespaceEnd;
    private boolean seenWhitespaceEnd;

    public void addRuleSet(ParserRuleSet parserRuleSet) {
        this.ruleSets.put(parserRuleSet.getSetName(), parserRuleSet);
        if ("MAIN".equals(parserRuleSet.getSetName())) {
            this.mainRuleSet = parserRuleSet;
        }
    }

    public ParserRuleSet getMainRuleSet() {
        return this.mainRuleSet;
    }

    public ParserRuleSet getRuleSet(String string) {
        return this.ruleSets.get(string);
    }

    public ParserRuleSet[] getRuleSets() {
        return this.ruleSets.values().toArray(EMPTY_PARSER_RULE_SETS_ARRAY);
    }

    public synchronized LineContext markTokens(LineContext lineContext, TokenHandler tokenHandler, Segment segment) {
        ParserRule parserRule;
        this.tokenHandler = tokenHandler;
        this.line = segment;
        this.lastOffset = segment.offset;
        this.lineLength = segment.count + segment.offset;
        this.context = new LineContext();
        if (lineContext == null) {
            this.context.rules = this.getMainRuleSet();
            this.context.escapeRule = this.context.rules.getEscapeRule();
        } else {
            this.context.parent = lineContext.parent;
            this.context.setInRule(lineContext.inRule);
            this.context.rules = lineContext.rules;
            this.context.spanEndSubst = lineContext.spanEndSubst;
            this.context.spanEndSubstRegex = lineContext.spanEndSubstRegex;
        }
        this.keywords = this.context.rules.getKeywords();
        this.seenWhitespaceEnd = false;
        this.whitespaceEnd = segment.offset;
        int n = this.context.rules.getTerminateChar();
        boolean bl = false;
        this.pos = segment.offset;
        while (this.pos < this.lineLength) {
            block18: {
                if (n >= 0 && this.pos - segment.offset >= n && !bl) {
                    bl = true;
                    this.context = new LineContext(ParserRuleSet.getStandardRuleSet(this.context.rules.getDefault()), this.context);
                    this.keywords = this.context.rules.getKeywords();
                }
                if (this.context.escapeRule == null || !this.handleRuleStart(this.context.escapeRule)) {
                    if (this.context.parent != null && this.context.parent.inRule != null && this.checkDelegateEnd(this.context.parent.inRule)) {
                        this.seenWhitespaceEnd = true;
                    } else {
                        char c = segment.array[this.pos];
                        List<ParserRule> list = this.context.rules.getRules(c);
                        for (ParserRule parserRule2 : list) {
                            if (!this.handleRuleStart(parserRule2)) continue;
                            this.seenWhitespaceEnd = true;
                            break block18;
                        }
                        if (Character.isWhitespace(c)) {
                            if (!this.seenWhitespaceEnd) {
                                this.whitespaceEnd = this.pos + 1;
                            }
                            if (this.context.inRule != null) {
                                this.handleRuleEnd(this.context.inRule);
                            }
                            this.handleNoWordBreak();
                            this.markKeyword(false);
                            if (this.lastOffset != this.pos) {
                                tokenHandler.handleToken(segment, this.context.rules.getDefault(), this.lastOffset - segment.offset, this.pos - this.lastOffset, this.context);
                            }
                            tokenHandler.handleToken(segment, this.context.rules.getDefault(), this.pos - segment.offset, 1, this.context);
                            this.lastOffset = this.pos + 1;
                        } else {
                            if (this.keywords != null || this.context.rules.getRuleCount() != 0) {
                                String string = this.context.rules.getNoWordSep();
                                if (!Character.isLetterOrDigit(c) && string.indexOf(c) == -1) {
                                    if (this.context.inRule != null) {
                                        this.handleRuleEnd(this.context.inRule);
                                    }
                                    this.handleNoWordBreak();
                                    this.markKeyword(true);
                                    tokenHandler.handleToken(segment, this.context.rules.getDefault(), this.lastOffset - segment.offset, 1, this.context);
                                    this.lastOffset = this.pos + 1;
                                }
                            }
                            this.seenWhitespaceEnd = true;
                        }
                    }
                }
            }
            ++this.pos;
        }
        this.pos = this.lineLength;
        if (this.context.inRule != null) {
            this.handleRuleEnd(this.context.inRule);
        }
        this.handleNoWordBreak();
        this.markKeyword(true);
        while (this.context.parent != null && ((parserRule = this.context.parent.inRule) != null && (parserRule.action & 0x200) == 512 || bl)) {
            this.context = this.context.parent;
            this.keywords = this.context.rules.getKeywords();
            this.context.setInRule(null);
        }
        tokenHandler.handleToken(segment, (byte)127, this.pos - segment.offset, 0, this.context);
        this.context = this.context.intern();
        tokenHandler.setLineContext(this.context);
        this.tokenHandler = null;
        this.line = null;
        return this.context;
    }

    private boolean checkDelegateEnd(ParserRule parserRule) {
        if (parserRule.end == null && parserRule.endRegexp == null) {
            return false;
        }
        LineContext lineContext = this.context;
        this.context = this.context.parent;
        this.keywords = this.context.rules.getKeywords();
        boolean bl = this.handleRuleEnd(parserRule);
        this.context = lineContext;
        this.keywords = this.context.rules.getKeywords();
        if (bl) {
            if (this.context.inRule != null) {
                this.handleRuleEnd(this.context.inRule);
            }
            this.markKeyword(true);
            this.context = (LineContext)this.context.parent.clone();
            this.tokenHandler.handleToken(this.line, this.matchToken(this.context.inRule, this.context.inRule, this.context), this.pos - this.line.offset, this.pattern.count, this.context);
            this.keywords = this.context.rules.getKeywords();
            this.context.setInRule(null);
            this.lastOffset = this.pos + this.pattern.count;
            this.pos += this.pattern.count - 1;
            return true;
        }
        return false;
    }

    private boolean offsetMatches(int n, int n2) {
        return !((n2 & 2) == 2 ? n != this.line.offset : ((n2 & 4) == 4 ? n != this.whitespaceEnd : (n2 & 8) == 8 && n != this.lastOffset));
    }

    private boolean handleRuleStart(ParserRule parserRule) {
        int n;
        int n2;
        if (null == parserRule.upHashChars ? parserRule.upHashChar != null && this.pos + parserRule.upHashChar.length < this.line.array.length && !this.checkHashString(parserRule.upHashChar) : -1 == Arrays.binarySearch(parserRule.upHashChars, Character.toUpperCase(this.line.array[this.pos]))) {
            return false;
        }
        int n3 = n2 = (parserRule.action & 4) != 0 ? this.lastOffset : this.pos;
        if (!this.offsetMatches(n2, parserRule.startPosMatch)) {
            return false;
        }
        Matcher matcher = null;
        if ((parserRule.action & 0x2000) == 0) {
            this.pattern.array = parserRule.start;
            this.pattern.offset = 0;
            n = this.pattern.count = this.pattern.array.length;
            if (!SyntaxUtilities.regionMatches(this.context.rules.getIgnoreCase(), this.line, this.pos, this.pattern.array)) {
                return false;
            }
        } else {
            SegmentCharSequence segmentCharSequence = new SegmentCharSequence(this.line, this.pos - this.line.offset, this.line.count - (this.pos - this.line.offset));
            matcher = parserRule.startRegexp.matcher(segmentCharSequence);
            if (!matcher.lookingAt()) {
                return false;
            }
            if (matcher.start() != 0) {
                throw new InternalError("Can't happen");
            }
            n = matcher.end();
            if (n == 0) {
                n = 1;
            }
        }
        if ((parserRule.action & 0x800) == 2048) {
            this.pos += this.pattern.count;
        } else {
            if (this.context.inRule != null) {
                this.handleRuleEnd(this.context.inRule);
            }
            this.markKeyword((parserRule.action & 4) != 4);
            switch (parserRule.action & 0xFF) {
                case 0: {
                    this.context.spanEndSubst = null;
                    this.context.spanEndSubstRegex = null;
                    if ((parserRule.action & 0x2000) != 0) {
                        this.handleTokenWithSpaces(this.tokenHandler, parserRule.token, this.pos - this.line.offset, n, this.context);
                    } else {
                        this.tokenHandler.handleToken(this.line, parserRule.token, this.pos - this.line.offset, n, this.context);
                    }
                    if (parserRule.delegate == null) break;
                    this.context = new LineContext(parserRule.delegate, this.context.parent);
                    this.keywords = this.context.rules.getKeywords();
                    break;
                }
                case 2: 
                case 16: {
                    this.context.setInRule(parserRule);
                    byte by = this.matchToken(parserRule, this.context.inRule, this.context);
                    if ((parserRule.action & 0x2000) != 0) {
                        this.handleTokenWithSpaces(this.tokenHandler, by, this.pos - this.line.offset, n, this.context);
                    } else {
                        this.tokenHandler.handleToken(this.line, by, this.pos - this.line.offset, n, this.context);
                    }
                    char[] cArray = null;
                    Pattern pattern = null;
                    if (matcher != null && matcher.groupCount() > 0) {
                        if (parserRule.end != null) {
                            cArray = TokenMarker.substitute(matcher, parserRule.end, false);
                        } else if (parserRule.endRegexp != null) {
                            char[] cArray2 = parserRule.endRegexp.pattern().toCharArray();
                            cArray2 = TokenMarker.substitute(matcher, cArray2, true);
                            pattern = Pattern.compile(new String(cArray2));
                        }
                    }
                    this.context.spanEndSubst = cArray;
                    this.context.spanEndSubstRegex = pattern;
                    this.context = new LineContext(parserRule.delegate, this.context);
                    this.keywords = this.context.rules.getKeywords();
                    break;
                }
                case 8: {
                    this.tokenHandler.handleToken(this.line, this.matchToken(parserRule, parserRule, this.context), this.pos - this.line.offset, this.pattern.count, this.context);
                    this.context.spanEndSubst = null;
                    this.context.spanEndSubstRegex = null;
                    this.context.setInRule(parserRule);
                    break;
                }
                case 4: {
                    this.context.spanEndSubst = null;
                    this.context.spanEndSubstRegex = null;
                    if (this.pos != this.lastOffset) {
                        this.tokenHandler.handleToken(this.line, parserRule.token, this.lastOffset - this.line.offset, this.pos - this.lastOffset, this.context);
                    }
                    this.tokenHandler.handleToken(this.line, this.matchToken(parserRule, parserRule, this.context), this.pos - this.line.offset, this.pattern.count, this.context);
                    break;
                }
                default: {
                    throw new InternalError("Unhandled major action");
                }
            }
            this.pos += n - 1;
            this.lastOffset = this.pos + 1;
        }
        return true;
    }

    private boolean handleRuleEnd(ParserRule parserRule) {
        int n;
        int n2 = n = (parserRule.action & 4) != 0 ? this.lastOffset : this.pos;
        if (!this.offsetMatches(n, parserRule.endPosMatch)) {
            return false;
        }
        if ((parserRule.action & 8) == 0) {
            if ((parserRule.action & 0x4000) == 0) {
                this.pattern.array = this.context.spanEndSubst != null ? this.context.spanEndSubst : parserRule.end;
                this.pattern.offset = 0;
                this.pattern.count = this.pattern.array.length;
                if (!SyntaxUtilities.regionMatches(this.context.rules.getIgnoreCase(), this.line, this.pos, this.pattern.array)) {
                    return false;
                }
            } else {
                SegmentCharSequence segmentCharSequence;
                Pattern pattern = this.context.spanEndSubstRegex != null ? this.context.spanEndSubstRegex : parserRule.endRegexp;
                Matcher matcher = pattern.matcher(segmentCharSequence = new SegmentCharSequence(this.line, this.pos - this.line.offset, this.line.count - (this.pos - this.line.offset)));
                if (!matcher.lookingAt()) {
                    return false;
                }
                this.pattern.count = matcher.end();
            }
        }
        assert ((parserRule.action & 0x800) == 0);
        if ((this.context.inRule.action & 8) != 0) {
            if (this.pos != this.lastOffset) {
                this.tokenHandler.handleToken(this.line, this.context.inRule.token, this.lastOffset - this.line.offset, this.pos - this.lastOffset, this.context);
            }
            this.lastOffset = this.pos;
            this.context.setInRule(null);
        }
        return true;
    }

    private void handleNoWordBreak() {
        ParserRule parserRule;
        if (this.context.parent != null && (parserRule = this.context.parent.inRule) != null && (this.context.parent.inRule.action & 0x400) != 0) {
            if (this.pos != this.lastOffset) {
                this.tokenHandler.handleToken(this.line, parserRule.token, this.lastOffset - this.line.offset, this.pos - this.lastOffset, this.context);
            }
            this.lastOffset = this.pos;
            this.context = this.context.parent;
            this.keywords = this.context.rules.getKeywords();
            this.context.setInRule(null);
        }
    }

    private void handleTokenWithSpaces(TokenHandler tokenHandler, byte by, int n, int n2, LineContext lineContext) {
        int n3 = n;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            if (!Character.isWhitespace(this.line.array[i + this.line.offset])) continue;
            if (n3 != i) {
                tokenHandler.handleToken(this.line, by, n3, i - n3, lineContext);
            }
            tokenHandler.handleToken(this.line, by, i, 1, lineContext);
            n3 = i + 1;
        }
        if (n3 != n4) {
            tokenHandler.handleToken(this.line, by, n3, n4 - n3, lineContext);
        }
    }

    private void markKeyword(boolean bl) {
        byte by;
        int n = this.pos - this.lastOffset;
        if (n == 0) {
            return;
        }
        if (this.context.rules.getHighlightDigits()) {
            int n2;
            by = 0;
            boolean bl2 = false;
            for (int i = this.lastOffset; i < this.pos; ++i) {
                n2 = this.line.array[i];
                if (Character.isDigit((char)n2)) {
                    by = 1;
                    continue;
                }
                bl2 = true;
            }
            if (bl2) {
                Pattern pattern = this.context.rules.getDigitRegexp();
                if (by != 0) {
                    if (pattern == null) {
                        by = 0;
                    } else {
                        n2 = this.line.count;
                        int n3 = this.line.offset;
                        this.line.offset = this.lastOffset;
                        this.line.count = n;
                        SegmentCharSequence segmentCharSequence = new SegmentCharSequence(this.line);
                        by = (byte)(pattern.matcher(segmentCharSequence).matches() ? 1 : 0);
                        this.line.offset = n3;
                        this.line.count = n2;
                    }
                }
            }
            if (by != 0) {
                this.tokenHandler.handleToken(this.line, (byte)5, this.lastOffset - this.line.offset, n, this.context);
                this.lastOffset = this.pos;
                return;
            }
        }
        if (this.keywords != null && (by = this.keywords.lookup(this.line, this.lastOffset, n)) != 0) {
            this.tokenHandler.handleToken(this.line, by, this.lastOffset - this.line.offset, n, this.context);
            this.lastOffset = this.pos;
            return;
        }
        if (bl) {
            this.tokenHandler.handleToken(this.line, this.context.rules.getDefault(), this.lastOffset - this.line.offset, n, this.context);
            this.lastOffset = this.pos;
        }
    }

    private static char[] substitute(Matcher matcher, char[] cArray, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '$' || c == '~') {
                String string;
                if (i == cArray.length - 1) {
                    stringBuilder.append(c);
                    continue;
                }
                char c2 = cArray[i + 1];
                if (!Character.isDigit(c2)) {
                    stringBuilder.append(c);
                    continue;
                }
                if (c == '$') {
                    string = matcher.group(c2 - 48);
                    if (bl) {
                        string = TextUtilities.escapeText(string);
                    }
                    stringBuilder.append(string);
                    ++i;
                    continue;
                }
                string = matcher.group(c2 - 48);
                if (string.length() == 1) {
                    char c3 = TextUtilities.getComplementaryBracket(string.charAt(0), null);
                    if (c3 == '\u0000') {
                        c3 = string.charAt(0);
                    }
                    stringBuilder.append(c3);
                } else {
                    stringBuilder.append(c);
                }
                ++i;
                continue;
            }
            stringBuilder.append(c);
        }
        char[] cArray2 = new char[stringBuilder.length()];
        stringBuilder.getChars(0, stringBuilder.length(), cArray2, 0);
        return cArray2;
    }

    private byte matchToken(ParserRule parserRule, ParserRule parserRule2, LineContext lineContext) {
        switch (parserRule.matchType) {
            case -2: {
                return parserRule2.token;
            }
            case -1: {
                return this.context.rules.getDefault();
            }
        }
        return parserRule.matchType;
    }

    private boolean checkHashString(@Nonnull char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.toUpperCase(this.line.array[this.pos + i]) == cArray[i]) continue;
            return false;
        }
        return true;
    }

    public static class LineContext {
        private static final WeakHashMap<LineContext, WeakReference<LineContext>> intern = new WeakHashMap();
        public LineContext parent;
        public ParserRule inRule;
        public ParserRuleSet rules;
        public char[] spanEndSubst;
        public Pattern spanEndSubstRegex;
        public ParserRule escapeRule;

        public LineContext(ParserRuleSet parserRuleSet, LineContext lineContext) {
            this.rules = parserRuleSet;
            this.parent = lineContext == null ? null : (LineContext)lineContext.clone();
            this.escapeRule = parserRuleSet.getModeName() != null ? this.rules.getEscapeRule() : lineContext.escapeRule;
        }

        public LineContext() {
        }

        public LineContext intern() {
            LineContext lineContext;
            WeakReference<LineContext> weakReference = intern.get(this);
            if (weakReference != null && (lineContext = (LineContext)weakReference.get()) != null) {
                return lineContext;
            }
            intern.put(this, new WeakReference<LineContext>(this));
            return this;
        }

        public int hashCode() {
            int n = 0;
            n += this.parent != null ? this.parent.hashCode() : 0;
            n += this.inRule != null ? this.inRule.hashCode() : 0;
            n += this.rules != null ? this.rules.hashCode() : 0;
            n += this.spanEndSubst != null ? this.spanEndSubst.hashCode() : 0;
            return n += this.spanEndSubstRegex != null ? this.spanEndSubstRegex.hashCode() : 0;
        }

        public boolean equals(Object object) {
            if (object instanceof LineContext) {
                LineContext lineContext = (LineContext)object;
                return lineContext.inRule == this.inRule && lineContext.rules == this.rules && Objects.equals(this.parent, lineContext.parent) && LineContext.charArraysEqual(this.spanEndSubst, lineContext.spanEndSubst) && Objects.equals(this.spanEndSubstRegex, lineContext.spanEndSubstRegex);
            }
            return false;
        }

        public Object clone() {
            LineContext lineContext = new LineContext();
            lineContext.inRule = this.inRule;
            lineContext.rules = this.rules;
            lineContext.parent = this.parent == null ? null : (LineContext)this.parent.clone();
            lineContext.spanEndSubst = this.spanEndSubst;
            lineContext.spanEndSubstRegex = this.spanEndSubstRegex;
            lineContext.escapeRule = this.escapeRule;
            return lineContext;
        }

        private static boolean charArraysEqual(char[] cArray, char[] cArray2) {
            if (cArray == null) {
                return cArray2 == null;
            }
            if (cArray2 == null) {
                return false;
            }
            if (cArray.length != cArray2.length) {
                return false;
            }
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == cArray2[i]) continue;
                return false;
            }
            return true;
        }

        public void setInRule(ParserRule parserRule) {
            this.inRule = parserRule;
            this.escapeRule = parserRule != null && parserRule.escapeRule != null ? parserRule.escapeRule : (this.rules != null && this.rules.getModeName() != null ? this.rules.getEscapeRule() : (this.parent != null ? this.parent.escapeRule : null));
        }
    }
}

