/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.PsiReferenceListImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JavaClassReferenceListElementType
extends JavaStubElementType<PsiClassReferenceListStub, PsiReferenceList> {
    public JavaClassReferenceListElementType(@NotNull String id) {
        if (id == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(0);
        }
        super(id, true);
    }

    @Override
    public PsiReferenceList createPsi(@NotNull PsiClassReferenceListStub stub) {
        if (stub == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(1);
        }
        return this.getPsiFactory(stub).createClassReferenceList(stub);
    }

    @Override
    public PsiReferenceList createPsi(@NotNull ASTNode node) {
        if (node == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(2);
        }
        return new PsiReferenceListImpl(node);
    }

    @Override
    @NotNull
    public PsiClassReferenceListStub createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement parentStub) {
        if (tree == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(3);
        }
        if (node == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(4);
        }
        if (parentStub == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(5);
        }
        JavaClassReferenceListElementType type2 = (JavaClassReferenceListElementType)node.getTokenType();
        return new PsiClassReferenceListStubImpl(type2, parentStub, JavaClassReferenceListElementType.getTexts(tree, node));
    }

    private static String @NotNull [] getTexts(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        if (tree == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(6);
        }
        if (node == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(7);
        }
        List<LighterASTNode> refs = LightTreeUtil.getChildrenOfType(tree, node, JavaElementType.JAVA_CODE_REFERENCE);
        String[] texts = ArrayUtil.newStringArray(refs.size());
        for (int i = 0; i < refs.size(); ++i) {
            texts[i] = LightTreeUtil.toFilteredString(tree, refs.get(i), null);
        }
        if (texts == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(8);
        }
        return texts;
    }

    @Override
    public void serialize(@NotNull PsiClassReferenceListStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(9);
        }
        if (dataStream == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(10);
        }
        String[] names2 = stub.getReferencedNames();
        dataStream.writeVarInt(names2.length);
        for (String name : names2) {
            dataStream.writeName(name);
        }
    }

    @Override
    @NotNull
    public PsiClassReferenceListStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(11);
        }
        int len = dataStream.readVarInt();
        String[] names2 = ArrayUtil.newStringArray(len);
        for (int i = 0; i < names2.length; ++i) {
            names2[i] = dataStream.readNameString();
        }
        return new PsiClassReferenceListStubImpl(this, parentStub, names2);
    }

    @Override
    public void indexStub(@NotNull PsiClassReferenceListStub stub, @NotNull IndexSink sink) {
        PsiReferenceList.Role role;
        if (stub == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(12);
        }
        if (sink == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(13);
        }
        if ((role = stub.getRole()) == PsiReferenceList.Role.EXTENDS_LIST || role == PsiReferenceList.Role.IMPLEMENTS_LIST) {
            StubElement parentStub;
            String[] names2;
            for (String name : names2 = stub.getReferencedNames()) {
                String shortName = PsiNameHelper.getShortClassName(name);
                if (StringUtil.isEmptyOrSpaces(shortName)) continue;
                sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, shortName);
            }
            if (role == PsiReferenceList.Role.EXTENDS_LIST && (parentStub = stub.getParentStub()) instanceof PsiClassStub) {
                PsiClassStub psiClassStub = (PsiClassStub)parentStub;
                if (psiClassStub.isEnum()) {
                    sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, "Enum");
                }
                if (psiClassStub.isAnnotationType()) {
                    sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, "Annotation");
                }
            }
        }
    }

    @NotNull
    public static PsiReferenceList.Role elementTypeToRole(@NotNull IElementType type2) {
        if (type2 == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(14);
        }
        if (type2 == JavaStubElementTypes.EXTENDS_BOUND_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.EXTENDS_BOUNDS_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(15);
            }
            return role;
        }
        if (type2 == JavaStubElementTypes.EXTENDS_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.EXTENDS_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(16);
            }
            return role;
        }
        if (type2 == JavaStubElementTypes.IMPLEMENTS_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.IMPLEMENTS_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(17);
            }
            return role;
        }
        if (type2 == JavaStubElementTypes.THROWS_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.THROWS_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(18);
            }
            return role;
        }
        if (type2 == JavaStubElementTypes.PROVIDES_WITH_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.PROVIDES_WITH_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(19);
            }
            return role;
        }
        throw new RuntimeException("Unknown element type: " + type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTexts";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "elementTypeToRole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTexts";
                break;
            }
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "elementTypeToRole";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

