/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.lang.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MemoryResource
extends Resource {
    private final URL myUrl;
    private final byte[] myContent;
    private final Map<Resource.Attribute, String> myAttributes;

    private MemoryResource(@NotNull URL url, @NotNull byte[] content, @Nullable Map<Resource.Attribute, String> attributes) {
        if (url == null) {
            MemoryResource.$$$reportNull$$$0(0);
        }
        if (content == null) {
            MemoryResource.$$$reportNull$$$0(1);
        }
        this.myUrl = url;
        this.myContent = content;
        this.myAttributes = attributes;
    }

    @Override
    @NotNull
    public URL getURL() {
        URL uRL = this.myUrl;
        if (uRL == null) {
            MemoryResource.$$$reportNull$$$0(2);
        }
        return uRL;
    }

    @Override
    @NotNull
    public InputStream getInputStream() throws IOException {
        return new UnsyncByteArrayInputStream(this.myContent);
    }

    @Override
    @NotNull
    public byte[] getBytes() {
        if (this.myContent == null) {
            MemoryResource.$$$reportNull$$$0(3);
        }
        return this.myContent;
    }

    @Override
    public String getValue(@NotNull Resource.Attribute key) {
        if (key == null) {
            MemoryResource.$$$reportNull$$$0(4);
        }
        return this.myAttributes != null ? this.myAttributes.get((Object)key) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static MemoryResource load(@NotNull URL baseUrl, @NotNull ZipFile zipFile2, @NotNull ZipEntry entry, @Nullable Map<Resource.Attribute, String> attributes) throws IOException {
        if (baseUrl == null) {
            MemoryResource.$$$reportNull$$$0(5);
        }
        if (zipFile2 == null) {
            MemoryResource.$$$reportNull$$$0(6);
        }
        if (entry == null) {
            MemoryResource.$$$reportNull$$$0(7);
        }
        String name = entry.getName();
        URL url = new URL(baseUrl, name);
        byte[] content = ArrayUtilRt.EMPTY_BYTE_ARRAY;
        InputStream stream = zipFile2.getInputStream(entry);
        if (stream != null) {
            try {
                content = FileUtilRt.loadBytes(stream, (int)entry.getSize());
            }
            finally {
                stream.close();
            }
        }
        return new MemoryResource(url, content, attributes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/MemoryResource";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/MemoryResource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getURL";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

