/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.NamespaceStrategy;
import net.sourceforge.plantuml.cucadiagram.Stereotag;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.utils.UniqueSequence;

public class CommandPackageWithUSymbol
extends SingleLineCommand2<AbstractEntityDiagram> {
    public CommandPackageWithUSymbol() {
        super(CommandPackageWithUSymbol.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandPackageWithUSymbol.class.getName(), RegexLeaf.start(), new RegexLeaf("SYMBOL", "(package|rectangle|node|artifact|folder|file|frame|cloud|database|storage|component|card|together|queue|stack)"), RegexLeaf.spaceOneOrMore(), new RegexOr(new RegexConcat(new RegexLeaf("DISPLAY1", "([%g].+?[%g])"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE1", "(\\<\\<.+\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE1", "([^#%s{}]+)")), new RegexConcat(new RegexLeaf("CODE2", "([^#%s{}%g]+)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE2", "(\\<\\<.+\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("DISPLAY2", "([%g].+?[%g])")), new RegexConcat(new RegexLeaf("DISPLAY3", "([^#%s{}%g]+)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE3", "(\\<\\<.+\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE3", "([^#%s{}%g]+)")), new RegexLeaf("CODE8", "([%g][^%g]+[%g])"), new RegexLeaf("CODE9", "([^#%s{}%g]*)")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), CommandPackageWithUSymbol.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractEntityDiagram diagram, LineLocation location, RegexResult arg) {
        String urlString;
        String display;
        String idShort;
        String codeRaw = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.getLazzy("CODE", 0));
        String displayRaw = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.getLazzy("DISPLAY", 0));
        if (codeRaw.length() == 0) {
            idShort = UniqueSequence.getString("##");
            display = null;
        } else {
            idShort = codeRaw;
            display = displayRaw == null ? idShort : displayRaw;
        }
        Ident ident = diagram.buildLeafIdent(idShort);
        Ident code = diagram.V1972() ? ident : diagram.buildCode(idShort);
        IGroup currentPackage = diagram.getCurrentGroup();
        diagram.gotoGroup(ident, code, Display.getWithNewlines(display), GroupType.PACKAGE, currentPackage, NamespaceStrategy.SINGLE);
        IGroup p = diagram.getCurrentGroup();
        String symbol = arg.get("SYMBOL", 0);
        if ("together".equalsIgnoreCase(symbol)) {
            p.setThisIsTogether();
        }
        p.setUSymbol(USymbol.fromString(symbol, diagram.getSkinParam().actorStyle(), diagram.getSkinParam().componentStyle(), diagram.getSkinParam().packageStyle()));
        String stereotype = arg.getLazzy("STEREOTYPE", 0);
        if (stereotype != null) {
            p.setStereotype(new Stereotype(stereotype, false));
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            p.addUrl(url);
        }
        CommandCreateClassMultilines.addTags(p, arg.get("TAGS", 0));
        Colors colors = CommandPackageWithUSymbol.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        p.setColors(colors);
        return CommandExecutionResult.ok();
    }
}

