/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jungle;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.SvgCharSizeHack;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.UDrawableUtils;
import net.sourceforge.plantuml.jungle.GNode;
import net.sourceforge.plantuml.jungle.GTileOneLevelFactory;
import net.sourceforge.plantuml.jungle.Needle;
import net.sourceforge.plantuml.jungle.Rendering;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.ImageParameter;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class PSystemTree
extends AbstractPSystem {
    private GNode root;
    private List<GNode> stack = new ArrayList<GNode>();
    private final Rendering rendering = Rendering.NEEDLE;

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Tree)");
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        int margin2;
        int margin1;
        if (UseStyle.useBetaStyle()) {
            margin1 = SkinParam.zeroMargin(5);
            margin2 = SkinParam.zeroMargin(5);
        } else {
            margin1 = 5;
            margin2 = 5;
        }
        HColor backcolor = HColorUtils.WHITE;
        ClockwiseTopRightBottomLeft margins = ClockwiseTopRightBottomLeft.margin1margin2(margin1, margin2);
        ImageParameter imageParameter = new ImageParameter(new ColorMapperIdentity(), false, null, 1.0, null, null, margins, backcolor);
        ImageBuilder builder = ImageBuilder.build(imageParameter);
        if (this.rendering == Rendering.NEEDLE) {
            UDrawable tmp = Needle.getNeedle(this.root, 200.0, 0.0, 60.0);
            LimitFinder limitFinder = new LimitFinder(fileFormat.getDefaultStringBounder(SvgCharSizeHack.NO_HACK), true);
            tmp.drawU(limitFinder);
            double minY = limitFinder.getMinY();
            builder.setUDrawable(UDrawableUtils.move(tmp, 0.0, -minY));
        } else {
            builder.setUDrawable(new GTileOneLevelFactory().createGTile(this.root));
        }
        return builder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    public CommandExecutionResult addParagraph(int level, String label) {
        if (level == 1 && this.root == null) {
            this.root = new GNode(Display.create(label));
            this.stack.add(this.root);
            return CommandExecutionResult.ok();
        }
        if (level == 1 && this.root != null) {
            return CommandExecutionResult.error("Not allowed 1");
        }
        GNode parent = this.stack.get(level - 2);
        GNode newNode = parent.addChild(Display.create(label));
        if (level > this.stack.size() + 1) {
            return CommandExecutionResult.error("Not allowed 2");
        }
        if (level - 1 == this.stack.size()) {
            this.stack.add(newNode);
        } else {
            this.stack.set(level - 1, newNode);
        }
        return CommandExecutionResult.ok();
    }
}

