/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag;

import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.nwdiag.Square;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class Network {
    private final String name;
    private final Map<Square, String> localSquare = new LinkedHashMap<Square, String>();
    private HColor color;
    private boolean visible = true;
    private String ownAdress;
    private boolean fullWidth;
    private final int stage;
    private double xmin;
    private double xmax;
    private double y;

    public String toString() {
        return this.name + "(" + this.stage + ")";
    }

    public Network(String name, int stage) {
        this.name = name;
        this.stage = stage;
    }

    public String getAdress(Square element) {
        return this.localSquare.get(element);
    }

    public void addSquare(Square square, Map<String, String> props) {
        String address = props.get("address");
        if (address == null) {
            address = "";
        }
        if (address.length() == 0 && this.localSquare.containsKey(square)) {
            return;
        }
        this.localSquare.put(square, address);
    }

    public boolean constainsLocally(String name) {
        for (Square square : this.localSquare.keySet()) {
            if (!square.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public final String getOwnAdress() {
        return this.ownAdress;
    }

    public final void setOwnAdress(String ownAdress) {
        this.ownAdress = ownAdress;
    }

    public final String getName() {
        return this.name;
    }

    public final HColor getColor() {
        return this.color;
    }

    public final void setColor(HColor color) {
        this.color = color;
    }

    public void goInvisible() {
        this.visible = false;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public void setFullWidth(boolean fullWidth) {
        this.fullWidth = fullWidth;
    }

    public final boolean isFullWidth() {
        return this.fullWidth;
    }

    public final int getStage() {
        return this.stage;
    }

    public void setMinMax(double xmin, double xmax) {
        this.xmin = xmin;
        this.xmax = xmax;
    }

    public final double getXmin() {
        return this.xmin;
    }

    public final double getXmax() {
        return this.xmax;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double y) {
        this.y = y;
    }
}

