/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.wbs.WBSDiagram;

public class CommandWBSOrgmode
extends SingleLineCommand2<WBSDiagram> {
    public CommandWBSOrgmode() {
        super(false, CommandWBSOrgmode.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandWBSOrgmode.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "([*]+)"), new RegexOptional((IRegex)new RegexLeaf("BACKCOLOR", "\\[(#\\w+)\\]")), new RegexLeaf("DIRECTION", "([<>])?"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("LABEL", "([^%s].*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(WBSDiagram diagram, LineLocation location, RegexResult arg) {
        String direction;
        String type = arg.get("TYPE", 0);
        String label = arg.get("LABEL", 0);
        String stringColor = arg.get("BACKCOLOR", 0);
        HColor backColor = null;
        if (stringColor != null) {
            backColor = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(stringColor);
        }
        Direction dir = "<".equals(direction = arg.get("DIRECTION", 0)) ? Direction.LEFT : Direction.RIGHT;
        return diagram.addIdea(backColor, type.length() - 1, label, dir, IdeaShape.BOX);
    }
}

