/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Date;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.DocValuesAcc;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetModule;
import org.apache.solr.search.facet.SimpleAggValueSource;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.UnInvertedFieldAcc;
import org.apache.solr.search.function.FieldNameValueSource;

public class SumAgg
extends SimpleAggValueSource {
    public SumAgg(ValueSource vs) {
        super("sum", vs);
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, int numDocs, int numSlots) throws IOException {
        ValueSource vs = this.getArg();
        if (vs instanceof FieldNameValueSource) {
            String field = ((FieldNameValueSource)vs).getFieldName();
            SchemaField sf = fcontext.qcontext.searcher().getSchema().getField(field);
            if (sf.getType().getNumberType() == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.name() + " aggregation not supported for " + sf.getType().getTypeName());
            }
            if (sf.multiValued() || sf.getType().multiValuedFieldCache()) {
                if (sf.hasDocValues()) {
                    if (sf.getType().isPointField()) {
                        return new SumSortedNumericAcc(fcontext, sf, numSlots);
                    }
                    return new SumSortedSetAcc(fcontext, sf, numSlots);
                }
                if (sf.getType().isPointField()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.name() + " aggregation not supported for PointField w/o docValues");
                }
                return new SumUnInvertedFieldAcc(fcontext, sf, numSlots);
            }
            vs = sf.getType().getValueSource(sf, null);
        }
        return new SlotAcc.SumSlotAcc(vs, fcontext, numSlots);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new Merger();
    }

    class SumSortedNumericAcc
    extends DocValuesAcc.DoubleSortedNumericDVAcc {
        public SumSortedNumericAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots, 0.0);
        }

        @Override
        protected void collectValues(int doc, int slot) throws IOException {
            int count = this.values.docValueCount();
            for (int i = 0; i < count; ++i) {
                int n = slot;
                this.result[n] = this.result[n] + this.getDouble(this.values.nextValue());
            }
        }
    }

    class SumSortedSetAcc
    extends DocValuesAcc.DoubleSortedSetDVAcc {
        public SumSortedSetAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots, 0L);
        }

        @Override
        protected void collectValues(int doc, int slot) throws IOException {
            long ord;
            while ((ord = this.values.nextOrd()) != -1L) {
                BytesRef term = this.values.lookupOrd(ord);
                Object obj = this.sf.getType().toObject(this.sf, term);
                double val = obj instanceof Date ? (double)((Date)obj).getTime() : ((Number)obj).doubleValue();
                int n = slot;
                this.result[n] = this.result[n] + val;
            }
        }
    }

    class SumUnInvertedFieldAcc
    extends UnInvertedFieldAcc.DoubleUnInvertedFieldAcc {
        public SumUnInvertedFieldAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots, 0.0);
        }

        @Override
        public void call(int termNum) {
            try {
                BytesRef term = this.docToTerm.lookupOrd(termNum);
                Object obj = this.sf.getType().toObject(this.sf, term);
                double val = obj instanceof Date ? (double)((Date)obj).getTime() : ((Number)obj).doubleValue();
                int n = this.currentSlot;
                this.result[n] = this.result[n] + val;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static class Merger
    extends FacetModule.FacetDoubleMerger {
        double val;

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext) {
            this.val += ((Number)facetResult).doubleValue();
        }

        @Override
        protected double getDouble() {
            return this.val;
        }
    }
}

