/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.ElementIterable;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.IntervalMap;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.impl.Interval2IntTreeMap;
import org.gephi.graph.impl.TimeIndexImpl;
import org.gephi.graph.impl.TimeIndexStore;

public class IntervalIndexImpl<T extends Element>
extends TimeIndexImpl<T, Interval, IntervalSet, IntervalMap<?>> {
    public IntervalIndexImpl(TimeIndexStore<T, Interval, IntervalSet, IntervalMap<?>> store, boolean main) {
        super(store, main);
    }

    @Override
    public double getMinTimestamp() {
        if (this.mainIndex) {
            Interval2IntTreeMap sortedMap = (Interval2IntTreeMap)this.timestampIndexStore.timeSortedMap;
            if (!sortedMap.isEmpty()) {
                return sortedMap.getLow();
            }
        } else {
            Interval2IntTreeMap sortedMap = (Interval2IntTreeMap)this.timestampIndexStore.timeSortedMap;
            if (!sortedMap.isEmpty()) {
                for (Map.Entry<Interval, Integer> entry : sortedMap.entrySet()) {
                    TimeIndexImpl.TimeIndexEntry intervalEntry;
                    int index = entry.getValue();
                    if (index >= this.timestamps.length || (intervalEntry = this.timestamps[index]) == null) continue;
                    return entry.getKey().getLow();
                }
            }
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getMaxTimestamp() {
        if (this.mainIndex) {
            Interval2IntTreeMap sortedMap = (Interval2IntTreeMap)this.timestampIndexStore.timeSortedMap;
            if (!sortedMap.isEmpty()) {
                return sortedMap.getHigh();
            }
        } else {
            Interval2IntTreeMap sortedMap = (Interval2IntTreeMap)this.timestampIndexStore.timeSortedMap;
            if (!sortedMap.isEmpty()) {
                double max = Double.NEGATIVE_INFINITY;
                boolean found = false;
                for (Map.Entry<Interval, Integer> entry : sortedMap.entrySet()) {
                    TimeIndexImpl.TimeIndexEntry intervalEntry;
                    int index = entry.getValue();
                    if (index >= this.timestamps.length || (intervalEntry = this.timestamps[index]) == null) continue;
                    found = true;
                    max = Math.max(max, entry.getKey().getHigh());
                }
                if (found) {
                    return max;
                }
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public ElementIterable get(double timestamp) {
        this.checkDouble(timestamp);
        this.readLock();
        ObjectOpenHashSet elements = new ObjectOpenHashSet();
        Interval2IntTreeMap sortedMap = (Interval2IntTreeMap)this.timestampIndexStore.timeSortedMap;
        if (!sortedMap.isEmpty()) {
            for (Integer index : sortedMap.values(timestamp)) {
                TimeIndexImpl.TimeIndexEntry ts;
                if (index >= this.timestamps.length || (ts = this.timestamps[index]) == null) continue;
                elements.addAll(ts.elementSet);
            }
        }
        if (!elements.isEmpty()) {
            return new TimeIndexImpl.ElementIterableImpl(new TimeIndexImpl.ElementIteratorImpl((ObjectIterator<Element>)elements.iterator()));
        }
        this.readUnlock();
        return ElementIterable.EMPTY;
    }

    @Override
    public ElementIterable get(Interval interval) {
        this.readLock();
        ObjectOpenHashSet elements = new ObjectOpenHashSet();
        Interval2IntTreeMap sortedMap = (Interval2IntTreeMap)this.timestampIndexStore.timeSortedMap;
        if (!sortedMap.isEmpty()) {
            for (Integer index : sortedMap.values(interval)) {
                TimeIndexImpl.TimeIndexEntry ts;
                if (index >= this.timestamps.length || (ts = this.timestamps[index]) == null) continue;
                elements.addAll(ts.elementSet);
            }
        }
        if (!elements.isEmpty()) {
            return new TimeIndexImpl.ElementIterableImpl(new TimeIndexImpl.ElementIteratorImpl((ObjectIterator<Element>)elements.iterator()));
        }
        this.readUnlock();
        return ElementIterable.EMPTY;
    }
}

