/*
 * Decompiled with CFR 0.152.
 */
package org.coode.mdock;

import org.coode.mdock.NodeVisitor;
import org.coode.mdock.SplitterNode;

public abstract class Node {
    private SplitterNode parent;
    private boolean visible = true;

    protected void setParent(SplitterNode node) {
        this.parent = node;
    }

    public SplitterNode getParent() {
        return this.parent;
    }

    protected double getGloballyNormalisedHeight(Node child) {
        if (this.parent != null) {
            return this.parent.getGloballyNormalisedHeight(this);
        }
        return 1.0;
    }

    protected double getGloballyNormalisedWidth(Node child) {
        if (this.parent != null) {
            return this.parent.getGloballyNormalisedWidth(this);
        }
        return 1.0;
    }

    public double getGloballyNormalisedXLocation() {
        if (this.parent == null) {
            return 0.0;
        }
        return this.parent.getGloballyNormalisedXLocation(this);
    }

    public double getGloballyNormalisedXLocation(Node child) {
        if (this.parent == null) {
            return 0.0;
        }
        return this.parent.getGloballyNormalisedXLocation(this);
    }

    public double getGloballyNormalisedYLocation() {
        if (this.parent == null) {
            return 0.0;
        }
        return this.parent.getGloballyNormalisedYLocation(this);
    }

    public double getGloballyNormalisedYLocation(Node child) {
        if (this.parent == null) {
            return 0.0;
        }
        return this.parent.getGloballyNormalisedYLocation(this);
    }

    public double getGloballyNormalisedHeight() {
        if (this.parent == null) {
            return 1.0;
        }
        return this.parent.getGloballyNormalisedHeight(this);
    }

    public double getGloballyNormalisedWidth() {
        if (this.parent == null) {
            return 1.0;
        }
        return this.parent.getGloballyNormalisedWidth(this);
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
        this.notifyStateChange();
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void notifyStateChange() {
        this.stateChanged();
        if (this.parent != null) {
            this.parent.stateChanged();
            this.parent.notifyStateChange();
        }
    }

    public void remove() {
        SplitterNode parent = this.getParent();
        if (parent != null) {
            parent.removeChild(this);
            this.notifyStateChange();
        }
    }

    protected abstract void stateChanged();

    public abstract void accept(NodeVisitor var1);
}

