/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.FileTypeMap;

public class MimetypesFileTypeMap
extends FileTypeMap {
    private static final int PROG = 0;
    private static final int HOME = 1;
    private static final int SYS = 2;
    private static final int JAR = 3;
    private static final int DEF = 4;
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static boolean debug = false;
    private Map[] mimetypes;

    public MimetypesFileTypeMap() {
        this.init(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimetypesFileTypeMap(String string) throws IOException {
        try (FileReader fileReader = null;){
            fileReader = new FileReader(string);
            this.init(fileReader);
        }
    }

    public MimetypesFileTypeMap(InputStream inputStream) {
        this.init(new InputStreamReader(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Reader reader) {
        int n;
        Object object;
        this.mimetypes = new Map[5];
        for (int i = 0; i < this.mimetypes.length; ++i) {
            this.mimetypes[i] = new HashMap();
        }
        if (reader != null) {
            if (debug) {
                System.out.println("MimetypesFileTypeMap: load PROG");
            }
            try {
                this.parse(this.mimetypes[0], reader);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load HOME");
        }
        try {
            object = System.getProperty("user.home");
            if (object != null) {
                this.parseFile(this.mimetypes[1], new StringBuffer((String)object).append(File.separatorChar).append(".mime.types").toString());
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load SYS");
        }
        try {
            this.parseFile(this.mimetypes[2], new StringBuffer(System.getProperty("java.home")).append(File.separatorChar).append("lib").append(File.separatorChar).append("mime.types").toString());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load JAR");
        }
        if ((n = (object = this.getSystemResources("META-INF/mime.types")).size()) > 0) {
            for (int i = 0; i < n; ++i) {
                InputStreamReader inputStreamReader = null;
                URL uRL = (URL)object.get(i);
                try {
                    inputStreamReader = new InputStreamReader(uRL.openStream());
                    this.parse(this.mimetypes[3], inputStreamReader);
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                finally {
                    if (inputStreamReader != null) {
                        try {
                            ((Reader)inputStreamReader).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        } else {
            this.parseResource(this.mimetypes[3], "/META-INF/mime.types");
        }
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load DEF");
        }
        this.parseResource(this.mimetypes[4], "/META-INF/mimetypes.default");
    }

    public synchronized void addMimeTypes(String string) {
        if (debug) {
            System.out.println("MimetypesFileTypeMap: add to PROG");
        }
        try {
            this.parse(this.mimetypes[0], new StringReader(string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getContentType(File file) {
        return this.getContentType(file.getName());
    }

    @Override
    public synchronized String getContentType(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return DEFAULT_MIME_TYPE;
        }
        String string2 = string.substring(n + 1);
        if (string2.length() < 1) {
            return DEFAULT_MIME_TYPE;
        }
        for (int i = 0; i < this.mimetypes.length; ++i) {
            String string3 = (String)this.mimetypes[i].get(string2);
            if (string3 == null) continue;
            return string3;
        }
        return DEFAULT_MIME_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(Map map, String string) {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
            this.parse(map, fileReader);
        }
        catch (IOException iOException) {
        }
        finally {
            if (fileReader != null) {
                try {
                    ((Reader)fileReader).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseResource(Map map, String string) {
        Reader reader = null;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream != null) {
                reader = new InputStreamReader(inputStream);
                this.parse(map, reader);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void parse(Map map, Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = null;
        String string = bufferedReader.readLine();
        while (string != null) {
            int n = (string = string.trim()).length();
            if (n != 0 && string.charAt(0) != '#') {
                if (string.charAt(n - 1) == '\\') {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append(string.substring(0, n - 1));
                } else if (stringBuffer != null) {
                    stringBuffer.append(string);
                    this.parseEntry(map, stringBuffer.toString());
                    stringBuffer = null;
                } else {
                    this.parseEntry(map, string);
                }
            }
            string = bufferedReader.readLine();
        }
    }

    private void parseEntry(Map map, String string) {
        String string2 = null;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (Character.isWhitespace(c)) {
                if (string2 == null) {
                    string2 = stringBuffer.toString();
                } else if (stringBuffer.length() > 0) {
                    map.put(stringBuffer.toString(), string2);
                }
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0) {
            map.put(stringBuffer.toString(), string2);
        }
    }

    private List getSystemResources(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        try {
            Enumeration<URL> enumeration = ClassLoader.getSystemResources(string);
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }

    static {
        try {
            String string = System.getProperty("javax.activation.debug");
            debug = Boolean.valueOf(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

