/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EncodableInCharsetValidator
implements Validator<String> {
    private final String charsetName;

    EncodableInCharsetValidator(String charsetName) {
        this.charsetName = charsetName;
        Charset.forName(charsetName);
    }

    EncodableInCharsetValidator() {
        this(Charset.defaultCharset().name());
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        char[] c = model.toCharArray();
        boolean result = true;
        for (int i = 0; i < c.length; ++i) {
            String curr = new String(new char[]{c[i]});
            try {
                String nue = new String(curr.getBytes(this.charsetName));
                boolean bl = result = c[i] == nue.charAt(0);
                if (result) continue;
                problems.add(NbBundle.getMessage(EncodableInCharsetValidator.class, (String)"INVALID_CHARACTER", (Object)compName, (Object)curr, (Object)this.charsetName));
                break;
            }
            catch (UnsupportedEncodingException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        return result;
    }
}

