/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.xml.IFileParser;
import org.testng.xml.IPostProcessor;
import org.testng.xml.ISuiteParser;
import org.testng.xml.SuiteXmlParser;
import org.testng.xml.XmlSuite;

public class Parser {
    public static final String TESTNG_DTD = "testng-1.0.dtd";
    public static final String DEPRECATED_TESTNG_DTD_URL = "http://beust.com/testng/testng-1.0.dtd";
    public static final String TESTNG_DTD_URL = "http://testng.org/testng-1.0.dtd";
    public static final String DEFAULT_FILENAME = "testng.xml";
    private static final ISuiteParser DEFAULT_FILE_PARSER = new SuiteXmlParser();
    private static final List<ISuiteParser> PARSERS = Lists.newArrayList();
    private String m_fileName;
    private InputStream m_inputStream;
    private IPostProcessor m_postProcessor;
    private boolean m_loadClasses = true;

    public Parser(String string) {
        this.init(string, null);
    }

    public Parser() throws FileNotFoundException {
        this.init(null, null);
    }

    public Parser(InputStream inputStream) {
        this.init(null, inputStream);
    }

    private void init(String string, InputStream inputStream) {
        this.m_fileName = string != null ? string : DEFAULT_FILENAME;
        this.m_inputStream = inputStream;
    }

    public void setPostProcessor(IPostProcessor iPostProcessor) {
        this.m_postProcessor = iPostProcessor;
    }

    public void setLoadClasses(boolean bl) {
        this.m_loadClasses = bl;
    }

    private static IFileParser getParser(String string) {
        for (ISuiteParser iSuiteParser : PARSERS) {
            if (!iSuiteParser.accept(string)) continue;
            return iSuiteParser;
        }
        return DEFAULT_FILE_PARSER;
    }

    public Collection<XmlSuite> parse() throws IOException {
        Object object;
        Object object2;
        List list = Lists.newArrayList();
        XmlSuite xmlSuite = null;
        List<String> list2 = Lists.newArrayList();
        List list3 = Lists.newArrayList();
        List list4 = Lists.newArrayList();
        if (this.m_fileName != null) {
            object2 = Parser.constructURI(this.m_fileName);
            if (object2 == null || ((URI)object2).getScheme() == null) {
                object2 = new File(this.m_fileName).toURI();
            }
            if ("file".equalsIgnoreCase(((URI)object2).getScheme())) {
                object = new File((URI)object2);
                list2.add(((File)object).getCanonicalPath());
            } else {
                list2.add(((URI)object2).toString());
            }
        }
        object2 = Maps.newHashMap();
        while (!list2.isEmpty()) {
            for (String string : list2) {
                Object object3;
                Object object4;
                File file = null;
                InputStream inputStream = null;
                if (Parser.hasFileScheme(string)) {
                    object4 = new File(string);
                    file = ((File)object4).getParentFile();
                    inputStream = this.m_inputStream != null ? this.m_inputStream : new FileInputStream((File)object4);
                }
                object4 = Parser.getParser(string);
                XmlSuite xmlSuite2 = (XmlSuite)object4.parse(string, inputStream, this.m_loadClasses);
                xmlSuite2.setParsed(true);
                list.add(string);
                list4.add(string);
                if (object2.containsKey(string)) {
                    object3 = (XmlSuite)object2.get(string);
                    xmlSuite2.setParentSuite((XmlSuite)object3);
                    ((XmlSuite)object3).getChildSuites().add(xmlSuite2);
                }
                if (null == xmlSuite) {
                    xmlSuite = xmlSuite2;
                }
                if ((object3 = xmlSuite2.getSuiteFiles()).isEmpty()) continue;
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    String string2;
                    String string3 = string2 = (String)iterator.next();
                    if (Parser.hasFileScheme(string2)) {
                        string3 = file != null && new File(file, string2).exists() ? new File(file, string2).getCanonicalPath() : new File(string2).getCanonicalPath();
                    }
                    if (list.contains(string3)) continue;
                    list3.add(string3);
                    object2.put(string3, xmlSuite2);
                }
            }
            list2.removeAll(list4);
            list4 = Lists.newArrayList();
            list2.addAll(list3);
            list3 = Lists.newArrayList();
        }
        object = Lists.newArrayList();
        object.add(xmlSuite);
        if (this.m_postProcessor != null) {
            return this.m_postProcessor.process((Collection<XmlSuite>)object);
        }
        return object;
    }

    public static boolean hasFileScheme(String string) {
        URI uRI = Parser.constructURI(string);
        if (uRI == null) {
            return true;
        }
        String string2 = uRI.getScheme();
        return string2 == null || "file".equalsIgnoreCase(string2);
    }

    public List<XmlSuite> parseToList() throws IOException {
        return Lists.newArrayList(this.parse());
    }

    public static Collection<XmlSuite> parse(String string, IPostProcessor iPostProcessor) throws IOException {
        return Parser.newParser(string, iPostProcessor).parse();
    }

    public static Collection<XmlSuite> parse(InputStream inputStream, IPostProcessor iPostProcessor) throws IOException {
        return Parser.newParser(inputStream, iPostProcessor).parse();
    }

    private static Parser newParser(String string, IPostProcessor iPostProcessor) {
        Parser parser = new Parser(string);
        parser.setPostProcessor(iPostProcessor);
        return parser;
    }

    private static Parser newParser(InputStream inputStream, IPostProcessor iPostProcessor) {
        Parser parser = new Parser(inputStream);
        parser.setPostProcessor(iPostProcessor);
        return parser;
    }

    private static URI constructURI(String string) {
        try {
            return URI.create(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        ServiceLoader<ISuiteParser> serviceLoader = ServiceLoader.load(ISuiteParser.class);
        for (ISuiteParser iSuiteParser : serviceLoader) {
            PARSERS.add(iSuiteParser);
        }
    }
}

