/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.manager.BufferManager;
import org.gjt.sp.util.EnhancedTreeCellRenderer;
import org.gjt.sp.util.GenericGUIUtilities;

public class FilesChangedDialog
extends EnhancedDialog {
    private final View view;
    private final JTree bufferTree;
    private final DefaultTreeModel bufferTreeModel;
    private final DefaultMutableTreeNode root;
    private boolean selectAllInProgress;
    private JButton reload;
    private JButton ignore;

    public FilesChangedDialog(View view, int[] nArray, boolean bl) {
        super(view, jEdit.getProperty("files-changed.title"), false);
        Object object;
        this.view = view;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setContentPane(jPanel);
        Box box = new Box(1);
        box.add(new JLabel(UIManager.getIcon("OptionPane.warningIcon")));
        box.add(Box.createGlue());
        jPanel.add("West", box);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(jEdit.getProperty("files-changed.caption"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        jPanel2.add("North", jLabel);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(jEdit.getProperty("files-changed.deleted"), true);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(jEdit.getProperty("files-changed.changed" + (bl ? "-auto" : "")), true);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(jEdit.getProperty("files-changed.changed-dirty" + (bl ? "-auto" : "")), true);
        List<Buffer> list = jEdit.getBufferManager().getBuffers();
        for (int i = 0; i < nArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode4;
            object = list.get(i);
            switch (nArray[i]) {
                case 2: {
                    defaultMutableTreeNode4 = defaultMutableTreeNode;
                    break;
                }
                case 1: {
                    defaultMutableTreeNode4 = ((JEditBuffer)object).isDirty() ? defaultMutableTreeNode3 : defaultMutableTreeNode2;
                    break;
                }
                default: {
                    defaultMutableTreeNode4 = null;
                }
            }
            if (defaultMutableTreeNode4 == null) continue;
            defaultMutableTreeNode4.add(new DefaultMutableTreeNode(((Buffer)object).getPath()));
        }
        this.root = new DefaultMutableTreeNode("", true);
        if (defaultMutableTreeNode.getChildCount() != 0) {
            this.root.add(defaultMutableTreeNode);
        }
        if (defaultMutableTreeNode2.getChildCount() != 0) {
            this.root.add(defaultMutableTreeNode2);
        }
        if (defaultMutableTreeNode3.getChildCount() != 0) {
            this.root.add(defaultMutableTreeNode3);
        }
        this.bufferTreeModel = new DefaultTreeModel(this.root);
        this.bufferTree = new JTree(this.bufferTreeModel);
        this.bufferTree.setRowHeight(0);
        this.bufferTree.setRootVisible(false);
        this.bufferTree.setVisibleRowCount(10);
        this.bufferTree.setCellRenderer(new Renderer());
        this.bufferTree.getSelectionModel().addTreeSelectionListener(new TreeHandler());
        this.bufferTree.getSelectionModel().setSelectionMode(4);
        jPanel2.add("Center", new JScrollPane(this.bufferTree));
        jPanel.add("Center", jPanel2);
        Box box2 = new Box(0);
        box2.setBorder(BorderFactory.createEmptyBorder(17, 0, 0, 0));
        box2.add(Box.createGlue());
        if (!bl) {
            object = new JButton(jEdit.getProperty("files-changed.select-all"));
            ((AbstractButton)object).setMnemonic(jEdit.getProperty("files-changed.select-all.mnemonic").charAt(0));
            box2.add((Component)object);
            ((AbstractButton)object).addActionListener(actionEvent -> this.selectAll());
            box2.add(Box.createHorizontalStrut(6));
            this.reload = new JButton(jEdit.getProperty("files-changed.reload"));
            this.reload.setMnemonic(jEdit.getProperty("files-changed.reload.mnemonic").charAt(0));
            box2.add(this.reload);
            this.reload.addActionListener(actionEvent -> this.action("RELOAD"));
            box2.add(Box.createHorizontalStrut(6));
            this.ignore = new JButton(jEdit.getProperty("files-changed.ignore"));
            this.ignore.setMnemonic(jEdit.getProperty("files-changed.ignore.mnemonic").charAt(0));
            box2.add(this.ignore);
            this.ignore.addActionListener(actionEvent -> this.action("IGNORE"));
            box2.add(Box.createHorizontalStrut(6));
        }
        object = new JButton(jEdit.getProperty("common.close"));
        this.getRootPane().setDefaultButton((JButton)object);
        box2.add((Component)object);
        ((AbstractButton)object).addActionListener(actionEvent -> this.dispose());
        jPanel.add("South", box2);
        this.bufferTree.expandPath(new TreePath(new Object[]{this.root, defaultMutableTreeNode}));
        this.bufferTree.expandPath(new TreePath(new Object[]{this.root, defaultMutableTreeNode2}));
        this.bufferTree.expandPath(new TreePath(new Object[]{this.root, defaultMutableTreeNode3}));
        GenericGUIUtilities.requestFocus(this, this.bufferTree);
        this.updateEnabled();
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    @Override
    public void ok() {
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    private void updateEnabled() {
        TreePath[] treePathArray = this.bufferTree.getSelectionPaths();
        boolean bl = false;
        if (treePathArray != null) {
            for (TreePath treePath : treePathArray) {
                Object[] objectArray = treePath.getPath();
                if (objectArray.length != 3) continue;
                bl = true;
            }
        }
        if (this.reload != null) {
            this.reload.setEnabled(bl);
        }
        if (this.ignore != null) {
            this.ignore.setEnabled(bl);
        }
    }

    private void selectAll() {
        this.selectAllInProgress = true;
        Object[] objectArray = new TreeNode[3];
        objectArray[0] = this.root;
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            objectArray[1] = defaultMutableTreeNode;
            for (int j = 0; j < defaultMutableTreeNode.getChildCount(); ++j) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j);
                objectArray[2] = defaultMutableTreeNode2;
                this.bufferTree.getSelectionModel().addSelectionPath(new TreePath(objectArray));
            }
        }
        this.selectAllInProgress = false;
        this.updateEnabled();
    }

    private void action(String string) {
        TreePath[] treePathArray = this.bufferTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return;
        }
        int n = this.bufferTree.getRowForPath(treePathArray[0]);
        BufferManager bufferManager = jEdit.getBufferManager();
        for (TreePath treePath : treePathArray) {
            if (treePath.getPathCount() == 2) continue;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (!(defaultMutableTreeNode.getUserObject() instanceof String)) {
                return;
            }
            bufferManager.getBuffer((String)defaultMutableTreeNode.getUserObject()).ifPresent(buffer -> {
                if ("RELOAD".equals(string)) {
                    buffer.reload(this.view);
                } else {
                    buffer.setAutoReload(false);
                    buffer.setAutoReloadDialog(false);
                }
                MutableTreeNode mutableTreeNode = (MutableTreeNode)defaultMutableTreeNode.getParent();
                mutableTreeNode.remove(defaultMutableTreeNode);
            });
        }
        this.bufferTreeModel.reload(this.root);
        Object[] objectArray = new TreeNode[]{this.root, null};
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            if (this.root.getChildAt(i).getChildCount() == 0) {
                this.root.remove(i);
                --i;
                continue;
            }
            objectArray[1] = defaultMutableTreeNode;
            this.bufferTree.expandPath(new TreePath(objectArray));
        }
        if (this.root.getChildCount() == 0) {
            this.dispose();
        } else {
            TreePath treePath;
            if (n >= this.bufferTree.getRowCount()) {
                n = this.bufferTree.getRowCount() - 1;
            }
            if ((treePath = this.bufferTree.getPathForRow(n)).getPathCount() == 2) {
                this.bufferTree.setSelectionRow(n + 1);
            } else {
                this.bufferTree.setSelectionPath(treePath);
            }
        }
    }

    static class Renderer
    extends EnhancedTreeCellRenderer {
        private Font entryFont = UIManager.getFont("Tree.font");
        private final Font groupFont;

        Renderer() {
            if (this.entryFont == null) {
                this.entryFont = jEdit.getFontProperty("metal.secondary.font");
            }
            this.groupFont = this.entryFont.deriveFont(1);
        }

        @Override
        protected TreeCellRenderer newInstance() {
            return new Renderer();
        }

        @Override
        protected void configureTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (defaultMutableTreeNode.getParent() == jTree.getModel().getRoot()) {
                this.setFont(this.groupFont);
            } else {
                this.setFont(this.entryFont);
            }
            this.setIcon(null);
        }
    }

    class TreeHandler
    implements TreeSelectionListener {
        TreeHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (FilesChangedDialog.this.selectAllInProgress) {
                return;
            }
            FilesChangedDialog.this.updateEnabled();
            TreePath[] treePathArray = FilesChangedDialog.this.bufferTree.getSelectionPaths();
            if (treePathArray == null || treePathArray.length == 0) {
                return;
            }
            TreePath treePath = treePathArray[treePathArray.length - 1];
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode.getUserObject() instanceof String) {
                jEdit.getBufferManager().getBuffer((String)defaultMutableTreeNode.getUserObject()).ifPresent(buffer -> FilesChangedDialog.this.view.showBuffer((Buffer)buffer));
            }
        }
    }
}

