/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.IPropertyManager;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;

public class Chunk
extends Token {
    public static final Font[] EMPTY_FONT_ARRAY = new Font[0];
    public static final GlyphVector[] EMPTY_GLYPH_VECTOR_ARRAY = new GlyphVector[0];
    SyntaxStyle style;
    float width;
    private static boolean fontSubstEnabled;
    private static boolean fontSubstSystemFontsEnabled;
    private static Font[] preferredFonts;
    @Nullable
    private static Font[] fontSubstList;
    @Nullable
    private static Font lastSubstFont;
    private static int glyphCacheCapacity;
    private static SoftReference<GlyphCache> glyphCache;
    private Color background;
    private char[] chars;
    private String str;
    private GlyphData glyphData;

    public static float paintChunkList(Chunk chunk, Graphics2D graphics2D, float f, float f2, boolean bl) {
        Rectangle rectangle = graphics2D.getClipBounds();
        float f3 = 0.0f;
        while (chunk != null) {
            if (f + f3 + chunk.width > (float)rectangle.x && f + f3 < (float)(rectangle.x + rectangle.width)) {
                if (Debug.CHUNK_PAINT_DEBUG) {
                    graphics2D.draw(new Rectangle2D.Float(f + f3, f2 - 10.0f, chunk.width, 10.0f));
                }
                if (chunk.isAccessible() && chunk.glyphData != null) {
                    graphics2D.setFont(chunk.style.getFont());
                    graphics2D.setColor(chunk.style.getForegroundColor());
                    if (bl) {
                        chunk.drawGlyphs(graphics2D, f + f3, f2);
                    } else if (chunk.chars != null) {
                        if (chunk.str == null) {
                            chunk.str = new String(chunk.chars);
                        }
                        graphics2D.drawString(chunk.str, f + f3, f2);
                    }
                }
            }
            f3 += chunk.width;
            chunk = (Chunk)chunk.next;
        }
        return f3;
    }

    public static float paintChunkBackgrounds(Chunk chunk, Graphics2D graphics2D, float f, float f2, float f3) {
        Rectangle rectangle = graphics2D.getClipBounds();
        float f4 = 0.0f;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = fontMetrics.getAscent();
        float f5 = f3;
        while (chunk != null) {
            Color color;
            if (f + f4 + chunk.width > (float)rectangle.x && f + f4 < (float)(rectangle.x + rectangle.width) && chunk.isAccessible() && (color = chunk.background) != null) {
                graphics2D.setColor(color);
                graphics2D.fill(new Rectangle2D.Float(f + f4, f2 - (float)n, f4 + chunk.width - f4, f5));
            }
            f4 += chunk.width;
            chunk = (Chunk)chunk.next;
        }
        return f4;
    }

    public static float offsetToX(Chunk chunk, int n) {
        if (chunk != null && n < chunk.offset) {
            throw new ArrayIndexOutOfBoundsException(n + " < " + chunk.offset);
        }
        float f = 0.0f;
        while (chunk != null) {
            if (chunk.isAccessible() && n < chunk.offset + chunk.length) {
                return f + chunk.offsetToX(n - chunk.offset);
            }
            f += chunk.width;
            chunk = (Chunk)chunk.next;
        }
        return f;
    }

    public static int xToOffset(Chunk chunk, float f, boolean bl) {
        float f2 = 0.0f;
        while (chunk != null) {
            if (chunk.isAccessible() && f < f2 + chunk.width) {
                return chunk.xToOffset(f - f2, bl);
            }
            f2 += chunk.width;
            chunk = (Chunk)chunk.next;
        }
        return -1;
    }

    public static void propertiesChanged(IPropertyManager iPropertyManager) {
        fontSubstList = null;
        lastSubstFont = null;
        if (iPropertyManager == null) {
            fontSubstEnabled = false;
            fontSubstSystemFontsEnabled = true;
            preferredFonts = null;
        } else {
            fontSubstEnabled = Boolean.parseBoolean(iPropertyManager.getProperty("view.enableFontSubst"));
            fontSubstSystemFontsEnabled = Boolean.parseBoolean(iPropertyManager.getProperty("view.enableFontSubstSystemFonts"));
        }
        ArrayList<Font> arrayList = new ArrayList<Font>();
        int n = 0;
        if (iPropertyManager != null) {
            String string;
            while ((string = iPropertyManager.getProperty("view.fontSubstList." + n)) != null) {
                Font font = Font.decode(iPropertyManager.getProperty("view.fontSubstList." + n));
                if (!"dialog".equalsIgnoreCase(font.getFamily()) || "dialog".equalsIgnoreCase(string)) {
                    arrayList.add(font);
                }
                ++n;
            }
        }
        preferredFonts = arrayList.toArray(EMPTY_FONT_ARRAY);
        glyphCache = null;
    }

    public static Font getSubstFont(int n) {
        if (Character.isISOControl(n)) {
            return null;
        }
        if (lastSubstFont != null && lastSubstFont.canDisplay(n)) {
            return lastSubstFont;
        }
        for (Font font : Chunk.getFontSubstList()) {
            if (!font.canDisplay(n)) continue;
            lastSubstFont = font;
            return font;
        }
        return null;
    }

    public static Font deriveSubstFont(Font font, Font font2) {
        Font font3 = font2.deriveFont(font.getTransform());
        if (font3.getSize() == 1) {
            font3 = font3.deriveFont(font.getStyle(), font.getSize());
        }
        return font3;
    }

    public boolean usedFontSubstitution() {
        return fontSubstEnabled && this.glyphData != null && (this.glyphData.getGlyphVectorData().length > 1 || this.glyphData.getGlyphVectorData().length == 1 && this.glyphData.getGlyphVectorData()[0].getGlyphVector().getFont() != this.style.getFont());
    }

    Chunk(float f, int n, ParserRuleSet parserRuleSet) {
        super((byte)0, n, 0, parserRuleSet);
        this.width = f;
        assert (!this.isAccessible());
        assert (this.isInitialized());
    }

    Chunk(byte by, int n, int n2, ParserRuleSet parserRuleSet, SyntaxStyle[] syntaxStyleArray, byte by2) {
        super(by, n, n2, parserRuleSet);
        this.style = syntaxStyleArray[by];
        this.background = this.style.getBackgroundColor();
        if (this.background == null) {
            this.background = syntaxStyleArray[by2].getBackgroundColor();
        }
        assert (this.isAccessible());
        assert (!this.isInitialized());
    }

    Chunk(byte by, int n, int n2, ParserRuleSet parserRuleSet, SyntaxStyle syntaxStyle, Color color) {
        super(by, n, n2, parserRuleSet);
        this.style = syntaxStyle;
        this.background = color;
        assert (this.isAccessible());
        assert (!this.isInitialized());
    }

    final boolean isAccessible() {
        return this.length > 0;
    }

    final boolean isInitialized() {
        return !this.isAccessible() || this.glyphData != null || this.width > 0.0f;
    }

    final boolean isTab(Segment segment) {
        return this.length == 1 && segment.array[segment.offset + this.offset] == '\t';
    }

    final Chunk snippetBefore(int n) {
        assert (0 <= n && n < this.length);
        return new Chunk(this.id, this.offset, n, this.rules, this.style, this.background);
    }

    final Chunk snippetAfter(int n) {
        assert (0 <= n && n < this.length);
        return new Chunk(this.id, this.offset + n, this.length - n, this.rules, this.style, this.background);
    }

    final Chunk snippetBeforeLineOffset(int n) {
        return this.snippetBefore(n - this.offset);
    }

    final float offsetToX(int n) {
        if (this.glyphData == null) {
            return 0.0f;
        }
        float f = 0.0f;
        for (GlyphVectorData glyphVectorData : this.glyphData.getGlyphVectorData()) {
            GlyphVector glyphVector = glyphVectorData.getGlyphVector();
            if (n < glyphVector.getNumGlyphs()) {
                return f += (float)glyphVector.getGlyphPosition(n).getX();
            }
            f += glyphVectorData.getWidth();
            n -= glyphVector.getNumGlyphs();
        }
        assert (false) : "Shouldn't reach this.";
        return -1.0f;
    }

    final int xToOffset(float f, boolean bl) {
        if (this.glyphData == null) {
            if (bl && this.width - f < f) {
                return this.offset + this.length;
            }
            return this.offset;
        }
        int n = this.offset;
        float f2 = 0.0f;
        for (GlyphVectorData glyphVectorData : this.glyphData.getGlyphVectorData()) {
            GlyphVector glyphVector = glyphVectorData.getGlyphVector();
            float f3 = glyphVectorData.getWidth();
            if (f2 + f3 >= f) {
                float[] fArray = glyphVector.getGlyphPositions(0, glyphVector.getNumGlyphs(), null);
                for (int i = 0; i < glyphVector.getNumGlyphs(); ++i) {
                    float f4;
                    float f5 = f2 + fArray[i << 1];
                    float f6 = f4 = i == glyphVector.getNumGlyphs() - 1 ? this.width : f2 + fArray[(i << 1) + 2];
                    if (!(f4 > f)) continue;
                    if (!bl || f4 - f > f - f5) {
                        return n + i;
                    }
                    return n + i + 1;
                }
            }
            f2 += f3;
            n += glyphVector.getNumGlyphs();
        }
        assert (false) : "Shouldn't reach this.";
        return -1;
    }

    void init(Segment segment, TabExpander tabExpander, float f, FontRenderContext fontRenderContext, int n) {
        if (this.isAccessible()) {
            if (this.isTab(segment)) {
                float f2 = tabExpander.nextTabStop(f, n + this.offset);
                this.width = f2 - f;
            } else {
                this.chars = new char[this.length];
                System.arraycopy(segment.array, segment.offset + this.offset, this.chars, 0, this.length);
                GlyphKey glyphKey2 = new GlyphKey(this.chars, this.style.getFont(), fontRenderContext);
                GlyphCache glyphCache = Chunk.getGlyphCache();
                this.glyphData = glyphCache.computeIfAbsent(glyphKey2, glyphKey -> this.buildGlyphInfo(this.chars, fontRenderContext));
                this.width = this.glyphData.getWidth();
            }
        }
        assert (this.isInitialized());
    }

    private GlyphData buildGlyphInfo(char[] cArray, FontRenderContext fontRenderContext) {
        GlyphVector[] glyphVectorArray = Chunk.layoutGlyphs(this.style.getFont(), fontRenderContext, cArray, 0, cArray.length);
        return new GlyphData(glyphVectorArray);
    }

    private static Font[] getFontSubstList() {
        if (fontSubstList == null) {
            if (fontSubstSystemFontsEnabled) {
                Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
                fontSubstList = new Font[preferredFonts.length + fontArray.length];
                System.arraycopy(preferredFonts, 0, fontSubstList, 0, preferredFonts.length);
                System.arraycopy(fontArray, 0, fontSubstList, preferredFonts.length, fontArray.length);
            } else {
                fontSubstList = new Font[preferredFonts.length];
                System.arraycopy(preferredFonts, 0, fontSubstList, 0, preferredFonts.length);
            }
        }
        return fontSubstList;
    }

    private void drawGlyphs(Graphics2D graphics2D, float f, float f2) {
        for (GlyphVectorData glyphVectorData : this.glyphData.getGlyphVectorData()) {
            graphics2D.drawGlyphVector(glyphVectorData.getGlyphVector(), f, f2);
            f += glyphVectorData.getWidth();
        }
    }

    @Deprecated
    private static GlyphVector layoutGlyphVector(Font font, FontRenderContext fontRenderContext, char[] cArray, int n, int n2) {
        char[] cArray2;
        int n3 = n2 - n;
        if (cArray.length > n3 || n != 0) {
            cArray2 = new char[n3];
            System.arraycopy(cArray, n, cArray2, 0, n3);
        } else {
            cArray2 = cArray;
        }
        return Chunk.layoutGlyphVector(font, fontRenderContext, cArray2);
    }

    private static GlyphVector layoutGlyphVector(Font font, FontRenderContext fontRenderContext, char[] cArray) {
        int n = 6;
        GlyphVector glyphVector = font.layoutGlyphVector(fontRenderContext, cArray, 0, cArray.length, n);
        if ((glyphVector.getLayoutFlags() & 8) != 0) {
            glyphVector = font.createGlyphVector(fontRenderContext, cArray);
        }
        return glyphVector;
    }

    private static GlyphVector[] layoutGlyphs(Font font, FontRenderContext fontRenderContext, char[] cArray, int n, int n2) {
        int n3;
        int n4 = n3 = !fontSubstEnabled ? -1 : font.canDisplayUpTo(cArray, n, n2);
        if (n3 == -1) {
            GlyphVector glyphVector = Chunk.layoutGlyphVector(font, fontRenderContext, cArray, n, n2);
            return new GlyphVector[]{glyphVector};
        }
        FontSubstitution fontSubstitution = new FontSubstitution(font, fontRenderContext, cArray, n);
        fontSubstitution.addNonSubstRange(n3 - n);
        Chunk.doFontSubstitution(fontSubstitution, font, cArray, n3, n2);
        fontSubstitution.finish();
        return fontSubstitution.getGlyphs();
    }

    private static void doFontSubstitution(FontSubstitution fontSubstitution, Font font, char[] cArray, int n, int n2) {
        while (true) {
            assert (n < n2);
            int n3 = Character.codePointAt(cArray, n);
            int n4 = Character.charCount(n3);
            assert (!font.canDisplay(n3));
            Font font2 = Chunk.getSubstFont(n3);
            if (font2 != null) {
                font2 = Chunk.deriveSubstFont(font, font2);
                fontSubstitution.addRange(font2, n4);
            } else {
                fontSubstitution.addNonSubstRange(n4);
            }
            if ((n += n4) >= n2) break;
            int n5 = font.canDisplayUpTo(cArray, n, n2);
            if (n5 == -1) {
                fontSubstitution.addNonSubstRange(n2 - n);
                break;
            }
            fontSubstitution.addNonSubstRange(n5 - n);
            n = n5;
        }
    }

    private static GlyphCache getGlyphCache() {
        GlyphCache glyphCache;
        if (Chunk.glyphCache != null && (glyphCache = Chunk.glyphCache.get()) != null) {
            return glyphCache;
        }
        glyphCache = new GlyphCache(glyphCacheCapacity);
        Chunk.glyphCache = new SoftReference<GlyphCache>(glyphCache);
        return glyphCache;
    }

    static {
        glyphCacheCapacity = 256;
    }

    private static class GlyphVectorData {
        private final GlyphVector glyphVector;
        private final float width;

        private GlyphVectorData(GlyphVector glyphVector) {
            this.glyphVector = glyphVector;
            this.width = (float)glyphVector.getLogicalBounds().getWidth();
        }

        public GlyphVector getGlyphVector() {
            return this.glyphVector;
        }

        public float getWidth() {
            return this.width;
        }
    }

    private static class GlyphData {
        private final GlyphVectorData[] glyphVectorData;
        private final float width;

        GlyphData(GlyphVector[] glyphVectorArray) {
            this.glyphVectorData = new GlyphVectorData[glyphVectorArray.length];
            float f = 0.0f;
            for (int i = 0; i < glyphVectorArray.length; ++i) {
                GlyphVectorData glyphVectorData;
                this.glyphVectorData[i] = glyphVectorData = new GlyphVectorData(glyphVectorArray[i]);
                f += glyphVectorData.getWidth();
            }
            this.width = f;
        }

        public GlyphVectorData[] getGlyphVectorData() {
            return this.glyphVectorData;
        }

        public float getWidth() {
            return this.width;
        }
    }

    private static class GlyphCache
    extends LinkedHashMap<GlyphKey, GlyphData> {
        private final int capacity;

        GlyphCache(int n) {
            super(n + 1, 1.0f, true);
            this.capacity = n;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<GlyphKey, GlyphData> entry) {
            return this.size() > this.capacity;
        }
    }

    private static class GlyphKey {
        public final char[] chars;
        public final Font font;
        public final FontRenderContext context;
        private final int hashCode;

        GlyphKey(@Nonnull char[] cArray, @Nonnull Font font, @Nonnull FontRenderContext fontRenderContext) {
            this.chars = cArray;
            this.font = font;
            this.context = fontRenderContext;
            this.hashCode = 31 * (31 * Arrays.hashCode(cArray) + font.hashCode()) + fontRenderContext.hashCode();
        }

        public final int hashCode() {
            return this.hashCode;
        }

        public final boolean equals(Object object) {
            GlyphKey glyphKey = (GlyphKey)object;
            return Arrays.equals(this.chars, glyphKey.chars) && this.font.equals(glyphKey.font) && this.context.equals(glyphKey.context);
        }

        public final String toString() {
            return new String(this.chars);
        }
    }

    private static class FontSubstitution {
        private final Font mainFont;
        private final FontRenderContext frc;
        private final char[] text;
        private int rangeStart;
        @Nullable
        private Font rangeFont;
        private int rangeLength;
        private final List<GlyphVector> glyphs;

        FontSubstitution(Font font, FontRenderContext fontRenderContext, char[] cArray, int n) {
            this.mainFont = font;
            this.frc = fontRenderContext;
            this.text = cArray;
            this.rangeStart = n;
            this.rangeFont = null;
            this.rangeLength = 0;
            this.glyphs = new ArrayList<GlyphVector>();
        }

        public void addNonSubstRange(int n) {
            this.addRange(null, n);
        }

        private void addRange(Font font, int n) {
            assert (n >= 0);
            if (n == 0) {
                return;
            }
            if (font == this.rangeFont) {
                this.rangeLength += n;
            } else {
                this.addGlyphVectorOfLastRange();
                this.rangeFont = font;
                this.rangeStart += this.rangeLength;
                this.rangeLength = n;
            }
        }

        public void finish() {
            this.addGlyphVectorOfLastRange();
            this.rangeFont = null;
            this.rangeStart += this.rangeLength;
            this.rangeLength = 0;
        }

        public GlyphVector[] getGlyphs() {
            return this.glyphs.toArray(EMPTY_GLYPH_VECTOR_ARRAY);
        }

        private void addGlyphVectorOfLastRange() {
            if (this.rangeLength == 0) {
                return;
            }
            Font font = this.rangeFont == null ? this.mainFont : this.rangeFont;
            GlyphVector glyphVector = Chunk.layoutGlyphVector(font, this.frc, this.text, this.rangeStart, this.rangeStart + this.rangeLength);
            this.glyphs.add(glyphVector);
        }
    }
}

