/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.Token;

public class ParserRule {
    public static final int MAJOR_ACTIONS = 255;
    public static final int SEQ = 0;
    public static final int SPAN = 2;
    public static final int MARK_PREVIOUS = 4;
    public static final int MARK_FOLLOWING = 8;
    public static final int EOL_SPAN = 16;
    public static final int ACTION_HINTS = 65280;
    public static final int NO_LINE_BREAK = 512;
    public static final int NO_WORD_BREAK = 1024;
    public static final int IS_ESCAPE = 2048;
    public static final int REGEXP = 8192;
    public static final int END_REGEXP = 16384;
    public static final byte MATCH_TYPE_CONTEXT = -1;
    public static final byte MATCH_TYPE_RULE = -2;
    public static final int AT_LINE_START = 2;
    public static final int AT_WHITESPACE_END = 4;
    public static final int AT_WORD_START = 8;
    public final char[] upHashChar;
    public final char[] upHashChars;
    public final int startPosMatch;
    public final char[] start;
    public final Pattern startRegexp;
    public final int endPosMatch;
    public final char[] end;
    public final Pattern endRegexp;
    public final int action;
    public final byte token;
    public final byte matchType;
    public final ParserRule escapeRule;
    public ParserRuleSet delegate;

    public static ParserRule createSequenceRule(int n, String string, ParserRuleSet parserRuleSet, byte by) {
        return new ParserRule(0, string.substring(0, 1), n, string.toCharArray(), null, 0, null, null, parserRuleSet, by, -1, null);
    }

    public static ParserRule createRegexpSequenceRule(String string, int n, String string2, ParserRuleSet parserRuleSet, byte by, boolean bl) throws PatternSyntaxException {
        return new ParserRule(8192, string, n, null, Pattern.compile(string2, bl ? 2 : 0), 0, null, null, parserRuleSet, by, -1, null);
    }

    public static ParserRule createRegexpSequenceRule(int n, char[] cArray, String string, ParserRuleSet parserRuleSet, byte by, boolean bl) throws PatternSyntaxException {
        return new ParserRule(cArray, 8192, n, null, Pattern.compile(string, bl ? 2 : 0), 0, null, null, parserRuleSet, by, -1, null);
    }

    public static ParserRule createSpanRule(int n, String string, int n2, String string2, ParserRuleSet parserRuleSet, byte by, byte by2, boolean bl, boolean bl2, String string3) {
        int n3 = 2 | (bl ? 512 : 0) | (bl2 ? 1024 : 0);
        return new ParserRule(n3, string.substring(0, 1), n, string.toCharArray(), null, n2, string2.toCharArray(), null, parserRuleSet, by, by2, string3);
    }

    public static ParserRule createRegexpSpanRule(String string, int n, String string2, int n2, String string3, ParserRuleSet parserRuleSet, byte by, byte by2, boolean bl, boolean bl2, boolean bl3, String string4, boolean bl4) throws PatternSyntaxException {
        char[] cArray;
        Pattern pattern;
        int n3 = 0x2002 | (bl ? 512 : 0) | (bl2 ? 1024 : 0);
        if (bl4) {
            n3 |= 0x4000;
            pattern = Pattern.compile(string3, bl3 ? 2 : 0);
            cArray = null;
        } else {
            pattern = null;
            cArray = string3.toCharArray();
        }
        return new ParserRule(n3, string, n, null, Pattern.compile(string2, bl3 ? 2 : 0), n2, cArray, pattern, parserRuleSet, by, by2, string4);
    }

    public static ParserRule createRegexpSpanRule(int n, char[] cArray, String string, int n2, String string2, ParserRuleSet parserRuleSet, byte by, byte by2, boolean bl, boolean bl2, boolean bl3, String string3, boolean bl4) throws PatternSyntaxException {
        char[] cArray2;
        Pattern pattern;
        int n3 = 0x2002 | (bl ? 512 : 0) | (bl2 ? 1024 : 0);
        if (bl4) {
            n3 |= 0x4000;
            pattern = Pattern.compile(string2, bl3 ? 2 : 0);
            cArray2 = null;
        } else {
            pattern = null;
            cArray2 = string2.toCharArray();
        }
        return new ParserRule(cArray, n3, n, null, Pattern.compile(string, bl3 ? 2 : 0), n2, cArray2, pattern, parserRuleSet, by, by2, string3);
    }

    public static ParserRule createEOLSpanRule(int n, String string, ParserRuleSet parserRuleSet, byte by, byte by2) {
        int n2 = 528;
        return new ParserRule(n2, string.substring(0, 1), n, string.toCharArray(), null, 0, null, null, parserRuleSet, by, by2, null);
    }

    public static ParserRule createRegexpEOLSpanRule(String string, int n, String string2, ParserRuleSet parserRuleSet, byte by, byte by2, boolean bl) throws PatternSyntaxException {
        int n2 = 8720;
        return new ParserRule(n2, string, n, null, Pattern.compile(string2, bl ? 2 : 0), 0, null, null, parserRuleSet, by, by2, null);
    }

    public static ParserRule createRegexpEOLSpanRule(int n, char[] cArray, String string, ParserRuleSet parserRuleSet, byte by, byte by2, boolean bl) throws PatternSyntaxException {
        int n2 = 8720;
        return new ParserRule(cArray, n2, n, null, Pattern.compile(string, bl ? 2 : 0), 0, null, null, parserRuleSet, by, by2, null);
    }

    public static ParserRule createMarkFollowingRule(int n, String string, byte by, byte by2) {
        int n2 = 8;
        return new ParserRule(n2, string.substring(0, 1), n, string.toCharArray(), null, 0, null, null, null, by, by2, null);
    }

    public static ParserRule createMarkPreviousRule(int n, String string, byte by, byte by2) {
        int n2 = 4;
        return new ParserRule(n2, string.substring(0, 1), n, string.toCharArray(), null, 0, null, null, null, by, by2, null);
    }

    public static ParserRule createEscapeRule(String string) {
        int n = 2048;
        return new ParserRule(n, string.substring(0, 1), 0, string.toCharArray(), null, 0, null, null, null, 0, -1, null);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName()).append("[action=");
        switch (this.action & 0xFF) {
            case 0: {
                stringBuilder.append("SEQ");
                break;
            }
            case 2: {
                stringBuilder.append("SPAN");
                break;
            }
            case 4: {
                stringBuilder.append("MARK_PREVIOUS");
                break;
            }
            case 8: {
                stringBuilder.append("MARK_FOLLOWING");
                break;
            }
            case 16: {
                stringBuilder.append("EOL_SPAN");
                break;
            }
            default: {
                stringBuilder.append("UNKNOWN");
            }
        }
        int n = this.action & 0xFF00;
        stringBuilder.append("[matchType=").append(this.matchType == -1 ? "MATCH_TYPE_CONTEXT" : (this.matchType == -2 ? "MATCH_TYPE_RULE" : Token.tokenToString(this.matchType)));
        stringBuilder.append(",NO_LINE_BREAK=").append((n & 0x200) != 0);
        stringBuilder.append(",NO_WORD_BREAK=").append((n & 0x400) != 0);
        stringBuilder.append(",IS_ESCAPE=").append((n & 0x800) != 0);
        stringBuilder.append(",REGEXP=").append((n & 0x2000) != 0);
        stringBuilder.append("],upHashChar=").append(new String(this.upHashChar));
        stringBuilder.append(",upHashChars=").append(Arrays.toString(this.upHashChars));
        stringBuilder.append(",startPosMatch=");
        stringBuilder.append("[AT_LINE_START=").append((this.startPosMatch & 2) != 0);
        stringBuilder.append(",AT_WHITESPACE_END=").append((this.startPosMatch & 4) != 0);
        stringBuilder.append(",AT_WORD_START=").append((this.startPosMatch & 8) != 0);
        stringBuilder.append("],start=").append(null == this.start ? null : String.valueOf(this.start));
        stringBuilder.append(",startRegexp=").append(this.startRegexp);
        stringBuilder.append(",endPosMatch=");
        stringBuilder.append("[AT_LINE_START=").append((this.endPosMatch & 2) != 0);
        stringBuilder.append(",AT_WHITESPACE_END=").append((this.endPosMatch & 4) != 0);
        stringBuilder.append(",AT_WORD_START=").append((this.endPosMatch & 8) != 0);
        stringBuilder.append("],end=").append(null == this.end ? null : String.valueOf(this.end));
        stringBuilder.append(",delegate=").append(this.delegate);
        stringBuilder.append(",escapeRule=").append(this.escapeRule);
        stringBuilder.append(",token=").append(Token.tokenToString(this.token)).append(']');
        return stringBuilder.toString();
    }

    private ParserRule(int n, String string, int n2, char[] cArray, Pattern pattern, int n3, char[] cArray2, Pattern pattern2, ParserRuleSet parserRuleSet, byte by, byte by2, String string2) {
        this.action = n;
        this.upHashChar = null == string ? null : string.toUpperCase().toCharArray();
        this.upHashChars = null;
        this.startPosMatch = n2;
        this.start = cArray;
        this.startRegexp = pattern;
        this.endPosMatch = n3;
        this.end = cArray2;
        this.endRegexp = pattern2;
        this.delegate = parserRuleSet;
        this.token = by;
        this.matchType = by2;
        ParserRule parserRule = this.escapeRule = string2 != null && !string2.isEmpty() ? ParserRule.createEscapeRule(string2) : null;
        if (this.delegate == null && (n & 0xFF) != 0) {
            this.delegate = ParserRuleSet.getStandardRuleSet(by);
        }
    }

    private ParserRule(char[] cArray, int n, int n2, char[] cArray2, Pattern pattern, int n3, char[] cArray3, Pattern pattern2, ParserRuleSet parserRuleSet, byte by, byte by2, String string) {
        this.action = n;
        this.upHashChar = null;
        HashSet<Character> hashSet = new HashSet<Character>();
        for (char c : cArray) {
            hashSet.add(Character.valueOf(Character.toUpperCase(c)));
        }
        this.upHashChars = new char[hashSet.size()];
        int n4 = 0;
        for (Character c : hashSet) {
            this.upHashChars[n4++] = c.charValue();
        }
        Arrays.sort(this.upHashChars);
        this.startPosMatch = n2;
        this.start = cArray2;
        this.startRegexp = pattern;
        this.endPosMatch = n3;
        this.end = cArray3;
        this.endRegexp = pattern2;
        this.delegate = parserRuleSet;
        this.token = by;
        this.matchType = by2;
        ParserRule parserRule = this.escapeRule = string != null && !string.isEmpty() ? ParserRule.createEscapeRule(string) : null;
        if (this.delegate == null && (n & 0xFF) != 0) {
            this.delegate = ParserRuleSet.getStandardRuleSet(by);
        }
    }
}

