/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class ScrollLayout
implements LayoutManager {
    public static final String CENTER = "center";
    public static final String RIGHT = "right";
    public static final String LEFT = "left";
    public static final String BOTTOM = "bottom";
    public static final String TOP = "top";
    public static final String TOP_LEFT = "topLeft";
    public static final String TOP_RIGHT = "topRight";
    public static final String BOTTOM_LEFT = "bottomLeft";
    public static final String BOTTOM_RIGHT = "bottomRight";
    private Component center;
    private Component left;
    private Component right;
    private Component bottom;
    private Component top;
    private Component topLeft;
    private Component topRight;
    private Component bottomLeft;
    private Component bottomRight;

    @Override
    public void addLayoutComponent(String string, Component component) {
        switch (string) {
            case "center": {
                this.center = component;
                break;
            }
            case "right": {
                this.right = component;
                break;
            }
            case "left": {
                this.left = component;
                break;
            }
            case "bottom": {
                this.bottom = component;
                break;
            }
            case "top": {
                this.top = component;
                break;
            }
            case "topLeft": {
                this.topLeft = component;
                break;
            }
            case "topRight": {
                this.topRight = component;
                break;
            }
            case "bottomLeft": {
                this.bottomLeft = component;
                break;
            }
            case "bottomRight": {
                this.bottomRight = component;
            }
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        if (this.center == component) {
            this.center = null;
        } else if (this.right == component) {
            this.right = null;
        } else if (this.left == component) {
            this.left = null;
        } else if (this.bottom == component) {
            this.bottom = null;
        } else if (this.top == component) {
            this.top = null;
        } else if (this.topLeft == component) {
            this.topLeft = null;
        } else if (this.topRight == component) {
            this.topRight = null;
        } else if (this.bottomLeft == component) {
            this.bottomLeft = null;
        } else if (this.bottomRight == component) {
            this.bottomRight = null;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension();
        Insets insets = ScrollLayout.getInsets(container);
        dimension.width = insets.left + insets.right;
        dimension.width += this.getLeftPreferredWidth();
        dimension.width += this.getCenterPreferredWidth();
        dimension.width += this.getRightPreferredWidth();
        dimension.height = insets.top + insets.bottom;
        dimension.height += this.getTopPreferredHeight();
        dimension.height += this.getCenterPreferredHeight();
        dimension.height += this.getBottomPreferredHeight();
        return dimension;
    }

    private int getLeftPreferredWidth() {
        if (this.left != null) {
            return this.left.getPreferredSize().width;
        }
        int n = this.topLeft == null ? 0 : this.topLeft.getPreferredSize().width;
        int n2 = this.left == null ? 0 : this.left.getPreferredSize().width;
        int n3 = this.bottomLeft == null ? 0 : this.bottomLeft.getPreferredSize().width;
        return Math.max(n2, Math.max(n, n3));
    }

    private int getCenterPreferredWidth() {
        int n = this.top == null ? 0 : this.top.getPreferredSize().width;
        int n2 = this.center == null ? 0 : this.center.getPreferredSize().width;
        int n3 = this.bottom == null ? 0 : this.bottom.getPreferredSize().width;
        return Math.max(n2, Math.max(n, n3));
    }

    private int getRightPreferredWidth() {
        if (this.right != null) {
            return this.right.getPreferredSize().width;
        }
        int n = this.topRight == null ? 0 : this.topRight.getPreferredSize().width;
        int n2 = this.right == null ? 0 : this.right.getPreferredSize().width;
        int n3 = this.bottomRight == null ? 0 : this.bottomRight.getPreferredSize().width;
        return Math.max(n2, Math.max(n, n3));
    }

    private int getTopPreferredHeight() {
        if (this.top != null) {
            return this.top.getPreferredSize().height;
        }
        int n = this.topLeft == null ? 0 : this.topLeft.getPreferredSize().height;
        int n2 = this.top == null ? 0 : this.top.getPreferredSize().height;
        int n3 = this.topRight == null ? 0 : this.topRight.getPreferredSize().height;
        return Math.max(n2, Math.max(n, n3));
    }

    private int getCenterPreferredHeight() {
        int n = this.left == null ? 0 : this.left.getPreferredSize().height;
        int n2 = this.center == null ? 0 : this.center.getPreferredSize().height;
        int n3 = this.right == null ? 0 : this.right.getPreferredSize().height;
        return Math.max(n2, Math.max(n, n3));
    }

    private int getBottomPreferredHeight() {
        if (this.bottom != null) {
            return this.bottom.getPreferredSize().height;
        }
        int n = this.bottomLeft == null ? 0 : this.bottomLeft.getPreferredSize().height;
        int n2 = this.bottom == null ? 0 : this.bottom.getPreferredSize().height;
        int n3 = this.bottomRight == null ? 0 : this.bottomRight.getPreferredSize().height;
        return Math.max(n2, Math.max(n3, n));
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension();
        Insets insets = ScrollLayout.getInsets(container);
        dimension.width = insets.left + insets.right;
        dimension.height = insets.top + insets.bottom;
        int n = this.topLeft == null ? 0 : this.topLeft.getMinimumSize().width;
        int n2 = this.left == null ? 0 : this.left.getMinimumSize().width;
        int n3 = this.bottomLeft == null ? 0 : this.bottomLeft.getMinimumSize().width;
        dimension.width += Math.max(n2, Math.max(n, n3));
        int n4 = this.top == null ? 0 : this.top.getMinimumSize().width;
        int n5 = this.center == null ? 0 : this.center.getMinimumSize().width;
        int n6 = this.bottom == null ? 0 : this.bottom.getMinimumSize().width;
        dimension.width += Math.max(n5, Math.max(n4, n6));
        int n7 = this.topRight == null ? 0 : this.topRight.getMinimumSize().width;
        int n8 = this.right == null ? 0 : this.right.getMinimumSize().width;
        int n9 = this.bottomRight == null ? 0 : this.bottomRight.getMinimumSize().width;
        dimension.width += Math.max(n8, Math.max(n7, n9));
        int n10 = this.topLeft == null ? 0 : this.topLeft.getMinimumSize().height;
        int n11 = this.left == null ? 0 : this.left.getMinimumSize().height;
        int n12 = this.bottomLeft == null ? 0 : this.bottomLeft.getMinimumSize().height;
        dimension.height += Math.max(n11, Math.max(n10, n12));
        int n13 = this.top == null ? 0 : this.top.getMinimumSize().height;
        int n14 = this.center == null ? 0 : this.center.getMinimumSize().height;
        int n15 = this.bottom == null ? 0 : this.bottom.getMinimumSize().height;
        dimension.height += Math.max(n14, Math.max(n13, n15));
        int n16 = this.topRight == null ? 0 : this.topRight.getMinimumSize().height;
        int n17 = this.right == null ? 0 : this.right.getMinimumSize().height;
        int n18 = this.bottomRight == null ? 0 : this.bottomRight.getMinimumSize().height;
        dimension.height += Math.max(n17, Math.max(n16, n18));
        return dimension;
    }

    @Override
    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        Insets insets = ScrollLayout.getInsets(container);
        int n = insets.top;
        int n2 = insets.left;
        int n3 = insets.bottom;
        int n4 = insets.right;
        int n5 = this.getLeftPreferredWidth();
        int n6 = this.getRightPreferredWidth();
        int n7 = this.getTopPreferredHeight();
        int n8 = this.getBottomPreferredHeight();
        int n9 = Math.max(0, dimension.width - n5 - n6 - n2 - n4);
        int n10 = Math.max(0, dimension.height - n7 - n8 - n - n3);
        if (this.left != null) {
            this.left.setBounds(n2, n + n7, n5, n10);
        }
        if (this.center != null) {
            this.center.setBounds(n2 + n5, n + n7, n9, n10);
        }
        if (this.right != null) {
            this.right.setBounds(n2 + n5 + n9, n + n7, n6, n10);
        }
        if (this.bottom != null) {
            this.bottom.setBounds(n2 + n5, n + n7 + n10, n9, n8);
        }
        if (this.top != null) {
            this.top.setBounds(n2 + n5, n, n9, n7);
        }
        if (this.topLeft != null) {
            this.topLeft.setBounds(n2, n, n5, n7);
        }
        if (this.topRight != null) {
            this.topRight.setBounds(n2 + n5 + n9, n, n6, n7);
        }
        if (this.bottomLeft != null) {
            this.bottomLeft.setBounds(n2, n + n7 + n10, n5, n8);
        }
        if (this.bottomRight != null) {
            this.bottomRight.setBounds(n2 + n5 + n9, n + n7 + n10, n6, n8);
        }
    }

    private static Insets getInsets(Component component) {
        Border border = ((JComponent)component).getBorder();
        if (border == null) {
            return new Insets(0, 0, 0, 0);
        }
        return border.getBorderInsets(component);
    }
}

