/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SingleSelectionModel;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.PrimitiveComparator;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.InspectPrimitiveDataText;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.gui.mappaint.StyleElementList;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class InspectPrimitiveDialog
extends ExtendedDialog {
    protected transient List<IPrimitive> primitives;
    private boolean mappaintTabLoaded;
    private boolean editcountTabLoaded;

    public InspectPrimitiveDialog(Collection<? extends IPrimitive> primitives, OsmData<?, ?, ?, ?> data) {
        super((Component)MainApplication.getMainFrame(), I18n.tr("Advanced object info", new Object[0]), I18n.tr("Close", new Object[0]));
        this.primitives = new ArrayList<IPrimitive>(primitives);
        this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(MainApplication.getMainFrame(), new Dimension(750, 550)));
        this.setButtonIcons("ok");
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab(I18n.tr("data", new Object[0]), InspectPrimitiveDialog.genericMonospacePanel(new JPanel(), InspectPrimitiveDialog.buildDataText(data, this.primitives)));
        JPanel pMapPaint = new JPanel();
        tabs.addTab(I18n.tr("map style", new Object[0]), pMapPaint);
        tabs.getModel().addChangeListener(e -> {
            if (!this.mappaintTabLoaded && ((SingleSelectionModel)e.getSource()).getSelectedIndex() == 1) {
                this.mappaintTabLoaded = true;
                InspectPrimitiveDialog.genericMonospacePanel(pMapPaint, InspectPrimitiveDialog.buildMapPaintText());
            }
        });
        JPanel pEditCounts = new JPanel();
        tabs.addTab(I18n.tr("edit counts", new Object[0]), pEditCounts);
        tabs.getModel().addChangeListener(e -> {
            if (!this.editcountTabLoaded && ((SingleSelectionModel)e.getSource()).getSelectedIndex() == 2) {
                this.editcountTabLoaded = true;
                InspectPrimitiveDialog.genericMonospacePanel(pEditCounts, InspectPrimitiveDialog.buildListOfEditorsText(primitives));
            }
        });
        this.setContent(tabs, false);
        this.configureContextsensitiveHelp("/Action/InfoAboutElements", true);
    }

    protected static JPanel genericMonospacePanel(JPanel p, String s) {
        p.setLayout(new GridBagLayout());
        JosmTextArea jte = new JosmTextArea();
        jte.setFont(GuiHelper.getMonospacedFont(jte));
        jte.setEditable(false);
        jte.append(s);
        jte.setCaretPosition(0);
        p.add((Component)new JScrollPane(jte), GBC.std().fill());
        return p;
    }

    protected static String buildDataText(OsmData<?, ?, ?, ?> data, List<IPrimitive> primitives) {
        InspectPrimitiveDataText dt = new InspectPrimitiveDataText(data);
        primitives.stream().sorted(PrimitiveComparator.orderingWaysRelationsNodes().thenComparing(PrimitiveComparator.comparingNames())).forEachOrdered(dt::addPrimitive);
        return dt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String buildMapPaintText() {
        Collection<?> sel = MainApplication.getLayerManager().getActiveData().getAllSelected();
        ElemStyles elemstyles = MapPaintStyles.getStyles();
        MapView nc = MainApplication.getMap().mapView;
        double scale = nc.getDist100Pixel();
        StringWriter stringWriter = new StringWriter();
        PrintWriter txtMappaint = new PrintWriter(stringWriter);
        MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
        try {
            for (IPrimitive osm : sel) {
                String heading = I18n.tr("Styles for \"{0}\":", osm.getDisplayName(DefaultNameFormatter.getInstance()));
                txtMappaint.println(heading);
                txtMappaint.println(InspectPrimitiveDialog.repeatString("=", heading.length()));
                MultiCascade mc = new MultiCascade();
                for (StyleSource s : elemstyles.getStyleSources()) {
                    if (!s.active) continue;
                    heading = I18n.tr("{0} style \"{1}\"", InspectPrimitiveDialog.getSort(s), s.getDisplayString());
                    txtMappaint.println(heading);
                    txtMappaint.println(InspectPrimitiveDialog.repeatString("-", heading.length()));
                    s.apply(mc, osm, scale, false);
                    txtMappaint.println(I18n.tr("Display range: {0}", mc.range));
                    for (Map.Entry<String, Cascade> e : mc.getLayers()) {
                        txtMappaint.println(I18n.tr("Layer {0}", e.getKey()));
                        txtMappaint.print(" * ");
                        txtMappaint.println(e.getValue());
                    }
                }
                txtMappaint.println();
                heading = I18n.tr("List of generated Styles:", new Object[0]);
                txtMappaint.println(heading);
                txtMappaint.println(InspectPrimitiveDialog.repeatString("-", heading.length()));
                StyleElementList sl = elemstyles.get(osm, scale, nc);
                for (StyleElement s : sl) {
                    txtMappaint.print(" * ");
                    txtMappaint.println(s);
                }
                txtMappaint.println();
                txtMappaint.println();
            }
        }
        finally {
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
        }
        if (sel.size() == 2) {
            StyleCache sc2;
            ArrayList selList = new ArrayList(sel);
            StyleCache sc1 = ((IPrimitive)selList.get(0)).getCachedStyle();
            if (sc1 == (sc2 = ((IPrimitive)selList.get(1)).getCachedStyle())) {
                txtMappaint.println(I18n.tr("The 2 selected objects have identical style caches.", new Object[0]));
            }
            if (!sc1.equals(sc2)) {
                txtMappaint.println(I18n.tr("The 2 selected objects have different style caches.", new Object[0]));
            }
            if (sc1 != sc2 && sc1.equals(sc2)) {
                txtMappaint.println(I18n.tr("Warning: The 2 selected objects have equal, but not identical style caches.", new Object[0]));
            }
        }
        return stringWriter.toString();
    }

    private static String repeatString(String string, int count) {
        return new String(new char[count]).replace("\u0000", string);
    }

    protected static String buildListOfEditorsText(Collection<? extends IPrimitive> primitives) {
        Map editCountByUser = primitives.stream().map(IPrimitive::getUser).filter(Objects::nonNull).collect(Collectors.groupingBy(User::getName, () -> new TreeMap(Collator.getInstance(Locale.getDefault())), Collectors.counting()));
        StringBuilder s = new StringBuilder(48).append(I18n.trn("{0} user last edited the selection:", "{0} users last edited the selection:", editCountByUser.size(), editCountByUser.size())).append("\n\n");
        editCountByUser.forEach((username, editCount) -> s.append(String.format("%6d  %s", editCount, username)).append('\n'));
        return s.toString();
    }

    private static String getSort(StyleSource s) {
        if (s instanceof MapCSSStyleSource) {
            return "MapCSS";
        }
        return I18n.tr("UNKNOWN", new Object[0]);
    }
}

