/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.sourceMap;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.inline.util.RelativePathCalculator;

public class SourceFilePathResolver {
    @NotNull
    private final Set<File> sourceRoots;
    @Nullable
    private final RelativePathCalculator outputDirPathResolver;
    @NotNull
    private final Map<File, String> cache;

    public SourceFilePathResolver(@NotNull List<File> sourceRoots) {
        if (sourceRoots == null) {
            SourceFilePathResolver.$$$reportNull$$$1(0);
        }
        if (sourceRoots == null) {
            SourceFilePathResolver.$$$reportNull$$$0(0);
        }
        this(sourceRoots, null);
    }

    public SourceFilePathResolver(@NotNull List<File> sourceRoots, @Nullable File outputDir2) {
        if (sourceRoots == null) {
            SourceFilePathResolver.$$$reportNull$$$1(1);
        }
        if (sourceRoots == null) {
            SourceFilePathResolver.$$$reportNull$$$0(1);
        }
        this.cache = new HashMap<File, String>();
        this.sourceRoots = new HashSet<File>();
        for (File sourceRoot : sourceRoots) {
            this.sourceRoots.add(sourceRoot.getAbsoluteFile());
        }
        this.outputDirPathResolver = outputDir2 != null ? new RelativePathCalculator(outputDir2) : null;
    }

    @NotNull
    public String getPathRelativeToSourceRoots(@NotNull File file2) throws IOException {
        String path2;
        if (file2 == null) {
            SourceFilePathResolver.$$$reportNull$$$1(2);
        }
        if (file2 == null) {
            SourceFilePathResolver.$$$reportNull$$$0(2);
        }
        if ((path2 = this.cache.get(file2)) == null) {
            path2 = this.calculatePathRelativeToSourceRoots(file2);
            this.cache.put(file2, path2);
        }
        String string2 = path2;
        if (string2 == null) {
            SourceFilePathResolver.$$$reportNull$$$0(3);
        }
        if (string2 == null) {
            SourceFilePathResolver.$$$reportNull$$$1(3);
        }
        return string2;
    }

    @NotNull
    private String calculatePathRelativeToSourceRoots(@NotNull File file2) throws IOException {
        String pathRelativeToOutput;
        if (file2 == null) {
            SourceFilePathResolver.$$$reportNull$$$1(4);
        }
        if (file2 == null) {
            SourceFilePathResolver.$$$reportNull$$$0(4);
        }
        if ((pathRelativeToOutput = this.calculatePathRelativeToOutput(file2)) != null) {
            String string2 = pathRelativeToOutput;
            if (string2 == null) {
                SourceFilePathResolver.$$$reportNull$$$0(5);
            }
            if (string2 == null) {
                SourceFilePathResolver.$$$reportNull$$$1(5);
            }
            return string2;
        }
        ArrayList<String> parts2 = new ArrayList<String>();
        for (File currentFile = file2.getCanonicalFile(); currentFile != null; currentFile = currentFile.getParentFile()) {
            if (this.sourceRoots.contains(currentFile)) {
                if (parts2.isEmpty()) break;
                Collections.reverse(parts2);
                String string3 = StringUtil.join(parts2, File.separator);
                if (string3 == null) {
                    SourceFilePathResolver.$$$reportNull$$$0(6);
                }
                if (string3 == null) {
                    SourceFilePathResolver.$$$reportNull$$$1(6);
                }
                return string3;
            }
            parts2.add(currentFile.getName());
        }
        String string4 = file2.getName();
        if (string4 == null) {
            SourceFilePathResolver.$$$reportNull$$$0(7);
        }
        if (string4 == null) {
            SourceFilePathResolver.$$$reportNull$$$1(7);
        }
        return string4;
    }

    @Nullable
    private String calculatePathRelativeToOutput(@NotNull File file2) {
        if (file2 == null) {
            SourceFilePathResolver.$$$reportNull$$$1(8);
        }
        if (file2 == null) {
            SourceFilePathResolver.$$$reportNull$$$0(8);
        }
        return this.outputDirPathResolver != null ? this.outputDirPathResolver.calculateRelativePathTo(file2) : null;
    }

    @NotNull
    public static SourceFilePathResolver create(@NotNull JsConfig config) {
        if (config == null) {
            SourceFilePathResolver.$$$reportNull$$$1(9);
        }
        if (config == null) {
            SourceFilePathResolver.$$$reportNull$$$0(9);
        }
        List<File> sourceRoots = config.getSourceMapRoots().stream().map(File::new).collect(Collectors.toList());
        File outputDir2 = null;
        if (config.shouldGenerateRelativePathsInSourceMap()) {
            outputDir2 = config.getConfiguration().get(JSConfigurationKeys.OUTPUT_DIR);
        }
        return new SourceFilePathResolver(sourceRoots, outputDir2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathRelativeToSourceRoots";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePathRelativeToSourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeToSourceRoots";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calculatePathRelativeToSourceRoots";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calculatePathRelativeToOutput";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathRelativeToSourceRoots";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePathRelativeToSourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeToSourceRoots";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calculatePathRelativeToSourceRoots";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calculatePathRelativeToOutput";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

