"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const Permalinks_1 = require("./Permalinks");
const __1 = require("..");
/**
 * Represents a system for generating a mention pill for an entity.
 * @category Utilities
 */
class MentionPill {
    constructor(entityPermalink, displayName) {
        this.entityPermalink = entityPermalink;
        this.displayName = displayName;
    }
    /**
     * The HTML component of the mention.
     */
    get html() {
        return `<a href="${this.entityPermalink}">${this.displayName}</a>`;
    }
    /**
     * The plain text component of the mention.
     */
    get text() {
        return this.displayName;
    }
    /**
     * Creates a new mention for a user in an optional room.
     * @param {string} userId The user ID the mention is for.
     * @param {String} inRoomId Optional room ID the user is being mentioned in, for the aesthetics of the mention.
     * @param {MatrixClient} client Optional client for creating a more pleasing mention.
     * @returns {Promise<MentionPill>} Resolves to the user's mention.
     */
    static forUser(userId, inRoomId = null, client = null) {
        return __awaiter(this, void 0, void 0, function* () {
            const permalink = Permalinks_1.Permalinks.forUser(userId);
            let displayName = userId;
            try {
                if (client) {
                    let profile = null;
                    if (inRoomId) {
                        profile = yield client.getRoomStateEvent(inRoomId, "m.room.member", userId);
                    }
                    if (!profile) {
                        profile = yield client.getUserProfile(userId);
                    }
                    if (profile['displayname']) {
                        displayName = profile['displayname'];
                    }
                }
            }
            catch (e) {
                __1.LogService.warn("MentionPill", "Error getting profile", e);
            }
            return new MentionPill(permalink, displayName);
        });
    }
    /**
     * Creates a mention from static information.
     * @param {string} userId The user ID the mention is for.
     * @param {string} displayName The user's display name.
     * @returns {MentionPill} The mention for the user.
     */
    static withDisplayName(userId, displayName) {
        return new MentionPill(Permalinks_1.Permalinks.forUser(userId), displayName || userId);
    }
}
exports.MentionPill = MentionPill;
