/*
 * Decompiled with CFR 0.152.
 */
import java.net.InetAddress;
import net.posick.mDNS.Lookup;
import net.posick.mDNS.MulticastDNSService;
import net.posick.mDNS.ServiceInstance;
import net.posick.mDNS.ServiceName;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;

public class Tester {
    public static void main(String[] args2) {
        int priority = 10;
        int weight = 10;
        int port = 8080;
        String ucn = "urn:smpte:ucn:org.smpte.st2071:device_v1.0";
        String ucnPTRName = "_org.smpte.st2071:device_v1.0._sub._mdc._tcp";
        String domain = "local.";
        String hostname = "TestHost";
        try {
            MulticastDNSService service = new MulticastDNSService();
            Name fqn = new Name(hostname + "." + (domain.endsWith(".") ? domain : domain + "."));
            ServiceName srvName = new ServiceName(hostname + "." + ucnPTRName + "." + (domain.endsWith(".") ? domain : domain + "."));
            ServiceInstance serviceInstance = new ServiceInstance(srvName, priority, weight, port, fqn, new InetAddress[]{InetAddress.getByName("192.168.1.74")}, "textvers=1", "rn=urn:smpte:udn:local:id=1234567890ABCDEF", "proto=mdcp", "path=/Device");
            ServiceInstance registeredService = service.register(serviceInstance);
            if (registeredService != null) {
                System.out.println("Services Successfully Registered: \n\t" + registeredService);
            } else {
                boolean hostnameResolves = false;
                Lookup lookup2 = new Lookup(fqn);
                Record[] rrs = lookup2.lookupRecords();
                if (rrs != null && rrs.length > 0) {
                    block5: for (Record rr : rrs) {
                        switch (rr.getType()) {
                            case 1: 
                            case 5: 
                            case 12: 
                            case 28: 
                            case 38: 
                            case 39: {
                                if (rr.getName().equals(fqn)) {
                                    hostnameResolves = true;
                                    break block5;
                                }
                            }
                            default: {
                                continue block5;
                            }
                        }
                    }
                }
                System.err.println("Services Registration for UCN \"" + ucn + "\" in domain \"" + domain + "\" Failed!");
                if (hostnameResolves) {
                    System.err.println("Hostname \"" + fqn + "\" can be resolved.");
                } else {
                    System.err.println("Hostname \"" + fqn + "\" cannot be resolved!");
                }
            }
            do {
                Thread.sleep(10L);
            } while (System.in.read() != 113);
            if (service.unregister(registeredService)) {
                System.out.println("Services Successfully Unregistered: \n\t" + registeredService);
            } else {
                System.err.println("Services was not Unregistered: \n\t" + registeredService);
            }
            service.close();
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println("Error Registering Capability \"" + ucn + "\" for Discovery - " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }
}

