/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Section;
import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.events.TileEvent;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.GradientLookup;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.tools.MovingAverage;
import eu.hansolo.tilesfx.tools.NiceScale;
import eu.hansolo.tilesfx.tools.Point;
import eu.hansolo.tilesfx.tools.Statistics;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.concurrent.Task;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class GaugeSparkLineTileSkin
extends TileSkin {
    private static final int SEC_MONTH = 2592000;
    private static final int SEC_DAY = 86400;
    private static final int SEC_HOUR = 3600;
    private static final int SEC_MINUTE = 60;
    private DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");
    private Text titleText;
    private Text valueText;
    private Text unitText;
    private TextFlow valueUnitFlow;
    private Text averageText;
    private Text text;
    private Text timeSpanText;
    private Rectangle graphBounds;
    private List<PathElement> pathElements;
    private Path sparkLine;
    private Circle dot;
    private Rectangle stdDeviationArea;
    private Line averageLine;
    private LinearGradient gradient;
    private GradientLookup gradientLookup;
    private Text minValueText;
    private Text maxValueText;
    private double low;
    private double high;
    private double lastLow;
    private double lastHigh;
    private double stdDeviation;
    private int noOfDatapoints;
    private List<Double> dataList;
    private MovingAverage movingAverage;
    private InvalidationListener averagingListener;
    private InvalidationListener highlightSectionListener;
    private NiceScale niceScaleY;
    private List<Line> horizontalTickLines;
    private double horizontalLineOffset;
    private double tickLabelFontSize;
    private List<Text> tickLabelsY;
    private Color tickLineColor;
    private Color tickLabelColor;
    private Canvas sectionCanvas;
    private GraphicsContext sectionCtx;
    private Canvas highlightSectionCanvas;
    private GraphicsContext highlightSectionCtx;
    private Arc barBackground;
    private Arc bar;

    public GaugeSparkLineTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        int i;
        super.initGraphics();
        this.averagingListener = o -> this.handleEvents("AVERAGING_PERIOD");
        this.highlightSectionListener = o -> this.handleEvents("HIGHLIGHT_SECTIONS");
        this.timeFormatter = DateTimeFormatter.ofPattern("HH:mm", this.tile.getLocale());
        if (this.tile.isAutoScale()) {
            this.tile.calcAutoScale();
        }
        this.niceScaleY = new NiceScale(this.minValue, this.maxValue);
        this.niceScaleY.setMaxTicks(5.0);
        this.tickLineColor = Color.color(Tile.FOREGROUND.getRed(), Tile.FOREGROUND.getGreen(), Tile.FOREGROUND.getBlue(), 0.5);
        this.tickLabelColor = this.tile.getTickLabelColor();
        this.horizontalTickLines = new ArrayList<Line>(5);
        this.tickLabelsY = new ArrayList<Text>(5);
        for (i = 0; i < 5; ++i) {
            Line hLine = new Line(0.0, 0.0, 0.0, 0.0);
            hLine.getStrokeDashArray().addAll((Double[])new Double[]{1.0, 2.0});
            hLine.setStroke(Color.TRANSPARENT);
            this.horizontalTickLines.add(hLine);
            Text tickLabelY = new Text("");
            tickLabelY.setFill(Color.TRANSPARENT);
            this.tickLabelsY.add(tickLabelY);
        }
        this.gradientLookup = new GradientLookup(this.tile.getGradientStops());
        this.lastLow = this.low = this.maxValue;
        this.lastHigh = this.high = this.minValue;
        this.stdDeviation = 0.0;
        this.movingAverage = this.tile.getMovingAverage();
        this.noOfDatapoints = this.tile.getAveragingPeriod();
        this.dataList = new LinkedList<Double>();
        if (this.noOfDatapoints < 4) {
            throw new IllegalArgumentException("Please increase the averaging period to a value larger than 3.");
        }
        this.graphBounds = new Rectangle(12.5, 125.0, 225.0, 112.5);
        this.titleText = new Text(this.tile.getTitle());
        this.titleText.setFill(this.tile.getTitleColor());
        Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, this.tile.getValue()));
        this.valueText.setFill(this.tile.getValueColor());
        Helper.enableNode(this.valueText, this.tile.isValueVisible());
        this.unitText = new Text(this.tile.getUnit());
        this.unitText.setFill(this.tile.getUnitColor());
        Helper.enableNode(this.unitText, !this.tile.getUnit().isEmpty());
        this.valueUnitFlow = new TextFlow(this.valueText, this.unitText);
        this.valueUnitFlow.setTextAlignment(TextAlignment.CENTER);
        this.averageText = new Text(String.format(this.locale, this.formatString, this.tile.getAverage()));
        this.averageText.setFill(Tile.FOREGROUND);
        Helper.enableNode(this.averageText, this.tile.isAverageVisible());
        this.text = new Text(this.tile.getText());
        this.text.setTextOrigin(VPos.TOP);
        this.text.setFill(this.tile.getTextColor());
        this.timeSpanText = new Text("");
        this.timeSpanText.setTextOrigin(VPos.TOP);
        this.timeSpanText.setFill(this.tile.getTextColor());
        Helper.enableNode(this.timeSpanText, !this.tile.isTextVisible());
        this.stdDeviationArea = new Rectangle();
        Helper.enableNode(this.stdDeviationArea, this.tile.isAverageVisible());
        this.averageLine = new Line();
        this.averageLine.setStroke(Tile.FOREGROUND);
        this.averageLine.getStrokeDashArray().addAll((Double[])new Double[]{1.25, 1.25});
        Helper.enableNode(this.averageLine, this.tile.isAverageVisible());
        this.pathElements = new ArrayList<PathElement>(this.noOfDatapoints);
        this.pathElements.add(0, new MoveTo());
        for (i = 1; i < this.noOfDatapoints; ++i) {
            this.pathElements.add(i, new LineTo());
        }
        this.sparkLine = new Path();
        this.sparkLine.getElements().addAll((Collection<PathElement>)this.pathElements);
        this.sparkLine.setFill(null);
        this.sparkLine.setStroke(this.tile.getBarColor());
        this.sparkLine.setStrokeWidth(1.875);
        this.sparkLine.setStrokeLineCap(StrokeLineCap.ROUND);
        this.sparkLine.setStrokeLineJoin(StrokeLineJoin.ROUND);
        this.dot = new Circle();
        this.dot.setFill(this.tile.getBarColor());
        this.sectionCanvas = new Canvas(250.0, 250.0);
        this.sectionCtx = this.sectionCanvas.getGraphicsContext2D();
        this.highlightSectionCanvas = new Canvas(250.0, 250.0);
        this.highlightSectionCtx = this.sectionCanvas.getGraphicsContext2D();
        this.barBackground = new Arc(125.0, 125.0, 100.0, 100.0, this.tile.getStartAngle() - 45.0, this.tile.getAngleRange());
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke(this.tile.getBarBackgroundColor());
        this.barBackground.setStrokeWidth(31.25);
        this.barBackground.setStrokeLineCap(StrokeLineCap.BUTT);
        this.barBackground.setFill(null);
        this.bar = new Arc(125.0, 125.0, 100.0, 100.0, this.tile.getStartAngle() - 135.0, 0.0);
        this.bar.setType(ArcType.OPEN);
        this.bar.setStroke(this.tile.getBarColor());
        this.bar.setStrokeWidth(31.25);
        this.bar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.bar.setFill(null);
        this.minValueText = new Text();
        Helper.enableNode(this.minValueText, this.tile.getMinValueVisible());
        this.maxValueText = new Text();
        Helper.enableNode(this.maxValueText, this.tile.getMaxValueVisible());
        this.getPane().getChildren().addAll((Node[])new Node[]{this.sectionCanvas, this.highlightSectionCanvas, this.barBackground, this.bar, this.minValueText, this.maxValueText, this.titleText, this.valueUnitFlow, this.stdDeviationArea, this.averageLine, this.sparkLine, this.dot, this.averageText, this.timeSpanText, this.text});
        this.getPane().getChildren().addAll((Collection<Node>)this.horizontalTickLines);
        this.getPane().getChildren().addAll((Collection<Node>)this.tickLabelsY);
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.averagingPeriodProperty().addListener(this.averagingListener);
        this.tile.highlightSectionsProperty().addListener(this.highlightSectionListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if (TileEvent.EventType.VISIBILITY.name().equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode(this.text, this.tile.isTextVisible());
            Helper.enableNode(this.valueText, this.tile.isValueVisible());
            Helper.enableNode(this.valueUnitFlow, !this.tile.getUnit().isEmpty());
            Helper.enableNode(this.timeSpanText, !this.tile.isTextVisible());
            Helper.enableNode(this.averageLine, this.tile.isAverageVisible());
            Helper.enableNode(this.averageText, this.tile.isAverageVisible());
            Helper.enableNode(this.stdDeviationArea, this.tile.isAverageVisible());
            Helper.enableNode(this.minValueText, this.tile.getMinValueVisible());
            Helper.enableNode(this.maxValueText, this.tile.getMaxValueVisible());
            this.redraw();
        } else if (TileEvent.EventType.AVERAGING.name().equals(EVENT_TYPE)) {
            int i;
            this.noOfDatapoints = this.tile.getAveragingPeriod();
            if (this.noOfDatapoints < 4) {
                throw new IllegalArgumentException("Please increase the averaging period to a value larger than 3.");
            }
            for (i = 0; i < this.noOfDatapoints; ++i) {
                this.dataList.add(this.minValue);
            }
            this.pathElements.clear();
            this.pathElements.add(0, new MoveTo());
            for (i = 1; i < this.noOfDatapoints; ++i) {
                this.pathElements.add(i, new LineTo());
            }
            this.sparkLine.getElements().setAll((Collection<PathElement>)this.pathElements);
            this.redraw();
        } else if (TileEvent.EventType.HIGHLIGHT_SECTIONS.name().equals(EVENT_TYPE)) {
            boolean isHighlightSections = this.tile.isHighlightSections();
            this.sectionCanvas.setVisible(!isHighlightSections);
            this.sectionCanvas.setManaged(!isHighlightSections);
            this.highlightSectionCanvas.setVisible(isHighlightSections);
            this.highlightSectionCanvas.setManaged(isHighlightSections);
        } else if (TileEvent.EventType.CLEAR_DATA.name().equals(EVENT_TYPE)) {
            this.dataList.clear();
            this.handleCurrentValue(this.minValue);
        } else if (TileEvent.EventType.FINISHED.name().equals(EVENT_TYPE)) {
            double value = Helper.clamp(this.minValue, this.maxValue, this.tile.getValue());
            this.handleCurrentValue(value);
            this.updateSparkline(value);
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        this.setBar(VALUE);
        if (this.tile.isHighlightSections()) {
            this.drawHighLightSections(VALUE);
        }
    }

    private void updateSparkline(double VALUE) {
        this.addData(VALUE);
        double statisticsLow = Statistics.getMin(this.dataList);
        double statisticsHigh = Statistics.getMax(this.dataList);
        if (this.tile.isFixedYScale() || Helper.equals(this.low, this.high)) {
            this.low = this.minValue;
            this.high = this.maxValue;
        } else {
            this.low = statisticsLow;
            this.high = statisticsHigh;
        }
        this.range = this.high - this.low;
        double minX = this.graphBounds.getX();
        double maxX = minX + this.graphBounds.getWidth();
        double minY = this.graphBounds.getY();
        double maxY = minY + this.graphBounds.getHeight();
        if (this.tile.isFixedYScale()) {
            this.niceScaleY.setMinMax(this.minValue, this.maxValue);
        } else {
            this.niceScaleY.setMinMax(this.low, this.high);
        }
        double niceMinY = this.niceScaleY.getNiceMin();
        double niceMaxY = this.niceScaleY.getNiceMax();
        double rangeY = niceMaxY - niceMinY;
        double stepX = this.graphBounds.getWidth() / (double)(this.noOfDatapoints - 1);
        double stepY = this.graphBounds.getHeight() / this.range;
        int lineCountY = 0;
        double tickSpacingY = this.niceScaleY.getTickSpacing();
        double tickStepY = tickSpacingY * stepY;
        double tickStartY = maxY;
        this.horizontalTickLines.forEach(line -> line.setStroke(Color.TRANSPARENT));
        this.tickLabelsY.forEach(label -> label.setFill(Color.TRANSPARENT));
        this.horizontalLineOffset = 0.0;
        double y = tickStartY;
        while ((double)Math.round(y) > minY) {
            Line line2 = this.horizontalTickLines.get(lineCountY);
            Text label2 = this.tickLabelsY.get(lineCountY);
            if (rangeY <= 4.0) {
                label2.setText(String.format(this.locale, "%.1f", this.low + (double)lineCountY * tickSpacingY));
            } else {
                label2.setText(String.format(this.locale, "%.0f", this.low + (double)lineCountY * tickSpacingY));
            }
            label2.setY(y + this.graphBounds.getHeight() * 0.03);
            label2.setFill(this.tickLabelColor);
            this.horizontalLineOffset = Math.max(label2.getLayoutBounds().getWidth(), this.horizontalLineOffset);
            line2.setStartX(minX);
            line2.setStartY(y);
            line2.setEndY(y);
            line2.setStroke(this.tickLineColor);
            ++lineCountY;
            lineCountY = Helper.clamp(0, 4, lineCountY);
            y -= tickStepY;
        }
        if (this.tickLabelFontSize < 6.0) {
            this.horizontalLineOffset = 0.0;
        }
        this.horizontalTickLines.forEach(line -> line.setEndX(maxX - this.horizontalLineOffset));
        this.tickLabelsY.forEach(label -> label.setX(maxX - label.getLayoutBounds().getWidth() + this.size * 0.02));
        if (!this.dataList.isEmpty()) {
            if (this.tile.isSmoothing()) {
                this.smooth(this.dataList);
            } else {
                MoveTo begin = (MoveTo)this.pathElements.get(0);
                begin.setX(minX);
                begin.setY(maxY - (this.dataList.get(0) - this.low) * stepY);
                for (int i = 1; i < this.noOfDatapoints - 1; ++i) {
                    LineTo lineTo = (LineTo)this.pathElements.get(i);
                    lineTo.setX(minX + (double)i * stepX);
                    lineTo.setY(maxY - (this.dataList.get(i) - this.low) * stepY);
                }
                LineTo end = (LineTo)this.pathElements.get(this.noOfDatapoints - 1);
                end.setX(maxX);
                end.setY(maxY - (this.dataList.get(this.noOfDatapoints - 1) - this.low) * stepY);
                this.dot.setCenterX(maxX);
                this.dot.setCenterY(end.getY());
            }
            if (this.tile.isStrokeWithGradient()) {
                this.setupGradient();
                this.dot.setFill(this.gradient);
                this.sparkLine.setStroke(this.gradient);
            }
            double average = this.tile.getAverage();
            double averageY = Helper.clamp(minY, maxY, maxY - Math.abs(this.low - average) * stepY);
            this.averageLine.setStartX(minX);
            this.averageLine.setStartY(averageY);
            this.averageLine.setEndX(maxX);
            this.averageLine.setEndY(averageY);
            this.stdDeviationArea.setY(this.averageLine.getStartY() - this.stdDeviation * 0.5 * stepY);
            this.stdDeviationArea.setHeight(this.stdDeviation * stepY);
            this.averageText.setText(String.format(this.locale, this.formatString, average));
        }
        if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(VALUE));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        }
        if (!this.tile.isTextVisible() && null != this.movingAverage.getTimeSpan()) {
            this.timeSpanText.setText(this.createTimeSpanText());
            this.text.setText(this.timeFormatter.format(this.movingAverage.getLastEntry().getTimestampAsDateTime(this.tile.getZoneId())));
        }
        this.resizeDynamicText();
        this.lastLow = this.low;
        this.lastHigh = this.high;
    }

    private void setBar(double VALUE) {
        double barLength = 0.0;
        double barStart = 0.0;
        double min2 = this.tile.getMinValue();
        double max = this.tile.getMaxValue();
        double step = this.tile.getAngleStep();
        double clampedValue = Helper.clamp(min2, max, VALUE);
        if (this.tile.isStartFromZero()) {
            if ((VALUE > min2 || min2 < 0.0) && (VALUE < max || max > 0.0)) {
                if (max < 0.0) {
                    barStart = this.tile.getStartAngle() - 135.0 - this.tile.getAngleRange();
                    barLength = (max - clampedValue) * step;
                } else if (min2 > 0.0) {
                    barStart = this.tile.getStartAngle() - 135.0;
                    barLength = (min2 - clampedValue) * step;
                } else {
                    barStart = this.tile.getStartAngle() - 135.0 + min2 * step;
                    barLength = -clampedValue * step;
                }
            }
        } else {
            barStart = this.tile.getStartAngle() - 135.0;
            barLength = (min2 - clampedValue) * step;
        }
        this.bar.setStartAngle(barStart);
        this.bar.setLength(barLength);
        if (this.tile.getSectionsVisible() && !this.sections.isEmpty()) {
            this.bar.setStroke(this.tile.getBarColor());
            for (Section section : this.sections) {
                if (!section.contains(VALUE)) continue;
                this.bar.setStroke(section.getColor());
                break;
            }
        }
    }

    private void drawHighLightSections(double VALUE) {
        this.highlightSectionCtx.setLineCap(StrokeLineCap.BUTT);
        this.highlightSectionCtx.clearRect(0.0, 0.0, this.width, this.height);
        if (this.tile.getSectionsVisible() && !this.sections.isEmpty()) {
            double x = (this.width - this.size * 0.7) * 0.5;
            double y = (this.height - this.size * 0.7) * 0.5;
            double wh = this.size * 0.7;
            double minValue = this.tile.getMinValue();
            double maxValue = this.tile.getMaxValue();
            double angleStep = this.tile.getAngleStep();
            this.highlightSectionCtx.setLineWidth(this.size * 0.01);
            this.highlightSectionCtx.setLineCap(StrokeLineCap.BUTT);
            for (int i = 0; i < this.sections.size(); ++i) {
                Section section = (Section)this.sections.get(i);
                if (Double.compare(section.getStart(), maxValue) > 0 || Double.compare(section.getStop(), minValue) < 0) continue;
                double sectionStartAngle = Double.compare(section.getStart(), minValue) < 0 && Double.compare(section.getStop(), maxValue) < 0 ? 15.0 : (section.getStart() - minValue) * angleStep + 15.0;
                double sectionAngleExtend = Double.compare(section.getStop(), maxValue) > 0 ? (maxValue - section.getStart()) * angleStep : (Double.compare(section.getStart(), minValue) < 0 ? (section.getStop() - minValue) * this.tile.getAngleStep() : (section.getStop() - section.getStart()) * angleStep);
                this.highlightSectionCtx.save();
                this.highlightSectionCtx.setStroke(section.contains(VALUE) ? section.getColor() : section.getColor().darker().darker());
                this.highlightSectionCtx.strokeArc(x, y, wh, wh, -(120.0 + sectionStartAngle), -sectionAngleExtend, ArcType.OPEN);
                this.highlightSectionCtx.restore();
            }
        }
    }

    private void addData(double VALUE) {
        if (this.dataList.isEmpty()) {
            for (int i = 0; i < this.noOfDatapoints; ++i) {
                this.dataList.add(VALUE);
            }
        }
        if (this.dataList.size() <= this.noOfDatapoints) {
            Collections.rotate(this.dataList, -1);
            this.dataList.set(this.noOfDatapoints - 1, VALUE);
        } else {
            this.dataList.add(VALUE);
        }
        this.stdDeviation = Statistics.getStdDev(this.dataList);
    }

    private void setupGradient() {
        double loFactor = (this.low - this.minValue) / this.tile.getRange();
        double hiFactor = (this.high - this.minValue) / this.tile.getRange();
        Stop loStop = new Stop(loFactor, this.gradientLookup.getColorAt(loFactor));
        Stop hiStop = new Stop(hiFactor, this.gradientLookup.getColorAt(hiFactor));
        List<Stop> stopsInBetween = this.gradientLookup.getStopsBetween(loFactor, hiFactor);
        double range = hiFactor - loFactor;
        double factor = 1.0 / range;
        ArrayList<Stop> stops = new ArrayList<Stop>();
        stops.add(new Stop(0.0, loStop.getColor()));
        for (Stop stop : stopsInBetween) {
            stops.add(new Stop((stop.getOffset() - loFactor) * factor, stop.getColor()));
        }
        stops.add(new Stop(1.0, hiStop.getColor()));
        this.gradient = new LinearGradient(0.0, this.graphBounds.getY() + this.graphBounds.getHeight(), 0.0, this.graphBounds.getY(), false, CycleMethod.NO_CYCLE, stops);
    }

    private String createTimeSpanText() {
        long timeSpan = this.movingAverage.getTimeSpan().getEpochSecond();
        StringBuilder timeSpanBuilder = new StringBuilder(this.movingAverage.isFilling() ? "\u22a2 " : "\u2190 ");
        if (timeSpan > 2592000L) {
            int months = (int)(timeSpan / 2592000L);
            double days = timeSpan % 2592000L;
            timeSpanBuilder.append(months).append("M");
            if (days > 0.0) {
                timeSpanBuilder.append(String.format(Locale.US, "%.0f", days)).append("d");
            }
            timeSpanBuilder.append(" \u2192");
        } else if (timeSpan > 86400L) {
            int days = (int)(timeSpan / 86400L);
            double hours = (timeSpan - (long)(days * 86400)) / 3600L;
            timeSpanBuilder.append(days).append("d");
            if (hours > 0.0) {
                timeSpanBuilder.append(String.format(Locale.US, "%.0f", hours)).append("h");
            }
            timeSpanBuilder.append(" \u2192");
        } else if (timeSpan > 3600L) {
            int hours = (int)(timeSpan / 3600L);
            double minutes = (timeSpan - (long)(hours * 3600)) / 60L;
            timeSpanBuilder.append(hours).append("h");
            if (minutes > 0.0) {
                timeSpanBuilder.append(String.format(Locale.US, "%.0f", minutes)).append("m");
            }
            timeSpanBuilder.append(" \u2192");
        } else if (timeSpan > 60L) {
            int minutes = (int)(timeSpan / 60L);
            double seconds = timeSpan - (long)(minutes * 60);
            timeSpanBuilder.append(minutes).append("m");
            if (seconds > 0.0) {
                timeSpanBuilder.append(String.format(Locale.US, "%.0f", seconds)).append("s");
            }
            timeSpanBuilder.append(" \u2192");
        } else {
            int seconds = (int)timeSpan;
            timeSpanBuilder.append(seconds).append("s").append(" \u2192");
        }
        return timeSpanBuilder.toString();
    }

    @Override
    public void dispose() {
        this.tile.averagingPeriodProperty().removeListener(this.averagingListener);
        this.tile.highlightSectionsProperty().removeListener(this.highlightSectionListener);
        super.dispose();
    }

    private void smooth(final List<Double> DATA_LIST) {
        Task<Point[]> smoothTask = new Task<Point[]>(){

            @Override
            protected Point[] call() {
                return Helper.smoothSparkLine(DATA_LIST, GaugeSparkLineTileSkin.this.minValue, GaugeSparkLineTileSkin.this.maxValue, GaugeSparkLineTileSkin.this.graphBounds, GaugeSparkLineTileSkin.this.noOfDatapoints);
            }
        };
        smoothTask.setOnSucceeded(t -> {
            Point[] smoothedPoints = (Point[])smoothTask.getValue();
            int lengthMinusOne = smoothedPoints.length - 1;
            this.sparkLine.getElements().clear();
            this.sparkLine.getElements().add(new MoveTo(smoothedPoints[0].getX(), smoothedPoints[0].getY()));
            for (int i = 1; i < lengthMinusOne; ++i) {
                this.sparkLine.getElements().add(new LineTo(smoothedPoints[i].getX(), smoothedPoints[i].getY()));
            }
            this.dot.setCenterX(smoothedPoints[lengthMinusOne].getX());
            this.dot.setCenterY(smoothedPoints[lengthMinusOne].getY());
        });
        Thread smoothThread = new Thread(smoothTask);
        smoothThread.setDaemon(true);
        smoothThread.start();
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.unitText.isVisible() ? this.width - this.size * 0.275 : this.width - this.size * 0.1;
        double fontSize = this.size * 0.12;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        maxWidth = this.width - this.size * 0.7;
        fontSize = this.size * 0.06;
        this.averageText.setFont(Fonts.latoRegular(fontSize));
        if (this.averageText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.averageText, maxWidth, fontSize);
        }
        if (this.averageLine.getStartY() < this.graphBounds.getY() + this.graphBounds.getHeight() * 0.5) {
            this.averageText.setY(this.averageLine.getStartY() + this.size * 0.0425);
        } else {
            this.averageText.setY(this.averageLine.getStartY() - this.size * 0.0075);
        }
        maxWidth = this.width - this.size * 0.25;
        fontSize = this.size * 0.06;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        this.text.relocate(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth(), this.height - this.size * 0.1);
        maxWidth = this.width - this.size * 0.25;
        fontSize = this.size * 0.06;
        this.timeSpanText.setFont(Fonts.latoRegular(fontSize));
        if (this.timeSpanText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.timeSpanText, maxWidth, fontSize);
        }
        this.timeSpanText.relocate((this.width - this.timeSpanText.getLayoutBounds().getWidth()) * 0.5, this.height - this.size * 0.1);
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        maxWidth = this.width - (this.width - this.size * 0.275);
        fontSize = this.size * 0.06;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.averageText.setX(this.size * 0.05);
        fontSize = this.size * 0.04;
        this.minValueText.setFont(Fonts.latoRegular(fontSize));
        this.minValueText.setText(String.format(this.locale, "%.0f", this.tile.getMinValue()));
        this.minValueText.setX(this.width * 0.5 - this.size * 0.2);
        this.minValueText.setY(this.height * 0.5 + this.size * 0.25);
        this.maxValueText.setFont(Fonts.latoRegular(fontSize));
        this.maxValueText.setText(String.format(this.locale, "%.0f", this.tile.getMaxValue()));
        this.maxValueText.setX(this.width * 0.5 + this.size * 0.2 - this.maxValueText.getLayoutBounds().getWidth());
        this.maxValueText.setY(this.height * 0.5 + this.size * 0.25);
    }

    private void drawBackground() {
        this.sectionCanvas.setCache(false);
        this.sectionCtx.setLineCap(StrokeLineCap.BUTT);
        this.sectionCtx.clearRect(0.0, 0.0, this.width, this.height);
        if (this.tile.getSectionsVisible() && !this.sections.isEmpty()) {
            double x = (this.width - this.size * 0.7) * 0.5;
            double y = (this.height - this.size * 0.7) * 0.5;
            double wh = this.size * 0.7;
            double minValue = this.tile.getMinValue();
            double maxValue = this.tile.getMaxValue();
            double angleStep = this.tile.getAngleStep();
            this.sectionCtx.setLineWidth(this.size * 0.01);
            this.sectionCtx.setLineCap(StrokeLineCap.BUTT);
            for (int i = 0; i < this.sections.size(); ++i) {
                Section section = (Section)this.sections.get(i);
                if (Double.compare(section.getStart(), maxValue) > 0 || Double.compare(section.getStop(), minValue) < 0) continue;
                double sectionStartAngle = Double.compare(section.getStart(), minValue) < 0 && Double.compare(section.getStop(), maxValue) < 0 ? 15.0 : (section.getStart() - minValue) * angleStep + 15.0;
                double sectionAngleExtend = Double.compare(section.getStop(), maxValue) > 0 ? (maxValue - section.getStart()) * angleStep : (Double.compare(section.getStart(), minValue) < 0 ? (section.getStop() - minValue) * this.tile.getAngleStep() : (section.getStop() - section.getStart()) * angleStep);
                this.sectionCtx.save();
                this.sectionCtx.setStroke(section.getColor());
                this.sectionCtx.strokeArc(x, y, wh, wh, -(120.0 + sectionStartAngle), -sectionAngleExtend, ArcType.OPEN);
                this.sectionCtx.restore();
            }
        }
        this.sectionCanvas.setCache(true);
        this.sectionCanvas.setCacheHint(CacheHint.QUALITY);
        this.barBackground.setStroke(this.tile.getBarBackgroundColor());
    }

    @Override
    protected void resize() {
        super.resize();
        this.graphBounds = new Rectangle((this.width - this.size * 0.35) * 0.5, (this.height - this.size * 0.35) * 0.5, this.size * 0.35, this.size * 0.35);
        this.lastLow = this.maxValue;
        this.lastHigh = this.minValue;
        this.tickLabelFontSize = this.graphBounds.getHeight() * 0.1;
        Font tickLabelFont = Fonts.latoRegular(this.tickLabelFontSize);
        this.tickLabelsY.forEach(label -> {
            Helper.enableNode(label, this.tickLabelFontSize >= 6.0);
            label.setFont(tickLabelFont);
        });
        this.horizontalTickLines.forEach(line -> line.setStrokeWidth(0.5));
        this.stdDeviationArea.setX(this.graphBounds.getX());
        this.stdDeviationArea.setWidth(this.graphBounds.getWidth());
        this.averageLine.getStrokeDashArray().setAll((Double[])new Double[]{this.graphBounds.getWidth() * 0.01, this.graphBounds.getWidth() * 0.01});
        this.low = Statistics.getMin(this.dataList);
        this.high = Statistics.getMax(this.dataList);
        if (Helper.equals(this.low, this.high)) {
            this.low = this.minValue;
            this.high = this.maxValue;
        }
        this.range = this.high - this.low;
        double minX = this.graphBounds.getX();
        double maxX = minX + this.graphBounds.getWidth();
        double minY = this.graphBounds.getY();
        double maxY = minY + this.graphBounds.getHeight();
        double stepX = this.graphBounds.getWidth() / (double)(this.noOfDatapoints - 1);
        double stepY = this.graphBounds.getHeight() / this.range;
        this.niceScaleY.setMinMax(this.low, this.high);
        int lineCountY = 0;
        int tickLabelOffsetY = 0;
        double tickSpacingY = this.niceScaleY.getTickSpacing();
        double tickStepY = tickSpacingY * stepY;
        if (tickSpacingY < this.low) {
            tickLabelOffsetY = (int)(this.low / tickSpacingY) + 1;
        }
        double tickStartY = maxY - ((double)tickLabelOffsetY * tickSpacingY - this.low) * stepY;
        double niceMinY = this.niceScaleY.getNiceMin();
        double niceMaxY = this.niceScaleY.getNiceMax();
        double rangeY = niceMaxY - niceMinY;
        this.horizontalTickLines.forEach(line -> line.setStroke(Color.TRANSPARENT));
        this.tickLabelsY.forEach(label -> label.setFill(Color.TRANSPARENT));
        this.horizontalLineOffset = 0.0;
        double y = tickStartY;
        while ((double)Math.round(y) > minY) {
            Line line2 = this.horizontalTickLines.get(lineCountY);
            Text label2 = this.tickLabelsY.get(lineCountY);
            if (rangeY <= 4.0) {
                label2.setText(String.format(this.locale, "%.1f", this.low + (double)lineCountY * tickSpacingY));
            } else {
                label2.setText(String.format(this.locale, "%.0f", this.low + (double)lineCountY * tickSpacingY));
            }
            label2.setY(y + this.graphBounds.getHeight() * 0.03);
            label2.setFill(this.tickLabelColor);
            this.horizontalLineOffset = Math.max(label2.getLayoutBounds().getWidth(), this.horizontalLineOffset);
            line2.setStartX(minX);
            line2.setStartY(y);
            line2.setEndY(y);
            line2.setStroke(this.tickLineColor);
            ++lineCountY;
            lineCountY = Helper.clamp(0, 4, lineCountY);
            y -= tickStepY;
        }
        if (this.tickLabelFontSize < 6.0) {
            this.horizontalLineOffset = 0.0;
        }
        this.horizontalTickLines.forEach(line -> line.setEndX(maxX - this.horizontalLineOffset));
        this.tickLabelsY.forEach(label -> label.setX(maxX - label.getLayoutBounds().getWidth() + this.size * 0.02));
        if (!this.dataList.isEmpty()) {
            if (this.tile.isSmoothing()) {
                this.smooth(this.dataList);
            } else {
                MoveTo begin = (MoveTo)this.pathElements.get(0);
                begin.setX(minX);
                begin.setY(maxY - Math.abs(this.low - this.dataList.get(0)) * stepY);
                for (int i = 1; i < this.noOfDatapoints - 1; ++i) {
                    LineTo lineTo = (LineTo)this.pathElements.get(i);
                    lineTo.setX(minX + (double)i * stepX);
                    lineTo.setY(maxY - Math.abs(this.low - this.dataList.get(i)) * stepY);
                }
                LineTo end = (LineTo)this.pathElements.get(this.noOfDatapoints - 1);
                end.setX(maxX);
                end.setY(maxY - Math.abs(this.low - this.dataList.get(this.noOfDatapoints - 1)) * stepY);
                this.dot.setCenterX(maxX);
                this.dot.setCenterY(end.getY());
            }
            if (this.tile.isStrokeWithGradient()) {
                this.setupGradient();
                this.dot.setFill(this.gradient);
                this.sparkLine.setStroke(this.gradient);
            }
            double average = this.tile.getAverage();
            double averageY = Helper.clamp(minY, maxY, maxY - Math.abs(this.low - average) * stepY);
            this.averageLine.setStartX(minX);
            this.averageLine.setStartY(averageY);
            this.averageLine.setEndX(maxX);
            this.averageLine.setEndY(averageY);
            this.stdDeviationArea.setY(this.averageLine.getStartY() - this.stdDeviation * 0.5 * stepY);
            this.stdDeviationArea.setHeight(this.stdDeviation * stepY);
            this.averageText.setText(String.format(this.locale, this.formatString, average));
        }
        if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(this.tile.getCurrentValue()));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, this.tile.getCurrentValue()));
        }
        if (!this.tile.isTextVisible() && null != this.movingAverage.getTimeSpan()) {
            this.timeSpanText.setText(this.createTimeSpanText());
            this.text.setText(this.timeFormatter.format(this.movingAverage.getLastEntry().getTimestampAsDateTime(this.tile.getZoneId())));
        }
        this.resizeDynamicText();
        this.lastLow = this.low;
        this.lastHigh = this.high;
        this.setBar(this.tile.getCurrentValue());
        if (this.tile.isHighlightSections()) {
            this.drawHighLightSections(this.tile.getCurrentValue());
        }
        if (this.tile.getAveragingPeriod() < 250) {
            this.sparkLine.setStrokeWidth(this.size * 0.005);
            this.dot.setRadius(this.size * 0.01);
        } else if (this.tile.getAveragingPeriod() < 500) {
            this.sparkLine.setStrokeWidth(this.size * 0.003);
            this.dot.setRadius(this.size * 0.0105);
        } else {
            this.sparkLine.setStrokeWidth(this.size * 0.002);
            this.dot.setRadius(this.size * 0.007);
        }
        if (this.tile.isStrokeWithGradient()) {
            this.setupGradient();
        }
        this.resizeStaticText();
        this.resizeDynamicText();
        this.valueUnitFlow.setPrefWidth(this.width - this.doubleInset);
        this.valueUnitFlow.relocate(this.inset, this.height * 0.5 + this.size * 0.25);
        this.sectionCanvas.setWidth(this.width);
        this.sectionCanvas.setHeight(this.height);
        this.highlightSectionCanvas.setWidth(this.width);
        this.highlightSectionCanvas.setHeight(this.height);
        this.barBackground.setCenterX(this.width * 0.5);
        this.barBackground.setCenterY(this.height * 0.5);
        this.barBackground.setRadiusX(this.size * 0.3);
        this.barBackground.setRadiusY(this.size * 0.3);
        this.barBackground.setStrokeWidth(this.size * 0.07);
        this.bar.setCenterX(this.width * 0.5);
        this.bar.setCenterY(this.height * 0.5);
        this.bar.setRadiusX(this.size * 0.3);
        this.bar.setRadiusY(this.size * 0.3);
        this.bar.setStrokeWidth(this.size * 0.07);
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.drawBackground();
        this.setBar(this.tile.getCurrentValue());
        this.titleText.setText(this.tile.getTitle());
        this.unitText.setText(this.tile.getUnit());
        if (!this.tile.getDescription().isEmpty()) {
            this.text.setText(this.tile.getDescription());
        }
        if (this.tile.isTextVisible()) {
            this.text.setText(this.tile.getText());
        } else if (!this.tile.isTextVisible() && null != this.movingAverage.getTimeSpan()) {
            this.timeSpanText.setText(this.createTimeSpanText());
            this.text.setText(this.timeFormatter.format(this.movingAverage.getLastEntry().getTimestampAsDateTime(this.tile.getZoneId())));
        }
        this.resizeStaticText();
        this.titleText.setFill(this.tile.getTitleColor());
        this.valueText.setFill(this.tile.getValueColor());
        this.text.setFill(this.tile.getTextColor());
        this.unitText.setFill(this.tile.getUnitColor());
        this.timeSpanText.setFill(this.tile.getTextColor());
        this.minValueText.setFill(this.tile.getTextColor());
        this.maxValueText.setFill(this.tile.getTextColor());
        if (this.tile.isStrokeWithGradient()) {
            this.setupGradient();
            this.sparkLine.setStroke(this.gradient);
        } else {
            this.sparkLine.setStroke(this.tile.getBarColor());
        }
        this.stdDeviationArea.setFill(Helper.getColorWithOpacity(Tile.FOREGROUND, 0.1));
        this.dot.setFill(this.tile.isStrokeWithGradient() ? this.gradient : this.tile.getBarColor());
    }
}

