/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.NoSuchElementException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mediathek.config.Daten;
import mediathek.filmlisten.FilmeLaden;
import mediathek.gui.actions.DisposeDialogAction;
import mediathek.gui.dialog.ButtonFlowPanel;
import mediathek.gui.dialog.ButtonPanel;
import mediathek.gui.dialogEinstellungen.PanelFilmlisteLaden;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.FilmListUpdateType;
import mediathek.tool.GuiFunktionen;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lmediathek/gui/dialog/LoadFilmListDialog;", "Ljavax/swing/JDialog;", "owner", "Ljava/awt/Frame;", "(Ljava/awt/Frame;)V", "btnContentPanel", "Lmediathek/gui/dialog/ButtonPanel;", "contentPanel", "Lmediathek/gui/dialogEinstellungen/PanelFilmlisteLaden;", "createButtonPanel", "", "registerWindowSizeListener", "restoreWindowSizeFromConfig", "MediathekView"})
public final class LoadFilmListDialog
extends JDialog {
    private final PanelFilmlisteLaden contentPanel;
    private final ButtonPanel btnContentPanel = new ButtonPanel();

    private final void createButtonPanel() {
        ButtonFlowPanel buttonFlowPanel = new ButtonFlowPanel();
        this.btnContentPanel.add((Component)buttonFlowPanel, "East");
        JButton closeBtn = new JButton(new DisposeDialogAction(this, "Schlie\u00dfen", "Dialog schlie\u00dfen"));
        buttonFlowPanel.add(closeBtn);
        JRootPane jRootPane = this.getRootPane();
        Intrinsics.checkNotNullExpressionValue(jRootPane, "getRootPane()");
        jRootPane.setDefaultButton(closeBtn);
        JButton btn = new JButton("Filmliste laden");
        btn.addActionListener(new ActionListener(this){
            final /* synthetic */ LoadFilmListDialog this$0;

            public final void actionPerformed(ActionEvent it) {
                Daten daten = Daten.getInstance();
                Intrinsics.checkNotNullExpressionValue(daten, "Daten.getInstance()");
                FilmeLaden filmeLaden = daten.getFilmeLaden();
                if (GuiFunktionen.getImportArtFilme() == FilmListUpdateType.AUTOMATIC) {
                    filmeLaden.loadFilmlist("", false);
                } else {
                    String strUrl;
                    JTextField jTextField = LoadFilmListDialog.access$getContentPanel$p(this.this$0).getJTextFieldUrl();
                    Intrinsics.checkNotNullExpressionValue(jTextField, "contentPanel.jTextFieldUrl");
                    String string = strUrl = jTextField.getText();
                    Intrinsics.checkNotNullExpressionValue(string, "strUrl");
                    if (StringsKt.contains((CharSequence)string, "mediathekview.de", true)) {
                        JOptionPane.showMessageDialog(this.this$0, "Bitte vermeiden Sie das Laden der Filmliste von unseren Servern \u00fcber eine manuell eingegebene URL.\n\nSie umgehen damit unter Umst\u00e4nden Mechanismen, die eine Lastverteilung auf unseren Servern erm\u00f6glichen\noder erhalten veraltete Dateien.\n\nNutzen Sie diese M\u00f6glichkeit NUR, wenn der regul\u00e4re Download OHNE manuelle Adresse nicht funktioniert.\nSie k\u00f6nnen sicher sein, dass wir einen Fehler schnellstm\u00f6glich beheben werden.", "MediathekView", 2);
                    }
                    JCheckBox jCheckBox = LoadFilmListDialog.access$getContentPanel$p(this.this$0).getJCheckBoxUpdate();
                    Intrinsics.checkNotNullExpressionValue(jCheckBox, "contentPanel.jCheckBoxUpdate");
                    if (jCheckBox.isSelected()) {
                        filmeLaden.updateFilmlist(strUrl);
                    } else {
                        filmeLaden.loadFilmlist(strUrl, false);
                    }
                }
                this.this$0.dispose();
            }
            {
                this.this$0 = loadFilmListDialog;
            }
        });
        buttonFlowPanel.add(btn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void restoreWindowSizeFromConfig() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.READ);
            int width = config.getInt("dialog.load_filmlist.width");
            int height = config.getInt("dialog.load_filmlist.height");
            int x = config.getInt("dialog.load_filmlist.x");
            int y = config.getInt("dialog.load_filmlist.y");
            this.setBounds(x, y, width, height);
        }
        catch (NoSuchElementException ignored) {
            this.pack();
            if (this.getWidth() < 100 || this.getHeight() < 100) {
                this.setSize(640, 480);
            }
            GuiFunktionen.centerOnScreen(this, false);
        }
        finally {
            config.unlock(LockMode.READ);
        }
    }

    private final void registerWindowSizeListener() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                this.storeWindowPosition(e);
            }

            public void componentMoved(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                this.storeWindowPosition(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void storeWindowPosition(ComponentEvent e) {
                Component component;
                Configuration config = ApplicationConfiguration.getConfiguration();
                Component component2 = component = e.getComponent();
                Intrinsics.checkNotNullExpressionValue(component2, "component");
                Dimension dims = component2.getSize();
                Point loc = component.getLocation();
                try {
                    config.lock(LockMode.WRITE);
                    config.setProperty("dialog.load_filmlist.width", dims.width);
                    config.setProperty("dialog.load_filmlist.height", dims.height);
                    config.setProperty("dialog.load_filmlist.x", loc.x);
                    config.setProperty("dialog.load_filmlist.y", loc.y);
                }
                finally {
                    config.unlock(LockMode.WRITE);
                }
            }
        });
    }

    public LoadFilmListDialog(@Nullable Frame owner) {
        super(owner, "Filmliste laden", true);
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        Intrinsics.checkNotNullExpressionValue(container, "contentPane");
        container.setLayout(new BorderLayout());
        this.contentPanel = new PanelFilmlisteLaden(false);
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.createButtonPanel();
        this.getContentPane().add((Component)this.btnContentPanel, "South");
        this.restoreWindowSizeFromConfig();
        this.registerWindowSizeListener();
        EscapeKeyHandler.installHandler(this, new Runnable(){

            @Override
            public final void run() {
                this.dispose();
            }
        });
    }

    public static final /* synthetic */ PanelFilmlisteLaden access$getContentPanel$p(LoadFilmListDialog $this) {
        return $this.contentPanel;
    }
}

