/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.notification;

import java.io.Closeable;
import java.io.IOException;
import java.net.Inet4Address;
import java.util.Arrays;
import javafx.application.Platform;
import mediathek.tool.javafx.FXErrorDialog;
import mediathek.tool.notification.INotificationCenter;
import mediathek.tool.notification.thrift.NotificationMessage;
import mediathek.tool.notification.thrift.ThriftNotificationCenter;
import net.posick.mDNS.Browse;
import net.posick.mDNS.DNSSDListener;
import net.posick.mDNS.MulticastDNSService;
import net.posick.mDNS.ServiceInstance;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.jetbrains.annotations.NotNull;
import org.xbill.DNS.Message;

public class MacNotificationCenter
implements INotificationCenter,
Closeable {
    private static final Logger logger = LogManager.getLogger();
    private static final String NOTIFICATION_SERVICE_NAME = "NotificationService";
    private static final String MV_NOTIFICATION_MDNS_NAME = "_mv-notification._tcp.local.";
    private TSocket transport;
    private TProtocol protocol;
    private TMultiplexedProtocol mp;
    private ThriftNotificationCenter.Client client;
    private MulticastDNSService service;

    public MacNotificationCenter() {
        this.setupJmdnsListener();
    }

    private void setupJmdnsListener() {
        try {
            this.service = new MulticastDNSService();
            this.service.startServiceDiscovery(new Browse(MV_NOTIFICATION_MDNS_NAME), new DNSSDListener(){

                @Override
                public void serviceDiscovered(Object id, ServiceInstance service) {
                    logger.trace("Notification Service Discovered");
                    Arrays.stream(service.getAddresses()).filter(a -> a instanceof Inet4Address).findAny().ifPresent(a -> {
                        MacNotificationCenter.this.cleanupThrift();
                        MacNotificationCenter.this.createThriftClient(a.getHostAddress(), service.getPort());
                    });
                }

                @Override
                public void serviceRemoved(Object id, ServiceInstance service) {
                    logger.trace("Notification Service Removed");
                    MacNotificationCenter.this.cleanupThrift();
                }

                @Override
                public void handleException(Object id, Exception e) {
                }

                @Override
                public void receiveMessage(Object id, Message message) {
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void cleanupThrift() {
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
        }
        this.transport = null;
        this.mp = null;
        this.client = null;
        this.protocol = null;
    }

    @Override
    public void displayNotification(NotificationMessage msg) {
        try {
            logger.trace("Sending native notification to {} on serverPort {}", (Object)this.transport.getSocket().getInetAddress(), (Object)this.transport.getSocket().getPort());
            this.client.displayNotification(msg);
        }
        catch (Exception e) {
            this.showErrorDialog(e);
        }
    }

    private void showErrorDialog(Exception ex) {
        Platform.runLater(() -> FXErrorDialog.showErrorDialog("MediathekView", "Native Benachrichtigungen k\u00f6nnen nicht angezeigt werden", "Bitte stellen Sie sicher das das Hilfsprogramm gestartet ist.", ex));
    }

    private void createThriftClient(@NotNull String addr, int port) {
        try {
            logger.trace("creating thrift client");
            this.transport = new TSocket(addr, port);
            this.transport.open();
            this.protocol = new TBinaryProtocol(this.transport);
            this.mp = new TMultiplexedProtocol(this.protocol, NOTIFICATION_SERVICE_NAME);
            this.client = new ThriftNotificationCenter.Client(this.mp);
        }
        catch (TException e) {
            logger.error("thrift client creation failed!", (Throwable)e);
            this.transport = null;
            this.mp = null;
            this.client = null;
            this.protocol = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.service != null) {
            this.service.close();
        }
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
        }
    }
}

